package models

import (
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
    ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e "github.com/microsoft/kiota-abstractions-go/store"
)

// WindowsMalwareOverview windows device malware overview.
type WindowsMalwareOverview struct {
    // Stores model information.
    backingStore ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore
}
// NewWindowsMalwareOverview instantiates a new windowsMalwareOverview and sets the default values.
func NewWindowsMalwareOverview()(*WindowsMalwareOverview) {
    m := &WindowsMalwareOverview{
    }
    m.backingStore = ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStoreFactoryInstance();
    m.SetAdditionalData(make(map[string]any))
    return m
}
// CreateWindowsMalwareOverviewFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
func CreateWindowsMalwareOverviewFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    return NewWindowsMalwareOverview(), nil
}
// GetAdditionalData gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
func (m *WindowsMalwareOverview) GetAdditionalData()(map[string]any) {
    val , err :=  m.backingStore.Get("additionalData")
    if err != nil {
        panic(err)
    }
    if val == nil {
        var value = make(map[string]any);
        m.SetAdditionalData(value);
    }
    return val.(map[string]any)
}
// GetBackingStore gets the backingStore property value. Stores model information.
func (m *WindowsMalwareOverview) GetBackingStore()(ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore) {
    return m.backingStore
}
// GetFieldDeserializers the deserialization information for the current model
func (m *WindowsMalwareOverview) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := make(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error))
    res["malwareCategorySummary"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateWindowsMalwareCategoryCountFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]WindowsMalwareCategoryCountable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(WindowsMalwareCategoryCountable)
                }
            }
            m.SetMalwareCategorySummary(res)
        }
        return nil
    }
    res["malwareDetectedDeviceCount"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt32Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetMalwareDetectedDeviceCount(val)
        }
        return nil
    }
    res["malwareExecutionStateSummary"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateWindowsMalwareExecutionStateCountFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]WindowsMalwareExecutionStateCountable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(WindowsMalwareExecutionStateCountable)
                }
            }
            m.SetMalwareExecutionStateSummary(res)
        }
        return nil
    }
    res["malwareNameSummary"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateWindowsMalwareNameCountFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]WindowsMalwareNameCountable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(WindowsMalwareNameCountable)
                }
            }
            m.SetMalwareNameSummary(res)
        }
        return nil
    }
    res["malwareSeveritySummary"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateWindowsMalwareSeverityCountFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]WindowsMalwareSeverityCountable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(WindowsMalwareSeverityCountable)
                }
            }
            m.SetMalwareSeveritySummary(res)
        }
        return nil
    }
    res["malwareStateSummary"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateWindowsMalwareStateCountFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]WindowsMalwareStateCountable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(WindowsMalwareStateCountable)
                }
            }
            m.SetMalwareStateSummary(res)
        }
        return nil
    }
    res["@odata.type"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetOdataType(val)
        }
        return nil
    }
    res["osVersionsSummary"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfObjectValues(CreateOsVersionCountFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]OsVersionCountable, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = v.(OsVersionCountable)
                }
            }
            m.SetOsVersionsSummary(res)
        }
        return nil
    }
    res["totalDistinctMalwareCount"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt32Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetTotalDistinctMalwareCount(val)
        }
        return nil
    }
    res["totalMalwareCount"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt32Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetTotalMalwareCount(val)
        }
        return nil
    }
    return res
}
// GetMalwareCategorySummary gets the malwareCategorySummary property value. List of device counts per malware category
func (m *WindowsMalwareOverview) GetMalwareCategorySummary()([]WindowsMalwareCategoryCountable) {
    val, err := m.GetBackingStore().Get("malwareCategorySummary")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]WindowsMalwareCategoryCountable)
    }
    return nil
}
// GetMalwareDetectedDeviceCount gets the malwareDetectedDeviceCount property value. Count of devices with malware detected in the last 30 days
func (m *WindowsMalwareOverview) GetMalwareDetectedDeviceCount()(*int32) {
    val, err := m.GetBackingStore().Get("malwareDetectedDeviceCount")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int32)
    }
    return nil
}
// GetMalwareExecutionStateSummary gets the malwareExecutionStateSummary property value. List of device counts per malware execution state
func (m *WindowsMalwareOverview) GetMalwareExecutionStateSummary()([]WindowsMalwareExecutionStateCountable) {
    val, err := m.GetBackingStore().Get("malwareExecutionStateSummary")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]WindowsMalwareExecutionStateCountable)
    }
    return nil
}
// GetMalwareNameSummary gets the malwareNameSummary property value. List of device counts per malware
func (m *WindowsMalwareOverview) GetMalwareNameSummary()([]WindowsMalwareNameCountable) {
    val, err := m.GetBackingStore().Get("malwareNameSummary")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]WindowsMalwareNameCountable)
    }
    return nil
}
// GetMalwareSeveritySummary gets the malwareSeveritySummary property value. List of active malware counts per malware severity
func (m *WindowsMalwareOverview) GetMalwareSeveritySummary()([]WindowsMalwareSeverityCountable) {
    val, err := m.GetBackingStore().Get("malwareSeveritySummary")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]WindowsMalwareSeverityCountable)
    }
    return nil
}
// GetMalwareStateSummary gets the malwareStateSummary property value. List of device counts per malware state
func (m *WindowsMalwareOverview) GetMalwareStateSummary()([]WindowsMalwareStateCountable) {
    val, err := m.GetBackingStore().Get("malwareStateSummary")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]WindowsMalwareStateCountable)
    }
    return nil
}
// GetOdataType gets the @odata.type property value. The OdataType property
func (m *WindowsMalwareOverview) GetOdataType()(*string) {
    val, err := m.GetBackingStore().Get("odataType")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetOsVersionsSummary gets the osVersionsSummary property value. List of device counts with malware per windows OS version
func (m *WindowsMalwareOverview) GetOsVersionsSummary()([]OsVersionCountable) {
    val, err := m.GetBackingStore().Get("osVersionsSummary")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]OsVersionCountable)
    }
    return nil
}
// GetTotalDistinctMalwareCount gets the totalDistinctMalwareCount property value. Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
func (m *WindowsMalwareOverview) GetTotalDistinctMalwareCount()(*int32) {
    val, err := m.GetBackingStore().Get("totalDistinctMalwareCount")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int32)
    }
    return nil
}
// GetTotalMalwareCount gets the totalMalwareCount property value. Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
func (m *WindowsMalwareOverview) GetTotalMalwareCount()(*int32) {
    val, err := m.GetBackingStore().Get("totalMalwareCount")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int32)
    }
    return nil
}
// Serialize serializes information the current object
func (m *WindowsMalwareOverview) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    if m.GetMalwareCategorySummary() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetMalwareCategorySummary()))
        for i, v := range m.GetMalwareCategorySummary() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err := writer.WriteCollectionOfObjectValues("malwareCategorySummary", cast)
        if err != nil {
            return err
        }
    }
    {
        err := writer.WriteInt32Value("malwareDetectedDeviceCount", m.GetMalwareDetectedDeviceCount())
        if err != nil {
            return err
        }
    }
    if m.GetMalwareExecutionStateSummary() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetMalwareExecutionStateSummary()))
        for i, v := range m.GetMalwareExecutionStateSummary() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err := writer.WriteCollectionOfObjectValues("malwareExecutionStateSummary", cast)
        if err != nil {
            return err
        }
    }
    if m.GetMalwareNameSummary() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetMalwareNameSummary()))
        for i, v := range m.GetMalwareNameSummary() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err := writer.WriteCollectionOfObjectValues("malwareNameSummary", cast)
        if err != nil {
            return err
        }
    }
    if m.GetMalwareSeveritySummary() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetMalwareSeveritySummary()))
        for i, v := range m.GetMalwareSeveritySummary() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err := writer.WriteCollectionOfObjectValues("malwareSeveritySummary", cast)
        if err != nil {
            return err
        }
    }
    if m.GetMalwareStateSummary() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetMalwareStateSummary()))
        for i, v := range m.GetMalwareStateSummary() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err := writer.WriteCollectionOfObjectValues("malwareStateSummary", cast)
        if err != nil {
            return err
        }
    }
    {
        err := writer.WriteStringValue("@odata.type", m.GetOdataType())
        if err != nil {
            return err
        }
    }
    if m.GetOsVersionsSummary() != nil {
        cast := make([]i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, len(m.GetOsVersionsSummary()))
        for i, v := range m.GetOsVersionsSummary() {
            if v != nil {
                cast[i] = v.(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable)
            }
        }
        err := writer.WriteCollectionOfObjectValues("osVersionsSummary", cast)
        if err != nil {
            return err
        }
    }
    {
        err := writer.WriteInt32Value("totalDistinctMalwareCount", m.GetTotalDistinctMalwareCount())
        if err != nil {
            return err
        }
    }
    {
        err := writer.WriteInt32Value("totalMalwareCount", m.GetTotalMalwareCount())
        if err != nil {
            return err
        }
    }
    {
        err := writer.WriteAdditionalData(m.GetAdditionalData())
        if err != nil {
            return err
        }
    }
    return nil
}
// SetAdditionalData sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
func (m *WindowsMalwareOverview) SetAdditionalData(value map[string]any)() {
    err := m.GetBackingStore().Set("additionalData", value)
    if err != nil {
        panic(err)
    }
}
// SetBackingStore sets the backingStore property value. Stores model information.
func (m *WindowsMalwareOverview) SetBackingStore(value ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore)() {
    m.backingStore = value
}
// SetMalwareCategorySummary sets the malwareCategorySummary property value. List of device counts per malware category
func (m *WindowsMalwareOverview) SetMalwareCategorySummary(value []WindowsMalwareCategoryCountable)() {
    err := m.GetBackingStore().Set("malwareCategorySummary", value)
    if err != nil {
        panic(err)
    }
}
// SetMalwareDetectedDeviceCount sets the malwareDetectedDeviceCount property value. Count of devices with malware detected in the last 30 days
func (m *WindowsMalwareOverview) SetMalwareDetectedDeviceCount(value *int32)() {
    err := m.GetBackingStore().Set("malwareDetectedDeviceCount", value)
    if err != nil {
        panic(err)
    }
}
// SetMalwareExecutionStateSummary sets the malwareExecutionStateSummary property value. List of device counts per malware execution state
func (m *WindowsMalwareOverview) SetMalwareExecutionStateSummary(value []WindowsMalwareExecutionStateCountable)() {
    err := m.GetBackingStore().Set("malwareExecutionStateSummary", value)
    if err != nil {
        panic(err)
    }
}
// SetMalwareNameSummary sets the malwareNameSummary property value. List of device counts per malware
func (m *WindowsMalwareOverview) SetMalwareNameSummary(value []WindowsMalwareNameCountable)() {
    err := m.GetBackingStore().Set("malwareNameSummary", value)
    if err != nil {
        panic(err)
    }
}
// SetMalwareSeveritySummary sets the malwareSeveritySummary property value. List of active malware counts per malware severity
func (m *WindowsMalwareOverview) SetMalwareSeveritySummary(value []WindowsMalwareSeverityCountable)() {
    err := m.GetBackingStore().Set("malwareSeveritySummary", value)
    if err != nil {
        panic(err)
    }
}
// SetMalwareStateSummary sets the malwareStateSummary property value. List of device counts per malware state
func (m *WindowsMalwareOverview) SetMalwareStateSummary(value []WindowsMalwareStateCountable)() {
    err := m.GetBackingStore().Set("malwareStateSummary", value)
    if err != nil {
        panic(err)
    }
}
// SetOdataType sets the @odata.type property value. The OdataType property
func (m *WindowsMalwareOverview) SetOdataType(value *string)() {
    err := m.GetBackingStore().Set("odataType", value)
    if err != nil {
        panic(err)
    }
}
// SetOsVersionsSummary sets the osVersionsSummary property value. List of device counts with malware per windows OS version
func (m *WindowsMalwareOverview) SetOsVersionsSummary(value []OsVersionCountable)() {
    err := m.GetBackingStore().Set("osVersionsSummary", value)
    if err != nil {
        panic(err)
    }
}
// SetTotalDistinctMalwareCount sets the totalDistinctMalwareCount property value. Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
func (m *WindowsMalwareOverview) SetTotalDistinctMalwareCount(value *int32)() {
    err := m.GetBackingStore().Set("totalDistinctMalwareCount", value)
    if err != nil {
        panic(err)
    }
}
// SetTotalMalwareCount sets the totalMalwareCount property value. Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
func (m *WindowsMalwareOverview) SetTotalMalwareCount(value *int32)() {
    err := m.GetBackingStore().Set("totalMalwareCount", value)
    if err != nil {
        panic(err)
    }
}
// WindowsMalwareOverviewable 
type WindowsMalwareOverviewable interface {
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.AdditionalDataHolder
    ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackedModel
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetBackingStore()(ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore)
    GetMalwareCategorySummary()([]WindowsMalwareCategoryCountable)
    GetMalwareDetectedDeviceCount()(*int32)
    GetMalwareExecutionStateSummary()([]WindowsMalwareExecutionStateCountable)
    GetMalwareNameSummary()([]WindowsMalwareNameCountable)
    GetMalwareSeveritySummary()([]WindowsMalwareSeverityCountable)
    GetMalwareStateSummary()([]WindowsMalwareStateCountable)
    GetOdataType()(*string)
    GetOsVersionsSummary()([]OsVersionCountable)
    GetTotalDistinctMalwareCount()(*int32)
    GetTotalMalwareCount()(*int32)
    SetBackingStore(value ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore)()
    SetMalwareCategorySummary(value []WindowsMalwareCategoryCountable)()
    SetMalwareDetectedDeviceCount(value *int32)()
    SetMalwareExecutionStateSummary(value []WindowsMalwareExecutionStateCountable)()
    SetMalwareNameSummary(value []WindowsMalwareNameCountable)()
    SetMalwareSeveritySummary(value []WindowsMalwareSeverityCountable)()
    SetMalwareStateSummary(value []WindowsMalwareStateCountable)()
    SetOdataType(value *string)()
    SetOsVersionsSummary(value []OsVersionCountable)()
    SetTotalDistinctMalwareCount(value *int32)()
    SetTotalMalwareCount(value *int32)()
}
