/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.platform.vcs.backend.split.VcsBackendSplitBundle;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.reactive.AddRemove;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/vcs/backend/split/BackendChangeListManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createChangeListFor", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "gate", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerGate;", "getChangeListName", "", "Companion", "intellij.platform.vcs.backend.split"})
public final class BackendChangeListManager
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public BackendChangeListManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        UserManager.Companion.getInstance(this.project).getUsers().adviseAddRemove(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> BackendChangeListManager._init_$lambda$0(this, arg_0, arg_1, arg_2));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final LocalChangeList createChangeListFor(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        String string = this.getChangeListName(clientId);
        if (string == null) {
            return null;
        }
        String listName = string;
        LocalChangeList localChangeList = changeListManager2.findChangeList(listName);
        if (localChangeList == null) {
            LocalChangeList localChangeList2 = changeListManager2.addChangeList(listName, null);
            localChangeList = localChangeList2;
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList2, (String)"addChangeList(...)");
        }
        return localChangeList;
    }

    @Nullable
    public final LocalChangeList createChangeListFor(@NotNull ClientId clientId, @NotNull ChangeListManagerGate gate) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)gate, (String)"gate");
        String string = this.getChangeListName(clientId);
        if (string == null) {
            return null;
        }
        String listName = string;
        LocalChangeList localChangeList = gate.findChangeList(listName);
        if (localChangeList == null) {
            LocalChangeList localChangeList2 = gate.addChangeList(listName, null);
            localChangeList = localChangeList2;
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList2, (String)"addChangeList(...)");
        }
        return localChangeList;
    }

    private final String getChangeListName(ClientId clientId) {
        Object object = ClientSessionsManager.Companion.getAppSession(clientId);
        if (object == null || (object = object.getName()) == null) {
            return null;
        }
        Object name = object;
        Object[] objectArray = new Object[]{name};
        return VcsBackendSplitBundle.INSTANCE.message("cwm.client.changelist.name", objectArray);
    }

    private static final Unit _init_$lambda$0(BackendChangeListManager this$0, AddRemove addRemove, int n, RdUserModel userModel) {
        Intrinsics.checkNotNullParameter((Object)addRemove, (String)"addRemove");
        Intrinsics.checkNotNullParameter((Object)userModel, (String)"userModel");
        if (addRemove == AddRemove.Remove) {
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this$0.project);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            String listName = this$0.getChangeListName(UserManagerKt.getClientId((RdUserModel)userModel));
            LocalChangeList localChangeList = changeListManager2.findChangeList(listName);
            if (localChangeList == null) {
                return Unit.INSTANCE;
            }
            LocalChangeList changeList = localChangeList;
            changeListManager2.scheduleAutomaticEmptyChangeListDeletion(changeList, true);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/vcs/backend/split/BackendChangeListManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/vcs/backend/split/BackendChangeListManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendActiveChangeListTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendActiveChangeListTracker.kt\ncom/intellij/platform/vcs/backend/split/BackendChangeListManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,244:1\n30#2,2:245\n*S KotlinDebug\n*F\n+ 1 BackendActiveChangeListTracker.kt\ncom/intellij/platform/vcs/backend/split/BackendChangeListManager$Companion\n*L\n39#1:245,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendChangeListManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<BackendChangeListManager> serviceClass$iv = BackendChangeListManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (BackendChangeListManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

