/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridStartupActivity;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridEditorPanel;
import com.intellij.database.datagrid.GridFilterAndSortingComponent;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelUtil;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.color.GridColorModel;
import com.intellij.database.datagrid.color.GridColorModelImpl;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.editor.DataGridColors;
import com.intellij.database.editor.TableFileEditorState;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.extractors.NumberDisplayType;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.actions.ChangeColumnDisplayTypeAction;
import com.intellij.database.run.actions.DeleteRowsAction;
import com.intellij.database.run.ui.ColumnModelModification;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.run.ui.FloatingPagingManager;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.database.run.ui.HiddenColumnsSelectionHolder;
import com.intellij.database.run.ui.ResultViewFactory;
import com.intellij.database.run.ui.ResultViewWithCells;
import com.intellij.database.run.ui.ResultViewWithColumns;
import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridCopyProvider;
import com.intellij.database.run.ui.grid.GridDataSupportImpl;
import com.intellij.database.run.ui.grid.GridFilterAndSortingComponentImpl;
import com.intellij.database.run.ui.grid.GridFilterPanel;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.grid.GridMarkupModelImpl;
import com.intellij.database.run.ui.grid.GridPasteProvider;
import com.intellij.database.run.ui.grid.GridRowComparator;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.table.FormatterConfigCache;
import com.intellij.database.run.ui.table.LocalFilterState;
import com.intellij.database.run.ui.table.TableResultRowHeader;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.find.FindModel;
import com.intellij.find.SearchSession;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.JBAutoScroller;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableResultPanel
extends UserDataHolderBase
implements DataGrid,
GridModel.Listener<GridRow, GridColumn>,
DataGridAppearance,
ColumnModelModification {
    private static final ColorKey HOVER_BACKGROUND = ColorKey.createColorKey((String)"Table.hoverBackground", (Color)JBUI.CurrentTheme.Table.Hover.background((boolean)true));
    private final String myUniqueId;
    private static final int RESULT_VIEW_COMPONENT_Z_INDEX = JLayeredPane.DEFAULT_LAYER;
    private static final int LOAD_DATA_Z_INDEX = JLayeredPane.MODAL_LAYER;
    private final Alarm alarm;
    private ErrorNotificationPanel myErrorNotificationPanel;
    private final GridMainPanel myMainPanel;
    private final LayeredPaneWithSizer myLayeredPane;
    private ResultView myResultView;
    private final ActionGroup myPopupActionGroup;
    protected final ActionGroup myGutterPopupActions;
    private final ActionGroup myColumnHeaderActions;
    private final ActionGroup myRowHeaderActions;
    private final GridColorsScheme myColorsScheme;
    private final GridColorsScheme myEditorColorsScheme;
    private final ColumnAttributes myColumnAttributes;
    private final Project myProject;
    private Function<DataGrid, ObjectFormatter> myObjectFormatterProvider;
    protected final GridFilterAndSortingComponent myFilterComponent;
    private final EventDispatcher<DataGridListener> myEventDispatcher;
    private final GridMarkupModel<GridRow, GridColumn> myMarkupModel;
    private final GridDataHookUp<GridRow, GridColumn> myDataHookUp;
    private final MyLoadDataPanel myLoadDataPanel;
    private JComponent myMainResultViewComponent;
    private final HiddenColumnsSelectionHolder myHiddenColumnSelectionHolder;
    private final JBAutoScroller.AutoscrollLocker myAutoscrollLocker;
    private GridColorModel myColorModel;
    private SearchSession mySearchSession;
    private GridPresentationMode myPresentationMode;
    private ResultViewFactory myViewFactory;
    private final ResultViewSettings myResultViewSettings;
    private DataGridAppearanceSettings.BooleanMode myBooleanMode;
    private final LocalFilterState myLocalFilterState;
    private final CoroutineScope cs;
    private final SimpleModificationTracker myModificationTracker;
    private final SimpleModificationTracker myColumnModificationTracker;
    private final CachedValue<Map<ModelIndex<GridColumn>, DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig>> myFormatterConfigCached;

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<GridRow, GridColumn> dataHookUp, @NotNull ActionGroup popupActions, @NotNull BiConsumer<DataGrid, DataGridAppearance> configurator) {
        if (project == null) {
            TableResultPanel.$$$reportNull$$$0(0);
        }
        if (dataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(1);
        }
        if (popupActions == null) {
            TableResultPanel.$$$reportNull$$$0(2);
        }
        if (configurator == null) {
            TableResultPanel.$$$reportNull$$$0(3);
        }
        this(project, dataHookUp, popupActions, null, GridUtil.getGridColumnHeaderPopupActions(), ActionGroup.EMPTY_GROUP, false, configurator);
    }

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<GridRow, GridColumn> dataHookUp, @NotNull ActionGroup popupActions, @Nullable ActionGroup gutterPopupActions, @NotNull ActionGroup columnHeaderActions, @NotNull ActionGroup rowHeaderActions, boolean useConsoleFonts, @NotNull BiConsumer<DataGrid, DataGridAppearance> configurator) {
        if (project == null) {
            TableResultPanel.$$$reportNull$$$0(4);
        }
        if (dataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(5);
        }
        if (popupActions == null) {
            TableResultPanel.$$$reportNull$$$0(6);
        }
        if (columnHeaderActions == null) {
            TableResultPanel.$$$reportNull$$$0(7);
        }
        if (rowHeaderActions == null) {
            TableResultPanel.$$$reportNull$$$0(8);
        }
        if (configurator == null) {
            TableResultPanel.$$$reportNull$$$0(9);
        }
        this.myUniqueId = UUID.randomUUID().toString();
        this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myObjectFormatterProvider = null;
        this.myEventDispatcher = EventDispatcher.create(DataGridListener.class);
        this.myPresentationMode = GridPresentationMode.TABLE;
        this.myResultViewSettings = new ResultViewSettings();
        this.myBooleanMode = DataGridAppearanceSettings.BooleanMode.TEXT;
        this.cs = CoroutineScopeKt.childScope((CoroutineScope)GlobalScope.INSTANCE, (String)this.getClass().getName(), (CoroutineContext)Dispatchers.getIO(), (boolean)true);
        this.myModificationTracker = new SimpleModificationTracker();
        this.myColumnModificationTracker = new SimpleModificationTracker();
        this.myProject = project;
        this.myPopupActionGroup = popupActions;
        this.myGutterPopupActions = gutterPopupActions;
        this.myColumnHeaderActions = columnHeaderActions;
        this.myRowHeaderActions = rowHeaderActions;
        this.myEditorColorsScheme = new GridColorsScheme(useConsoleFonts, null);
        this.myMarkupModel = new GridMarkupModelImpl<GridRow, GridColumn>();
        this.myHiddenColumnSelectionHolder = new HiddenColumnsSelectionHolder();
        this.myAutoscrollLocker = new JBAutoScroller.AutoscrollLocker();
        this.myDataHookUp = dataHookUp;
        this.myMainPanel = new GridMainPanel(this, sink -> this.uiDataSnapshot(sink));
        this.myColumnAttributes = new ColumnAttributes();
        this.myLocalFilterState = new LocalFilterState(this, true);
        configurator.accept(this, this);
        DataGridSettings settings = GridUtil.getSettings(this);
        boolean isEnableLocalFilterByDefault = settings == null || settings.isEnableLocalFilterByDefault();
        this.myLocalFilterState.setEnabled(this.myLocalFilterState.isEnabled() && isEnableLocalFilterByDefault);
        this.myFormatterConfigCached = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(FormatterConfigCache.getCacheValueProvider(this));
        this.myColorsScheme = new GridColorsScheme(useConsoleFonts, DataGridAppearanceSettings.getSettings());
        this.myFilterComponent = new GridFilterAndSortingComponentImpl(this.myProject, this);
        GridSortingModel sortingModel = this.myDataHookUp.getSortingModel();
        this.myFilterComponent.toggleSortingPanel(sortingModel != null && sortingModel.isSortingEnabled());
        this.myMainPanel.setLoadingText("");
        this.myLoadDataPanel = new MyLoadDataPanel(this);
        this.myLayeredPane = new LayeredPaneWithSizer();
        this.myMainPanel.setCenterComponent((JComponent)((Object)this.myLayeredPane));
        this.myMainPanel.addListener((JBLoadingPanelListener)new JBLoadingPanelListener.Adapter(){

            public void onLoadingStart() {
                DataGridStartupActivity.DataEditorConfigurator.disableLoadingDelay(TableResultPanel.this);
            }
        });
        this.myViewFactory = ResultViewFactory.of(this.myPresentationMode);
        this.createResultView();
        if (sortingModel != null) {
            sortingModel.addListener(new GridSortingModel.Listener(){

                public void orderingChanged() {
                    TableResultPanel.this.setOrderingFromModel();
                    TableResultPanel.this.updateSortKeysFromColumnAttributes();
                }
            }, (Disposable)this);
        }
        this.installDataHookUpListeners();
        this.columnsAdded((ModelIndexSet<GridColumn>)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnIndices());
        this.addDataGridListener((DataGridListener)this.myProject.getMessageBus().syncPublisher(DataGridListener.TOPIC), (Disposable)this);
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(DataGridAppearanceSettings.TOPIC, () -> {
            this.myColorsScheme.updateFromSettings(DataGridAppearanceSettings.getSettings());
            DataGridAppearanceSettings s = DataGridAppearanceSettings.getSettings();
            this.setBooleanMode(s.getBooleanMode());
            boolean striped = s.isStripedTable();
            this.setResultViewStriped(striped);
            if (!striped) {
                this.myResultView.setShowVerticalLines(true);
                this.myResultView.setShowHorizontalLines(this.myResultViewSettings.myShowHorizontalLines);
            }
            this.myResultView.reinitSettings();
        });
        connection.subscribe(EditorColorsManager.TOPIC, scheme -> {
            GridUtil.globalSchemeChange(this, scheme);
            this.myResultView.reinitSettings();
        });
        connection.subscribe(DataGridSettings.TOPIC, () -> this.updateFloatingPaging());
    }

    @Override
    @NotNull
    public String getUniqueId() {
        String string = this.myUniqueId;
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public void loadingDelayDisabled() {
        this.myLayeredPane.remove(this.myLoadDataPanel);
    }

    @Override
    public void loadingDelayed() {
        this.myLayeredPane.add(this.myLoadDataPanel);
        this.myLayeredPane.setLayer(this.myLoadDataPanel, LOAD_DATA_Z_INDEX);
    }

    @Override
    public void addResultViewMouseListener(@NotNull MouseListener listener) {
        if (listener == null) {
            TableResultPanel.$$$reportNull$$$0(11);
        }
        this.myResultViewSettings.myMouseListener = listener;
        this.myResultView.getComponent().addMouseListener(this.myResultViewSettings.myMouseListener);
    }

    @Override
    @NotNull
    public DataGridAppearance getAppearance() {
        TableResultPanel tableResultPanel = this;
        if (tableResultPanel == null) {
            TableResultPanel.$$$reportNull$$$0(12);
        }
        return tableResultPanel;
    }

    public void setResultViewVisibleRowCount(int v) {
        this.myResultViewSettings.myVisibleRowCount = v;
        if (this.myResultView != null) {
            this.myResultView.setVisibleRowCount(v);
        }
    }

    public void setResultViewShowRowNumbers(boolean v) {
        this.myResultViewSettings.myShowRowNumbers = v;
        if (this.myResultView != null) {
            this.myResultView.showRowNumbers(v);
        }
    }

    public void setTransparentColumnHeaderBackground(boolean v) {
        this.myResultViewSettings.myTransparentColumnHeaderBg = v;
        this.myColorModel = new GridColorModelImpl((DataGrid)this, GridUtil.getDatabaseMutator(this), this.myResultViewSettings.myTransparentRowHeaderBg, v);
        if (this.myResultView != null) {
            this.myResultView.setTransparentColumnHeaderBackground(v);
        }
    }

    public void setTransparentRowHeaderBackground(boolean v) {
        this.myResultViewSettings.myTransparentRowHeaderBg = v;
        this.myColorModel = new GridColorModelImpl((DataGrid)this, GridUtil.getDatabaseMutator(this), v, this.myResultViewSettings.myTransparentColumnHeaderBg);
    }

    public void setResultViewAdditionalRowsCount(int v) {
        this.myResultViewSettings.myAdditionalRowsCount = v;
        if (this.myResultView != null) {
            this.myResultView.setAdditionalRowsCount(v);
        }
    }

    public void setResultViewSetShowHorizontalLines(boolean v) {
        this.myResultViewSettings.myShowHorizontalLines = v;
        if (this.myResultView != null) {
            this.myResultView.setShowHorizontalLines(v);
        }
    }

    public void setResultViewStriped(boolean v) {
        this.myResultViewSettings.myStriped = v;
        if (this.myResultView != null) {
            this.myResultView.setStriped(v);
        }
    }

    public void addSpaceForHorizontalScrollbar(boolean v) {
        this.myResultViewSettings.myAddSpaceForHorizontalScrollbar = v;
        if (this.myResultView != null) {
            this.myResultView.addSpaceForHorizontalScrollbar(v);
        }
    }

    public void expandMultilineRows(boolean v) {
        this.myResultViewSettings.myExpandMultilineRows = v;
        if (this.myResultView != null) {
            this.myResultView.expandMultilineRows(v);
        }
    }

    public void setBooleanMode(@NotNull DataGridAppearanceSettings.BooleanMode v) {
        if (v == null) {
            TableResultPanel.$$$reportNull$$$0(13);
        }
        this.myBooleanMode = v;
    }

    @NotNull
    public DataGridAppearanceSettings.BooleanMode getBooleanMode() {
        DataGridAppearanceSettings.BooleanMode booleanMode = this.myBooleanMode;
        if (booleanMode == null) {
            TableResultPanel.$$$reportNull$$$0(14);
        }
        return booleanMode;
    }

    public void setResultViewAllowMultilineColumnLabels(boolean v) {
        this.myResultViewSettings.myAllowMultilineColumnLabels = v;
        if (this.myResultView != null) {
            this.myResultView.setAllowMultilineLabel(v);
        }
    }

    public void setHoveredRowBgHighlightingEnabled(boolean v) {
        ResultView.HoveredRowBgHighlightMode hoveredRowBgHighlightMode = this.myResultViewSettings.myHoveredRowBgHighlightMode = v ? ResultView.HoveredRowBgHighlightMode.HIGHLIGHT : ResultView.HoveredRowBgHighlightMode.NOT_HIGHLIGHT;
        if (this.myResultView != null) {
            this.myResultView.setHoveredRowHighlightMode(this.myResultViewSettings.myHoveredRowBgHighlightMode);
        }
    }

    public void setAnonymousColumnName(@NotNull String name) {
        if (name == null) {
            TableResultPanel.$$$reportNull$$$0(15);
        }
        this.myColumnAttributes.myAnonymousColumnName = name;
    }

    private void createResultView() {
        this.myResultView = this.myViewFactory.createResultView(this, this.myColumnHeaderActions, this.myRowHeaderActions);
        this.myColorModel = new GridColorModelImpl((DataGrid)this, GridUtil.getDatabaseMutator(this), this.myResultViewSettings.myTransparentRowHeaderBg, this.myResultViewSettings.myTransparentColumnHeaderBg);
        this.myMainResultViewComponent = this.myViewFactory.wrap(this, this.myResultView);
        this.myLayeredPane.add(this.myMainResultViewComponent);
        this.myLayeredPane.setLayer(this.myMainResultViewComponent, RESULT_VIEW_COMPONENT_Z_INDEX);
        if (FloatingPagingManager.shouldBePresent(this)) {
            FloatingPagingManager.installOn(this, this.myLayeredPane);
        }
        this.registerEscapeAction(this.myResultView);
        this.myResultView.addSelectionChangedListener(isAdjusting -> {
            ((DataGridListener)this.myEventDispatcher.getMulticaster()).onSelectionChanged(this, (boolean)isAdjusting);
            if (!isAdjusting.booleanValue()) {
                ApplicationManager.getApplication().invokeLater(() -> GridUtil.activeGridChanged(this));
            }
        });
        this.myResultView.addMouseListenerToComponents((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                if (!TableResultPanel.this.stopEditing()) {
                    TableResultPanel.this.cancelEditing();
                }
                if (TableResultPanel.this.myPopupActionGroup != ActionGroup.EMPTY_GROUP) {
                    ActionManager.getInstance().createActionPopupMenu("EditorPopup", TableResultPanel.this.myPopupActionGroup).getComponent().show(comp, x, y);
                }
            }
        });
        if (this.myResultViewSettings.myMouseListener != null) {
            this.myResultView.getComponent().addMouseListener(this.myResultViewSettings.myMouseListener);
        }
        if (this.myResultViewSettings.myVisibleRowCount > 0) {
            this.myResultView.setVisibleRowCount(this.myResultViewSettings.myVisibleRowCount);
        }
        this.myResultView.showRowNumbers(this.myResultViewSettings.myShowRowNumbers);
        this.myResultView.setTransparentColumnHeaderBackground(this.myResultViewSettings.myTransparentColumnHeaderBg);
        this.myResultView.setAdditionalRowsCount(this.myResultViewSettings.myAdditionalRowsCount);
        this.myResultView.setShowHorizontalLines(this.myResultViewSettings.myShowHorizontalLines);
        this.myResultView.setAllowMultilineLabel(this.myResultViewSettings.myAllowMultilineColumnLabels);
        this.myResultView.setStriped(this.myResultViewSettings.myStriped);
        this.myResultView.addSpaceForHorizontalScrollbar(this.myResultViewSettings.myAddSpaceForHorizontalScrollbar);
        this.myResultView.expandMultilineRows(this.myResultViewSettings.myExpandMultilineRows);
        this.myResultView.setHoveredRowHighlightMode(this.myResultViewSettings.myHoveredRowBgHighlightMode);
    }

    @Override
    @NotNull
    public GridColorModel getColorModel() {
        GridColorModel gridColorModel = this.myColorModel;
        if (gridColorModel == null) {
            TableResultPanel.$$$reportNull$$$0(16);
        }
        return gridColorModel;
    }

    @Override
    @NotNull
    public JBAutoScroller.AutoscrollLocker getAutoscrollLocker() {
        JBAutoScroller.AutoscrollLocker autoscrollLocker = this.myAutoscrollLocker;
        if (autoscrollLocker == null) {
            TableResultPanel.$$$reportNull$$$0(17);
        }
        return autoscrollLocker;
    }

    @Override
    public HiddenColumnsSelectionHolder getHiddenColumnSelectionHolder() {
        return this.myHiddenColumnSelectionHolder;
    }

    @Override
    @NotNull
    public GridRowHeader createRowHeader(@NotNull TableResultView table2) {
        if (table2 == null) {
            TableResultPanel.$$$reportNull$$$0(18);
        }
        return new TableResultRowHeader(this, table2, this.myGutterPopupActions);
    }

    public void installDataHookUpListeners() {
        this.myDataHookUp.addRequestListener((GridDataHookUp.RequestListener)new GridDataHookUp.RequestListener<GridRow, GridColumn>(){

            public void error(@NotNull GridRequestSource source, @NotNull ErrorInfo errorInfo) {
                GridRequestSource.GridRequestPlace gridRequestPlace;
                if (source == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (errorInfo == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((gridRequestPlace = (GridRequestSource.GridRequestPlace)ObjectUtils.tryCast((Object)source.place, GridRequestSource.GridRequestPlace.class)) == null || gridRequestPlace.getGrid() != TableResultPanel.this) {
                    return;
                }
                TableResultPanel.this.handleError(source, errorInfo);
            }

            public void updateCountReceived(@NotNull GridRequestSource source, int updateCount) {
                if (source == null) {
                    4.$$$reportNull$$$0(2);
                }
            }

            public void requestFinished(@NotNull GridRequestSource source, boolean success) {
                if (source == null) {
                    4.$$$reportNull$$$0(3);
                }
                this.doRepaint(source);
                GridRequestSource.GridRequestPlace gridRequestPlace = (GridRequestSource.GridRequestPlace)ObjectUtils.tryCast((Object)source.place, GridRequestSource.GridRequestPlace.class);
                if (gridRequestPlace == null || gridRequestPlace.getGrid() != TableResultPanel.this) {
                    return;
                }
                if (!source.errorOccurred()) {
                    TableResultPanel.this.hideErrorPanel();
                }
            }

            private void doRepaint(@NotNull GridRequestSource source) {
                Component rowHeader;
                if (source == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (!source.isMutatedDataLocally()) {
                    return;
                }
                TableResultPanel.this.myResultView.getComponent().repaint(50L);
                JViewport header = TableResultPanel.this.myMainResultViewComponent instanceof JScrollPane ? ((JScrollPane)TableResultPanel.this.myMainResultViewComponent).getRowHeader() : null;
                Component component = rowHeader = header == null ? null : header.getView();
                if (rowHeader != null) {
                    rowHeader.repaint(50L);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorInfo";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateCountReceived";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestFinished";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doRepaint";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).addListener((GridModel.Listener)this, (Disposable)this);
    }

    public void columnsAdded(ModelIndexSet<GridColumn> columnIndices) {
        this.myColumnAttributes.newColumns(this, this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumns());
        this.setOrderingFromModel();
        this.updateSortKeysFromColumnAttributes();
        this.myResultView.columnsAdded(columnIndices);
        this.trueLayout();
        this.restoreColumnsOrder();
        this.myColumnModificationTracker.incModificationCount();
    }

    protected void columnAttributesUpdated() {
        this.myResultView.columnAttributesUpdated();
        this.restoreColumnsOrder();
    }

    public void restoreColumnsOrder() {
        LinkedHashMap<Integer, ModelIndex<GridColumn>> expectedToModel = new LinkedHashMap<Integer, ModelIndex<GridColumn>>();
        GridModel<GridRow, GridColumn> model2 = this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        JBIterable modelIndices = model2.getColumnIndices().asIterable();
        for (ModelIndex modelIndex : modelIndices) {
            GridColumn column = (GridColumn)model2.getColumn(modelIndex);
            if (column == null) {
                return;
            }
            int initialPosition = this.getInitialPosition(column);
            if (initialPosition == 0) {
                return;
            }
            initialPosition = initialPosition == -1 ? modelIndex.value : TableFileEditorState.fromSerializedPosition(initialPosition);
            expectedToModel.put(initialPosition, (ModelIndex<GridColumn>)modelIndex);
        }
        this.myResultView.restoreColumnsOrder(expectedToModel);
    }

    public void columnsRemoved(ModelIndexSet<GridColumn> columns) {
        this.myResultView.columnsRemoved(columns);
        this.trueLayout();
        this.myColumnModificationTracker.incModificationCount();
    }

    public void rowsAdded(ModelIndexSet<GridRow> rows) {
        this.myResultView.rowsAdded(rows);
        ActivityTracker.getInstance().inc();
        this.trueLayout();
    }

    public void afterLastRowAdded() {
        this.clearAllColumnsDisplayTypesAllowableCache();
        this.myResultView.afterLastRowAdded();
        ActivityTracker.getInstance().inc();
    }

    @Override
    public void fireValueEdited(@Nullable Object object) {
        ((DataGridListener)this.myEventDispatcher.getMulticaster()).onValueEdited(this, object);
    }

    @Override
    @NotNull
    public ResultView getResultView() {
        ResultView resultView = this.myResultView;
        if (resultView == null) {
            TableResultPanel.$$$reportNull$$$0(19);
        }
        return resultView;
    }

    public void rowsRemoved(ModelIndexSet<GridRow> rows) {
        this.myResultView.rowsRemoved(rows);
        this.trueLayout();
    }

    public void cellsUpdated(ModelIndexSet<GridRow> rows, ModelIndexSet<GridColumn> columns, @Nullable GridRequestSource.RequestPlace place) {
        for (ModelIndex columnIdx : columns.asIterable()) {
            this.clearDisplayTypesAllowableCache((ModelIndex<GridColumn>)columnIdx);
        }
        this.myResultView.cellsUpdated(rows, columns, place);
    }

    private void registerEscapeAction(@NotNull ResultView resultView) {
        if (resultView == null) {
            TableResultPanel.$$$reportNull$$$0(20);
        }
        resultView.registerEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableResultPanel.this.myErrorNotificationPanel != null) {
                    TableResultPanel.this.hideErrorPanel();
                } else if (TableResultPanel.this.mySearchSession != null) {
                    TableResultPanel.this.mySearchSession.close();
                }
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && !TableResultPanel.this.isEditing() && (TableResultPanel.this.myErrorNotificationPanel != null || TableResultPanel.this.mySearchSession != null);
            }
        });
    }

    @Override
    public boolean isSortViaOrderBySupported() {
        return this.myDataHookUp.getSortingModel() != null;
    }

    @Override
    public boolean isSortViaOrderBy() {
        GridSortingModel sortingModel = this.myDataHookUp.getSortingModel();
        return sortingModel != null && sortingModel.isSortingEnabled();
    }

    @Override
    public void setSortViaOrderBy(boolean sortViaOrderBy) {
        GridSortingModel sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return;
        }
        boolean reload = this.updateDataOrdering(false) || sortingModel.isSortingEnabled() != sortViaOrderBy;
        sortingModel.setSortingEnabled(sortViaOrderBy);
        if (reload && this.isSafeToReload()) {
            this.myDataHookUp.getLoader().loadFirstPage(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this)));
        }
    }

    @Override
    @NotNull
    public RowSortOrder.Type getSortOrder(@NotNull ModelIndex<GridColumn> columnIdx) {
        int sortOrder;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(21);
        }
        int n = sortOrder = this.shouldExposeSortingInfo() ? this.getSortOrder((GridColumn)this.getDataModel().getColumn(columnIdx)) : 0;
        RowSortOrder.Type type = sortOrder == 0 ? RowSortOrder.Type.UNSORTED : (sortOrder < 0 ? RowSortOrder.Type.ASC : RowSortOrder.Type.DESC);
        if (type == null) {
            TableResultPanel.$$$reportNull$$$0(22);
        }
        return type;
    }

    @Override
    public int getThenBySortOrder(@NotNull ModelIndex<GridColumn> columnIdx) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(23);
        }
        return this.shouldExposeSortingInfo() ? Math.abs(this.getSortOrder((GridColumn)this.getDataModel().getColumn(columnIdx))) : 0;
    }

    private boolean shouldExposeSortingInfo() {
        return !this.getResultView().isTransposed() || this.isSortViaOrderBy();
    }

    @Override
    public int getSortOrder(@Nullable GridColumn column) {
        return column != null ? this.myColumnAttributes.getSortOrder(column) : 0;
    }

    @Override
    public void addDataGridListener(DataGridListener listener, Disposable disposable) {
        this.myEventDispatcher.addListener((EventListener)listener, disposable);
    }

    @Override
    @NotNull
    public GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myColorsScheme;
        if (gridColorsScheme == null) {
            TableResultPanel.$$$reportNull$$$0(24);
        }
        return gridColorsScheme;
    }

    @Override
    @Nullable
    public Color getHoveredRowBackground() {
        return this.myColorsScheme.getColor(HOVER_BACKGROUND);
    }

    @Override
    @Nullable
    public Color getStripeRowBackground() {
        if (this.myColorsScheme.isExplicitDefaultBackground()) {
            return this.myColorsScheme.getDelegate().getDefaultBackground();
        }
        Color color = this.myColorsScheme.getColor(DataGridColors.GRID_STRIPE_COLOR);
        Color color2 = color = color != null ? color : this.myColorsScheme.getColor(EditorColors.CARET_ROW_COLOR);
        if (color == null) {
            AbstractColorsScheme delegate = (AbstractColorsScheme)ObjectUtils.tryCast((Object)this.myColorsScheme.getDelegate(), AbstractColorsScheme.class);
            AbstractColorsScheme original = delegate == null ? null : delegate.getOriginal();
            color = original == null ? null : original.getColor(EditorColors.CARET_ROW_COLOR);
        }
        return color;
    }

    @Override
    @NotNull
    public GridColorsScheme getEditorColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myEditorColorsScheme;
        if (gridColorsScheme == null) {
            TableResultPanel.$$$reportNull$$$0(25);
        }
        return gridColorsScheme;
    }

    @Override
    public void searchSessionStarted(@NotNull SearchSession searchSession) {
        if (searchSession == null) {
            TableResultPanel.$$$reportNull$$$0(26);
        }
        this.mySearchSession = searchSession;
        this.myResultView.searchSessionStarted(searchSession);
        this.getResultView().searchSessionUpdated();
    }

    @Override
    public void searchSessionStopped(@NotNull SearchSession searchSession) {
        if (searchSession == null) {
            TableResultPanel.$$$reportNull$$$0(27);
        }
        assert (this.mySearchSession == searchSession);
        this.mySearchSession = null;
        this.getResultView().searchSessionUpdated();
    }

    @Override
    @Nullable
    public SearchSession getSearchSession() {
        return this.mySearchSession;
    }

    @Override
    public TreeMap<Integer, GridColumn> getSortOrderMap() {
        return this.myColumnAttributes.getSortOrderMap();
    }

    @Override
    public int countSortedColumns() {
        return this.myColumnAttributes.countSortedColumns();
    }

    @Override
    public void setObjectFormatterProvider(@NotNull Function<DataGrid, ObjectFormatter> objectFormatterProvider) {
        if (objectFormatterProvider == null) {
            TableResultPanel.$$$reportNull$$$0(28);
        }
        this.myObjectFormatterProvider = objectFormatterProvider;
    }

    @Override
    public ObjectFormatter getObjectFormatter() {
        return this.myObjectFormatterProvider.apply(this);
    }

    public boolean isEditable() {
        return GridHelper.get(this).isEditable(this);
    }

    public boolean isCellEditingAllowed() {
        return this.myResultView instanceof ResultViewWithCells && ((ResultViewWithCells)((Object)this.myResultView)).isCellEditingAllowed();
    }

    public void setCells(@NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns, @Nullable Object value) {
        GridMutator mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(29);
        }
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(30);
        }
        if ((mutator = this.myDataHookUp.getMutator()) != null && this.isSafeToUpdate(rows, columns, value)) {
            mutator.mutate(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this, rows, columns)), rows, columns, value, true);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TableResultPanel.$$$reportNull$$$0(31);
        }
        return project;
    }

    @Override
    @NotNull
    public ActionCallback submit() {
        GridMutator.DatabaseMutator<GridRow, GridColumn> mutator = GridUtil.getDatabaseMutator(this);
        if (mutator == null || !mutator.hasPendingChanges()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TableResultPanel.$$$reportNull$$$0(32);
            }
            return actionCallback;
        }
        GridSelection selection = this.getSelectionModel().store();
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this, mutator.getAffectedRows(), ModelIndexSet.forColumns((CoreGrid)this, (int[])new int[]{-1})));
        mutator.submit(source, true);
        ActionCallback actionCallback = source.getActionCallback().doWhenDone(() -> this.getSelectionModel().restore(this.getSelectionModel().fit(selection)));
        if (actionCallback == null) {
            TableResultPanel.$$$reportNull$$$0(33);
        }
        return actionCallback;
    }

    @NotNull
    public GridDataSupport getDataSupport() {
        return new GridDataSupportImpl(this, (GridMutator<GridRow, GridColumn>)this.myDataHookUp.getMutator());
    }

    @NotNull
    public SelectionModel<GridRow, GridColumn> getSelectionModel() {
        SelectionModel selectionModel = SelectionModelUtil.get(this, this.myResultView);
        if (selectionModel == null) {
            TableResultPanel.$$$reportNull$$$0(34);
        }
        return selectionModel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        GridDataRequest.GridDataRequestOwner owner = (GridDataRequest.GridDataRequestOwner)ObjectUtils.tryCast(this.getDataHookup(), GridDataRequest.GridDataRequestOwner.class);
        return owner != null ? StringUtil.notNullize((String)owner.getDisplayName()) : "";
    }

    @Override
    @NotNull
    public GridMarkupModel<GridRow, GridColumn> getMarkupModel() {
        GridMarkupModel<GridRow, GridColumn> gridMarkupModel = this.myMarkupModel;
        if (gridMarkupModel == null) {
            TableResultPanel.$$$reportNull$$$0(35);
        }
        return gridMarkupModel;
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getDataModel(@NotNull DataAccessType reason) {
        if (reason == null) {
            TableResultPanel.$$$reportNull$$$0(36);
        }
        GridModel gridModel = reason.getModel(this.myDataHookUp);
        if (gridModel == null) {
            TableResultPanel.$$$reportNull$$$0(37);
        }
        return gridModel;
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getDataModel() {
        GridModel gridModel = this.myDataHookUp.getDataModel();
        if (gridModel == null) {
            TableResultPanel.$$$reportNull$$$0(38);
        }
        return gridModel;
    }

    @NotNull
    public GridDataHookUp<GridRow, GridColumn> getDataHookup() {
        GridDataHookUp<GridRow, GridColumn> gridDataHookUp = this.myDataHookUp;
        if (gridDataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(39);
        }
        return gridDataHookUp;
    }

    @NotNull
    public RawIndexConverter getRawIndexConverter() {
        RawIndexConverter rawIndexConverter = this.myResultView.getRawIndexConverter();
        if (rawIndexConverter == null) {
            TableResultPanel.$$$reportNull$$$0(40);
        }
        return rawIndexConverter;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myResultView.getPreferredFocusedComponent();
        if (jComponent == null) {
            TableResultPanel.$$$reportNull$$$0(41);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getMainResultViewComponent() {
        JComponent jComponent = this.myMainResultViewComponent;
        if (jComponent == null) {
            TableResultPanel.$$$reportNull$$$0(42);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public GridMainPanel getPanel() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            TableResultPanel.$$$reportNull$$$0(43);
        }
        return gridMainPanel;
    }

    @NotNull
    public ModelIndexSet<GridColumn> getVisibleColumns() {
        ModelIndexSet<GridColumn> modelIndexSet = this.myResultView.getVisibleColumns();
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(44);
        }
        return modelIndexSet;
    }

    @NotNull
    public ModelIndexSet<GridRow> getVisibleRows() {
        ModelIndexSet<GridRow> modelIndexSet = this.myResultView.getVisibleRows();
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(45);
        }
        return modelIndexSet;
    }

    public int getVisibleRowsCount() {
        return this.myResultView.getViewRowCount();
    }

    public boolean isEditing() {
        return this.myResultView.isEditing();
    }

    public boolean stopEditing() {
        return this.myResultView.stopEditing();
    }

    public void cancelEditing() {
        this.myResultView.cancelEditing();
    }

    public void editSelectedCell() {
        if (this.myResultView instanceof ResultViewWithCells) {
            ((ResultViewWithCells)((Object)this.myResultView)).editSelectedCell();
        }
    }

    @NotNull
    public String getUnambiguousColumnName(@NotNull ModelIndex<GridColumn> column) {
        GridColumn c2;
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(46);
        }
        String string = (c2 = (GridColumn)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column)) == null ? "" : this.myColumnAttributes.getName(c2).trim();
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(47);
        }
        return string;
    }

    public boolean isViewModified() {
        for (GridColumn column : this.getDataModel().getColumns()) {
            boolean sortOrderChanged;
            boolean shouldBeShown = !column.getAttributes().contains(ColumnDescriptor.Attribute.HIDDEN);
            boolean shown = this.isColumnEnabled(column);
            boolean bl = sortOrderChanged = this.getSortOrder(column) != 0;
            if (shown == shouldBeShown && !sortOrderChanged) continue;
            return true;
        }
        return this.myResultView.isViewModified();
    }

    @Override
    public int getVisibleColumnCount() {
        return this.myResultView.getViewColumnCount();
    }

    void showError(@NotNull ErrorInfo errorInfo, @Nullable DataGridRequestPlace source) {
        if (errorInfo == null) {
            TableResultPanel.$$$reportNull$$$0(48);
        }
        this.hideErrorPanel();
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(errorInfo.getMessage(), errorInfo.getOriginalThrowable());
        List fixes = errorInfo.getFixes();
        if (!fixes.isEmpty()) {
            for (ErrorInfo.Fix fix : fixes) {
                builder.addLink(fix.getName(), null, () -> GridHelper.get(this).applyFix(this.myProject, fix, null));
            }
            builder.addSpace();
        } else {
            builder.addDetailsButton();
        }
        if (source != null && source.getRows().size() == 1) {
            ModelIndex modelRowIdx = (ModelIndex)source.getRows().first();
            ModelIndex modelColumnIdx = (ModelIndex)source.getColumns().first();
            ViewIndex viewRowIdx = modelRowIdx.toView((CoreGrid)this);
            ViewIndex viewColumnIdx = modelColumnIdx.toView((CoreGrid)this);
            int r = viewRowIdx.asInteger() + 1;
            int c2 = viewColumnIdx.asInteger() + 1;
            String title = DataGridBundle.message((String)"action.row.choice.col.text", (Object[])new Object[]{r, c2, c2 < 1 ? 0 : 1});
            builder.addLink(title, 78, () -> {
                if (viewRowIdx.isValid((CoreGrid)this) && viewColumnIdx.isValid((CoreGrid)this)) {
                    GridUtil.scrollToLocally(this, (ViewIndex<GridRow>)viewRowIdx, (ViewIndex<GridColumn>)viewColumnIdx);
                }
            });
        }
        this.myErrorNotificationPanel = builder.addCloseButton(this::hideErrorPanel).build();
        this.myMainPanel.setBottomComponent(this.myErrorNotificationPanel);
        this.myErrorNotificationPanel.revalidate();
        this.myMainPanel.repaint();
    }

    void hideErrorPanel() {
        if (this.myErrorNotificationPanel == null) {
            return;
        }
        this.myMainPanel.setBottomComponent(null);
        this.myErrorNotificationPanel = null;
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void handleError(@NotNull GridRequestSource requestSource, @NotNull ErrorInfo errorInfo) {
        if (requestSource == null) {
            TableResultPanel.$$$reportNull$$$0(49);
        }
        if (errorInfo == null) {
            TableResultPanel.$$$reportNull$$$0(50);
        }
        GridRequestSource.RequestPlace source = requestSource.place;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myFilterComponent.getFilterPanel().handleError(requestSource, errorInfo)) {
                return;
            }
            GridEditorPanel sortingPanel = this.myFilterComponent.getSortingPanel();
            if (sortingPanel != null && sortingPanel.handleError(requestSource, errorInfo)) {
                return;
            }
            this.showError(errorInfo, (DataGridRequestPlace)ObjectUtils.tryCast((Object)source, DataGridRequestPlace.class));
        });
    }

    protected void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            TableResultPanel.$$$reportNull$$$0(51);
        }
        sink.set(CommonDataKeys.PROJECT, (Object)this.myProject);
        sink.setNull(CommonDataKeys.EDITOR);
        sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)new GridCopyProvider(this));
        sink.set(PlatformDataKeys.PASTE_PROVIDER, (Object)new GridPasteProvider(this, GridUtil::retrieveDataFromText));
        sink.set(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)new DeleteRowsAction());
        sink.set(DatabaseDataKeys.DATA_GRID_KEY, (Object)this);
        sink.set(LangDataKeys.NO_NEW_ACTION, (Object)Boolean.TRUE);
        sink.lazy(CommonDataKeys.PSI_FILE, () -> {
            VirtualFile file = GridUtil.getVirtualFile(this);
            return file == null ? null : PsiManager.getInstance((Project)this.getProject()).findFile(file);
        });
        sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> GridUtil.getPsiElementForSelection(this));
        sink.lazy(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY, () -> (PsiElement[])ContainerUtil.ar((Object[])new PsiElement[]{GridUtil.getPsiElementForSelection(this)}));
    }

    @Override
    public void toggleSortColumns(@NotNull List<ModelIndex<GridColumn>> columns, boolean additive) {
        boolean forceAscOrder;
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(52);
        }
        if (columns.isEmpty()) {
            return;
        }
        GridModel<GridRow, GridColumn> model2 = this.getDataModel();
        int oldOrder = this.myColumnAttributes.getSortOrder((GridColumn)model2.getColumn(columns.get(0)));
        boolean bl = forceAscOrder = !additive && !GridUtil.areOnlySortedColumns(columns, this);
        RowSortOrder.Type order = forceAscOrder || oldOrder == 0 ? RowSortOrder.Type.ASC : (oldOrder < 0 ? RowSortOrder.Type.DESC : RowSortOrder.Type.UNSORTED);
        this.sortColumns(columns, order, additive);
        GridUtil.activeGridListener().onColumnSortingToggled(this.myMainPanel.getGrid());
    }

    @Override
    public void sortColumns(@NotNull List<ModelIndex<GridColumn>> columns, @NotNull RowSortOrder.Type order, boolean additive) {
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(53);
        }
        if (order == null) {
            TableResultPanel.$$$reportNull$$$0(54);
        }
        if (columns.isEmpty()) {
            return;
        }
        GridSortingModel model2 = this.myDataHookUp.getSortingModel();
        if (additive && model2 != null) {
            List ordering = ContainerUtil.map((Collection)model2.getOrdering(), sortOrder -> (ModelIndex)sortOrder.getColumn());
            if (!GridHelper.get(this).canSortTogether(this, ordering, columns)) {
                return;
            }
        }
        if (this.sortingEquals(columns, order, !additive)) {
            return;
        }
        if (!additive) {
            this.myColumnAttributes.resetOrdering();
        }
        for (ModelIndex<GridColumn> column : columns) {
            this.changeSortOrder(column, order);
        }
        this.updateSortKeysFromColumnAttributes();
        this.updateDataOrderingIfNeeded();
    }

    @Override
    public ColumnAttributes getColumnAttributes() {
        return this.myColumnAttributes;
    }

    public boolean sortingEquals(@NotNull List<ModelIndex<GridColumn>> columns, @NotNull RowSortOrder.Type order, boolean checkOtherColumns) {
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(55);
        }
        if (order == null) {
            TableResultPanel.$$$reportNull$$$0(56);
        }
        GridModel<GridRow, GridColumn> model2 = this.getDataModel();
        Set newColumns = ContainerUtil.map2Set(columns, c2 -> c2.asInteger());
        for (ModelIndex idx : model2.getColumnIndices().asIterable()) {
            int oldOrder = this.myColumnAttributes.getSortOrder((GridColumn)model2.getColumn(idx));
            if (!(newColumns.contains(idx.asInteger()) ? (order == RowSortOrder.Type.ASC ? oldOrder >= 0 : (order == RowSortOrder.Type.DESC ? oldOrder <= 0 : oldOrder != 0)) : checkOtherColumns && oldOrder != 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Language getContentLanguage(@NotNull ModelIndex<GridColumn> columnIdx) {
        GridColumn column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(57);
        }
        Language language = (column = (GridColumn)this.getDataModel().getColumn(columnIdx)) != null ? this.getContentLanguage(column) : Language.ANY;
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(58);
        }
        return language;
    }

    @NotNull
    Language getContentLanguage(@NotNull GridColumn column) {
        Language fromAttributes;
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(59);
        }
        Language language = (fromAttributes = this.myColumnAttributes.getContentLanguage(column)) != null ? fromAttributes : this.getInitialContentLanguage(column);
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(60);
        }
        return language;
    }

    @Override
    public boolean isRowFilteredOut(@NotNull ModelIndex<?> rowIdx) {
        if (rowIdx == null) {
            TableResultPanel.$$$reportNull$$$0(61);
        }
        return false;
    }

    @Override
    public void setContentLanguage(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull Language language) {
        GridColumn column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(62);
        }
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(63);
        }
        if ((column = (GridColumn)this.getDataModel().getColumn(columnIdx)) != null) {
            this.myColumnAttributes.setContentLanguage(column, language);
            this.myResultView.contentLanguageUpdated(columnIdx, language);
            ((DataGridListener)this.myEventDispatcher.getMulticaster()).onCellLanguageChanged(columnIdx, language);
        }
    }

    @Override
    public void setDisplayType(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull DisplayType displayType) {
        GridColumn column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(64);
        }
        if (displayType == null) {
            TableResultPanel.$$$reportNull$$$0(65);
        }
        if ((column = (GridColumn)this.getDataModel().getColumn(columnIdx)) != null) {
            this.myColumnAttributes.setDisplayType(column, displayType);
            this.myResultView.displayTypeUpdated(columnIdx, displayType);
            ((DataGridListener)this.myEventDispatcher.getMulticaster()).onCellDisplayTypeChanged(columnIdx, displayType);
            this.myModificationTracker.incModificationCount();
        }
    }

    @Override
    @NotNull
    public DisplayType getPureDisplayType(@NotNull ModelIndex<GridColumn> columnIdx) {
        GridColumn column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(66);
        }
        if ((column = (GridColumn)this.getDataModel().getColumn(columnIdx)) == null) {
            BinaryDisplayType binaryDisplayType = BinaryDisplayType.HEX;
            if (binaryDisplayType == null) {
                TableResultPanel.$$$reportNull$$$0(67);
            }
            return binaryDisplayType;
        }
        DisplayType fromAttributes = this.myColumnAttributes.getDisplayType(column);
        if (fromAttributes != null) {
            DisplayType displayType = fromAttributes;
            if (displayType == null) {
                TableResultPanel.$$$reportNull$$$0(68);
            }
            return displayType;
        }
        NumberDisplayType defaultType = ChangeColumnDisplayTypeAction.isIntegerOrBigInt(columnIdx, this) ? NumberDisplayType.NUMBER : BinaryDisplayType.DETECT;
        DisplayType displayType = (DisplayType)ObjectUtils.notNull((Object)this.getInitialDisplayType(column), (Object)((DisplayType)defaultType));
        if (displayType == null) {
            TableResultPanel.$$$reportNull$$$0(69);
        }
        return displayType;
    }

    @Override
    @NotNull
    public DisplayType getDisplayType(@NotNull ModelIndex<GridColumn> columnIdx) {
        DisplayType displayType;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(70);
        }
        Object object = (displayType = this.getPureDisplayType(columnIdx)) != BinaryDisplayType.DETECT ? displayType : this.getOptimalBinaryDisplayTypeForDetect(columnIdx);
        if (object == null) {
            TableResultPanel.$$$reportNull$$$0(71);
        }
        return object;
    }

    @Override
    @NotNull
    public BinaryDisplayType getOptimalBinaryDisplayTypeForDetect(@NotNull ModelIndex<GridColumn> columnIdx) {
        boolean hasRows;
        GridColumn column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(72);
        }
        if ((column = (GridColumn)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx)) == null) {
            BinaryDisplayType binaryDisplayType = BinaryDisplayType.HEX;
            if (binaryDisplayType == null) {
                TableResultPanel.$$$reportNull$$$0(73);
            }
            return binaryDisplayType;
        }
        ColumnAttributes.Attributes columnAttributes = this.myColumnAttributes.myAttributesMap.get(column);
        if (columnAttributes == null) {
            BinaryDisplayType binaryDisplayType = BinaryDisplayType.HEX;
            if (binaryDisplayType == null) {
                TableResultPanel.$$$reportNull$$$0(74);
            }
            return binaryDisplayType;
        }
        if (columnAttributes.myDisplayTypesInfoCache == null) {
            this.updateDisplayTypesAllowable(columnIdx);
        }
        boolean uuidAllowed = columnAttributes.myDisplayTypesInfoCache.allowedDisplayTypes().contains(BinaryDisplayType.UUID);
        boolean uuidKnownVersion = columnAttributes.myDisplayTypesInfoCache.uuidHasKnownVersion;
        boolean uuidSwapKnownVersion = columnAttributes.myDisplayTypesInfoCache.uuidHasSwapKnownVersion;
        boolean detectUUIDInBinaryColumns = GridUtil.isDetectUUIDInBinaryColumns(this);
        boolean bl = hasRows = this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount() > 0;
        if (detectUUIDInBinaryColumns && uuidAllowed && hasRows) {
            if (!uuidKnownVersion && uuidSwapKnownVersion) {
                BinaryDisplayType binaryDisplayType = BinaryDisplayType.UUID_SWAP;
                if (binaryDisplayType == null) {
                    TableResultPanel.$$$reportNull$$$0(75);
                }
                return binaryDisplayType;
            }
            BinaryDisplayType binaryDisplayType = BinaryDisplayType.UUID;
            if (binaryDisplayType == null) {
                TableResultPanel.$$$reportNull$$$0(76);
            }
            return binaryDisplayType;
        }
        if (GridUtil.isDetectTextInBinaryColumns(this) && this.myColumnAttributes.getIsDisplayTypeAllowed(column, BinaryDisplayType.TEXT) && hasRows) {
            BinaryDisplayType binaryDisplayType = BinaryDisplayType.TEXT;
            if (binaryDisplayType == null) {
                TableResultPanel.$$$reportNull$$$0(77);
            }
            return binaryDisplayType;
        }
        BinaryDisplayType binaryDisplayType = BinaryDisplayType.HEX;
        if (binaryDisplayType == null) {
            TableResultPanel.$$$reportNull$$$0(78);
        }
        return binaryDisplayType;
    }

    private void updateDisplayTypesAllowable(ModelIndex<GridColumn> columnIdx) {
        GridColumn column = (GridColumn)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        if (column == null) {
            return;
        }
        LinkedHashSet<BinaryDisplayType> newAllowedDisplayTypes = new LinkedHashSet<BinaryDisplayType>();
        boolean uuidHasKnownVersion = false;
        boolean uuidSwapHasKnownVersion = false;
        if (this.checkTextViewAllowed(columnIdx)) {
            newAllowedDisplayTypes.add(BinaryDisplayType.TEXT);
        }
        if (ChangeColumnDisplayTypeAction.isBinary(columnIdx, this) && this.checkSomeUUIDViewAllowed(columnIdx)) {
            newAllowedDisplayTypes.add(BinaryDisplayType.UUID);
            newAllowedDisplayTypes.add(BinaryDisplayType.UUID_SWAP);
            uuidHasKnownVersion = this.checkUUIDHasKnownVersion(columnIdx, false);
            uuidSwapHasKnownVersion = this.checkUUIDHasKnownVersion(columnIdx, true);
        }
        this.myColumnAttributes.myAttributesMap.get((Object)column).myDisplayTypesInfoCache = new ColumnAttributes.DisplayTypesInfo(newAllowedDisplayTypes, uuidHasKnownVersion, uuidSwapHasKnownVersion);
        this.myResultView.displayTypeUpdated(columnIdx, (DisplayType)BinaryDisplayType.DETECT);
        this.myModificationTracker.incModificationCount();
    }

    private void clearDisplayTypesAllowableCache(ModelIndex<GridColumn> columnIdx) {
        GridColumn column = (GridColumn)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        if (column == null) {
            return;
        }
        this.myColumnAttributes.clearDisplayTypeAllowedCache(column);
    }

    private void clearAllColumnsDisplayTypesAllowableCache() {
        GridModel<GridRow, GridColumn> model2 = this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        JBIterable modelIndices = model2.getColumnIndices().asIterable();
        for (ModelIndex columnIdx : modelIndices) {
            GridColumn column = (GridColumn)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
            if (column == null) {
                return;
            }
            this.myColumnAttributes.clearDisplayTypeAllowedCache(column);
        }
    }

    @Override
    public boolean isDisplayTypeApplicable(@NotNull BinaryDisplayType displayType, @NotNull ModelIndex<GridColumn> columnIdx) {
        GridColumn column;
        if (displayType == null) {
            TableResultPanel.$$$reportNull$$$0(79);
        }
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(80);
        }
        if ((column = (GridColumn)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx)) == null) {
            return false;
        }
        if (this.myColumnAttributes.myAttributesMap.get((Object)column).myDisplayTypesInfoCache == null) {
            this.updateDisplayTypesAllowable(columnIdx);
        }
        return this.myColumnAttributes.getIsDisplayTypeAllowed(column, displayType) || displayType == BinaryDisplayType.UUID && this.myColumnAttributes.getIsDisplayTypeAllowed(column, BinaryDisplayType.UUID_SWAP);
    }

    private boolean checkTextViewAllowed(@NotNull ModelIndex<GridColumn> columnIdx) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(81);
        }
        return this.isViewAllowed(columnIdx, value -> TextInfo.tryDetectString((byte[])value) != null);
    }

    private boolean checkSomeUUIDViewAllowed(@NotNull ModelIndex<GridColumn> columnIdx) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(82);
        }
        return this.isViewAllowed(columnIdx, value -> ((byte[])value).length == 16);
    }

    private boolean checkUUIDHasKnownVersion(@NotNull ModelIndex<GridColumn> columnIdx, boolean swapFlag) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(83);
        }
        return this.isViewAllowed(columnIdx, value -> ObjectFormatterUtil.isValidUUIDWithKnownVersion((UUID)ObjectFormatterUtil.toUUID((byte[])value, (boolean)swapFlag)));
    }

    private boolean isViewAllowed(@NotNull ModelIndex<GridColumn> columnIdx, Function<byte[], Boolean> valueViewCheck) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(84);
        }
        boolean isViewAllowed = true;
        GridModel<GridRow, GridColumn> dataModel = this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        GridColumn column = (GridColumn)dataModel.getColumn(columnIdx);
        if (column == null) {
            return false;
        }
        int rowsToInspect = Math.min(dataModel.getRowCount(), 1000);
        for (ModelIndex rowIdx : dataModel.getRowIndices().asIterable().take(rowsToInspect)) {
            GridRow row = (GridRow)dataModel.getRow(rowIdx);
            if (row == null) {
                return false;
            }
            Object value = column.getValue(row);
            if (value == null) continue;
            if (value instanceof byte[]) {
                isViewAllowed &= valueViewCheck.apply((byte[])value).booleanValue();
                continue;
            }
            if (value instanceof LobInfo.BlobInfo) {
                isViewAllowed &= valueViewCheck.apply(((LobInfo.BlobInfo)value).data).booleanValue();
                continue;
            }
            if (value instanceof TextInfo) {
                isViewAllowed &= valueViewCheck.apply(((TextInfo)value).bytes).booleanValue();
                continue;
            }
            isViewAllowed = false;
            break;
        }
        return isViewAllowed;
    }

    @Override
    @NotNull
    public ModelIndex<GridColumn> getContextColumn() {
        ModelIndex<GridColumn> modelIndex = this.myResultView.getContextColumn();
        if (modelIndex == null) {
            TableResultPanel.$$$reportNull$$$0(85);
        }
        return modelIndex;
    }

    public void setFilterText(@NotNull String filter, int caretPosition) {
        if (filter == null) {
            TableResultPanel.$$$reportNull$$$0(86);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.isFilteringComponentShown() && !StringUtil.isEmptyOrSpaces((String)filter)) {
            this.toggleFilteringComponent();
            this.getFilterComponent().getFilterPanel().getComponent().requestFocusInWindow();
        }
        GridFilterPanel.setFilterText(this.myFilterComponent.getFilterPanel(), this, filter, caretPosition);
    }

    @NotNull
    public String getFilterText() {
        String string = this.myFilterComponent.getFilterPanel().getText();
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(87);
        }
        return string;
    }

    public boolean isReady() {
        return !this.getDataModel().isUpdatingNow();
    }

    @Override
    public boolean isEmpty() {
        return this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount() == 0;
    }

    public void dispose() {
        if (this.myResultView != null) {
            Disposer.dispose((Disposable)this.myResultView);
        }
        kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)this.cs, null);
    }

    public void showCell(int absoluteRowIdx, @NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(88);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            int rawRowIndex = this.adjustAbsoluteRowIdx(absoluteRowIdx) + 1;
            this.scrollTo(rawRowIndex, column);
        });
    }

    private int adjustAbsoluteRowIdx(int absoluteRowIdx) {
        GridPagingModel pageModel = this.myDataHookUp.getPageModel();
        if (!pageModel.isTotalRowCountPrecise()) {
            return absoluteRowIdx;
        }
        long lastRowIdx = pageModel.getTotalRowCount() - 1L;
        return Math.min(lastRowIdx > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lastRowIdx, absoluteRowIdx);
    }

    private void scrollTo(int dataRowIndex, ModelIndex<GridColumn> columnIdx) {
        GridPagingModel pageModel = this.myDataHookUp.getPageModel();
        Runnable localScrollRunnable = () -> {
            ModelIndex rowIdx = pageModel.findRow(dataRowIndex);
            Pair rowAndColumn = this.getRawIndexConverter().rowAndColumn2View().fun((Object)rowIdx.asInteger(), (Object)columnIdx.asInteger());
            ViewIndex row = ViewIndex.forRow((CoreGrid)this, (int)((Integer)rowAndColumn.first));
            ViewIndex column = ViewIndex.forColumn((CoreGrid)this, (int)((Integer)rowAndColumn.second));
            GridUtil.scrollToLocally(this, (ViewIndex<GridRow>)row, (ViewIndex<GridColumn>)column);
        };
        if (pageModel.findRow(dataRowIndex).isValid((CoreGrid)this)) {
            localScrollRunnable.run();
        } else {
            GridLoader loader = this.myDataHookUp.getLoader();
            int offset = Math.max(0, dataRowIndex - pageModel.getPageSize() / 2);
            GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this));
            source.getActionCallback().doWhenDone(localScrollRunnable);
            loader.load(source, offset);
        }
    }

    @Override
    public boolean isFilteringSupported() {
        return this.getDataHookup().getFilteringModel() != null;
    }

    @Override
    public boolean isFilteringComponentShown() {
        return this.myFilterComponent.getComponent().isVisible();
    }

    @Override
    public void toggleFilteringComponent() {
        this.myFilterComponent.getComponent().setVisible(!this.myFilterComponent.getComponent().isVisible());
    }

    @Override
    public void resetLayout() {
        this.myResultView.resetLayout();
    }

    @Override
    public void fireContentChanged(@Nullable GridRequestSource.RequestPlace place) {
        Component rowHeader;
        JViewport header = this.myMainResultViewComponent instanceof JScrollPane ? ((JScrollPane)this.myMainResultViewComponent).getRowHeader() : null;
        Component component = rowHeader = header == null ? null : header.getView();
        if (rowHeader instanceof TableResultRowHeader) {
            ((TableResultRowHeader)rowHeader).updatePreferredSize();
            rowHeader.revalidate();
            rowHeader.repaint();
        }
        this.myModificationTracker.incModificationCount();
        ((DataGridListener)this.myEventDispatcher.getMulticaster()).onContentChanged(this, place);
    }

    @Override
    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    @Override
    @NotNull
    public ModificationTracker getColumnModelModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myColumnModificationTracker;
        if (simpleModificationTracker == null) {
            TableResultPanel.$$$reportNull$$$0(89);
        }
        return simpleModificationTracker;
    }

    @Override
    @Nullable
    public DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig getFormatterConfig(@NotNull ModelIndex<GridColumn> columnIdx) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(90);
        }
        return (DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig)((Map)this.myFormatterConfigCached.getValue()).get(columnIdx);
    }

    protected boolean isInitiallyDisabled(@NotNull GridColumn column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(91);
        }
        return column.getAttributes().contains(ColumnDescriptor.Attribute.HIDDEN);
    }

    protected Language getInitialContentLanguage(@NotNull GridColumn column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(92);
        }
        return Language.ANY;
    }

    protected int getInitialPosition(@NotNull GridColumn column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(93);
        }
        return -1;
    }

    @Nullable
    protected DisplayType getInitialDisplayType(@NotNull GridColumn column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(94);
        }
        return null;
    }

    @Override
    public void setValueAt(@NotNull ModelIndexSet<GridRow> viewRows, @NotNull ModelIndexSet<GridColumn> viewColumns, @Nullable Object value, boolean allowImmediateUpdate, @Nullable Runnable moveToNextCellRunnable, @NotNull GridRequestSource source) {
        ModelIndexSet columns;
        if (viewRows == null) {
            TableResultPanel.$$$reportNull$$$0(95);
        }
        if (viewColumns == null) {
            TableResultPanel.$$$reportNull$$$0(96);
        }
        if (source == null) {
            TableResultPanel.$$$reportNull$$$0(97);
        }
        GridMutator mutator = this.getDataHookup().getMutator();
        int[] validRows = this.valid(viewRows);
        int[] validColumns = this.valid(viewColumns);
        ModelIndexSet rows = validRows.length > 0 ? ModelIndexSet.forRows((CoreGrid)this, (int[])validRows) : null;
        ModelIndexSet modelIndexSet = columns = validRows.length > 0 ? ModelIndexSet.forColumns((CoreGrid)this, (int[])validColumns) : null;
        if (mutator == null || rows == null || this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).allValuesEqualTo(rows, columns, value)) {
            if (moveToNextCellRunnable != null) {
                ApplicationManager.getApplication().invokeLater(moveToNextCellRunnable);
            }
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (moveToNextCellRunnable != null) {
                source.getActionCallback().doWhenDone(moveToNextCellRunnable);
            }
            mutator.mutate(source, rows, columns, value, allowImmediateUpdate);
        });
    }

    private <T> int[] valid(ModelIndexSet<T> set) {
        return set.asList().stream().filter(idx -> idx.isValid((CoreGrid)this)).mapToInt(Index::asInteger).toArray();
    }

    @Override
    public boolean isHeaderSelecting() {
        return false;
    }

    private void setOrderingFromModel() {
        if (!this.isSortViaOrderBy()) {
            return;
        }
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<GridColumn>> order : this.getOrderingFromModel()) {
            this.changeSortOrder((ModelIndex<GridColumn>)((ModelIndex)order.getColumn()), order.getOrder());
        }
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<GridColumn>>> getOrderingFromModel() {
        GridSortingModel sortingModel = this.myDataHookUp.getSortingModel();
        List list = sortingModel != null ? sortingModel.getAppliedOrdering() : ContainerUtil.emptyList();
        if (list == null) {
            TableResultPanel.$$$reportNull$$$0(98);
        }
        return list;
    }

    @Override
    public void updateSortKeysFromColumnAttributes() {
        this.myResultView.updateSortKeysFromColumnAttributes();
        this.fireContentChanged(null);
    }

    public void changeSortOrder(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull RowSortOrder.Type targetSortOrder) {
        GridColumn column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(99);
        }
        if (targetSortOrder == null) {
            TableResultPanel.$$$reportNull$$$0(100);
        }
        if ((column = (GridColumn)this.getDataModel().getColumn(columnIdx)) != null) {
            this.myColumnAttributes.changeSortOrder(column, targetSortOrder);
        }
    }

    private void updateDataOrderingIfNeeded() {
        if (this.isSortViaOrderBy()) {
            this.updateDataOrdering(true);
        }
    }

    private boolean updateDataOrdering(boolean reloadIfUpdated) {
        List<RowSortOrder<ModelIndex<GridColumn>>> newOrdering;
        GridSortingModel sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return false;
        }
        List<RowSortOrder<ModelIndex<GridColumn>>> oldOrdering = this.getOrderingFromModel();
        if (TableResultPanel.isSameOrdering(oldOrdering, newOrdering = this.createOrdering())) {
            return false;
        }
        if (reloadIfUpdated && !this.isSafeToReload()) {
            return false;
        }
        sortingModel.setOrdering(newOrdering);
        if (reloadIfUpdated) {
            this.alarm.cancelAllRequests();
            this.alarm.addRequest(() -> this.myDataHookUp.getLoader().loadFirstPage(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this))), 300);
        }
        return true;
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<GridColumn>>> createOrdering() {
        TreeMap<Integer, GridColumn> sortOrderMap = this.getSortOrderMap();
        ArrayList<RowSortOrder<ModelIndex<GridColumn>>> ordering = new ArrayList<RowSortOrder<ModelIndex<GridColumn>>>(sortOrderMap.size());
        for (GridColumn column : sortOrderMap.values()) {
            int dataColumnIdx = column.getColumnNumber();
            ModelIndex columnIdx = ModelIndex.forColumn((CoreGrid)this, (int)dataColumnIdx);
            ordering.add((RowSortOrder<ModelIndex<GridColumn>>)(this.getSortOrder(column) < 0 ? RowSortOrder.asc((Object)columnIdx) : RowSortOrder.desc((Object)columnIdx)));
        }
        ArrayList<RowSortOrder<ModelIndex<GridColumn>>> arrayList = ordering;
        if (arrayList == null) {
            TableResultPanel.$$$reportNull$$$0(101);
        }
        return arrayList;
    }

    private static boolean isSameOrdering(@NotNull List<RowSortOrder<ModelIndex<GridColumn>>> ordering1, @NotNull List<RowSortOrder<ModelIndex<GridColumn>>> ordering2) {
        if (ordering1 == null) {
            TableResultPanel.$$$reportNull$$$0(102);
        }
        if (ordering2 == null) {
            TableResultPanel.$$$reportNull$$$0(103);
        }
        if (ordering1.size() != ordering2.size()) {
            return false;
        }
        for (int i = 0; i < ordering1.size(); ++i) {
            RowSortOrder<ModelIndex<GridColumn>> o1 = ordering1.get(i);
            RowSortOrder<ModelIndex<GridColumn>> o2 = ordering2.get(i);
            if (Comparing.equal((Object)o1.getOrder(), (Object)o2.getOrder()) && Comparing.equal((Object)((ModelIndex)o1.getColumn()), (Object)((ModelIndex)o2.getColumn()))) continue;
            return false;
        }
        return true;
    }

    public boolean isColumnEnabled(@NotNull ModelIndex<GridColumn> columnIndex) {
        if (columnIndex == null) {
            TableResultPanel.$$$reportNull$$$0(104);
        }
        if (!columnIndex.isValid((CoreGrid)this)) {
            return false;
        }
        return this.isColumnEnabled((GridColumn)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIndex));
    }

    public boolean isColumnEnabled(@Nullable GridColumn column) {
        if (column == null) {
            return false;
        }
        Boolean enabled = this.myColumnAttributes.isEnabled(column);
        return enabled != null ? enabled : !this.isInitiallyDisabled(column);
    }

    public void setColumnEnabled(@NotNull ModelIndex<GridColumn> columnIdx, boolean state) {
        GridColumn column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(105);
        }
        if ((column = (GridColumn)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx)) == null || this.isColumnEnabled(column) == state) {
            return;
        }
        this.myColumnAttributes.setEnabled(column, state);
        GridSelection selection = this.getSelectionModel().store();
        ModelIndex colIdx = ModelIndex.forColumn((CoreGrid)this, (int)column.getColumnNumber());
        this.storeOrRestoreSelection((ModelIndex<GridColumn>)colIdx, state, (GridSelection<GridRow, GridColumn>)selection);
        this.myResultView.setColumnEnabled((ModelIndex<GridColumn>)colIdx, state);
        this.fireContentChanged(null);
        this.runWithIgnoreSelectionChanges(() -> this.getSelectionModel().restore(selection));
    }

    public void setRowEnabled(@NotNull ModelIndex<GridRow> rowIdx, boolean state) {
        if (rowIdx == null) {
            TableResultPanel.$$$reportNull$$$0(106);
        }
        this.myResultView.setRowEnabled(rowIdx, state);
    }

    public void storeOrRestoreSelection(@NotNull ModelIndex<GridColumn> columnIdx, boolean state, @NotNull GridSelection<GridRow, GridColumn> selection) {
        boolean selected;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(107);
        }
        if (selection == null) {
            TableResultPanel.$$$reportNull$$$0(108);
        }
        int modelIndex = columnIdx.asInteger();
        if (state && this.myHiddenColumnSelectionHolder.contains(modelIndex)) {
            selection.addSelectedColumns((CoreGrid)this, ModelIndexSet.forColumns((CoreGrid)this, (int[])new int[]{columnIdx.value}));
            this.myHiddenColumnSelectionHolder.columnShown(modelIndex);
        } else if (!state && (selected = this.getSelectionModel().isSelectedColumn(columnIdx))) {
            this.myHiddenColumnSelectionHolder.columnHidden(modelIndex);
        }
    }

    @Override
    public void setPresentationMode(@NotNull GridPresentationMode presentationMode) {
        if (presentationMode == null) {
            TableResultPanel.$$$reportNull$$$0(109);
        }
        if (this.myPresentationMode == presentationMode) {
            return;
        }
        GridUtil.saveAndRestoreSelection(this, () -> {
            boolean requestFocusInSearchField;
            this.myPresentationMode = presentationMode;
            ResultViewFactory newFactory = ResultViewFactory.of(presentationMode);
            boolean bl = requestFocusInSearchField = this.mySearchSession != null && IdeFocusManager.getInstance((Project)this.getProject()).getFocusOwner() == this.mySearchSession.getComponent().getSearchTextComponent();
            if (this.myViewFactory != newFactory) {
                boolean wasTransposed = this.myResultView.isTransposed();
                this.myViewFactory = newFactory;
                this.myLayeredPane.removeAll();
                Disposer.dispose((Disposable)this.myResultView);
                this.createResultView();
                this.myResultView.setTransposed(wasTransposed);
                this.columnsAdded((ModelIndexSet<GridColumn>)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnIndices());
                if (this.mySearchSession != null) {
                    FindModel findModel = this.mySearchSession.getFindModel();
                    this.mySearchSession.close();
                    this.mySearchSession = this.myResultView.createSearchSession(findModel, this.myMainPanel.getSecondTopComponent());
                }
            }
            this.myMainPanel.revalidate();
            this.myMainPanel.repaint();
            if (!DataGridStartupActivity.DataEditorConfigurator.isLoadingDelayed(this)) {
                IdeFocusManager.getInstance((Project)this.getProject()).doWhenFocusSettlesDown(() -> IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)(requestFocusInSearchField ? this.mySearchSession.getComponent().getSearchTextComponent() : this.getPreferredFocusedComponent()), true));
            }
        });
    }

    @Override
    @NotNull
    public GridPresentationMode getPresentationMode() {
        GridPresentationMode gridPresentationMode = this.myPresentationMode;
        if (gridPresentationMode == null) {
            TableResultPanel.$$$reportNull$$$0(110);
        }
        return gridPresentationMode;
    }

    @Override
    public void runWithIgnoreSelectionChanges(Runnable runnable) {
        try {
            this.myHiddenColumnSelectionHolder.startAdjusting();
            runnable.run();
        }
        finally {
            this.myHiddenColumnSelectionHolder.endAdjusting();
        }
    }

    @Override
    public boolean isSafeToReload() {
        GridMutator mutator = this.myDataHookUp.getMutator();
        return mutator == null || !mutator.hasPendingChanges() || GridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    @Override
    public boolean isSafeToUpdate(@NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns, @Nullable Object newValue) {
        GridMutator mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(111);
        }
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(112);
        }
        return (mutator = this.myDataHookUp.getMutator()) == null || mutator.isUpdateSafe(rows, columns, newValue) || GridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    @Override
    @NotNull
    public GridFilterAndSortingComponent getFilterComponent() {
        GridFilterAndSortingComponent gridFilterAndSortingComponent = this.myFilterComponent;
        if (gridFilterAndSortingComponent == null) {
            TableResultPanel.$$$reportNull$$$0(113);
        }
        return gridFilterAndSortingComponent;
    }

    @Override
    public void resetFilters() {
        this.setFilterText("", -1);
        this.resetOrderingAndVisibility();
    }

    public void resetView() {
        if (this.isSortViaOrderBy() && !this.isSafeToReload()) {
            return;
        }
        HiddenColumnsSelectionHolder copy = this.myHiddenColumnSelectionHolder.copy();
        this.myHiddenColumnSelectionHolder.reset();
        GridSelection selection = this.getSelectionModel().store();
        this.resetOrderingAndVisibility();
        if (this.myResultView instanceof ResultViewWithRows) {
            ((ResultViewWithRows)((Object)this.myResultView)).resetRowHeights();
        }
        if (this.myResultView instanceof ResultViewWithColumns) {
            ((ResultViewWithColumns)this.myResultView).createDefaultColumnsFromModel();
        }
        this.myResultView.resetLayout();
        int[] modelIndices = copy.selectedModelIndices(this);
        selection.addSelectedColumns((CoreGrid)this, ModelIndexSet.forColumns((CoreGrid)this, (int[])modelIndices));
        this.getSelectionModel().restore(selection);
        if (this.isSortViaOrderBy()) {
            this.myDataHookUp.getLoader().reloadCurrentPage(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this)));
        }
    }

    @Override
    @Nullable
    public Comparator<?> getComparator(@NotNull ModelIndex<GridColumn> columnIdx) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(114);
        }
        GridColumn column = (GridColumn)this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        return this.myColumnAttributes.getComparator(column);
    }

    @Override
    @NotNull
    @NlsSafe
    public String getName(@NotNull GridColumn column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(115);
        }
        String string = this.myColumnAttributes.getName(column);
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(116);
        }
        return string;
    }

    @Override
    public void trueLayout() {
        Container parent;
        Container container = parent = this.myResultView != null ? this.myResultView.getComponent().getParent() : null;
        if (parent == null) {
            return;
        }
        Dimension size = parent.getSize();
        int colNum = this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnCount();
        this.myResultView.getComponent().setPreferredSize(colNum == 0 ? size : null);
        this.myMainResultViewComponent.revalidate();
        this.myMainResultViewComponent.repaint(50L);
    }

    @Override
    @NotNull
    public LocalFilterState getLocalFilterState() {
        LocalFilterState localFilterState = this.myLocalFilterState;
        if (localFilterState == null) {
            TableResultPanel.$$$reportNull$$$0(117);
        }
        return localFilterState;
    }

    @NotNull
    public CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.cs;
        if (coroutineScope == null) {
            TableResultPanel.$$$reportNull$$$0(118);
        }
        return coroutineScope;
    }

    @Override
    public void adaptForNewQuery() {
        this.getLocalFilterState().reset();
    }

    private void resetOrderingAndVisibility() {
        this.myColumnAttributes.resetOrdering();
        this.myColumnAttributes.resetVisibility();
        this.updateSortKeysFromColumnAttributes();
        this.updateDataOrderingIfNeeded();
        this.myResultView.orderingAndVisibilityChanged();
    }

    private void updateFloatingPaging() {
        boolean shouldFloatingPagingBePresent = FloatingPagingManager.shouldBePresent(this);
        boolean isFloatingPagingPresent = FloatingPagingManager.isPresent(this);
        if (isFloatingPagingPresent) {
            FloatingPagingManager.uninstallFrom(this, this.myLayeredPane);
        }
        if (shouldFloatingPagingBePresent) {
            FloatingPagingManager.installOn(this, this.myLayeredPane);
        }
        ActivityTracker.getInstance().inc();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 14, 16, 17, 19, 22, 24, 25, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 58, 60, 67, 68, 69, 71, 73, 74, 75, 76, 77, 78, 85, 87, 89, 98, 101, 110, 113, 116, 117, 118 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHookUp";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnHeaderActions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowHeaderActions";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 60: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 85: 
            case 87: 
            case 89: 
            case 98: 
            case 101: 
            case 110: 
            case 113: 
            case 116: 
            case 117: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/TableResultPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
            case 21: 
            case 23: 
            case 57: 
            case 62: 
            case 64: 
            case 66: 
            case 70: 
            case 72: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 90: 
            case 99: 
            case 105: 
            case 107: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchSession";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectFormatterProvider";
                break;
            }
            case 29: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 30: 
            case 52: 
            case 53: 
            case 55: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 46: 
            case 59: 
            case 88: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestSource";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 61: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 65: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRows";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewColumns";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSortOrder";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering1";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering2";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndex";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueId";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppearance";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBooleanMode";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoscrollLocker";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultView";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrder";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorColorsScheme";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkupModel";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataHookup";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawIndexConverter";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainResultViewComponent";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRows";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnambiguousColumnName";
                break;
            }
            case 58: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLanguage";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getPureDisplayType";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayType";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptimalBinaryDisplayTypeForDetect";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextColumn";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterText";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnModelModificationTracker";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderingFromModel";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrdering";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationMode";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterComponent";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFilterState";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 58: 
            case 60: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 85: 
            case 87: 
            case 89: 
            case 98: 
            case 101: 
            case 110: 
            case 113: 
            case 116: 
            case 117: 
            case 118: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addResultViewMouseListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setBooleanMode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setAnonymousColumnName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createRowHeader";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerEscapeAction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSortOrder";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getThenBySortOrder";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "searchSessionStarted";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "searchSessionStopped";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setObjectFormatterProvider";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setCells";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDataModel";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getUnambiguousColumnName";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "handleError";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "toggleSortColumns";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "sortColumns";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "sortingEquals";
                break;
            }
            case 57: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getContentLanguage";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isRowFilteredOut";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setContentLanguage";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayType";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getPureDisplayType";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayType";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getOptimalBinaryDisplayTypeForDetect";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isDisplayTypeApplicable";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "checkTextViewAllowed";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "checkSomeUUIDViewAllowed";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "checkUUIDHasKnownVersion";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isViewAllowed";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "setFilterText";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "showCell";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getFormatterConfig";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isInitiallyDisabled";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getInitialContentLanguage";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getInitialPosition";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getInitialDisplayType";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "changeSortOrder";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isSameOrdering";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "isColumnEnabled";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "setColumnEnabled";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "setRowEnabled";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "storeOrRestoreSelection";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "setPresentationMode";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToUpdate";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getComparator";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 14, 16, 17, 19, 22, 24, 25, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 58, 60, 67, 68, 69, 71, 73, 74, 75, 76, 77, 78, 85, 87, 89, 98, 101, 110, 113, 116, 117, 118 -> new IllegalStateException(string);
        };
    }

    private static class ResultViewSettings {
        MouseListener myMouseListener;
        int myVisibleRowCount;
        boolean myShowRowNumbers;
        boolean myTransparentRowHeaderBg;
        boolean myTransparentColumnHeaderBg;
        int myAdditionalRowsCount;
        boolean myShowHorizontalLines;
        boolean myStriped;
        boolean myAllowMultilineColumnLabels;
        boolean myAddSpaceForHorizontalScrollbar;
        boolean myExpandMultilineRows;
        ResultView.HoveredRowBgHighlightMode myHoveredRowBgHighlightMode = ResultView.HoveredRowBgHighlightMode.AUTO;

        private ResultViewSettings() {
        }
    }

    public static class ColumnAttributes {
        private String myAnonymousColumnName = "<anonymous>";
        private final Map<GridColumn, Attributes> myAttributesMap = new HashMap<GridColumn, Attributes>();
        private List<String> myUnambiguousColumnNames = ContainerUtil.emptyList();

        @NlsSafe
        @NotNull
        public String getName(GridColumn column) {
            String name = column.getColumnNumber() < this.myUnambiguousColumnNames.size() ? this.myUnambiguousColumnNames.get(column.getColumnNumber()) : column.getName();
            String string = StringUtil.isNotEmpty((String)name) ? name : this.myAnonymousColumnName;
            if (string == null) {
                ColumnAttributes.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public DisplayType getDisplayType(GridColumn column) {
            Attributes attributes = this.myAttributesMap.get(column);
            return attributes == null ? null : attributes.myDisplayType;
        }

        public void setDisplayType(GridColumn column, @NotNull DisplayType displayType) {
            if (displayType == null) {
                ColumnAttributes.$$$reportNull$$$0(1);
            }
            this.myAttributesMap.get((Object)column).myDisplayType = displayType;
        }

        public boolean getIsDisplayTypeAllowed(GridColumn column, @NotNull BinaryDisplayType displayType) {
            Attributes attributes;
            if (displayType == null) {
                ColumnAttributes.$$$reportNull$$$0(2);
            }
            return (attributes = this.myAttributesMap.get(column)) != null && attributes.myDisplayTypesInfoCache != null && attributes.myDisplayTypesInfoCache.allowedDisplayTypes.contains(displayType);
        }

        public void clearDisplayTypeAllowedCache(GridColumn column) {
            Attributes attributes = this.myAttributesMap.get(column);
            if (attributes != null) {
                attributes.myDisplayTypesInfoCache = null;
            }
        }

        @Nullable
        public Language getContentLanguage(GridColumn column) {
            Attributes attributes = this.myAttributesMap.get(column);
            return attributes == null ? null : attributes.myContentLanguage;
        }

        public void setContentLanguage(GridColumn column, @NotNull Language language) {
            if (language == null) {
                ColumnAttributes.$$$reportNull$$$0(3);
            }
            this.myAttributesMap.get((Object)column).myContentLanguage = language;
        }

        @Nullable
        public Comparator<GridRow> getComparator(GridColumn column) {
            Attributes attributes = this.myAttributesMap.get(column);
            return attributes == null ? null : attributes.myComparator;
        }

        @Nullable
        Boolean isEnabled(GridColumn column) {
            Attributes attributes = this.myAttributesMap.get(column);
            return attributes == null ? null : attributes.myEnabled;
        }

        public void setEnabled(GridColumn column, boolean enabled) {
            this.myAttributesMap.get((Object)column).myEnabled = enabled;
        }

        public void setIsCollapsedSubtree(GridColumn column, boolean collapsed) {
            this.myAttributesMap.get((Object)column).myIsCollapsedColumnSubtree = collapsed;
        }

        public void setHiddenDueToCollapse(GridColumn column, boolean hidden) {
            this.myAttributesMap.get((Object)column).myHiddenDueToCollapse = hidden;
        }

        @Nullable
        public Boolean isCollapsedSubtree(GridColumn column) {
            Attributes attributes = this.myAttributesMap.get(column);
            return attributes == null ? null : attributes.myIsCollapsedColumnSubtree;
        }

        @Nullable
        public Boolean isHiddenDueToCollapse(GridColumn column) {
            Attributes attributes = this.myAttributesMap.get(column);
            return attributes == null ? null : attributes.myHiddenDueToCollapse;
        }

        public int getSortOrder(GridColumn column) {
            Attributes attributes = this.myAttributesMap.get(column);
            return attributes == null || attributes.mySortOrder == null ? 0 : attributes.mySortOrder;
        }

        public void resetOrdering() {
            for (Attributes attr : this.myAttributesMap.values()) {
                attr.mySortOrder = 0;
            }
        }

        public void resetVisibility() {
            for (GridColumn column : this.myAttributesMap.keySet()) {
                this.setEnabled(column, !column.getAttributes().contains(ColumnDescriptor.Attribute.HIDDEN));
            }
        }

        public void changeSortOrder(GridColumn targetColumn, @NotNull RowSortOrder.Type targetSortOrder) {
            if (targetSortOrder == null) {
                ColumnAttributes.$$$reportNull$$$0(4);
            }
            if (this.getComparator(targetColumn) == null) {
                return;
            }
            int prevOrder = this.getSortOrder(targetColumn);
            if (prevOrder != 0 && targetSortOrder != RowSortOrder.Type.UNSORTED) {
                int prevOrderAbs = Math.abs(prevOrder);
                this.setSortOrder(targetColumn, targetSortOrder == RowSortOrder.Type.ASC ? -prevOrderAbs : prevOrderAbs);
                return;
            }
            int maxOrder = 0;
            for (GridColumn column : this.myAttributesMap.keySet()) {
                if (Comparing.equal((Object)column, (Object)targetColumn)) continue;
                int order = this.getSortOrder(column);
                if (prevOrder != 0 && Math.abs(order) > Math.abs(prevOrder)) {
                    order = order > 0 ? order - 1 : order + 1;
                    this.setSortOrder(column, order);
                }
                maxOrder = Math.max(maxOrder, Math.abs(order));
            }
            int asc = -maxOrder - 1;
            int desc = maxOrder + 1;
            int newOrder = targetSortOrder == RowSortOrder.Type.ASC ? asc : (targetSortOrder == RowSortOrder.Type.DESC ? desc : 0);
            this.setSortOrder(targetColumn, newOrder);
        }

        public int countSortedColumns() {
            int count = 0;
            for (Attributes attributes : this.myAttributesMap.values()) {
                if ((attributes == null || attributes.mySortOrder == null ? 0 : attributes.mySortOrder) == 0) continue;
                ++count;
            }
            return count;
        }

        public TreeMap<Integer, GridColumn> getSortOrderMap() {
            TreeMap<Integer, GridColumn> sortOrderMap = new TreeMap<Integer, GridColumn>();
            for (GridColumn column : this.myAttributesMap.keySet()) {
                int sortOrder = this.getSortOrder(column);
                if (sortOrder == 0) continue;
                sortOrderMap.put(Math.abs(sortOrder), column);
            }
            return sortOrderMap;
        }

        private void updateColumnNames(TableResultPanel resultPanel) {
            this.myUnambiguousColumnNames = GridHelper.get(resultPanel).getUnambiguousColumnNames(resultPanel);
        }

        public void newColumns(TableResultPanel resultPanel, Collection<GridColumn> columnsToRetain) {
            this.updateColumnNames(resultPanel);
            this.myAttributesMap.keySet().retainAll(columnsToRetain);
            GridHelper helper = GridHelper.get(resultPanel);
            columnsToRetain.stream().filter(column -> !this.myAttributesMap.containsKey(column)).forEach(column -> this.myAttributesMap.put((GridColumn)column, new Attributes(helper.createComparator((GridColumn)column))));
        }

        public void setSortOrder(GridColumn column, int sortOrder) {
            this.myAttributesMap.get((Object)column).mySortOrder = sortOrder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetSortOrder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDisplayType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIsDisplayTypeAllowed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setContentLanguage";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "changeSortOrder";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }

        static final class Attributes {
            Language myContentLanguage;
            final Comparator<GridRow> myComparator;
            Boolean myEnabled;
            Integer mySortOrder;
            DisplayType myDisplayType;
            @Nullable
            DisplayTypesInfo myDisplayTypesInfoCache;
            Boolean myHiddenDueToCollapse;
            Boolean myIsCollapsedColumnSubtree;

            Attributes(@Nullable GridRowComparator comparator) {
                this.myComparator = comparator;
            }
        }

        record DisplayTypesInfo(@NotNull Set<BinaryDisplayType> allowedDisplayTypes, boolean uuidHasKnownVersion, boolean uuidHasSwapKnownVersion) {
            @NotNull
            private final Set<BinaryDisplayType> allowedDisplayTypes;

            DisplayTypesInfo(@NotNull Set<BinaryDisplayType> allowedDisplayTypes, boolean uuidHasKnownVersion, boolean uuidHasSwapKnownVersion) {
                if (allowedDisplayTypes == null) {
                    DisplayTypesInfo.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            public Set<BinaryDisplayType> allowedDisplayTypes() {
                Set<BinaryDisplayType> set = this.allowedDisplayTypes;
                if (set == null) {
                    DisplayTypesInfo.$$$reportNull$$$0(1);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "allowedDisplayTypes";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes$DisplayTypesInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes$DisplayTypesInfo";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "allowedDisplayTypes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static class MyLoadDataPanel
    extends JPanel {
        final UIUtil.TextPainter myPainter;
        final TableResultPanel myGrid;

        MyLoadDataPanel(@NotNull TableResultPanel grid) {
            if (grid == null) {
                MyLoadDataPanel.$$$reportNull$$$0(0);
            }
            this.myPainter = EditorEmptyTextPainter.createTextPainter();
            this.myGrid = grid;
            this.setOpaque(true);
            this.myPainter.appendLine(DataGridBundle.message((String)"DataView.load.data", (Object[])new Object[0]) + " <shortcut>" + KeymapUtil.getFirstKeyboardShortcutText((String)"Refresh") + "</shortcut>");
            this.addMouseListener(new LoadingMouseListener(this, grid));
        }

        @Override
        public Color getBackground() {
            return this.myGrid == null || this.myGrid.myResultView == null ? super.getBackground() : this.myGrid.myColorsScheme.getDefaultBackground();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            UISettings.setupAntialiasing((Graphics)g);
            this.myPainter.draw(g, (width, height) -> Couple.of((Object)((this.getWidth() - width) / 2), (Object)((this.getHeight() - height) / 2)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/TableResultPanel$MyLoadDataPanel", "<init>"));
        }
    }

    public static class LayeredPaneWithSizer
    extends JBLayeredPane {
        public static final Key<Function1<LayeredPaneWithSizer, Unit>> SIZER = Key.create((String)"LayeredPaneWithSizer.SIZER");

        public void doLayout() {
            super.doLayout();
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                Component component = this.getComponent(i);
                Function1 sizer = (Function1)ClientProperty.get((Component)component, SIZER);
                if (sizer == null) {
                    component.setBounds(0, 0, this.getWidth(), this.getHeight());
                    continue;
                }
                sizer.invoke((Object)this);
            }
        }
    }

    private static class LoadingMouseListener
    extends MouseAdapter {
        final Component myComponent;
        final TableResultPanel myGrid;

        LoadingMouseListener(@NotNull Component component, @NotNull TableResultPanel grid) {
            if (component == null) {
                LoadingMouseListener.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                LoadingMouseListener.$$$reportNull$$$0(1);
            }
            this.myComponent = component;
            this.myGrid = grid;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DataGridStartupActivity.DataEditorConfigurator.isLoadingDelayed(this.myGrid)) {
                this.myGrid.getDataHookup().getLoader().reloadCurrentPage(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.myGrid)));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (DataGridStartupActivity.DataEditorConfigurator.isLoadingDelayed(this.myGrid)) {
                ResultView view = this.myGrid.myResultView;
                if (view != null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)view.getComponent(), true));
                }
            } else {
                this.myComponent.removeMouseListener(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/TableResultPanel$LoadingMouseListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

