/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.importFrom.docx;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionsBaseDialog;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownImportExportUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0014J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\b\u0010\u0013\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/docx/MarkdownImportDocxDialog;", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog;", "fileToImport", "Lcom/intellij/openapi/vfs/VirtualFile;", "importTaskTitle", "", "Lorg/jetbrains/annotations/Nls;", "importDialogTitle", "project", "Lcom/intellij/openapi/project/Project;", "suggestedFilePath", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "doAction", "", "selectedFileUrl", "getFileNameIfExist", "dir", "fileNameWithoutExtension", "removeDocxFile", "intellij.markdown"})
public final class MarkdownImportDocxDialog
extends MarkdownFileActionsBaseDialog {
    @NotNull
    private final VirtualFile fileToImport;
    @NotNull
    private final String importTaskTitle;

    public MarkdownImportDocxDialog(@NotNull VirtualFile fileToImport, @NotNull String importTaskTitle, @NotNull String importDialogTitle, @NotNull Project project, @NotNull String suggestedFilePath) {
        Intrinsics.checkNotNullParameter((Object)fileToImport, (String)"fileToImport");
        Intrinsics.checkNotNullParameter((Object)importTaskTitle, (String)"importTaskTitle");
        Intrinsics.checkNotNullParameter((Object)importDialogTitle, (String)"importDialogTitle");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestedFilePath, (String)"suggestedFilePath");
        super(project, suggestedFilePath, fileToImport);
        this.fileToImport = fileToImport;
        this.importTaskTitle = importTaskTitle;
        this.setTitle(importDialogTitle);
        this.setOKButtonText(MarkdownBundle.message("markdown.import.dialog.ok.button", new Object[0]));
    }

    @Override
    protected void doAction(@NotNull String selectedFileUrl) {
        Intrinsics.checkNotNullParameter((Object)selectedFileUrl, (String)"selectedFileUrl");
        MarkdownImportExportUtils.INSTANCE.copyAndConvertToMd(this.getProject(), this.fileToImport, selectedFileUrl, this.importTaskTitle);
        this.removeDocxFile();
    }

    @Override
    @Nullable
    protected String getFileNameIfExist(@NotNull String dir, @NotNull String fileNameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        String[] stringArray = new String[]{dir, fileNameWithoutExtension + ".md"};
        return FileUtil.exists((String)FileUtil.join((String[])stringArray)) ? fileNameWithoutExtension + ".md" : null;
    }

    private final void removeDocxFile() {
        ApplicationManager.getApplication().runWriteAction(() -> MarkdownImportDocxDialog.removeDocxFile$lambda$0(this));
    }

    private static final void removeDocxFile$lambda$0(MarkdownImportDocxDialog this$0) {
        if (this$0.fileToImport.exists()) {
            this$0.fileToImport.delete((Object)this$0);
        }
    }
}

