
#include <iostream>
#include <stdlib.h>
#include <physfs.h>

#include "ScoreBoard.h"
#include "Menu.h"


ScoreBoard::ScoreBoard()
{
	for(int i=0;i<=5;i++){
		score[i].value=0;
		score[i].name="Nobody";
	}
}

ScoreBoard::~ScoreBoard()
{
}

int ScoreBoard::IsHigh(int queryscore)
{
	if(queryscore>score[5].value)
		return 1;
	else
		return 0;
}

void ScoreBoard::NewScore(int newscore,char* newname_c)
{
	string newname;

	if(!IsHigh(newscore)) return;

	if(strlen(newname_c)==0)
		newname="Anon.";
	else
		newname=newname_c;

	if(newscore>score[5].value && newscore<score[4].value){
		score[5].value=newscore;
		score[5].name=newname;
	}
	else{
		for(int i=0;i<=4;i++){
			if(newscore>score[i].value){
				for(int a=5;a>i;a--){
					score[a].value=score[a-1].value;
					score[a].name=score[a-1].name;
				}
				score[i].value=newscore;
				score[i].name=newname;
				break;
			}
		}
	}
}

void ScoreBoard::Print()
{
	for(int i=0;i<=5;i++){
		cout << score[i].name << " : " << score[i].value << endl;
	}
}

void ScoreBoard::Display(Visual* visual)
{
	Menu* menu;
	char* labels[9];
	for(int i=0;i<8;i++){
		labels[i]=(char*)malloc(sizeof(unsigned char)*40);
	}
	strcpy(labels[0],"High Scores");
	strcpy(labels[7],"Done");
	labels[8]=NULL;
	for(int i=1;i<7;i++){
		sprintf(labels[i],"%s : %d",score[i-1].name.c_str(),score[i-1].value);
	}
	menufunc functions[]={MENU_NOSELECT,MENU_NOSELECT,MENU_NOSELECT,MENU_NOSELECT,MENU_NOSELECT,MENU_NOSELECT,MENU_NOSELECT,MENU_CONTINUE};
	void* targets[]={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};

	menu=new Menu(labels,functions,targets,visual);
	menu->solidbackground=1;
	menu->Happen();
	delete menu;

	for(int i=0;i<8;i++){
		free(labels[i]);
	}
}



void ScoreBoard::Load(char* filename)
{
	PHYSFS_file* filehandle=NULL;
	char *wholefile;
	int filelength;

	string conffile;
	string lhs;
	string rhs;
	string curline;
	char temp[64];

	int* pointd=NULL;
	string* points=NULL;

	//open the file
	filehandle=PHYSFS_openRead(filename);

	if(!filehandle){
		printf("ScoreBoard::Load: Can't open file %s\n",filename);
		printf("ScoreBoard::Load: PHYSFS says: %s\n",PHYSFS_getLastError());
		return;
	}

	//how long is it (bytes)?
	filelength=PHYSFS_fileLength(filehandle);
	
	//allocate storage for whole file
	wholefile=(char*)malloc(filelength+1);

	//dump out of file, into C string
	filelength=PHYSFS_read(filehandle,wholefile,1,filelength);
	wholefile[filelength]='\0';

	//transfer that into a C++ string
	conffile=wholefile;

	//we're done with the C string
	free(wholefile);

	//and we're done with the file
	if(!PHYSFS_close(filehandle))
		printf("ScoreBoard::Load: PHYSFS_close failed with error %s\n",PHYSFS_getLastError());

	while(conffile.find("\n",0)!=string::npos){
		curline=conffile.substr(0,conffile.find("\n",0)); //grab up to the next newline
		conffile.erase(0,conffile.find("\n",0)+1); //scrub up to and including the newline
	
		if(curline.find("=",0)==string::npos || curline.size() == 0
		 || curline.substr(0,1)=="#") //lines without equals signs, empty lines, comment lines
			continue;

		lhs=curline.substr(0,curline.find("=",0)); // lhs is up to the equals
		curline.erase(0,curline.find("=",0)+1); // curline loses up to and including the equals
		rhs=curline;                           //rhs is what's left
	
		if(lhs=="value0")
			pointd=&score[0].value;
		else if(lhs=="name0")
			points=&score[0].name;
		else if(lhs=="value1")
			pointd=&score[1].value;
		else if(lhs=="name1")
			points=&score[1].name;
		else if(lhs=="value2")
			pointd=&score[2].value;
		else if(lhs=="name2")
			points=&score[2].name;
		else if(lhs=="value3")
			pointd=&score[3].value;
		else if(lhs=="name3")
			points=&score[3].name;
		else if(lhs=="value4")
			pointd=&score[4].value;
		else if(lhs=="name4")
			points=&score[4].name;
		else if(lhs=="value5")
			pointd=&score[5].value;
		else if(lhs=="name5")
			points=&score[5].name;
		else
			cout << "ScoreBoard::Load: unrecognised parameter: " << lhs << endl;

		if(pointd!=NULL){
			sscanf(rhs.c_str(),"%d",pointd);
			pointd=NULL;
		}
		else if(points!=NULL){
			sscanf(rhs.c_str(),"%[^\n]",temp); //you'd think it would be %s, but that breaks at whitespace
			*points=temp;
			points=NULL;
		}
	}

	return;
}

void ScoreBoard::Dump(char* filename)
{
	PHYSFS_file* filehandle=NULL;
	char line[256];

	//open the file for writing
	filehandle=PHYSFS_openWrite(filename);

	if(!filehandle){
		printf("ScoreBoard::Dump: Can't open file %s\n",filename);
		printf("ScoreBoard::Dump: PHYSFS says: %s\n",PHYSFS_getLastError());
		return;
	}
	
	sprintf(line,"value0=%d\n",score[0].value);
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"name0=%s\n",score[0].name.c_str());
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"value1=%d\n",score[1].value);
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"name1=%s\n",score[1].name.c_str());
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"value2=%d\n",score[2].value);
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"name2=%s\n",score[2].name.c_str());
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"value3=%d\n",score[3].value);
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"name3=%s\n",score[3].name.c_str());
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"value4=%d\n",score[4].value);
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"name4=%s\n",score[4].name.c_str());
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"value5=%d\n",score[5].value);
	PHYSFS_write(filehandle,line,1,strlen(line));
	sprintf(line,"name5=%s\n",score[5].name.c_str());
	PHYSFS_write(filehandle,line,1,strlen(line));

	//and we're done with the file
	if(!PHYSFS_close(filehandle))
		printf("ScoreBoard::Load: PHYSFS_close failed with error %s\n",PHYSFS_getLastError());
}
