/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/



#ifndef PLAYER_H
#define PLAYER_H

#include "Vector.h"
#include "Game.h"
#include "PowerUp.h"

class Player{
public:
	void Physics();
	void Collide();
	int	SafeToRespawn();
	void Respawn();
	void Unspawn();
	void Explode();
	Player(Game* newgame);
	~Player();
	void FireMissile();
  void ShootCannon();
  void StartCannon();
  void StopCannon();
	void TriggerShield();
	void GivePowerUp(poweruptype);
	void Hurt(float pain);
	Game* game;

	Vector s;
	Vector v;
	Vector a;
	float thrust;

	float strafea;
	float strafev;

	float bear; //RADIANS!
	float bearv;
	float beara;
	float bouncecycle;
	float shieldeffect;
	float maxshieldeffect;
	float collideradius;
	float collideradius2;
	float radarrange;

	int cannonfiring;
	float cannonwait;
	float cannonperiod;

	Vector tracer;
	Vector tracersource;

	float hp;
	int alive;
	int lives;
	float highlightlives;     //if >0, life icons flash (set from GiveLife)

	poweruptype powerup;
	float poweruptimer;
	float maxpoweruptimer;

	int soundid;

	int collideflag;
	
};

#endif //PLAYER_H
