/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyPathRenderer;
import classycle.dependency.PatternVertexCondition;
import classycle.graph.NameAttributes;
import classycle.graph.Vertex;
import classycle.graph.VertexCondition;
import classycle.util.StringPattern;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyPathsRenderer {
    private static final String INDENT = "  ";
    private final Vertex[] _graph;
    private final VertexCondition _startSetCondition;
    private final VertexCondition _finalSetCondition;
    private final Set<Vertex> _vertices = new HashSet<Vertex>();

    public DependencyPathsRenderer(Vertex[] graph, StringPattern startSetPattern, StringPattern finalSetPattern) {
        this(graph, new PatternVertexCondition(startSetPattern), new PatternVertexCondition(finalSetPattern));
    }

    public DependencyPathsRenderer(Vertex[] graph, VertexCondition startSetCondition, VertexCondition finalSetCondition) {
        this._graph = graph;
        this._startSetCondition = startSetCondition;
        this._finalSetCondition = finalSetCondition;
        for (int i = 0; i < graph.length; ++i) {
            this._vertices.add(graph[i]);
        }
    }

    public String renderGraph(final String lineStart) {
        final StringBuffer buffer = new StringBuffer();
        DependencyPathRenderer renderer = new DependencyPathRenderer(){
            String _start;
            private int _indentation;
            {
                this._start = '\n' + lineStart;
            }

            public void increaseIndentation() {
                ++this._indentation;
            }

            public void add(String nodeName) {
                buffer.append(this._start);
                for (int i = 0; i < this._indentation; ++i) {
                    buffer.append(DependencyPathsRenderer.INDENT);
                }
                if (this._indentation > 0) {
                    buffer.append("-> ");
                }
                buffer.append(nodeName);
            }

            public void decreaseIndentation() {
                --this._indentation;
            }
        };
        this.renderGraph(renderer);
        return new String(buffer);
    }

    public void renderGraph(DependencyPathRenderer renderer) {
        HashSet<Vertex> visitedVertices = new HashSet<Vertex>();
        for (int i = 0; i < this._graph.length; ++i) {
            Vertex vertex = this._graph[i];
            if (!this._startSetCondition.isFulfilled(vertex)) continue;
            renderer.add(this.getNameOf(vertex));
            this.renderPaths(renderer, vertex, visitedVertices);
        }
    }

    private void renderPaths(DependencyPathRenderer renderer, Vertex vertex, Set<Vertex> visitedVertices) {
        visitedVertices.add(vertex);
        renderer.increaseIndentation();
        int n = vertex.getNumberOfOutgoingArcs();
        for (int i = 0; i < n; ++i) {
            Vertex headVertex = vertex.getHeadVertex(i);
            if (!this._vertices.contains(headVertex) || this._startSetCondition.isFulfilled(headVertex)) continue;
            renderer.add(this.getNameOf(headVertex));
            if (this._finalSetCondition.isFulfilled(headVertex) || visitedVertices.contains(headVertex)) continue;
            this.renderPaths(renderer, headVertex, visitedVertices);
        }
        renderer.decreaseIndentation();
    }

    private String getNameOf(Vertex vertex) {
        return ((NameAttributes)vertex.getAttributes()).getName();
    }
}

