/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PomReader {
    private static final String PACKAGING = "packaging";
    private static final String DEPENDENCY = "dependency";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEPENDENCY_MGT = "dependencyManagement";
    private static final String PROJECT = "project";
    private static final String MODEL = "model";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String DESCRIPTION = "description";
    private static final String HOMEPAGE = "url";
    private static final String LICENSES = "licenses";
    private static final String LICENSE = "license";
    private static final String LICENSE_NAME = "name";
    private static final String LICENSE_URL = "url";
    private static final String PARENT = "parent";
    private static final String SCOPE = "scope";
    private static final String CLASSIFIER = "classifier";
    private static final String OPTIONAL = "optional";
    private static final String EXCLUSIONS = "exclusions";
    private static final String EXCLUSION = "exclusion";
    private static final String DISTRIBUTION_MGT = "distributionManagement";
    private static final String RELOCATION = "relocation";
    private static final String PROPERTIES = "properties";
    private static final String PLUGINS = "plugins";
    private static final String PLUGIN = "plugin";
    private static final String TYPE = "type";
    private HashMap properties = new HashMap();
    private final Element projectElement;
    private final Element parentElement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomReader(URL uRL, Resource resource) throws IOException, SAXException {
        AddDTDFilterInputStream addDTDFilterInputStream = new AddDTDFilterInputStream(URLHandlerRegistry.getDefault().openStream(uRL));
        InputSource inputSource = new InputSource(addDTDFilterInputStream);
        inputSource.setSystemId(XMLHelper.toSystemId(uRL));
        try {
            Document document = XMLHelper.parseToDom(inputSource, new EntityResolver(){

                @Override
                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    if (string2 != null && string2.endsWith("m2-entities.ent")) {
                        return new InputSource(PomReader.class.getResourceAsStream("m2-entities.ent"));
                    }
                    return null;
                }
            });
            this.projectElement = document.getDocumentElement();
            if (!PROJECT.equals(this.projectElement.getNodeName()) && !MODEL.equals(this.projectElement.getNodeName())) {
                throw new SAXParseException("project must be the root tag", resource.getName(), resource.getName(), 0, 0);
            }
            this.parentElement = PomReader.getFirstChildElement(this.projectElement, PARENT);
        }
        finally {
            try {
                ((InputStream)addDTDFilterInputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean hasParent() {
        return this.parentElement != null;
    }

    public void setProperty(String string, String string2) {
        if (!this.properties.containsKey(string) && string2 != null) {
            this.properties.put(string, string2);
        }
    }

    public String getGroupId() {
        String string = PomReader.getFirstChildText(this.projectElement, GROUP_ID);
        if (string == null) {
            string = PomReader.getFirstChildText(this.parentElement, GROUP_ID);
        }
        return this.replaceProps(string);
    }

    public String getParentGroupId() {
        String string = PomReader.getFirstChildText(this.parentElement, GROUP_ID);
        if (string == null) {
            string = PomReader.getFirstChildText(this.projectElement, GROUP_ID);
        }
        return this.replaceProps(string);
    }

    public String getArtifactId() {
        String string = PomReader.getFirstChildText(this.projectElement, ARTIFACT_ID);
        if (string == null) {
            string = PomReader.getFirstChildText(this.parentElement, ARTIFACT_ID);
        }
        return this.replaceProps(string);
    }

    public String getParentArtifactId() {
        String string = PomReader.getFirstChildText(this.parentElement, ARTIFACT_ID);
        if (string == null) {
            string = PomReader.getFirstChildText(this.projectElement, ARTIFACT_ID);
        }
        return this.replaceProps(string);
    }

    public String getVersion() {
        String string = PomReader.getFirstChildText(this.projectElement, VERSION);
        if (string == null) {
            string = PomReader.getFirstChildText(this.parentElement, VERSION);
        }
        return this.replaceProps(string);
    }

    public String getParentVersion() {
        String string = PomReader.getFirstChildText(this.parentElement, VERSION);
        if (string == null) {
            string = PomReader.getFirstChildText(this.projectElement, VERSION);
        }
        return this.replaceProps(string);
    }

    public String getPackaging() {
        String string = PomReader.getFirstChildText(this.projectElement, PACKAGING);
        if (string == null) {
            string = "jar";
        }
        return string;
    }

    public String getHomePage() {
        String string = PomReader.getFirstChildText(this.projectElement, "url");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getDescription() {
        String string = PomReader.getFirstChildText(this.projectElement, DESCRIPTION);
        if (string == null) {
            string = "";
        }
        return string.trim();
    }

    public License[] getLicenses() {
        Element element = PomReader.getFirstChildElement(this.projectElement, LICENSES);
        if (element == null) {
            return new License[0];
        }
        element.normalize();
        ArrayList<License> arrayList = new ArrayList<License>();
        for (Element element2 : PomReader.getAllChilds(element)) {
            if (!LICENSE.equals(element2.getNodeName())) continue;
            String string = PomReader.getFirstChildText(element2, LICENSE_NAME);
            String string2 = PomReader.getFirstChildText(element2, "url");
            if (string == null && string2 == null) continue;
            if (string == null) {
                string = "Unknown License";
            }
            arrayList.add(new License(string, string2));
        }
        return arrayList.toArray(new License[arrayList.size()]);
    }

    public ModuleRevisionId getRelocation() {
        Element element = PomReader.getFirstChildElement(this.projectElement, DISTRIBUTION_MGT);
        Element element2 = PomReader.getFirstChildElement(element, RELOCATION);
        if (element2 == null) {
            return null;
        }
        String string = PomReader.getFirstChildText(element2, GROUP_ID);
        String string2 = PomReader.getFirstChildText(element2, ARTIFACT_ID);
        String string3 = PomReader.getFirstChildText(element2, VERSION);
        string = string == null ? this.getGroupId() : string;
        string2 = string2 == null ? this.getArtifactId() : string2;
        string3 = string3 == null ? this.getVersion() : string3;
        return ModuleRevisionId.newInstance(string, string2, string3);
    }

    public List getDependencies() {
        Element element = PomReader.getFirstChildElement(this.projectElement, DEPENDENCIES);
        LinkedList<PomDependencyData> linkedList = new LinkedList<PomDependencyData>();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
                linkedList.add(new PomDependencyData((Element)node));
            }
        }
        return linkedList;
    }

    public List getDependencyMgt() {
        Element element = PomReader.getFirstChildElement(this.projectElement, DEPENDENCY_MGT);
        element = PomReader.getFirstChildElement(element, DEPENDENCIES);
        LinkedList<PomDependencyMgtElement> linkedList = new LinkedList<PomDependencyMgtElement>();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
                linkedList.add(new PomDependencyMgtElement((Element)node));
            }
        }
        return linkedList;
    }

    public List getPlugins() {
        LinkedList<PomPluginElement> linkedList = new LinkedList<PomPluginElement>();
        Element element = PomReader.getFirstChildElement(this.projectElement, "build");
        if (element == null) {
            return linkedList;
        }
        Element element2 = PomReader.getFirstChildElement(element, PLUGINS);
        if (element2 != null) {
            NodeList nodeList = element2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !PLUGIN.equals(node.getNodeName())) continue;
                linkedList.add(new PomPluginElement((Element)node));
            }
        }
        return linkedList;
    }

    public Map getPomProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Element element = PomReader.getFirstChildElement(this.projectElement, PROPERTIES);
        if (element != null) {
            element.normalize();
        }
        for (Element element2 : PomReader.getAllChilds(element)) {
            hashMap.put(element2.getNodeName(), PomReader.getTextContent(element2));
        }
        return hashMap;
    }

    private String replaceProps(String string) {
        if (string == null) {
            return null;
        }
        return IvyPatternHelper.substituteVariables(string, this.properties).trim();
    }

    private static String getTextContent(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        block3: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    stringBuffer.append(node.getNodeValue());
                    continue block3;
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String getFirstChildText(Element element, String string) {
        Element element2 = PomReader.getFirstChildElement(element, string);
        if (element2 != null) {
            return PomReader.getTextContent(element2);
        }
        return null;
    }

    private static Element getFirstChildElement(Element element, String string) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    private static List getAllChilds(Element element) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                linkedList.add(node);
            }
        }
        return linkedList;
    }

    private static final class AddDTDFilterInputStream
    extends FilterInputStream {
        private static final int MARK = 10000;
        private static final String DOCTYPE = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n";
        private int count;
        private byte[] prefix = "<!DOCTYPE project SYSTEM \"m2-entities.ent\">\n".getBytes();

        private AddDTDFilterInputStream(InputStream inputStream) throws IOException {
            super(new BufferedInputStream(inputStream));
            this.in.mark(10000);
            int n = this.in.read();
            int n2 = this.in.read();
            int n3 = this.in.read();
            if (n == 239 && n2 == 187 && n3 == 191) {
                this.in.mark(10000);
            } else {
                this.in.reset();
            }
            int n4 = 0;
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.in, "UTF-8"), 100);
            String string = lineNumberReader.readLine();
            if (string != null) {
                String string2 = string.trim();
                if (string2.startsWith("<?xml ")) {
                    int n5 = string2.indexOf("?>");
                    String string3 = string2.substring(0, n5 + 2);
                    this.prefix = (string3 + "\n" + DOCTYPE).getBytes();
                    n4 = string3.getBytes().length;
                }
            } else {
                this.prefix = new byte[0];
            }
            this.in.reset();
            for (int i = 0; i < n4; ++i) {
                this.in.read();
            }
        }

        @Override
        public int read() throws IOException {
            if (this.count < this.prefix.length) {
                return this.prefix[this.count++];
            }
            int n = super.read();
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            if (this.count < this.prefix.length) {
                int n4 = Math.min(this.prefix.length - this.count, n2);
                System.arraycopy(this.prefix, this.count, byArray, n, n4);
                n3 = n4;
            }
            if (n3 < n2) {
                n3 += this.in.read(byArray, n + n3, n2 - n3);
            }
            this.count += n3;
            return n3;
        }
    }

    public class PomDependencyData
    extends PomDependencyMgtElement {
        private final Element depElement;

        public PomDependencyData(PomDependencyData pomDependencyData) {
            this(pomDependencyData.depElement);
        }

        PomDependencyData(Element element) {
            super(element);
            this.depElement = element;
        }

        @Override
        public String getScope() {
            String string = PomReader.getFirstChildText(this.depElement, PomReader.SCOPE);
            return PomReader.this.replaceProps(string);
        }

        public String getClassifier() {
            String string = PomReader.getFirstChildText(this.depElement, PomReader.CLASSIFIER);
            return PomReader.this.replaceProps(string);
        }

        public String getType() {
            String string = PomReader.getFirstChildText(this.depElement, PomReader.TYPE);
            return PomReader.this.replaceProps(string);
        }

        public boolean isOptional() {
            Element element = PomReader.getFirstChildElement(this.depElement, PomReader.OPTIONAL);
            return element != null && "true".equalsIgnoreCase(PomReader.getTextContent(element));
        }
    }

    public class PomPluginElement
    implements PomDependencyMgt {
        private Element pluginElement;

        PomPluginElement(Element element) {
            this.pluginElement = element;
        }

        @Override
        public String getGroupId() {
            String string = PomReader.getFirstChildText(this.pluginElement, PomReader.GROUP_ID);
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getArtifactId() {
            String string = PomReader.getFirstChildText(this.pluginElement, PomReader.ARTIFACT_ID);
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getVersion() {
            String string = PomReader.getFirstChildText(this.pluginElement, PomReader.VERSION);
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getScope() {
            return null;
        }

        @Override
        public List getExcludedModules() {
            return Collections.EMPTY_LIST;
        }
    }

    public class PomDependencyMgtElement
    implements PomDependencyMgt {
        private final Element depElement;

        public PomDependencyMgtElement(PomDependencyMgtElement pomDependencyMgtElement) {
            this(pomDependencyMgtElement.depElement);
        }

        PomDependencyMgtElement(Element element) {
            this.depElement = element;
        }

        @Override
        public String getGroupId() {
            String string = PomReader.getFirstChildText(this.depElement, PomReader.GROUP_ID);
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getArtifactId() {
            String string = PomReader.getFirstChildText(this.depElement, PomReader.ARTIFACT_ID);
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getVersion() {
            String string = PomReader.getFirstChildText(this.depElement, PomReader.VERSION);
            return PomReader.this.replaceProps(string);
        }

        @Override
        public String getScope() {
            String string = PomReader.getFirstChildText(this.depElement, PomReader.SCOPE);
            return PomReader.this.replaceProps(string);
        }

        @Override
        public List getExcludedModules() {
            Element element = PomReader.getFirstChildElement(this.depElement, PomReader.EXCLUSIONS);
            LinkedList<ModuleId> linkedList = new LinkedList<ModuleId>();
            if (element != null) {
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !PomReader.EXCLUSION.equals(node.getNodeName())) continue;
                    String string = PomReader.getFirstChildText((Element)node, PomReader.GROUP_ID);
                    String string2 = PomReader.getFirstChildText((Element)node, PomReader.ARTIFACT_ID);
                    if (string == null || string2 == null) continue;
                    linkedList.add(ModuleId.newInstance(string, string2));
                }
            }
            return linkedList;
        }
    }
}

