/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp;

import com.jsuereth.pgp.KeyNotFoundException;
import com.jsuereth.pgp.PublicKeyLike;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Security;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public abstract class PublicKeyLike$class {
    public static final boolean verifyMessageFile(PublicKeyLike $this, File input, File output) {
        FileInputStream in = new FileInputStream(input);
        FileOutputStream out = new FileOutputStream(output);
        try {
            return $this.verifyMessageStream(in, out);
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static final String verifyMessageString(PublicKeyLike $this, String input) {
        ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Predef$.MODULE$.assert($this.verifyMessageStream(in, out));
        return out.toString(Charset.defaultCharset().name());
    }

    public static final boolean verifySignatureFile(PublicKeyLike $this, File raw, File signature) {
        FileInputStream in = new FileInputStream(raw);
        FileInputStream in2 = new FileInputStream(signature);
        try {
            return $this.verifySignatureStreams(in, in2);
        }
        finally {
            in.close();
            in2.close();
        }
    }

    public static final boolean verifySignatureString(PublicKeyLike $this, String msg, String signature) {
        ByteArrayInputStream in = new ByteArrayInputStream(msg.getBytes());
        ByteArrayInputStream in2 = new ByteArrayInputStream(signature.getBytes());
        try {
            return $this.verifySignatureStreams(in, in2);
        }
        finally {
            in.close();
            in2.close();
        }
    }

    public static boolean verifyMessageStreamHelper(PublicKeyLike $this, InputStream input, OutputStream output, Function1 getKey2) {
        InputStream in = PGPUtil.getDecoderStream((InputStream)input);
        JcaPGPObjectFactory tmp = new JcaPGPObjectFactory(in);
        PGPCompressedData c1 = (PGPCompressedData)tmp.nextObject();
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
        PGPOnePassSignatureList sigList = (PGPOnePassSignatureList)pgpFact.nextObject();
        PGPOnePassSignature ops = sigList.get(0);
        PGPLiteralData p2 = (PGPLiteralData)pgpFact.nextObject();
        InputStream dIn = p2.getInputStream();
        PGPPublicKey key2 = (PGPPublicKey)getKey2.apply((Object)BoxesRunTime.boxToLong((long)ops.getKeyID()));
        ops.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider(Security.getProvider("BC")), key2);
        int ch = dIn.read();
        while (ch >= 0) {
            ops.update((byte)ch);
            output.write(ch);
            ch = dIn.read();
        }
        PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
        return ops.verify(p3.get(0));
    }

    public static boolean verifySignatureStreamsHelper(PublicKeyLike $this, InputStream msg, InputStream signature, Function1 getKey2) {
        Object object;
        block8: {
            Tuple2 tuple2;
            block7: {
                JcaPGPObjectFactory pgpFact;
                block6: {
                    InputStream in = PGPUtil.getDecoderStream((InputStream)signature);
                    pgpFact = new JcaPGPObjectFactory(in);
                    Object o = pgpFact.nextObject();
                    object = o;
                    if (!(object instanceof PGPCompressedData)) break block6;
                    PGPCompressedData pGPCompressedData = (PGPCompressedData)object;
                    tuple2 = new Tuple2((Object)((PGPSignatureList)pgpFact.nextObject()), (Object)new JcaPGPObjectFactory(pGPCompressedData.getDataStream()));
                    break block7;
                }
                if (!(object instanceof PGPSignatureList)) break block8;
                PGPSignatureList pGPSignatureList = (PGPSignatureList)object;
                tuple2 = new Tuple2((Object)pGPSignatureList, (Object)pgpFact);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                PGPSignatureList sigList = (PGPSignatureList)tuple22._1();
                JcaPGPObjectFactory pgpFact = (JcaPGPObjectFactory)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)sigList, (Object)pgpFact);
                PGPSignatureList sigList2 = (PGPSignatureList)tuple24._1();
                JcaPGPObjectFactory pgpFact2 = (JcaPGPObjectFactory)tuple24._2();
                BufferedInputStream dIn = new BufferedInputStream(msg);
                PGPSignature sig = sigList2.get(0);
                PGPPublicKey pGPPublicKey = (PGPPublicKey)getKey2.apply((Object)BoxesRunTime.boxToLong((long)sig.getKeyID()));
                if (pGPPublicKey == null) {
                    throw new KeyNotFoundException(sig.getKeyID());
                }
                sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider(Security.getProvider("BC")), pGPPublicKey);
                int ch = dIn.read();
                while (ch >= 0) {
                    sig.update((byte)ch);
                    ch = dIn.read();
                }
                dIn.close();
                boolean bl = sig.verify();
                return bl;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError(object);
    }

    public static void $init$(PublicKeyLike $this) {
    }
}

