/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "callbacks.h"
#include "shared.h"


  void
on_main_window_destroy(
    GObject *object,
    gpointer   user_data)
{
  Cleanup();
  gtk_main_quit();
}


  gboolean
on_main_window_delete_event(
    GtkWidget *widget,
    GdkEvent  *event,
    gpointer   user_data)
{
  GtkBuilder *builder;
  if( isFlagSet(ACTION_FLAGS_ALL) )
  {
    if( !quit_dialog )
    {
      quit_dialog = create_quit_dialog( &builder );
      gtk_widget_show( quit_dialog );
      g_object_unref( builder );
    }
  }
  else
  {
    Cleanup();
    gtk_main_quit();
  }

  return TRUE;
}


  gboolean
on_viewport_button_press_event(
    GtkWidget      *widget,
    GdkEventButton *event,
    gpointer        user_data)
{
  if( event->button == 3 ) Popup_Menu();
  return TRUE;
}


  void
on_receive_togglebutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  Receive_Togglebutton_Toggled( togglebutton );
}


  void
on_normalize_togglebutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
    SetFlag( IMAGE_NORMALIZE );
  else
    ClearFlag( IMAGE_NORMALIZE );
}


  void
on_colorize_togglebutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
    SetFlag( IMAGE_COLORIZE );
  else
    ClearFlag( IMAGE_COLORIZE );
}


  void
on_invert_togglebutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
    SetFlag( IMAGE_ROTATE );
  else
    ClearFlag( IMAGE_ROTATE );
}


  void
on_level_setup_togglebutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  if( isFlagSet(START_STOP_TIMER) )
    return;

  /* Run signal level setup function */
  if( gtk_toggle_button_get_active(togglebutton) )
  {
    SetFlag( ACTION_SETUP_AUDIO );
    Show_Message( _("Starting signal level setup "), "black" );
    g_idle_add( Setup_Signal_Level, NULL );
  } /* if( isFlagClear(ACTION_SETUP_AUDIO) ) */
  else
    ClearFlag( ACTION_SETUP_AUDIO );
}


  void
on_operation_timer_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  timer_dialog = create_timer_dialog( &timer_dialog_builder );
  gtk_widget_show( timer_dialog );
}


  void
on_start_stop_timer_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  startstop_timer = create_startstop_timer( &startstop_builder );
  gtk_widget_show( startstop_timer );
}


  void
on_cancel_timer_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  g_idle_add( Cancel_Timer, NULL );
}


  void
on_decode_from_dsp_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  SetFlag( ACTION_PROCESS_DSP );

  /* Open file chooser dialog */
  File_Chooser();

  /* Offer a default image file name */
  File_Name( image_file );
  gtk_file_chooser_set_filename(
      GTK_FILE_CHOOSER(filechooser), image_file );
}


  void
on_record_to_file_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  char record_path[64];
  int idx;

  /* Open file chooser dialog */
  SetFlag( ACTION_RECORD_APT );
  File_Chooser();

  /* Offer a default name for the samples file */
  File_Name( samples_file );
  gtk_file_chooser_set_current_name(
      GTK_FILE_CHOOSER(filechooser), samples_file );

  /* Find the directory intended for saving */
  size_t s = sizeof( record_path );
  Strlcpy( record_path, samples_file, s );
  for( idx = (int)s - 1; idx > 0; idx-- )
  {
    if( record_path[idx] == '/' ) break;
    record_path[idx] = '\0';
  }
  gtk_file_chooser_set_current_folder(
      GTK_FILE_CHOOSER(filechooser), record_path );

}


  void
on_decode_from_file_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  char record_path[64];

  SetFlag( ACTION_PROCESS_FILE );

  /* Open file chooser dialog */
  File_Chooser();
  gtk_file_chooser_set_action(
      GTK_FILE_CHOOSER(filechooser), GTK_FILE_CHOOSER_ACTION_OPEN );

  /* Offer the default 'record/' directory for opening a samples file */
  size_t s = sizeof( record_path );
  Strlcpy( record_path, rc_data.xwxapt_dir, s );
  Strlcat( record_path, "record/", s );
  gtk_file_chooser_set_current_folder(
      GTK_FILE_CHOOSER(filechooser), record_path );
}


  void
on_stop_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  ClearFlag( ACTION_FLAGS_ALL );
}


  void
on_quit_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  GtkBuilder *builder;
  if( isFlagSet(ACTION_FLAGS_ALL) )
  {
    if( !quit_dialog )
    {
      quit_dialog = create_quit_dialog( &builder );
      gtk_widget_show( quit_dialog );
      g_object_unref( builder );
    }
  }
  else
  {
    Cleanup();
    gtk_main_quit();
  }
}


  void
on_filechooser_response(
    GtkDialog *dialog,
    gint       response_id,
    gpointer   user_data)
{
  Filechooser_Response( response_id );
}


  void
on_filechooser_destroy(
    GObject *object,
    gpointer user_data)
{
  filechooser = NULL;
}


  void
on_timer_okbutton_clicked(
    GtkButton *button,
    gpointer   user_data)
{
  Timeout_Setup( button );
}


  gboolean
on_error_dialog_delete_event(
    GtkWidget *widget,
    GdkEvent  *event,
    gpointer   user_data)
{
  return TRUE;
}


  void
on_error_dialog_destroy(
    GObject *object,
    gpointer    user_data)
{
  error_dialog = NULL;
}


  void
on_quit_dialog_destroy(
    GObject *object,
    gpointer    user_data)
{
  quit_dialog = NULL;
}


  void
on_timer_dialog_destroy(
    GObject *object,
    gpointer    user_data)
{
  timer_dialog = NULL;
}


  void
on_startstop_timer_destroy(
    GObject *object,
    gpointer    user_data)
{
  startstop_timer = NULL;
}


  void
on_error_ok_button_clicked(
    GtkButton *button,
    gpointer   user_data)
{
  gtk_widget_destroy( error_dialog );
}


  void
on_error_quit_button_clicked(
    GtkButton *button,
    gpointer   user_data)
{
  Cleanup();
  gtk_main_quit();
}


  void
on_hrs_entry_changed(
    GtkEditable *editable,
    gpointer     user_data)
{
  Hours_Entry( editable );
}


  void
on_min_entry_changed(
    GtkEditable *editable,
    gpointer     user_data)
{
  Minutes_Entry( editable );
}


  void
on_startstop_cancel_clicked(
    GtkButton *button,
    gpointer   user_data)
{
  gtk_widget_destroy( startstop_timer );
}


  void
on_startstop_ok_clicked(
    GtkButton *button,
    gpointer   user_data)
{
  Start_Stop_OK_Clicked( button );
}


  void
on_quit_cancel_button_clicked(
    GtkButton *button,
    gpointer   user_data)
{
  gtk_widget_destroy( quit_dialog );
}


  void
on_quit_button_clicked(
    GtkButton *button,
    gpointer   user_data)
{
  Cleanup();
  gtk_main_quit();
}


  void
on_noaa15_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  rc_data.rtlsdr_center_freq = 137620000;
  sat_type = NOAA_15;
  Initialize_Top_Window();

  /* Enter center freq to relevant entry widget */
  Enter_Center_Freq( rc_data.rtlsdr_center_freq );
}


  void
on_noaa18_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  rc_data.rtlsdr_center_freq = 137912500;
  sat_type = NOAA_18;
  Initialize_Top_Window();

  /* Enter center freq to relevant entry widget */
  Enter_Center_Freq( rc_data.rtlsdr_center_freq );
}


  void
on_noaa19_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  rc_data.rtlsdr_center_freq = 137100000;
  sat_type = NOAA_19;
  Initialize_Top_Window();

  /* Enter center freq to relevant entry widget */
  Enter_Center_Freq( rc_data.rtlsdr_center_freq );
}


  void
on_meteor_activate(
    GtkMenuItem *menuitem,
    gpointer     user_data)
{
  rc_data.rtlsdr_center_freq = 137100000; /* ?? Sat is now extinct */
  sat_type = METEOR;
  Initialize_Top_Window();

  /* Enter center freq to relevant entry widget */
  Enter_Center_Freq( rc_data.rtlsdr_center_freq );
}



  gboolean
on_ifft_drawingarea_draw(
    GtkWidget *widget,
    cairo_t   *cr,
    gpointer   user_data)
{
  if( wfall_pixbuf != NULL )
  {
    gdk_cairo_set_source_pixbuf( cr, wfall_pixbuf, 0.0, 0.0 );
    cairo_paint( cr );
    return( TRUE );
  }
  return( FALSE );
}


  gboolean
on_demod_drawingarea_draw(
    GtkWidget *widget,
    cairo_t   *cr,
    gpointer   user_data)
{
  /* Draw scope background */
  if( isFlagClear(ENABLE_SCOPE) )
  {
    cairo_set_source_rgb( cr, 0.0, 0.3, 0.0 );
    cairo_rectangle( cr, 0.0, 0.0,
        (double)scope_width, (double)scope_height );
    cairo_fill( cr );
  }
  else Draw_Signal( cr );
  return( TRUE );
}


  void
on_gain_hscale_value_changed(
    GtkRange *range,
    gpointer  user_data)
{
  if( isFlagClear(RTLSDR_INIT) ||
      isFlagClear(TUNER_GAIN_MANL) )
    return;
  gdouble gain = gtk_range_get_value( range );
  Set_Tuner_Gain( gain );
}


  void
on_auto_checkbutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  if( isFlagClear(RTLSDR_INIT) ) return;
  if( gtk_toggle_button_get_active(togglebutton) )
  {
    Set_Tuner_Gain_Mode( TUNER_GAIN_AUTO );
    ClearFlag(TUNER_GAIN_MANL);
  }
  else
  {
    Set_Tuner_Gain_Mode( TUNER_GAIN_MANUAL );
    SetFlag(TUNER_GAIN_MANL);
  }
}


  void
on_offset_checkbutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
    SetFlag( ENABLE_DOPPLER_CORR );
  else
    ClearFlag( ENABLE_DOPPLER_CORR );
}


  void
on_bw_entry_activate(
    GtkEntry *entry,
    gpointer  user_data)
{
  BW_Entry_Activate( entry );
}


  void
on_freq_entry_activate(
    GtkEntry *entry,
    gpointer  user_data)
{
  /* Get center freq value in Hz, entry value is in kHz */
  double khz = atof( gtk_entry_get_text(entry) );
  rc_data.rtlsdr_center_freq = (uint32_t)( khz * 1000.0 );
  if( isFlagSet(RTLSDR_INIT) )
    Rtlsdr_Set_Center_Freq( rc_data.rtlsdr_center_freq );
}


  void
on_dagc_checkbutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  if( isFlagClear(RTLSDR_INIT) ) return;
  if( gtk_toggle_button_get_active(togglebutton) )
    Rtlsdr_Set_Agc_Mode( RTL_DAGC_ON );
  else
    Rtlsdr_Set_Agc_Mode( RTL_DAGC_OFF );
}


  void
on_subcarrier_radiobutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  ClearFlag( CARRIER_SPECTRUM );
  rc_data.ifft_decimate = IFFT_SUBCARRIER_DECIMATE;
  rc_data.ifft_scale = IFFT_DET_SCALE;
}


  void
on_carrier_radiobutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  SetFlag( CARRIER_SPECTRUM );
  rc_data.ifft_decimate = IFFT_RTLSDR_DECIMATE;
  rc_data.ifft_scale = IFFT_SDR_SCALE;
}

