#[cfg(feature = "Win32_System_Search_Common")]
pub mod Common;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn ODBCGetTryWaitValue() -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ODBCGetTryWaitValue() -> u32;
    }
    ODBCGetTryWaitValue()
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ODBCSetTryWaitValue(dwvalue: u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn ODBCSetTryWaitValue(dwvalue: u32) -> super::super::Foundation::BOOL;
    }
    ODBCSetTryWaitValue(dwvalue)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLAllocConnect(environmenthandle: *mut ::core::ffi::c_void, connectionhandle: *mut *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLAllocConnect(environmenthandle: *mut ::core::ffi::c_void, connectionhandle: *mut *mut ::core::ffi::c_void) -> i16;
    }
    SQLAllocConnect(::core::mem::transmute(environmenthandle), ::core::mem::transmute(connectionhandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLAllocEnv(environmenthandle: *mut *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLAllocEnv(environmenthandle: *mut *mut ::core::ffi::c_void) -> i16;
    }
    SQLAllocEnv(::core::mem::transmute(environmenthandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLAllocHandle(handletype: i16, inputhandle: *mut ::core::ffi::c_void, outputhandle: *mut *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLAllocHandle(handletype: i16, inputhandle: *mut ::core::ffi::c_void, outputhandle: *mut *mut ::core::ffi::c_void) -> i16;
    }
    SQLAllocHandle(handletype, ::core::mem::transmute(inputhandle), ::core::mem::transmute(outputhandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLAllocHandleStd(fhandletype: i16, hinput: *mut ::core::ffi::c_void, phoutput: *mut *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLAllocHandleStd(fhandletype: i16, hinput: *mut ::core::ffi::c_void, phoutput: *mut *mut ::core::ffi::c_void) -> i16;
    }
    SQLAllocHandleStd(fhandletype, ::core::mem::transmute(hinput), ::core::mem::transmute(phoutput))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLAllocStmt(connectionhandle: *mut ::core::ffi::c_void, statementhandle: *mut *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLAllocStmt(connectionhandle: *mut ::core::ffi::c_void, statementhandle: *mut *mut ::core::ffi::c_void) -> i16;
    }
    SQLAllocStmt(::core::mem::transmute(connectionhandle), ::core::mem::transmute(statementhandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLBindCol(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, targettype: i16, targetvalue: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i64, strlen_or_ind: ::core::option::Option<*mut i64>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLBindCol(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, targettype: i16, targetvalue: *mut ::core::ffi::c_void, bufferlength: i64, strlen_or_ind: *mut i64) -> i16;
    }
    SQLBindCol(::core::mem::transmute(statementhandle), columnnumber, targettype, ::core::mem::transmute(targetvalue.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(strlen_or_ind.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLBindCol(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, targettype: i16, targetvalue: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i32, strlen_or_ind: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLBindCol(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, targettype: i16, targetvalue: *mut ::core::ffi::c_void, bufferlength: i32, strlen_or_ind: *mut i32) -> i16;
    }
    SQLBindCol(::core::mem::transmute(statementhandle), columnnumber, targettype, ::core::mem::transmute(targetvalue.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(strlen_or_ind.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLBindParam(statementhandle: *mut ::core::ffi::c_void, parameternumber: u16, valuetype: i16, parametertype: i16, lengthprecision: u64, parameterscale: i16, parametervalue: *mut ::core::ffi::c_void, strlen_or_ind: *mut i64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLBindParam(statementhandle: *mut ::core::ffi::c_void, parameternumber: u16, valuetype: i16, parametertype: i16, lengthprecision: u64, parameterscale: i16, parametervalue: *mut ::core::ffi::c_void, strlen_or_ind: *mut i64) -> i16;
    }
    SQLBindParam(::core::mem::transmute(statementhandle), parameternumber, valuetype, parametertype, lengthprecision, parameterscale, ::core::mem::transmute(parametervalue), ::core::mem::transmute(strlen_or_ind))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLBindParam(statementhandle: *mut ::core::ffi::c_void, parameternumber: u16, valuetype: i16, parametertype: i16, lengthprecision: u32, parameterscale: i16, parametervalue: *mut ::core::ffi::c_void, strlen_or_ind: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLBindParam(statementhandle: *mut ::core::ffi::c_void, parameternumber: u16, valuetype: i16, parametertype: i16, lengthprecision: u32, parameterscale: i16, parametervalue: *mut ::core::ffi::c_void, strlen_or_ind: *mut i32) -> i16;
    }
    SQLBindParam(::core::mem::transmute(statementhandle), parameternumber, valuetype, parametertype, lengthprecision, parameterscale, ::core::mem::transmute(parametervalue), ::core::mem::transmute(strlen_or_ind))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLBindParameter(hstmt: *mut ::core::ffi::c_void, ipar: u16, fparamtype: i16, fctype: i16, fsqltype: i16, cbcoldef: u64, ibscale: i16, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i64, pcbvalue: *mut i64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLBindParameter(hstmt: *mut ::core::ffi::c_void, ipar: u16, fparamtype: i16, fctype: i16, fsqltype: i16, cbcoldef: u64, ibscale: i16, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i64, pcbvalue: *mut i64) -> i16;
    }
    SQLBindParameter(::core::mem::transmute(hstmt), ipar, fparamtype, fctype, fsqltype, cbcoldef, ibscale, ::core::mem::transmute(rgbvalue), cbvaluemax, ::core::mem::transmute(pcbvalue))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLBindParameter(hstmt: *mut ::core::ffi::c_void, ipar: u16, fparamtype: i16, fctype: i16, fsqltype: i16, cbcoldef: u32, ibscale: i16, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i32, pcbvalue: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLBindParameter(hstmt: *mut ::core::ffi::c_void, ipar: u16, fparamtype: i16, fctype: i16, fsqltype: i16, cbcoldef: u32, ibscale: i16, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i32, pcbvalue: *mut i32) -> i16;
    }
    SQLBindParameter(::core::mem::transmute(hstmt), ipar, fparamtype, fctype, fsqltype, cbcoldef, ibscale, ::core::mem::transmute(rgbvalue), cbvaluemax, ::core::mem::transmute(pcbvalue))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLBrowseConnect(hdbc: *mut ::core::ffi::c_void, szconnstrin: &[u8], szconnstrout: ::core::option::Option<&mut [u8]>, pcchconnstrout: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLBrowseConnect(hdbc: *mut ::core::ffi::c_void, szconnstrin: *const u8, cchconnstrin: i16, szconnstrout: *mut u8, cchconnstroutmax: i16, pcchconnstrout: *mut i16) -> i16;
    }
    SQLBrowseConnect(::core::mem::transmute(hdbc), ::core::mem::transmute(szconnstrin.as_ptr()), szconnstrin.len() as _, ::core::mem::transmute(szconnstrout.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szconnstrout.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcchconnstrout.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLBrowseConnectA(hdbc: *mut ::core::ffi::c_void, szconnstrin: &[u8], szconnstrout: ::core::option::Option<&mut [u8]>, pcbconnstrout: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLBrowseConnectA(hdbc: *mut ::core::ffi::c_void, szconnstrin: *const u8, cbconnstrin: i16, szconnstrout: *mut u8, cbconnstroutmax: i16, pcbconnstrout: *mut i16) -> i16;
    }
    SQLBrowseConnectA(::core::mem::transmute(hdbc), ::core::mem::transmute(szconnstrin.as_ptr()), szconnstrin.len() as _, ::core::mem::transmute(szconnstrout.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szconnstrout.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcbconnstrout.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLBrowseConnectW(hdbc: *mut ::core::ffi::c_void, szconnstrin: &[u16], szconnstrout: ::core::option::Option<&mut [u16]>, pcchconnstrout: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLBrowseConnectW(hdbc: *mut ::core::ffi::c_void, szconnstrin: *const u16, cchconnstrin: i16, szconnstrout: *mut u16, cchconnstroutmax: i16, pcchconnstrout: *mut i16) -> i16;
    }
    SQLBrowseConnectW(::core::mem::transmute(hdbc), ::core::mem::transmute(szconnstrin.as_ptr()), szconnstrin.len() as _, ::core::mem::transmute(szconnstrout.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szconnstrout.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcchconnstrout.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLBulkOperations(statementhandle: *mut ::core::ffi::c_void, operation: i16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLBulkOperations(statementhandle: *mut ::core::ffi::c_void, operation: i16) -> i16;
    }
    SQLBulkOperations(::core::mem::transmute(statementhandle), operation)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLCancel(statementhandle: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLCancel(statementhandle: *mut ::core::ffi::c_void) -> i16;
    }
    SQLCancel(::core::mem::transmute(statementhandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLCancelHandle(handletype: i16, inputhandle: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLCancelHandle(handletype: i16, inputhandle: *mut ::core::ffi::c_void) -> i16;
    }
    SQLCancelHandle(handletype, ::core::mem::transmute(inputhandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLCloseCursor(statementhandle: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLCloseCursor(statementhandle: *mut ::core::ffi::c_void) -> i16;
    }
    SQLCloseCursor(::core::mem::transmute(statementhandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SQLCloseEnumServers<'a, P0>(henumhandle: P0) -> i16
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLCloseEnumServers(henumhandle: super::super::Foundation::HANDLE) -> i16;
    }
    SQLCloseEnumServers(henumhandle.into())
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLColAttribute(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, fieldidentifier: u16, characterattribute: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i16, stringlength: ::core::option::Option<*mut i16>, numericattribute: ::core::option::Option<*mut i64>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttribute(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, fieldidentifier: u16, characterattribute: *mut ::core::ffi::c_void, bufferlength: i16, stringlength: *mut i16, numericattribute: *mut i64) -> i16;
    }
    SQLColAttribute(::core::mem::transmute(statementhandle), columnnumber, fieldidentifier, ::core::mem::transmute(characterattribute.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(stringlength.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(numericattribute.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLColAttribute(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, fieldidentifier: u16, characterattribute: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i16, stringlength: ::core::option::Option<*mut i16>, numericattribute: ::core::option::Option<*mut ::core::ffi::c_void>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttribute(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, fieldidentifier: u16, characterattribute: *mut ::core::ffi::c_void, bufferlength: i16, stringlength: *mut i16, numericattribute: *mut ::core::ffi::c_void) -> i16;
    }
    SQLColAttribute(::core::mem::transmute(statementhandle), columnnumber, fieldidentifier, ::core::mem::transmute(characterattribute.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(stringlength.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(numericattribute.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLColAttributeA(hstmt: *mut ::core::ffi::c_void, icol: i16, ifield: i16, pcharattr: ::core::option::Option<*mut ::core::ffi::c_void>, cbcharattrmax: i16, pcbcharattr: ::core::option::Option<*mut i16>, pnumattr: ::core::option::Option<*mut i64>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttributeA(hstmt: *mut ::core::ffi::c_void, icol: i16, ifield: i16, pcharattr: *mut ::core::ffi::c_void, cbcharattrmax: i16, pcbcharattr: *mut i16, pnumattr: *mut i64) -> i16;
    }
    SQLColAttributeA(::core::mem::transmute(hstmt), icol, ifield, ::core::mem::transmute(pcharattr.unwrap_or(::std::ptr::null_mut())), cbcharattrmax, ::core::mem::transmute(pcbcharattr.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pnumattr.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLColAttributeA(hstmt: *mut ::core::ffi::c_void, icol: i16, ifield: i16, pcharattr: ::core::option::Option<*mut ::core::ffi::c_void>, cbcharattrmax: i16, pcbcharattr: ::core::option::Option<*mut i16>, pnumattr: ::core::option::Option<*mut ::core::ffi::c_void>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttributeA(hstmt: *mut ::core::ffi::c_void, icol: i16, ifield: i16, pcharattr: *mut ::core::ffi::c_void, cbcharattrmax: i16, pcbcharattr: *mut i16, pnumattr: *mut ::core::ffi::c_void) -> i16;
    }
    SQLColAttributeA(::core::mem::transmute(hstmt), icol, ifield, ::core::mem::transmute(pcharattr.unwrap_or(::std::ptr::null_mut())), cbcharattrmax, ::core::mem::transmute(pcbcharattr.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pnumattr.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLColAttributeW(hstmt: *mut ::core::ffi::c_void, icol: u16, ifield: u16, pcharattr: ::core::option::Option<*mut ::core::ffi::c_void>, cbdescmax: i16, pcbcharattr: ::core::option::Option<*mut i16>, pnumattr: ::core::option::Option<*mut i64>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttributeW(hstmt: *mut ::core::ffi::c_void, icol: u16, ifield: u16, pcharattr: *mut ::core::ffi::c_void, cbdescmax: i16, pcbcharattr: *mut i16, pnumattr: *mut i64) -> i16;
    }
    SQLColAttributeW(::core::mem::transmute(hstmt), icol, ifield, ::core::mem::transmute(pcharattr.unwrap_or(::std::ptr::null_mut())), cbdescmax, ::core::mem::transmute(pcbcharattr.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pnumattr.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLColAttributeW(hstmt: *mut ::core::ffi::c_void, icol: u16, ifield: u16, pcharattr: ::core::option::Option<*mut ::core::ffi::c_void>, cbdescmax: i16, pcbcharattr: ::core::option::Option<*mut i16>, pnumattr: ::core::option::Option<*mut ::core::ffi::c_void>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttributeW(hstmt: *mut ::core::ffi::c_void, icol: u16, ifield: u16, pcharattr: *mut ::core::ffi::c_void, cbdescmax: i16, pcbcharattr: *mut i16, pnumattr: *mut ::core::ffi::c_void) -> i16;
    }
    SQLColAttributeW(::core::mem::transmute(hstmt), icol, ifield, ::core::mem::transmute(pcharattr.unwrap_or(::std::ptr::null_mut())), cbdescmax, ::core::mem::transmute(pcbcharattr.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pnumattr.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLColAttributes(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: *mut ::core::ffi::c_void, cbdescmax: i16, pcbdesc: *mut i16, pfdesc: *mut i64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttributes(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: *mut ::core::ffi::c_void, cbdescmax: i16, pcbdesc: *mut i16, pfdesc: *mut i64) -> i16;
    }
    SQLColAttributes(::core::mem::transmute(hstmt), icol, fdesctype, ::core::mem::transmute(rgbdesc), cbdescmax, ::core::mem::transmute(pcbdesc), ::core::mem::transmute(pfdesc))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLColAttributes(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: *mut ::core::ffi::c_void, cbdescmax: i16, pcbdesc: *mut i16, pfdesc: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttributes(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: *mut ::core::ffi::c_void, cbdescmax: i16, pcbdesc: *mut i16, pfdesc: *mut i32) -> i16;
    }
    SQLColAttributes(::core::mem::transmute(hstmt), icol, fdesctype, ::core::mem::transmute(rgbdesc), cbdescmax, ::core::mem::transmute(pcbdesc), ::core::mem::transmute(pfdesc))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLColAttributesA(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: ::core::option::Option<*mut ::core::ffi::c_void>, cbdescmax: i16, pcbdesc: ::core::option::Option<*mut i16>, pfdesc: ::core::option::Option<*mut i64>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttributesA(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: *mut ::core::ffi::c_void, cbdescmax: i16, pcbdesc: *mut i16, pfdesc: *mut i64) -> i16;
    }
    SQLColAttributesA(::core::mem::transmute(hstmt), icol, fdesctype, ::core::mem::transmute(rgbdesc.unwrap_or(::std::ptr::null_mut())), cbdescmax, ::core::mem::transmute(pcbdesc.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pfdesc.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLColAttributesA(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: ::core::option::Option<*mut ::core::ffi::c_void>, cbdescmax: i16, pcbdesc: ::core::option::Option<*mut i16>, pfdesc: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttributesA(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: *mut ::core::ffi::c_void, cbdescmax: i16, pcbdesc: *mut i16, pfdesc: *mut i32) -> i16;
    }
    SQLColAttributesA(::core::mem::transmute(hstmt), icol, fdesctype, ::core::mem::transmute(rgbdesc.unwrap_or(::std::ptr::null_mut())), cbdescmax, ::core::mem::transmute(pcbdesc.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pfdesc.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLColAttributesW(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: ::core::option::Option<*mut ::core::ffi::c_void>, cbdescmax: i16, pcbdesc: ::core::option::Option<*mut i16>, pfdesc: ::core::option::Option<*mut i64>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttributesW(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: *mut ::core::ffi::c_void, cbdescmax: i16, pcbdesc: *mut i16, pfdesc: *mut i64) -> i16;
    }
    SQLColAttributesW(::core::mem::transmute(hstmt), icol, fdesctype, ::core::mem::transmute(rgbdesc.unwrap_or(::std::ptr::null_mut())), cbdescmax, ::core::mem::transmute(pcbdesc.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pfdesc.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLColAttributesW(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: ::core::option::Option<*mut ::core::ffi::c_void>, cbdescmax: i16, pcbdesc: ::core::option::Option<*mut i16>, pfdesc: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColAttributesW(hstmt: *mut ::core::ffi::c_void, icol: u16, fdesctype: u16, rgbdesc: *mut ::core::ffi::c_void, cbdescmax: i16, pcbdesc: *mut i16, pfdesc: *mut i32) -> i16;
    }
    SQLColAttributesW(::core::mem::transmute(hstmt), icol, fdesctype, ::core::mem::transmute(rgbdesc.unwrap_or(::std::ptr::null_mut())), cbdescmax, ::core::mem::transmute(pcbdesc.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pfdesc.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLColumnPrivileges(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, sztablename: ::core::option::Option<&[u8]>, szcolumnname: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColumnPrivileges(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cchcatalogname: i16, szschemaname: *const u8, cchschemaname: i16, sztablename: *const u8, cchtablename: i16, szcolumnname: *const u8, cchcolumnname: i16) -> i16;
    }
    SQLColumnPrivileges(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szcolumnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolumnname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLColumnPrivilegesA(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, sztablename: ::core::option::Option<&[u8]>, szcolumnname: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColumnPrivilegesA(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cbcatalogname: i16, szschemaname: *const u8, cbschemaname: i16, sztablename: *const u8, cbtablename: i16, szcolumnname: *const u8, cbcolumnname: i16) -> i16;
    }
    SQLColumnPrivilegesA(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szcolumnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolumnname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLColumnPrivilegesW(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u16]>, szschemaname: ::core::option::Option<&[u16]>, sztablename: ::core::option::Option<&[u16]>, szcolumnname: ::core::option::Option<&[u16]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColumnPrivilegesW(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u16, cchcatalogname: i16, szschemaname: *const u16, cchschemaname: i16, sztablename: *const u16, cchtablename: i16, szcolumnname: *const u16, cchcolumnname: i16) -> i16;
    }
    SQLColumnPrivilegesW(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szcolumnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolumnname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLColumns(statementhandle: *mut ::core::ffi::c_void, catalogname: ::core::option::Option<&[u8]>, schemaname: ::core::option::Option<&[u8]>, tablename: ::core::option::Option<&[u8]>, columnname: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColumns(statementhandle: *mut ::core::ffi::c_void, catalogname: *const u8, namelength1: i16, schemaname: *const u8, namelength2: i16, tablename: *const u8, namelength3: i16, columnname: *const u8, namelength4: i16) -> i16;
    }
    SQLColumns(
        ::core::mem::transmute(statementhandle),
        ::core::mem::transmute(catalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        catalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(schemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        schemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(tablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        tablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(columnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        columnname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLColumnsA(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, sztablename: ::core::option::Option<&[u8]>, szcolumnname: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColumnsA(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cbcatalogname: i16, szschemaname: *const u8, cbschemaname: i16, sztablename: *const u8, cbtablename: i16, szcolumnname: *const u8, cbcolumnname: i16) -> i16;
    }
    SQLColumnsA(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szcolumnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolumnname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLColumnsW(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u16]>, szschemaname: ::core::option::Option<&[u16]>, sztablename: ::core::option::Option<&[u16]>, szcolumnname: ::core::option::Option<&[u16]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLColumnsW(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u16, cchcatalogname: i16, szschemaname: *const u16, cchschemaname: i16, sztablename: *const u16, cchtablename: i16, szcolumnname: *const u16, cchcolumnname: i16) -> i16;
    }
    SQLColumnsW(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szcolumnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolumnname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLCompleteAsync(handletype: i16, handle: *mut ::core::ffi::c_void, asyncretcodeptr: *mut i16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLCompleteAsync(handletype: i16, handle: *mut ::core::ffi::c_void, asyncretcodeptr: *mut i16) -> i16;
    }
    SQLCompleteAsync(handletype, ::core::mem::transmute(handle), ::core::mem::transmute(asyncretcodeptr))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLConnect(connectionhandle: *mut ::core::ffi::c_void, servername: &[u8], username: &[u8], authentication: &[u8]) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLConnect(connectionhandle: *mut ::core::ffi::c_void, servername: *const u8, namelength1: i16, username: *const u8, namelength2: i16, authentication: *const u8, namelength3: i16) -> i16;
    }
    SQLConnect(::core::mem::transmute(connectionhandle), ::core::mem::transmute(servername.as_ptr()), servername.len() as _, ::core::mem::transmute(username.as_ptr()), username.len() as _, ::core::mem::transmute(authentication.as_ptr()), authentication.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLConnectA(hdbc: *mut ::core::ffi::c_void, szdsn: &[u8], szuid: &[u8], szauthstr: &[u8]) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLConnectA(hdbc: *mut ::core::ffi::c_void, szdsn: *const u8, cbdsn: i16, szuid: *const u8, cbuid: i16, szauthstr: *const u8, cbauthstr: i16) -> i16;
    }
    SQLConnectA(::core::mem::transmute(hdbc), ::core::mem::transmute(szdsn.as_ptr()), szdsn.len() as _, ::core::mem::transmute(szuid.as_ptr()), szuid.len() as _, ::core::mem::transmute(szauthstr.as_ptr()), szauthstr.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLConnectW(hdbc: *mut ::core::ffi::c_void, szdsn: &[u16], szuid: &[u16], szauthstr: &[u16]) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLConnectW(hdbc: *mut ::core::ffi::c_void, szdsn: *const u16, cchdsn: i16, szuid: *const u16, cchuid: i16, szauthstr: *const u16, cchauthstr: i16) -> i16;
    }
    SQLConnectW(::core::mem::transmute(hdbc), ::core::mem::transmute(szdsn.as_ptr()), szdsn.len() as _, ::core::mem::transmute(szuid.as_ptr()), szuid.len() as _, ::core::mem::transmute(szauthstr.as_ptr()), szauthstr.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLCopyDesc(sourcedeschandle: *mut ::core::ffi::c_void, targetdeschandle: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLCopyDesc(sourcedeschandle: *mut ::core::ffi::c_void, targetdeschandle: *mut ::core::ffi::c_void) -> i16;
    }
    SQLCopyDesc(::core::mem::transmute(sourcedeschandle), ::core::mem::transmute(targetdeschandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLDataSources(environmenthandle: *mut ::core::ffi::c_void, direction: u16, servername: ::core::option::Option<&mut [u8]>, namelength1ptr: ::core::option::Option<*mut i16>, description: ::core::option::Option<&mut [u8]>, namelength2ptr: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDataSources(environmenthandle: *mut ::core::ffi::c_void, direction: u16, servername: *mut u8, bufferlength1: i16, namelength1ptr: *mut i16, description: *mut u8, bufferlength2: i16, namelength2ptr: *mut i16) -> i16;
    }
    SQLDataSources(
        ::core::mem::transmute(environmenthandle),
        direction,
        ::core::mem::transmute(servername.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        servername.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(namelength1ptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(description.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        description.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(namelength2ptr.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLDataSourcesA(henv: *mut ::core::ffi::c_void, fdirection: u16, szdsn: ::core::option::Option<&mut [u8]>, pcbdsn: *mut i16, szdescription: ::core::option::Option<&mut [u8]>, pcbdescription: *mut i16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDataSourcesA(henv: *mut ::core::ffi::c_void, fdirection: u16, szdsn: *mut u8, cbdsnmax: i16, pcbdsn: *mut i16, szdescription: *mut u8, cbdescriptionmax: i16, pcbdescription: *mut i16) -> i16;
    }
    SQLDataSourcesA(::core::mem::transmute(henv), fdirection, ::core::mem::transmute(szdsn.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szdsn.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcbdsn), ::core::mem::transmute(szdescription.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szdescription.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcbdescription))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLDataSourcesW(henv: *mut ::core::ffi::c_void, fdirection: u16, szdsn: ::core::option::Option<&mut [u16]>, pcchdsn: ::core::option::Option<*mut i16>, wszdescription: ::core::option::Option<&mut [u16]>, pcchdescription: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDataSourcesW(henv: *mut ::core::ffi::c_void, fdirection: u16, szdsn: *mut u16, cchdsnmax: i16, pcchdsn: *mut i16, wszdescription: *mut u16, cchdescriptionmax: i16, pcchdescription: *mut i16) -> i16;
    }
    SQLDataSourcesW(
        ::core::mem::transmute(henv),
        fdirection,
        ::core::mem::transmute(szdsn.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szdsn.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcchdsn.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(wszdescription.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        wszdescription.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcchdescription.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLDescribeCol(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, columnname: ::core::option::Option<&mut [u8]>, namelength: ::core::option::Option<*mut i16>, datatype: ::core::option::Option<*mut i16>, columnsize: ::core::option::Option<*mut u64>, decimaldigits: ::core::option::Option<*mut i16>, nullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDescribeCol(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, columnname: *mut u8, bufferlength: i16, namelength: *mut i16, datatype: *mut i16, columnsize: *mut u64, decimaldigits: *mut i16, nullable: *mut i16) -> i16;
    }
    SQLDescribeCol(
        ::core::mem::transmute(statementhandle),
        columnnumber,
        ::core::mem::transmute(columnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        columnname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(namelength.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(datatype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(columnsize.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(decimaldigits.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(nullable.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLDescribeCol(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, columnname: ::core::option::Option<&mut [u8]>, namelength: ::core::option::Option<*mut i16>, datatype: ::core::option::Option<*mut i16>, columnsize: ::core::option::Option<*mut u32>, decimaldigits: ::core::option::Option<*mut i16>, nullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDescribeCol(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, columnname: *mut u8, bufferlength: i16, namelength: *mut i16, datatype: *mut i16, columnsize: *mut u32, decimaldigits: *mut i16, nullable: *mut i16) -> i16;
    }
    SQLDescribeCol(
        ::core::mem::transmute(statementhandle),
        columnnumber,
        ::core::mem::transmute(columnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        columnname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(namelength.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(datatype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(columnsize.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(decimaldigits.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(nullable.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLDescribeColA(hstmt: *mut ::core::ffi::c_void, icol: u16, szcolname: ::core::option::Option<&mut [u8]>, pcbcolname: ::core::option::Option<*mut i16>, pfsqltype: ::core::option::Option<*mut i16>, pcbcoldef: ::core::option::Option<*mut u64>, pibscale: ::core::option::Option<*mut i16>, pfnullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDescribeColA(hstmt: *mut ::core::ffi::c_void, icol: u16, szcolname: *mut u8, cbcolnamemax: i16, pcbcolname: *mut i16, pfsqltype: *mut i16, pcbcoldef: *mut u64, pibscale: *mut i16, pfnullable: *mut i16) -> i16;
    }
    SQLDescribeColA(
        ::core::mem::transmute(hstmt),
        icol,
        ::core::mem::transmute(szcolname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcbcolname.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfsqltype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pcbcoldef.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pibscale.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfnullable.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLDescribeColA(hstmt: *mut ::core::ffi::c_void, icol: u16, szcolname: ::core::option::Option<&mut [u8]>, pcbcolname: ::core::option::Option<*mut i16>, pfsqltype: ::core::option::Option<*mut i16>, pcbcoldef: ::core::option::Option<*mut u32>, pibscale: ::core::option::Option<*mut i16>, pfnullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDescribeColA(hstmt: *mut ::core::ffi::c_void, icol: u16, szcolname: *mut u8, cbcolnamemax: i16, pcbcolname: *mut i16, pfsqltype: *mut i16, pcbcoldef: *mut u32, pibscale: *mut i16, pfnullable: *mut i16) -> i16;
    }
    SQLDescribeColA(
        ::core::mem::transmute(hstmt),
        icol,
        ::core::mem::transmute(szcolname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcbcolname.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfsqltype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pcbcoldef.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pibscale.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfnullable.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLDescribeColW(hstmt: *mut ::core::ffi::c_void, icol: u16, szcolname: ::core::option::Option<&mut [u16]>, pcchcolname: ::core::option::Option<*mut i16>, pfsqltype: ::core::option::Option<*mut i16>, pcbcoldef: ::core::option::Option<*mut u64>, pibscale: ::core::option::Option<*mut i16>, pfnullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDescribeColW(hstmt: *mut ::core::ffi::c_void, icol: u16, szcolname: *mut u16, cchcolnamemax: i16, pcchcolname: *mut i16, pfsqltype: *mut i16, pcbcoldef: *mut u64, pibscale: *mut i16, pfnullable: *mut i16) -> i16;
    }
    SQLDescribeColW(
        ::core::mem::transmute(hstmt),
        icol,
        ::core::mem::transmute(szcolname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcchcolname.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfsqltype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pcbcoldef.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pibscale.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfnullable.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLDescribeColW(hstmt: *mut ::core::ffi::c_void, icol: u16, szcolname: ::core::option::Option<&mut [u16]>, pcchcolname: ::core::option::Option<*mut i16>, pfsqltype: ::core::option::Option<*mut i16>, pcbcoldef: ::core::option::Option<*mut u32>, pibscale: ::core::option::Option<*mut i16>, pfnullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDescribeColW(hstmt: *mut ::core::ffi::c_void, icol: u16, szcolname: *mut u16, cchcolnamemax: i16, pcchcolname: *mut i16, pfsqltype: *mut i16, pcbcoldef: *mut u32, pibscale: *mut i16, pfnullable: *mut i16) -> i16;
    }
    SQLDescribeColW(
        ::core::mem::transmute(hstmt),
        icol,
        ::core::mem::transmute(szcolname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcchcolname.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfsqltype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pcbcoldef.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pibscale.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfnullable.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLDescribeParam(hstmt: *mut ::core::ffi::c_void, ipar: u16, pfsqltype: ::core::option::Option<*mut i16>, pcbparamdef: ::core::option::Option<*mut u64>, pibscale: ::core::option::Option<*mut i16>, pfnullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDescribeParam(hstmt: *mut ::core::ffi::c_void, ipar: u16, pfsqltype: *mut i16, pcbparamdef: *mut u64, pibscale: *mut i16, pfnullable: *mut i16) -> i16;
    }
    SQLDescribeParam(::core::mem::transmute(hstmt), ipar, ::core::mem::transmute(pfsqltype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbparamdef.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pibscale.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pfnullable.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLDescribeParam(hstmt: *mut ::core::ffi::c_void, ipar: u16, pfsqltype: ::core::option::Option<*mut i16>, pcbparamdef: ::core::option::Option<*mut u32>, pibscale: ::core::option::Option<*mut i16>, pfnullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDescribeParam(hstmt: *mut ::core::ffi::c_void, ipar: u16, pfsqltype: *mut i16, pcbparamdef: *mut u32, pibscale: *mut i16, pfnullable: *mut i16) -> i16;
    }
    SQLDescribeParam(::core::mem::transmute(hstmt), ipar, ::core::mem::transmute(pfsqltype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbparamdef.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pibscale.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pfnullable.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLDisconnect(connectionhandle: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDisconnect(connectionhandle: *mut ::core::ffi::c_void) -> i16;
    }
    SQLDisconnect(::core::mem::transmute(connectionhandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLDriverConnect(hdbc: *mut ::core::ffi::c_void, hwnd: isize, szconnstrin: &[u8], szconnstrout: ::core::option::Option<&mut [u8]>, pcchconnstrout: ::core::option::Option<*mut i16>, fdrivercompletion: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDriverConnect(hdbc: *mut ::core::ffi::c_void, hwnd: isize, szconnstrin: *const u8, cchconnstrin: i16, szconnstrout: *mut u8, cchconnstroutmax: i16, pcchconnstrout: *mut i16, fdrivercompletion: u16) -> i16;
    }
    SQLDriverConnect(::core::mem::transmute(hdbc), hwnd, ::core::mem::transmute(szconnstrin.as_ptr()), szconnstrin.len() as _, ::core::mem::transmute(szconnstrout.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szconnstrout.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcchconnstrout.unwrap_or(::std::ptr::null_mut())), fdrivercompletion)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLDriverConnectA(hdbc: *mut ::core::ffi::c_void, hwnd: isize, szconnstrin: &[u8], szconnstrout: ::core::option::Option<&mut [u8]>, pcbconnstrout: ::core::option::Option<*mut i16>, fdrivercompletion: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDriverConnectA(hdbc: *mut ::core::ffi::c_void, hwnd: isize, szconnstrin: *const u8, cbconnstrin: i16, szconnstrout: *mut u8, cbconnstroutmax: i16, pcbconnstrout: *mut i16, fdrivercompletion: u16) -> i16;
    }
    SQLDriverConnectA(::core::mem::transmute(hdbc), hwnd, ::core::mem::transmute(szconnstrin.as_ptr()), szconnstrin.len() as _, ::core::mem::transmute(szconnstrout.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szconnstrout.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcbconnstrout.unwrap_or(::std::ptr::null_mut())), fdrivercompletion)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLDriverConnectW(hdbc: *mut ::core::ffi::c_void, hwnd: isize, szconnstrin: &[u16], szconnstrout: ::core::option::Option<&mut [u16]>, pcchconnstrout: ::core::option::Option<*mut i16>, fdrivercompletion: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDriverConnectW(hdbc: *mut ::core::ffi::c_void, hwnd: isize, szconnstrin: *const u16, cchconnstrin: i16, szconnstrout: *mut u16, cchconnstroutmax: i16, pcchconnstrout: *mut i16, fdrivercompletion: u16) -> i16;
    }
    SQLDriverConnectW(::core::mem::transmute(hdbc), hwnd, ::core::mem::transmute(szconnstrin.as_ptr()), szconnstrin.len() as _, ::core::mem::transmute(szconnstrout.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szconnstrout.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcchconnstrout.unwrap_or(::std::ptr::null_mut())), fdrivercompletion)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLDrivers(henv: *mut ::core::ffi::c_void, fdirection: u16, szdriverdesc: ::core::option::Option<&mut [u8]>, pcchdriverdesc: ::core::option::Option<*mut i16>, szdriverattributes: ::core::option::Option<&mut [u8]>, pcchdrvrattr: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDrivers(henv: *mut ::core::ffi::c_void, fdirection: u16, szdriverdesc: *mut u8, cchdriverdescmax: i16, pcchdriverdesc: *mut i16, szdriverattributes: *mut u8, cchdrvrattrmax: i16, pcchdrvrattr: *mut i16) -> i16;
    }
    SQLDrivers(
        ::core::mem::transmute(henv),
        fdirection,
        ::core::mem::transmute(szdriverdesc.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szdriverdesc.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcchdriverdesc.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(szdriverattributes.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szdriverattributes.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcchdrvrattr.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLDriversA(henv: *mut ::core::ffi::c_void, fdirection: u16, szdriverdesc: ::core::option::Option<&mut [u8]>, pcbdriverdesc: ::core::option::Option<*mut i16>, szdriverattributes: ::core::option::Option<&mut [u8]>, pcbdrvrattr: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDriversA(henv: *mut ::core::ffi::c_void, fdirection: u16, szdriverdesc: *mut u8, cbdriverdescmax: i16, pcbdriverdesc: *mut i16, szdriverattributes: *mut u8, cbdrvrattrmax: i16, pcbdrvrattr: *mut i16) -> i16;
    }
    SQLDriversA(
        ::core::mem::transmute(henv),
        fdirection,
        ::core::mem::transmute(szdriverdesc.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szdriverdesc.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcbdriverdesc.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(szdriverattributes.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szdriverattributes.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcbdrvrattr.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLDriversW(henv: *mut ::core::ffi::c_void, fdirection: u16, szdriverdesc: ::core::option::Option<&mut [u16]>, pcchdriverdesc: ::core::option::Option<*mut i16>, szdriverattributes: ::core::option::Option<&mut [u16]>, pcchdrvrattr: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLDriversW(henv: *mut ::core::ffi::c_void, fdirection: u16, szdriverdesc: *mut u16, cchdriverdescmax: i16, pcchdriverdesc: *mut i16, szdriverattributes: *mut u16, cchdrvrattrmax: i16, pcchdrvrattr: *mut i16) -> i16;
    }
    SQLDriversW(
        ::core::mem::transmute(henv),
        fdirection,
        ::core::mem::transmute(szdriverdesc.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szdriverdesc.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcchdriverdesc.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(szdriverattributes.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szdriverattributes.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcchdrvrattr.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLEndTran(handletype: i16, handle: *mut ::core::ffi::c_void, completiontype: i16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLEndTran(handletype: i16, handle: *mut ::core::ffi::c_void, completiontype: i16) -> i16;
    }
    SQLEndTran(handletype, ::core::mem::transmute(handle), completiontype)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLError(environmenthandle: *mut ::core::ffi::c_void, connectionhandle: *mut ::core::ffi::c_void, statementhandle: *mut ::core::ffi::c_void, sqlstate: &mut [u8; 6], nativeerror: ::core::option::Option<*mut i32>, messagetext: ::core::option::Option<&mut [u8]>, textlength: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLError(environmenthandle: *mut ::core::ffi::c_void, connectionhandle: *mut ::core::ffi::c_void, statementhandle: *mut ::core::ffi::c_void, sqlstate: *mut u8, nativeerror: *mut i32, messagetext: *mut u8, bufferlength: i16, textlength: *mut i16) -> i16;
    }
    SQLError(::core::mem::transmute(environmenthandle), ::core::mem::transmute(connectionhandle), ::core::mem::transmute(statementhandle), ::core::mem::transmute(sqlstate.as_ptr()), ::core::mem::transmute(nativeerror.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(messagetext.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), messagetext.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(textlength.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLErrorA(henv: *mut ::core::ffi::c_void, hdbc: *mut ::core::ffi::c_void, hstmt: *mut ::core::ffi::c_void, szsqlstate: *mut u8, pfnativeerror: ::core::option::Option<*mut i32>, szerrormsg: ::core::option::Option<&mut [u8]>, pcberrormsg: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLErrorA(henv: *mut ::core::ffi::c_void, hdbc: *mut ::core::ffi::c_void, hstmt: *mut ::core::ffi::c_void, szsqlstate: *mut u8, pfnativeerror: *mut i32, szerrormsg: *mut u8, cberrormsgmax: i16, pcberrormsg: *mut i16) -> i16;
    }
    SQLErrorA(::core::mem::transmute(henv), ::core::mem::transmute(hdbc), ::core::mem::transmute(hstmt), ::core::mem::transmute(szsqlstate), ::core::mem::transmute(pfnativeerror.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(szerrormsg.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szerrormsg.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcberrormsg.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLErrorW(henv: *mut ::core::ffi::c_void, hdbc: *mut ::core::ffi::c_void, hstmt: *mut ::core::ffi::c_void, wszsqlstate: &mut [u16; 6], pfnativeerror: ::core::option::Option<*mut i32>, wszerrormsg: ::core::option::Option<&mut [u16]>, pccherrormsg: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLErrorW(henv: *mut ::core::ffi::c_void, hdbc: *mut ::core::ffi::c_void, hstmt: *mut ::core::ffi::c_void, wszsqlstate: *mut u16, pfnativeerror: *mut i32, wszerrormsg: *mut u16, ccherrormsgmax: i16, pccherrormsg: *mut i16) -> i16;
    }
    SQLErrorW(::core::mem::transmute(henv), ::core::mem::transmute(hdbc), ::core::mem::transmute(hstmt), ::core::mem::transmute(wszsqlstate.as_ptr()), ::core::mem::transmute(pfnativeerror.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(wszerrormsg.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), wszerrormsg.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pccherrormsg.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLExecDirect(statementhandle: *mut ::core::ffi::c_void, statementtext: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLExecDirect(statementhandle: *mut ::core::ffi::c_void, statementtext: *const u8, textlength: i32) -> i16;
    }
    SQLExecDirect(::core::mem::transmute(statementhandle), ::core::mem::transmute(statementtext.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), statementtext.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLExecDirectA(hstmt: *mut ::core::ffi::c_void, szsqlstr: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLExecDirectA(hstmt: *mut ::core::ffi::c_void, szsqlstr: *const u8, cbsqlstr: i32) -> i16;
    }
    SQLExecDirectA(::core::mem::transmute(hstmt), ::core::mem::transmute(szsqlstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szsqlstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLExecDirectW(hstmt: *mut ::core::ffi::c_void, szsqlstr: ::core::option::Option<&[u16]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLExecDirectW(hstmt: *mut ::core::ffi::c_void, szsqlstr: *const u16, textlength: i32) -> i16;
    }
    SQLExecDirectW(::core::mem::transmute(hstmt), ::core::mem::transmute(szsqlstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szsqlstr.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLExecute(statementhandle: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLExecute(statementhandle: *mut ::core::ffi::c_void) -> i16;
    }
    SQLExecute(::core::mem::transmute(statementhandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLExtendedFetch(hstmt: *mut ::core::ffi::c_void, ffetchtype: u16, irow: i64, pcrow: ::core::option::Option<*mut u64>, rgfrowstatus: ::core::option::Option<*mut u16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLExtendedFetch(hstmt: *mut ::core::ffi::c_void, ffetchtype: u16, irow: i64, pcrow: *mut u64, rgfrowstatus: *mut u16) -> i16;
    }
    SQLExtendedFetch(::core::mem::transmute(hstmt), ffetchtype, irow, ::core::mem::transmute(pcrow.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(rgfrowstatus.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLExtendedFetch(hstmt: *mut ::core::ffi::c_void, ffetchtype: u16, irow: i32, pcrow: ::core::option::Option<*mut u32>, rgfrowstatus: ::core::option::Option<*mut u16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLExtendedFetch(hstmt: *mut ::core::ffi::c_void, ffetchtype: u16, irow: i32, pcrow: *mut u32, rgfrowstatus: *mut u16) -> i16;
    }
    SQLExtendedFetch(::core::mem::transmute(hstmt), ffetchtype, irow, ::core::mem::transmute(pcrow.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(rgfrowstatus.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLFetch(statementhandle: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLFetch(statementhandle: *mut ::core::ffi::c_void) -> i16;
    }
    SQLFetch(::core::mem::transmute(statementhandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLFetchScroll(statementhandle: *mut ::core::ffi::c_void, fetchorientation: i16, fetchoffset: i64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLFetchScroll(statementhandle: *mut ::core::ffi::c_void, fetchorientation: i16, fetchoffset: i64) -> i16;
    }
    SQLFetchScroll(::core::mem::transmute(statementhandle), fetchorientation, fetchoffset)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLFetchScroll(statementhandle: *mut ::core::ffi::c_void, fetchorientation: i16, fetchoffset: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLFetchScroll(statementhandle: *mut ::core::ffi::c_void, fetchorientation: i16, fetchoffset: i32) -> i16;
    }
    SQLFetchScroll(::core::mem::transmute(statementhandle), fetchorientation, fetchoffset)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLForeignKeys(hstmt: *mut ::core::ffi::c_void, szpkcatalogname: ::core::option::Option<&[u8]>, szpkschemaname: ::core::option::Option<&[u8]>, szpktablename: ::core::option::Option<&[u8]>, szfkcatalogname: ::core::option::Option<&[u8]>, szfkschemaname: ::core::option::Option<&[u8]>, szfktablename: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLForeignKeys(hstmt: *mut ::core::ffi::c_void, szpkcatalogname: *const u8, cchpkcatalogname: i16, szpkschemaname: *const u8, cchpkschemaname: i16, szpktablename: *const u8, cchpktablename: i16, szfkcatalogname: *const u8, cchfkcatalogname: i16, szfkschemaname: *const u8, cchfkschemaname: i16, szfktablename: *const u8, cchfktablename: i16) -> i16;
    }
    SQLForeignKeys(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szpkcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szpkcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szpkschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szpkschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szpktablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szpktablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szfkcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szfkcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szfkschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szfkschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szfktablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szfktablename.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLForeignKeysA(hstmt: *mut ::core::ffi::c_void, szpkcatalogname: ::core::option::Option<&[u8]>, szpkschemaname: ::core::option::Option<&[u8]>, szpktablename: ::core::option::Option<&[u8]>, szfkcatalogname: ::core::option::Option<&[u8]>, szfkschemaname: ::core::option::Option<&[u8]>, szfktablename: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLForeignKeysA(hstmt: *mut ::core::ffi::c_void, szpkcatalogname: *const u8, cbpkcatalogname: i16, szpkschemaname: *const u8, cbpkschemaname: i16, szpktablename: *const u8, cbpktablename: i16, szfkcatalogname: *const u8, cbfkcatalogname: i16, szfkschemaname: *const u8, cbfkschemaname: i16, szfktablename: *const u8, cbfktablename: i16) -> i16;
    }
    SQLForeignKeysA(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szpkcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szpkcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szpkschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szpkschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szpktablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szpktablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szfkcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szfkcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szfkschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szfkschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szfktablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szfktablename.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLForeignKeysW(hstmt: *mut ::core::ffi::c_void, szpkcatalogname: ::core::option::Option<&[u16]>, szpkschemaname: ::core::option::Option<&[u16]>, szpktablename: ::core::option::Option<&[u16]>, szfkcatalogname: ::core::option::Option<&[u16]>, szfkschemaname: ::core::option::Option<&[u16]>, szfktablename: ::core::option::Option<&[u16]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLForeignKeysW(hstmt: *mut ::core::ffi::c_void, szpkcatalogname: *const u16, cchpkcatalogname: i16, szpkschemaname: *const u16, cchpkschemaname: i16, szpktablename: *const u16, cchpktablename: i16, szfkcatalogname: *const u16, cchfkcatalogname: i16, szfkschemaname: *const u16, cchfkschemaname: i16, szfktablename: *const u16, cchfktablename: i16) -> i16;
    }
    SQLForeignKeysW(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szpkcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szpkcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szpkschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szpkschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szpktablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szpktablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szfkcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szfkcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szfkschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szfkschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szfktablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szfktablename.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLFreeConnect(connectionhandle: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLFreeConnect(connectionhandle: *mut ::core::ffi::c_void) -> i16;
    }
    SQLFreeConnect(::core::mem::transmute(connectionhandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLFreeEnv(environmenthandle: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLFreeEnv(environmenthandle: *mut ::core::ffi::c_void) -> i16;
    }
    SQLFreeEnv(::core::mem::transmute(environmenthandle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLFreeHandle(handletype: i16, handle: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLFreeHandle(handletype: i16, handle: *mut ::core::ffi::c_void) -> i16;
    }
    SQLFreeHandle(handletype, ::core::mem::transmute(handle))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLFreeStmt(statementhandle: *mut ::core::ffi::c_void, option: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLFreeStmt(statementhandle: *mut ::core::ffi::c_void, option: u16) -> i16;
    }
    SQLFreeStmt(::core::mem::transmute(statementhandle), option)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetConnectAttr(connectionhandle: *mut ::core::ffi::c_void, attribute: i32, value: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i32, stringlengthptr: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetConnectAttr(connectionhandle: *mut ::core::ffi::c_void, attribute: i32, value: *mut ::core::ffi::c_void, bufferlength: i32, stringlengthptr: *mut i32) -> i16;
    }
    SQLGetConnectAttr(::core::mem::transmute(connectionhandle), attribute, ::core::mem::transmute(value.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(stringlengthptr.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetConnectAttrA(hdbc: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: ::core::option::Option<*mut ::core::ffi::c_void>, cbvaluemax: i32, pcbvalue: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetConnectAttrA(hdbc: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i32, pcbvalue: *mut i32) -> i16;
    }
    SQLGetConnectAttrA(::core::mem::transmute(hdbc), fattribute, ::core::mem::transmute(rgbvalue.unwrap_or(::std::ptr::null_mut())), cbvaluemax, ::core::mem::transmute(pcbvalue.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetConnectAttrW(hdbc: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: ::core::option::Option<*mut ::core::ffi::c_void>, cbvaluemax: i32, pcbvalue: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetConnectAttrW(hdbc: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i32, pcbvalue: *mut i32) -> i16;
    }
    SQLGetConnectAttrW(::core::mem::transmute(hdbc), fattribute, ::core::mem::transmute(rgbvalue.unwrap_or(::std::ptr::null_mut())), cbvaluemax, ::core::mem::transmute(pcbvalue.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetConnectOption(connectionhandle: *mut ::core::ffi::c_void, option: u16, value: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetConnectOption(connectionhandle: *mut ::core::ffi::c_void, option: u16, value: *mut ::core::ffi::c_void) -> i16;
    }
    SQLGetConnectOption(::core::mem::transmute(connectionhandle), option, ::core::mem::transmute(value))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetConnectOptionA(hdbc: *mut ::core::ffi::c_void, foption: u16, pvparam: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetConnectOptionA(hdbc: *mut ::core::ffi::c_void, foption: u16, pvparam: *mut ::core::ffi::c_void) -> i16;
    }
    SQLGetConnectOptionA(::core::mem::transmute(hdbc), foption, ::core::mem::transmute(pvparam))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetConnectOptionW(hdbc: *mut ::core::ffi::c_void, foption: u16, pvparam: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetConnectOptionW(hdbc: *mut ::core::ffi::c_void, foption: u16, pvparam: *mut ::core::ffi::c_void) -> i16;
    }
    SQLGetConnectOptionW(::core::mem::transmute(hdbc), foption, ::core::mem::transmute(pvparam))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetCursorName(statementhandle: *mut ::core::ffi::c_void, cursorname: ::core::option::Option<&mut [u8]>, namelengthptr: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetCursorName(statementhandle: *mut ::core::ffi::c_void, cursorname: *mut u8, bufferlength: i16, namelengthptr: *mut i16) -> i16;
    }
    SQLGetCursorName(::core::mem::transmute(statementhandle), ::core::mem::transmute(cursorname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), cursorname.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(namelengthptr.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetCursorNameA(hstmt: *mut ::core::ffi::c_void, szcursor: ::core::option::Option<&mut [u8]>, pcbcursor: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetCursorNameA(hstmt: *mut ::core::ffi::c_void, szcursor: *mut u8, cbcursormax: i16, pcbcursor: *mut i16) -> i16;
    }
    SQLGetCursorNameA(::core::mem::transmute(hstmt), ::core::mem::transmute(szcursor.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szcursor.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcbcursor.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetCursorNameW(hstmt: *mut ::core::ffi::c_void, szcursor: ::core::option::Option<&mut [u16]>, pcchcursor: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetCursorNameW(hstmt: *mut ::core::ffi::c_void, szcursor: *mut u16, cchcursormax: i16, pcchcursor: *mut i16) -> i16;
    }
    SQLGetCursorNameW(::core::mem::transmute(hstmt), ::core::mem::transmute(szcursor.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szcursor.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcchcursor.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLGetData(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, targettype: i16, targetvalue: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i64, strlen_or_indptr: ::core::option::Option<*mut i64>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetData(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, targettype: i16, targetvalue: *mut ::core::ffi::c_void, bufferlength: i64, strlen_or_indptr: *mut i64) -> i16;
    }
    SQLGetData(::core::mem::transmute(statementhandle), columnnumber, targettype, ::core::mem::transmute(targetvalue.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(strlen_or_indptr.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLGetData(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, targettype: i16, targetvalue: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i32, strlen_or_indptr: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetData(statementhandle: *mut ::core::ffi::c_void, columnnumber: u16, targettype: i16, targetvalue: *mut ::core::ffi::c_void, bufferlength: i32, strlen_or_indptr: *mut i32) -> i16;
    }
    SQLGetData(::core::mem::transmute(statementhandle), columnnumber, targettype, ::core::mem::transmute(targetvalue.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(strlen_or_indptr.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetDescField(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, fieldidentifier: i16, value: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i32, stringlength: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDescField(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, fieldidentifier: i16, value: *mut ::core::ffi::c_void, bufferlength: i32, stringlength: *mut i32) -> i16;
    }
    SQLGetDescField(::core::mem::transmute(descriptorhandle), recnumber, fieldidentifier, ::core::mem::transmute(value.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(stringlength.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetDescFieldA(hdesc: *mut ::core::ffi::c_void, irecord: i16, ifield: i16, rgbvalue: ::core::option::Option<*mut ::core::ffi::c_void>, cbbufferlength: i32, stringlength: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDescFieldA(hdesc: *mut ::core::ffi::c_void, irecord: i16, ifield: i16, rgbvalue: *mut ::core::ffi::c_void, cbbufferlength: i32, stringlength: *mut i32) -> i16;
    }
    SQLGetDescFieldA(::core::mem::transmute(hdesc), irecord, ifield, ::core::mem::transmute(rgbvalue.unwrap_or(::std::ptr::null_mut())), cbbufferlength, ::core::mem::transmute(stringlength.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetDescFieldW(hdesc: *mut ::core::ffi::c_void, irecord: i16, ifield: i16, rgbvalue: ::core::option::Option<*mut ::core::ffi::c_void>, cbbufferlength: i32, stringlength: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDescFieldW(hdesc: *mut ::core::ffi::c_void, irecord: i16, ifield: i16, rgbvalue: *mut ::core::ffi::c_void, cbbufferlength: i32, stringlength: *mut i32) -> i16;
    }
    SQLGetDescFieldW(::core::mem::transmute(hdesc), irecord, ifield, ::core::mem::transmute(rgbvalue.unwrap_or(::std::ptr::null_mut())), cbbufferlength, ::core::mem::transmute(stringlength.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLGetDescRec(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, name: ::core::option::Option<&mut [u8]>, stringlengthptr: ::core::option::Option<*mut i16>, typeptr: ::core::option::Option<*mut i16>, subtypeptr: ::core::option::Option<*mut i16>, lengthptr: ::core::option::Option<*mut i64>, precisionptr: ::core::option::Option<*mut i16>, scaleptr: ::core::option::Option<*mut i16>, nullableptr: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDescRec(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, name: *mut u8, bufferlength: i16, stringlengthptr: *mut i16, typeptr: *mut i16, subtypeptr: *mut i16, lengthptr: *mut i64, precisionptr: *mut i16, scaleptr: *mut i16, nullableptr: *mut i16) -> i16;
    }
    SQLGetDescRec(
        ::core::mem::transmute(descriptorhandle),
        recnumber,
        ::core::mem::transmute(name.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        name.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(stringlengthptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(typeptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(subtypeptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(lengthptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(precisionptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(scaleptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(nullableptr.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLGetDescRec(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, name: ::core::option::Option<&mut [u8]>, stringlengthptr: ::core::option::Option<*mut i16>, typeptr: ::core::option::Option<*mut i16>, subtypeptr: ::core::option::Option<*mut i16>, lengthptr: ::core::option::Option<*mut i32>, precisionptr: ::core::option::Option<*mut i16>, scaleptr: ::core::option::Option<*mut i16>, nullableptr: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDescRec(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, name: *mut u8, bufferlength: i16, stringlengthptr: *mut i16, typeptr: *mut i16, subtypeptr: *mut i16, lengthptr: *mut i32, precisionptr: *mut i16, scaleptr: *mut i16, nullableptr: *mut i16) -> i16;
    }
    SQLGetDescRec(
        ::core::mem::transmute(descriptorhandle),
        recnumber,
        ::core::mem::transmute(name.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        name.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(stringlengthptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(typeptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(subtypeptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(lengthptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(precisionptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(scaleptr.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(nullableptr.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLGetDescRecA(hdesc: *mut ::core::ffi::c_void, irecord: i16, szname: ::core::option::Option<&mut [u8]>, pcbname: ::core::option::Option<*mut i16>, pftype: ::core::option::Option<*mut i16>, pfsubtype: ::core::option::Option<*mut i16>, plength: ::core::option::Option<*mut i64>, pprecision: ::core::option::Option<*mut i16>, pscale: ::core::option::Option<*mut i16>, pnullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDescRecA(hdesc: *mut ::core::ffi::c_void, irecord: i16, szname: *mut u8, cbnamemax: i16, pcbname: *mut i16, pftype: *mut i16, pfsubtype: *mut i16, plength: *mut i64, pprecision: *mut i16, pscale: *mut i16, pnullable: *mut i16) -> i16;
    }
    SQLGetDescRecA(
        ::core::mem::transmute(hdesc),
        irecord,
        ::core::mem::transmute(szname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcbname.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pftype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfsubtype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(plength.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pprecision.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pscale.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pnullable.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLGetDescRecA(hdesc: *mut ::core::ffi::c_void, irecord: i16, szname: ::core::option::Option<&mut [u8]>, pcbname: ::core::option::Option<*mut i16>, pftype: ::core::option::Option<*mut i16>, pfsubtype: ::core::option::Option<*mut i16>, plength: ::core::option::Option<*mut i32>, pprecision: ::core::option::Option<*mut i16>, pscale: ::core::option::Option<*mut i16>, pnullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDescRecA(hdesc: *mut ::core::ffi::c_void, irecord: i16, szname: *mut u8, cbnamemax: i16, pcbname: *mut i16, pftype: *mut i16, pfsubtype: *mut i16, plength: *mut i32, pprecision: *mut i16, pscale: *mut i16, pnullable: *mut i16) -> i16;
    }
    SQLGetDescRecA(
        ::core::mem::transmute(hdesc),
        irecord,
        ::core::mem::transmute(szname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcbname.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pftype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfsubtype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(plength.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pprecision.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pscale.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pnullable.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLGetDescRecW(hdesc: *mut ::core::ffi::c_void, irecord: i16, szname: ::core::option::Option<&mut [u16]>, pcchname: ::core::option::Option<*mut i16>, pftype: ::core::option::Option<*mut i16>, pfsubtype: ::core::option::Option<*mut i16>, plength: ::core::option::Option<*mut i64>, pprecision: ::core::option::Option<*mut i16>, pscale: ::core::option::Option<*mut i16>, pnullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDescRecW(hdesc: *mut ::core::ffi::c_void, irecord: i16, szname: *mut u16, cchnamemax: i16, pcchname: *mut i16, pftype: *mut i16, pfsubtype: *mut i16, plength: *mut i64, pprecision: *mut i16, pscale: *mut i16, pnullable: *mut i16) -> i16;
    }
    SQLGetDescRecW(
        ::core::mem::transmute(hdesc),
        irecord,
        ::core::mem::transmute(szname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcchname.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pftype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfsubtype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(plength.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pprecision.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pscale.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pnullable.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLGetDescRecW(hdesc: *mut ::core::ffi::c_void, irecord: i16, szname: ::core::option::Option<&mut [u16]>, pcchname: ::core::option::Option<*mut i16>, pftype: ::core::option::Option<*mut i16>, pfsubtype: ::core::option::Option<*mut i16>, plength: ::core::option::Option<*mut i32>, pprecision: ::core::option::Option<*mut i16>, pscale: ::core::option::Option<*mut i16>, pnullable: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDescRecW(hdesc: *mut ::core::ffi::c_void, irecord: i16, szname: *mut u16, cchnamemax: i16, pcchname: *mut i16, pftype: *mut i16, pfsubtype: *mut i16, plength: *mut i32, pprecision: *mut i16, pscale: *mut i16, pnullable: *mut i16) -> i16;
    }
    SQLGetDescRecW(
        ::core::mem::transmute(hdesc),
        irecord,
        ::core::mem::transmute(szname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pcchname.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pftype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pfsubtype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(plength.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pprecision.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pscale.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pnullable.unwrap_or(::std::ptr::null_mut())),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetDiagField(handletype: i16, handle: *mut ::core::ffi::c_void, recnumber: i16, diagidentifier: i16, diaginfo: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i16, stringlength: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDiagField(handletype: i16, handle: *mut ::core::ffi::c_void, recnumber: i16, diagidentifier: i16, diaginfo: *mut ::core::ffi::c_void, bufferlength: i16, stringlength: *mut i16) -> i16;
    }
    SQLGetDiagField(handletype, ::core::mem::transmute(handle), recnumber, diagidentifier, ::core::mem::transmute(diaginfo.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(stringlength.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetDiagFieldA(fhandletype: i16, handle: *mut ::core::ffi::c_void, irecord: i16, fdiagfield: i16, rgbdiaginfo: ::core::option::Option<*mut ::core::ffi::c_void>, cbdiaginfomax: i16, pcbdiaginfo: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDiagFieldA(fhandletype: i16, handle: *mut ::core::ffi::c_void, irecord: i16, fdiagfield: i16, rgbdiaginfo: *mut ::core::ffi::c_void, cbdiaginfomax: i16, pcbdiaginfo: *mut i16) -> i16;
    }
    SQLGetDiagFieldA(fhandletype, ::core::mem::transmute(handle), irecord, fdiagfield, ::core::mem::transmute(rgbdiaginfo.unwrap_or(::std::ptr::null_mut())), cbdiaginfomax, ::core::mem::transmute(pcbdiaginfo.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetDiagFieldW(fhandletype: i16, handle: *mut ::core::ffi::c_void, irecord: i16, fdiagfield: i16, rgbdiaginfo: ::core::option::Option<*mut ::core::ffi::c_void>, cbbufferlength: i16, pcbstringlength: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDiagFieldW(fhandletype: i16, handle: *mut ::core::ffi::c_void, irecord: i16, fdiagfield: i16, rgbdiaginfo: *mut ::core::ffi::c_void, cbbufferlength: i16, pcbstringlength: *mut i16) -> i16;
    }
    SQLGetDiagFieldW(fhandletype, ::core::mem::transmute(handle), irecord, fdiagfield, ::core::mem::transmute(rgbdiaginfo.unwrap_or(::std::ptr::null_mut())), cbbufferlength, ::core::mem::transmute(pcbstringlength.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetDiagRec(handletype: i16, handle: *mut ::core::ffi::c_void, recnumber: i16, sqlstate: ::core::option::Option<&mut [u8; 6]>, nativeerror: *mut i32, messagetext: ::core::option::Option<&mut [u8]>, textlength: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDiagRec(handletype: i16, handle: *mut ::core::ffi::c_void, recnumber: i16, sqlstate: *mut u8, nativeerror: *mut i32, messagetext: *mut u8, bufferlength: i16, textlength: *mut i16) -> i16;
    }
    SQLGetDiagRec(handletype, ::core::mem::transmute(handle), recnumber, ::core::mem::transmute(sqlstate.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(nativeerror), ::core::mem::transmute(messagetext.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), messagetext.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(textlength.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetDiagRecA(fhandletype: i16, handle: *mut ::core::ffi::c_void, irecord: i16, szsqlstate: ::core::option::Option<&mut [u8; 6]>, pfnativeerror: *mut i32, szerrormsg: ::core::option::Option<&mut [u8]>, pcberrormsg: *mut i16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDiagRecA(fhandletype: i16, handle: *mut ::core::ffi::c_void, irecord: i16, szsqlstate: *mut u8, pfnativeerror: *mut i32, szerrormsg: *mut u8, cberrormsgmax: i16, pcberrormsg: *mut i16) -> i16;
    }
    SQLGetDiagRecA(fhandletype, ::core::mem::transmute(handle), irecord, ::core::mem::transmute(szsqlstate.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pfnativeerror), ::core::mem::transmute(szerrormsg.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szerrormsg.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcberrormsg))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetDiagRecW(fhandletype: i16, handle: *mut ::core::ffi::c_void, irecord: i16, szsqlstate: ::core::option::Option<&mut [u16; 6]>, pfnativeerror: *mut i32, szerrormsg: ::core::option::Option<&mut [u16]>, pccherrormsg: *mut i16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetDiagRecW(fhandletype: i16, handle: *mut ::core::ffi::c_void, irecord: i16, szsqlstate: *mut u16, pfnativeerror: *mut i32, szerrormsg: *mut u16, ccherrormsgmax: i16, pccherrormsg: *mut i16) -> i16;
    }
    SQLGetDiagRecW(fhandletype, ::core::mem::transmute(handle), irecord, ::core::mem::transmute(szsqlstate.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pfnativeerror), ::core::mem::transmute(szerrormsg.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szerrormsg.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pccherrormsg))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetEnvAttr(environmenthandle: *mut ::core::ffi::c_void, attribute: i32, value: *mut ::core::ffi::c_void, bufferlength: i32, stringlength: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetEnvAttr(environmenthandle: *mut ::core::ffi::c_void, attribute: i32, value: *mut ::core::ffi::c_void, bufferlength: i32, stringlength: *mut i32) -> i16;
    }
    SQLGetEnvAttr(::core::mem::transmute(environmenthandle), attribute, ::core::mem::transmute(value), bufferlength, ::core::mem::transmute(stringlength.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetFunctions(connectionhandle: *mut ::core::ffi::c_void, functionid: u16, supported: ::core::option::Option<*mut u16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetFunctions(connectionhandle: *mut ::core::ffi::c_void, functionid: u16, supported: *mut u16) -> i16;
    }
    SQLGetFunctions(::core::mem::transmute(connectionhandle), functionid, ::core::mem::transmute(supported.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetInfo(connectionhandle: *mut ::core::ffi::c_void, infotype: u16, infovalue: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i16, stringlengthptr: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetInfo(connectionhandle: *mut ::core::ffi::c_void, infotype: u16, infovalue: *mut ::core::ffi::c_void, bufferlength: i16, stringlengthptr: *mut i16) -> i16;
    }
    SQLGetInfo(::core::mem::transmute(connectionhandle), infotype, ::core::mem::transmute(infovalue.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(stringlengthptr.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetInfoA(hdbc: *mut ::core::ffi::c_void, finfotype: u16, rgbinfovalue: ::core::option::Option<*mut ::core::ffi::c_void>, cbinfovaluemax: i16, pcbinfovalue: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetInfoA(hdbc: *mut ::core::ffi::c_void, finfotype: u16, rgbinfovalue: *mut ::core::ffi::c_void, cbinfovaluemax: i16, pcbinfovalue: *mut i16) -> i16;
    }
    SQLGetInfoA(::core::mem::transmute(hdbc), finfotype, ::core::mem::transmute(rgbinfovalue.unwrap_or(::std::ptr::null_mut())), cbinfovaluemax, ::core::mem::transmute(pcbinfovalue.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetInfoW(hdbc: *mut ::core::ffi::c_void, finfotype: u16, rgbinfovalue: ::core::option::Option<*mut ::core::ffi::c_void>, cbinfovaluemax: i16, pcbinfovalue: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetInfoW(hdbc: *mut ::core::ffi::c_void, finfotype: u16, rgbinfovalue: *mut ::core::ffi::c_void, cbinfovaluemax: i16, pcbinfovalue: *mut i16) -> i16;
    }
    SQLGetInfoW(::core::mem::transmute(hdbc), finfotype, ::core::mem::transmute(rgbinfovalue.unwrap_or(::std::ptr::null_mut())), cbinfovaluemax, ::core::mem::transmute(pcbinfovalue.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SQLGetNextEnumeration<'a, P0>(henumhandle: P0, prgenumdata: *mut u8, pienumlength: *mut i32) -> i16
where
    P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetNextEnumeration(henumhandle: super::super::Foundation::HANDLE, prgenumdata: *mut u8, pienumlength: *mut i32) -> i16;
    }
    SQLGetNextEnumeration(henumhandle.into(), ::core::mem::transmute(prgenumdata), ::core::mem::transmute(pienumlength))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetStmtAttr(statementhandle: *mut ::core::ffi::c_void, attribute: i32, value: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: i32, stringlength: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetStmtAttr(statementhandle: *mut ::core::ffi::c_void, attribute: i32, value: *mut ::core::ffi::c_void, bufferlength: i32, stringlength: *mut i32) -> i16;
    }
    SQLGetStmtAttr(::core::mem::transmute(statementhandle), attribute, ::core::mem::transmute(value.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(stringlength.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetStmtAttrA(hstmt: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i32, pcbvalue: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetStmtAttrA(hstmt: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i32, pcbvalue: *mut i32) -> i16;
    }
    SQLGetStmtAttrA(::core::mem::transmute(hstmt), fattribute, ::core::mem::transmute(rgbvalue), cbvaluemax, ::core::mem::transmute(pcbvalue))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetStmtAttrW(hstmt: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i32, pcbvalue: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetStmtAttrW(hstmt: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i32, pcbvalue: *mut i32) -> i16;
    }
    SQLGetStmtAttrW(::core::mem::transmute(hstmt), fattribute, ::core::mem::transmute(rgbvalue), cbvaluemax, ::core::mem::transmute(pcbvalue))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetStmtOption(statementhandle: *mut ::core::ffi::c_void, option: u16, value: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetStmtOption(statementhandle: *mut ::core::ffi::c_void, option: u16, value: *mut ::core::ffi::c_void) -> i16;
    }
    SQLGetStmtOption(::core::mem::transmute(statementhandle), option, ::core::mem::transmute(value))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetTypeInfo(statementhandle: *mut ::core::ffi::c_void, datatype: i16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetTypeInfo(statementhandle: *mut ::core::ffi::c_void, datatype: i16) -> i16;
    }
    SQLGetTypeInfo(::core::mem::transmute(statementhandle), datatype)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetTypeInfoA(statementhandle: *mut ::core::ffi::c_void, datatype: i16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetTypeInfoA(statementhandle: *mut ::core::ffi::c_void, datatype: i16) -> i16;
    }
    SQLGetTypeInfoA(::core::mem::transmute(statementhandle), datatype)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLGetTypeInfoW(statementhandle: *mut ::core::ffi::c_void, datatype: i16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLGetTypeInfoW(statementhandle: *mut ::core::ffi::c_void, datatype: i16) -> i16;
    }
    SQLGetTypeInfoW(::core::mem::transmute(statementhandle), datatype)
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SQLInitEnumServers<'a, P0, P1>(pwchservername: P0, pwchinstancename: P1) -> super::super::Foundation::HANDLE
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLInitEnumServers(pwchservername: ::windows::core::PCWSTR, pwchinstancename: ::windows::core::PCWSTR) -> super::super::Foundation::HANDLE;
    }
    SQLInitEnumServers(pwchservername.into(), pwchinstancename.into())
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLLinkedCatalogsA<'a, P0>(param0: *mut ::core::ffi::c_void, param1: P0, param2: i16) -> i16
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLLinkedCatalogsA(param0: *mut ::core::ffi::c_void, param1: ::windows::core::PCSTR, param2: i16) -> i16;
    }
    SQLLinkedCatalogsA(::core::mem::transmute(param0), param1.into(), param2)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLLinkedCatalogsW<'a, P0>(param0: *mut ::core::ffi::c_void, param1: P0, param2: i16) -> i16
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLLinkedCatalogsW(param0: *mut ::core::ffi::c_void, param1: ::windows::core::PCWSTR, param2: i16) -> i16;
    }
    SQLLinkedCatalogsW(::core::mem::transmute(param0), param1.into(), param2)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLLinkedServers(param0: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLLinkedServers(param0: *mut ::core::ffi::c_void) -> i16;
    }
    SQLLinkedServers(::core::mem::transmute(param0))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLMoreResults(hstmt: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLMoreResults(hstmt: *mut ::core::ffi::c_void) -> i16;
    }
    SQLMoreResults(::core::mem::transmute(hstmt))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLNativeSql(hdbc: *mut ::core::ffi::c_void, szsqlstrin: &[u8], szsqlstr: ::core::option::Option<&mut [u8]>, pcbsqlstr: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLNativeSql(hdbc: *mut ::core::ffi::c_void, szsqlstrin: *const u8, cchsqlstrin: i32, szsqlstr: *mut u8, cchsqlstrmax: i32, pcbsqlstr: *mut i32) -> i16;
    }
    SQLNativeSql(::core::mem::transmute(hdbc), ::core::mem::transmute(szsqlstrin.as_ptr()), szsqlstrin.len() as _, ::core::mem::transmute(szsqlstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szsqlstr.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcbsqlstr))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLNativeSqlA(hdbc: *mut ::core::ffi::c_void, szsqlstrin: &[u8], szsqlstr: ::core::option::Option<&mut [u8]>, pcbsqlstr: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLNativeSqlA(hdbc: *mut ::core::ffi::c_void, szsqlstrin: *const u8, cbsqlstrin: i32, szsqlstr: *mut u8, cbsqlstrmax: i32, pcbsqlstr: *mut i32) -> i16;
    }
    SQLNativeSqlA(::core::mem::transmute(hdbc), ::core::mem::transmute(szsqlstrin.as_ptr()), szsqlstrin.len() as _, ::core::mem::transmute(szsqlstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szsqlstr.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcbsqlstr))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLNativeSqlW(hdbc: *mut ::core::ffi::c_void, szsqlstrin: &[u16], szsqlstr: ::core::option::Option<&mut [u16]>, pcchsqlstr: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLNativeSqlW(hdbc: *mut ::core::ffi::c_void, szsqlstrin: *const u16, cchsqlstrin: i32, szsqlstr: *mut u16, cchsqlstrmax: i32, pcchsqlstr: *mut i32) -> i16;
    }
    SQLNativeSqlW(::core::mem::transmute(hdbc), ::core::mem::transmute(szsqlstrin.as_ptr()), szsqlstrin.len() as _, ::core::mem::transmute(szsqlstr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), szsqlstr.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pcchsqlstr))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLNumParams(hstmt: *mut ::core::ffi::c_void, pcpar: ::core::option::Option<*mut i16>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLNumParams(hstmt: *mut ::core::ffi::c_void, pcpar: *mut i16) -> i16;
    }
    SQLNumParams(::core::mem::transmute(hstmt), ::core::mem::transmute(pcpar.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLNumResultCols(statementhandle: *mut ::core::ffi::c_void, columncount: *mut i16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLNumResultCols(statementhandle: *mut ::core::ffi::c_void, columncount: *mut i16) -> i16;
    }
    SQLNumResultCols(::core::mem::transmute(statementhandle), ::core::mem::transmute(columncount))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLParamData(statementhandle: *mut ::core::ffi::c_void, value: ::core::option::Option<*mut *mut ::core::ffi::c_void>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLParamData(statementhandle: *mut ::core::ffi::c_void, value: *mut *mut ::core::ffi::c_void) -> i16;
    }
    SQLParamData(::core::mem::transmute(statementhandle), ::core::mem::transmute(value.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLParamOptions(hstmt: *mut ::core::ffi::c_void, crow: u64, pirow: *mut u64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLParamOptions(hstmt: *mut ::core::ffi::c_void, crow: u64, pirow: *mut u64) -> i16;
    }
    SQLParamOptions(::core::mem::transmute(hstmt), crow, ::core::mem::transmute(pirow))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLParamOptions(hstmt: *mut ::core::ffi::c_void, crow: u32, pirow: *mut u32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLParamOptions(hstmt: *mut ::core::ffi::c_void, crow: u32, pirow: *mut u32) -> i16;
    }
    SQLParamOptions(::core::mem::transmute(hstmt), crow, ::core::mem::transmute(pirow))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLPrepare(statementhandle: *mut ::core::ffi::c_void, statementtext: &[u8]) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLPrepare(statementhandle: *mut ::core::ffi::c_void, statementtext: *const u8, textlength: i32) -> i16;
    }
    SQLPrepare(::core::mem::transmute(statementhandle), ::core::mem::transmute(statementtext.as_ptr()), statementtext.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLPrepareA(hstmt: *mut ::core::ffi::c_void, szsqlstr: &[u8]) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLPrepareA(hstmt: *mut ::core::ffi::c_void, szsqlstr: *const u8, cbsqlstr: i32) -> i16;
    }
    SQLPrepareA(::core::mem::transmute(hstmt), ::core::mem::transmute(szsqlstr.as_ptr()), szsqlstr.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLPrepareW(hstmt: *mut ::core::ffi::c_void, szsqlstr: &[u16]) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLPrepareW(hstmt: *mut ::core::ffi::c_void, szsqlstr: *const u16, cchsqlstr: i32) -> i16;
    }
    SQLPrepareW(::core::mem::transmute(hstmt), ::core::mem::transmute(szsqlstr.as_ptr()), szsqlstr.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLPrimaryKeys(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, sztablename: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLPrimaryKeys(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cchcatalogname: i16, szschemaname: *const u8, cchschemaname: i16, sztablename: *const u8, cchtablename: i16) -> i16;
    }
    SQLPrimaryKeys(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLPrimaryKeysA(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, sztablename: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLPrimaryKeysA(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cbcatalogname: i16, szschemaname: *const u8, cbschemaname: i16, sztablename: *const u8, cbtablename: i16) -> i16;
    }
    SQLPrimaryKeysA(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLPrimaryKeysW(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u16]>, szschemaname: ::core::option::Option<&[u16]>, sztablename: ::core::option::Option<&[u16]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLPrimaryKeysW(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u16, cchcatalogname: i16, szschemaname: *const u16, cchschemaname: i16, sztablename: *const u16, cchtablename: i16) -> i16;
    }
    SQLPrimaryKeysW(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLProcedureColumns(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, szprocname: ::core::option::Option<&[u8]>, szcolumnname: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLProcedureColumns(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cchcatalogname: i16, szschemaname: *const u8, cchschemaname: i16, szprocname: *const u8, cchprocname: i16, szcolumnname: *const u8, cchcolumnname: i16) -> i16;
    }
    SQLProcedureColumns(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szprocname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szprocname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szcolumnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolumnname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLProcedureColumnsA(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, szprocname: ::core::option::Option<&[u8]>, szcolumnname: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLProcedureColumnsA(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cbcatalogname: i16, szschemaname: *const u8, cbschemaname: i16, szprocname: *const u8, cbprocname: i16, szcolumnname: *const u8, cbcolumnname: i16) -> i16;
    }
    SQLProcedureColumnsA(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szprocname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szprocname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szcolumnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolumnname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLProcedureColumnsW(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u16]>, szschemaname: ::core::option::Option<&[u16]>, szprocname: ::core::option::Option<&[u16]>, szcolumnname: ::core::option::Option<&[u16]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLProcedureColumnsW(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u16, cchcatalogname: i16, szschemaname: *const u16, cchschemaname: i16, szprocname: *const u16, cchprocname: i16, szcolumnname: *const u16, cchcolumnname: i16) -> i16;
    }
    SQLProcedureColumnsW(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szprocname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szprocname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szcolumnname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcolumnname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLProcedures(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, szprocname: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLProcedures(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cchcatalogname: i16, szschemaname: *const u8, cchschemaname: i16, szprocname: *const u8, cchprocname: i16) -> i16;
    }
    SQLProcedures(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szprocname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szprocname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLProceduresA(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, szprocname: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLProceduresA(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cbcatalogname: i16, szschemaname: *const u8, cbschemaname: i16, szprocname: *const u8, cbprocname: i16) -> i16;
    }
    SQLProceduresA(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szprocname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szprocname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLProceduresW(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u16]>, szschemaname: ::core::option::Option<&[u16]>, szprocname: ::core::option::Option<&[u16]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLProceduresW(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u16, cchcatalogname: i16, szschemaname: *const u16, cchschemaname: i16, szprocname: *const u16, cchprocname: i16) -> i16;
    }
    SQLProceduresW(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szprocname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szprocname.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLPutData(statementhandle: *mut ::core::ffi::c_void, data: *const ::core::ffi::c_void, strlen_or_ind: i64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLPutData(statementhandle: *mut ::core::ffi::c_void, data: *const ::core::ffi::c_void, strlen_or_ind: i64) -> i16;
    }
    SQLPutData(::core::mem::transmute(statementhandle), ::core::mem::transmute(data), strlen_or_ind)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLPutData(statementhandle: *mut ::core::ffi::c_void, data: *const ::core::ffi::c_void, strlen_or_ind: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLPutData(statementhandle: *mut ::core::ffi::c_void, data: *const ::core::ffi::c_void, strlen_or_ind: i32) -> i16;
    }
    SQLPutData(::core::mem::transmute(statementhandle), ::core::mem::transmute(data), strlen_or_ind)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLRowCount(statementhandle: *const ::core::ffi::c_void, rowcount: *mut i64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLRowCount(statementhandle: *const ::core::ffi::c_void, rowcount: *mut i64) -> i16;
    }
    SQLRowCount(::core::mem::transmute(statementhandle), ::core::mem::transmute(rowcount))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLRowCount(statementhandle: *const ::core::ffi::c_void, rowcount: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLRowCount(statementhandle: *const ::core::ffi::c_void, rowcount: *mut i32) -> i16;
    }
    SQLRowCount(::core::mem::transmute(statementhandle), ::core::mem::transmute(rowcount))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetConnectAttr(connectionhandle: *mut ::core::ffi::c_void, attribute: i32, value: ::core::option::Option<*const ::core::ffi::c_void>, stringlength: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetConnectAttr(connectionhandle: *mut ::core::ffi::c_void, attribute: i32, value: *const ::core::ffi::c_void, stringlength: i32) -> i16;
    }
    SQLSetConnectAttr(::core::mem::transmute(connectionhandle), attribute, ::core::mem::transmute(value.unwrap_or(::std::ptr::null())), stringlength)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetConnectAttrA(hdbc: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: ::core::option::Option<*const ::core::ffi::c_void>, cbvalue: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetConnectAttrA(hdbc: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: *const ::core::ffi::c_void, cbvalue: i32) -> i16;
    }
    SQLSetConnectAttrA(::core::mem::transmute(hdbc), fattribute, ::core::mem::transmute(rgbvalue.unwrap_or(::std::ptr::null())), cbvalue)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetConnectAttrW(hdbc: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: ::core::option::Option<*const ::core::ffi::c_void>, cbvalue: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetConnectAttrW(hdbc: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: *const ::core::ffi::c_void, cbvalue: i32) -> i16;
    }
    SQLSetConnectAttrW(::core::mem::transmute(hdbc), fattribute, ::core::mem::transmute(rgbvalue.unwrap_or(::std::ptr::null())), cbvalue)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLSetConnectOption(connectionhandle: *mut ::core::ffi::c_void, option: u16, value: u64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetConnectOption(connectionhandle: *mut ::core::ffi::c_void, option: u16, value: u64) -> i16;
    }
    SQLSetConnectOption(::core::mem::transmute(connectionhandle), option, value)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLSetConnectOption(connectionhandle: *mut ::core::ffi::c_void, option: u16, value: u32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetConnectOption(connectionhandle: *mut ::core::ffi::c_void, option: u16, value: u32) -> i16;
    }
    SQLSetConnectOption(::core::mem::transmute(connectionhandle), option, value)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLSetConnectOptionA(hdbc: *mut ::core::ffi::c_void, foption: u16, vparam: u64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetConnectOptionA(hdbc: *mut ::core::ffi::c_void, foption: u16, vparam: u64) -> i16;
    }
    SQLSetConnectOptionA(::core::mem::transmute(hdbc), foption, vparam)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLSetConnectOptionA(hdbc: *mut ::core::ffi::c_void, foption: u16, vparam: u32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetConnectOptionA(hdbc: *mut ::core::ffi::c_void, foption: u16, vparam: u32) -> i16;
    }
    SQLSetConnectOptionA(::core::mem::transmute(hdbc), foption, vparam)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLSetConnectOptionW(hdbc: *mut ::core::ffi::c_void, foption: u16, vparam: u64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetConnectOptionW(hdbc: *mut ::core::ffi::c_void, foption: u16, vparam: u64) -> i16;
    }
    SQLSetConnectOptionW(::core::mem::transmute(hdbc), foption, vparam)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLSetConnectOptionW(hdbc: *mut ::core::ffi::c_void, foption: u16, vparam: u32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetConnectOptionW(hdbc: *mut ::core::ffi::c_void, foption: u16, vparam: u32) -> i16;
    }
    SQLSetConnectOptionW(::core::mem::transmute(hdbc), foption, vparam)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetCursorName(statementhandle: *mut ::core::ffi::c_void, cursorname: &[u8]) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetCursorName(statementhandle: *mut ::core::ffi::c_void, cursorname: *const u8, namelength: i16) -> i16;
    }
    SQLSetCursorName(::core::mem::transmute(statementhandle), ::core::mem::transmute(cursorname.as_ptr()), cursorname.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetCursorNameA(hstmt: *mut ::core::ffi::c_void, szcursor: &[u8]) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetCursorNameA(hstmt: *mut ::core::ffi::c_void, szcursor: *const u8, cbcursor: i16) -> i16;
    }
    SQLSetCursorNameA(::core::mem::transmute(hstmt), ::core::mem::transmute(szcursor.as_ptr()), szcursor.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetCursorNameW(hstmt: *mut ::core::ffi::c_void, szcursor: &[u16]) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetCursorNameW(hstmt: *mut ::core::ffi::c_void, szcursor: *const u16, cchcursor: i16) -> i16;
    }
    SQLSetCursorNameW(::core::mem::transmute(hstmt), ::core::mem::transmute(szcursor.as_ptr()), szcursor.len() as _)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetDescField(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, fieldidentifier: i16, value: *const ::core::ffi::c_void, bufferlength: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetDescField(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, fieldidentifier: i16, value: *const ::core::ffi::c_void, bufferlength: i32) -> i16;
    }
    SQLSetDescField(::core::mem::transmute(descriptorhandle), recnumber, fieldidentifier, ::core::mem::transmute(value), bufferlength)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetDescFieldW(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, fieldidentifier: i16, value: *mut ::core::ffi::c_void, bufferlength: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetDescFieldW(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, fieldidentifier: i16, value: *mut ::core::ffi::c_void, bufferlength: i32) -> i16;
    }
    SQLSetDescFieldW(::core::mem::transmute(descriptorhandle), recnumber, fieldidentifier, ::core::mem::transmute(value), bufferlength)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLSetDescRec(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, r#type: i16, subtype: i16, length: i64, precision: i16, scale: i16, data: ::core::option::Option<*mut ::core::ffi::c_void>, stringlength: ::core::option::Option<*mut i64>, indicator: ::core::option::Option<*mut i64>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetDescRec(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, r#type: i16, subtype: i16, length: i64, precision: i16, scale: i16, data: *mut ::core::ffi::c_void, stringlength: *mut i64, indicator: *mut i64) -> i16;
    }
    SQLSetDescRec(::core::mem::transmute(descriptorhandle), recnumber, r#type, subtype, length, precision, scale, ::core::mem::transmute(data.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(stringlength.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(indicator.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLSetDescRec(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, r#type: i16, subtype: i16, length: i32, precision: i16, scale: i16, data: ::core::option::Option<*mut ::core::ffi::c_void>, stringlength: ::core::option::Option<*mut i32>, indicator: ::core::option::Option<*mut i32>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetDescRec(descriptorhandle: *mut ::core::ffi::c_void, recnumber: i16, r#type: i16, subtype: i16, length: i32, precision: i16, scale: i16, data: *mut ::core::ffi::c_void, stringlength: *mut i32, indicator: *mut i32) -> i16;
    }
    SQLSetDescRec(::core::mem::transmute(descriptorhandle), recnumber, r#type, subtype, length, precision, scale, ::core::mem::transmute(data.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(stringlength.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(indicator.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetEnvAttr(environmenthandle: *mut ::core::ffi::c_void, attribute: i32, value: ::core::option::Option<*const ::core::ffi::c_void>, stringlength: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetEnvAttr(environmenthandle: *mut ::core::ffi::c_void, attribute: i32, value: *const ::core::ffi::c_void, stringlength: i32) -> i16;
    }
    SQLSetEnvAttr(::core::mem::transmute(environmenthandle), attribute, ::core::mem::transmute(value.unwrap_or(::std::ptr::null())), stringlength)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLSetParam(statementhandle: *mut ::core::ffi::c_void, parameternumber: u16, valuetype: i16, parametertype: i16, lengthprecision: u64, parameterscale: i16, parametervalue: *const ::core::ffi::c_void, strlen_or_ind: *mut i64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetParam(statementhandle: *mut ::core::ffi::c_void, parameternumber: u16, valuetype: i16, parametertype: i16, lengthprecision: u64, parameterscale: i16, parametervalue: *const ::core::ffi::c_void, strlen_or_ind: *mut i64) -> i16;
    }
    SQLSetParam(::core::mem::transmute(statementhandle), parameternumber, valuetype, parametertype, lengthprecision, parameterscale, ::core::mem::transmute(parametervalue), ::core::mem::transmute(strlen_or_ind))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLSetParam(statementhandle: *mut ::core::ffi::c_void, parameternumber: u16, valuetype: i16, parametertype: i16, lengthprecision: u32, parameterscale: i16, parametervalue: *const ::core::ffi::c_void, strlen_or_ind: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetParam(statementhandle: *mut ::core::ffi::c_void, parameternumber: u16, valuetype: i16, parametertype: i16, lengthprecision: u32, parameterscale: i16, parametervalue: *const ::core::ffi::c_void, strlen_or_ind: *mut i32) -> i16;
    }
    SQLSetParam(::core::mem::transmute(statementhandle), parameternumber, valuetype, parametertype, lengthprecision, parameterscale, ::core::mem::transmute(parametervalue), ::core::mem::transmute(strlen_or_ind))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLSetPos(hstmt: *mut ::core::ffi::c_void, irow: u64, foption: u16, flock: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetPos(hstmt: *mut ::core::ffi::c_void, irow: u64, foption: u16, flock: u16) -> i16;
    }
    SQLSetPos(::core::mem::transmute(hstmt), irow, foption, flock)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLSetPos(hstmt: *mut ::core::ffi::c_void, irow: u16, foption: u16, flock: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetPos(hstmt: *mut ::core::ffi::c_void, irow: u16, foption: u16, flock: u16) -> i16;
    }
    SQLSetPos(::core::mem::transmute(hstmt), irow, foption, flock)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLSetScrollOptions(hstmt: *mut ::core::ffi::c_void, fconcurrency: u16, crowkeyset: i64, crowrowset: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetScrollOptions(hstmt: *mut ::core::ffi::c_void, fconcurrency: u16, crowkeyset: i64, crowrowset: u16) -> i16;
    }
    SQLSetScrollOptions(::core::mem::transmute(hstmt), fconcurrency, crowkeyset, crowrowset)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLSetScrollOptions(hstmt: *mut ::core::ffi::c_void, fconcurrency: u16, crowkeyset: i32, crowrowset: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetScrollOptions(hstmt: *mut ::core::ffi::c_void, fconcurrency: u16, crowkeyset: i32, crowrowset: u16) -> i16;
    }
    SQLSetScrollOptions(::core::mem::transmute(hstmt), fconcurrency, crowkeyset, crowrowset)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetStmtAttr(statementhandle: *mut ::core::ffi::c_void, attribute: i32, value: *const ::core::ffi::c_void, stringlength: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetStmtAttr(statementhandle: *mut ::core::ffi::c_void, attribute: i32, value: *const ::core::ffi::c_void, stringlength: i32) -> i16;
    }
    SQLSetStmtAttr(::core::mem::transmute(statementhandle), attribute, ::core::mem::transmute(value), stringlength)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSetStmtAttrW(hstmt: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetStmtAttrW(hstmt: *mut ::core::ffi::c_void, fattribute: i32, rgbvalue: *mut ::core::ffi::c_void, cbvaluemax: i32) -> i16;
    }
    SQLSetStmtAttrW(::core::mem::transmute(hstmt), fattribute, ::core::mem::transmute(rgbvalue), cbvaluemax)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[inline]
pub unsafe fn SQLSetStmtOption(statementhandle: *mut ::core::ffi::c_void, option: u16, value: u64) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetStmtOption(statementhandle: *mut ::core::ffi::c_void, option: u16, value: u64) -> i16;
    }
    SQLSetStmtOption(::core::mem::transmute(statementhandle), option, value)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[cfg(target_arch = "x86")]
#[inline]
pub unsafe fn SQLSetStmtOption(statementhandle: *mut ::core::ffi::c_void, option: u16, value: u32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSetStmtOption(statementhandle: *mut ::core::ffi::c_void, option: u16, value: u32) -> i16;
    }
    SQLSetStmtOption(::core::mem::transmute(statementhandle), option, value)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSpecialColumns(statementhandle: *mut ::core::ffi::c_void, identifiertype: u16, catalogname: ::core::option::Option<&[u8]>, schemaname: ::core::option::Option<&[u8]>, tablename: ::core::option::Option<&[u8]>, scope: u16, nullable: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSpecialColumns(statementhandle: *mut ::core::ffi::c_void, identifiertype: u16, catalogname: *const u8, namelength1: i16, schemaname: *const u8, namelength2: i16, tablename: *const u8, namelength3: i16, scope: u16, nullable: u16) -> i16;
    }
    SQLSpecialColumns(
        ::core::mem::transmute(statementhandle),
        identifiertype,
        ::core::mem::transmute(catalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        catalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(schemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        schemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(tablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        tablename.as_deref().map_or(0, |slice| slice.len() as _),
        scope,
        nullable,
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSpecialColumnsA(hstmt: *mut ::core::ffi::c_void, fcoltype: u16, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, sztablename: ::core::option::Option<&[u8]>, fscope: u16, fnullable: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSpecialColumnsA(hstmt: *mut ::core::ffi::c_void, fcoltype: u16, szcatalogname: *const u8, cbcatalogname: i16, szschemaname: *const u8, cbschemaname: i16, sztablename: *const u8, cbtablename: i16, fscope: u16, fnullable: u16) -> i16;
    }
    SQLSpecialColumnsA(
        ::core::mem::transmute(hstmt),
        fcoltype,
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        fscope,
        fnullable,
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLSpecialColumnsW(hstmt: *mut ::core::ffi::c_void, fcoltype: u16, szcatalogname: ::core::option::Option<&[u16]>, szschemaname: ::core::option::Option<&[u16]>, sztablename: ::core::option::Option<&[u16]>, fscope: u16, fnullable: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLSpecialColumnsW(hstmt: *mut ::core::ffi::c_void, fcoltype: u16, szcatalogname: *const u16, cchcatalogname: i16, szschemaname: *const u16, cchschemaname: i16, sztablename: *const u16, cchtablename: i16, fscope: u16, fnullable: u16) -> i16;
    }
    SQLSpecialColumnsW(
        ::core::mem::transmute(hstmt),
        fcoltype,
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        fscope,
        fnullable,
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLStatistics(statementhandle: *mut ::core::ffi::c_void, catalogname: ::core::option::Option<&[u8]>, schemaname: ::core::option::Option<&[u8]>, tablename: ::core::option::Option<&[u8]>, unique: u16, reserved: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLStatistics(statementhandle: *mut ::core::ffi::c_void, catalogname: *const u8, namelength1: i16, schemaname: *const u8, namelength2: i16, tablename: *const u8, namelength3: i16, unique: u16, reserved: u16) -> i16;
    }
    SQLStatistics(
        ::core::mem::transmute(statementhandle),
        ::core::mem::transmute(catalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        catalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(schemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        schemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(tablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        tablename.as_deref().map_or(0, |slice| slice.len() as _),
        unique,
        reserved,
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLStatisticsA(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, sztablename: ::core::option::Option<&[u8]>, funique: u16, faccuracy: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLStatisticsA(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cbcatalogname: i16, szschemaname: *const u8, cbschemaname: i16, sztablename: *const u8, cbtablename: i16, funique: u16, faccuracy: u16) -> i16;
    }
    SQLStatisticsA(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        funique,
        faccuracy,
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLStatisticsW(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u16]>, szschemaname: ::core::option::Option<&[u16]>, sztablename: ::core::option::Option<&[u16]>, funique: u16, faccuracy: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLStatisticsW(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u16, cchcatalogname: i16, szschemaname: *const u16, cchschemaname: i16, sztablename: *const u16, cchtablename: i16, funique: u16, faccuracy: u16) -> i16;
    }
    SQLStatisticsW(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        funique,
        faccuracy,
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLTablePrivileges(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, sztablename: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLTablePrivileges(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cchcatalogname: i16, szschemaname: *const u8, cchschemaname: i16, sztablename: *const u8, cchtablename: i16) -> i16;
    }
    SQLTablePrivileges(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLTablePrivilegesA(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, sztablename: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLTablePrivilegesA(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cbcatalogname: i16, szschemaname: *const u8, cbschemaname: i16, sztablename: *const u8, cbtablename: i16) -> i16;
    }
    SQLTablePrivilegesA(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLTablePrivilegesW(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u16]>, szschemaname: ::core::option::Option<&[u16]>, sztablename: ::core::option::Option<&[u16]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLTablePrivilegesW(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u16, cchcatalogname: i16, szschemaname: *const u16, cchschemaname: i16, sztablename: *const u16, cchtablename: i16) -> i16;
    }
    SQLTablePrivilegesW(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLTables(statementhandle: *mut ::core::ffi::c_void, catalogname: ::core::option::Option<&[u8]>, schemaname: ::core::option::Option<&[u8]>, tablename: ::core::option::Option<&[u8]>, tabletype: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLTables(statementhandle: *mut ::core::ffi::c_void, catalogname: *const u8, namelength1: i16, schemaname: *const u8, namelength2: i16, tablename: *const u8, namelength3: i16, tabletype: *const u8, namelength4: i16) -> i16;
    }
    SQLTables(
        ::core::mem::transmute(statementhandle),
        ::core::mem::transmute(catalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        catalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(schemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        schemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(tablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        tablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(tabletype.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        tabletype.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLTablesA(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u8]>, szschemaname: ::core::option::Option<&[u8]>, sztablename: ::core::option::Option<&[u8]>, sztabletype: ::core::option::Option<&[u8]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLTablesA(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u8, cbcatalogname: i16, szschemaname: *const u8, cbschemaname: i16, sztablename: *const u8, cbtablename: i16, sztabletype: *const u8, cbtabletype: i16) -> i16;
    }
    SQLTablesA(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztabletype.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztabletype.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLTablesW(hstmt: *mut ::core::ffi::c_void, szcatalogname: ::core::option::Option<&[u16]>, szschemaname: ::core::option::Option<&[u16]>, sztablename: ::core::option::Option<&[u16]>, sztabletype: ::core::option::Option<&[u16]>) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLTablesW(hstmt: *mut ::core::ffi::c_void, szcatalogname: *const u16, cchcatalogname: i16, szschemaname: *const u16, cchschemaname: i16, sztablename: *const u16, cchtablename: i16, sztabletype: *const u16, cchtabletype: i16) -> i16;
    }
    SQLTablesW(
        ::core::mem::transmute(hstmt),
        ::core::mem::transmute(szcatalogname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szcatalogname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(szschemaname.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        szschemaname.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztablename.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztablename.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(sztabletype.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        sztabletype.as_deref().map_or(0, |slice| slice.len() as _),
    )
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn SQLTransact(environmenthandle: *mut ::core::ffi::c_void, connectionhandle: *mut ::core::ffi::c_void, completiontype: u16) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn SQLTransact(environmenthandle: *mut ::core::ffi::c_void, connectionhandle: *mut ::core::ffi::c_void, completiontype: u16) -> i16;
    }
    SQLTransact(::core::mem::transmute(environmenthandle), ::core::mem::transmute(connectionhandle), completiontype)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_batch(param0: *mut ::core::ffi::c_void) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_batch(param0: *mut ::core::ffi::c_void) -> i32;
    }
    bcp_batch(::core::mem::transmute(param0))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_bind(param0: *mut ::core::ffi::c_void, param1: *mut u8, param2: i32, param3: i32, param4: *mut u8, param5: i32, param6: i32, param7: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_bind(param0: *mut ::core::ffi::c_void, param1: *mut u8, param2: i32, param3: i32, param4: *mut u8, param5: i32, param6: i32, param7: i32) -> i16;
    }
    bcp_bind(::core::mem::transmute(param0), ::core::mem::transmute(param1), param2, param3, ::core::mem::transmute(param4), param5, param6, param7)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_colfmt(param0: *mut ::core::ffi::c_void, param1: i32, param2: u8, param3: i32, param4: i32, param5: *mut u8, param6: i32, param7: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_colfmt(param0: *mut ::core::ffi::c_void, param1: i32, param2: u8, param3: i32, param4: i32, param5: *mut u8, param6: i32, param7: i32) -> i16;
    }
    bcp_colfmt(::core::mem::transmute(param0), param1, param2, param3, param4, ::core::mem::transmute(param5), param6, param7)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_collen(param0: *mut ::core::ffi::c_void, param1: i32, param2: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_collen(param0: *mut ::core::ffi::c_void, param1: i32, param2: i32) -> i16;
    }
    bcp_collen(::core::mem::transmute(param0), param1, param2)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_colptr(param0: *mut ::core::ffi::c_void, param1: *mut u8, param2: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_colptr(param0: *mut ::core::ffi::c_void, param1: *mut u8, param2: i32) -> i16;
    }
    bcp_colptr(::core::mem::transmute(param0), ::core::mem::transmute(param1), param2)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_columns(param0: *mut ::core::ffi::c_void, param1: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_columns(param0: *mut ::core::ffi::c_void, param1: i32) -> i16;
    }
    bcp_columns(::core::mem::transmute(param0), param1)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_control(param0: *mut ::core::ffi::c_void, param1: i32, param2: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_control(param0: *mut ::core::ffi::c_void, param1: i32, param2: *mut ::core::ffi::c_void) -> i16;
    }
    bcp_control(::core::mem::transmute(param0), param1, ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_done(param0: *mut ::core::ffi::c_void) -> i32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_done(param0: *mut ::core::ffi::c_void) -> i32;
    }
    bcp_done(::core::mem::transmute(param0))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_exec(param0: *mut ::core::ffi::c_void, param1: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_exec(param0: *mut ::core::ffi::c_void, param1: *mut i32) -> i16;
    }
    bcp_exec(::core::mem::transmute(param0), ::core::mem::transmute(param1))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_getcolfmt(param0: *mut ::core::ffi::c_void, param1: i32, param2: i32, param3: *mut ::core::ffi::c_void, param4: i32, param5: *mut i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_getcolfmt(param0: *mut ::core::ffi::c_void, param1: i32, param2: i32, param3: *mut ::core::ffi::c_void, param4: i32, param5: *mut i32) -> i16;
    }
    bcp_getcolfmt(::core::mem::transmute(param0), param1, param2, ::core::mem::transmute(param3), param4, ::core::mem::transmute(param5))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_initA<'a, P0, P1, P2>(param0: *mut ::core::ffi::c_void, param1: P0, param2: P1, param3: P2, param4: i32) -> i16
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
    P1: ::std::convert::Into<::windows::core::PCSTR>,
    P2: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_initA(param0: *mut ::core::ffi::c_void, param1: ::windows::core::PCSTR, param2: ::windows::core::PCSTR, param3: ::windows::core::PCSTR, param4: i32) -> i16;
    }
    bcp_initA(::core::mem::transmute(param0), param1.into(), param2.into(), param3.into(), param4)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_initW<'a, P0, P1, P2>(param0: *mut ::core::ffi::c_void, param1: P0, param2: P1, param3: P2, param4: i32) -> i16
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_initW(param0: *mut ::core::ffi::c_void, param1: ::windows::core::PCWSTR, param2: ::windows::core::PCWSTR, param3: ::windows::core::PCWSTR, param4: i32) -> i16;
    }
    bcp_initW(::core::mem::transmute(param0), param1.into(), param2.into(), param3.into(), param4)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_moretext(param0: *mut ::core::ffi::c_void, param1: i32, param2: *mut u8) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_moretext(param0: *mut ::core::ffi::c_void, param1: i32, param2: *mut u8) -> i16;
    }
    bcp_moretext(::core::mem::transmute(param0), param1, ::core::mem::transmute(param2))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_readfmtA<'a, P0>(param0: *mut ::core::ffi::c_void, param1: P0) -> i16
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_readfmtA(param0: *mut ::core::ffi::c_void, param1: ::windows::core::PCSTR) -> i16;
    }
    bcp_readfmtA(::core::mem::transmute(param0), param1.into())
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_readfmtW<'a, P0>(param0: *mut ::core::ffi::c_void, param1: P0) -> i16
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_readfmtW(param0: *mut ::core::ffi::c_void, param1: ::windows::core::PCWSTR) -> i16;
    }
    bcp_readfmtW(::core::mem::transmute(param0), param1.into())
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_sendrow(param0: *mut ::core::ffi::c_void) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_sendrow(param0: *mut ::core::ffi::c_void) -> i16;
    }
    bcp_sendrow(::core::mem::transmute(param0))
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_setcolfmt(param0: *mut ::core::ffi::c_void, param1: i32, param2: i32, param3: *mut ::core::ffi::c_void, param4: i32) -> i16 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_setcolfmt(param0: *mut ::core::ffi::c_void, param1: i32, param2: i32, param3: *mut ::core::ffi::c_void, param4: i32) -> i16;
    }
    bcp_setcolfmt(::core::mem::transmute(param0), param1, param2, ::core::mem::transmute(param3), param4)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_writefmtA<'a, P0>(param0: *mut ::core::ffi::c_void, param1: P0) -> i16
where
    P0: ::std::convert::Into<::windows::core::PCSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_writefmtA(param0: *mut ::core::ffi::c_void, param1: ::windows::core::PCSTR) -> i16;
    }
    bcp_writefmtA(::core::mem::transmute(param0), param1.into())
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn bcp_writefmtW<'a, P0>(param0: *mut ::core::ffi::c_void, param1: P0) -> i16
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn bcp_writefmtW(param0: *mut ::core::ffi::c_void, param1: ::windows::core::PCWSTR) -> i16;
    }
    bcp_writefmtW(::core::mem::transmute(param0), param1.into())
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn dbprtypeA(param0: i32) -> ::windows::core::PSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn dbprtypeA(param0: i32) -> ::windows::core::PSTR;
    }
    dbprtypeA(param0)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[inline]
pub unsafe fn dbprtypeW(param0: i32) -> ::windows::core::PWSTR {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn dbprtypeW(param0: i32) -> ::windows::core::PWSTR;
    }
    dbprtypeW(param0)
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct DataSource(::windows::core::IUnknown);
impl DataSource {
    pub unsafe fn getDataMember(&self, bstrdm: *const u16, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).getDataMember)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(bstrdm), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn getDataMemberName(&self, lindex: i32) -> ::windows::core::Result<*mut u16> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).getDataMemberName)(::windows::core::Vtable::as_raw(self), lindex, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut u16>(result__)
    }
    pub unsafe fn getDataMemberCount(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).getDataMemberCount)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn addDataSourceListener<'a, P0>(&self, pdsl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, DataSourceListener>>,
    {
        (::windows::core::Vtable::vtable(self).addDataSourceListener)(::windows::core::Vtable::as_raw(self), pdsl.into().abi()).ok()
    }
    pub unsafe fn removeDataSourceListener<'a, P0>(&self, pdsl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, DataSourceListener>>,
    {
        (::windows::core::Vtable::vtable(self).removeDataSourceListener)(::windows::core::Vtable::as_raw(self), pdsl.into().abi()).ok()
    }
}
::windows::core::interface_hierarchy!(DataSource, ::windows::core::IUnknown);
impl ::core::clone::Clone for DataSource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for DataSource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for DataSource {}
impl ::core::fmt::Debug for DataSource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DataSource").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for DataSource {
    type Vtable = DataSource_Vtbl;
}
unsafe impl ::windows::core::Interface for DataSource {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c0ffab3_cd84_11d0_949a_00a0c91110ed);
}
#[repr(C)]
#[doc(hidden)]
pub struct DataSource_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub getDataMember: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16, riid: *const ::windows::core::GUID, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub getDataMemberName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, pbstrdm: *mut *mut u16) -> ::windows::core::HRESULT,
    pub getDataMemberCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub addDataSourceListener: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdsl: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub removeDataSourceListener: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdsl: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct DataSourceListener(::windows::core::IUnknown);
impl DataSourceListener {
    pub unsafe fn dataMemberChanged(&self, bstrdm: *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).dataMemberChanged)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(bstrdm)).ok()
    }
    pub unsafe fn dataMemberAdded(&self, bstrdm: *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).dataMemberAdded)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(bstrdm)).ok()
    }
    pub unsafe fn dataMemberRemoved(&self, bstrdm: *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).dataMemberRemoved)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(bstrdm)).ok()
    }
}
::windows::core::interface_hierarchy!(DataSourceListener, ::windows::core::IUnknown);
impl ::core::clone::Clone for DataSourceListener {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for DataSourceListener {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for DataSourceListener {}
impl ::core::fmt::Debug for DataSourceListener {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DataSourceListener").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for DataSourceListener {
    type Vtable = DataSourceListener_Vtbl;
}
unsafe impl ::windows::core::Interface for DataSourceListener {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c0ffab2_cd84_11d0_949a_00a0c91110ed);
}
#[repr(C)]
#[doc(hidden)]
pub struct DataSourceListener_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub dataMemberChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16) -> ::windows::core::HRESULT,
    pub dataMemberAdded: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16) -> ::windows::core::HRESULT,
    pub dataMemberRemoved: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdm: *const u16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DataSourceObject(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DataSourceObject {}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(DataSourceObject, ::windows::core::IUnknown, super::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DataSourceObject {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DataSourceObject {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DataSourceObject {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DataSourceObject {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DataSourceObject").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for DataSourceObject {
    type Vtable = DataSourceObject_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DataSourceObject {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0ae9a4e4_18d4_11d1_b3b3_00aa00c1a924);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DataSourceObject_Vtbl {
    pub base__: super::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IAccessor(::windows::core::IUnknown);
impl IAccessor {
    pub unsafe fn AddRefAccessor<'a, P0>(&self, haccessor: P0) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).AddRefAccessor)(::windows::core::Vtable::as_raw(self), haccessor.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateAccessor(&self, dwaccessorflags: u32, cbindings: usize, rgbindings: *const DBBINDING, cbrowsize: usize, phaccessor: *mut HACCESSOR, rgstatus: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CreateAccessor)(::windows::core::Vtable::as_raw(self), dwaccessorflags, cbindings, ::core::mem::transmute(rgbindings), cbrowsize, ::core::mem::transmute(phaccessor), ::core::mem::transmute(rgstatus.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetBindings<'a, P0>(&self, haccessor: P0, pdwaccessorflags: *mut u32, pcbindings: ::core::option::Option<*mut usize>, prgbindings: ::core::option::Option<*mut *mut DBBINDING>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).GetBindings)(::windows::core::Vtable::as_raw(self), haccessor.into(), ::core::mem::transmute(pdwaccessorflags), ::core::mem::transmute(pcbindings.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(prgbindings.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn ReleaseAccessor<'a, P0>(&self, haccessor: P0) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ReleaseAccessor)(::windows::core::Vtable::as_raw(self), haccessor.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(IAccessor, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAccessor {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessor {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessor {}
impl ::core::fmt::Debug for IAccessor {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessor").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAccessor {
    type Vtable = IAccessor_Vtbl;
}
unsafe impl ::windows::core::Interface for IAccessor {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8c_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessor_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AddRefAccessor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: HACCESSOR, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateAccessor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwaccessorflags: u32, cbindings: usize, rgbindings: *const ::core::mem::ManuallyDrop<DBBINDING>, cbrowsize: usize, phaccessor: *mut HACCESSOR, rgstatus: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateAccessor: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetBindings: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: HACCESSOR, pdwaccessorflags: *mut u32, pcbindings: *mut usize, prgbindings: *mut *mut ::core::mem::ManuallyDrop<DBBINDING>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetBindings: usize,
    pub ReleaseAccessor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: HACCESSOR, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IAlterIndex(::windows::core::IUnknown);
impl IAlterIndex {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AlterIndex(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pindexid: *mut super::super::Storage::IndexServer::DBID, pnewindexid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AlterIndex)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid), ::core::mem::transmute(pnewindexid), cpropertysets, ::core::mem::transmute(rgpropertysets)).ok()
    }
}
::windows::core::interface_hierarchy!(IAlterIndex, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAlterIndex {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAlterIndex {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAlterIndex {}
impl ::core::fmt::Debug for IAlterIndex {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAlterIndex").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAlterIndex {
    type Vtable = IAlterIndex_Vtbl;
}
unsafe impl ::windows::core::Interface for IAlterIndex {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa6_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAlterIndex_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub AlterIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pindexid: *mut super::super::Storage::IndexServer::DBID, pnewindexid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    AlterIndex: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IAlterTable(::windows::core::IUnknown);
impl IAlterTable {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AlterColumn(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pcolumnid: *mut super::super::Storage::IndexServer::DBID, dwcolumndescflags: u32, pcolumndesc: *mut DBCOLUMNDESC) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AlterColumn)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pcolumnid), dwcolumndescflags, ::core::mem::transmute(pcolumndesc)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AlterTable(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pnewtableid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AlterTable)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pnewtableid), cpropertysets, ::core::mem::transmute(rgpropertysets)).ok()
    }
}
::windows::core::interface_hierarchy!(IAlterTable, ::windows::core::IUnknown);
impl ::core::clone::Clone for IAlterTable {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAlterTable {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAlterTable {}
impl ::core::fmt::Debug for IAlterTable {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAlterTable").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IAlterTable {
    type Vtable = IAlterTable_Vtbl;
}
unsafe impl ::windows::core::Interface for IAlterTable {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa5_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAlterTable_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub AlterColumn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pcolumnid: *mut super::super::Storage::IndexServer::DBID, dwcolumndescflags: u32, pcolumndesc: *mut ::core::mem::ManuallyDrop<DBCOLUMNDESC>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    AlterColumn: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub AlterTable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pnewtableid: *mut super::super::Storage::IndexServer::DBID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    AlterTable: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IBindResource(::windows::core::IUnknown);
impl IBindResource {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Bind<'a, P0, P1, P2>(&self, punkouter: P0, pwszurl: P1, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: P2, pimplsession: ::core::option::Option<*mut DBIMPLICITSESSION>, pdwbindstatus: ::core::option::Option<*mut u32>, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IAuthenticate>>,
    {
        (::windows::core::Vtable::vtable(self).Bind)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), pwszurl.into(), dwbindurlflags, ::core::mem::transmute(rguid), ::core::mem::transmute(riid), pauthenticate.into().abi(), ::core::mem::transmute(pimplsession.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwbindstatus.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppunk)).ok()
    }
}
::windows::core::interface_hierarchy!(IBindResource, ::windows::core::IUnknown);
impl ::core::clone::Clone for IBindResource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBindResource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBindResource {}
impl ::core::fmt::Debug for IBindResource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBindResource").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IBindResource {
    type Vtable = IBindResource_Vtbl;
}
unsafe impl ::windows::core::Interface for IBindResource {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab1_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBindResource_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Bind: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: *mut ::core::ffi::c_void, pimplsession: *mut ::core::mem::ManuallyDrop<DBIMPLICITSESSION>, pdwbindstatus: *mut u32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Bind: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IChapteredRowset(::windows::core::IUnknown);
impl IChapteredRowset {
    pub unsafe fn AddRefChapter(&self, hchapter: usize) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).AddRefChapter)(::windows::core::Vtable::as_raw(self), hchapter, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn ReleaseChapter(&self, hchapter: usize) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ReleaseChapter)(::windows::core::Vtable::as_raw(self), hchapter, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(IChapteredRowset, ::windows::core::IUnknown);
impl ::core::clone::Clone for IChapteredRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IChapteredRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IChapteredRowset {}
impl ::core::fmt::Debug for IChapteredRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IChapteredRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IChapteredRowset {
    type Vtable = IChapteredRowset_Vtbl;
}
unsafe impl ::windows::core::Interface for IChapteredRowset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a93_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IChapteredRowset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AddRefChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
    pub ReleaseChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, pcrefcount: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IColumnMapper(::windows::core::IUnknown);
impl IColumnMapper {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetPropInfoFromName<'a, P0>(&self, wcspropname: P0, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).GetPropInfoFromName)(::windows::core::Vtable::as_raw(self), wcspropname.into(), ::core::mem::transmute(pppropid), ::core::mem::transmute(pproptype), ::core::mem::transmute(puiwidth)).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetPropInfoFromId(&self, ppropid: *const super::super::Storage::IndexServer::DBID, pwcsname: *mut *mut u16, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetPropInfoFromId)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppropid), ::core::mem::transmute(pwcsname), ::core::mem::transmute(pproptype), ::core::mem::transmute(puiwidth)).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn EnumPropInfo(&self, ientry: u32, pwcsname: *const *const u16, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).EnumPropInfo)(::windows::core::Vtable::as_raw(self), ientry, ::core::mem::transmute(pwcsname), ::core::mem::transmute(pppropid), ::core::mem::transmute(pproptype), ::core::mem::transmute(puiwidth)).ok()
    }
    pub unsafe fn IsMapUpToDate(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).IsMapUpToDate)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IColumnMapper, ::windows::core::IUnknown);
impl ::core::clone::Clone for IColumnMapper {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnMapper {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnMapper {}
impl ::core::fmt::Debug for IColumnMapper {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnMapper").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IColumnMapper {
    type Vtable = IColumnMapper_Vtbl;
}
unsafe impl ::windows::core::Interface for IColumnMapper {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b63e37a_9ccc_11d0_bcdb_00805fccce04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnMapper_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetPropInfoFromName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wcspropname: ::windows::core::PCWSTR, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetPropInfoFromName: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetPropInfoFromId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppropid: *const super::super::Storage::IndexServer::DBID, pwcsname: *mut *mut u16, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetPropInfoFromId: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub EnumPropInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ientry: u32, pwcsname: *const *const u16, pppropid: *mut *mut super::super::Storage::IndexServer::DBID, pproptype: *mut u16, puiwidth: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    EnumPropInfo: usize,
    pub IsMapUpToDate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IColumnMapperCreator(::windows::core::IUnknown);
impl IColumnMapperCreator {
    pub unsafe fn GetColumnMapper<'a, P0, P1>(&self, wcsmachinename: P0, wcscatalogname: P1) -> ::windows::core::Result<IColumnMapper>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetColumnMapper)(::windows::core::Vtable::as_raw(self), wcsmachinename.into(), wcscatalogname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IColumnMapper>(result__)
    }
}
::windows::core::interface_hierarchy!(IColumnMapperCreator, ::windows::core::IUnknown);
impl ::core::clone::Clone for IColumnMapperCreator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnMapperCreator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnMapperCreator {}
impl ::core::fmt::Debug for IColumnMapperCreator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnMapperCreator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IColumnMapperCreator {
    type Vtable = IColumnMapperCreator_Vtbl;
}
unsafe impl ::windows::core::Interface for IColumnMapperCreator {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b63e37b_9ccc_11d0_bcdb_00805fccce04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnMapperCreator_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetColumnMapper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wcsmachinename: ::windows::core::PCWSTR, wcscatalogname: ::windows::core::PCWSTR, ppcolumnmapper: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IColumnsInfo(::windows::core::IUnknown);
impl IColumnsInfo {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn GetColumnInfo(&self, pccolumns: *mut usize, prginfo: ::core::option::Option<*mut *mut DBCOLUMNINFO>, ppstringsbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetColumnInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prginfo.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppstringsbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn MapColumnIDs(&self, ccolumnids: usize, rgcolumnids: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>) -> ::windows::core::Result<usize> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).MapColumnIDs)(::windows::core::Vtable::as_raw(self), ccolumnids, ::core::mem::transmute(rgcolumnids.unwrap_or(::std::ptr::null())), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<usize>(result__)
    }
}
::windows::core::interface_hierarchy!(IColumnsInfo, ::windows::core::IUnknown);
impl ::core::clone::Clone for IColumnsInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnsInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnsInfo {}
impl ::core::fmt::Debug for IColumnsInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnsInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IColumnsInfo {
    type Vtable = IColumnsInfo_Vtbl;
}
unsafe impl ::windows::core::Interface for IColumnsInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a11_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnsInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub GetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pccolumns: *mut usize, prginfo: *mut *mut ::core::mem::ManuallyDrop<DBCOLUMNINFO>, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))]
    GetColumnInfo: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub MapColumnIDs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumnids: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgcolumns: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    MapColumnIDs: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IColumnsInfo2(::windows::core::IUnknown);
impl IColumnsInfo2 {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn GetColumnInfo(&self, pccolumns: *mut usize, prginfo: ::core::option::Option<*mut *mut DBCOLUMNINFO>, ppstringsbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetColumnInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prginfo.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppstringsbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn MapColumnIDs(&self, ccolumnids: usize, rgcolumnids: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>) -> ::windows::core::Result<usize> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.MapColumnIDs)(::windows::core::Vtable::as_raw(self), ccolumnids, ::core::mem::transmute(rgcolumnids.unwrap_or(::std::ptr::null())), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<usize>(result__)
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn GetRestrictedColumnInfo(&self, rgcolumnidmasks: &[super::super::Storage::IndexServer::DBID], dwflags: u32, pccolumns: *mut usize, prgcolumnids: *mut *mut super::super::Storage::IndexServer::DBID, prgcolumninfo: *mut *mut DBCOLUMNINFO, ppstringsbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetRestrictedColumnInfo)(::windows::core::Vtable::as_raw(self), rgcolumnidmasks.len() as _, ::core::mem::transmute(rgcolumnidmasks.as_ptr()), dwflags, ::core::mem::transmute(pccolumns), ::core::mem::transmute(prgcolumnids), ::core::mem::transmute(prgcolumninfo), ::core::mem::transmute(ppstringsbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(IColumnsInfo2, ::windows::core::IUnknown, IColumnsInfo);
impl ::core::clone::Clone for IColumnsInfo2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnsInfo2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnsInfo2 {}
impl ::core::fmt::Debug for IColumnsInfo2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnsInfo2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IColumnsInfo2 {
    type Vtable = IColumnsInfo2_Vtbl;
}
unsafe impl ::windows::core::Interface for IColumnsInfo2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab8_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnsInfo2_Vtbl {
    pub base__: IColumnsInfo_Vtbl,
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub GetRestrictedColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumnidmasks: usize, rgcolumnidmasks: *const super::super::Storage::IndexServer::DBID, dwflags: u32, pccolumns: *mut usize, prgcolumnids: *mut *mut super::super::Storage::IndexServer::DBID, prgcolumninfo: *mut *mut ::core::mem::ManuallyDrop<DBCOLUMNINFO>, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))]
    GetRestrictedColumnInfo: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IColumnsRowset(::windows::core::IUnknown);
impl IColumnsRowset {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetAvailableColumns(&self, pcoptcolumns: *mut usize, prgoptcolumns: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetAvailableColumns)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcoptcolumns), ::core::mem::transmute(prgoptcolumns)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetColumnsRowset<'a, P0>(&self, punkouter: P0, rgoptcolumns: &[super::super::Storage::IndexServer::DBID], riid: *const ::windows::core::GUID, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>, ppcolrowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).GetColumnsRowset)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), rgoptcolumns.len() as _, ::core::mem::transmute(rgoptcolumns.as_ptr()), ::core::mem::transmute(riid), rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(ppcolrowset)).ok()
    }
}
::windows::core::interface_hierarchy!(IColumnsRowset, ::windows::core::IUnknown);
impl ::core::clone::Clone for IColumnsRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnsRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnsRowset {}
impl ::core::fmt::Debug for IColumnsRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnsRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IColumnsRowset {
    type Vtable = IColumnsRowset_Vtbl;
}
unsafe impl ::windows::core::Interface for IColumnsRowset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a10_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnsRowset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetAvailableColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcoptcolumns: *mut usize, prgoptcolumns: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetAvailableColumns: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetColumnsRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, coptcolumns: usize, rgoptcolumns: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, ppcolrowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetColumnsRowset: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommand(::windows::core::IUnknown);
impl ICommand {
    pub unsafe fn Cancel(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Cancel)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Execute<'a, P0>(&self, punkouter: P0, riid: *const ::windows::core::GUID, pparams: ::core::option::Option<*mut DBPARAMS>, pcrowsaffected: ::core::option::Option<*mut isize>, pprowset: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).Execute)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(pparams.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcrowsaffected.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pprowset.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetDBSession(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetDBSession)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(ICommand, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommand {}
impl ::core::fmt::Debug for ICommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommand").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommand {
    type Vtable = ICommand_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommand {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a63_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommand_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Cancel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Execute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pparams: *mut DBPARAMS, pcrowsaffected: *mut isize, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetDBSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandCost(::windows::core::IUnknown);
impl ICommandCost {
    pub unsafe fn GetAccumulatedCost<'a, P0>(&self, pwszrowsetname: P0, pccostlimits: *mut u32, prgcostlimits: *mut *mut DBCOST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).GetAccumulatedCost)(::windows::core::Vtable::as_raw(self), pwszrowsetname.into(), ::core::mem::transmute(pccostlimits), ::core::mem::transmute(prgcostlimits)).ok()
    }
    pub unsafe fn GetCostEstimate<'a, P0>(&self, pwszrowsetname: P0, pccostestimates: *mut u32, prgcostestimates: *mut DBCOST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).GetCostEstimate)(::windows::core::Vtable::as_raw(self), pwszrowsetname.into(), ::core::mem::transmute(pccostestimates), ::core::mem::transmute(prgcostestimates)).ok()
    }
    pub unsafe fn GetCostGoals<'a, P0>(&self, pwszrowsetname: P0, pccostgoals: *mut u32, prgcostgoals: *mut DBCOST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).GetCostGoals)(::windows::core::Vtable::as_raw(self), pwszrowsetname.into(), ::core::mem::transmute(pccostgoals), ::core::mem::transmute(prgcostgoals)).ok()
    }
    pub unsafe fn GetCostLimits<'a, P0>(&self, pwszrowsetname: P0, pccostlimits: *mut u32, prgcostlimits: *mut DBCOST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).GetCostLimits)(::windows::core::Vtable::as_raw(self), pwszrowsetname.into(), ::core::mem::transmute(pccostlimits), ::core::mem::transmute(prgcostlimits)).ok()
    }
    pub unsafe fn SetCostGoals<'a, P0>(&self, pwszrowsetname: P0, ccostgoals: u32, rgcostgoals: *const DBCOST) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetCostGoals)(::windows::core::Vtable::as_raw(self), pwszrowsetname.into(), ccostgoals, ::core::mem::transmute(rgcostgoals)).ok()
    }
    pub unsafe fn SetCostLimits<'a, P0>(&self, pwszrowsetname: P0, ccostlimits: u32, prgcostlimits: *mut DBCOST, dwexecutionflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetCostLimits)(::windows::core::Vtable::as_raw(self), pwszrowsetname.into(), ccostlimits, ::core::mem::transmute(prgcostlimits), dwexecutionflags).ok()
    }
}
::windows::core::interface_hierarchy!(ICommandCost, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICommandCost {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandCost {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandCost {}
impl ::core::fmt::Debug for ICommandCost {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandCost").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommandCost {
    type Vtable = ICommandCost_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommandCost {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a4e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandCost_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetAccumulatedCost: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, pccostlimits: *mut u32, prgcostlimits: *mut *mut DBCOST) -> ::windows::core::HRESULT,
    pub GetCostEstimate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, pccostestimates: *mut u32, prgcostestimates: *mut DBCOST) -> ::windows::core::HRESULT,
    pub GetCostGoals: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, pccostgoals: *mut u32, prgcostgoals: *mut DBCOST) -> ::windows::core::HRESULT,
    pub GetCostLimits: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, pccostlimits: *mut u32, prgcostlimits: *mut DBCOST) -> ::windows::core::HRESULT,
    pub SetCostGoals: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, ccostgoals: u32, rgcostgoals: *const DBCOST) -> ::windows::core::HRESULT,
    pub SetCostLimits: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszrowsetname: ::windows::core::PCWSTR, ccostlimits: u32, prgcostlimits: *mut DBCOST, dwexecutionflags: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandPersist(::windows::core::IUnknown);
impl ICommandPersist {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DeleteCommand(&self, pcommandid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DeleteCommand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcommandid)).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetCurrentCommand(&self, ppcommandid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCurrentCommand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppcommandid)).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn LoadCommand(&self, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).LoadCommand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcommandid), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn SaveCommand(&self, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SaveCommand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcommandid), dwflags).ok()
    }
}
::windows::core::interface_hierarchy!(ICommandPersist, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICommandPersist {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandPersist {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandPersist {}
impl ::core::fmt::Debug for ICommandPersist {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandPersist").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommandPersist {
    type Vtable = ICommandPersist_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommandPersist {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa7_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandPersist_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub DeleteCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcommandid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    DeleteCommand: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetCurrentCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcommandid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetCurrentCommand: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub LoadCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    LoadCommand: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub SaveCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcommandid: *mut super::super::Storage::IndexServer::DBID, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    SaveCommand: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandPrepare(::windows::core::IUnknown);
impl ICommandPrepare {
    pub unsafe fn Prepare(&self, cexpectedruns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Prepare)(::windows::core::Vtable::as_raw(self), cexpectedruns).ok()
    }
    pub unsafe fn Unprepare(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Unprepare)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(ICommandPrepare, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICommandPrepare {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandPrepare {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandPrepare {}
impl ::core::fmt::Debug for ICommandPrepare {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandPrepare").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommandPrepare {
    type Vtable = ICommandPrepare_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommandPrepare {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a26_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandPrepare_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Prepare: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cexpectedruns: u32) -> ::windows::core::HRESULT,
    pub Unprepare: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandProperties(::windows::core::IUnknown);
impl ICommandProperties {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, rgpropertyidsets: ::core::option::Option<&[DBPROPIDSET]>, pcpropertysets: *mut u32, prgpropertysets: ::core::option::Option<*mut *mut DBPROPSET>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetProperties)(::windows::core::Vtable::as_raw(self), rgpropertyidsets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertyidsets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperties(&self, rgpropertysets: &[DBPROPSET]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetProperties)(::windows::core::Vtable::as_raw(self), rgpropertysets.len() as _, ::core::mem::transmute(rgpropertysets.as_ptr())).ok()
    }
}
::windows::core::interface_hierarchy!(ICommandProperties, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICommandProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandProperties {}
impl ::core::fmt::Debug for ICommandProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommandProperties {
    type Vtable = ICommandProperties_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommandProperties {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a79_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandProperties_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetProperties: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *const DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetProperties: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandStream(::windows::core::IUnknown);
impl ICommandStream {
    pub unsafe fn GetCommandStream(&self, piid: ::core::option::Option<*mut ::windows::core::GUID>, pguiddialect: ::core::option::Option<*mut ::windows::core::GUID>, ppcommandstream: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCommandStream)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(piid.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pguiddialect.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppcommandstream)).ok()
    }
    pub unsafe fn SetCommandStream<'a, P0>(&self, riid: *const ::windows::core::GUID, rguiddialect: *const ::windows::core::GUID, pcommandstream: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).SetCommandStream)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(rguiddialect), pcommandstream.into().abi()).ok()
    }
}
::windows::core::interface_hierarchy!(ICommandStream, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICommandStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandStream {}
impl ::core::fmt::Debug for ICommandStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandStream").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommandStream {
    type Vtable = ICommandStream_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommandStream {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733abf_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandStream_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetCommandStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, piid: *mut ::windows::core::GUID, pguiddialect: *mut ::windows::core::GUID, ppcommandstream: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetCommandStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, rguiddialect: *const ::windows::core::GUID, pcommandstream: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandText(::windows::core::IUnknown);
impl ICommandText {
    pub unsafe fn Cancel(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.Cancel)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Execute<'a, P0>(&self, punkouter: P0, riid: *const ::windows::core::GUID, pparams: ::core::option::Option<*mut DBPARAMS>, pcrowsaffected: ::core::option::Option<*mut isize>, pprowset: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).base__.Execute)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(pparams.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcrowsaffected.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pprowset.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetDBSession(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetDBSession)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn GetCommandText(&self, pguiddialect: ::core::option::Option<*mut ::windows::core::GUID>, ppwszcommand: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCommandText)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pguiddialect.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppwszcommand)).ok()
    }
    pub unsafe fn SetCommandText<'a, P0>(&self, rguiddialect: *const ::windows::core::GUID, pwszcommand: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetCommandText)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(rguiddialect), pwszcommand.into()).ok()
    }
}
::windows::core::interface_hierarchy!(ICommandText, ::windows::core::IUnknown, ICommand);
impl ::core::clone::Clone for ICommandText {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandText {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandText {}
impl ::core::fmt::Debug for ICommandText {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandText").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommandText {
    type Vtable = ICommandText_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommandText {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a27_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandText_Vtbl {
    pub base__: ICommand_Vtbl,
    pub GetCommandText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguiddialect: *mut ::windows::core::GUID, ppwszcommand: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetCommandText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rguiddialect: *const ::windows::core::GUID, pwszcommand: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandValidate(::windows::core::IUnknown);
impl ICommandValidate {
    pub unsafe fn ValidateCompletely(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ValidateCompletely)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn ValidateSyntax(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ValidateSyntax)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(ICommandValidate, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICommandValidate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandValidate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandValidate {}
impl ::core::fmt::Debug for ICommandValidate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandValidate").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommandValidate {
    type Vtable = ICommandValidate_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommandValidate {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a18_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandValidate_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub ValidateCompletely: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ValidateSyntax: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICommandWithParameters(::windows::core::IUnknown);
impl ICommandWithParameters {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetParameterInfo(&self, pcparams: *mut usize, prgparaminfo: ::core::option::Option<*mut *mut DBPARAMINFO>, ppnamesbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetParameterInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcparams), ::core::mem::transmute(prgparaminfo.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppnamesbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn MapParameterNames(&self, cparamnames: usize, rgparamnames: *const ::windows::core::PWSTR) -> ::windows::core::Result<isize> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).MapParameterNames)(::windows::core::Vtable::as_raw(self), cparamnames, ::core::mem::transmute(rgparamnames), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<isize>(result__)
    }
    pub unsafe fn SetParameterInfo(&self, cparams: usize, rgparamordinals: ::core::option::Option<*const usize>, rgparambindinfo: ::core::option::Option<*const DBPARAMBINDINFO>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetParameterInfo)(::windows::core::Vtable::as_raw(self), cparams, ::core::mem::transmute(rgparamordinals.unwrap_or(::std::ptr::null())), ::core::mem::transmute(rgparambindinfo.unwrap_or(::std::ptr::null()))).ok()
    }
}
::windows::core::interface_hierarchy!(ICommandWithParameters, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICommandWithParameters {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommandWithParameters {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommandWithParameters {}
impl ::core::fmt::Debug for ICommandWithParameters {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommandWithParameters").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICommandWithParameters {
    type Vtable = ICommandWithParameters_Vtbl;
}
unsafe impl ::windows::core::Interface for ICommandWithParameters {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a64_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommandWithParameters_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetParameterInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcparams: *mut usize, prgparaminfo: *mut *mut ::core::mem::ManuallyDrop<DBPARAMINFO>, ppnamesbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetParameterInfo: usize,
    pub MapParameterNames: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cparamnames: usize, rgparamnames: *const ::windows::core::PWSTR, rgparamordinals: *mut isize) -> ::windows::core::HRESULT,
    pub SetParameterInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cparams: usize, rgparamordinals: *const usize, rgparambindinfo: *const DBPARAMBINDINFO) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICondition(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICondition {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetClassID)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn IsDirty(&self) -> ::windows::core::HRESULT {
        (::windows::core::Vtable::vtable(self).base__.IsDirty)(::windows::core::Vtable::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Load<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IStream>>,
    {
        (::windows::core::Vtable::vtable(self).base__.Load)(::windows::core::Vtable::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Save<'a, P0, P1>(&self, pstm: P0, fcleardirty: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IStream>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.Save)(::windows::core::Vtable::as_raw(self), pstm.into().abi(), fcleardirty.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetSizeMax(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetSizeMax)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search_Common\"`*"]
    #[cfg(feature = "Win32_System_Search_Common")]
    pub unsafe fn GetConditionType(&self) -> ::windows::core::Result<Common::CONDITION_TYPE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetConditionType)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<Common::CONDITION_TYPE>(result__)
    }
    pub unsafe fn GetSubConditions<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).GetSubConditions)(::windows::core::Vtable::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn GetComparisonInfo(&self, ppszpropertyname: ::core::option::Option<*mut ::windows::core::PWSTR>, pcop: ::core::option::Option<*mut Common::CONDITION_OPERATION>, ppropvar: ::core::option::Option<*mut super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetComparisonInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppszpropertyname.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcop.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppropvar.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetValueType(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetValueType)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetValueNormalization(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetValueNormalization)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetInputTerms(&self, pppropertyterm: ::core::option::Option<*mut ::core::option::Option<IRichChunk>>, ppoperationterm: ::core::option::Option<*mut ::core::option::Option<IRichChunk>>, ppvalueterm: ::core::option::Option<*mut ::core::option::Option<IRichChunk>>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetInputTerms)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pppropertyterm.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppoperationterm.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppvalueterm.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<ICondition> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Clone)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(ICondition, ::windows::core::IUnknown, super::Com::IPersist, super::Com::IPersistStream);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICondition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICondition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICondition {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICondition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICondition").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for ICondition {
    type Vtable = ICondition_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICondition {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0fc988d4_c935_4b97_a973_46282ea175c8);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICondition_Vtbl {
    pub base__: super::Com::IPersistStream_Vtbl,
    #[cfg(feature = "Win32_System_Search_Common")]
    pub GetConditionType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnodetype: *mut Common::CONDITION_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Search_Common"))]
    GetConditionType: usize,
    pub GetSubConditions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub GetComparisonInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszpropertyname: *mut ::windows::core::PWSTR, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common")))]
    GetComparisonInfo: usize,
    pub GetValueType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszvaluetypename: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetValueNormalization: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsznormalization: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetInputTerms: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pppropertyterm: *mut *mut ::core::ffi::c_void, ppoperationterm: *mut *mut ::core::ffi::c_void, ppvalueterm: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppc: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Clone: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICondition2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICondition2 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetClassID)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn IsDirty(&self) -> ::windows::core::HRESULT {
        (::windows::core::Vtable::vtable(self).base__.base__.IsDirty)(::windows::core::Vtable::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Load<'a, P0>(&self, pstm: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IStream>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.Load)(::windows::core::Vtable::as_raw(self), pstm.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Save<'a, P0, P1>(&self, pstm: P0, fcleardirty: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IStream>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.Save)(::windows::core::Vtable::as_raw(self), pstm.into().abi(), fcleardirty.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetSizeMax(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetSizeMax)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search_Common\"`*"]
    #[cfg(feature = "Win32_System_Search_Common")]
    pub unsafe fn GetConditionType(&self) -> ::windows::core::Result<Common::CONDITION_TYPE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetConditionType)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<Common::CONDITION_TYPE>(result__)
    }
    pub unsafe fn GetSubConditions<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).base__.GetSubConditions)(::windows::core::Vtable::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn GetComparisonInfo(&self, ppszpropertyname: ::core::option::Option<*mut ::windows::core::PWSTR>, pcop: ::core::option::Option<*mut Common::CONDITION_OPERATION>, ppropvar: ::core::option::Option<*mut super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetComparisonInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppszpropertyname.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcop.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppropvar.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetValueType(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetValueType)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetValueNormalization(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetValueNormalization)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetInputTerms(&self, pppropertyterm: ::core::option::Option<*mut ::core::option::Option<IRichChunk>>, ppoperationterm: ::core::option::Option<*mut ::core::option::Option<IRichChunk>>, ppvalueterm: ::core::option::Option<*mut ::core::option::Option<IRichChunk>>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetInputTerms)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pppropertyterm.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppoperationterm.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppvalueterm.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Clone(&self) -> ::windows::core::Result<ICondition> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Clone)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    pub unsafe fn GetLocale(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetLocale)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetLeafConditionInfo(&self, ppropkey: ::core::option::Option<*mut super::super::UI::Shell::PropertiesSystem::PROPERTYKEY>, pcop: ::core::option::Option<*mut Common::CONDITION_OPERATION>, ppropvar: ::core::option::Option<*mut super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetLeafConditionInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppropkey.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcop.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppropvar.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(ICondition2, ::windows::core::IUnknown, super::Com::IPersist, super::Com::IPersistStream, ICondition);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICondition2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICondition2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICondition2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICondition2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICondition2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for ICondition2 {
    type Vtable = ICondition2_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for ICondition2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0db8851d_2e5b_47eb_9208_d28c325a01d7);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICondition2_Vtbl {
    pub base__: ICondition_Vtbl,
    pub GetLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszlocalename: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub GetLeafConditionInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppropkey: *mut super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, pcop: *mut Common::CONDITION_OPERATION, ppropvar: *mut ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    GetLeafConditionInfo: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IConditionFactory(::windows::core::IUnknown);
impl IConditionFactory {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn MakeNot<'a, P0, P1>(&self, pcsub: P0, fsimplify: P1) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICondition>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).MakeNot)(::windows::core::Vtable::as_raw(self), pcsub.into().abi(), fsimplify.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeAndOr<'a, P0, P1>(&self, ct: Common::CONDITION_TYPE, peusubs: P0, fsimplify: P1) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IEnumUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).MakeAndOr)(::windows::core::Vtable::as_raw(self), ct, peusubs.into().abi(), fsimplify.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeLeaf<'a, P0, P1, P2, P3, P4, P5>(&self, pszpropertyname: P0, cop: Common::CONDITION_OPERATION, pszvaluetype: P1, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: P2, poperationterm: P3, pvalueterm: P4, fexpand: P5) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P3: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P4: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P5: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).MakeLeaf)(::windows::core::Vtable::as_raw(self), pszpropertyname.into(), cop, pszvaluetype.into(), ::core::mem::transmute(ppropvar), ppropertynameterm.into().abi(), poperationterm.into().abi(), pvalueterm.into().abi(), fexpand.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Resolve<'a, P0>(&self, pc: P0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: ::core::option::Option<*const super::super::Foundation::SYSTEMTIME>) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICondition>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Resolve)(::windows::core::Vtable::as_raw(self), pc.into().abi(), sqro, ::core::mem::transmute(pstreferencetime.unwrap_or(::std::ptr::null())), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
}
::windows::core::interface_hierarchy!(IConditionFactory, ::windows::core::IUnknown);
impl ::core::clone::Clone for IConditionFactory {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConditionFactory {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConditionFactory {}
impl ::core::fmt::Debug for IConditionFactory {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConditionFactory").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IConditionFactory {
    type Vtable = IConditionFactory_Vtbl;
}
unsafe impl ::windows::core::Interface for IConditionFactory {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa5efe073_b16f_474f_9f3e_9f8b497a3e08);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConditionFactory_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub MakeNot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcsub: *mut ::core::ffi::c_void, fsimplify: super::super::Foundation::BOOL, ppcresult: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    MakeNot: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub MakeAndOr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, peusubs: *mut ::core::ffi::c_void, fsimplify: super::super::Foundation::BOOL, ppcresult: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common")))]
    MakeAndOr: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub MakeLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpropertyname: ::windows::core::PCWSTR, cop: Common::CONDITION_OPERATION, pszvaluetype: ::windows::core::PCWSTR, ppropvar: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>, ppropertynameterm: *mut ::core::ffi::c_void, poperationterm: *mut ::core::ffi::c_void, pvalueterm: *mut ::core::ffi::c_void, fexpand: super::super::Foundation::BOOL, ppcresult: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common")))]
    MakeLeaf: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub Resolve: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pc: *mut ::core::ffi::c_void, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME, ppcresolved: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    Resolve: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IConditionFactory2(::windows::core::IUnknown);
impl IConditionFactory2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn MakeNot<'a, P0, P1>(&self, pcsub: P0, fsimplify: P1) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICondition>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.MakeNot)(::windows::core::Vtable::as_raw(self), pcsub.into().abi(), fsimplify.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeAndOr<'a, P0, P1>(&self, ct: Common::CONDITION_TYPE, peusubs: P0, fsimplify: P1) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IEnumUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.MakeAndOr)(::windows::core::Vtable::as_raw(self), ct, peusubs.into().abi(), fsimplify.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeLeaf<'a, P0, P1, P2, P3, P4, P5>(&self, pszpropertyname: P0, cop: Common::CONDITION_OPERATION, pszvaluetype: P1, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: P2, poperationterm: P3, pvalueterm: P4, fexpand: P5) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P3: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P4: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P5: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.MakeLeaf)(::windows::core::Vtable::as_raw(self), pszpropertyname.into(), cop, pszvaluetype.into(), ::core::mem::transmute(ppropvar), ppropertynameterm.into().abi(), poperationterm.into().abi(), pvalueterm.into().abi(), fexpand.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Resolve<'a, P0>(&self, pc: P0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: ::core::option::Option<*const super::super::Foundation::SYSTEMTIME>) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICondition>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Resolve)(::windows::core::Vtable::as_raw(self), pc.into().abi(), sqro, ::core::mem::transmute(pstreferencetime.unwrap_or(::std::ptr::null())), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateTrueFalse<'a, P0, T>(&self, fval: P0, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateTrueFalse)(::windows::core::Vtable::as_raw(self), fval.into(), cco, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateNegation<'a, P0, T>(&self, pcsub: P0, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICondition>>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateNegation)(::windows::core::Vtable::as_raw(self), pcsub.into().abi(), cco, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn CreateCompoundFromObjectArray<'a, P0, T>(&self, ct: Common::CONDITION_TYPE, poasubs: P0, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::UI::Shell::Common::IObjectArray>>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateCompoundFromObjectArray)(::windows::core::Vtable::as_raw(self), ct, poasubs.into().abi(), cco, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn CreateCompoundFromArray<T>(&self, ct: Common::CONDITION_TYPE, ppcondsubs: &[::core::option::Option<ICondition>], cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateCompoundFromArray)(::windows::core::Vtable::as_raw(self), ct, ::core::mem::transmute(ppcondsubs.as_ptr()), ppcondsubs.len() as _, cco, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateStringLeaf<'a, P0, P1, T>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, pszvalue: P0, pszlocalename: P1, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateStringLeaf)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(propkey), cop, pszvalue.into(), pszlocalename.into(), cco, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateIntegerLeaf<T>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, lvalue: i32, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateIntegerLeaf)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(propkey), cop, lvalue, cco, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateBooleanLeaf<'a, P0, T>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, fvalue: P0, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateBooleanLeaf)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(propkey), cop, fvalue.into(), cco, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn CreateLeaf<'a, P0, P1, P2, P3, P4, T>(&self, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, propvar: *const super::Com::StructuredStorage::PROPVARIANT, pszsemantictype: P0, pszlocalename: P1, ppropertynameterm: P2, poperationterm: P3, pvalueterm: P4, cco: CONDITION_CREATION_OPTIONS) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P3: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P4: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateLeaf)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(propkey), cop, ::core::mem::transmute(propvar), pszsemantictype.into(), pszlocalename.into(), ppropertynameterm.into().abi(), poperationterm.into().abi(), pvalueterm.into().abi(), cco, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ResolveCondition<'a, P0, T>(&self, pc: P0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: ::core::option::Option<*const super::super::Foundation::SYSTEMTIME>) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICondition>>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).ResolveCondition)(::windows::core::Vtable::as_raw(self), pc.into().abi(), sqro, ::core::mem::transmute(pstreferencetime.unwrap_or(::std::ptr::null())), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
::windows::core::interface_hierarchy!(IConditionFactory2, ::windows::core::IUnknown, IConditionFactory);
impl ::core::clone::Clone for IConditionFactory2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConditionFactory2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConditionFactory2 {}
impl ::core::fmt::Debug for IConditionFactory2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConditionFactory2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IConditionFactory2 {
    type Vtable = IConditionFactory2_Vtbl;
}
unsafe impl ::windows::core::Interface for IConditionFactory2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x71d222e1_432f_429e_8c13_b6dafde5077a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConditionFactory2_Vtbl {
    pub base__: IConditionFactory_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub CreateTrueFalse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fval: super::super::Foundation::BOOL, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CreateTrueFalse: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateNegation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcsub: *mut ::core::ffi::c_void, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateNegation: usize,
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_Common"))]
    pub CreateCompoundFromObjectArray: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, poasubs: *mut ::core::ffi::c_void, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_Common")))]
    CreateCompoundFromObjectArray: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub CreateCompoundFromArray: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ct: Common::CONDITION_TYPE, ppcondsubs: *const *mut ::core::ffi::c_void, csubs: u32, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Search_Common")))]
    CreateCompoundFromArray: usize,
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub CreateStringLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, pszvalue: ::windows::core::PCWSTR, pszlocalename: ::windows::core::PCWSTR, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    CreateStringLeaf: usize,
    #[cfg(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub CreateIntegerLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, lvalue: i32, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    CreateIntegerLeaf: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub CreateBooleanLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, fvalue: super::super::Foundation::BOOL, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    CreateBooleanLeaf: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub CreateLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, cop: Common::CONDITION_OPERATION, propvar: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>, pszsemantictype: ::windows::core::PCWSTR, pszlocalename: ::windows::core::PCWSTR, ppropertynameterm: *mut ::core::ffi::c_void, poperationterm: *mut ::core::ffi::c_void, pvalueterm: *mut ::core::ffi::c_void, cco: CONDITION_CREATION_OPTIONS, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common", feature = "Win32_UI_Shell_PropertiesSystem")))]
    CreateLeaf: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub ResolveCondition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pc: *mut ::core::ffi::c_void, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: *const super::super::Foundation::SYSTEMTIME, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    ResolveCondition: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IConditionGenerator(::windows::core::IUnknown);
impl IConditionGenerator {
    pub unsafe fn Initialize<'a, P0>(&self, pschemaprovider: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ISchemaProvider>>,
    {
        (::windows::core::Vtable::vtable(self).Initialize)(::windows::core::Vtable::as_raw(self), pschemaprovider.into().abi()).ok()
    }
    pub unsafe fn RecognizeNamedEntities<'a, P0, P1, P2>(&self, pszinputstring: P0, lciduserlocale: u32, ptokencollection: P1, pnamedentities: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ITokenCollection>>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, INamedEntityCollector>>,
    {
        (::windows::core::Vtable::vtable(self).RecognizeNamedEntities)(::windows::core::Vtable::as_raw(self), pszinputstring.into(), lciduserlocale, ptokencollection.into().abi(), pnamedentities.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn GenerateForLeaf<'a, P0, P1, P2, P3, P4, P5, P6, P7, P8>(&self, pconditionfactory: P0, pszpropertyname: P1, cop: Common::CONDITION_OPERATION, pszvaluetype: P2, pszvalue: P3, pszvalue2: P4, ppropertynameterm: P5, poperationterm: P6, pvalueterm: P7, automaticwildcard: P8, pnostringquery: *mut super::super::Foundation::BOOL, ppqueryexpression: *mut ::core::option::Option<ICondition>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IConditionFactory>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
        P3: ::std::convert::Into<::windows::core::PCWSTR>,
        P4: ::std::convert::Into<::windows::core::PCWSTR>,
        P5: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P6: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P7: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P8: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).GenerateForLeaf)(::windows::core::Vtable::as_raw(self), pconditionfactory.into().abi(), pszpropertyname.into(), cop, pszvaluetype.into(), pszvalue.into(), pszvalue2.into(), ppropertynameterm.into().abi(), poperationterm.into().abi(), pvalueterm.into().abi(), automaticwildcard.into(), ::core::mem::transmute(pnostringquery), ::core::mem::transmute(ppqueryexpression)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn DefaultPhrase<'a, P0, P1>(&self, pszvaluetype: P0, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, fuseenglish: P1) -> ::windows::core::Result<::windows::core::PWSTR>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).DefaultPhrase)(::windows::core::Vtable::as_raw(self), pszvaluetype.into(), ::core::mem::transmute(ppropvar), fuseenglish.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
}
::windows::core::interface_hierarchy!(IConditionGenerator, ::windows::core::IUnknown);
impl ::core::clone::Clone for IConditionGenerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConditionGenerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConditionGenerator {}
impl ::core::fmt::Debug for IConditionGenerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConditionGenerator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IConditionGenerator {
    type Vtable = IConditionGenerator_Vtbl;
}
unsafe impl ::windows::core::Interface for IConditionGenerator {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x92d2cc58_4386_45a3_b98c_7e0ce64a4117);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConditionGenerator_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pschemaprovider: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RecognizeNamedEntities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszinputstring: ::windows::core::PCWSTR, lciduserlocale: u32, ptokencollection: *mut ::core::ffi::c_void, pnamedentities: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub GenerateForLeaf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pconditionfactory: *mut ::core::ffi::c_void, pszpropertyname: ::windows::core::PCWSTR, cop: Common::CONDITION_OPERATION, pszvaluetype: ::windows::core::PCWSTR, pszvalue: ::windows::core::PCWSTR, pszvalue2: ::windows::core::PCWSTR, ppropertynameterm: *mut ::core::ffi::c_void, poperationterm: *mut ::core::ffi::c_void, pvalueterm: *mut ::core::ffi::c_void, automaticwildcard: super::super::Foundation::BOOL, pnostringquery: *mut super::super::Foundation::BOOL, ppqueryexpression: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common")))]
    GenerateForLeaf: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub DefaultPhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszvaluetype: ::windows::core::PCWSTR, ppropvar: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>, fuseenglish: super::super::Foundation::BOOL, ppszphrase: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    DefaultPhrase: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IConvertType(::windows::core::IUnknown);
impl IConvertType {
    pub unsafe fn CanConvert(&self, wfromtype: u16, wtotype: u16, dwconvertflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CanConvert)(::windows::core::Vtable::as_raw(self), wfromtype, wtotype, dwconvertflags).ok()
    }
}
::windows::core::interface_hierarchy!(IConvertType, ::windows::core::IUnknown);
impl ::core::clone::Clone for IConvertType {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IConvertType {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConvertType {}
impl ::core::fmt::Debug for IConvertType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConvertType").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IConvertType {
    type Vtable = IConvertType_Vtbl;
}
unsafe impl ::windows::core::Interface for IConvertType {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a88_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConvertType_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub CanConvert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wfromtype: u16, wtotype: u16, dwconvertflags: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ICreateRow(::windows::core::IUnknown);
impl ICreateRow {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateRow<'a, P0, P1, P2>(&self, punkouter: P0, pwszurl: P1, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: P2, pimplsession: ::core::option::Option<*mut DBIMPLICITSESSION>, pdwbindstatus: *mut u32, ppwsznewurl: ::core::option::Option<*mut ::windows::core::PWSTR>, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IAuthenticate>>,
    {
        (::windows::core::Vtable::vtable(self).CreateRow)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), pwszurl.into(), dwbindurlflags, ::core::mem::transmute(rguid), ::core::mem::transmute(riid), pauthenticate.into().abi(), ::core::mem::transmute(pimplsession.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwbindstatus), ::core::mem::transmute(ppwsznewurl.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppunk)).ok()
    }
}
::windows::core::interface_hierarchy!(ICreateRow, ::windows::core::IUnknown);
impl ::core::clone::Clone for ICreateRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICreateRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICreateRow {}
impl ::core::fmt::Debug for ICreateRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICreateRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ICreateRow {
    type Vtable = ICreateRow_Vtbl;
}
unsafe impl ::windows::core::Interface for ICreateRow {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab2_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreateRow_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: *mut ::core::ffi::c_void, pimplsession: *mut ::core::mem::ManuallyDrop<DBIMPLICITSESSION>, pdwbindstatus: *mut u32, ppwsznewurl: *mut ::windows::core::PWSTR, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateRow: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBAsynchNotify(::windows::core::IUnknown);
impl IDBAsynchNotify {
    pub unsafe fn OnLowResource(&self, dwreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnLowResource)(::windows::core::Vtable::as_raw(self), dwreserved).ok()
    }
    pub unsafe fn OnProgress<'a, P0>(&self, hchapter: usize, eoperation: u32, ulprogress: usize, ulprogressmax: usize, easynchphase: u32, pwszstatustext: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).OnProgress)(::windows::core::Vtable::as_raw(self), hchapter, eoperation, ulprogress, ulprogressmax, easynchphase, pwszstatustext.into()).ok()
    }
    pub unsafe fn OnStop<'a, P0>(&self, hchapter: usize, eoperation: u32, hrstatus: ::windows::core::HRESULT, pwszstatustext: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).OnStop)(::windows::core::Vtable::as_raw(self), hchapter, eoperation, hrstatus, pwszstatustext.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IDBAsynchNotify, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBAsynchNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBAsynchNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBAsynchNotify {}
impl ::core::fmt::Debug for IDBAsynchNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBAsynchNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBAsynchNotify {
    type Vtable = IDBAsynchNotify_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBAsynchNotify {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a96_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBAsynchNotify_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub OnLowResource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwreserved: usize) -> ::windows::core::HRESULT,
    pub OnProgress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32, ulprogress: usize, ulprogressmax: usize, easynchphase: u32, pwszstatustext: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub OnStop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32, hrstatus: ::windows::core::HRESULT, pwszstatustext: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBAsynchStatus(::windows::core::IUnknown);
impl IDBAsynchStatus {
    pub unsafe fn Abort(&self, hchapter: usize, eoperation: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Abort)(::windows::core::Vtable::as_raw(self), hchapter, eoperation).ok()
    }
    pub unsafe fn GetStatus(&self, hchapter: usize, eoperation: u32, pulprogress: ::core::option::Option<*mut usize>, pulprogressmax: ::core::option::Option<*mut usize>, peasynchphase: *mut u32, ppwszstatustext: ::core::option::Option<*mut ::windows::core::PWSTR>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetStatus)(::windows::core::Vtable::as_raw(self), hchapter, eoperation, ::core::mem::transmute(pulprogress.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pulprogressmax.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(peasynchphase), ::core::mem::transmute(ppwszstatustext.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(IDBAsynchStatus, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBAsynchStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBAsynchStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBAsynchStatus {}
impl ::core::fmt::Debug for IDBAsynchStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBAsynchStatus").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBAsynchStatus {
    type Vtable = IDBAsynchStatus_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBAsynchStatus {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a95_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBAsynchStatus_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Abort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32) -> ::windows::core::HRESULT,
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, eoperation: u32, pulprogress: *mut usize, pulprogressmax: *mut usize, peasynchphase: *mut u32, ppwszstatustext: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBBinderProperties(::windows::core::IUnknown);
impl IDBBinderProperties {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, rgpropertyidsets: ::core::option::Option<&[DBPROPIDSET]>, pcpropertysets: *mut u32, prgpropertysets: ::core::option::Option<*mut *mut DBPROPSET>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetProperties)(::windows::core::Vtable::as_raw(self), rgpropertyidsets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertyidsets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetPropertyInfo(&self, rgpropertyidsets: ::core::option::Option<&[DBPROPIDSET]>, pcpropertyinfosets: *mut u32, prgpropertyinfosets: ::core::option::Option<*mut *mut DBPROPINFOSET>, ppdescbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetPropertyInfo)(::windows::core::Vtable::as_raw(self), rgpropertyidsets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertyidsets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pcpropertyinfosets), ::core::mem::transmute(prgpropertyinfosets.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppdescbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperties(&self, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetProperties)(::windows::core::Vtable::as_raw(self), rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Reset)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IDBBinderProperties, ::windows::core::IUnknown, IDBProperties);
impl ::core::clone::Clone for IDBBinderProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBBinderProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBBinderProperties {}
impl ::core::fmt::Debug for IDBBinderProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBBinderProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBBinderProperties {
    type Vtable = IDBBinderProperties_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBBinderProperties {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab3_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBBinderProperties_Vtbl {
    pub base__: IDBProperties_Vtbl,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBCreateCommand(::windows::core::IUnknown);
impl IDBCreateCommand {
    pub unsafe fn CreateCommand<'a, P0>(&self, punkouter: P0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).CreateCommand)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IDBCreateCommand, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBCreateCommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBCreateCommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBCreateCommand {}
impl ::core::fmt::Debug for IDBCreateCommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBCreateCommand").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBCreateCommand {
    type Vtable = IDBCreateCommand_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBCreateCommand {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a1d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBCreateCommand_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub CreateCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppcommand: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBCreateSession(::windows::core::IUnknown);
impl IDBCreateSession {
    pub unsafe fn CreateSession<'a, P0>(&self, punkouter: P0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).CreateSession)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IDBCreateSession, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBCreateSession {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBCreateSession {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBCreateSession {}
impl ::core::fmt::Debug for IDBCreateSession {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBCreateSession").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBCreateSession {
    type Vtable = IDBCreateSession_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBCreateSession {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a5d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBCreateSession_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub CreateSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppdbsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBDataSourceAdmin(::windows::core::IUnknown);
impl IDBDataSourceAdmin {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateDataSource<'a, P0>(&self, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>, punkouter: P0, riid: *const ::windows::core::GUID, ppdbsession: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).CreateDataSource)(::windows::core::Vtable::as_raw(self), rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), punkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppdbsession.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn DestroyDataSource(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DestroyDataSource)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetCreationProperties(&self, rgpropertyidsets: ::core::option::Option<&[DBPROPIDSET]>, pcpropertyinfosets: *mut u32, prgpropertyinfosets: ::core::option::Option<*mut *mut DBPROPINFOSET>, ppdescbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCreationProperties)(::windows::core::Vtable::as_raw(self), rgpropertyidsets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertyidsets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pcpropertyinfosets), ::core::mem::transmute(prgpropertyinfosets.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppdescbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ModifyDataSource(&self, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ModifyDataSource)(::windows::core::Vtable::as_raw(self), rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
}
::windows::core::interface_hierarchy!(IDBDataSourceAdmin, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBDataSourceAdmin {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBDataSourceAdmin {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBDataSourceAdmin {}
impl ::core::fmt::Debug for IDBDataSourceAdmin {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBDataSourceAdmin").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBDataSourceAdmin {
    type Vtable = IDBDataSourceAdmin_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBDataSourceAdmin {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7a_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBDataSourceAdmin_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppdbsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateDataSource: usize,
    pub DestroyDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetCreationProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetCreationProperties: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub ModifyDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    ModifyDataSource: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBInfo(::windows::core::IUnknown);
impl IDBInfo {
    pub unsafe fn GetKeywords(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetKeywords)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLiteralInfo(&self, rgliterals: ::core::option::Option<&[u32]>, pcliteralinfo: *mut u32, prgliteralinfo: *mut *mut DBLITERALINFO, ppcharbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetLiteralInfo)(::windows::core::Vtable::as_raw(self), rgliterals.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgliterals.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pcliteralinfo), ::core::mem::transmute(prgliteralinfo), ::core::mem::transmute(ppcharbuffer)).ok()
    }
}
::windows::core::interface_hierarchy!(IDBInfo, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBInfo {}
impl ::core::fmt::Debug for IDBInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBInfo {
    type Vtable = IDBInfo_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a89_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetKeywords: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppwszkeywords: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetLiteralInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cliterals: u32, rgliterals: *const u32, pcliteralinfo: *mut u32, prgliteralinfo: *mut *mut DBLITERALINFO, ppcharbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetLiteralInfo: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBInitialize(::windows::core::IUnknown);
impl IDBInitialize {
    pub unsafe fn Initialize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Initialize)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Uninitialize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Uninitialize)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IDBInitialize, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBInitialize {}
impl ::core::fmt::Debug for IDBInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBInitialize {
    type Vtable = IDBInitialize_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBInitialize {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8b_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBInitialize_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Uninitialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBPromptInitialize(::windows::core::IUnknown);
impl IDBPromptInitialize {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PromptDataSource<'a, P0, P1, P2>(&self, punkouter: P0, hwndparent: P1, dwpromptoptions: u32, rgsourcetypefilter: ::core::option::Option<&[u32]>, pwszszzproviderfilter: P2, riid: *const ::windows::core::GUID, ppdatasource: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::HWND>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).PromptDataSource)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), hwndparent.into(), dwpromptoptions, rgsourcetypefilter.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgsourcetypefilter.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pwszszzproviderfilter.into(), ::core::mem::transmute(riid), ::core::mem::transmute(ppdatasource)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PromptFileName<'a, P0, P1, P2>(&self, hwndparent: P0, dwpromptoptions: u32, pwszinitialdirectory: P1, pwszinitialfile: P2) -> ::windows::core::Result<::windows::core::PWSTR>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).PromptFileName)(::windows::core::Vtable::as_raw(self), hwndparent.into(), dwpromptoptions, pwszinitialdirectory.into(), pwszinitialfile.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
}
::windows::core::interface_hierarchy!(IDBPromptInitialize, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBPromptInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBPromptInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBPromptInitialize {}
impl ::core::fmt::Debug for IDBPromptInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBPromptInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBPromptInitialize {
    type Vtable = IDBPromptInitialize_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBPromptInitialize {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206ccb0_19c1_11d1_89e0_00c04fd7a829);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBPromptInitialize_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub PromptDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, hwndparent: super::super::Foundation::HWND, dwpromptoptions: u32, csourcetypefilter: u32, rgsourcetypefilter: *const u32, pwszszzproviderfilter: ::windows::core::PCWSTR, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PromptDataSource: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub PromptFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndparent: super::super::Foundation::HWND, dwpromptoptions: u32, pwszinitialdirectory: ::windows::core::PCWSTR, pwszinitialfile: ::windows::core::PCWSTR, ppwszselectedfile: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PromptFileName: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBProperties(::windows::core::IUnknown);
impl IDBProperties {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, rgpropertyidsets: ::core::option::Option<&[DBPROPIDSET]>, pcpropertysets: *mut u32, prgpropertysets: ::core::option::Option<*mut *mut DBPROPSET>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetProperties)(::windows::core::Vtable::as_raw(self), rgpropertyidsets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertyidsets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetPropertyInfo(&self, rgpropertyidsets: ::core::option::Option<&[DBPROPIDSET]>, pcpropertyinfosets: *mut u32, prgpropertyinfosets: ::core::option::Option<*mut *mut DBPROPINFOSET>, ppdescbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetPropertyInfo)(::windows::core::Vtable::as_raw(self), rgpropertyidsets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertyidsets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pcpropertyinfosets), ::core::mem::transmute(prgpropertyinfosets.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppdescbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperties(&self, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetProperties)(::windows::core::Vtable::as_raw(self), rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
}
::windows::core::interface_hierarchy!(IDBProperties, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBProperties {}
impl ::core::fmt::Debug for IDBProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBProperties {
    type Vtable = IDBProperties_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBProperties {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8a_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBProperties_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetProperties: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetPropertyInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertyinfosets: *mut u32, prgpropertyinfosets: *mut *mut DBPROPINFOSET, ppdescbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetPropertyInfo: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetProperties: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBSchemaCommand(::windows::core::IUnknown);
impl IDBSchemaCommand {
    pub unsafe fn GetCommand<'a, P0>(&self, punkouter: P0, rguidschema: *const ::windows::core::GUID) -> ::windows::core::Result<ICommand>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCommand)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(rguidschema), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICommand>(result__)
    }
    pub unsafe fn GetSchemas(&self, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetSchemas)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcschemas), ::core::mem::transmute(prgschemas)).ok()
    }
}
::windows::core::interface_hierarchy!(IDBSchemaCommand, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBSchemaCommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBSchemaCommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBSchemaCommand {}
impl ::core::fmt::Debug for IDBSchemaCommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBSchemaCommand").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBSchemaCommand {
    type Vtable = IDBSchemaCommand_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBSchemaCommand {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a50_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBSchemaCommand_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, rguidschema: *const ::windows::core::GUID, ppcommand: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetSchemas: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDBSchemaRowset(::windows::core::IUnknown);
impl IDBSchemaRowset {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetRowset<'a, P0>(&self, punkouter: P0, rguidschema: *const ::windows::core::GUID, rgrestrictions: ::core::option::Option<&[super::Com::VARIANT]>, riid: *const ::windows::core::GUID, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>, pprowset: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).GetRowset)(
            ::windows::core::Vtable::as_raw(self),
            punkouter.into().abi(),
            ::core::mem::transmute(rguidschema),
            rgrestrictions.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(rgrestrictions.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            ::core::mem::transmute(riid),
            rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            ::core::mem::transmute(pprowset.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn GetSchemas(&self, pcschemas: *mut u32, prgschemas: ::core::option::Option<*mut *mut ::windows::core::GUID>, prgrestrictionsupport: ::core::option::Option<*mut *mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetSchemas)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcschemas), ::core::mem::transmute(prgschemas.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(prgrestrictionsupport.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(IDBSchemaRowset, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDBSchemaRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDBSchemaRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDBSchemaRowset {}
impl ::core::fmt::Debug for IDBSchemaRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDBSchemaRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDBSchemaRowset {
    type Vtable = IDBSchemaRowset_Vtbl;
}
unsafe impl ::windows::core::Interface for IDBSchemaRowset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7b_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDBSchemaRowset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, rguidschema: *const ::windows::core::GUID, crestrictions: u32, rgrestrictions: *const ::core::mem::ManuallyDrop<super::Com::VARIANT>, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetRowset: usize,
    pub GetSchemas: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcschemas: *mut u32, prgschemas: *mut *mut ::windows::core::GUID, prgrestrictionsupport: *mut *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDCInfo(::windows::core::IUnknown);
impl IDCInfo {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetInfo(&self, cinfo: u32, rgeinfotype: *const u32) -> ::windows::core::Result<*mut DCINFO> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetInfo)(::windows::core::Vtable::as_raw(self), cinfo, ::core::mem::transmute(rgeinfotype), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut DCINFO>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetInfo(&self, rginfo: &[DCINFO]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetInfo)(::windows::core::Vtable::as_raw(self), rginfo.len() as _, ::core::mem::transmute(rginfo.as_ptr())).ok()
    }
}
::windows::core::interface_hierarchy!(IDCInfo, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDCInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDCInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDCInfo {}
impl ::core::fmt::Debug for IDCInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDCInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDCInfo {
    type Vtable = IDCInfo_Vtbl;
}
unsafe impl ::windows::core::Interface for IDCInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a9c_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDCInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cinfo: u32, rgeinfotype: *const u32, prginfo: *mut *mut ::core::mem::ManuallyDrop<DCINFO>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetInfo: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cinfo: u32, rginfo: *const ::core::mem::ManuallyDrop<DCINFO>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetInfo: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDataConvert(::windows::core::IUnknown);
impl IDataConvert {
    pub unsafe fn DataConvert(&self, wsrctype: u16, wdsttype: u16, cbsrclength: usize, pcbdstlength: ::core::option::Option<*mut usize>, psrc: *const ::core::ffi::c_void, pdst: *mut ::core::ffi::c_void, cbdstmaxlength: usize, dbssrcstatus: u32, pdbsstatus: ::core::option::Option<*mut u32>, bprecision: u8, bscale: u8, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DataConvert)(::windows::core::Vtable::as_raw(self), wsrctype, wdsttype, cbsrclength, ::core::mem::transmute(pcbdstlength.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(psrc), ::core::mem::transmute(pdst), cbdstmaxlength, dbssrcstatus, ::core::mem::transmute(pdbsstatus.unwrap_or(::std::ptr::null_mut())), bprecision, bscale, dwflags).ok()
    }
    pub unsafe fn CanConvert(&self, wsrctype: u16, wdsttype: u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CanConvert)(::windows::core::Vtable::as_raw(self), wsrctype, wdsttype).ok()
    }
    pub unsafe fn GetConversionSize(&self, wsrctype: u16, wdsttype: u16, pcbsrclength: ::core::option::Option<*const usize>, pcbdstlength: ::core::option::Option<*mut usize>, psrc: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetConversionSize)(::windows::core::Vtable::as_raw(self), wsrctype, wdsttype, ::core::mem::transmute(pcbsrclength.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pcbdstlength.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(psrc.unwrap_or(::std::ptr::null()))).ok()
    }
}
::windows::core::interface_hierarchy!(IDataConvert, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDataConvert {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataConvert {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataConvert {}
impl ::core::fmt::Debug for IDataConvert {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataConvert").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDataConvert {
    type Vtable = IDataConvert_Vtbl;
}
unsafe impl ::windows::core::Interface for IDataConvert {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataConvert_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub DataConvert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wsrctype: u16, wdsttype: u16, cbsrclength: usize, pcbdstlength: *mut usize, psrc: *const ::core::ffi::c_void, pdst: *mut ::core::ffi::c_void, cbdstmaxlength: usize, dbssrcstatus: u32, pdbsstatus: *mut u32, bprecision: u8, bscale: u8, dwflags: u32) -> ::windows::core::HRESULT,
    pub CanConvert: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wsrctype: u16, wdsttype: u16) -> ::windows::core::HRESULT,
    pub GetConversionSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wsrctype: u16, wdsttype: u16, pcbsrclength: *const usize, pcbdstlength: *mut usize, psrc: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IDataInitialize(::windows::core::IUnknown);
impl IDataInitialize {
    pub unsafe fn GetDataSource<'a, P0, P1>(&self, punkouter: P0, dwclsctx: u32, pwszinitializationstring: P1, riid: *const ::windows::core::GUID, ppdatasource: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).GetDataSource)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), dwclsctx, pwszinitializationstring.into(), ::core::mem::transmute(riid), ::core::mem::transmute(ppdatasource)).ok()
    }
    pub unsafe fn GetInitializationString<'a, P0>(&self, pdatasource: P0, fincludepassword: u8) -> ::windows::core::Result<::windows::core::PWSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetInitializationString)(::windows::core::Vtable::as_raw(self), pdatasource.into().abi(), fincludepassword, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn CreateDBInstance<'a, P0, P1>(&self, clsidprovider: *const ::windows::core::GUID, punkouter: P0, dwclsctx: u32, pwszreserved: P1, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).CreateDBInstance)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(clsidprovider), punkouter.into().abi(), dwclsctx, pwszreserved.into(), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateDBInstanceEx<'a, P0, P1>(&self, clsidprovider: *const ::windows::core::GUID, punkouter: P0, dwclsctx: u32, pwszreserved: P1, pserverinfo: *const super::Com::COSERVERINFO, rgmqresults: &mut [super::Com::MULTI_QI]) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).CreateDBInstanceEx)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(clsidprovider), punkouter.into().abi(), dwclsctx, pwszreserved.into(), ::core::mem::transmute(pserverinfo), rgmqresults.len() as _, ::core::mem::transmute(rgmqresults.as_ptr())).ok()
    }
    pub unsafe fn LoadStringFromStorage<'a, P0>(&self, pwszfilename: P0) -> ::windows::core::Result<::windows::core::PWSTR>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).LoadStringFromStorage)(::windows::core::Vtable::as_raw(self), pwszfilename.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn WriteStringToStorage<'a, P0, P1>(&self, pwszfilename: P0, pwszinitializationstring: P1, dwcreationdisposition: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).WriteStringToStorage)(::windows::core::Vtable::as_raw(self), pwszfilename.into(), pwszinitializationstring.into(), dwcreationdisposition).ok()
    }
}
::windows::core::interface_hierarchy!(IDataInitialize, ::windows::core::IUnknown);
impl ::core::clone::Clone for IDataInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IDataInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDataInitialize {}
impl ::core::fmt::Debug for IDataInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IDataInitialize {
    type Vtable = IDataInitialize_Vtbl;
}
unsafe impl ::windows::core::Interface for IDataInitialize {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206ccb1_19c1_11d1_89e0_00c04fd7a829);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataInitialize_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, dwclsctx: u32, pwszinitializationstring: ::windows::core::PCWSTR, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetInitializationString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdatasource: *mut ::core::ffi::c_void, fincludepassword: u8, ppwszinitstring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub CreateDBInstance: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsidprovider: *const ::windows::core::GUID, punkouter: *mut ::core::ffi::c_void, dwclsctx: u32, pwszreserved: ::windows::core::PCWSTR, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateDBInstanceEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsidprovider: *const ::windows::core::GUID, punkouter: *mut ::core::ffi::c_void, dwclsctx: u32, pwszreserved: ::windows::core::PCWSTR, pserverinfo: *const super::Com::COSERVERINFO, cmq: u32, rgmqresults: *mut ::core::mem::ManuallyDrop<super::Com::MULTI_QI>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateDBInstanceEx: usize,
    pub LoadStringFromStorage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszfilename: ::windows::core::PCWSTR, ppwszinitializationstring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub WriteStringToStorage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszfilename: ::windows::core::PCWSTR, pwszinitializationstring: ::windows::core::PCWSTR, dwcreationdisposition: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IDataSourceLocator(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IDataSourceLocator {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn hWnd(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).hWnd)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SethWnd<'a, P0>(&self, hwndparent: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).SethWnd)(::windows::core::Vtable::as_raw(self), hwndparent.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PromptNew(&self) -> ::windows::core::Result<super::Com::IDispatch> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).PromptNew)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PromptEdit(&self, ppadoconnection: *mut ::core::option::Option<super::Com::IDispatch>, pbsuccess: *mut i16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).PromptEdit)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppadoconnection), ::core::mem::transmute(pbsuccess)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows::core::interface_hierarchy!(IDataSourceLocator, ::windows::core::IUnknown, super::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IDataSourceLocator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IDataSourceLocator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IDataSourceLocator {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IDataSourceLocator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDataSourceLocator").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Vtable for IDataSourceLocator {
    type Vtable = IDataSourceLocator_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for IDataSourceLocator {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206ccb2_19c1_11d1_89e0_00c04fd7a829);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IDataSourceLocator_Vtbl {
    pub base__: super::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub hWnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwndparent: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    hWnd: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SethWnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndparent: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SethWnd: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PromptNew: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppadoconnection: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PromptNew: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PromptEdit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppadoconnection: *mut *mut ::core::ffi::c_void, pbsuccess: *mut i16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PromptEdit: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IEntity(::windows::core::IUnknown);
impl IEntity {
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Name)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn Base(&self) -> ::windows::core::Result<IEntity> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Base)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEntity>(result__)
    }
    pub unsafe fn Relationships<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).Relationships)(::windows::core::Vtable::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetRelationship<'a, P0>(&self, pszrelationname: P0) -> ::windows::core::Result<IRelationship>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetRelationship)(::windows::core::Vtable::as_raw(self), pszrelationname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IRelationship>(result__)
    }
    pub unsafe fn MetaData<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).MetaData)(::windows::core::Vtable::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn NamedEntities<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).NamedEntities)(::windows::core::Vtable::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetNamedEntity<'a, P0>(&self, pszvalue: P0) -> ::windows::core::Result<INamedEntity>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetNamedEntity)(::windows::core::Vtable::as_raw(self), pszvalue.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<INamedEntity>(result__)
    }
    pub unsafe fn DefaultPhrase(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).DefaultPhrase)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
}
::windows::core::interface_hierarchy!(IEntity, ::windows::core::IUnknown);
impl ::core::clone::Clone for IEntity {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEntity {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEntity {}
impl ::core::fmt::Debug for IEntity {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEntity").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IEntity {
    type Vtable = IEntity_Vtbl;
}
unsafe impl ::windows::core::Interface for IEntity {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x24264891_e80b_4fd3_b7ce_4ff2fae8931f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEntity_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub Base: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbaseentity: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Relationships: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, prelationships: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRelationship: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszrelationname: ::windows::core::PCWSTR, prelationship: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub MetaData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pmetadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub NamedEntities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pnamedentities: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetNamedEntity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszvalue: ::windows::core::PCWSTR, ppnamedentity: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DefaultPhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszphrase: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IEnumItemProperties(::windows::core::IUnknown);
impl IEnumItemProperties {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Next(&self, rgelt: &mut [ITEMPROP], pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Next)(::windows::core::Vtable::as_raw(self), rgelt.len() as _, ::core::mem::transmute(rgelt.as_ptr()), ::core::mem::transmute(pceltfetched)).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Skip)(::windows::core::Vtable::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Reset)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumItemProperties> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Clone)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumItemProperties>(result__)
    }
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCount)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(IEnumItemProperties, ::windows::core::IUnknown);
impl ::core::clone::Clone for IEnumItemProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumItemProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumItemProperties {}
impl ::core::fmt::Debug for IEnumItemProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumItemProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IEnumItemProperties {
    type Vtable = IEnumItemProperties_Vtbl;
}
unsafe impl ::windows::core::Interface for IEnumItemProperties {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf72c8d96_6dbd_11d1_a1e8_00c04fc2fbe1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumItemProperties_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut ::core::mem::ManuallyDrop<ITEMPROP>, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pncount: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IEnumSearchRoots(::windows::core::IUnknown);
impl IEnumSearchRoots {
    pub unsafe fn Next(&self, rgelt: &mut [::core::option::Option<ISearchRoot>], pceltfetched: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Next)(::windows::core::Vtable::as_raw(self), rgelt.len() as _, ::core::mem::transmute(rgelt.as_ptr()), ::core::mem::transmute(pceltfetched.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Skip)(::windows::core::Vtable::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Reset)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumSearchRoots> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Clone)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumSearchRoots>(result__)
    }
}
::windows::core::interface_hierarchy!(IEnumSearchRoots, ::windows::core::IUnknown);
impl ::core::clone::Clone for IEnumSearchRoots {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumSearchRoots {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumSearchRoots {}
impl ::core::fmt::Debug for IEnumSearchRoots {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumSearchRoots").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IEnumSearchRoots {
    type Vtable = IEnumSearchRoots_Vtbl;
}
unsafe impl ::windows::core::Interface for IEnumSearchRoots {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef52);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSearchRoots_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut *mut ::core::ffi::c_void, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IEnumSearchScopeRules(::windows::core::IUnknown);
impl IEnumSearchScopeRules {
    pub unsafe fn Next(&self, pprgelt: &mut [::core::option::Option<ISearchScopeRule>], pceltfetched: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Next)(::windows::core::Vtable::as_raw(self), pprgelt.len() as _, ::core::mem::transmute(pprgelt.as_ptr()), ::core::mem::transmute(pceltfetched.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Skip)(::windows::core::Vtable::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Reset)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumSearchScopeRules> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Clone)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumSearchScopeRules>(result__)
    }
}
::windows::core::interface_hierarchy!(IEnumSearchScopeRules, ::windows::core::IUnknown);
impl ::core::clone::Clone for IEnumSearchScopeRules {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumSearchScopeRules {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumSearchScopeRules {}
impl ::core::fmt::Debug for IEnumSearchScopeRules {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumSearchScopeRules").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IEnumSearchScopeRules {
    type Vtable = IEnumSearchScopeRules_Vtbl;
}
unsafe impl ::windows::core::Interface for IEnumSearchScopeRules {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef54);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSearchScopeRules_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, pprgelt: *mut *mut ::core::ffi::c_void, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IEnumSubscription(::windows::core::IUnknown);
impl IEnumSubscription {
    pub unsafe fn Next(&self, rgelt: &mut [::windows::core::GUID], pceltfetched: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Next)(::windows::core::Vtable::as_raw(self), rgelt.len() as _, ::core::mem::transmute(rgelt.as_ptr()), ::core::mem::transmute(pceltfetched)).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Skip)(::windows::core::Vtable::as_raw(self), celt).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Reset)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows::core::Result<IEnumSubscription> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Clone)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumSubscription>(result__)
    }
    pub unsafe fn GetCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCount)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(IEnumSubscription, ::windows::core::IUnknown);
impl ::core::clone::Clone for IEnumSubscription {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IEnumSubscription {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumSubscription {}
impl ::core::fmt::Debug for IEnumSubscription {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumSubscription").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IEnumSubscription {
    type Vtable = IEnumSubscription_Vtbl;
}
unsafe impl ::windows::core::Interface for IEnumSubscription {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf72c8d97_6dbd_11d1_a1e8_00c04fc2fbe1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSubscription_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32, rgelt: *mut ::windows::core::GUID, pceltfetched: *mut u32) -> ::windows::core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, celt: u32) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pncount: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IErrorLookup(::windows::core::IUnknown);
impl IErrorLookup {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetErrorDescription(&self, hrerror: ::windows::core::HRESULT, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, lcid: u32, pbstrsource: ::core::option::Option<*mut ::windows::core::BSTR>, pbstrdescription: ::core::option::Option<*mut ::windows::core::BSTR>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetErrorDescription)(::windows::core::Vtable::as_raw(self), hrerror, dwlookupid, ::core::mem::transmute(pdispparams), lcid, ::core::mem::transmute(pbstrsource.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pbstrdescription.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetHelpInfo(&self, hrerror: ::windows::core::HRESULT, dwlookupid: u32, lcid: u32, pbstrhelpfile: ::core::option::Option<*mut ::windows::core::BSTR>, pdwhelpcontext: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetHelpInfo)(::windows::core::Vtable::as_raw(self), hrerror, dwlookupid, lcid, ::core::mem::transmute(pbstrhelpfile.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwhelpcontext)).ok()
    }
    pub unsafe fn ReleaseErrors(&self, dwdynamicerrorid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ReleaseErrors)(::windows::core::Vtable::as_raw(self), dwdynamicerrorid).ok()
    }
}
::windows::core::interface_hierarchy!(IErrorLookup, ::windows::core::IUnknown);
impl ::core::clone::Clone for IErrorLookup {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IErrorLookup {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IErrorLookup {}
impl ::core::fmt::Debug for IErrorLookup {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IErrorLookup").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IErrorLookup {
    type Vtable = IErrorLookup_Vtbl;
}
unsafe impl ::windows::core::Interface for IErrorLookup {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a66_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IErrorLookup_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetErrorDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrerror: ::windows::core::HRESULT, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, lcid: u32, pbstrsource: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>, pbstrdescription: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetErrorDescription: usize,
    pub GetHelpInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrerror: ::windows::core::HRESULT, dwlookupid: u32, lcid: u32, pbstrhelpfile: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>, pdwhelpcontext: *mut u32) -> ::windows::core::HRESULT,
    pub ReleaseErrors: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwdynamicerrorid: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IErrorRecords(::windows::core::IUnknown);
impl IErrorRecords {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AddErrorRecord<'a, P0>(&self, perrorinfo: *const ERRORINFO, dwlookupid: u32, pdispparams: ::core::option::Option<*const super::Com::DISPPARAMS>, punkcustomerror: P0, dwdynamicerrorid: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).AddErrorRecord)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(perrorinfo), dwlookupid, ::core::mem::transmute(pdispparams.unwrap_or(::std::ptr::null())), punkcustomerror.into().abi(), dwdynamicerrorid).ok()
    }
    pub unsafe fn GetBasicErrorInfo(&self, ulrecordnum: u32) -> ::windows::core::Result<ERRORINFO> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetBasicErrorInfo)(::windows::core::Vtable::as_raw(self), ulrecordnum, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ERRORINFO>(result__)
    }
    pub unsafe fn GetCustomErrorObject(&self, ulrecordnum: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCustomErrorObject)(::windows::core::Vtable::as_raw(self), ulrecordnum, ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetErrorInfo(&self, ulrecordnum: u32, lcid: u32) -> ::windows::core::Result<super::Com::IErrorInfo> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetErrorInfo)(::windows::core::Vtable::as_raw(self), ulrecordnum, lcid, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::IErrorInfo>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetErrorParameters(&self, ulrecordnum: u32) -> ::windows::core::Result<super::Com::DISPPARAMS> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetErrorParameters)(::windows::core::Vtable::as_raw(self), ulrecordnum, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::DISPPARAMS>(result__)
    }
    pub unsafe fn GetRecordCount(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetRecordCount)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(IErrorRecords, ::windows::core::IUnknown);
impl ::core::clone::Clone for IErrorRecords {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IErrorRecords {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IErrorRecords {}
impl ::core::fmt::Debug for IErrorRecords {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IErrorRecords").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IErrorRecords {
    type Vtable = IErrorRecords_Vtbl;
}
unsafe impl ::windows::core::Interface for IErrorRecords {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a67_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IErrorRecords_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub AddErrorRecord: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, perrorinfo: *const ERRORINFO, dwlookupid: u32, pdispparams: *const super::Com::DISPPARAMS, punkcustomerror: *mut ::core::ffi::c_void, dwdynamicerrorid: u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    AddErrorRecord: usize,
    pub GetBasicErrorInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, perrorinfo: *mut ERRORINFO) -> ::windows::core::HRESULT,
    pub GetCustomErrorObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, riid: *const ::windows::core::GUID, ppobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetErrorInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, lcid: u32, pperrorinfo: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetErrorInfo: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetErrorParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrecordnum: u32, pdispparams: *mut super::Com::DISPPARAMS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetErrorParameters: usize,
    pub GetRecordCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcrecords: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IGetDataSource(::windows::core::IUnknown);
impl IGetDataSource {
    pub unsafe fn GetDataSource(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetDataSource)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IGetDataSource, ::windows::core::IUnknown);
impl ::core::clone::Clone for IGetDataSource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetDataSource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetDataSource {}
impl ::core::fmt::Debug for IGetDataSource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetDataSource").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IGetDataSource {
    type Vtable = IGetDataSource_Vtbl;
}
unsafe impl ::windows::core::Interface for IGetDataSource {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a75_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetDataSource_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetDataSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppdatasource: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IGetRow(::windows::core::IUnknown);
impl IGetRow {
    pub unsafe fn GetRowFromHROW<'a, P0>(&self, punkouter: P0, hrow: usize, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetRowFromHROW)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), hrow, ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn GetURLFromHROW(&self, hrow: usize) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetURLFromHROW)(::windows::core::Vtable::as_raw(self), hrow, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
}
::windows::core::interface_hierarchy!(IGetRow, ::windows::core::IUnknown);
impl ::core::clone::Clone for IGetRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetRow {}
impl ::core::fmt::Debug for IGetRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IGetRow {
    type Vtable = IGetRow_Vtbl;
}
unsafe impl ::windows::core::Interface for IGetRow {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aaf_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetRow_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetRowFromHROW: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, hrow: usize, riid: *const ::windows::core::GUID, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetURLFromHROW: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, ppwszurl: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IGetSession(::windows::core::IUnknown);
impl IGetSession {
    pub unsafe fn GetSession(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSession)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IGetSession, ::windows::core::IUnknown);
impl ::core::clone::Clone for IGetSession {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetSession {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetSession {}
impl ::core::fmt::Debug for IGetSession {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetSession").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IGetSession {
    type Vtable = IGetSession_Vtbl;
}
unsafe impl ::windows::core::Interface for IGetSession {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aba_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetSession_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetSession: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppsession: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IGetSourceRow(::windows::core::IUnknown);
impl IGetSourceRow {
    pub unsafe fn GetSourceRow(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSourceRow)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IGetSourceRow, ::windows::core::IUnknown);
impl ::core::clone::Clone for IGetSourceRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IGetSourceRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetSourceRow {}
impl ::core::fmt::Debug for IGetSourceRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetSourceRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IGetSourceRow {
    type Vtable = IGetSourceRow_Vtbl;
}
unsafe impl ::windows::core::Interface for IGetSourceRow {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733abb_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetSourceRow_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetSourceRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprow: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IIndexDefinition(::windows::core::IUnknown);
impl IIndexDefinition {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateIndex(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>, rgindexcolumndescs: &[DBINDEXCOLUMNDESC], rgpropertysets: &mut [DBPROPSET], ppindexid: ::core::option::Option<*mut *mut super::super::Storage::IndexServer::DBID>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CreateIndex)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid.unwrap_or(::std::ptr::null())), rgindexcolumndescs.len() as _, ::core::mem::transmute(rgindexcolumndescs.as_ptr()), rgpropertysets.len() as _, ::core::mem::transmute(rgpropertysets.as_ptr()), ::core::mem::transmute(ppindexid.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DropIndex(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DropIndex)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pindexid.unwrap_or(::std::ptr::null()))).ok()
    }
}
::windows::core::interface_hierarchy!(IIndexDefinition, ::windows::core::IUnknown);
impl ::core::clone::Clone for IIndexDefinition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IIndexDefinition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IIndexDefinition {}
impl ::core::fmt::Debug for IIndexDefinition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IIndexDefinition").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IIndexDefinition {
    type Vtable = IIndexDefinition_Vtbl;
}
unsafe impl ::windows::core::Interface for IIndexDefinition {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a68_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IIndexDefinition_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, cindexcolumndescs: usize, rgindexcolumndescs: *const DBINDEXCOLUMNDESC, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateIndex: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub DropIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    DropIndex: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IInterval(::windows::core::IUnknown);
impl IInterval {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetLimits(&self, pilklower: *mut INTERVAL_LIMIT_KIND, ppropvarlower: *mut super::Com::StructuredStorage::PROPVARIANT, pilkupper: *mut INTERVAL_LIMIT_KIND, ppropvarupper: *mut super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetLimits)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pilklower), ::core::mem::transmute(ppropvarlower), ::core::mem::transmute(pilkupper), ::core::mem::transmute(ppropvarupper)).ok()
    }
}
::windows::core::interface_hierarchy!(IInterval, ::windows::core::IUnknown);
impl ::core::clone::Clone for IInterval {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IInterval {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IInterval {}
impl ::core::fmt::Debug for IInterval {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IInterval").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IInterval {
    type Vtable = IInterval_Vtbl;
}
unsafe impl ::windows::core::Interface for IInterval {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6bf0a714_3c18_430b_8b5d_83b1c234d3db);
}
#[repr(C)]
#[doc(hidden)]
pub struct IInterval_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub GetLimits: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pilklower: *mut INTERVAL_LIMIT_KIND, ppropvarlower: *mut ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>, pilkupper: *mut INTERVAL_LIMIT_KIND, ppropvarupper: *mut ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    GetLimits: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ILoadFilter(::windows::core::IUnknown);
impl ILoadFilter {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn LoadIFilter<'a, P0, P1, P2>(&self, pwcspath: P0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: P1, fusedefault: P2, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P2: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).LoadIFilter)(::windows::core::Vtable::as_raw(self), pwcspath.into(), ::core::mem::transmute(pfilteredsources), punkouter.into().abi(), fusedefault.into(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn LoadIFilterFromStorage<'a, P0, P1, P2, P3>(&self, pstg: P0, punkouter: P1, pwcsoverride: P2, fusedefault: P3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::StructuredStorage::IStorage>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
        P3: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).LoadIFilterFromStorage)(::windows::core::Vtable::as_raw(self), pstg.into().abi(), punkouter.into().abi(), pwcsoverride.into(), fusedefault.into(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn LoadIFilterFromStream<'a, P0, P1, P2>(&self, pstm: P0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: P1, fusedefault: P2, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IStream>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P2: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).LoadIFilterFromStream)(::windows::core::Vtable::as_raw(self), pstm.into().abi(), ::core::mem::transmute(pfilteredsources), punkouter.into().abi(), fusedefault.into(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
}
::windows::core::interface_hierarchy!(ILoadFilter, ::windows::core::IUnknown);
impl ::core::clone::Clone for ILoadFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ILoadFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ILoadFilter {}
impl ::core::fmt::Debug for ILoadFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ILoadFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ILoadFilter {
    type Vtable = ILoadFilter_Vtbl;
}
unsafe impl ::windows::core::Interface for ILoadFilter {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc7310722_ac80_11d1_8df3_00c04fb6ef4f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ILoadFilter_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub LoadIFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwcspath: ::windows::core::PCWSTR, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: *mut ::core::ffi::c_void, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))]
    LoadIFilter: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
    pub LoadIFilterFromStorage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstg: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pwcsoverride: ::windows::core::PCWSTR, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage")))]
    LoadIFilterFromStorage: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub LoadIFilterFromStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: *mut ::core::ffi::c_void, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: *mut ::core::ffi::c_void, fusedefault: super::super::Foundation::BOOL, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))]
    LoadIFilterFromStream: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ILoadFilterWithPrivateComActivation(::windows::core::IUnknown);
impl ILoadFilterWithPrivateComActivation {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn LoadIFilter<'a, P0, P1, P2>(&self, pwcspath: P0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: P1, fusedefault: P2, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P2: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.LoadIFilter)(::windows::core::Vtable::as_raw(self), pwcspath.into(), ::core::mem::transmute(pfilteredsources), punkouter.into().abi(), fusedefault.into(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn LoadIFilterFromStorage<'a, P0, P1, P2, P3>(&self, pstg: P0, punkouter: P1, pwcsoverride: P2, fusedefault: P3, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::StructuredStorage::IStorage>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
        P3: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.LoadIFilterFromStorage)(::windows::core::Vtable::as_raw(self), pstg.into().abi(), punkouter.into().abi(), pwcsoverride.into(), fusedefault.into(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn LoadIFilterFromStream<'a, P0, P1, P2>(&self, pstm: P0, pfilteredsources: *const FILTERED_DATA_SOURCES, punkouter: P1, fusedefault: P2, pfilterclsid: *mut ::windows::core::GUID, searchdecsize: *mut i32, pwcssearchdesc: *mut *mut u16, ppifilt: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IStream>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P2: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.LoadIFilterFromStream)(::windows::core::Vtable::as_raw(self), pstm.into().abi(), ::core::mem::transmute(pfilteredsources), punkouter.into().abi(), fusedefault.into(), ::core::mem::transmute(pfilterclsid), ::core::mem::transmute(searchdecsize), ::core::mem::transmute(pwcssearchdesc), ::core::mem::transmute(ppifilt)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn LoadIFilterWithPrivateComActivation<'a, P0>(&self, filteredsources: *const FILTERED_DATA_SOURCES, usedefault: P0, filterclsid: *mut ::windows::core::GUID, isfilterprivatecomactivated: *mut super::super::Foundation::BOOL, filterobj: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).LoadIFilterWithPrivateComActivation)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(filteredsources), usedefault.into(), ::core::mem::transmute(filterclsid), ::core::mem::transmute(isfilterprivatecomactivated), ::core::mem::transmute(filterobj)).ok()
    }
}
::windows::core::interface_hierarchy!(ILoadFilterWithPrivateComActivation, ::windows::core::IUnknown, ILoadFilter);
impl ::core::clone::Clone for ILoadFilterWithPrivateComActivation {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ILoadFilterWithPrivateComActivation {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ILoadFilterWithPrivateComActivation {}
impl ::core::fmt::Debug for ILoadFilterWithPrivateComActivation {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ILoadFilterWithPrivateComActivation").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ILoadFilterWithPrivateComActivation {
    type Vtable = ILoadFilterWithPrivateComActivation_Vtbl;
}
unsafe impl ::windows::core::Interface for ILoadFilterWithPrivateComActivation {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x40bdbd34_780b_48d3_9bb6_12ebd4ad2e75);
}
#[repr(C)]
#[doc(hidden)]
pub struct ILoadFilterWithPrivateComActivation_Vtbl {
    pub base__: ILoadFilter_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub LoadIFilterWithPrivateComActivation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filteredsources: *const FILTERED_DATA_SOURCES, usedefault: super::super::Foundation::BOOL, filterclsid: *mut ::windows::core::GUID, isfilterprivatecomactivated: *mut super::super::Foundation::BOOL, filterobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))]
    LoadIFilterWithPrivateComActivation: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IMDDataset(::windows::core::IUnknown);
impl IMDDataset {
    pub unsafe fn FreeAxisInfo(&self, caxes: usize, rgaxisinfo: *mut MDAXISINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).FreeAxisInfo)(::windows::core::Vtable::as_raw(self), caxes, ::core::mem::transmute(rgaxisinfo)).ok()
    }
    pub unsafe fn GetAxisInfo(&self, pcaxes: *mut usize, prgaxisinfo: *mut *mut MDAXISINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetAxisInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcaxes), ::core::mem::transmute(prgaxisinfo)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetAxisRowset<'a, P0>(&self, punkouter: P0, iaxis: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).GetAxisRowset)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), iaxis, ::core::mem::transmute(riid), cpropertysets, ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(pprowset)).ok()
    }
    pub unsafe fn GetCellData<'a, P0>(&self, haccessor: P0, ulstartcell: usize, ulendcell: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).GetCellData)(::windows::core::Vtable::as_raw(self), haccessor.into(), ulstartcell, ulendcell, ::core::mem::transmute(pdata)).ok()
    }
    pub unsafe fn GetSpecification(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSpecification)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IMDDataset, ::windows::core::IUnknown);
impl ::core::clone::Clone for IMDDataset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMDDataset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMDDataset {}
impl ::core::fmt::Debug for IMDDataset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMDDataset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IMDDataset {
    type Vtable = IMDDataset_Vtbl;
}
unsafe impl ::windows::core::Interface for IMDDataset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa07cccd1_8148_11d0_87bb_00c04fc33942);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMDDataset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub FreeAxisInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, caxes: usize, rgaxisinfo: *mut MDAXISINFO) -> ::windows::core::HRESULT,
    pub GetAxisInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcaxes: *mut usize, prgaxisinfo: *mut *mut MDAXISINFO) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetAxisRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, iaxis: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetAxisRowset: usize,
    pub GetCellData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: HACCESSOR, ulstartcell: usize, ulendcell: usize, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetSpecification: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppspecification: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IMDFind(::windows::core::IUnknown);
impl IMDFind {
    pub unsafe fn FindCell(&self, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut ::windows::core::PWSTR, pulcellordinal: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).FindCell)(::windows::core::Vtable::as_raw(self), ulstartingordinal, cmembers, ::core::mem::transmute(rgpwszmember), ::core::mem::transmute(pulcellordinal)).ok()
    }
    pub unsafe fn FindTuple(&self, ulaxisidentifier: u32, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut ::windows::core::PWSTR, pultupleordinal: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).FindTuple)(::windows::core::Vtable::as_raw(self), ulaxisidentifier, ulstartingordinal, cmembers, ::core::mem::transmute(rgpwszmember), ::core::mem::transmute(pultupleordinal)).ok()
    }
}
::windows::core::interface_hierarchy!(IMDFind, ::windows::core::IUnknown);
impl ::core::clone::Clone for IMDFind {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMDFind {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMDFind {}
impl ::core::fmt::Debug for IMDFind {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMDFind").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IMDFind {
    type Vtable = IMDFind_Vtbl;
}
unsafe impl ::windows::core::Interface for IMDFind {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa07cccd2_8148_11d0_87bb_00c04fc33942);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMDFind_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub FindCell: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut ::windows::core::PWSTR, pulcellordinal: *mut usize) -> ::windows::core::HRESULT,
    pub FindTuple: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulaxisidentifier: u32, ulstartingordinal: usize, cmembers: usize, rgpwszmember: *mut ::windows::core::PWSTR, pultupleordinal: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IMDRangeRowset(::windows::core::IUnknown);
impl IMDRangeRowset {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetRangeRowset<'a, P0>(&self, punkouter: P0, ulstartcell: usize, ulendcell: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).GetRangeRowset)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ulstartcell, ulendcell, ::core::mem::transmute(riid), cpropertysets, ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(pprowset)).ok()
    }
}
::windows::core::interface_hierarchy!(IMDRangeRowset, ::windows::core::IUnknown);
impl ::core::clone::Clone for IMDRangeRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMDRangeRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMDRangeRowset {}
impl ::core::fmt::Debug for IMDRangeRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMDRangeRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IMDRangeRowset {
    type Vtable = IMDRangeRowset_Vtbl;
}
unsafe impl ::windows::core::Interface for IMDRangeRowset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa0_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMDRangeRowset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetRangeRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ulstartcell: usize, ulendcell: usize, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetRangeRowset: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IMetaData(::windows::core::IUnknown);
impl IMetaData {
    pub unsafe fn GetData(&self, ppszkey: ::core::option::Option<*mut ::windows::core::PWSTR>, ppszvalue: ::core::option::Option<*mut ::windows::core::PWSTR>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetData)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppszkey.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppszvalue.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(IMetaData, ::windows::core::IUnknown);
impl ::core::clone::Clone for IMetaData {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMetaData {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMetaData {}
impl ::core::fmt::Debug for IMetaData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMetaData").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IMetaData {
    type Vtable = IMetaData_Vtbl;
}
unsafe impl ::windows::core::Interface for IMetaData {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x780102b0_c43b_4876_bc7b_5e9ba5c88794);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMetaData_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszkey: *mut ::windows::core::PWSTR, ppszvalue: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IMultipleResults(::windows::core::IUnknown);
impl IMultipleResults {
    pub unsafe fn GetResult<'a, P0>(&self, punkouter: P0, lresultflag: isize, riid: *const ::windows::core::GUID, pcrowsaffected: ::core::option::Option<*mut isize>, pprowset: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).GetResult)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), lresultflag, ::core::mem::transmute(riid), ::core::mem::transmute(pcrowsaffected.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pprowset.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(IMultipleResults, ::windows::core::IUnknown);
impl ::core::clone::Clone for IMultipleResults {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IMultipleResults {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMultipleResults {}
impl ::core::fmt::Debug for IMultipleResults {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMultipleResults").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IMultipleResults {
    type Vtable = IMultipleResults_Vtbl;
}
unsafe impl ::windows::core::Interface for IMultipleResults {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a90_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultipleResults_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetResult: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, lresultflag: isize, riid: *const ::windows::core::GUID, pcrowsaffected: *mut isize, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct INamedEntity(::windows::core::IUnknown);
impl INamedEntity {
    pub unsafe fn GetValue(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetValue)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn DefaultPhrase(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).DefaultPhrase)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
}
::windows::core::interface_hierarchy!(INamedEntity, ::windows::core::IUnknown);
impl ::core::clone::Clone for INamedEntity {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for INamedEntity {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for INamedEntity {}
impl ::core::fmt::Debug for INamedEntity {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INamedEntity").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for INamedEntity {
    type Vtable = INamedEntity_Vtbl;
}
unsafe impl ::windows::core::Interface for INamedEntity {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xabdbd0b1_7d54_49fb_ab5c_bff4130004cd);
}
#[repr(C)]
#[doc(hidden)]
pub struct INamedEntity_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszvalue: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub DefaultPhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszphrase: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct INamedEntityCollector(::windows::core::IUnknown);
impl INamedEntityCollector {
    pub unsafe fn Add<'a, P0, P1>(&self, beginspan: u32, endspan: u32, beginactual: u32, endactual: u32, ptype: P0, pszvalue: P1, certainty: NAMED_ENTITY_CERTAINTY) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IEntity>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).Add)(::windows::core::Vtable::as_raw(self), beginspan, endspan, beginactual, endactual, ptype.into().abi(), pszvalue.into(), certainty).ok()
    }
}
::windows::core::interface_hierarchy!(INamedEntityCollector, ::windows::core::IUnknown);
impl ::core::clone::Clone for INamedEntityCollector {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for INamedEntityCollector {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for INamedEntityCollector {}
impl ::core::fmt::Debug for INamedEntityCollector {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INamedEntityCollector").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for INamedEntityCollector {
    type Vtable = INamedEntityCollector_Vtbl;
}
unsafe impl ::windows::core::Interface for INamedEntityCollector {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaf2440f6_8afc_47d0_9a7f_396a0acfb43d);
}
#[repr(C)]
#[doc(hidden)]
pub struct INamedEntityCollector_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, beginspan: u32, endspan: u32, beginactual: u32, endactual: u32, ptype: *mut ::core::ffi::c_void, pszvalue: ::windows::core::PCWSTR, certainty: NAMED_ENTITY_CERTAINTY) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IObjectAccessControl(::windows::core::IUnknown);
impl IObjectAccessControl {
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetObjectAccessRights(&self, pobject: *mut SEC_OBJECT, pcaccessentries: *mut u32, prgaccessentries: *mut *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetObjectAccessRights)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pobject), ::core::mem::transmute(pcaccessentries), ::core::mem::transmute(prgaccessentries)).ok()
    }
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetObjectOwner(&self, pobject: *mut SEC_OBJECT, ppowner: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetObjectOwner)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pobject), ::core::mem::transmute(ppowner)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn IsObjectAccessAllowed(&self, pobject: *mut SEC_OBJECT, paccessentry: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W, pfresult: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).IsObjectAccessAllowed)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pobject), ::core::mem::transmute(paccessentry), ::core::mem::transmute(pfresult)).ok()
    }
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn SetObjectAccessRights(&self, pobject: *mut SEC_OBJECT, caccessentries: u32, prgaccessentries: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetObjectAccessRights)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pobject), caccessentries, ::core::mem::transmute(prgaccessentries)).ok()
    }
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn SetObjectOwner(&self, pobject: *mut SEC_OBJECT, powner: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetObjectOwner)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pobject), ::core::mem::transmute(powner)).ok()
    }
}
::windows::core::interface_hierarchy!(IObjectAccessControl, ::windows::core::IUnknown);
impl ::core::clone::Clone for IObjectAccessControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IObjectAccessControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IObjectAccessControl {}
impl ::core::fmt::Debug for IObjectAccessControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IObjectAccessControl").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IObjectAccessControl {
    type Vtable = IObjectAccessControl_Vtbl;
}
unsafe impl ::windows::core::Interface for IObjectAccessControl {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa3_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IObjectAccessControl_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub GetObjectAccessRights: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, pcaccessentries: *mut u32, prgaccessentries: *mut *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))]
    GetObjectAccessRights: usize,
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub GetObjectOwner: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, ppowner: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))]
    GetObjectOwner: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub IsObjectAccessAllowed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, paccessentry: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W, pfresult: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))]
    IsObjectAccessAllowed: usize,
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub SetObjectAccessRights: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, caccessentries: u32, prgaccessentries: *mut super::super::Security::Authorization::EXPLICIT_ACCESS_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))]
    SetObjectAccessRights: usize,
    #[cfg(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer"))]
    pub SetObjectOwner: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pobject: *mut SEC_OBJECT, powner: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer")))]
    SetObjectOwner: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IOpLockStatus(::windows::core::IUnknown);
impl IOpLockStatus {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsOplockValid(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsOplockValid)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsOplockBroken(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsOplockBroken)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOplockEventHandle(&self) -> ::windows::core::Result<super::super::Foundation::HANDLE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetOplockEventHandle)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
}
::windows::core::interface_hierarchy!(IOpLockStatus, ::windows::core::IUnknown);
impl ::core::clone::Clone for IOpLockStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IOpLockStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IOpLockStatus {}
impl ::core::fmt::Debug for IOpLockStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOpLockStatus").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IOpLockStatus {
    type Vtable = IOpLockStatus_Vtbl;
}
unsafe impl ::windows::core::Interface for IOpLockStatus {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc731065d_ac80_11d1_8df3_00c04fb6ef4f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IOpLockStatus_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub IsOplockValid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfisoplockvalid: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsOplockValid: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsOplockBroken: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfisoplockbroken: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsOplockBroken: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetOplockEventHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phoplockev: *mut super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetOplockEventHandle: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IOpenRowset(::windows::core::IUnknown);
impl IOpenRowset {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OpenRowset<'a, P0>(&self, punkouter: P0, ptableid: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>, pindexid: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>, riid: *const ::windows::core::GUID, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>, pprowset: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).OpenRowset)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(ptableid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pindexid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(riid), rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pprowset.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(IOpenRowset, ::windows::core::IUnknown);
impl ::core::clone::Clone for IOpenRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IOpenRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IOpenRowset {}
impl ::core::fmt::Debug for IOpenRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOpenRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IOpenRowset {
    type Vtable = IOpenRowset_Vtbl;
}
unsafe impl ::windows::core::Interface for IOpenRowset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a69_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IOpenRowset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub OpenRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    OpenRowset: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IParentRowset(::windows::core::IUnknown);
impl IParentRowset {
    pub unsafe fn GetChildRowset<'a, P0>(&self, punkouter: P0, iordinal: usize, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetChildRowset)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), iordinal, ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IParentRowset, ::windows::core::IUnknown);
impl ::core::clone::Clone for IParentRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IParentRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IParentRowset {}
impl ::core::fmt::Debug for IParentRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IParentRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IParentRowset {
    type Vtable = IParentRowset_Vtbl;
}
unsafe impl ::windows::core::Interface for IParentRowset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aaa_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IParentRowset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetChildRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, iordinal: usize, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IProtocolHandlerSite(::windows::core::IUnknown);
impl IProtocolHandlerSite {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetFilter<'a, P0, P1>(&self, pclsidobj: *mut ::windows::core::GUID, pcwszcontenttype: P0, pcwszextension: P1, ppfilter: *mut ::core::option::Option<super::super::Storage::IndexServer::IFilter>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).GetFilter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pclsidobj), pcwszcontenttype.into(), pcwszextension.into(), ::core::mem::transmute(ppfilter)).ok()
    }
}
::windows::core::interface_hierarchy!(IProtocolHandlerSite, ::windows::core::IUnknown);
impl ::core::clone::Clone for IProtocolHandlerSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IProtocolHandlerSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IProtocolHandlerSite {}
impl ::core::fmt::Debug for IProtocolHandlerSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IProtocolHandlerSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IProtocolHandlerSite {
    type Vtable = IProtocolHandlerSite_Vtbl;
}
unsafe impl ::windows::core::Interface for IProtocolHandlerSite {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b63e385_9ccc_11d0_bcdb_00805fccce04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IProtocolHandlerSite_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclsidobj: *mut ::windows::core::GUID, pcwszcontenttype: ::windows::core::PCWSTR, pcwszextension: ::windows::core::PCWSTR, ppfilter: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetFilter: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IProvideMoniker(::windows::core::IUnknown);
impl IProvideMoniker {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetMoniker(&self) -> ::windows::core::Result<super::Com::IMoniker> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetMoniker)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::IMoniker>(result__)
    }
}
::windows::core::interface_hierarchy!(IProvideMoniker, ::windows::core::IUnknown);
impl ::core::clone::Clone for IProvideMoniker {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IProvideMoniker {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IProvideMoniker {}
impl ::core::fmt::Debug for IProvideMoniker {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IProvideMoniker").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IProvideMoniker {
    type Vtable = IProvideMoniker_Vtbl;
}
unsafe impl ::windows::core::Interface for IProvideMoniker {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a4d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IProvideMoniker_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetMoniker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppimoniker: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetMoniker: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IQueryParser(::windows::core::IUnknown);
impl IQueryParser {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parse<'a, P0, P1>(&self, pszinputstring: P0, pcustomproperties: P1) -> ::windows::core::Result<IQuerySolution>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IEnumUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Parse)(::windows::core::Vtable::as_raw(self), pszinputstring.into(), pcustomproperties.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IQuerySolution>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetOption(&self, option: STRUCTURED_QUERY_SINGLE_OPTION, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetOption)(::windows::core::Vtable::as_raw(self), option, ::core::mem::transmute(poptionvalue)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetOption(&self, option: STRUCTURED_QUERY_SINGLE_OPTION) -> ::windows::core::Result<super::Com::StructuredStorage::PROPVARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetOption)(::windows::core::Vtable::as_raw(self), option, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetMultiOption<'a, P0>(&self, option: STRUCTURED_QUERY_MULTIOPTION, pszoptionkey: P0, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetMultiOption)(::windows::core::Vtable::as_raw(self), option, pszoptionkey.into(), ::core::mem::transmute(poptionvalue)).ok()
    }
    pub unsafe fn GetSchemaProvider(&self) -> ::windows::core::Result<ISchemaProvider> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSchemaProvider)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISchemaProvider>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn RestateToString<'a, P0, P1>(&self, pcondition: P0, fuseenglish: P1) -> ::windows::core::Result<::windows::core::PWSTR>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICondition>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).RestateToString)(::windows::core::Vtable::as_raw(self), pcondition.into().abi(), fuseenglish.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn ParsePropertyValue<'a, P0, P1>(&self, pszpropertyname: P0, pszinputstring: P1) -> ::windows::core::Result<IQuerySolution>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ParsePropertyValue)(::windows::core::Vtable::as_raw(self), pszpropertyname.into(), pszinputstring.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IQuerySolution>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn RestatePropertyValueToString<'a, P0, P1>(&self, pcondition: P0, fuseenglish: P1, ppszpropertyname: *mut ::windows::core::PWSTR, ppszquerystring: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICondition>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).RestatePropertyValueToString)(::windows::core::Vtable::as_raw(self), pcondition.into().abi(), fuseenglish.into(), ::core::mem::transmute(ppszpropertyname), ::core::mem::transmute(ppszquerystring)).ok()
    }
}
::windows::core::interface_hierarchy!(IQueryParser, ::windows::core::IUnknown);
impl ::core::clone::Clone for IQueryParser {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IQueryParser {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IQueryParser {}
impl ::core::fmt::Debug for IQueryParser {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IQueryParser").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IQueryParser {
    type Vtable = IQueryParser_Vtbl;
}
unsafe impl ::windows::core::Interface for IQueryParser {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2ebdee67_3505_43f8_9946_ea44abc8e5b0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IQueryParser_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Parse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszinputstring: ::windows::core::PCWSTR, pcustomproperties: *mut ::core::ffi::c_void, ppsolution: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parse: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub SetOption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: STRUCTURED_QUERY_SINGLE_OPTION, poptionvalue: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    SetOption: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub GetOption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: STRUCTURED_QUERY_SINGLE_OPTION, poptionvalue: *mut ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    GetOption: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub SetMultiOption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: STRUCTURED_QUERY_MULTIOPTION, pszoptionkey: ::windows::core::PCWSTR, poptionvalue: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    SetMultiOption: usize,
    pub GetSchemaProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppschemaprovider: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub RestateToString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcondition: *mut ::core::ffi::c_void, fuseenglish: super::super::Foundation::BOOL, ppszquerystring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    RestateToString: usize,
    pub ParsePropertyValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpropertyname: ::windows::core::PCWSTR, pszinputstring: ::windows::core::PCWSTR, ppsolution: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub RestatePropertyValueToString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcondition: *mut ::core::ffi::c_void, fuseenglish: super::super::Foundation::BOOL, ppszpropertyname: *mut ::windows::core::PWSTR, ppszquerystring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    RestatePropertyValueToString: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IQueryParserManager(::windows::core::IUnknown);
impl IQueryParserManager {
    pub unsafe fn CreateLoadedParser<'a, P0, T>(&self, pszcatalog: P0, langidforkeywords: u16) -> ::windows::core::Result<T>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).CreateLoadedParser)(::windows::core::Vtable::as_raw(self), pszcatalog.into(), langidforkeywords, &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeOptions<'a, P0, P1, P2>(&self, funderstandnqs: P0, fautowildcard: P1, pqueryparser: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, IQueryParser>>,
    {
        (::windows::core::Vtable::vtable(self).InitializeOptions)(::windows::core::Vtable::as_raw(self), funderstandnqs.into(), fautowildcard.into(), pqueryparser.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetOption(&self, option: QUERY_PARSER_MANAGER_OPTION, poptionvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetOption)(::windows::core::Vtable::as_raw(self), option, ::core::mem::transmute(poptionvalue)).ok()
    }
}
::windows::core::interface_hierarchy!(IQueryParserManager, ::windows::core::IUnknown);
impl ::core::clone::Clone for IQueryParserManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IQueryParserManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IQueryParserManager {}
impl ::core::fmt::Debug for IQueryParserManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IQueryParserManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IQueryParserManager {
    type Vtable = IQueryParserManager_Vtbl;
}
unsafe impl ::windows::core::Interface for IQueryParserManager {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa879e3c4_af77_44fb_8f37_ebd1487cf920);
}
#[repr(C)]
#[doc(hidden)]
pub struct IQueryParserManager_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub CreateLoadedParser: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcatalog: ::windows::core::PCWSTR, langidforkeywords: u16, riid: *const ::windows::core::GUID, ppqueryparser: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub InitializeOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, funderstandnqs: super::super::Foundation::BOOL, fautowildcard: super::super::Foundation::BOOL, pqueryparser: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InitializeOptions: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub SetOption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, option: QUERY_PARSER_MANAGER_OPTION, poptionvalue: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    SetOption: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IQuerySolution(::windows::core::IUnknown);
impl IQuerySolution {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn MakeNot<'a, P0, P1>(&self, pcsub: P0, fsimplify: P1) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICondition>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.MakeNot)(::windows::core::Vtable::as_raw(self), pcsub.into().abi(), fsimplify.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeAndOr<'a, P0, P1>(&self, ct: Common::CONDITION_TYPE, peusubs: P0, fsimplify: P1) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IEnumUnknown>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.MakeAndOr)(::windows::core::Vtable::as_raw(self), ct, peusubs.into().abi(), fsimplify.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Search_Common\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Search_Common"))]
    pub unsafe fn MakeLeaf<'a, P0, P1, P2, P3, P4, P5>(&self, pszpropertyname: P0, cop: Common::CONDITION_OPERATION, pszvaluetype: P1, ppropvar: *const super::Com::StructuredStorage::PROPVARIANT, ppropertynameterm: P2, poperationterm: P3, pvalueterm: P4, fexpand: P5) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P3: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P4: ::std::convert::Into<::windows::core::InParam<'a, IRichChunk>>,
        P5: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.MakeLeaf)(::windows::core::Vtable::as_raw(self), pszpropertyname.into(), cop, pszvaluetype.into(), ::core::mem::transmute(ppropvar), ppropertynameterm.into().abi(), poperationterm.into().abi(), pvalueterm.into().abi(), fexpand.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Resolve<'a, P0>(&self, pc: P0, sqro: STRUCTURED_QUERY_RESOLVE_OPTION, pstreferencetime: ::core::option::Option<*const super::super::Foundation::SYSTEMTIME>) -> ::windows::core::Result<ICondition>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ICondition>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Resolve)(::windows::core::Vtable::as_raw(self), pc.into().abi(), sqro, ::core::mem::transmute(pstreferencetime.unwrap_or(::std::ptr::null())), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ICondition>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetQuery(&self, ppquerynode: ::core::option::Option<*mut ::core::option::Option<ICondition>>, ppmaintype: ::core::option::Option<*mut ::core::option::Option<IEntity>>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetQuery)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppquerynode.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppmaintype.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetErrors<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).GetErrors)(::windows::core::Vtable::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetLexicalData(&self, ppszinputstring: ::core::option::Option<*mut ::windows::core::PWSTR>, pptokens: ::core::option::Option<*mut ::core::option::Option<ITokenCollection>>, plcid: ::core::option::Option<*mut u32>, ppwordbreaker: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetLexicalData)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppszinputstring.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pptokens.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plcid.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppwordbreaker.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(IQuerySolution, ::windows::core::IUnknown, IConditionFactory);
impl ::core::clone::Clone for IQuerySolution {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IQuerySolution {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IQuerySolution {}
impl ::core::fmt::Debug for IQuerySolution {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IQuerySolution").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IQuerySolution {
    type Vtable = IQuerySolution_Vtbl;
}
unsafe impl ::windows::core::Interface for IQuerySolution {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd6ebc66b_8921_4193_afdd_a1789fb7ff57);
}
#[repr(C)]
#[doc(hidden)]
pub struct IQuerySolution_Vtbl {
    pub base__: IConditionFactory_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetQuery: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppquerynode: *mut *mut ::core::ffi::c_void, ppmaintype: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetQuery: usize,
    pub GetErrors: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppparseerrors: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetLexicalData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszinputstring: *mut ::windows::core::PWSTR, pptokens: *mut *mut ::core::ffi::c_void, plcid: *mut u32, ppwordbreaker: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IReadData(::windows::core::IUnknown);
impl IReadData {
    pub unsafe fn ReadData<'a, P0>(&self, hchapter: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, haccessor: P0, crows: isize, pcrowsobtained: *mut usize, ppfixeddata: *mut *mut u8, pcbvariabletotal: *mut usize, ppvariabledata: *mut *mut u8) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).ReadData)(::windows::core::Vtable::as_raw(self), hchapter, cbbookmark, ::core::mem::transmute(pbookmark), lrowsoffset, haccessor.into(), crows, ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(ppfixeddata), ::core::mem::transmute(pcbvariabletotal), ::core::mem::transmute(ppvariabledata)).ok()
    }
    pub unsafe fn ReleaseChapter(&self, hchapter: usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ReleaseChapter)(::windows::core::Vtable::as_raw(self), hchapter).ok()
    }
}
::windows::core::interface_hierarchy!(IReadData, ::windows::core::IUnknown);
impl ::core::clone::Clone for IReadData {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IReadData {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IReadData {}
impl ::core::fmt::Debug for IReadData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IReadData").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IReadData {
    type Vtable = IReadData_Vtbl;
}
unsafe impl ::windows::core::Interface for IReadData {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6a_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IReadData_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub ReadData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, haccessor: HACCESSOR, crows: isize, pcrowsobtained: *mut usize, ppfixeddata: *mut *mut u8, pcbvariabletotal: *mut usize, ppvariabledata: *mut *mut u8) -> ::windows::core::HRESULT,
    pub ReleaseChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRegisterProvider(::windows::core::IUnknown);
impl IRegisterProvider {
    pub unsafe fn GetURLMapping<'a, P0>(&self, pwszurl: P0, dwreserved: usize) -> ::windows::core::Result<::windows::core::GUID>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetURLMapping)(::windows::core::Vtable::as_raw(self), pwszurl.into(), dwreserved, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    pub unsafe fn SetURLMapping<'a, P0>(&self, pwszurl: P0, dwreserved: usize, rclsidprovider: ::core::option::Option<*const ::windows::core::GUID>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetURLMapping)(::windows::core::Vtable::as_raw(self), pwszurl.into(), dwreserved, ::core::mem::transmute(rclsidprovider.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn UnregisterProvider<'a, P0>(&self, pwszurl: P0, dwreserved: usize, rclsidprovider: ::core::option::Option<*const ::windows::core::GUID>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).UnregisterProvider)(::windows::core::Vtable::as_raw(self), pwszurl.into(), dwreserved, ::core::mem::transmute(rclsidprovider.unwrap_or(::std::ptr::null()))).ok()
    }
}
::windows::core::interface_hierarchy!(IRegisterProvider, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRegisterProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRegisterProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRegisterProvider {}
impl ::core::fmt::Debug for IRegisterProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRegisterProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRegisterProvider {
    type Vtable = IRegisterProvider_Vtbl;
}
unsafe impl ::windows::core::Interface for IRegisterProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab9_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRegisterProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetURLMapping: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, dwreserved: usize, pclsidprovider: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub SetURLMapping: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, dwreserved: usize, rclsidprovider: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub UnregisterProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, dwreserved: usize, rclsidprovider: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRelationship(::windows::core::IUnknown);
impl IRelationship {
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Name)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsReal(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsReal)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn Destination(&self) -> ::windows::core::Result<IEntity> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Destination)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEntity>(result__)
    }
    pub unsafe fn MetaData<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).MetaData)(::windows::core::Vtable::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn DefaultPhrase(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).DefaultPhrase)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
}
::windows::core::interface_hierarchy!(IRelationship, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRelationship {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRelationship {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRelationship {}
impl ::core::fmt::Debug for IRelationship {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRelationship").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRelationship {
    type Vtable = IRelationship_Vtbl;
}
unsafe impl ::windows::core::Interface for IRelationship {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2769280b_5108_498c_9c7f_a51239b63147);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRelationship_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub IsReal: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pisreal: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsReal: usize,
    pub Destination: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdestinationentity: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub MetaData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pmetadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DefaultPhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszphrase: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRichChunk(::windows::core::IUnknown);
impl IRichChunk {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetData(&self, pfirstpos: ::core::option::Option<*mut u32>, plength: ::core::option::Option<*mut u32>, ppsz: ::core::option::Option<*mut ::windows::core::PWSTR>, pvalue: ::core::option::Option<*mut super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetData)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pfirstpos.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plength.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppsz.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvalue.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(IRichChunk, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRichChunk {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRichChunk {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRichChunk {}
impl ::core::fmt::Debug for IRichChunk {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRichChunk").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRichChunk {
    type Vtable = IRichChunk_Vtbl;
}
unsafe impl ::windows::core::Interface for IRichChunk {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4fdef69c_dbc9_454e_9910_b34f3c64b510);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRichChunk_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub GetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfirstpos: *mut u32, plength: *mut u32, ppsz: *mut ::windows::core::PWSTR, pvalue: *mut ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    GetData: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRow(::windows::core::IUnknown);
impl IRow {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetColumns(&self, rgcolumns: &mut [DBCOLUMNACCESS]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetColumns)(::windows::core::Vtable::as_raw(self), rgcolumns.len() as _, ::core::mem::transmute(rgcolumns.as_ptr())).ok()
    }
    pub unsafe fn GetSourceRowset(&self, riid: *const ::windows::core::GUID, pprowset: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>, phrow: ::core::option::Option<*mut usize>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetSourceRowset)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(pprowset.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(phrow.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn Open<'a, P0>(&self, punkouter: P0, pcolumnid: *const super::super::Storage::IndexServer::DBID, rguidcolumntype: *const ::windows::core::GUID, dwbindflags: u32, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Open)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(pcolumnid), ::core::mem::transmute(rguidcolumntype), dwbindflags, ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IRow, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRow {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRow {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRow {}
impl ::core::fmt::Debug for IRow {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRow").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRow {
    type Vtable = IRow_Vtbl;
}
unsafe impl ::windows::core::Interface for IRow {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab4_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRow_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgcolumns: *mut DBCOLUMNACCESS) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetColumns: usize,
    pub GetSourceRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub Open: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, pcolumnid: *const super::super::Storage::IndexServer::DBID, rguidcolumntype: *const ::windows::core::GUID, dwbindflags: u32, riid: *const ::windows::core::GUID, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    Open: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowChange(::windows::core::IUnknown);
impl IRowChange {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn SetColumns(&self, rgcolumns: &[DBCOLUMNACCESS]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetColumns)(::windows::core::Vtable::as_raw(self), rgcolumns.len() as _, ::core::mem::transmute(rgcolumns.as_ptr())).ok()
    }
}
::windows::core::interface_hierarchy!(IRowChange, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowChange {}
impl ::core::fmt::Debug for IRowChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowChange {
    type Vtable = IRowChange_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowChange {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab5_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowChange_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub SetColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgcolumns: *const DBCOLUMNACCESS) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    SetColumns: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowPosition(::windows::core::IUnknown);
impl IRowPosition {
    pub unsafe fn ClearRowPosition(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ClearRowPosition)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetRowPosition(&self, phchapter: ::core::option::Option<*mut usize>, phrow: *mut usize, pdwpositionflags: ::core::option::Option<*mut u32>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetRowPosition)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(phchapter.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(phrow), ::core::mem::transmute(pdwpositionflags.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetRowset(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetRowset)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn Initialize<'a, P0>(&self, prowset: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).Initialize)(::windows::core::Vtable::as_raw(self), prowset.into().abi()).ok()
    }
    pub unsafe fn SetRowPosition(&self, hchapter: usize, hrow: usize, dwpositionflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetRowPosition)(::windows::core::Vtable::as_raw(self), hchapter, hrow, dwpositionflags).ok()
    }
}
::windows::core::interface_hierarchy!(IRowPosition, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowPosition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowPosition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowPosition {}
impl ::core::fmt::Debug for IRowPosition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowPosition").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowPosition {
    type Vtable = IRowPosition_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowPosition {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a94_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowPosition_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub ClearRowPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetRowPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phchapter: *mut usize, phrow: *mut usize, pdwpositionflags: *mut u32) -> ::windows::core::HRESULT,
    pub GetRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetRowPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, hrow: usize, dwpositionflags: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowPositionChange(::windows::core::IUnknown);
impl IRowPositionChange {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnRowPositionChange<'a, P0>(&self, ereason: u32, ephase: u32, fcantdeny: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).OnRowPositionChange)(::windows::core::Vtable::as_raw(self), ereason, ephase, fcantdeny.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IRowPositionChange, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowPositionChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowPositionChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowPositionChange {}
impl ::core::fmt::Debug for IRowPositionChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowPositionChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowPositionChange {
    type Vtable = IRowPositionChange_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowPositionChange {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0997a571_126e_11d0_9f8a_00a0c9a0631e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowPositionChange_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub OnRowPositionChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnRowPositionChange: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowSchemaChange(::windows::core::IUnknown);
impl IRowSchemaChange {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn SetColumns(&self, rgcolumns: &[DBCOLUMNACCESS]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetColumns)(::windows::core::Vtable::as_raw(self), rgcolumns.len() as _, ::core::mem::transmute(rgcolumns.as_ptr())).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DeleteColumns(&self, ccolumns: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgdwstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DeleteColumns)(::windows::core::Vtable::as_raw(self), ccolumns, ::core::mem::transmute(rgcolumnids), ::core::mem::transmute(rgdwstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub unsafe fn AddColumns(&self, ccolumns: usize, rgnewcolumninfo: *const DBCOLUMNINFO, rgcolumns: *mut DBCOLUMNACCESS) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AddColumns)(::windows::core::Vtable::as_raw(self), ccolumns, ::core::mem::transmute(rgnewcolumninfo), ::core::mem::transmute(rgcolumns)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowSchemaChange, ::windows::core::IUnknown, IRowChange);
impl ::core::clone::Clone for IRowSchemaChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowSchemaChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowSchemaChange {}
impl ::core::fmt::Debug for IRowSchemaChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowSchemaChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowSchemaChange {
    type Vtable = IRowSchemaChange_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowSchemaChange {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aae_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowSchemaChange_Vtbl {
    pub base__: IRowChange_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub DeleteColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgcolumnids: *const super::super::Storage::IndexServer::DBID, rgdwstatus: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    DeleteColumns: usize,
    #[cfg(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com"))]
    pub AddColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ccolumns: usize, rgnewcolumninfo: *const ::core::mem::ManuallyDrop<DBCOLUMNINFO>, rgcolumns: *mut DBCOLUMNACCESS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com")))]
    AddColumns: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowset(::windows::core::IUnknown);
impl IRowset {
    pub unsafe fn AddRefRows(&self, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AddRefRows)(::windows::core::Vtable::as_raw(self), crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    pub unsafe fn GetData<'a, P0>(&self, hrow: usize, haccessor: P0, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).GetData)(::windows::core::Vtable::as_raw(self), hrow, haccessor.into(), ::core::mem::transmute(pdata)).ok()
    }
    pub unsafe fn GetNextRows(&self, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetNextRows)(::windows::core::Vtable::as_raw(self), hreserved, lrowsoffset, crows, ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    pub unsafe fn ReleaseRows(&self, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ReleaseRows)(::windows::core::Vtable::as_raw(self), crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowoptions), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    pub unsafe fn RestartPosition(&self, hreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).RestartPosition)(::windows::core::Vtable::as_raw(self), hreserved).ok()
    }
}
::windows::core::interface_hierarchy!(IRowset, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowset {}
impl ::core::fmt::Debug for IRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowset {
    type Vtable = IRowset_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7c_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub AddRefRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub GetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: HACCESSOR, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetNextRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
    pub ReleaseRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub RestartPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetAsynch(::windows::core::IUnknown);
impl IRowsetAsynch {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RatioFinished(&self, puldenominator: *mut usize, pulnumerator: *mut usize, pcrows: *mut usize, pfnewrows: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).RatioFinished)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(puldenominator), ::core::mem::transmute(pulnumerator), ::core::mem::transmute(pcrows), ::core::mem::transmute(pfnewrows)).ok()
    }
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Stop)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetAsynch, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetAsynch {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetAsynch {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetAsynch {}
impl ::core::fmt::Debug for IRowsetAsynch {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetAsynch").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetAsynch {
    type Vtable = IRowsetAsynch_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetAsynch {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a0f_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetAsynch_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub RatioFinished: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puldenominator: *mut usize, pulnumerator: *mut usize, pcrows: *mut usize, pfnewrows: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RatioFinished: usize,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetBookmark(::windows::core::IUnknown);
impl IRowsetBookmark {
    pub unsafe fn PositionOnBookmark(&self, hchapter: usize, pbookmark: &[u8]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).PositionOnBookmark)(::windows::core::Vtable::as_raw(self), hchapter, pbookmark.len() as _, ::core::mem::transmute(pbookmark.as_ptr())).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetBookmark, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetBookmark {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetBookmark {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetBookmark {}
impl ::core::fmt::Debug for IRowsetBookmark {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetBookmark").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetBookmark {
    type Vtable = IRowsetBookmark_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetBookmark {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ac2_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetBookmark_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub PositionOnBookmark: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, cbbookmark: usize, pbookmark: *const u8) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetChange(::windows::core::IUnknown);
impl IRowsetChange {
    pub unsafe fn DeleteRows(&self, hreserved: usize, crows: usize, rghrows: *const usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DeleteRows)(::windows::core::Vtable::as_raw(self), hreserved, crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    pub unsafe fn SetData<'a, P0>(&self, hrow: usize, haccessor: P0, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).SetData)(::windows::core::Vtable::as_raw(self), hrow, haccessor.into(), ::core::mem::transmute(pdata)).ok()
    }
    pub unsafe fn InsertRow<'a, P0>(&self, hreserved: usize, haccessor: P0, pdata: *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).InsertRow)(::windows::core::Vtable::as_raw(self), hreserved, haccessor.into(), ::core::mem::transmute(pdata), ::core::mem::transmute(phrow)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetChange, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetChange {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetChange {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetChange {}
impl ::core::fmt::Debug for IRowsetChange {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetChange").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetChange {
    type Vtable = IRowsetChange_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetChange {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a05_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetChange_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub DeleteRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub SetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: HACCESSOR, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub InsertRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, haccessor: HACCESSOR, pdata: *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetChangeExtInfo(::windows::core::IUnknown);
impl IRowsetChangeExtInfo {
    pub unsafe fn GetOriginalRow(&self, hreserved: usize, hrow: usize, phroworiginal: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetOriginalRow)(::windows::core::Vtable::as_raw(self), hreserved, hrow, ::core::mem::transmute(phroworiginal)).ok()
    }
    pub unsafe fn GetPendingColumns(&self, hreserved: usize, hrow: usize, ccolumnordinals: u32, rgiordinals: *const u32, rgcolumnstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetPendingColumns)(::windows::core::Vtable::as_raw(self), hreserved, hrow, ccolumnordinals, ::core::mem::transmute(rgiordinals), ::core::mem::transmute(rgcolumnstatus)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetChangeExtInfo, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetChangeExtInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetChangeExtInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetChangeExtInfo {}
impl ::core::fmt::Debug for IRowsetChangeExtInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetChangeExtInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetChangeExtInfo {
    type Vtable = IRowsetChangeExtInfo_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetChangeExtInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a8f_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetChangeExtInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetOriginalRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, hrow: usize, phroworiginal: *mut usize) -> ::windows::core::HRESULT,
    pub GetPendingColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, hrow: usize, ccolumnordinals: u32, rgiordinals: *const u32, rgcolumnstatus: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetChapterMember(::windows::core::IUnknown);
impl IRowsetChapterMember {
    pub unsafe fn IsRowInChapter(&self, hchapter: usize, hrow: usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).IsRowInChapter)(::windows::core::Vtable::as_raw(self), hchapter, hrow).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetChapterMember, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetChapterMember {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetChapterMember {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetChapterMember {}
impl ::core::fmt::Debug for IRowsetChapterMember {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetChapterMember").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetChapterMember {
    type Vtable = IRowsetChapterMember_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetChapterMember {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa8_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetChapterMember_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub IsRowInChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, hrow: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetCopyRows(::windows::core::IUnknown);
impl IRowsetCopyRows {
    pub unsafe fn CloseSource(&self, hsourceid: u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CloseSource)(::windows::core::Vtable::as_raw(self), hsourceid).ok()
    }
    pub unsafe fn CopyByHROWS(&self, hsourceid: u16, hreserved: usize, crows: isize, rghrows: *const usize, bflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CopyByHROWS)(::windows::core::Vtable::as_raw(self), hsourceid, hreserved, crows, ::core::mem::transmute(rghrows), bflags).ok()
    }
    pub unsafe fn CopyRows(&self, hsourceid: u16, hreserved: usize, crows: isize, bflags: u32, pcrowscopied: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CopyRows)(::windows::core::Vtable::as_raw(self), hsourceid, hreserved, crows, bflags, ::core::mem::transmute(pcrowscopied)).ok()
    }
    pub unsafe fn DefineSource<'a, P0>(&self, prowsetsource: P0, ccolids: usize, rgsourcecolumns: *const isize, rgtargetcolumns: *const isize, phsourceid: *mut u16) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IRowset>>,
    {
        (::windows::core::Vtable::vtable(self).DefineSource)(::windows::core::Vtable::as_raw(self), prowsetsource.into().abi(), ccolids, ::core::mem::transmute(rgsourcecolumns), ::core::mem::transmute(rgtargetcolumns), ::core::mem::transmute(phsourceid)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetCopyRows, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetCopyRows {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetCopyRows {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetCopyRows {}
impl ::core::fmt::Debug for IRowsetCopyRows {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetCopyRows").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetCopyRows {
    type Vtable = IRowsetCopyRows_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetCopyRows {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6b_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetCopyRows_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub CloseSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hsourceid: u16) -> ::windows::core::HRESULT,
    pub CopyByHROWS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hsourceid: u16, hreserved: usize, crows: isize, rghrows: *const usize, bflags: u32) -> ::windows::core::HRESULT,
    pub CopyRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hsourceid: u16, hreserved: usize, crows: isize, bflags: u32, pcrowscopied: *mut usize) -> ::windows::core::HRESULT,
    pub DefineSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowsetsource: *mut ::core::ffi::c_void, ccolids: usize, rgsourcecolumns: *const isize, rgtargetcolumns: *const isize, phsourceid: *mut u16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetCurrentIndex(::windows::core::IUnknown);
impl IRowsetCurrentIndex {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetIndexInfo(&self, pckeycolumns: *mut usize, prgindexcolumndesc: *mut *mut DBINDEXCOLUMNDESC, pcindexpropertysets: *mut u32, prgindexpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetIndexInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pckeycolumns), ::core::mem::transmute(prgindexcolumndesc), ::core::mem::transmute(pcindexpropertysets), ::core::mem::transmute(prgindexpropertysets)).ok()
    }
    pub unsafe fn Seek<'a, P0>(&self, haccessor: P0, ckeyvalues: usize, pdata: *mut ::core::ffi::c_void, dwseekoptions: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).base__.Seek)(::windows::core::Vtable::as_raw(self), haccessor.into(), ckeyvalues, ::core::mem::transmute(pdata), dwseekoptions).ok()
    }
    pub unsafe fn SetRange<'a, P0>(&self, haccessor: P0, cstartkeycolumns: usize, pstartdata: *mut ::core::ffi::c_void, cendkeycolumns: usize, penddata: *mut ::core::ffi::c_void, dwrangeoptions: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetRange)(::windows::core::Vtable::as_raw(self), haccessor.into(), cstartkeycolumns, ::core::mem::transmute(pstartdata), cendkeycolumns, ::core::mem::transmute(penddata), dwrangeoptions).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn GetIndex(&self, ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetIndex)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppindexid)).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn SetIndex(&self, pindexid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetIndex)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pindexid)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetCurrentIndex, ::windows::core::IUnknown, IRowsetIndex);
impl ::core::clone::Clone for IRowsetCurrentIndex {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetCurrentIndex {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetCurrentIndex {}
impl ::core::fmt::Debug for IRowsetCurrentIndex {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetCurrentIndex").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetCurrentIndex {
    type Vtable = IRowsetCurrentIndex_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetCurrentIndex {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733abd_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetCurrentIndex_Vtbl {
    pub base__: IRowsetIndex_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub GetIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppindexid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    GetIndex: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub SetIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pindexid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    SetIndex: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetEvents(::windows::core::IUnknown);
impl IRowsetEvents {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnNewItem(&self, itemid: *const super::Com::StructuredStorage::PROPVARIANT, newitemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnNewItem)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(itemid), newitemstate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnChangedItem(&self, itemid: *const super::Com::StructuredStorage::PROPVARIANT, rowsetitemstate: ROWSETEVENT_ITEMSTATE, changeditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnChangedItem)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(itemid), rowsetitemstate, changeditemstate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnDeletedItem(&self, itemid: *const super::Com::StructuredStorage::PROPVARIANT, deleteditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnDeletedItem)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(itemid), deleteditemstate).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn OnRowsetEvent(&self, eventtype: ROWSETEVENT_TYPE, eventdata: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnRowsetEvent)(::windows::core::Vtable::as_raw(self), eventtype, ::core::mem::transmute(eventdata)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetEvents, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetEvents {}
impl ::core::fmt::Debug for IRowsetEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetEvents {
    type Vtable = IRowsetEvents_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetEvents {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1551aea5_5d66_4b11_86f5_d5634cb211b9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetEvents_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub OnNewItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itemid: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>, newitemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    OnNewItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub OnChangedItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itemid: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>, rowsetitemstate: ROWSETEVENT_ITEMSTATE, changeditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    OnChangedItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub OnDeletedItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itemid: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>, deleteditemstate: ROWSETEVENT_ITEMSTATE) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    OnDeletedItem: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub OnRowsetEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventtype: ROWSETEVENT_TYPE, eventdata: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    OnRowsetEvent: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetFastLoad(::windows::core::IUnknown);
impl IRowsetFastLoad {
    pub unsafe fn InsertRow<'a, P0>(&self, haccessor: P0, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).InsertRow)(::windows::core::Vtable::as_raw(self), haccessor.into(), ::core::mem::transmute(pdata)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Commit<'a, P0>(&self, fdone: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).Commit)(::windows::core::Vtable::as_raw(self), fdone.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetFastLoad, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetFastLoad {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetFastLoad {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetFastLoad {}
impl ::core::fmt::Debug for IRowsetFastLoad {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetFastLoad").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetFastLoad {
    type Vtable = IRowsetFastLoad_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetFastLoad {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca13_ef21_11d0_97e7_00c04fc2ad98);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetFastLoad_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub InsertRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: HACCESSOR, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Commit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdone: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Commit: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetFind(::windows::core::IUnknown);
impl IRowsetFind {
    pub unsafe fn FindNextRow<'a, P0>(&self, hchapter: usize, haccessor: P0, pfindvalue: *mut ::core::ffi::c_void, compareop: u32, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).FindNextRow)(::windows::core::Vtable::as_raw(self), hchapter, haccessor.into(), ::core::mem::transmute(pfindvalue), compareop, cbbookmark, ::core::mem::transmute(pbookmark), lrowsoffset, crows, ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetFind, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetFind {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetFind {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetFind {}
impl ::core::fmt::Debug for IRowsetFind {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetFind").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetFind {
    type Vtable = IRowsetFind_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetFind {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a9d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetFind_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub FindNextRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, haccessor: HACCESSOR, pfindvalue: *mut ::core::ffi::c_void, compareop: u32, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetIdentity(::windows::core::IUnknown);
impl IRowsetIdentity {
    pub unsafe fn IsSameRow(&self, hthisrow: usize, hthatrow: usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).IsSameRow)(::windows::core::Vtable::as_raw(self), hthisrow, hthatrow).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetIdentity, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetIdentity {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetIdentity {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetIdentity {}
impl ::core::fmt::Debug for IRowsetIdentity {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetIdentity").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetIdentity {
    type Vtable = IRowsetIdentity_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetIdentity {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a09_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetIdentity_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub IsSameRow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hthisrow: usize, hthatrow: usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetIndex(::windows::core::IUnknown);
impl IRowsetIndex {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetIndexInfo(&self, pckeycolumns: *mut usize, prgindexcolumndesc: *mut *mut DBINDEXCOLUMNDESC, pcindexpropertysets: *mut u32, prgindexpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetIndexInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pckeycolumns), ::core::mem::transmute(prgindexcolumndesc), ::core::mem::transmute(pcindexpropertysets), ::core::mem::transmute(prgindexpropertysets)).ok()
    }
    pub unsafe fn Seek<'a, P0>(&self, haccessor: P0, ckeyvalues: usize, pdata: *mut ::core::ffi::c_void, dwseekoptions: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).Seek)(::windows::core::Vtable::as_raw(self), haccessor.into(), ckeyvalues, ::core::mem::transmute(pdata), dwseekoptions).ok()
    }
    pub unsafe fn SetRange<'a, P0>(&self, haccessor: P0, cstartkeycolumns: usize, pstartdata: *mut ::core::ffi::c_void, cendkeycolumns: usize, penddata: *mut ::core::ffi::c_void, dwrangeoptions: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).SetRange)(::windows::core::Vtable::as_raw(self), haccessor.into(), cstartkeycolumns, ::core::mem::transmute(pstartdata), cendkeycolumns, ::core::mem::transmute(penddata), dwrangeoptions).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetIndex, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetIndex {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetIndex {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetIndex {}
impl ::core::fmt::Debug for IRowsetIndex {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetIndex").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetIndex {
    type Vtable = IRowsetIndex_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetIndex {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a82_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetIndex_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetIndexInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pckeycolumns: *mut usize, prgindexcolumndesc: *mut *mut DBINDEXCOLUMNDESC, pcindexpropertysets: *mut u32, prgindexpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetIndexInfo: usize,
    pub Seek: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: HACCESSOR, ckeyvalues: usize, pdata: *mut ::core::ffi::c_void, dwseekoptions: u32) -> ::windows::core::HRESULT,
    pub SetRange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: HACCESSOR, cstartkeycolumns: usize, pstartdata: *mut ::core::ffi::c_void, cendkeycolumns: usize, penddata: *mut ::core::ffi::c_void, dwrangeoptions: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetInfo(::windows::core::IUnknown);
impl IRowsetInfo {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, rgpropertyidsets: ::core::option::Option<&[DBPROPIDSET]>, pcpropertysets: *mut u32, prgpropertysets: ::core::option::Option<*mut *mut DBPROPSET>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetProperties)(::windows::core::Vtable::as_raw(self), rgpropertyidsets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertyidsets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetReferencedRowset(&self, iordinal: usize, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetReferencedRowset)(::windows::core::Vtable::as_raw(self), iordinal, ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn GetSpecification(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSpecification)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IRowsetInfo, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetInfo {}
impl ::core::fmt::Debug for IRowsetInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetInfo {
    type Vtable = IRowsetInfo_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a55_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetProperties: usize,
    pub GetReferencedRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iordinal: usize, riid: *const ::windows::core::GUID, ppreferencedrowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetSpecification: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppspecification: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetKeys(::windows::core::IUnknown);
impl IRowsetKeys {
    pub unsafe fn ListKeys(&self, pccolumns: *mut usize, prgcolumns: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ListKeys)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pccolumns), ::core::mem::transmute(prgcolumns)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetKeys, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetKeys {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetKeys {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetKeys {}
impl ::core::fmt::Debug for IRowsetKeys {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetKeys").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetKeys {
    type Vtable = IRowsetKeys_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetKeys {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a12_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetKeys_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub ListKeys: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pccolumns: *mut usize, prgcolumns: *mut *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetLocate(::windows::core::IUnknown);
impl IRowsetLocate {
    pub unsafe fn AddRefRows(&self, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.AddRefRows)(::windows::core::Vtable::as_raw(self), crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    pub unsafe fn GetData<'a, P0>(&self, hrow: usize, haccessor: P0, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).base__.GetData)(::windows::core::Vtable::as_raw(self), hrow, haccessor.into(), ::core::mem::transmute(pdata)).ok()
    }
    pub unsafe fn GetNextRows(&self, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetNextRows)(::windows::core::Vtable::as_raw(self), hreserved, lrowsoffset, crows, ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    pub unsafe fn ReleaseRows(&self, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.ReleaseRows)(::windows::core::Vtable::as_raw(self), crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowoptions), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    pub unsafe fn RestartPosition(&self, hreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.RestartPosition)(::windows::core::Vtable::as_raw(self), hreserved).ok()
    }
    pub unsafe fn Compare(&self, hreserved: usize, cbbookmark1: usize, pbookmark1: *const u8, cbbookmark2: usize, pbookmark2: *const u8, pcomparison: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Compare)(::windows::core::Vtable::as_raw(self), hreserved, cbbookmark1, ::core::mem::transmute(pbookmark1), cbbookmark2, ::core::mem::transmute(pbookmark2), ::core::mem::transmute(pcomparison)).ok()
    }
    pub unsafe fn GetRowsAt(&self, hreserved1: usize, hreserved2: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetRowsAt)(::windows::core::Vtable::as_raw(self), hreserved1, hreserved2, cbbookmark, ::core::mem::transmute(pbookmark), lrowsoffset, crows, ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    pub unsafe fn GetRowsByBookmark(&self, hreserved: usize, crows: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghrows: *mut usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetRowsByBookmark)(::windows::core::Vtable::as_raw(self), hreserved, crows, ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    pub unsafe fn Hash(&self, hreserved: usize, cbookmarks: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghashedvalues: *mut usize, rgbookmarkstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Hash)(::windows::core::Vtable::as_raw(self), hreserved, cbookmarks, ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghashedvalues), ::core::mem::transmute(rgbookmarkstatus)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetLocate, ::windows::core::IUnknown, IRowset);
impl ::core::clone::Clone for IRowsetLocate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetLocate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetLocate {}
impl ::core::fmt::Debug for IRowsetLocate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetLocate").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetLocate {
    type Vtable = IRowsetLocate_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetLocate {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetLocate_Vtbl {
    pub base__: IRowset_Vtbl,
    pub Compare: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbbookmark1: usize, pbookmark1: *const u8, cbbookmark2: usize, pbookmark2: *const u8, pcomparison: *mut u32) -> ::windows::core::HRESULT,
    pub GetRowsAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved1: usize, hreserved2: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
    pub GetRowsByBookmark: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghrows: *mut usize, rgrowstatus: *mut u32) -> ::windows::core::HRESULT,
    pub Hash: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbookmarks: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghashedvalues: *mut usize, rgbookmarkstatus: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetNewRowAfter(::windows::core::IUnknown);
impl IRowsetNewRowAfter {
    pub unsafe fn SetNewDataAfter<'a, P0>(&self, hchapter: usize, cbbmprevious: u32, pbmprevious: *const u8, haccessor: P0, pdata: *mut u8, phrow: *mut usize) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).SetNewDataAfter)(::windows::core::Vtable::as_raw(self), hchapter, cbbmprevious, ::core::mem::transmute(pbmprevious), haccessor.into(), ::core::mem::transmute(pdata), ::core::mem::transmute(phrow)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetNewRowAfter, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetNewRowAfter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetNewRowAfter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetNewRowAfter {}
impl ::core::fmt::Debug for IRowsetNewRowAfter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetNewRowAfter").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetNewRowAfter {
    type Vtable = IRowsetNewRowAfter_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetNewRowAfter {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a71_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetNewRowAfter_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetNewDataAfter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, cbbmprevious: u32, pbmprevious: *const u8, haccessor: HACCESSOR, pdata: *mut u8, phrow: *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetNextRowset(::windows::core::IUnknown);
impl IRowsetNextRowset {
    pub unsafe fn GetNextRowset<'a, P0>(&self, punkouter: P0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetNextRowset)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IRowsetNextRowset, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetNextRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetNextRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetNextRowset {}
impl ::core::fmt::Debug for IRowsetNextRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetNextRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetNextRowset {
    type Vtable = IRowsetNextRowset_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetNextRowset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a72_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetNextRowset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetNextRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppnextrowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetNotify(::windows::core::IUnknown);
impl IRowsetNotify {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFieldChange<'a, P0, P1>(&self, prowset: P0, hrow: usize, rgcolumns: &[usize], ereason: u32, ephase: u32, fcantdeny: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IRowset>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).OnFieldChange)(::windows::core::Vtable::as_raw(self), prowset.into().abi(), hrow, rgcolumns.len() as _, ::core::mem::transmute(rgcolumns.as_ptr()), ereason, ephase, fcantdeny.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnRowChange<'a, P0, P1>(&self, prowset: P0, rghrows: &[usize], ereason: u32, ephase: u32, fcantdeny: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IRowset>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).OnRowChange)(::windows::core::Vtable::as_raw(self), prowset.into().abi(), rghrows.len() as _, ::core::mem::transmute(rghrows.as_ptr()), ereason, ephase, fcantdeny.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnRowsetChange<'a, P0, P1>(&self, prowset: P0, ereason: u32, ephase: u32, fcantdeny: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IRowset>>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).OnRowsetChange)(::windows::core::Vtable::as_raw(self), prowset.into().abi(), ereason, ephase, fcantdeny.into()).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetNotify, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetNotify {}
impl ::core::fmt::Debug for IRowsetNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetNotify {
    type Vtable = IRowsetNotify_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetNotify {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a83_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetNotify_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub OnFieldChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: *mut ::core::ffi::c_void, hrow: usize, ccolumns: usize, rgcolumns: *const usize, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnFieldChange: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnRowChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnRowChange: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnRowsetChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: *mut ::core::ffi::c_void, ereason: u32, ephase: u32, fcantdeny: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnRowsetChange: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetPrioritization(::windows::core::IUnknown);
impl IRowsetPrioritization {
    pub unsafe fn SetScopePriority(&self, priority: PRIORITY_LEVEL, scopestatisticseventfrequency: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetScopePriority)(::windows::core::Vtable::as_raw(self), priority, scopestatisticseventfrequency).ok()
    }
    pub unsafe fn GetScopePriority(&self, priority: *mut PRIORITY_LEVEL, scopestatisticseventfrequency: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetScopePriority)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(priority), ::core::mem::transmute(scopestatisticseventfrequency)).ok()
    }
    pub unsafe fn GetScopeStatistics(&self, indexeddocumentcount: *mut u32, oustandingaddcount: *mut u32, oustandingmodifycount: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetScopeStatistics)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(indexeddocumentcount), ::core::mem::transmute(oustandingaddcount), ::core::mem::transmute(oustandingmodifycount)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetPrioritization, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetPrioritization {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetPrioritization {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetPrioritization {}
impl ::core::fmt::Debug for IRowsetPrioritization {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetPrioritization").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetPrioritization {
    type Vtable = IRowsetPrioritization_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetPrioritization {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x42811652_079d_481b_87a2_09a69ecc5f44);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetPrioritization_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetScopePriority: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, priority: PRIORITY_LEVEL, scopestatisticseventfrequency: u32) -> ::windows::core::HRESULT,
    pub GetScopePriority: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, priority: *mut PRIORITY_LEVEL, scopestatisticseventfrequency: *mut u32) -> ::windows::core::HRESULT,
    pub GetScopeStatistics: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, indexeddocumentcount: *mut u32, oustandingaddcount: *mut u32, oustandingmodifycount: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetQueryStatus(::windows::core::IUnknown);
impl IRowsetQueryStatus {
    pub unsafe fn GetStatus(&self, pdwstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetStatus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pdwstatus)).ok()
    }
    pub unsafe fn GetStatusEx(&self, pdwstatus: *mut u32, pcfiltereddocuments: *mut u32, pcdocumentstofilter: *mut u32, pdwratiofinisheddenominator: *mut usize, pdwratiofinishednumerator: *mut usize, cbbmk: usize, pbmk: *const u8, pirowbmk: *mut usize, pcrowstotal: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetStatusEx)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pdwstatus), ::core::mem::transmute(pcfiltereddocuments), ::core::mem::transmute(pcdocumentstofilter), ::core::mem::transmute(pdwratiofinisheddenominator), ::core::mem::transmute(pdwratiofinishednumerator), cbbmk, ::core::mem::transmute(pbmk), ::core::mem::transmute(pirowbmk), ::core::mem::transmute(pcrowstotal)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetQueryStatus, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetQueryStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetQueryStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetQueryStatus {}
impl ::core::fmt::Debug for IRowsetQueryStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetQueryStatus").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetQueryStatus {
    type Vtable = IRowsetQueryStatus_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetQueryStatus {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa7ac77ed_f8d7_11ce_a798_0020f8008024);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetQueryStatus_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwstatus: *mut u32) -> ::windows::core::HRESULT,
    pub GetStatusEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwstatus: *mut u32, pcfiltereddocuments: *mut u32, pcdocumentstofilter: *mut u32, pdwratiofinisheddenominator: *mut usize, pdwratiofinishednumerator: *mut usize, cbbmk: usize, pbmk: *const u8, pirowbmk: *mut usize, pcrowstotal: *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetRefresh(::windows::core::IUnknown);
impl IRowsetRefresh {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RefreshVisibleData<'a, P0>(&self, hchapter: usize, crows: usize, rghrows: *const usize, foverwrite: P0, pcrowsrefreshed: *mut usize, prghrowsrefreshed: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).RefreshVisibleData)(::windows::core::Vtable::as_raw(self), hchapter, crows, ::core::mem::transmute(rghrows), foverwrite.into(), ::core::mem::transmute(pcrowsrefreshed), ::core::mem::transmute(prghrowsrefreshed), ::core::mem::transmute(prgrowstatus)).ok()
    }
    pub unsafe fn GetLastVisibleData<'a, P0>(&self, hrow: usize, haccessor: P0, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).GetLastVisibleData)(::windows::core::Vtable::as_raw(self), hrow, haccessor.into(), ::core::mem::transmute(pdata)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetRefresh, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetRefresh {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetRefresh {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetRefresh {}
impl ::core::fmt::Debug for IRowsetRefresh {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetRefresh").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetRefresh {
    type Vtable = IRowsetRefresh_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetRefresh {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa9_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetRefresh_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub RefreshVisibleData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, crows: usize, rghrows: *const usize, foverwrite: super::super::Foundation::BOOL, pcrowsrefreshed: *mut usize, prghrowsrefreshed: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RefreshVisibleData: usize,
    pub GetLastVisibleData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: HACCESSOR, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetResynch(::windows::core::IUnknown);
impl IRowsetResynch {
    pub unsafe fn GetVisibleData<'a, P0>(&self, hrow: usize, haccessor: P0, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).GetVisibleData)(::windows::core::Vtable::as_raw(self), hrow, haccessor.into(), ::core::mem::transmute(pdata)).ok()
    }
    pub unsafe fn ResynchRows(&self, crows: usize, rghrows: *const usize, pcrowsresynched: *mut usize, prghrowsresynched: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ResynchRows)(::windows::core::Vtable::as_raw(self), crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(pcrowsresynched), ::core::mem::transmute(prghrowsresynched), ::core::mem::transmute(prgrowstatus)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetResynch, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetResynch {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetResynch {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetResynch {}
impl ::core::fmt::Debug for IRowsetResynch {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetResynch").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetResynch {
    type Vtable = IRowsetResynch_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetResynch {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a84_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetResynch_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetVisibleData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: HACCESSOR, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ResynchRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rghrows: *const usize, pcrowsresynched: *mut usize, prghrowsresynched: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetScroll(::windows::core::IUnknown);
impl IRowsetScroll {
    pub unsafe fn AddRefRows(&self, crows: usize, rghrows: *const usize, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.AddRefRows)(::windows::core::Vtable::as_raw(self), crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    pub unsafe fn GetData<'a, P0>(&self, hrow: usize, haccessor: P0, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.GetData)(::windows::core::Vtable::as_raw(self), hrow, haccessor.into(), ::core::mem::transmute(pdata)).ok()
    }
    pub unsafe fn GetNextRows(&self, hreserved: usize, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetNextRows)(::windows::core::Vtable::as_raw(self), hreserved, lrowsoffset, crows, ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    pub unsafe fn ReleaseRows(&self, crows: usize, rghrows: *const usize, rgrowoptions: *mut u32, rgrefcounts: *mut u32, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.ReleaseRows)(::windows::core::Vtable::as_raw(self), crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowoptions), ::core::mem::transmute(rgrefcounts), ::core::mem::transmute(rgrowstatus)).ok()
    }
    pub unsafe fn RestartPosition(&self, hreserved: usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.RestartPosition)(::windows::core::Vtable::as_raw(self), hreserved).ok()
    }
    pub unsafe fn Compare(&self, hreserved: usize, cbbookmark1: usize, pbookmark1: *const u8, cbbookmark2: usize, pbookmark2: *const u8, pcomparison: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.Compare)(::windows::core::Vtable::as_raw(self), hreserved, cbbookmark1, ::core::mem::transmute(pbookmark1), cbbookmark2, ::core::mem::transmute(pbookmark2), ::core::mem::transmute(pcomparison)).ok()
    }
    pub unsafe fn GetRowsAt(&self, hreserved1: usize, hreserved2: usize, cbbookmark: usize, pbookmark: *const u8, lrowsoffset: isize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetRowsAt)(::windows::core::Vtable::as_raw(self), hreserved1, hreserved2, cbbookmark, ::core::mem::transmute(pbookmark), lrowsoffset, crows, ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
    pub unsafe fn GetRowsByBookmark(&self, hreserved: usize, crows: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghrows: *mut usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetRowsByBookmark)(::windows::core::Vtable::as_raw(self), hreserved, crows, ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    pub unsafe fn Hash(&self, hreserved: usize, cbookmarks: usize, rgcbbookmarks: *const usize, rgpbookmarks: *const *const u8, rghashedvalues: *mut usize, rgbookmarkstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.Hash)(::windows::core::Vtable::as_raw(self), hreserved, cbookmarks, ::core::mem::transmute(rgcbbookmarks), ::core::mem::transmute(rgpbookmarks), ::core::mem::transmute(rghashedvalues), ::core::mem::transmute(rgbookmarkstatus)).ok()
    }
    pub unsafe fn GetApproximatePosition(&self, hreserved: usize, cbbookmark: usize, pbookmark: *const u8, pulposition: *mut usize, pcrows: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetApproximatePosition)(::windows::core::Vtable::as_raw(self), hreserved, cbbookmark, ::core::mem::transmute(pbookmark), ::core::mem::transmute(pulposition), ::core::mem::transmute(pcrows)).ok()
    }
    pub unsafe fn GetRowsAtRatio(&self, hreserved1: usize, hreserved2: usize, ulnumerator: usize, uldenominator: usize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetRowsAtRatio)(::windows::core::Vtable::as_raw(self), hreserved1, hreserved2, ulnumerator, uldenominator, crows, ::core::mem::transmute(pcrowsobtained), ::core::mem::transmute(prghrows)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetScroll, ::windows::core::IUnknown, IRowset, IRowsetLocate);
impl ::core::clone::Clone for IRowsetScroll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetScroll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetScroll {}
impl ::core::fmt::Debug for IRowsetScroll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetScroll").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetScroll {
    type Vtable = IRowsetScroll_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetScroll {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a7e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetScroll_Vtbl {
    pub base__: IRowsetLocate_Vtbl,
    pub GetApproximatePosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, cbbookmark: usize, pbookmark: *const u8, pulposition: *mut usize, pcrows: *mut usize) -> ::windows::core::HRESULT,
    pub GetRowsAtRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved1: usize, hreserved2: usize, ulnumerator: usize, uldenominator: usize, crows: isize, pcrowsobtained: *mut usize, prghrows: *mut *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetUpdate(::windows::core::IUnknown);
impl IRowsetUpdate {
    pub unsafe fn DeleteRows(&self, hreserved: usize, crows: usize, rghrows: *const usize, rgrowstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.DeleteRows)(::windows::core::Vtable::as_raw(self), hreserved, crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(rgrowstatus)).ok()
    }
    pub unsafe fn SetData<'a, P0>(&self, hrow: usize, haccessor: P0, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetData)(::windows::core::Vtable::as_raw(self), hrow, haccessor.into(), ::core::mem::transmute(pdata)).ok()
    }
    pub unsafe fn InsertRow<'a, P0>(&self, hreserved: usize, haccessor: P0, pdata: *mut ::core::ffi::c_void, phrow: *mut usize) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).base__.InsertRow)(::windows::core::Vtable::as_raw(self), hreserved, haccessor.into(), ::core::mem::transmute(pdata), ::core::mem::transmute(phrow)).ok()
    }
    pub unsafe fn GetOriginalData<'a, P0>(&self, hrow: usize, haccessor: P0, pdata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).GetOriginalData)(::windows::core::Vtable::as_raw(self), hrow, haccessor.into(), ::core::mem::transmute(pdata)).ok()
    }
    pub unsafe fn GetPendingRows(&self, hreserved: usize, dwrowstatus: u32, pcpendingrows: *mut usize, prgpendingrows: *mut *mut usize, prgpendingstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetPendingRows)(::windows::core::Vtable::as_raw(self), hreserved, dwrowstatus, ::core::mem::transmute(pcpendingrows), ::core::mem::transmute(prgpendingrows), ::core::mem::transmute(prgpendingstatus)).ok()
    }
    pub unsafe fn GetRowStatus(&self, hreserved: usize, crows: usize, rghrows: *const usize, rgpendingstatus: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetRowStatus)(::windows::core::Vtable::as_raw(self), hreserved, crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(rgpendingstatus)).ok()
    }
    pub unsafe fn Undo(&self, hreserved: usize, crows: usize, rghrows: *const usize, pcrowsundone: *mut usize, prgrowsundone: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Undo)(::windows::core::Vtable::as_raw(self), hreserved, crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(pcrowsundone), ::core::mem::transmute(prgrowsundone), ::core::mem::transmute(prgrowstatus)).ok()
    }
    pub unsafe fn Update(&self, hreserved: usize, crows: usize, rghrows: *const usize, pcrows: *mut usize, prgrows: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Update)(::windows::core::Vtable::as_raw(self), hreserved, crows, ::core::mem::transmute(rghrows), ::core::mem::transmute(pcrows), ::core::mem::transmute(prgrows), ::core::mem::transmute(prgrowstatus)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetUpdate, ::windows::core::IUnknown, IRowsetChange);
impl ::core::clone::Clone for IRowsetUpdate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetUpdate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetUpdate {}
impl ::core::fmt::Debug for IRowsetUpdate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetUpdate").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetUpdate {
    type Vtable = IRowsetUpdate_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetUpdate {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6d_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetUpdate_Vtbl {
    pub base__: IRowsetChange_Vtbl,
    pub GetOriginalData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrow: usize, haccessor: HACCESSOR, pdata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetPendingRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, dwrowstatus: u32, pcpendingrows: *mut usize, prgpendingrows: *mut *mut usize, prgpendingstatus: *mut *mut u32) -> ::windows::core::HRESULT,
    pub GetRowStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, rgpendingstatus: *mut u32) -> ::windows::core::HRESULT,
    pub Undo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, pcrowsundone: *mut usize, prgrowsundone: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
    pub Update: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hreserved: usize, crows: usize, rghrows: *const usize, pcrows: *mut usize, prgrows: *mut *mut usize, prgrowstatus: *mut *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetView(::windows::core::IUnknown);
impl IRowsetView {
    pub unsafe fn CreateView<'a, P0>(&self, punkouter: P0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).CreateView)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn GetView(&self, hchapter: usize, riid: *const ::windows::core::GUID, phchaptersource: *mut usize, ppview: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetView)(::windows::core::Vtable::as_raw(self), hchapter, ::core::mem::transmute(riid), ::core::mem::transmute(phchaptersource), ::core::mem::transmute(ppview)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetView, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetView {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetView {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetView {}
impl ::core::fmt::Debug for IRowsetView {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetView").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetView {
    type Vtable = IRowsetView_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetView {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a99_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetView_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub CreateView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppview: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hchapter: usize, riid: *const ::windows::core::GUID, phchaptersource: *mut usize, ppview: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetWatchAll(::windows::core::IUnknown);
impl IRowsetWatchAll {
    pub unsafe fn Acknowledge(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Acknowledge)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Start(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Start)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn StopWatching(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).StopWatching)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetWatchAll, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetWatchAll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWatchAll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWatchAll {}
impl ::core::fmt::Debug for IRowsetWatchAll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWatchAll").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetWatchAll {
    type Vtable = IRowsetWatchAll_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetWatchAll {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a73_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWatchAll_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Acknowledge: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Start: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub StopWatching: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetWatchNotify(::windows::core::IUnknown);
impl IRowsetWatchNotify {
    pub unsafe fn OnChange<'a, P0>(&self, prowset: P0, echangereason: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IRowset>>,
    {
        (::windows::core::Vtable::vtable(self).OnChange)(::windows::core::Vtable::as_raw(self), prowset.into().abi(), echangereason).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetWatchNotify, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetWatchNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWatchNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWatchNotify {}
impl ::core::fmt::Debug for IRowsetWatchNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWatchNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetWatchNotify {
    type Vtable = IRowsetWatchNotify_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetWatchNotify {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a44_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWatchNotify_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub OnChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prowset: *mut ::core::ffi::c_void, echangereason: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetWatchRegion(::windows::core::IUnknown);
impl IRowsetWatchRegion {
    pub unsafe fn Acknowledge(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.Acknowledge)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Start(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.Start)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn StopWatching(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.StopWatching)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn CreateWatchRegion(&self, dwwatchmode: u32, phregion: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CreateWatchRegion)(::windows::core::Vtable::as_raw(self), dwwatchmode, ::core::mem::transmute(phregion)).ok()
    }
    pub unsafe fn ChangeWatchMode(&self, hregion: usize, dwwatchmode: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ChangeWatchMode)(::windows::core::Vtable::as_raw(self), hregion, dwwatchmode).ok()
    }
    pub unsafe fn DeleteWatchRegion(&self, hregion: usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DeleteWatchRegion)(::windows::core::Vtable::as_raw(self), hregion).ok()
    }
    pub unsafe fn GetWatchRegionInfo(&self, hregion: usize, pdwwatchmode: *mut u32, phchapter: *mut usize, pcbbookmark: *mut usize, ppbookmark: *mut *mut u8, pcrows: *mut isize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetWatchRegionInfo)(::windows::core::Vtable::as_raw(self), hregion, ::core::mem::transmute(pdwwatchmode), ::core::mem::transmute(phchapter), ::core::mem::transmute(pcbbookmark), ::core::mem::transmute(ppbookmark), ::core::mem::transmute(pcrows)).ok()
    }
    pub unsafe fn Refresh(&self, pcchangesobtained: *mut usize, prgchanges: *mut *mut DBROWWATCHCHANGE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Refresh)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcchangesobtained), ::core::mem::transmute(prgchanges)).ok()
    }
    pub unsafe fn ShrinkWatchRegion(&self, hregion: usize, hchapter: usize, cbbookmark: usize, pbookmark: *mut u8, crows: isize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ShrinkWatchRegion)(::windows::core::Vtable::as_raw(self), hregion, hchapter, cbbookmark, ::core::mem::transmute(pbookmark), crows).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetWatchRegion, ::windows::core::IUnknown, IRowsetWatchAll);
impl ::core::clone::Clone for IRowsetWatchRegion {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWatchRegion {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWatchRegion {}
impl ::core::fmt::Debug for IRowsetWatchRegion {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWatchRegion").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetWatchRegion {
    type Vtable = IRowsetWatchRegion_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetWatchRegion {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a45_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWatchRegion_Vtbl {
    pub base__: IRowsetWatchAll_Vtbl,
    pub CreateWatchRegion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwwatchmode: u32, phregion: *mut usize) -> ::windows::core::HRESULT,
    pub ChangeWatchMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize, dwwatchmode: u32) -> ::windows::core::HRESULT,
    pub DeleteWatchRegion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize) -> ::windows::core::HRESULT,
    pub GetWatchRegionInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize, pdwwatchmode: *mut u32, phchapter: *mut usize, pcbbookmark: *mut usize, ppbookmark: *mut *mut u8, pcrows: *mut isize) -> ::windows::core::HRESULT,
    pub Refresh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcchangesobtained: *mut usize, prgchanges: *mut *mut DBROWWATCHCHANGE) -> ::windows::core::HRESULT,
    pub ShrinkWatchRegion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hregion: usize, hchapter: usize, cbbookmark: usize, pbookmark: *mut u8, crows: isize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IRowsetWithParameters(::windows::core::IUnknown);
impl IRowsetWithParameters {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetParameterInfo(&self, pcparams: *mut usize, prgparaminfo: *mut *mut DBPARAMINFO, ppnamesbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetParameterInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcparams), ::core::mem::transmute(prgparaminfo), ::core::mem::transmute(ppnamesbuffer)).ok()
    }
    pub unsafe fn Requery(&self, pparams: *mut DBPARAMS, pulerrorparam: *mut u32, phreserved: *mut usize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Requery)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pparams), ::core::mem::transmute(pulerrorparam), ::core::mem::transmute(phreserved)).ok()
    }
}
::windows::core::interface_hierarchy!(IRowsetWithParameters, ::windows::core::IUnknown);
impl ::core::clone::Clone for IRowsetWithParameters {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IRowsetWithParameters {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IRowsetWithParameters {}
impl ::core::fmt::Debug for IRowsetWithParameters {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRowsetWithParameters").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IRowsetWithParameters {
    type Vtable = IRowsetWithParameters_Vtbl;
}
unsafe impl ::windows::core::Interface for IRowsetWithParameters {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a6e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IRowsetWithParameters_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetParameterInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcparams: *mut usize, prgparaminfo: *mut *mut ::core::mem::ManuallyDrop<DBPARAMINFO>, ppnamesbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetParameterInfo: usize,
    pub Requery: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pparams: *mut DBPARAMS, pulerrorparam: *mut u32, phreserved: *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISQLErrorInfo(::windows::core::IUnknown);
impl ISQLErrorInfo {
    pub unsafe fn GetSQLInfo(&self, pbstrsqlstate: *mut ::windows::core::BSTR, plnativeerror: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetSQLInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pbstrsqlstate), ::core::mem::transmute(plnativeerror)).ok()
    }
}
::windows::core::interface_hierarchy!(ISQLErrorInfo, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISQLErrorInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLErrorInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLErrorInfo {}
impl ::core::fmt::Debug for ISQLErrorInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLErrorInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISQLErrorInfo {
    type Vtable = ISQLErrorInfo_Vtbl;
}
unsafe impl ::windows::core::Interface for ISQLErrorInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a74_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLErrorInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetSQLInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrsqlstate: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>, plnativeerror: *mut i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISQLGetDiagField(::windows::core::IUnknown);
impl ISQLGetDiagField {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDiagField(&self, pdiaginfo: ::core::option::Option<*mut KAGGETDIAG>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetDiagField)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pdiaginfo.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(ISQLGetDiagField, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISQLGetDiagField {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLGetDiagField {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLGetDiagField {}
impl ::core::fmt::Debug for ISQLGetDiagField {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLGetDiagField").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISQLGetDiagField {
    type Vtable = ISQLGetDiagField_Vtbl;
}
unsafe impl ::windows::core::Interface for ISQLGetDiagField {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x228972f1_b5ff_11d0_8a80_00c04fd611cd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLGetDiagField_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetDiagField: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdiaginfo: *mut ::core::mem::ManuallyDrop<KAGGETDIAG>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetDiagField: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISQLRequestDiagFields(::windows::core::IUnknown);
impl ISQLRequestDiagFields {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RequestDiagFields(&self, rgdiagfields: &[KAGREQDIAG]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).RequestDiagFields)(::windows::core::Vtable::as_raw(self), rgdiagfields.len() as _, ::core::mem::transmute(rgdiagfields.as_ptr())).ok()
    }
}
::windows::core::interface_hierarchy!(ISQLRequestDiagFields, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISQLRequestDiagFields {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLRequestDiagFields {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLRequestDiagFields {}
impl ::core::fmt::Debug for ISQLRequestDiagFields {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLRequestDiagFields").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISQLRequestDiagFields {
    type Vtable = ISQLRequestDiagFields_Vtbl;
}
unsafe impl ::windows::core::Interface for ISQLRequestDiagFields {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x228972f0_b5ff_11d0_8a80_00c04fd611cd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLRequestDiagFields_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub RequestDiagFields: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cdiagfields: u32, rgdiagfields: *const KAGREQDIAG) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RequestDiagFields: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISQLServerErrorInfo(::windows::core::IUnknown);
impl ISQLServerErrorInfo {
    pub unsafe fn GetErrorInfo(&self, pperrorinfo: *mut *mut SSERRORINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetErrorInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pperrorinfo), ::core::mem::transmute(ppstringsbuffer)).ok()
    }
}
::windows::core::interface_hierarchy!(ISQLServerErrorInfo, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISQLServerErrorInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISQLServerErrorInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISQLServerErrorInfo {}
impl ::core::fmt::Debug for ISQLServerErrorInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISQLServerErrorInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISQLServerErrorInfo {
    type Vtable = ISQLServerErrorInfo_Vtbl;
}
unsafe impl ::windows::core::Interface for ISQLServerErrorInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca12_ef21_11d0_97e7_00c04fc2ad98);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISQLServerErrorInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetErrorInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pperrorinfo: *mut *mut SSERRORINFO, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISchemaLocalizerSupport(::windows::core::IUnknown);
impl ISchemaLocalizerSupport {
    pub unsafe fn Localize<'a, P0>(&self, pszglobalstring: P0) -> ::windows::core::Result<::windows::core::PWSTR>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Localize)(::windows::core::Vtable::as_raw(self), pszglobalstring.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
}
::windows::core::interface_hierarchy!(ISchemaLocalizerSupport, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISchemaLocalizerSupport {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISchemaLocalizerSupport {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISchemaLocalizerSupport {}
impl ::core::fmt::Debug for ISchemaLocalizerSupport {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISchemaLocalizerSupport").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISchemaLocalizerSupport {
    type Vtable = ISchemaLocalizerSupport_Vtbl;
}
unsafe impl ::windows::core::Interface for ISchemaLocalizerSupport {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xca3fdca2_bfbe_4eed_90d7_0caef0a1bda1);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISchemaLocalizerSupport_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Localize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszglobalstring: ::windows::core::PCWSTR, ppszlocalstring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISchemaLock(::windows::core::IUnknown);
impl ISchemaLock {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub unsafe fn GetSchemaLock(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, lmmode: u32, phlockhandle: *mut super::super::Foundation::HANDLE, ptableversion: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetSchemaLock)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), lmmode, ::core::mem::transmute(phlockhandle), ::core::mem::transmute(ptableversion)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReleaseSchemaLock<'a, P0>(&self, hlockhandle: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HANDLE>,
    {
        (::windows::core::Vtable::vtable(self).ReleaseSchemaLock)(::windows::core::Vtable::as_raw(self), hlockhandle.into()).ok()
    }
}
::windows::core::interface_hierarchy!(ISchemaLock, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISchemaLock {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISchemaLock {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISchemaLock {}
impl ::core::fmt::Debug for ISchemaLock {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISchemaLock").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISchemaLock {
    type Vtable = ISchemaLock_Vtbl;
}
unsafe impl ::windows::core::Interface for ISchemaLock {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4c2389fb_2511_11d4_b258_00c04f7971ce);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISchemaLock_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer"))]
    pub GetSchemaLock: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, lmmode: u32, phlockhandle: *mut super::super::Foundation::HANDLE, ptableversion: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer")))]
    GetSchemaLock: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ReleaseSchemaLock: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hlockhandle: super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ReleaseSchemaLock: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISchemaProvider(::windows::core::IUnknown);
impl ISchemaProvider {
    pub unsafe fn Entities<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).Entities)(::windows::core::Vtable::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn RootEntity(&self) -> ::windows::core::Result<IEntity> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).RootEntity)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEntity>(result__)
    }
    pub unsafe fn GetEntity<'a, P0>(&self, pszentityname: P0) -> ::windows::core::Result<IEntity>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetEntity)(::windows::core::Vtable::as_raw(self), pszentityname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEntity>(result__)
    }
    pub unsafe fn MetaData<T>(&self) -> ::windows::core::Result<T>
    where
        T: ::windows::core::Interface,
    {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Vtable::vtable(self).MetaData)(::windows::core::Vtable::as_raw(self), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn Localize<'a, P0>(&self, lcid: u32, pschemalocalizersupport: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ISchemaLocalizerSupport>>,
    {
        (::windows::core::Vtable::vtable(self).Localize)(::windows::core::Vtable::as_raw(self), lcid, pschemalocalizersupport.into().abi()).ok()
    }
    pub unsafe fn SaveBinary<'a, P0>(&self, pszschemabinarypath: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SaveBinary)(::windows::core::Vtable::as_raw(self), pszschemabinarypath.into()).ok()
    }
    pub unsafe fn LookupAuthoredNamedEntity<'a, P0, P1, P2>(&self, pentity: P0, pszinputstring: P1, ptokencollection: P2, ctokensbegin: u32, pctokenslength: *mut u32, ppszvalue: *mut ::windows::core::PWSTR) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IEntity>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, ITokenCollection>>,
    {
        (::windows::core::Vtable::vtable(self).LookupAuthoredNamedEntity)(::windows::core::Vtable::as_raw(self), pentity.into().abi(), pszinputstring.into(), ptokencollection.into().abi(), ctokensbegin, ::core::mem::transmute(pctokenslength), ::core::mem::transmute(ppszvalue)).ok()
    }
}
::windows::core::interface_hierarchy!(ISchemaProvider, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISchemaProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISchemaProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISchemaProvider {}
impl ::core::fmt::Debug for ISchemaProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISchemaProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISchemaProvider {
    type Vtable = ISchemaProvider_Vtbl;
}
unsafe impl ::windows::core::Interface for ISchemaProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8cf89bcb_394c_49b2_ae28_a59dd4ed7f68);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISchemaProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Entities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pentities: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RootEntity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prootentity: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetEntity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszentityname: ::windows::core::PCWSTR, pentity: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub MetaData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pmetadata: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Localize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lcid: u32, pschemalocalizersupport: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SaveBinary: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszschemabinarypath: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub LookupAuthoredNamedEntity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pentity: *mut ::core::ffi::c_void, pszinputstring: ::windows::core::PCWSTR, ptokencollection: *mut ::core::ffi::c_void, ctokensbegin: u32, pctokenslength: *mut u32, ppszvalue: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IScopedOperations(::windows::core::IUnknown);
impl IScopedOperations {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Bind<'a, P0, P1, P2>(&self, punkouter: P0, pwszurl: P1, dwbindurlflags: u32, rguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, pauthenticate: P2, pimplsession: ::core::option::Option<*mut DBIMPLICITSESSION>, pdwbindstatus: ::core::option::Option<*mut u32>, ppunk: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IAuthenticate>>,
    {
        (::windows::core::Vtable::vtable(self).base__.Bind)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), pwszurl.into(), dwbindurlflags, ::core::mem::transmute(rguid), ::core::mem::transmute(riid), pauthenticate.into().abi(), ::core::mem::transmute(pimplsession.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwbindstatus.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppunk)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Copy<'a, P0>(&self, crows: usize, rgpwszsourceurls: ::core::option::Option<*const ::windows::core::PWSTR>, rgpwszdesturls: *const ::windows::core::PWSTR, dwcopyflags: u32, pauthenticate: P0, rgdwstatus: *mut u32, rgpwsznewurls: ::core::option::Option<*mut ::windows::core::PWSTR>, ppstringsbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IAuthenticate>>,
    {
        (::windows::core::Vtable::vtable(self).Copy)(::windows::core::Vtable::as_raw(self), crows, ::core::mem::transmute(rgpwszsourceurls.unwrap_or(::std::ptr::null())), ::core::mem::transmute(rgpwszdesturls), dwcopyflags, pauthenticate.into().abi(), ::core::mem::transmute(rgdwstatus), ::core::mem::transmute(rgpwsznewurls.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppstringsbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Move<'a, P0>(&self, crows: usize, rgpwszsourceurls: ::core::option::Option<*const ::windows::core::PWSTR>, rgpwszdesturls: *const ::windows::core::PWSTR, dwmoveflags: u32, pauthenticate: P0, rgdwstatus: *mut u32, rgpwsznewurls: ::core::option::Option<*mut ::windows::core::PWSTR>, ppstringsbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::IAuthenticate>>,
    {
        (::windows::core::Vtable::vtable(self).Move)(::windows::core::Vtable::as_raw(self), crows, ::core::mem::transmute(rgpwszsourceurls.unwrap_or(::std::ptr::null())), ::core::mem::transmute(rgpwszdesturls), dwmoveflags, pauthenticate.into().abi(), ::core::mem::transmute(rgdwstatus), ::core::mem::transmute(rgpwsznewurls.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppstringsbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Delete(&self, crows: usize, rgpwszurls: *const ::windows::core::PWSTR, dwdeleteflags: u32) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Delete)(::windows::core::Vtable::as_raw(self), crows, ::core::mem::transmute(rgpwszurls), dwdeleteflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OpenRowset<'a, P0>(&self, punkouter: P0, ptableid: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>, pindexid: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>, riid: *const ::windows::core::GUID, rgpropertysets: &mut [DBPROPSET], pprowset: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).OpenRowset)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(ptableid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pindexid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(riid), rgpropertysets.len() as _, ::core::mem::transmute(rgpropertysets.as_ptr()), ::core::mem::transmute(pprowset.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(IScopedOperations, ::windows::core::IUnknown, IBindResource);
impl ::core::clone::Clone for IScopedOperations {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IScopedOperations {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IScopedOperations {}
impl ::core::fmt::Debug for IScopedOperations {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IScopedOperations").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IScopedOperations {
    type Vtable = IScopedOperations_Vtbl;
}
unsafe impl ::windows::core::Interface for IScopedOperations {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733ab0_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IScopedOperations_Vtbl {
    pub base__: IBindResource_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Copy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rgpwszsourceurls: *const ::windows::core::PWSTR, rgpwszdesturls: *const ::windows::core::PWSTR, dwcopyflags: u32, pauthenticate: *mut ::core::ffi::c_void, rgdwstatus: *mut u32, rgpwsznewurls: *mut ::windows::core::PWSTR, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Copy: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Move: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rgpwszsourceurls: *const ::windows::core::PWSTR, rgpwszdesturls: *const ::windows::core::PWSTR, dwmoveflags: u32, pauthenticate: *mut ::core::ffi::c_void, rgdwstatus: *mut u32, rgpwsznewurls: *mut ::windows::core::PWSTR, ppstringsbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Move: usize,
    pub Delete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crows: usize, rgpwszurls: *const ::windows::core::PWSTR, dwdeleteflags: u32, rgdwstatus: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub OpenRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pindexid: *const super::super::Storage::IndexServer::DBID, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    OpenRowset: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchCatalogManager(::windows::core::IUnknown);
impl ISearchCatalogManager {
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Name)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetParameter<'a, P0>(&self, pszname: P0) -> ::windows::core::Result<*mut super::Com::StructuredStorage::PROPVARIANT>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetParameter)(::windows::core::Vtable::as_raw(self), pszname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetParameter<'a, P0>(&self, pszname: P0, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetParameter)(::windows::core::Vtable::as_raw(self), pszname.into(), ::core::mem::transmute(pvalue)).ok()
    }
    pub unsafe fn GetCatalogStatus(&self, pstatus: *mut CatalogStatus, ppausedreason: *mut CatalogPausedReason) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCatalogStatus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pstatus), ::core::mem::transmute(ppausedreason)).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Reset)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Reindex(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Reindex)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn ReindexMatchingURLs<'a, P0>(&self, pszpattern: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).ReindexMatchingURLs)(::windows::core::Vtable::as_raw(self), pszpattern.into()).ok()
    }
    pub unsafe fn ReindexSearchRoot<'a, P0>(&self, pszrooturl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).ReindexSearchRoot)(::windows::core::Vtable::as_raw(self), pszrooturl.into()).ok()
    }
    pub unsafe fn SetConnectTimeout(&self, dwconnecttimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetConnectTimeout)(::windows::core::Vtable::as_raw(self), dwconnecttimeout).ok()
    }
    pub unsafe fn ConnectTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ConnectTimeout)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn SetDataTimeout(&self, dwdatatimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetDataTimeout)(::windows::core::Vtable::as_raw(self), dwdatatimeout).ok()
    }
    pub unsafe fn DataTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).DataTimeout)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn NumberOfItems(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).NumberOfItems)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn NumberOfItemsToIndex(&self, plincrementalcount: *mut i32, plnotificationqueue: *mut i32, plhighpriorityqueue: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).NumberOfItemsToIndex)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(plincrementalcount), ::core::mem::transmute(plnotificationqueue), ::core::mem::transmute(plhighpriorityqueue)).ok()
    }
    pub unsafe fn URLBeingIndexed(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).URLBeingIndexed)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetURLIndexingState<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetURLIndexingState)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetPersistentItemsChangedSink(&self) -> ::windows::core::Result<ISearchPersistentItemsChangedSink> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetPersistentItemsChangedSink)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISearchPersistentItemsChangedSink>(result__)
    }
    pub unsafe fn RegisterViewForNotification<'a, P0, P1>(&self, pszview: P0, pviewchangedsink: P1) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ISearchViewChangedSink>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).RegisterViewForNotification)(::windows::core::Vtable::as_raw(self), pszview.into(), pviewchangedsink.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetItemsChangedSink<'a, P0>(&self, pisearchnotifyinlinesite: P0, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, pguidcatalogresetsignature: *mut ::windows::core::GUID, pguidcheckpointsignature: *mut ::windows::core::GUID, pdwlastcheckpointnumber: *mut u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ISearchNotifyInlineSite>>,
    {
        (::windows::core::Vtable::vtable(self).GetItemsChangedSink)(::windows::core::Vtable::as_raw(self), pisearchnotifyinlinesite.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppv), ::core::mem::transmute(pguidcatalogresetsignature), ::core::mem::transmute(pguidcheckpointsignature), ::core::mem::transmute(pdwlastcheckpointnumber)).ok()
    }
    pub unsafe fn UnregisterViewForNotification(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).UnregisterViewForNotification)(::windows::core::Vtable::as_raw(self), dwcookie).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetExtensionClusion<'a, P0, P1>(&self, pszextension: P0, fexclude: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetExtensionClusion)(::windows::core::Vtable::as_raw(self), pszextension.into(), fexclude.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumerateExcludedExtensions(&self) -> ::windows::core::Result<super::Com::IEnumString> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).EnumerateExcludedExtensions)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::IEnumString>(result__)
    }
    pub unsafe fn GetQueryHelper(&self) -> ::windows::core::Result<ISearchQueryHelper> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetQueryHelper)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISearchQueryHelper>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiacriticSensitivity<'a, P0>(&self, fdiacriticsensitive: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetDiacriticSensitivity)(::windows::core::Vtable::as_raw(self), fdiacriticsensitive.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DiacriticSensitivity(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).DiacriticSensitivity)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetCrawlScopeManager(&self) -> ::windows::core::Result<ISearchCrawlScopeManager> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCrawlScopeManager)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISearchCrawlScopeManager>(result__)
    }
}
::windows::core::interface_hierarchy!(ISearchCatalogManager, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchCatalogManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchCatalogManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchCatalogManager {}
impl ::core::fmt::Debug for ISearchCatalogManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchCatalogManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchCatalogManager {
    type Vtable = ISearchCatalogManager_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchCatalogManager {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef50);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchCatalogManager_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub GetParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR, ppvalue: *mut *mut ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    GetParameter: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub SetParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR, pvalue: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    SetParameter: usize,
    pub GetCatalogStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstatus: *mut CatalogStatus, ppausedreason: *mut CatalogPausedReason) -> ::windows::core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Reindex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ReindexMatchingURLs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpattern: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub ReindexSearchRoot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszrooturl: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub SetConnectTimeout: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwconnecttimeout: u32) -> ::windows::core::HRESULT,
    pub ConnectTimeout: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwconnecttimeout: *mut u32) -> ::windows::core::HRESULT,
    pub SetDataTimeout: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwdatatimeout: u32) -> ::windows::core::HRESULT,
    pub DataTimeout: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwdatatimeout: *mut u32) -> ::windows::core::HRESULT,
    pub NumberOfItems: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    pub NumberOfItemsToIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plincrementalcount: *mut i32, plnotificationqueue: *mut i32, plhighpriorityqueue: *mut i32) -> ::windows::core::HRESULT,
    pub URLBeingIndexed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetURLIndexingState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR, pdwstate: *mut u32) -> ::windows::core::HRESULT,
    pub GetPersistentItemsChangedSink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppisearchpersistentitemschangedsink: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RegisterViewForNotification: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszview: ::windows::core::PCWSTR, pviewchangedsink: *mut ::core::ffi::c_void, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub GetItemsChangedSink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pisearchnotifyinlinesite: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, pguidcatalogresetsignature: *mut ::windows::core::GUID, pguidcheckpointsignature: *mut ::windows::core::GUID, pdwlastcheckpointnumber: *mut u32) -> ::windows::core::HRESULT,
    pub UnregisterViewForNotification: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetExtensionClusion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszextension: ::windows::core::PCWSTR, fexclude: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetExtensionClusion: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EnumerateExcludedExtensions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppextensions: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EnumerateExcludedExtensions: usize,
    pub GetQueryHelper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsearchqueryhelper: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDiacriticSensitivity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdiacriticsensitive: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDiacriticSensitivity: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub DiacriticSensitivity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfdiacriticsensitive: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DiacriticSensitivity: usize,
    pub GetCrawlScopeManager: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppcrawlscopemanager: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchCatalogManager2(::windows::core::IUnknown);
impl ISearchCatalogManager2 {
    pub unsafe fn Name(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.Name)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetParameter<'a, P0>(&self, pszname: P0) -> ::windows::core::Result<*mut super::Com::StructuredStorage::PROPVARIANT>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetParameter)(::windows::core::Vtable::as_raw(self), pszname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetParameter<'a, P0>(&self, pszname: P0, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetParameter)(::windows::core::Vtable::as_raw(self), pszname.into(), ::core::mem::transmute(pvalue)).ok()
    }
    pub unsafe fn GetCatalogStatus(&self, pstatus: *mut CatalogStatus, ppausedreason: *mut CatalogPausedReason) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetCatalogStatus)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pstatus), ::core::mem::transmute(ppausedreason)).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.Reset)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn Reindex(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.Reindex)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn ReindexMatchingURLs<'a, P0>(&self, pszpattern: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.ReindexMatchingURLs)(::windows::core::Vtable::as_raw(self), pszpattern.into()).ok()
    }
    pub unsafe fn ReindexSearchRoot<'a, P0>(&self, pszrooturl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.ReindexSearchRoot)(::windows::core::Vtable::as_raw(self), pszrooturl.into()).ok()
    }
    pub unsafe fn SetConnectTimeout(&self, dwconnecttimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetConnectTimeout)(::windows::core::Vtable::as_raw(self), dwconnecttimeout).ok()
    }
    pub unsafe fn ConnectTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.ConnectTimeout)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn SetDataTimeout(&self, dwdatatimeout: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SetDataTimeout)(::windows::core::Vtable::as_raw(self), dwdatatimeout).ok()
    }
    pub unsafe fn DataTimeout(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.DataTimeout)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn NumberOfItems(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.NumberOfItems)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn NumberOfItemsToIndex(&self, plincrementalcount: *mut i32, plnotificationqueue: *mut i32, plhighpriorityqueue: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.NumberOfItemsToIndex)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(plincrementalcount), ::core::mem::transmute(plnotificationqueue), ::core::mem::transmute(plhighpriorityqueue)).ok()
    }
    pub unsafe fn URLBeingIndexed(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.URLBeingIndexed)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetURLIndexingState<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetURLIndexingState)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetPersistentItemsChangedSink(&self) -> ::windows::core::Result<ISearchPersistentItemsChangedSink> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetPersistentItemsChangedSink)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISearchPersistentItemsChangedSink>(result__)
    }
    pub unsafe fn RegisterViewForNotification<'a, P0, P1>(&self, pszview: P0, pviewchangedsink: P1) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, ISearchViewChangedSink>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.RegisterViewForNotification)(::windows::core::Vtable::as_raw(self), pszview.into(), pviewchangedsink.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn GetItemsChangedSink<'a, P0>(&self, pisearchnotifyinlinesite: P0, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void, pguidcatalogresetsignature: *mut ::windows::core::GUID, pguidcheckpointsignature: *mut ::windows::core::GUID, pdwlastcheckpointnumber: *mut u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ISearchNotifyInlineSite>>,
    {
        (::windows::core::Vtable::vtable(self).base__.GetItemsChangedSink)(::windows::core::Vtable::as_raw(self), pisearchnotifyinlinesite.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppv), ::core::mem::transmute(pguidcatalogresetsignature), ::core::mem::transmute(pguidcheckpointsignature), ::core::mem::transmute(pdwlastcheckpointnumber)).ok()
    }
    pub unsafe fn UnregisterViewForNotification(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.UnregisterViewForNotification)(::windows::core::Vtable::as_raw(self), dwcookie).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetExtensionClusion<'a, P0, P1>(&self, pszextension: P0, fexclude: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetExtensionClusion)(::windows::core::Vtable::as_raw(self), pszextension.into(), fexclude.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumerateExcludedExtensions(&self) -> ::windows::core::Result<super::Com::IEnumString> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.EnumerateExcludedExtensions)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::IEnumString>(result__)
    }
    pub unsafe fn GetQueryHelper(&self) -> ::windows::core::Result<ISearchQueryHelper> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetQueryHelper)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISearchQueryHelper>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiacriticSensitivity<'a, P0>(&self, fdiacriticsensitive: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetDiacriticSensitivity)(::windows::core::Vtable::as_raw(self), fdiacriticsensitive.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DiacriticSensitivity(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.DiacriticSensitivity)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetCrawlScopeManager(&self) -> ::windows::core::Result<ISearchCrawlScopeManager> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetCrawlScopeManager)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISearchCrawlScopeManager>(result__)
    }
    pub unsafe fn PrioritizeMatchingURLs<'a, P0>(&self, pszpattern: P0, dwprioritizeflags: PRIORITIZE_FLAGS) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).PrioritizeMatchingURLs)(::windows::core::Vtable::as_raw(self), pszpattern.into(), dwprioritizeflags).ok()
    }
}
::windows::core::interface_hierarchy!(ISearchCatalogManager2, ::windows::core::IUnknown, ISearchCatalogManager);
impl ::core::clone::Clone for ISearchCatalogManager2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchCatalogManager2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchCatalogManager2 {}
impl ::core::fmt::Debug for ISearchCatalogManager2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchCatalogManager2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchCatalogManager2 {
    type Vtable = ISearchCatalogManager2_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchCatalogManager2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7ac3286d_4d1d_4817_84fc_c1c85e3af0d9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchCatalogManager2_Vtbl {
    pub base__: ISearchCatalogManager_Vtbl,
    pub PrioritizeMatchingURLs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpattern: ::windows::core::PCWSTR, dwprioritizeflags: PRIORITIZE_FLAGS) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchCrawlScopeManager(::windows::core::IUnknown);
impl ISearchCrawlScopeManager {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddDefaultScopeRule<'a, P0, P1>(&self, pszurl: P0, finclude: P1, ffollowflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).AddDefaultScopeRule)(::windows::core::Vtable::as_raw(self), pszurl.into(), finclude.into(), ffollowflags).ok()
    }
    pub unsafe fn AddRoot<'a, P0>(&self, psearchroot: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ISearchRoot>>,
    {
        (::windows::core::Vtable::vtable(self).AddRoot)(::windows::core::Vtable::as_raw(self), psearchroot.into().abi()).ok()
    }
    pub unsafe fn RemoveRoot<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).RemoveRoot)(::windows::core::Vtable::as_raw(self), pszurl.into()).ok()
    }
    pub unsafe fn EnumerateRoots(&self) -> ::windows::core::Result<IEnumSearchRoots> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).EnumerateRoots)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumSearchRoots>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddHierarchicalScope<'a, P0, P1, P2, P3>(&self, pszurl: P0, finclude: P1, fdefault: P2, foverridechildren: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<super::super::Foundation::BOOL>,
        P3: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).AddHierarchicalScope)(::windows::core::Vtable::as_raw(self), pszurl.into(), finclude.into(), fdefault.into(), foverridechildren.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddUserScopeRule<'a, P0, P1, P2>(&self, pszurl: P0, finclude: P1, foverridechildren: P2, ffollowflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).AddUserScopeRule)(::windows::core::Vtable::as_raw(self), pszurl.into(), finclude.into(), foverridechildren.into(), ffollowflags).ok()
    }
    pub unsafe fn RemoveScopeRule<'a, P0>(&self, pszrule: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).RemoveScopeRule)(::windows::core::Vtable::as_raw(self), pszrule.into()).ok()
    }
    pub unsafe fn EnumerateScopeRules(&self) -> ::windows::core::Result<IEnumSearchScopeRules> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).EnumerateScopeRules)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumSearchScopeRules>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasParentScopeRule<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).HasParentScopeRule)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasChildScopeRule<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).HasChildScopeRule)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IncludedInCrawlScope<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IncludedInCrawlScope)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IncludedInCrawlScopeEx<'a, P0>(&self, pszurl: P0, pfisincluded: *mut super::super::Foundation::BOOL, preason: *mut CLUSION_REASON) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).IncludedInCrawlScopeEx)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(pfisincluded), ::core::mem::transmute(preason)).ok()
    }
    pub unsafe fn RevertToDefaultScopes(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).RevertToDefaultScopes)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn SaveAll(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SaveAll)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetParentScopeVersionId<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetParentScopeVersionId)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn RemoveDefaultScopeRule<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).RemoveDefaultScopeRule)(::windows::core::Vtable::as_raw(self), pszurl.into()).ok()
    }
}
::windows::core::interface_hierarchy!(ISearchCrawlScopeManager, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchCrawlScopeManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchCrawlScopeManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchCrawlScopeManager {}
impl ::core::fmt::Debug for ISearchCrawlScopeManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchCrawlScopeManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchCrawlScopeManager {
    type Vtable = ISearchCrawlScopeManager_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchCrawlScopeManager {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef55);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchCrawlScopeManager_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub AddDefaultScopeRule: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR, finclude: super::super::Foundation::BOOL, ffollowflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AddDefaultScopeRule: usize,
    pub AddRoot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psearchroot: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RemoveRoot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub EnumerateRoots: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsearchroots: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub AddHierarchicalScope: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR, finclude: super::super::Foundation::BOOL, fdefault: super::super::Foundation::BOOL, foverridechildren: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AddHierarchicalScope: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub AddUserScopeRule: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR, finclude: super::super::Foundation::BOOL, foverridechildren: super::super::Foundation::BOOL, ffollowflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AddUserScopeRule: usize,
    pub RemoveScopeRule: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszrule: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub EnumerateScopeRules: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsearchscoperules: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub HasParentScopeRule: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR, pfhasparentrule: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HasParentScopeRule: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub HasChildScopeRule: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR, pfhaschildrule: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HasChildScopeRule: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IncludedInCrawlScope: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR, pfisincluded: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IncludedInCrawlScope: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IncludedInCrawlScopeEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR, pfisincluded: *mut super::super::Foundation::BOOL, preason: *mut CLUSION_REASON) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IncludedInCrawlScopeEx: usize,
    pub RevertToDefaultScopes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SaveAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetParentScopeVersionId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR, plscopeid: *mut i32) -> ::windows::core::HRESULT,
    pub RemoveDefaultScopeRule: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchCrawlScopeManager2(::windows::core::IUnknown);
impl ISearchCrawlScopeManager2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddDefaultScopeRule<'a, P0, P1>(&self, pszurl: P0, finclude: P1, ffollowflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.AddDefaultScopeRule)(::windows::core::Vtable::as_raw(self), pszurl.into(), finclude.into(), ffollowflags).ok()
    }
    pub unsafe fn AddRoot<'a, P0>(&self, psearchroot: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ISearchRoot>>,
    {
        (::windows::core::Vtable::vtable(self).base__.AddRoot)(::windows::core::Vtable::as_raw(self), psearchroot.into().abi()).ok()
    }
    pub unsafe fn RemoveRoot<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.RemoveRoot)(::windows::core::Vtable::as_raw(self), pszurl.into()).ok()
    }
    pub unsafe fn EnumerateRoots(&self) -> ::windows::core::Result<IEnumSearchRoots> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.EnumerateRoots)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumSearchRoots>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddHierarchicalScope<'a, P0, P1, P2, P3>(&self, pszurl: P0, finclude: P1, fdefault: P2, foverridechildren: P3) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<super::super::Foundation::BOOL>,
        P3: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.AddHierarchicalScope)(::windows::core::Vtable::as_raw(self), pszurl.into(), finclude.into(), fdefault.into(), foverridechildren.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AddUserScopeRule<'a, P0, P1, P2>(&self, pszurl: P0, finclude: P1, foverridechildren: P2, ffollowflags: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
        P2: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.AddUserScopeRule)(::windows::core::Vtable::as_raw(self), pszurl.into(), finclude.into(), foverridechildren.into(), ffollowflags).ok()
    }
    pub unsafe fn RemoveScopeRule<'a, P0>(&self, pszrule: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.RemoveScopeRule)(::windows::core::Vtable::as_raw(self), pszrule.into()).ok()
    }
    pub unsafe fn EnumerateScopeRules(&self) -> ::windows::core::Result<IEnumSearchScopeRules> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.EnumerateScopeRules)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumSearchScopeRules>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasParentScopeRule<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.HasParentScopeRule)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasChildScopeRule<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.HasChildScopeRule)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IncludedInCrawlScope<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.IncludedInCrawlScope)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IncludedInCrawlScopeEx<'a, P0>(&self, pszurl: P0, pfisincluded: *mut super::super::Foundation::BOOL, preason: *mut CLUSION_REASON) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.IncludedInCrawlScopeEx)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(pfisincluded), ::core::mem::transmute(preason)).ok()
    }
    pub unsafe fn RevertToDefaultScopes(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.RevertToDefaultScopes)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn SaveAll(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.SaveAll)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetParentScopeVersionId<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<i32>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetParentScopeVersionId)(::windows::core::Vtable::as_raw(self), pszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
    pub unsafe fn RemoveDefaultScopeRule<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.RemoveDefaultScopeRule)(::windows::core::Vtable::as_raw(self), pszurl.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetVersion(&self, plversion: *mut *mut i32, phfilemapping: *mut super::super::Foundation::HANDLE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetVersion)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(plversion), ::core::mem::transmute(phfilemapping)).ok()
    }
}
::windows::core::interface_hierarchy!(ISearchCrawlScopeManager2, ::windows::core::IUnknown, ISearchCrawlScopeManager);
impl ::core::clone::Clone for ISearchCrawlScopeManager2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchCrawlScopeManager2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchCrawlScopeManager2 {}
impl ::core::fmt::Debug for ISearchCrawlScopeManager2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchCrawlScopeManager2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchCrawlScopeManager2 {
    type Vtable = ISearchCrawlScopeManager2_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchCrawlScopeManager2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6292f7ad_4e19_4717_a534_8fc22bcd5ccd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchCrawlScopeManager2_Vtbl {
    pub base__: ISearchCrawlScopeManager_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetVersion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plversion: *mut *mut i32, phfilemapping: *mut super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetVersion: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchItemsChangedSink(::windows::core::IUnknown);
impl ISearchItemsChangedSink {
    pub unsafe fn StartedMonitoringScope<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).StartedMonitoringScope)(::windows::core::Vtable::as_raw(self), pszurl.into()).ok()
    }
    pub unsafe fn StoppedMonitoringScope<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).StoppedMonitoringScope)(::windows::core::Vtable::as_raw(self), pszurl.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OnItemsChanged(&self, dwnumberofchanges: u32, rgdatachangeentries: *const SEARCH_ITEM_CHANGE, rgdwdocids: *mut u32, rghrcompletioncodes: *mut ::windows::core::HRESULT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnItemsChanged)(::windows::core::Vtable::as_raw(self), dwnumberofchanges, ::core::mem::transmute(rgdatachangeentries), ::core::mem::transmute(rgdwdocids), ::core::mem::transmute(rghrcompletioncodes)).ok()
    }
}
::windows::core::interface_hierarchy!(ISearchItemsChangedSink, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchItemsChangedSink {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchItemsChangedSink {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchItemsChangedSink {}
impl ::core::fmt::Debug for ISearchItemsChangedSink {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchItemsChangedSink").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchItemsChangedSink {
    type Vtable = ISearchItemsChangedSink_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchItemsChangedSink {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef58);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchItemsChangedSink_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub StartedMonitoringScope: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub StoppedMonitoringScope: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub OnItemsChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwnumberofchanges: u32, rgdatachangeentries: *const SEARCH_ITEM_CHANGE, rgdwdocids: *mut u32, rghrcompletioncodes: *mut ::windows::core::HRESULT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OnItemsChanged: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchLanguageSupport(::windows::core::IUnknown);
impl ISearchLanguageSupport {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiacriticSensitivity<'a, P0>(&self, fdiacriticsensitive: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetDiacriticSensitivity)(::windows::core::Vtable::as_raw(self), fdiacriticsensitive.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDiacriticSensitivity(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetDiacriticSensitivity)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn LoadWordBreaker(&self, lcid: u32, riid: *const ::windows::core::GUID, ppwordbreaker: *mut *mut ::core::ffi::c_void, plcidused: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).LoadWordBreaker)(::windows::core::Vtable::as_raw(self), lcid, ::core::mem::transmute(riid), ::core::mem::transmute(ppwordbreaker), ::core::mem::transmute(plcidused)).ok()
    }
    pub unsafe fn LoadStemmer(&self, lcid: u32, riid: *const ::windows::core::GUID, ppstemmer: *mut *mut ::core::ffi::c_void, plcidused: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).LoadStemmer)(::windows::core::Vtable::as_raw(self), lcid, ::core::mem::transmute(riid), ::core::mem::transmute(ppstemmer), ::core::mem::transmute(plcidused)).ok()
    }
    pub unsafe fn IsPrefixNormalized(&self, pwcsquerytoken: &[u16], pwcsdocumenttoken: &[u16]) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsPrefixNormalized)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pwcsquerytoken.as_ptr()), pwcsquerytoken.len() as _, ::core::mem::transmute(pwcsdocumenttoken.as_ptr()), pwcsdocumenttoken.len() as _, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(ISearchLanguageSupport, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchLanguageSupport {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchLanguageSupport {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchLanguageSupport {}
impl ::core::fmt::Debug for ISearchLanguageSupport {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchLanguageSupport").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchLanguageSupport {
    type Vtable = ISearchLanguageSupport_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchLanguageSupport {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x24c3cbaa_ebc1_491a_9ef1_9f6d8deb1b8f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchLanguageSupport_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDiacriticSensitivity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fdiacriticsensitive: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDiacriticSensitivity: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetDiacriticSensitivity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfdiacriticsensitive: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetDiacriticSensitivity: usize,
    pub LoadWordBreaker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lcid: u32, riid: *const ::windows::core::GUID, ppwordbreaker: *mut *mut ::core::ffi::c_void, plcidused: *mut u32) -> ::windows::core::HRESULT,
    pub LoadStemmer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lcid: u32, riid: *const ::windows::core::GUID, ppstemmer: *mut *mut ::core::ffi::c_void, plcidused: *mut u32) -> ::windows::core::HRESULT,
    pub IsPrefixNormalized: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwcsquerytoken: ::windows::core::PCWSTR, cwcquerytoken: u32, pwcsdocumenttoken: ::windows::core::PCWSTR, cwcdocumenttoken: u32, pulprefixlength: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchManager(::windows::core::IUnknown);
impl ISearchManager {
    pub unsafe fn GetIndexerVersionStr(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetIndexerVersionStr)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetIndexerVersion(&self, pdwmajor: *mut u32, pdwminor: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetIndexerVersion)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pdwmajor), ::core::mem::transmute(pdwminor)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetParameter<'a, P0>(&self, pszname: P0) -> ::windows::core::Result<*mut super::Com::StructuredStorage::PROPVARIANT>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetParameter)(::windows::core::Vtable::as_raw(self), pszname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetParameter<'a, P0>(&self, pszname: P0, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetParameter)(::windows::core::Vtable::as_raw(self), pszname.into(), ::core::mem::transmute(pvalue)).ok()
    }
    pub unsafe fn ProxyName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ProxyName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn BypassList(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).BypassList)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetProxy<'a, P0, P1, P2>(&self, suseproxy: PROXY_ACCESS, flocalbypassproxy: P0, dwportnumber: u32, pszproxyname: P1, pszbypasslist: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetProxy)(::windows::core::Vtable::as_raw(self), suseproxy, flocalbypassproxy.into(), dwportnumber, pszproxyname.into(), pszbypasslist.into()).ok()
    }
    pub unsafe fn GetCatalog<'a, P0>(&self, pszcatalog: P0) -> ::windows::core::Result<ISearchCatalogManager>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCatalog)(::windows::core::Vtable::as_raw(self), pszcatalog.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISearchCatalogManager>(result__)
    }
    pub unsafe fn UserAgent(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).UserAgent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetUserAgent<'a, P0>(&self, pszuseragent: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetUserAgent)(::windows::core::Vtable::as_raw(self), pszuseragent.into()).ok()
    }
    pub unsafe fn UseProxy(&self) -> ::windows::core::Result<PROXY_ACCESS> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).UseProxy)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<PROXY_ACCESS>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LocalBypass(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).LocalBypass)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn PortNumber(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).PortNumber)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(ISearchManager, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchManager {}
impl ::core::fmt::Debug for ISearchManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchManager {
    type Vtable = ISearchManager_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchManager {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef69);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchManager_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetIndexerVersionStr: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszversionstring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GetIndexerVersion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmajor: *mut u32, pdwminor: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub GetParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR, ppvalue: *mut *mut ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    GetParameter: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub SetParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: ::windows::core::PCWSTR, pvalue: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    SetParameter: usize,
    pub ProxyName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszproxyname: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub BypassList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszbypasslist: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetProxy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, suseproxy: PROXY_ACCESS, flocalbypassproxy: super::super::Foundation::BOOL, dwportnumber: u32, pszproxyname: ::windows::core::PCWSTR, pszbypasslist: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetProxy: usize,
    pub GetCatalog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcatalog: ::windows::core::PCWSTR, ppcatalogmanager: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UserAgent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszuseragent: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetUserAgent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszuseragent: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub UseProxy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puseproxy: *mut PROXY_ACCESS) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub LocalBypass: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pflocalbypass: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    LocalBypass: usize,
    pub PortNumber: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwportnumber: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchManager2(::windows::core::IUnknown);
impl ISearchManager2 {
    pub unsafe fn GetIndexerVersionStr(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetIndexerVersionStr)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GetIndexerVersion(&self, pdwmajor: *mut u32, pdwminor: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetIndexerVersion)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pdwmajor), ::core::mem::transmute(pdwminor)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn GetParameter<'a, P0>(&self, pszname: P0) -> ::windows::core::Result<*mut super::Com::StructuredStorage::PROPVARIANT>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetParameter)(::windows::core::Vtable::as_raw(self), pszname.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut super::Com::StructuredStorage::PROPVARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn SetParameter<'a, P0>(&self, pszname: P0, pvalue: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetParameter)(::windows::core::Vtable::as_raw(self), pszname.into(), ::core::mem::transmute(pvalue)).ok()
    }
    pub unsafe fn ProxyName(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.ProxyName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn BypassList(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.BypassList)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetProxy<'a, P0, P1, P2>(&self, suseproxy: PROXY_ACCESS, flocalbypassproxy: P0, dwportnumber: u32, pszproxyname: P1, pszbypasslist: P2) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetProxy)(::windows::core::Vtable::as_raw(self), suseproxy, flocalbypassproxy.into(), dwportnumber, pszproxyname.into(), pszbypasslist.into()).ok()
    }
    pub unsafe fn GetCatalog<'a, P0>(&self, pszcatalog: P0) -> ::windows::core::Result<ISearchCatalogManager>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetCatalog)(::windows::core::Vtable::as_raw(self), pszcatalog.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISearchCatalogManager>(result__)
    }
    pub unsafe fn UserAgent(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.UserAgent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetUserAgent<'a, P0>(&self, pszuseragent: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.SetUserAgent)(::windows::core::Vtable::as_raw(self), pszuseragent.into()).ok()
    }
    pub unsafe fn UseProxy(&self) -> ::windows::core::Result<PROXY_ACCESS> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.UseProxy)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<PROXY_ACCESS>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LocalBypass(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.LocalBypass)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn PortNumber(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.PortNumber)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn CreateCatalog<'a, P0>(&self, pszcatalog: P0) -> ::windows::core::Result<ISearchCatalogManager>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).CreateCatalog)(::windows::core::Vtable::as_raw(self), pszcatalog.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISearchCatalogManager>(result__)
    }
    pub unsafe fn DeleteCatalog<'a, P0>(&self, pszcatalog: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).DeleteCatalog)(::windows::core::Vtable::as_raw(self), pszcatalog.into()).ok()
    }
}
::windows::core::interface_hierarchy!(ISearchManager2, ::windows::core::IUnknown, ISearchManager);
impl ::core::clone::Clone for ISearchManager2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchManager2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchManager2 {}
impl ::core::fmt::Debug for ISearchManager2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchManager2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchManager2 {
    type Vtable = ISearchManager2_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchManager2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdbab3f73_db19_4a79_bfc0_a61a93886ddf);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchManager2_Vtbl {
    pub base__: ISearchManager_Vtbl,
    pub CreateCatalog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcatalog: ::windows::core::PCWSTR, ppcatalogmanager: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub DeleteCatalog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcatalog: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchNotifyInlineSite(::windows::core::IUnknown);
impl ISearchNotifyInlineSite {
    pub unsafe fn OnItemIndexedStatusChange(&self, sipstatus: SEARCH_INDEXING_PHASE, rgitemstatusentries: &[SEARCH_ITEM_INDEXING_STATUS]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnItemIndexedStatusChange)(::windows::core::Vtable::as_raw(self), sipstatus, rgitemstatusentries.len() as _, ::core::mem::transmute(rgitemstatusentries.as_ptr())).ok()
    }
    pub unsafe fn OnCatalogStatusChange(&self, guidcatalogresetsignature: *const ::windows::core::GUID, guidcheckpointsignature: *const ::windows::core::GUID, dwlastcheckpointnumber: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnCatalogStatusChange)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(guidcatalogresetsignature), ::core::mem::transmute(guidcheckpointsignature), dwlastcheckpointnumber).ok()
    }
}
::windows::core::interface_hierarchy!(ISearchNotifyInlineSite, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchNotifyInlineSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchNotifyInlineSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchNotifyInlineSite {}
impl ::core::fmt::Debug for ISearchNotifyInlineSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchNotifyInlineSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchNotifyInlineSite {
    type Vtable = ISearchNotifyInlineSite_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchNotifyInlineSite {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb5702e61_e75c_4b64_82a1_6cb4f832fccf);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchNotifyInlineSite_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub OnItemIndexedStatusChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sipstatus: SEARCH_INDEXING_PHASE, dwnumentries: u32, rgitemstatusentries: *const SEARCH_ITEM_INDEXING_STATUS) -> ::windows::core::HRESULT,
    pub OnCatalogStatusChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guidcatalogresetsignature: *const ::windows::core::GUID, guidcheckpointsignature: *const ::windows::core::GUID, dwlastcheckpointnumber: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchPersistentItemsChangedSink(::windows::core::IUnknown);
impl ISearchPersistentItemsChangedSink {
    pub unsafe fn StartedMonitoringScope<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).StartedMonitoringScope)(::windows::core::Vtable::as_raw(self), pszurl.into()).ok()
    }
    pub unsafe fn StoppedMonitoringScope<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).StoppedMonitoringScope)(::windows::core::Vtable::as_raw(self), pszurl.into()).ok()
    }
    pub unsafe fn OnItemsChanged(&self, dwnumberofchanges: u32, datachangeentries: *const SEARCH_ITEM_PERSISTENT_CHANGE) -> ::windows::core::Result<::windows::core::HRESULT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).OnItemsChanged)(::windows::core::Vtable::as_raw(self), dwnumberofchanges, ::core::mem::transmute(datachangeentries), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::HRESULT>(result__)
    }
}
::windows::core::interface_hierarchy!(ISearchPersistentItemsChangedSink, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchPersistentItemsChangedSink {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchPersistentItemsChangedSink {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchPersistentItemsChangedSink {}
impl ::core::fmt::Debug for ISearchPersistentItemsChangedSink {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchPersistentItemsChangedSink").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchPersistentItemsChangedSink {
    type Vtable = ISearchPersistentItemsChangedSink_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchPersistentItemsChangedSink {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa2ffdf9b_4758_4f84_b729_df81a1a0612f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchPersistentItemsChangedSink_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub StartedMonitoringScope: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub StoppedMonitoringScope: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub OnItemsChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwnumberofchanges: u32, datachangeentries: *const SEARCH_ITEM_PERSISTENT_CHANGE, hrcompletioncodes: *mut ::windows::core::HRESULT) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchProtocol(::windows::core::IUnknown);
impl ISearchProtocol {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<'a, P0>(&self, ptimeoutinfo: *mut TIMEOUT_INFO, pprotocolhandlersite: P0, pproxyinfo: *mut PROXY_INFO) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IProtocolHandlerSite>>,
    {
        (::windows::core::Vtable::vtable(self).Init)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptimeoutinfo), pprotocolhandlersite.into().abi(), ::core::mem::transmute(pproxyinfo)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateAccessor<'a, P0>(&self, pcwszurl: P0, pauthenticationinfo: *mut AUTHENTICATION_INFO, pincrementalaccessinfo: *mut INCREMENTAL_ACCESS_INFO, piteminfo: *mut ITEM_INFO, ppaccessor: *mut ::core::option::Option<IUrlAccessor>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).CreateAccessor)(::windows::core::Vtable::as_raw(self), pcwszurl.into(), ::core::mem::transmute(pauthenticationinfo), ::core::mem::transmute(pincrementalaccessinfo), ::core::mem::transmute(piteminfo), ::core::mem::transmute(ppaccessor)).ok()
    }
    pub unsafe fn CloseAccessor<'a, P0>(&self, paccessor: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IUrlAccessor>>,
    {
        (::windows::core::Vtable::vtable(self).CloseAccessor)(::windows::core::Vtable::as_raw(self), paccessor.into().abi()).ok()
    }
    pub unsafe fn ShutDown(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ShutDown)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(ISearchProtocol, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchProtocol {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchProtocol {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchProtocol {}
impl ::core::fmt::Debug for ISearchProtocol {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchProtocol").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchProtocol {
    type Vtable = ISearchProtocol_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchProtocol {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc73106ba_ac80_11d1_8df3_00c04fb6ef4f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchProtocol_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Init: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimeoutinfo: *mut TIMEOUT_INFO, pprotocolhandlersite: *mut ::core::ffi::c_void, pproxyinfo: *mut PROXY_INFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Init: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub CreateAccessor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcwszurl: ::windows::core::PCWSTR, pauthenticationinfo: *mut AUTHENTICATION_INFO, pincrementalaccessinfo: *mut INCREMENTAL_ACCESS_INFO, piteminfo: *mut ITEM_INFO, ppaccessor: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CreateAccessor: usize,
    pub CloseAccessor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, paccessor: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ShutDown: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchProtocol2(::windows::core::IUnknown);
impl ISearchProtocol2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<'a, P0>(&self, ptimeoutinfo: *mut TIMEOUT_INFO, pprotocolhandlersite: P0, pproxyinfo: *mut PROXY_INFO) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IProtocolHandlerSite>>,
    {
        (::windows::core::Vtable::vtable(self).base__.Init)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptimeoutinfo), pprotocolhandlersite.into().abi(), ::core::mem::transmute(pproxyinfo)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateAccessor<'a, P0>(&self, pcwszurl: P0, pauthenticationinfo: *mut AUTHENTICATION_INFO, pincrementalaccessinfo: *mut INCREMENTAL_ACCESS_INFO, piteminfo: *mut ITEM_INFO, ppaccessor: *mut ::core::option::Option<IUrlAccessor>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.CreateAccessor)(::windows::core::Vtable::as_raw(self), pcwszurl.into(), ::core::mem::transmute(pauthenticationinfo), ::core::mem::transmute(pincrementalaccessinfo), ::core::mem::transmute(piteminfo), ::core::mem::transmute(ppaccessor)).ok()
    }
    pub unsafe fn CloseAccessor<'a, P0>(&self, paccessor: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IUrlAccessor>>,
    {
        (::windows::core::Vtable::vtable(self).base__.CloseAccessor)(::windows::core::Vtable::as_raw(self), paccessor.into().abi()).ok()
    }
    pub unsafe fn ShutDown(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.ShutDown)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CreateAccessorEx<'a, P0>(&self, pcwszurl: P0, pauthenticationinfo: *mut AUTHENTICATION_INFO, pincrementalaccessinfo: *mut INCREMENTAL_ACCESS_INFO, piteminfo: *mut ITEM_INFO, puserdata: *const super::Com::BLOB, ppaccessor: *mut ::core::option::Option<IUrlAccessor>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).CreateAccessorEx)(::windows::core::Vtable::as_raw(self), pcwszurl.into(), ::core::mem::transmute(pauthenticationinfo), ::core::mem::transmute(pincrementalaccessinfo), ::core::mem::transmute(piteminfo), ::core::mem::transmute(puserdata), ::core::mem::transmute(ppaccessor)).ok()
    }
}
::windows::core::interface_hierarchy!(ISearchProtocol2, ::windows::core::IUnknown, ISearchProtocol);
impl ::core::clone::Clone for ISearchProtocol2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchProtocol2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchProtocol2 {}
impl ::core::fmt::Debug for ISearchProtocol2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchProtocol2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchProtocol2 {
    type Vtable = ISearchProtocol2_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchProtocol2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7789f0b2_b5b2_4722_8b65_5dbd150697a9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchProtocol2_Vtbl {
    pub base__: ISearchProtocol_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CreateAccessorEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcwszurl: ::windows::core::PCWSTR, pauthenticationinfo: *mut AUTHENTICATION_INFO, pincrementalaccessinfo: *mut INCREMENTAL_ACCESS_INFO, piteminfo: *mut ITEM_INFO, puserdata: *const super::Com::BLOB, ppaccessor: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CreateAccessorEx: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchProtocolThreadContext(::windows::core::IUnknown);
impl ISearchProtocolThreadContext {
    pub unsafe fn ThreadInit(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ThreadInit)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn ThreadShutdown(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ThreadShutdown)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn ThreadIdle(&self, dwtimeelaspedsincelastcallinms: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).ThreadIdle)(::windows::core::Vtable::as_raw(self), dwtimeelaspedsincelastcallinms).ok()
    }
}
::windows::core::interface_hierarchy!(ISearchProtocolThreadContext, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchProtocolThreadContext {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchProtocolThreadContext {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchProtocolThreadContext {}
impl ::core::fmt::Debug for ISearchProtocolThreadContext {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchProtocolThreadContext").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchProtocolThreadContext {
    type Vtable = ISearchProtocolThreadContext_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchProtocolThreadContext {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc73106e1_ac80_11d1_8df3_00c04fb6ef4f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchProtocolThreadContext_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub ThreadInit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ThreadShutdown: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ThreadIdle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtimeelaspedsincelastcallinms: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchQueryHelper(::windows::core::IUnknown);
impl ISearchQueryHelper {
    pub unsafe fn ConnectionString(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ConnectionString)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetQueryContentLocale(&self, lcid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetQueryContentLocale)(::windows::core::Vtable::as_raw(self), lcid).ok()
    }
    pub unsafe fn QueryContentLocale(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QueryContentLocale)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn SetQueryKeywordLocale(&self, lcid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetQueryKeywordLocale)(::windows::core::Vtable::as_raw(self), lcid).ok()
    }
    pub unsafe fn QueryKeywordLocale(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QueryKeywordLocale)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn SetQueryTermExpansion(&self, expandterms: SEARCH_TERM_EXPANSION) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetQueryTermExpansion)(::windows::core::Vtable::as_raw(self), expandterms).ok()
    }
    pub unsafe fn QueryTermExpansion(&self) -> ::windows::core::Result<SEARCH_TERM_EXPANSION> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QueryTermExpansion)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<SEARCH_TERM_EXPANSION>(result__)
    }
    pub unsafe fn SetQuerySyntax(&self, querysyntax: SEARCH_QUERY_SYNTAX) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetQuerySyntax)(::windows::core::Vtable::as_raw(self), querysyntax).ok()
    }
    pub unsafe fn QuerySyntax(&self) -> ::windows::core::Result<SEARCH_QUERY_SYNTAX> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QuerySyntax)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<SEARCH_QUERY_SYNTAX>(result__)
    }
    pub unsafe fn SetQueryContentProperties<'a, P0>(&self, pszcontentproperties: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetQueryContentProperties)(::windows::core::Vtable::as_raw(self), pszcontentproperties.into()).ok()
    }
    pub unsafe fn QueryContentProperties(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QueryContentProperties)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetQuerySelectColumns<'a, P0>(&self, pszselectcolumns: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetQuerySelectColumns)(::windows::core::Vtable::as_raw(self), pszselectcolumns.into()).ok()
    }
    pub unsafe fn QuerySelectColumns(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QuerySelectColumns)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetQueryWhereRestrictions<'a, P0>(&self, pszrestrictions: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetQueryWhereRestrictions)(::windows::core::Vtable::as_raw(self), pszrestrictions.into()).ok()
    }
    pub unsafe fn QueryWhereRestrictions(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QueryWhereRestrictions)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetQuerySorting<'a, P0>(&self, pszsorting: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetQuerySorting)(::windows::core::Vtable::as_raw(self), pszsorting.into()).ok()
    }
    pub unsafe fn QuerySorting(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QuerySorting)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn GenerateSQLFromUserQuery<'a, P0>(&self, pszquery: P0) -> ::windows::core::Result<::windows::core::PWSTR>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GenerateSQLFromUserQuery)(::windows::core::Vtable::as_raw(self), pszquery.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn WriteProperties(&self, itemid: i32, dwnumberofcolumns: u32, pcolumns: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, pvalues: *const SEARCH_COLUMN_PROPERTIES, pftgathermodifiedtime: ::core::option::Option<*const super::super::Foundation::FILETIME>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).WriteProperties)(::windows::core::Vtable::as_raw(self), itemid, dwnumberofcolumns, ::core::mem::transmute(pcolumns), ::core::mem::transmute(pvalues), ::core::mem::transmute(pftgathermodifiedtime.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn SetQueryMaxResults(&self, cmaxresults: i32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetQueryMaxResults)(::windows::core::Vtable::as_raw(self), cmaxresults).ok()
    }
    pub unsafe fn QueryMaxResults(&self) -> ::windows::core::Result<i32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).QueryMaxResults)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<i32>(result__)
    }
}
::windows::core::interface_hierarchy!(ISearchQueryHelper, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchQueryHelper {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchQueryHelper {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchQueryHelper {}
impl ::core::fmt::Debug for ISearchQueryHelper {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchQueryHelper").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchQueryHelper {
    type Vtable = ISearchQueryHelper_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchQueryHelper {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef63);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchQueryHelper_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub ConnectionString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszconnectionstring: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetQueryContentLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lcid: u32) -> ::windows::core::HRESULT,
    pub QueryContentLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcid: *mut u32) -> ::windows::core::HRESULT,
    pub SetQueryKeywordLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lcid: u32) -> ::windows::core::HRESULT,
    pub QueryKeywordLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcid: *mut u32) -> ::windows::core::HRESULT,
    pub SetQueryTermExpansion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, expandterms: SEARCH_TERM_EXPANSION) -> ::windows::core::HRESULT,
    pub QueryTermExpansion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pexpandterms: *mut SEARCH_TERM_EXPANSION) -> ::windows::core::HRESULT,
    pub SetQuerySyntax: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, querysyntax: SEARCH_QUERY_SYNTAX) -> ::windows::core::HRESULT,
    pub QuerySyntax: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pquerysyntax: *mut SEARCH_QUERY_SYNTAX) -> ::windows::core::HRESULT,
    pub SetQueryContentProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszcontentproperties: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub QueryContentProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszcontentproperties: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetQuerySelectColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszselectcolumns: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub QuerySelectColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszselectcolumns: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetQueryWhereRestrictions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszrestrictions: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub QueryWhereRestrictions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszrestrictions: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetQuerySorting: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszsorting: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub QuerySorting: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszsorting: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub GenerateSQLFromUserQuery: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszquery: ::windows::core::PCWSTR, ppszsql: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub WriteProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itemid: i32, dwnumberofcolumns: u32, pcolumns: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, pvalues: *const ::core::mem::ManuallyDrop<SEARCH_COLUMN_PROPERTIES>, pftgathermodifiedtime: *const super::super::Foundation::FILETIME) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_UI_Shell_PropertiesSystem")))]
    WriteProperties: usize,
    pub SetQueryMaxResults: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cmaxresults: i32) -> ::windows::core::HRESULT,
    pub QueryMaxResults: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcmaxresults: *mut i32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchQueryHits(::windows::core::IUnknown);
impl ISearchQueryHits {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn Init<'a, P0>(&self, pflt: P0, ulflags: u32) -> i32
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::super::Storage::IndexServer::IFilter>>,
    {
        (::windows::core::Vtable::vtable(self).Init)(::windows::core::Vtable::as_raw(self), pflt.into().abi(), ulflags)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn NextHitMoniker(&self, pcmnk: *mut u32, papmnk: *mut *mut ::core::option::Option<super::Com::IMoniker>) -> i32 {
        (::windows::core::Vtable::vtable(self).NextHitMoniker)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcmnk), ::core::mem::transmute(papmnk))
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn NextHitOffset(&self, pcregion: *mut u32, paregion: *mut *mut super::super::Storage::IndexServer::FILTERREGION) -> i32 {
        (::windows::core::Vtable::vtable(self).NextHitOffset)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcregion), ::core::mem::transmute(paregion))
    }
}
::windows::core::interface_hierarchy!(ISearchQueryHits, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchQueryHits {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchQueryHits {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchQueryHits {}
impl ::core::fmt::Debug for ISearchQueryHits {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchQueryHits").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchQueryHits {
    type Vtable = ISearchQueryHits_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchQueryHits {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xed8ce7e0_106c_11ce_84e2_00aa004b9986);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchQueryHits_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub Init: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pflt: *mut ::core::ffi::c_void, ulflags: u32) -> i32,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    Init: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub NextHitMoniker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcmnk: *mut u32, papmnk: *mut *mut *mut ::core::ffi::c_void) -> i32,
    #[cfg(not(feature = "Win32_System_Com"))]
    NextHitMoniker: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub NextHitOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcregion: *mut u32, paregion: *mut *mut super::super::Storage::IndexServer::FILTERREGION) -> i32,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    NextHitOffset: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchRoot(::windows::core::IUnknown);
impl ISearchRoot {
    pub unsafe fn SetSchedule<'a, P0>(&self, psztaskarg: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetSchedule)(::windows::core::Vtable::as_raw(self), psztaskarg.into()).ok()
    }
    pub unsafe fn Schedule(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Schedule)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetRootURL<'a, P0>(&self, pszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetRootURL)(::windows::core::Vtable::as_raw(self), pszurl.into()).ok()
    }
    pub unsafe fn RootURL(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).RootURL)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetIsHierarchical<'a, P0>(&self, fishierarchical: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetIsHierarchical)(::windows::core::Vtable::as_raw(self), fishierarchical.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsHierarchical(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsHierarchical)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetProvidesNotifications<'a, P0>(&self, fprovidesnotifications: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetProvidesNotifications)(::windows::core::Vtable::as_raw(self), fprovidesnotifications.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ProvidesNotifications(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ProvidesNotifications)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetUseNotificationsOnly<'a, P0>(&self, fusenotificationsonly: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetUseNotificationsOnly)(::windows::core::Vtable::as_raw(self), fusenotificationsonly.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UseNotificationsOnly(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).UseNotificationsOnly)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetEnumerationDepth(&self, dwdepth: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetEnumerationDepth)(::windows::core::Vtable::as_raw(self), dwdepth).ok()
    }
    pub unsafe fn EnumerationDepth(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).EnumerationDepth)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn SetHostDepth(&self, dwdepth: u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetHostDepth)(::windows::core::Vtable::as_raw(self), dwdepth).ok()
    }
    pub unsafe fn HostDepth(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).HostDepth)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFollowDirectories<'a, P0>(&self, ffollowdirectories: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).SetFollowDirectories)(::windows::core::Vtable::as_raw(self), ffollowdirectories.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FollowDirectories(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).FollowDirectories)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetAuthenticationType(&self, authtype: AUTH_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetAuthenticationType)(::windows::core::Vtable::as_raw(self), authtype).ok()
    }
    pub unsafe fn AuthenticationType(&self) -> ::windows::core::Result<AUTH_TYPE> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).AuthenticationType)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<AUTH_TYPE>(result__)
    }
    pub unsafe fn SetUser<'a, P0>(&self, pszuser: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetUser)(::windows::core::Vtable::as_raw(self), pszuser.into()).ok()
    }
    pub unsafe fn User(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).User)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    pub unsafe fn SetPassword<'a, P0>(&self, pszpassword: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).SetPassword)(::windows::core::Vtable::as_raw(self), pszpassword.into()).ok()
    }
    pub unsafe fn Password(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).Password)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
}
::windows::core::interface_hierarchy!(ISearchRoot, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchRoot {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchRoot {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchRoot {}
impl ::core::fmt::Debug for ISearchRoot {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchRoot").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchRoot {
    type Vtable = ISearchRoot_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchRoot {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x04c18ccf_1f57_4cbd_88cc_3900f5195ce3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchRoot_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub SetSchedule: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psztaskarg: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub Schedule: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsztaskarg: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetRootURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszurl: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub RootURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszurl: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetIsHierarchical: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fishierarchical: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetIsHierarchical: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsHierarchical: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfishierarchical: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsHierarchical: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetProvidesNotifications: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fprovidesnotifications: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetProvidesNotifications: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ProvidesNotifications: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfprovidesnotifications: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ProvidesNotifications: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetUseNotificationsOnly: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fusenotificationsonly: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetUseNotificationsOnly: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub UseNotificationsOnly: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfusenotificationsonly: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UseNotificationsOnly: usize,
    pub SetEnumerationDepth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwdepth: u32) -> ::windows::core::HRESULT,
    pub EnumerationDepth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwdepth: *mut u32) -> ::windows::core::HRESULT,
    pub SetHostDepth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwdepth: u32) -> ::windows::core::HRESULT,
    pub HostDepth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwdepth: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetFollowDirectories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ffollowdirectories: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetFollowDirectories: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub FollowDirectories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pffollowdirectories: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    FollowDirectories: usize,
    pub SetAuthenticationType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, authtype: AUTH_TYPE) -> ::windows::core::HRESULT,
    pub AuthenticationType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pauthtype: *mut AUTH_TYPE) -> ::windows::core::HRESULT,
    pub SetUser: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszuser: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub User: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszuser: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    pub SetPassword: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpassword: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub Password: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszpassword: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchScopeRule(::windows::core::IUnknown);
impl ISearchScopeRule {
    pub unsafe fn PatternOrURL(&self) -> ::windows::core::Result<::windows::core::PWSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).PatternOrURL)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::PWSTR>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsIncluded(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsIncluded)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsDefault(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsDefault)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn FollowFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).FollowFlags)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
::windows::core::interface_hierarchy!(ISearchScopeRule, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchScopeRule {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchScopeRule {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchScopeRule {}
impl ::core::fmt::Debug for ISearchScopeRule {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchScopeRule").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchScopeRule {
    type Vtable = ISearchScopeRule_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchScopeRule {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef53);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchScopeRule_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub PatternOrURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszpatternorurl: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub IsIncluded: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfisincluded: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsIncluded: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfisdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsDefault: usize,
    pub FollowFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfollowflags: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISearchViewChangedSink(::windows::core::IUnknown);
impl ISearchViewChangedSink {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn OnChange(&self, pdwdocid: *const i32, pchange: *const SEARCH_ITEM_CHANGE, pfinview: *const super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).OnChange)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pdwdocid), ::core::mem::transmute(pchange), ::core::mem::transmute(pfinview)).ok()
    }
}
::windows::core::interface_hierarchy!(ISearchViewChangedSink, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISearchViewChangedSink {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISearchViewChangedSink {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISearchViewChangedSink {}
impl ::core::fmt::Debug for ISearchViewChangedSink {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISearchViewChangedSink").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISearchViewChangedSink {
    type Vtable = ISearchViewChangedSink_Vtbl;
}
unsafe impl ::windows::core::Interface for ISearchViewChangedSink {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab310581_ac80_11d1_8df3_00c04fb6ef65);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISearchViewChangedSink_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub OnChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwdocid: *const i32, pchange: *const SEARCH_ITEM_CHANGE, pfinview: *const super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    OnChange: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISecurityInfo(::windows::core::IUnknown);
impl ISecurityInfo {
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`*"]
    #[cfg(feature = "Win32_Security_Authorization")]
    pub unsafe fn GetCurrentTrustee(&self, pptrustee: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCurrentTrustee)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pptrustee)).ok()
    }
    pub unsafe fn GetObjectTypes(&self, cobjecttypes: *mut u32, rgobjecttypes: *mut *mut ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetObjectTypes)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(cobjecttypes), ::core::mem::transmute(rgobjecttypes)).ok()
    }
    pub unsafe fn GetPermissions(&self, objecttype: ::windows::core::GUID, ppermissions: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetPermissions)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(objecttype), ::core::mem::transmute(ppermissions)).ok()
    }
}
::windows::core::interface_hierarchy!(ISecurityInfo, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISecurityInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISecurityInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISecurityInfo {}
impl ::core::fmt::Debug for ISecurityInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISecurityInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISecurityInfo {
    type Vtable = ISecurityInfo_Vtbl;
}
unsafe impl ::windows::core::Interface for ISecurityInfo {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa4_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISecurityInfo_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Security_Authorization")]
    pub GetCurrentTrustee: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptrustee: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Security_Authorization"))]
    GetCurrentTrustee: usize,
    pub GetObjectTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cobjecttypes: *mut u32, rgobjecttypes: *mut *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub GetPermissions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, objecttype: ::windows::core::GUID, ppermissions: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IService(::windows::core::IUnknown);
impl IService {
    pub unsafe fn InvokeService<'a, P0>(&self, punkinner: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).InvokeService)(::windows::core::Vtable::as_raw(self), punkinner.into().abi()).ok()
    }
}
::windows::core::interface_hierarchy!(IService, ::windows::core::IUnknown);
impl ::core::clone::Clone for IService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IService {}
impl ::core::fmt::Debug for IService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IService").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IService {
    type Vtable = IService_Vtbl;
}
unsafe impl ::windows::core::Interface for IService {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x06210e88_01f5_11d1_b512_0080c781c384);
}
#[repr(C)]
#[doc(hidden)]
pub struct IService_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub InvokeService: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkinner: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISessionProperties(::windows::core::IUnknown);
impl ISessionProperties {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetProperties(&self, rgpropertyidsets: ::core::option::Option<&[DBPROPIDSET]>, pcpropertysets: *mut u32, prgpropertysets: ::core::option::Option<*mut *mut DBPROPSET>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetProperties)(::windows::core::Vtable::as_raw(self), rgpropertyidsets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertyidsets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetProperties(&self, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetProperties)(::windows::core::Vtable::as_raw(self), rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr()))).ok()
    }
}
::windows::core::interface_hierarchy!(ISessionProperties, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISessionProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISessionProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISessionProperties {}
impl ::core::fmt::Debug for ISessionProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISessionProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISessionProperties {
    type Vtable = ISessionProperties_Vtbl;
}
unsafe impl ::windows::core::Interface for ISessionProperties {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a85_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISessionProperties_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetProperties: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetProperties: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISimpleCommandCreator(::windows::core::IUnknown);
impl ISimpleCommandCreator {
    pub unsafe fn CreateICommand<'a, P0>(&self, ppiunknown: *mut ::core::option::Option<::windows::core::IUnknown>, pouterunk: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).CreateICommand)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppiunknown), pouterunk.into().abi()).ok()
    }
    pub unsafe fn VerifyCatalog<'a, P0, P1>(&self, pwszmachine: P0, pwszcatalogname: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).VerifyCatalog)(::windows::core::Vtable::as_raw(self), pwszmachine.into(), pwszcatalogname.into()).ok()
    }
    pub unsafe fn GetDefaultCatalog<'a, P0>(&self, pwszcatalogname: P0, cwcin: u32, pcwcout: *mut u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).GetDefaultCatalog)(::windows::core::Vtable::as_raw(self), pwszcatalogname.into(), cwcin, ::core::mem::transmute(pcwcout)).ok()
    }
}
::windows::core::interface_hierarchy!(ISimpleCommandCreator, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISimpleCommandCreator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISimpleCommandCreator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISimpleCommandCreator {}
impl ::core::fmt::Debug for ISimpleCommandCreator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISimpleCommandCreator").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISimpleCommandCreator {
    type Vtable = ISimpleCommandCreator_Vtbl;
}
unsafe impl ::windows::core::Interface for ISimpleCommandCreator {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5e341ab7_02d0_11d1_900c_00a0c9063796);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISimpleCommandCreator_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub CreateICommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppiunknown: *mut *mut ::core::ffi::c_void, pouterunk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub VerifyCatalog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszmachine: ::windows::core::PCWSTR, pwszcatalogname: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub GetDefaultCatalog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszcatalogname: ::windows::core::PCWSTR, cwcin: u32, pcwcout: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISourcesRowset(::windows::core::IUnknown);
impl ISourcesRowset {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSourcesRowset<'a, P0>(&self, punkouter: P0, riid: *const ::windows::core::GUID, rgproperties: ::core::option::Option<&mut [DBPROPSET]>, ppsourcesrowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).GetSourcesRowset)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(riid), rgproperties.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgproperties.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), ::core::mem::transmute(ppsourcesrowset)).ok()
    }
}
::windows::core::interface_hierarchy!(ISourcesRowset, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISourcesRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISourcesRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISourcesRowset {}
impl ::core::fmt::Debug for ISourcesRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISourcesRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISourcesRowset {
    type Vtable = ISourcesRowset_Vtbl;
}
unsafe impl ::windows::core::Interface for ISourcesRowset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a1e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISourcesRowset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetSourcesRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, cpropertysets: u32, rgproperties: *mut DBPROPSET, ppsourcesrowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetSourcesRowset: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IStemmer(::windows::core::IUnknown);
impl IStemmer {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init(&self, ulmaxtokensize: u32, pflicense: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Init)(::windows::core::Vtable::as_raw(self), ulmaxtokensize, ::core::mem::transmute(pflicense)).ok()
    }
    pub unsafe fn GenerateWordForms<'a, P0, P1>(&self, pwcinbuf: P0, cwc: u32, pstemsink: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, IWordFormSink>>,
    {
        (::windows::core::Vtable::vtable(self).GenerateWordForms)(::windows::core::Vtable::as_raw(self), pwcinbuf.into(), cwc, pstemsink.into().abi()).ok()
    }
    pub unsafe fn GetLicenseToUse(&self, ppwcslicense: *const *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetLicenseToUse)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppwcslicense)).ok()
    }
}
::windows::core::interface_hierarchy!(IStemmer, ::windows::core::IUnknown);
impl ::core::clone::Clone for IStemmer {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IStemmer {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IStemmer {}
impl ::core::fmt::Debug for IStemmer {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IStemmer").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IStemmer {
    type Vtable = IStemmer_Vtbl;
}
unsafe impl ::windows::core::Interface for IStemmer {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xefbaf140_7f42_11ce_be57_00aa0051fe20);
}
#[repr(C)]
#[doc(hidden)]
pub struct IStemmer_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Init: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulmaxtokensize: u32, pflicense: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Init: usize,
    pub GenerateWordForms: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwcinbuf: ::windows::core::PCWSTR, cwc: u32, pstemsink: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetLicenseToUse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppwcslicense: *const *const u16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISubscriptionItem(::windows::core::IUnknown);
impl ISubscriptionItem {
    pub unsafe fn GetCookie(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCookie)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    pub unsafe fn GetSubscriptionItemInfo(&self) -> ::windows::core::Result<SUBSCRIPTIONITEMINFO> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSubscriptionItemInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<SUBSCRIPTIONITEMINFO>(result__)
    }
    pub unsafe fn SetSubscriptionItemInfo(&self, psubscriptioniteminfo: *const SUBSCRIPTIONITEMINFO) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetSubscriptionItemInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(psubscriptioniteminfo)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ReadProperties(&self, ncount: u32, rgwszname: *const ::windows::core::PWSTR) -> ::windows::core::Result<super::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ReadProperties)(::windows::core::Vtable::as_raw(self), ncount, ::core::mem::transmute(rgwszname), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn WriteProperties(&self, ncount: u32, rgwszname: *const ::windows::core::PWSTR, rgvalue: *const super::Com::VARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).WriteProperties)(::windows::core::Vtable::as_raw(self), ncount, ::core::mem::transmute(rgwszname), ::core::mem::transmute(rgvalue)).ok()
    }
    pub unsafe fn EnumProperties(&self) -> ::windows::core::Result<IEnumItemProperties> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).EnumProperties)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumItemProperties>(result__)
    }
    pub unsafe fn NotifyChanged(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).NotifyChanged)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(ISubscriptionItem, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISubscriptionItem {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISubscriptionItem {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISubscriptionItem {}
impl ::core::fmt::Debug for ISubscriptionItem {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISubscriptionItem").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISubscriptionItem {
    type Vtable = ISubscriptionItem_Vtbl;
}
unsafe impl ::windows::core::Interface for ISubscriptionItem {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa97559f8_6c4a_11d1_a1e8_00c04fc2fbe1);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISubscriptionItem_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetCookie: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcookie: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub GetSubscriptionItemInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psubscriptioniteminfo: *mut SUBSCRIPTIONITEMINFO) -> ::windows::core::HRESULT,
    pub SetSubscriptionItemInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psubscriptioniteminfo: *const SUBSCRIPTIONITEMINFO) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub ReadProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ncount: u32, rgwszname: *const ::windows::core::PWSTR, rgvalue: *mut ::core::mem::ManuallyDrop<super::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    ReadProperties: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub WriteProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ncount: u32, rgwszname: *const ::windows::core::PWSTR, rgvalue: *const ::core::mem::ManuallyDrop<super::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    WriteProperties: usize,
    pub EnumProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenumitemproperties: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub NotifyChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISubscriptionMgr(::windows::core::IUnknown);
impl ISubscriptionMgr {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeleteSubscription<'a, P0, P1>(&self, pwszurl: P0, hwnd: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).DeleteSubscription)(::windows::core::Vtable::as_raw(self), pwszurl.into(), hwnd.into()).ok()
    }
    pub unsafe fn UpdateSubscription<'a, P0>(&self, pwszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).UpdateSubscription)(::windows::core::Vtable::as_raw(self), pwszurl.into()).ok()
    }
    pub unsafe fn UpdateAll(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).UpdateAll)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSubscribed<'a, P0>(&self, pwszurl: P0) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).IsSubscribed)(::windows::core::Vtable::as_raw(self), pwszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSubscriptionInfo<'a, P0>(&self, pwszurl: P0) -> ::windows::core::Result<SUBSCRIPTIONINFO>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSubscriptionInfo)(::windows::core::Vtable::as_raw(self), pwszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<SUBSCRIPTIONINFO>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDefaultInfo(&self, subtype: SUBSCRIPTIONTYPE) -> ::windows::core::Result<SUBSCRIPTIONINFO> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetDefaultInfo)(::windows::core::Vtable::as_raw(self), subtype, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<SUBSCRIPTIONINFO>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowSubscriptionProperties<'a, P0, P1>(&self, pwszurl: P0, hwnd: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).ShowSubscriptionProperties)(::windows::core::Vtable::as_raw(self), pwszurl.into(), hwnd.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateSubscription<'a, P0, P1, P2>(&self, hwnd: P0, pwszurl: P1, pwszfriendlyname: P2, dwflags: u32, substype: SUBSCRIPTIONTYPE, pinfo: *mut SUBSCRIPTIONINFO) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).CreateSubscription)(::windows::core::Vtable::as_raw(self), hwnd.into(), pwszurl.into(), pwszfriendlyname.into(), dwflags, substype, ::core::mem::transmute(pinfo)).ok()
    }
}
::windows::core::interface_hierarchy!(ISubscriptionMgr, ::windows::core::IUnknown);
impl ::core::clone::Clone for ISubscriptionMgr {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISubscriptionMgr {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISubscriptionMgr {}
impl ::core::fmt::Debug for ISubscriptionMgr {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISubscriptionMgr").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISubscriptionMgr {
    type Vtable = ISubscriptionMgr_Vtbl;
}
unsafe impl ::windows::core::Interface for ISubscriptionMgr {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x085fb2c0_0df8_11d1_8f4b_00a0c905413f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISubscriptionMgr_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub DeleteSubscription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DeleteSubscription: usize,
    pub UpdateSubscription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR) -> ::windows::core::HRESULT,
    pub UpdateAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub IsSubscribed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, pfsubscribed: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsSubscribed: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetSubscriptionInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, pinfo: *mut ::core::mem::ManuallyDrop<SUBSCRIPTIONINFO>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetSubscriptionInfo: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetDefaultInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, subtype: SUBSCRIPTIONTYPE, pinfo: *mut ::core::mem::ManuallyDrop<SUBSCRIPTIONINFO>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetDefaultInfo: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ShowSubscriptionProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ShowSubscriptionProperties: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub CreateSubscription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, pwszurl: ::windows::core::PCWSTR, pwszfriendlyname: ::windows::core::PCWSTR, dwflags: u32, substype: SUBSCRIPTIONTYPE, pinfo: *mut ::core::mem::ManuallyDrop<SUBSCRIPTIONINFO>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CreateSubscription: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ISubscriptionMgr2(::windows::core::IUnknown);
impl ISubscriptionMgr2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeleteSubscription<'a, P0, P1>(&self, pwszurl: P0, hwnd: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).base__.DeleteSubscription)(::windows::core::Vtable::as_raw(self), pwszurl.into(), hwnd.into()).ok()
    }
    pub unsafe fn UpdateSubscription<'a, P0>(&self, pwszurl: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.UpdateSubscription)(::windows::core::Vtable::as_raw(self), pwszurl.into()).ok()
    }
    pub unsafe fn UpdateAll(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.UpdateAll)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSubscribed<'a, P0>(&self, pwszurl: P0) -> ::windows::core::Result<super::super::Foundation::BOOL>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.IsSubscribed)(::windows::core::Vtable::as_raw(self), pwszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSubscriptionInfo<'a, P0>(&self, pwszurl: P0) -> ::windows::core::Result<SUBSCRIPTIONINFO>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetSubscriptionInfo)(::windows::core::Vtable::as_raw(self), pwszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<SUBSCRIPTIONINFO>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDefaultInfo(&self, subtype: SUBSCRIPTIONTYPE) -> ::windows::core::Result<SUBSCRIPTIONINFO> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetDefaultInfo)(::windows::core::Vtable::as_raw(self), subtype, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<SUBSCRIPTIONINFO>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowSubscriptionProperties<'a, P0, P1>(&self, pwszurl: P0, hwnd: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<super::super::Foundation::HWND>,
    {
        (::windows::core::Vtable::vtable(self).base__.ShowSubscriptionProperties)(::windows::core::Vtable::as_raw(self), pwszurl.into(), hwnd.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateSubscription<'a, P0, P1, P2>(&self, hwnd: P0, pwszurl: P1, pwszfriendlyname: P2, dwflags: u32, substype: SUBSCRIPTIONTYPE, pinfo: *mut SUBSCRIPTIONINFO) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::HWND>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.CreateSubscription)(::windows::core::Vtable::as_raw(self), hwnd.into(), pwszurl.into(), pwszfriendlyname.into(), dwflags, substype, ::core::mem::transmute(pinfo)).ok()
    }
    pub unsafe fn GetItemFromURL<'a, P0>(&self, pwszurl: P0) -> ::windows::core::Result<ISubscriptionItem>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetItemFromURL)(::windows::core::Vtable::as_raw(self), pwszurl.into(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISubscriptionItem>(result__)
    }
    pub unsafe fn GetItemFromCookie(&self, psubscriptioncookie: *const ::windows::core::GUID) -> ::windows::core::Result<ISubscriptionItem> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetItemFromCookie)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(psubscriptioncookie), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<ISubscriptionItem>(result__)
    }
    pub unsafe fn GetSubscriptionRunState(&self, dwnumcookies: u32, pcookies: *const ::windows::core::GUID) -> ::windows::core::Result<u32> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSubscriptionRunState)(::windows::core::Vtable::as_raw(self), dwnumcookies, ::core::mem::transmute(pcookies), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
    pub unsafe fn EnumSubscriptions(&self, dwflags: u32) -> ::windows::core::Result<IEnumSubscription> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).EnumSubscriptions)(::windows::core::Vtable::as_raw(self), dwflags, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<IEnumSubscription>(result__)
    }
    pub unsafe fn UpdateItems(&self, dwflags: u32, pcookies: &[::windows::core::GUID]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).UpdateItems)(::windows::core::Vtable::as_raw(self), dwflags, pcookies.len() as _, ::core::mem::transmute(pcookies.as_ptr())).ok()
    }
    pub unsafe fn AbortItems(&self, pcookies: &[::windows::core::GUID]) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AbortItems)(::windows::core::Vtable::as_raw(self), pcookies.len() as _, ::core::mem::transmute(pcookies.as_ptr())).ok()
    }
    pub unsafe fn AbortAll(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AbortAll)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(ISubscriptionMgr2, ::windows::core::IUnknown, ISubscriptionMgr);
impl ::core::clone::Clone for ISubscriptionMgr2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ISubscriptionMgr2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ISubscriptionMgr2 {}
impl ::core::fmt::Debug for ISubscriptionMgr2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ISubscriptionMgr2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ISubscriptionMgr2 {
    type Vtable = ISubscriptionMgr2_Vtbl;
}
unsafe impl ::windows::core::Interface for ISubscriptionMgr2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x614bc270_aedf_11d1_a1f9_00c04fc2fbe1);
}
#[repr(C)]
#[doc(hidden)]
pub struct ISubscriptionMgr2_Vtbl {
    pub base__: ISubscriptionMgr_Vtbl,
    pub GetItemFromURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszurl: ::windows::core::PCWSTR, ppsubscriptionitem: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetItemFromCookie: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psubscriptioncookie: *const ::windows::core::GUID, ppsubscriptionitem: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetSubscriptionRunState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwnumcookies: u32, pcookies: *const ::windows::core::GUID, pdwrunstate: *mut u32) -> ::windows::core::HRESULT,
    pub EnumSubscriptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, ppenumsubscriptions: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UpdateItems: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, dwnumcookies: u32, pcookies: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub AbortItems: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwnumcookies: u32, pcookies: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub AbortAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ITableCreation(::windows::core::IUnknown);
impl ITableCreation {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTable<'a, P0>(&self, punkouter: P0, ptableid: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>, rgcolumndescs: ::core::option::Option<&[DBCOLUMNDESC]>, riid: *const ::windows::core::GUID, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>, pptableid: ::core::option::Option<*mut *mut super::super::Storage::IndexServer::DBID>, pprowset: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).base__.CreateTable)(
            ::windows::core::Vtable::as_raw(self),
            punkouter.into().abi(),
            ::core::mem::transmute(ptableid.unwrap_or(::std::ptr::null())),
            rgcolumndescs.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(rgcolumndescs.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            ::core::mem::transmute(riid),
            rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            ::core::mem::transmute(pptableid.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pprowset.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DropTable(&self, ptableid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.DropTable)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AddColumn(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pcolumndesc: *const DBCOLUMNDESC) -> ::windows::core::Result<*mut super::super::Storage::IndexServer::DBID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.AddColumn)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pcolumndesc), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut super::super::Storage::IndexServer::DBID>(result__)
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DropColumn(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pcolumnid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.DropColumn)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pcolumnid)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetTableDefinition(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pccolumndescs: ::core::option::Option<*mut usize>, prgcolumndescs: ::core::option::Option<*mut *mut DBCOLUMNDESC>, pcpropertysets: ::core::option::Option<*mut u32>, prgpropertysets: ::core::option::Option<*mut *mut DBPROPSET>, pcconstraintdescs: ::core::option::Option<*mut u32>, prgconstraintdescs: ::core::option::Option<*mut *mut DBCONSTRAINTDESC>, ppwszstringbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetTableDefinition)(
            ::windows::core::Vtable::as_raw(self),
            ::core::mem::transmute(ptableid),
            ::core::mem::transmute(pccolumndescs.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(prgcolumndescs.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pcpropertysets.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(prgpropertysets.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pcconstraintdescs.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(prgconstraintdescs.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(ppwszstringbuffer.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
}
::windows::core::interface_hierarchy!(ITableCreation, ::windows::core::IUnknown, ITableDefinition);
impl ::core::clone::Clone for ITableCreation {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ITableCreation {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ITableCreation {}
impl ::core::fmt::Debug for ITableCreation {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ITableCreation").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ITableCreation {
    type Vtable = ITableCreation_Vtbl;
}
unsafe impl ::windows::core::Interface for ITableCreation {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733abc_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ITableCreation_Vtbl {
    pub base__: ITableDefinition_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetTableDefinition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pccolumndescs: *mut usize, prgcolumndescs: *mut *mut ::core::mem::ManuallyDrop<DBCOLUMNDESC>, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET, pcconstraintdescs: *mut u32, prgconstraintdescs: *mut *mut DBCONSTRAINTDESC, ppwszstringbuffer: *mut *mut u16) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetTableDefinition: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ITableDefinition(::windows::core::IUnknown);
impl ITableDefinition {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTable<'a, P0>(&self, punkouter: P0, ptableid: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>, rgcolumndescs: ::core::option::Option<&[DBCOLUMNDESC]>, riid: *const ::windows::core::GUID, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>, pptableid: ::core::option::Option<*mut *mut super::super::Storage::IndexServer::DBID>, pprowset: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).CreateTable)(
            ::windows::core::Vtable::as_raw(self),
            punkouter.into().abi(),
            ::core::mem::transmute(ptableid.unwrap_or(::std::ptr::null())),
            rgcolumndescs.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(rgcolumndescs.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            ::core::mem::transmute(riid),
            rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            ::core::mem::transmute(pptableid.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pprowset.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DropTable(&self, ptableid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DropTable)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AddColumn(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pcolumndesc: *const DBCOLUMNDESC) -> ::windows::core::Result<*mut super::super::Storage::IndexServer::DBID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).AddColumn)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pcolumndesc), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut super::super::Storage::IndexServer::DBID>(result__)
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DropColumn(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pcolumnid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DropColumn)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pcolumnid)).ok()
    }
}
::windows::core::interface_hierarchy!(ITableDefinition, ::windows::core::IUnknown);
impl ::core::clone::Clone for ITableDefinition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ITableDefinition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ITableDefinition {}
impl ::core::fmt::Debug for ITableDefinition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ITableDefinition").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ITableDefinition {
    type Vtable = ITableDefinition_Vtbl;
}
unsafe impl ::windows::core::Interface for ITableDefinition {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a86_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ITableDefinition_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateTable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, ccolumndescs: usize, rgcolumndescs: *const ::core::mem::ManuallyDrop<DBCOLUMNDESC>, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pptableid: *mut *mut super::super::Storage::IndexServer::DBID, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateTable: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub DropTable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    DropTable: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub AddColumn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pcolumndesc: *const ::core::mem::ManuallyDrop<DBCOLUMNDESC>, ppcolumnid: *mut *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    AddColumn: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub DropColumn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *const super::super::Storage::IndexServer::DBID, pcolumnid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    DropColumn: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ITableDefinitionWithConstraints(::windows::core::IUnknown);
impl ITableDefinitionWithConstraints {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTable<'a, P0>(&self, punkouter: P0, ptableid: ::core::option::Option<*const super::super::Storage::IndexServer::DBID>, rgcolumndescs: ::core::option::Option<&[DBCOLUMNDESC]>, riid: *const ::windows::core::GUID, rgpropertysets: ::core::option::Option<&mut [DBPROPSET]>, pptableid: ::core::option::Option<*mut *mut super::super::Storage::IndexServer::DBID>, pprowset: ::core::option::Option<*mut ::core::option::Option<::windows::core::IUnknown>>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).base__.base__.CreateTable)(
            ::windows::core::Vtable::as_raw(self),
            punkouter.into().abi(),
            ::core::mem::transmute(ptableid.unwrap_or(::std::ptr::null())),
            rgcolumndescs.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(rgcolumndescs.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            ::core::mem::transmute(riid),
            rgpropertysets.as_deref().map_or(0, |slice| slice.len() as _),
            ::core::mem::transmute(rgpropertysets.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
            ::core::mem::transmute(pptableid.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pprowset.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DropTable(&self, ptableid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.DropTable)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AddColumn(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pcolumndesc: *const DBCOLUMNDESC) -> ::windows::core::Result<*mut super::super::Storage::IndexServer::DBID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.AddColumn)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pcolumndesc), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<*mut super::super::Storage::IndexServer::DBID>(result__)
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DropColumn(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pcolumnid: *const super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.DropColumn)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pcolumnid)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetTableDefinition(&self, ptableid: *const super::super::Storage::IndexServer::DBID, pccolumndescs: ::core::option::Option<*mut usize>, prgcolumndescs: ::core::option::Option<*mut *mut DBCOLUMNDESC>, pcpropertysets: ::core::option::Option<*mut u32>, prgpropertysets: ::core::option::Option<*mut *mut DBPROPSET>, pcconstraintdescs: ::core::option::Option<*mut u32>, prgconstraintdescs: ::core::option::Option<*mut *mut DBCONSTRAINTDESC>, ppwszstringbuffer: ::core::option::Option<*mut *mut u16>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetTableDefinition)(
            ::windows::core::Vtable::as_raw(self),
            ::core::mem::transmute(ptableid),
            ::core::mem::transmute(pccolumndescs.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(prgcolumndescs.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pcpropertysets.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(prgpropertysets.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pcconstraintdescs.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(prgconstraintdescs.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(ppwszstringbuffer.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn AddConstraint(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pconstraintdesc: *mut DBCONSTRAINTDESC) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AddConstraint)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pconstraintdesc)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTableWithConstraints<'a, P0>(&self, punkouter: P0, ptableid: *mut super::super::Storage::IndexServer::DBID, ccolumndescs: usize, rgcolumndescs: *mut DBCOLUMNDESC, cconstraintdescs: u32, rgconstraintdescs: *mut DBCONSTRAINTDESC, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pptableid: *mut *mut super::super::Storage::IndexServer::DBID, pprowset: *mut ::core::option::Option<::windows::core::IUnknown>) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        (::windows::core::Vtable::vtable(self).CreateTableWithConstraints)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(ptableid), ccolumndescs, ::core::mem::transmute(rgcolumndescs), cconstraintdescs, ::core::mem::transmute(rgconstraintdescs), ::core::mem::transmute(riid), cpropertysets, ::core::mem::transmute(rgpropertysets), ::core::mem::transmute(pptableid), ::core::mem::transmute(pprowset)).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn DropConstraint(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, pconstraintid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DropConstraint)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(pconstraintid)).ok()
    }
}
::windows::core::interface_hierarchy!(ITableDefinitionWithConstraints, ::windows::core::IUnknown, ITableDefinition, ITableCreation);
impl ::core::clone::Clone for ITableDefinitionWithConstraints {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ITableDefinitionWithConstraints {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ITableDefinitionWithConstraints {}
impl ::core::fmt::Debug for ITableDefinitionWithConstraints {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ITableDefinitionWithConstraints").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ITableDefinitionWithConstraints {
    type Vtable = ITableDefinitionWithConstraints_Vtbl;
}
unsafe impl ::windows::core::Interface for ITableDefinitionWithConstraints {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aab_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ITableDefinitionWithConstraints_Vtbl {
    pub base__: ITableCreation_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub AddConstraint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pconstraintdesc: *mut DBCONSTRAINTDESC) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    AddConstraint: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateTableWithConstraints: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, ccolumndescs: usize, rgcolumndescs: *mut ::core::mem::ManuallyDrop<DBCOLUMNDESC>, cconstraintdescs: u32, rgconstraintdescs: *mut DBCONSTRAINTDESC, riid: *const ::windows::core::GUID, cpropertysets: u32, rgpropertysets: *mut DBPROPSET, pptableid: *mut *mut super::super::Storage::IndexServer::DBID, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateTableWithConstraints: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub DropConstraint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, pconstraintid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    DropConstraint: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ITableRename(::windows::core::IUnknown);
impl ITableRename {
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn RenameColumn(&self, ptableid: *mut super::super::Storage::IndexServer::DBID, poldcolumnid: *mut super::super::Storage::IndexServer::DBID, pnewcolumnid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).RenameColumn)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptableid), ::core::mem::transmute(poldcolumnid), ::core::mem::transmute(pnewcolumnid)).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn RenameTable(&self, poldtableid: *mut super::super::Storage::IndexServer::DBID, poldindexid: *mut super::super::Storage::IndexServer::DBID, pnewtableid: *mut super::super::Storage::IndexServer::DBID, pnewindexid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).RenameTable)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(poldtableid), ::core::mem::transmute(poldindexid), ::core::mem::transmute(pnewtableid), ::core::mem::transmute(pnewindexid)).ok()
    }
}
::windows::core::interface_hierarchy!(ITableRename, ::windows::core::IUnknown);
impl ::core::clone::Clone for ITableRename {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ITableRename {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ITableRename {}
impl ::core::fmt::Debug for ITableRename {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ITableRename").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ITableRename {
    type Vtable = ITableRename_Vtbl;
}
unsafe impl ::windows::core::Interface for ITableRename {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a77_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ITableRename_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub RenameColumn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptableid: *mut super::super::Storage::IndexServer::DBID, poldcolumnid: *mut super::super::Storage::IndexServer::DBID, pnewcolumnid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    RenameColumn: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub RenameTable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, poldtableid: *mut super::super::Storage::IndexServer::DBID, poldindexid: *mut super::super::Storage::IndexServer::DBID, pnewtableid: *mut super::super::Storage::IndexServer::DBID, pnewindexid: *mut super::super::Storage::IndexServer::DBID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    RenameTable: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ITokenCollection(::windows::core::IUnknown);
impl ITokenCollection {
    pub unsafe fn NumberOfTokens(&self, pcount: *const u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).NumberOfTokens)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcount)).ok()
    }
    pub unsafe fn GetToken(&self, i: u32, pbegin: ::core::option::Option<*mut u32>, plength: ::core::option::Option<*mut u32>, ppsz: ::core::option::Option<*mut ::windows::core::PWSTR>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetToken)(::windows::core::Vtable::as_raw(self), i, ::core::mem::transmute(pbegin.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plength.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppsz.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows::core::interface_hierarchy!(ITokenCollection, ::windows::core::IUnknown);
impl ::core::clone::Clone for ITokenCollection {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ITokenCollection {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ITokenCollection {}
impl ::core::fmt::Debug for ITokenCollection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ITokenCollection").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ITokenCollection {
    type Vtable = ITokenCollection_Vtbl;
}
unsafe impl ::windows::core::Interface for ITokenCollection {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x22d8b4f2_f577_4adb_a335_c2ae88416fab);
}
#[repr(C)]
#[doc(hidden)]
pub struct ITokenCollection_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub NumberOfTokens: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcount: *const u32) -> ::windows::core::HRESULT,
    pub GetToken: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, i: u32, pbegin: *mut u32, plength: *mut u32, ppsz: *mut ::windows::core::PWSTR) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ITransactionJoin(::windows::core::IUnknown);
impl ITransactionJoin {
    #[doc = "*Required features: `\"Win32_System_DistributedTransactionCoordinator\"`*"]
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub unsafe fn GetOptionsObject(&self) -> ::windows::core::Result<super::DistributedTransactionCoordinator::ITransactionOptions> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetOptionsObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::DistributedTransactionCoordinator::ITransactionOptions>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_DistributedTransactionCoordinator\"`*"]
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub unsafe fn JoinTransaction<'a, P0, P1>(&self, punktransactioncoord: P0, isolevel: i32, isoflags: u32, potheroptions: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::DistributedTransactionCoordinator::ITransactionOptions>>,
    {
        (::windows::core::Vtable::vtable(self).JoinTransaction)(::windows::core::Vtable::as_raw(self), punktransactioncoord.into().abi(), isolevel, isoflags, potheroptions.into().abi()).ok()
    }
}
::windows::core::interface_hierarchy!(ITransactionJoin, ::windows::core::IUnknown);
impl ::core::clone::Clone for ITransactionJoin {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ITransactionJoin {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ITransactionJoin {}
impl ::core::fmt::Debug for ITransactionJoin {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ITransactionJoin").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ITransactionJoin {
    type Vtable = ITransactionJoin_Vtbl;
}
unsafe impl ::windows::core::Interface for ITransactionJoin {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a5e_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ITransactionJoin_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub GetOptionsObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppoptions: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_DistributedTransactionCoordinator"))]
    GetOptionsObject: usize,
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub JoinTransaction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punktransactioncoord: *mut ::core::ffi::c_void, isolevel: i32, isoflags: u32, potheroptions: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_DistributedTransactionCoordinator"))]
    JoinTransaction: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`, `\"Win32_System_DistributedTransactionCoordinator\"`*"]
#[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
#[repr(transparent)]
pub struct ITransactionLocal(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
impl ITransactionLocal {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_DistributedTransactionCoordinator\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_DistributedTransactionCoordinator"))]
    pub unsafe fn Commit<'a, P0>(&self, fretaining: P0, grftc: u32, grfrm: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.Commit)(::windows::core::Vtable::as_raw(self), fretaining.into(), grftc, grfrm).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_DistributedTransactionCoordinator\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_DistributedTransactionCoordinator"))]
    pub unsafe fn Abort<'a, P0, P1>(&self, pboidreason: *const super::DistributedTransactionCoordinator::BOID, fretaining: P0, fasync: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
        P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).base__.Abort)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pboidreason), fretaining.into(), fasync.into()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_DistributedTransactionCoordinator\"`*"]
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub unsafe fn GetTransactionInfo(&self) -> ::windows::core::Result<super::DistributedTransactionCoordinator::XACTTRANSINFO> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetTransactionInfo)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::DistributedTransactionCoordinator::XACTTRANSINFO>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_DistributedTransactionCoordinator\"`*"]
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub unsafe fn GetOptionsObject(&self) -> ::windows::core::Result<super::DistributedTransactionCoordinator::ITransactionOptions> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetOptionsObject)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::DistributedTransactionCoordinator::ITransactionOptions>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_DistributedTransactionCoordinator\"`*"]
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub unsafe fn StartTransaction<'a, P0>(&self, isolevel: i32, isoflags: u32, potheroptions: P0) -> ::windows::core::Result<u32>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::DistributedTransactionCoordinator::ITransactionOptions>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).StartTransaction)(::windows::core::Vtable::as_raw(self), isolevel, isoflags, potheroptions.into().abi(), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u32>(result__)
    }
}
#[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
::windows::core::interface_hierarchy!(ITransactionLocal, ::windows::core::IUnknown, super::DistributedTransactionCoordinator::ITransaction);
#[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
impl ::core::clone::Clone for ITransactionLocal {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
impl ::core::cmp::PartialEq for ITransactionLocal {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
impl ::core::cmp::Eq for ITransactionLocal {}
#[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
impl ::core::fmt::Debug for ITransactionLocal {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ITransactionLocal").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
unsafe impl ::windows::core::Vtable for ITransactionLocal {
    type Vtable = ITransactionLocal_Vtbl;
}
#[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
unsafe impl ::windows::core::Interface for ITransactionLocal {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a5f_2a1c_11ce_ade5_00aa0044773d);
}
#[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
#[repr(C)]
#[doc(hidden)]
pub struct ITransactionLocal_Vtbl {
    pub base__: super::DistributedTransactionCoordinator::ITransaction_Vtbl,
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub GetOptionsObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppoptions: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_DistributedTransactionCoordinator"))]
    GetOptionsObject: usize,
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub StartTransaction: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, isolevel: i32, isoflags: u32, potheroptions: *mut ::core::ffi::c_void, pultransactionlevel: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_DistributedTransactionCoordinator"))]
    StartTransaction: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ITransactionObject(::windows::core::IUnknown);
impl ITransactionObject {
    #[doc = "*Required features: `\"Win32_System_DistributedTransactionCoordinator\"`*"]
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub unsafe fn GetTransactionObject(&self, ultransactionlevel: u32) -> ::windows::core::Result<super::DistributedTransactionCoordinator::ITransaction> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetTransactionObject)(::windows::core::Vtable::as_raw(self), ultransactionlevel, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::DistributedTransactionCoordinator::ITransaction>(result__)
    }
}
::windows::core::interface_hierarchy!(ITransactionObject, ::windows::core::IUnknown);
impl ::core::clone::Clone for ITransactionObject {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ITransactionObject {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ITransactionObject {}
impl ::core::fmt::Debug for ITransactionObject {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ITransactionObject").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ITransactionObject {
    type Vtable = ITransactionObject_Vtbl;
}
unsafe impl ::windows::core::Interface for ITransactionObject {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a60_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ITransactionObject_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_DistributedTransactionCoordinator")]
    pub GetTransactionObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultransactionlevel: u32, pptransactionobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_DistributedTransactionCoordinator"))]
    GetTransactionObject: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ITrusteeAdmin(::windows::core::IUnknown);
impl ITrusteeAdmin {
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`*"]
    #[cfg(feature = "Win32_Security_Authorization")]
    pub unsafe fn CompareTrustees(&self, ptrustee1: *mut super::super::Security::Authorization::TRUSTEE_W, ptrustee2: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CompareTrustees)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptrustee1), ::core::mem::transmute(ptrustee2)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateTrustee(&self, ptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).CreateTrustee)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptrustee), cpropertysets, ::core::mem::transmute(rgpropertysets)).ok()
    }
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`*"]
    #[cfg(feature = "Win32_Security_Authorization")]
    pub unsafe fn DeleteTrustee(&self, ptrustee: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DeleteTrustee)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptrustee)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn SetTrusteeProperties(&self, ptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetTrusteeProperties)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptrustee), cpropertysets, ::core::mem::transmute(rgpropertysets)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Security_Authorization\"`, `\"Win32_Storage_IndexServer\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetTrusteeProperties(&self, ptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetTrusteeProperties)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptrustee), cpropertyidsets, ::core::mem::transmute(rgpropertyidsets), ::core::mem::transmute(pcpropertysets), ::core::mem::transmute(prgpropertysets)).ok()
    }
}
::windows::core::interface_hierarchy!(ITrusteeAdmin, ::windows::core::IUnknown);
impl ::core::clone::Clone for ITrusteeAdmin {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ITrusteeAdmin {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ITrusteeAdmin {}
impl ::core::fmt::Debug for ITrusteeAdmin {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ITrusteeAdmin").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ITrusteeAdmin {
    type Vtable = ITrusteeAdmin_Vtbl;
}
unsafe impl ::windows::core::Interface for ITrusteeAdmin {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa1_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ITrusteeAdmin_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Security_Authorization")]
    pub CompareTrustees: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptrustee1: *mut super::super::Security::Authorization::TRUSTEE_W, ptrustee2: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Security_Authorization"))]
    CompareTrustees: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CreateTrustee: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CreateTrustee: usize,
    #[cfg(feature = "Win32_Security_Authorization")]
    pub DeleteTrustee: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptrustee: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Security_Authorization"))]
    DeleteTrustee: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub SetTrusteeProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, cpropertysets: u32, rgpropertysets: *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    SetTrusteeProperties: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetTrusteeProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, cpropertyidsets: u32, rgpropertyidsets: *const DBPROPIDSET, pcpropertysets: *mut u32, prgpropertysets: *mut *mut DBPROPSET) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization", feature = "Win32_Storage_IndexServer", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetTrusteeProperties: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct ITrusteeGroupAdmin(::windows::core::IUnknown);
impl ITrusteeGroupAdmin {
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`*"]
    #[cfg(feature = "Win32_Security_Authorization")]
    pub unsafe fn AddMember(&self, pmembershiptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pmembertrustee: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AddMember)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pmembershiptrustee), ::core::mem::transmute(pmembertrustee)).ok()
    }
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`*"]
    #[cfg(feature = "Win32_Security_Authorization")]
    pub unsafe fn DeleteMember(&self, pmembershiptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pmembertrustee: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).DeleteMember)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pmembershiptrustee), ::core::mem::transmute(pmembertrustee)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Security_Authorization\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization"))]
    pub unsafe fn IsMember(&self, pmembershiptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pmembertrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pfstatus: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).IsMember)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pmembershiptrustee), ::core::mem::transmute(pmembertrustee), ::core::mem::transmute(pfstatus)).ok()
    }
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`*"]
    #[cfg(feature = "Win32_Security_Authorization")]
    pub unsafe fn GetMembers(&self, pmembershiptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pcmembers: *mut u32, prgmembers: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetMembers)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pmembershiptrustee), ::core::mem::transmute(pcmembers), ::core::mem::transmute(prgmembers)).ok()
    }
    #[doc = "*Required features: `\"Win32_Security_Authorization\"`*"]
    #[cfg(feature = "Win32_Security_Authorization")]
    pub unsafe fn GetMemberships(&self, ptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pcmemberships: *mut u32, prgmemberships: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetMemberships)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptrustee), ::core::mem::transmute(pcmemberships), ::core::mem::transmute(prgmemberships)).ok()
    }
}
::windows::core::interface_hierarchy!(ITrusteeGroupAdmin, ::windows::core::IUnknown);
impl ::core::clone::Clone for ITrusteeGroupAdmin {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ITrusteeGroupAdmin {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ITrusteeGroupAdmin {}
impl ::core::fmt::Debug for ITrusteeGroupAdmin {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ITrusteeGroupAdmin").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for ITrusteeGroupAdmin {
    type Vtable = ITrusteeGroupAdmin_Vtbl;
}
unsafe impl ::windows::core::Interface for ITrusteeGroupAdmin {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733aa2_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ITrusteeGroupAdmin_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Security_Authorization")]
    pub AddMember: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmembershiptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pmembertrustee: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Security_Authorization"))]
    AddMember: usize,
    #[cfg(feature = "Win32_Security_Authorization")]
    pub DeleteMember: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmembershiptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pmembertrustee: *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Security_Authorization"))]
    DeleteMember: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization"))]
    pub IsMember: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmembershiptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pmembertrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pfstatus: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security_Authorization")))]
    IsMember: usize,
    #[cfg(feature = "Win32_Security_Authorization")]
    pub GetMembers: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmembershiptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pcmembers: *mut u32, prgmembers: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Security_Authorization"))]
    GetMembers: usize,
    #[cfg(feature = "Win32_Security_Authorization")]
    pub GetMemberships: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptrustee: *mut super::super::Security::Authorization::TRUSTEE_W, pcmemberships: *mut u32, prgmemberships: *mut *mut super::super::Security::Authorization::TRUSTEE_W) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Security_Authorization"))]
    GetMemberships: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IUMS(::std::ptr::NonNull<::std::ffi::c_void>);
impl IUMS {
    pub unsafe fn SqlUmsSuspend(&self, ticks: u32) {
        (::windows::core::Vtable::vtable(self).SqlUmsSuspend)(::windows::core::Vtable::as_raw(self), ticks)
    }
    pub unsafe fn SqlUmsYield(&self, ticks: u32) {
        (::windows::core::Vtable::vtable(self).SqlUmsYield)(::windows::core::Vtable::as_raw(self), ticks)
    }
    pub unsafe fn SqlUmsSwitchPremptive(&self) {
        (::windows::core::Vtable::vtable(self).SqlUmsSwitchPremptive)(::windows::core::Vtable::as_raw(self))
    }
    pub unsafe fn SqlUmsSwitchNonPremptive(&self) {
        (::windows::core::Vtable::vtable(self).SqlUmsSwitchNonPremptive)(::windows::core::Vtable::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SqlUmsFIsPremptive(&self) -> super::super::Foundation::BOOL {
        (::windows::core::Vtable::vtable(self).SqlUmsFIsPremptive)(::windows::core::Vtable::as_raw(self))
    }
}
impl ::core::clone::Clone for IUMS {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IUMS {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IUMS {}
impl ::core::fmt::Debug for IUMS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IUMS").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IUMS {
    type Vtable = IUMS_Vtbl;
}
#[repr(C)]
#[doc(hidden)]
pub struct IUMS_Vtbl {
    pub SqlUmsSuspend: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ticks: u32),
    pub SqlUmsYield: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ticks: u32),
    pub SqlUmsSwitchPremptive: unsafe extern "system" fn(this: *mut ::core::ffi::c_void),
    pub SqlUmsSwitchNonPremptive: unsafe extern "system" fn(this: *mut ::core::ffi::c_void),
    #[cfg(feature = "Win32_Foundation")]
    pub SqlUmsFIsPremptive: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))]
    SqlUmsFIsPremptive: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IUMSInitialize(::windows::core::IUnknown);
impl IUMSInitialize {
    pub unsafe fn Initialize(&self, pums: *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).Initialize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pums)).ok()
    }
}
::windows::core::interface_hierarchy!(IUMSInitialize, ::windows::core::IUnknown);
impl ::core::clone::Clone for IUMSInitialize {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IUMSInitialize {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IUMSInitialize {}
impl ::core::fmt::Debug for IUMSInitialize {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IUMSInitialize").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IUMSInitialize {
    type Vtable = IUMSInitialize_Vtbl;
}
unsafe impl ::windows::core::Interface for IUMSInitialize {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca14_ef21_11d0_97e7_00c04fc2ad98);
}
#[repr(C)]
#[doc(hidden)]
pub struct IUMSInitialize_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pums: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IUrlAccessor(::windows::core::IUnknown);
impl IUrlAccessor {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn AddRequestParameter(&self, pspec: *const super::Com::StructuredStorage::PROPSPEC, pvar: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).AddRequestParameter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pspec), ::core::mem::transmute(pvar)).ok()
    }
    pub unsafe fn GetDocFormat(&self, wszdocformat: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetDocFormat)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszdocformat), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetCLSID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetCLSID)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    pub unsafe fn GetHost(&self, wszhost: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetHost)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszhost), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn IsDirectory(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).IsDirectory)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetSize(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLastModified(&self) -> ::windows::core::Result<super::super::Foundation::FILETIME> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetLastModified)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::FILETIME>(result__)
    }
    pub unsafe fn GetFileName(&self, wszfilename: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetFileName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszfilename), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetSecurityDescriptor(&self, psd: &mut [u8], pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetSecurityDescriptor)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(psd.as_ptr()), psd.len() as _, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetRedirectedURL(&self, wszredirectedurl: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetRedirectedURL)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszredirectedurl), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetSecurityProvider(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSecurityProvider)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn BindToStream(&self) -> ::windows::core::Result<super::Com::IStream> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).BindToStream)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::IStream>(result__)
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn BindToFilter(&self) -> ::windows::core::Result<super::super::Storage::IndexServer::IFilter> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).BindToFilter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Storage::IndexServer::IFilter>(result__)
    }
}
::windows::core::interface_hierarchy!(IUrlAccessor, ::windows::core::IUnknown);
impl ::core::clone::Clone for IUrlAccessor {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IUrlAccessor {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IUrlAccessor {}
impl ::core::fmt::Debug for IUrlAccessor {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IUrlAccessor").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IUrlAccessor {
    type Vtable = IUrlAccessor_Vtbl;
}
unsafe impl ::windows::core::Interface for IUrlAccessor {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b63e318_9ccc_11d0_bcdb_00805fccce04);
}
#[repr(C)]
#[doc(hidden)]
pub struct IUrlAccessor_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub AddRequestParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pspec: *const super::Com::StructuredStorage::PROPSPEC, pvar: *const ::core::mem::ManuallyDrop<super::Com::StructuredStorage::PROPVARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    AddRequestParameter: usize,
    pub GetDocFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wszdocformat: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::HRESULT,
    pub GetCLSID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclsid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub GetHost: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wszhost: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::HRESULT,
    pub IsDirectory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pllsize: *mut u64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetLastModified: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pftlastmodified: *mut super::super::Foundation::FILETIME) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetLastModified: usize,
    pub GetFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wszfilename: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::HRESULT,
    pub GetSecurityDescriptor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psd: *mut u8, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::HRESULT,
    pub GetRedirectedURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wszredirectedurl: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::HRESULT,
    pub GetSecurityProvider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pspclsid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub BindToStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppstream: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    BindToStream: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub BindToFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfilter: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    BindToFilter: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IUrlAccessor2(::windows::core::IUnknown);
impl IUrlAccessor2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn AddRequestParameter(&self, pspec: *const super::Com::StructuredStorage::PROPSPEC, pvar: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.AddRequestParameter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pspec), ::core::mem::transmute(pvar)).ok()
    }
    pub unsafe fn GetDocFormat(&self, wszdocformat: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetDocFormat)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszdocformat), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetCLSID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetCLSID)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    pub unsafe fn GetHost(&self, wszhost: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetHost)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszhost), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn IsDirectory(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.IsDirectory)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetSize(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetSize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLastModified(&self) -> ::windows::core::Result<super::super::Foundation::FILETIME> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetLastModified)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::FILETIME>(result__)
    }
    pub unsafe fn GetFileName(&self, wszfilename: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetFileName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszfilename), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetSecurityDescriptor(&self, psd: &mut [u8], pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetSecurityDescriptor)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(psd.as_ptr()), psd.len() as _, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetRedirectedURL(&self, wszredirectedurl: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetRedirectedURL)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszredirectedurl), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetSecurityProvider(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.GetSecurityProvider)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn BindToStream(&self) -> ::windows::core::Result<super::Com::IStream> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.BindToStream)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::IStream>(result__)
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn BindToFilter(&self) -> ::windows::core::Result<super::super::Storage::IndexServer::IFilter> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.BindToFilter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Storage::IndexServer::IFilter>(result__)
    }
    pub unsafe fn GetDisplayUrl(&self, wszdocurl: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetDisplayUrl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszdocurl), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn IsDocument(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).IsDocument)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetCodePage(&self, wszcodepage: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetCodePage)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszcodepage), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
}
::windows::core::interface_hierarchy!(IUrlAccessor2, ::windows::core::IUnknown, IUrlAccessor);
impl ::core::clone::Clone for IUrlAccessor2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IUrlAccessor2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IUrlAccessor2 {}
impl ::core::fmt::Debug for IUrlAccessor2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IUrlAccessor2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IUrlAccessor2 {
    type Vtable = IUrlAccessor2_Vtbl;
}
unsafe impl ::windows::core::Interface for IUrlAccessor2 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc7310734_ac80_11d1_8df3_00c04fb6ef4f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IUrlAccessor2_Vtbl {
    pub base__: IUrlAccessor_Vtbl,
    pub GetDisplayUrl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wszdocurl: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::HRESULT,
    pub IsDocument: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub GetCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wszcodepage: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IUrlAccessor3(::windows::core::IUnknown);
impl IUrlAccessor3 {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn AddRequestParameter(&self, pspec: *const super::Com::StructuredStorage::PROPSPEC, pvar: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.AddRequestParameter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pspec), ::core::mem::transmute(pvar)).ok()
    }
    pub unsafe fn GetDocFormat(&self, wszdocformat: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetDocFormat)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszdocformat), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetCLSID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetCLSID)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    pub unsafe fn GetHost(&self, wszhost: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetHost)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszhost), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn IsDirectory(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.IsDirectory)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetSize(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetSize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLastModified(&self) -> ::windows::core::Result<super::super::Foundation::FILETIME> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetLastModified)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::FILETIME>(result__)
    }
    pub unsafe fn GetFileName(&self, wszfilename: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetFileName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszfilename), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetSecurityDescriptor(&self, psd: &mut [u8], pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetSecurityDescriptor)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(psd.as_ptr()), psd.len() as _, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetRedirectedURL(&self, wszredirectedurl: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetRedirectedURL)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszredirectedurl), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetSecurityProvider(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.GetSecurityProvider)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn BindToStream(&self) -> ::windows::core::Result<super::Com::IStream> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.BindToStream)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::IStream>(result__)
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn BindToFilter(&self) -> ::windows::core::Result<super::super::Storage::IndexServer::IFilter> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.BindToFilter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Storage::IndexServer::IFilter>(result__)
    }
    pub unsafe fn GetDisplayUrl(&self, wszdocurl: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetDisplayUrl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszdocurl), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn IsDocument(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.IsDocument)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetCodePage(&self, wszcodepage: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.GetCodePage)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszcodepage), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetImpersonationSidBlobs<'a, P0>(&self, pcwszurl: P0, pcsidcount: *mut u32, ppsidblobs: *mut *mut super::Com::BLOB) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).GetImpersonationSidBlobs)(::windows::core::Vtable::as_raw(self), pcwszurl.into(), ::core::mem::transmute(pcsidcount), ::core::mem::transmute(ppsidblobs)).ok()
    }
}
::windows::core::interface_hierarchy!(IUrlAccessor3, ::windows::core::IUnknown, IUrlAccessor, IUrlAccessor2);
impl ::core::clone::Clone for IUrlAccessor3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IUrlAccessor3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IUrlAccessor3 {}
impl ::core::fmt::Debug for IUrlAccessor3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IUrlAccessor3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IUrlAccessor3 {
    type Vtable = IUrlAccessor3_Vtbl;
}
unsafe impl ::windows::core::Interface for IUrlAccessor3 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6fbc7005_0455_4874_b8ff_7439450241a3);
}
#[repr(C)]
#[doc(hidden)]
pub struct IUrlAccessor3_Vtbl {
    pub base__: IUrlAccessor2_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub GetImpersonationSidBlobs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcwszurl: ::windows::core::PCWSTR, pcsidcount: *mut u32, ppsidblobs: *mut *mut super::Com::BLOB) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetImpersonationSidBlobs: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IUrlAccessor4(::windows::core::IUnknown);
impl IUrlAccessor4 {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn AddRequestParameter(&self, pspec: *const super::Com::StructuredStorage::PROPSPEC, pvar: *const super::Com::StructuredStorage::PROPVARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.AddRequestParameter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pspec), ::core::mem::transmute(pvar)).ok()
    }
    pub unsafe fn GetDocFormat(&self, wszdocformat: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetDocFormat)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszdocformat), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetCLSID(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetCLSID)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    pub unsafe fn GetHost(&self, wszhost: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetHost)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszhost), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn IsDirectory(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.IsDirectory)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetSize(&self) -> ::windows::core::Result<u64> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetSize)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<u64>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLastModified(&self) -> ::windows::core::Result<super::super::Foundation::FILETIME> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetLastModified)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::FILETIME>(result__)
    }
    pub unsafe fn GetFileName(&self, wszfilename: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetFileName)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszfilename), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetSecurityDescriptor(&self, psd: &mut [u8], pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetSecurityDescriptor)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(psd.as_ptr()), psd.len() as _, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetRedirectedURL(&self, wszredirectedurl: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetRedirectedURL)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszredirectedurl), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn GetSecurityProvider(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.GetSecurityProvider)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn BindToStream(&self) -> ::windows::core::Result<super::Com::IStream> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.BindToStream)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::IStream>(result__)
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn BindToFilter(&self) -> ::windows::core::Result<super::super::Storage::IndexServer::IFilter> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).base__.base__.base__.BindToFilter)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Storage::IndexServer::IFilter>(result__)
    }
    pub unsafe fn GetDisplayUrl(&self, wszdocurl: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetDisplayUrl)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszdocurl), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    pub unsafe fn IsDocument(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.IsDocument)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn GetCodePage(&self, wszcodepage: ::windows::core::PWSTR, dwsize: u32, pdwlength: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).base__.base__.GetCodePage)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(wszcodepage), dwsize, ::core::mem::transmute(pdwlength)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetImpersonationSidBlobs<'a, P0>(&self, pcwszurl: P0, pcsidcount: *mut u32, ppsidblobs: *mut *mut super::Com::BLOB) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).base__.GetImpersonationSidBlobs)(::windows::core::Vtable::as_raw(self), pcwszurl.into(), ::core::mem::transmute(pcsidcount), ::core::mem::transmute(ppsidblobs)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShouldIndexItemContent(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ShouldIndexItemContent)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_Shell_PropertiesSystem\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn ShouldIndexProperty(&self, key: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).ShouldIndexProperty)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(key), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
::windows::core::interface_hierarchy!(IUrlAccessor4, ::windows::core::IUnknown, IUrlAccessor, IUrlAccessor2, IUrlAccessor3);
impl ::core::clone::Clone for IUrlAccessor4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IUrlAccessor4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IUrlAccessor4 {}
impl ::core::fmt::Debug for IUrlAccessor4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IUrlAccessor4").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IUrlAccessor4 {
    type Vtable = IUrlAccessor4_Vtbl;
}
unsafe impl ::windows::core::Interface for IUrlAccessor4 {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cc51041_c8d2_41d7_bca3_9e9e286297dc);
}
#[repr(C)]
#[doc(hidden)]
pub struct IUrlAccessor4_Vtbl {
    pub base__: IUrlAccessor3_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub ShouldIndexItemContent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfindexcontent: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ShouldIndexItemContent: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub ShouldIndexProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, key: *const super::super::UI::Shell::PropertiesSystem::PROPERTYKEY, pfindexproperty: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_PropertiesSystem")))]
    ShouldIndexProperty: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IViewChapter(::windows::core::IUnknown);
impl IViewChapter {
    pub unsafe fn GetSpecification(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSpecification)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn OpenViewChapter(&self, hsource: usize) -> ::windows::core::Result<usize> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).OpenViewChapter)(::windows::core::Vtable::as_raw(self), hsource, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<usize>(result__)
    }
}
::windows::core::interface_hierarchy!(IViewChapter, ::windows::core::IUnknown);
impl ::core::clone::Clone for IViewChapter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IViewChapter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IViewChapter {}
impl ::core::fmt::Debug for IViewChapter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IViewChapter").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IViewChapter {
    type Vtable = IViewChapter_Vtbl;
}
unsafe impl ::windows::core::Interface for IViewChapter {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a98_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IViewChapter_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetSpecification: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub OpenViewChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hsource: usize, phviewchapter: *mut usize) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IViewFilter(::windows::core::IUnknown);
impl IViewFilter {
    pub unsafe fn GetFilter<'a, P0>(&self, haccessor: P0, pcrows: *mut usize, pcompareops: *mut *mut u32, pcriteriadata: *mut ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).GetFilter)(::windows::core::Vtable::as_raw(self), haccessor.into(), ::core::mem::transmute(pcrows), ::core::mem::transmute(pcompareops), ::core::mem::transmute(pcriteriadata)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFilterBindings(&self, pcbindings: *mut usize, prgbindings: ::core::option::Option<*mut *mut DBBINDING>) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetFilterBindings)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcbindings), ::core::mem::transmute(prgbindings.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetFilter<'a, P0>(&self, haccessor: P0, compareops: &[u32], pcriteriadata: *const ::core::ffi::c_void) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<HACCESSOR>,
    {
        (::windows::core::Vtable::vtable(self).SetFilter)(::windows::core::Vtable::as_raw(self), haccessor.into(), compareops.len() as _, ::core::mem::transmute(compareops.as_ptr()), ::core::mem::transmute(pcriteriadata)).ok()
    }
}
::windows::core::interface_hierarchy!(IViewFilter, ::windows::core::IUnknown);
impl ::core::clone::Clone for IViewFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IViewFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IViewFilter {}
impl ::core::fmt::Debug for IViewFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IViewFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IViewFilter {
    type Vtable = IViewFilter_Vtbl;
}
unsafe impl ::windows::core::Interface for IViewFilter {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a9b_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IViewFilter_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: HACCESSOR, pcrows: *mut usize, pcompareops: *mut *mut u32, pcriteriadata: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetFilterBindings: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcbindings: *mut usize, prgbindings: *mut *mut ::core::mem::ManuallyDrop<DBBINDING>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetFilterBindings: usize,
    pub SetFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, haccessor: HACCESSOR, crows: usize, compareops: *const u32, pcriteriadata: *const ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IViewRowset(::windows::core::IUnknown);
impl IViewRowset {
    pub unsafe fn GetSpecification(&self, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).GetSpecification)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn OpenViewRowset<'a, P0>(&self, punkouter: P0, riid: *const ::windows::core::GUID) -> ::windows::core::Result<::windows::core::IUnknown>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, ::windows::core::IUnknown>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).OpenViewRowset)(::windows::core::Vtable::as_raw(self), punkouter.into().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::IUnknown>(result__)
    }
}
::windows::core::interface_hierarchy!(IViewRowset, ::windows::core::IUnknown);
impl ::core::clone::Clone for IViewRowset {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IViewRowset {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IViewRowset {}
impl ::core::fmt::Debug for IViewRowset {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IViewRowset").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IViewRowset {
    type Vtable = IViewRowset_Vtbl;
}
unsafe impl ::windows::core::Interface for IViewRowset {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a97_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IViewRowset_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetSpecification: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppobject: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub OpenViewRowset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, pprowset: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IViewSort(::windows::core::IUnknown);
impl IViewSort {
    pub unsafe fn GetSortOrder(&self, pcvalues: *mut usize, prgcolumns: *mut *mut usize, prgorders: *mut *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetSortOrder)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(pcvalues), ::core::mem::transmute(prgcolumns), ::core::mem::transmute(prgorders)).ok()
    }
    pub unsafe fn SetSortOrder(&self, cvalues: usize, rgcolumns: *const usize, rgorders: *const u32) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).SetSortOrder)(::windows::core::Vtable::as_raw(self), cvalues, ::core::mem::transmute(rgcolumns), ::core::mem::transmute(rgorders)).ok()
    }
}
::windows::core::interface_hierarchy!(IViewSort, ::windows::core::IUnknown);
impl ::core::clone::Clone for IViewSort {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IViewSort {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IViewSort {}
impl ::core::fmt::Debug for IViewSort {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IViewSort").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IViewSort {
    type Vtable = IViewSort_Vtbl;
}
unsafe impl ::windows::core::Interface for IViewSort {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c733a9a_2a1c_11ce_ade5_00aa0044773d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IViewSort_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub GetSortOrder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcvalues: *mut usize, prgcolumns: *mut *mut usize, prgorders: *mut *mut u32) -> ::windows::core::HRESULT,
    pub SetSortOrder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cvalues: usize, rgcolumns: *const usize, rgorders: *const u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IWordBreaker(::windows::core::IUnknown);
impl IWordBreaker {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<'a, P0>(&self, fquery: P0, ulmaxtokensize: u32, pflicense: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<super::super::Foundation::BOOL>,
    {
        (::windows::core::Vtable::vtable(self).Init)(::windows::core::Vtable::as_raw(self), fquery.into(), ulmaxtokensize, ::core::mem::transmute(pflicense)).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn BreakText<'a, P0, P1>(&self, ptextsource: *mut TEXT_SOURCE, pwordsink: P0, pphrasesink: P1) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, IWordSink>>,
        P1: ::std::convert::Into<::windows::core::InParam<'a, super::super::Storage::IndexServer::IPhraseSink>>,
    {
        (::windows::core::Vtable::vtable(self).BreakText)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ptextsource), pwordsink.into().abi(), pphrasesink.into().abi()).ok()
    }
    pub unsafe fn ComposePhrase<'a, P0, P1, P2>(&self, pwcnoun: P0, cwcnoun: u32, pwcmodifier: P1, cwcmodifier: u32, ulattachmenttype: u32, pwcphrase: P2, pcwcphrase: *mut u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
        P1: ::std::convert::Into<::windows::core::PCWSTR>,
        P2: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).ComposePhrase)(::windows::core::Vtable::as_raw(self), pwcnoun.into(), cwcnoun, pwcmodifier.into(), cwcmodifier, ulattachmenttype, pwcphrase.into(), ::core::mem::transmute(pcwcphrase)).ok()
    }
    pub unsafe fn GetLicenseToUse(&self, ppwcslicense: *const *const u16) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).GetLicenseToUse)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(ppwcslicense)).ok()
    }
}
::windows::core::interface_hierarchy!(IWordBreaker, ::windows::core::IUnknown);
impl ::core::clone::Clone for IWordBreaker {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IWordBreaker {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IWordBreaker {}
impl ::core::fmt::Debug for IWordBreaker {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IWordBreaker").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IWordBreaker {
    type Vtable = IWordBreaker_Vtbl;
}
unsafe impl ::windows::core::Interface for IWordBreaker {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd53552c8_77e3_101a_b552_08002b33b0e6);
}
#[repr(C)]
#[doc(hidden)]
pub struct IWordBreaker_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Init: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fquery: super::super::Foundation::BOOL, ulmaxtokensize: u32, pflicense: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Init: usize,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub BreakText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptextsource: *mut TEXT_SOURCE, pwordsink: *mut ::core::ffi::c_void, pphrasesink: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    BreakText: usize,
    pub ComposePhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwcnoun: ::windows::core::PCWSTR, cwcnoun: u32, pwcmodifier: ::windows::core::PCWSTR, cwcmodifier: u32, ulattachmenttype: u32, pwcphrase: ::windows::core::PCWSTR, pcwcphrase: *mut u32) -> ::windows::core::HRESULT,
    pub GetLicenseToUse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppwcslicense: *const *const u16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IWordFormSink(::windows::core::IUnknown);
impl IWordFormSink {
    pub unsafe fn PutAltWord<'a, P0>(&self, pwcinbuf: P0, cwc: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).PutAltWord)(::windows::core::Vtable::as_raw(self), pwcinbuf.into(), cwc).ok()
    }
    pub unsafe fn PutWord<'a, P0>(&self, pwcinbuf: P0, cwc: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).PutWord)(::windows::core::Vtable::as_raw(self), pwcinbuf.into(), cwc).ok()
    }
}
::windows::core::interface_hierarchy!(IWordFormSink, ::windows::core::IUnknown);
impl ::core::clone::Clone for IWordFormSink {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IWordFormSink {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IWordFormSink {}
impl ::core::fmt::Debug for IWordFormSink {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IWordFormSink").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IWordFormSink {
    type Vtable = IWordFormSink_Vtbl;
}
unsafe impl ::windows::core::Interface for IWordFormSink {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfe77c330_7f42_11ce_be57_00aa0051fe20);
}
#[repr(C)]
#[doc(hidden)]
pub struct IWordFormSink_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub PutAltWord: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwcinbuf: ::windows::core::PCWSTR, cwc: u32) -> ::windows::core::HRESULT,
    pub PutWord: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwcinbuf: ::windows::core::PCWSTR, cwc: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct IWordSink(::windows::core::IUnknown);
impl IWordSink {
    pub unsafe fn PutWord<'a, P0>(&self, cwc: u32, pwcinbuf: P0, cwcsrclen: u32, cwcsrcpos: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).PutWord)(::windows::core::Vtable::as_raw(self), cwc, pwcinbuf.into(), cwcsrclen, cwcsrcpos).ok()
    }
    pub unsafe fn PutAltWord<'a, P0>(&self, cwc: u32, pwcinbuf: P0, cwcsrclen: u32, cwcsrcpos: u32) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::PCWSTR>,
    {
        (::windows::core::Vtable::vtable(self).PutAltWord)(::windows::core::Vtable::as_raw(self), cwc, pwcinbuf.into(), cwcsrclen, cwcsrcpos).ok()
    }
    pub unsafe fn StartAltPhrase(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).StartAltPhrase)(::windows::core::Vtable::as_raw(self)).ok()
    }
    pub unsafe fn EndAltPhrase(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).EndAltPhrase)(::windows::core::Vtable::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Storage_IndexServer\"`*"]
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub unsafe fn PutBreak(&self, breaktype: super::super::Storage::IndexServer::WORDREP_BREAK_TYPE) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).PutBreak)(::windows::core::Vtable::as_raw(self), breaktype).ok()
    }
}
::windows::core::interface_hierarchy!(IWordSink, ::windows::core::IUnknown);
impl ::core::clone::Clone for IWordSink {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IWordSink {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IWordSink {}
impl ::core::fmt::Debug for IWordSink {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IWordSink").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for IWordSink {
    type Vtable = IWordSink_Vtbl;
}
unsafe impl ::windows::core::Interface for IWordSink {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcc907054_c058_101a_b554_08002b33b0e6);
}
#[repr(C)]
#[doc(hidden)]
pub struct IWordSink_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub PutWord: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cwc: u32, pwcinbuf: ::windows::core::PCWSTR, cwcsrclen: u32, cwcsrcpos: u32) -> ::windows::core::HRESULT,
    pub PutAltWord: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cwc: u32, pwcinbuf: ::windows::core::PCWSTR, cwcsrclen: u32, cwcsrcpos: u32) -> ::windows::core::HRESULT,
    pub StartAltPhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndAltPhrase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Storage_IndexServer")]
    pub PutBreak: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, breaktype: super::super::Storage::IndexServer::WORDREP_BREAK_TYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Storage_IndexServer"))]
    PutBreak: usize,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct OLEDBSimpleProvider(::windows::core::IUnknown);
impl OLEDBSimpleProvider {
    pub unsafe fn getRowCount(&self) -> ::windows::core::Result<isize> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).getRowCount)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<isize>(result__)
    }
    pub unsafe fn getColumnCount(&self) -> ::windows::core::Result<isize> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).getColumnCount)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<isize>(result__)
    }
    pub unsafe fn getRWStatus(&self, irow: isize, icolumn: isize) -> ::windows::core::Result<OSPRW> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).getRWStatus)(::windows::core::Vtable::as_raw(self), irow, icolumn, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<OSPRW>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn getVariant(&self, irow: isize, icolumn: isize, format: OSPFORMAT) -> ::windows::core::Result<super::Com::VARIANT> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).getVariant)(::windows::core::Vtable::as_raw(self), irow, icolumn, format, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn setVariant<'a, P0>(&self, irow: isize, icolumn: isize, format: OSPFORMAT, var: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::VARIANT>>,
    {
        (::windows::core::Vtable::vtable(self).setVariant)(::windows::core::Vtable::as_raw(self), irow, icolumn, format, var.into().abi()).ok()
    }
    pub unsafe fn getLocale(&self) -> ::windows::core::Result<::windows::core::BSTR> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).getLocale)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<::windows::core::BSTR>(result__)
    }
    pub unsafe fn deleteRows(&self, irow: isize, crows: isize) -> ::windows::core::Result<isize> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).deleteRows)(::windows::core::Vtable::as_raw(self), irow, crows, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<isize>(result__)
    }
    pub unsafe fn insertRows(&self, irow: isize, crows: isize) -> ::windows::core::Result<isize> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).insertRows)(::windows::core::Vtable::as_raw(self), irow, crows, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<isize>(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn find<'a, P0>(&self, irowstart: isize, icolumn: isize, val: P0, findflags: OSPFIND, comptype: OSPCOMP) -> ::windows::core::Result<isize>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, super::Com::VARIANT>>,
    {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).find)(::windows::core::Vtable::as_raw(self), irowstart, icolumn, val.into().abi(), findflags, comptype, ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<isize>(result__)
    }
    pub unsafe fn addOLEDBSimpleProviderListener<'a, P0>(&self, pospilistener: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, OLEDBSimpleProviderListener>>,
    {
        (::windows::core::Vtable::vtable(self).addOLEDBSimpleProviderListener)(::windows::core::Vtable::as_raw(self), pospilistener.into().abi()).ok()
    }
    pub unsafe fn removeOLEDBSimpleProviderListener<'a, P0>(&self, pospilistener: P0) -> ::windows::core::Result<()>
    where
        P0: ::std::convert::Into<::windows::core::InParam<'a, OLEDBSimpleProviderListener>>,
    {
        (::windows::core::Vtable::vtable(self).removeOLEDBSimpleProviderListener)(::windows::core::Vtable::as_raw(self), pospilistener.into().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn isAsync(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).isAsync)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn getEstimatedRows(&self) -> ::windows::core::Result<isize> {
        let mut result__ = ::core::mem::MaybeUninit::zeroed();
        (::windows::core::Vtable::vtable(self).getEstimatedRows)(::windows::core::Vtable::as_raw(self), ::core::mem::transmute(result__.as_mut_ptr())).from_abi::<isize>(result__)
    }
    pub unsafe fn stopTransfer(&self) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).stopTransfer)(::windows::core::Vtable::as_raw(self)).ok()
    }
}
::windows::core::interface_hierarchy!(OLEDBSimpleProvider, ::windows::core::IUnknown);
impl ::core::clone::Clone for OLEDBSimpleProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for OLEDBSimpleProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for OLEDBSimpleProvider {}
impl ::core::fmt::Debug for OLEDBSimpleProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("OLEDBSimpleProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for OLEDBSimpleProvider {
    type Vtable = OLEDBSimpleProvider_Vtbl;
}
unsafe impl ::windows::core::Interface for OLEDBSimpleProvider {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe0e270c0_c0be_11d0_8fe4_00a0c90a6341);
}
#[repr(C)]
#[doc(hidden)]
pub struct OLEDBSimpleProvider_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub getRowCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcrows: *mut isize) -> ::windows::core::HRESULT,
    pub getColumnCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pccolumns: *mut isize) -> ::windows::core::HRESULT,
    pub getRWStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, icolumn: isize, prwstatus: *mut OSPRW) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub getVariant: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, icolumn: isize, format: OSPFORMAT, pvar: *mut ::core::mem::ManuallyDrop<super::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    getVariant: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub setVariant: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, icolumn: isize, format: OSPFORMAT, var: ::core::mem::ManuallyDrop<super::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    setVariant: usize,
    pub getLocale: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrlocale: *mut ::core::mem::ManuallyDrop<::windows::core::BSTR>) -> ::windows::core::HRESULT,
    pub deleteRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, crows: isize, pcrowsdeleted: *mut isize) -> ::windows::core::HRESULT,
    pub insertRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, crows: isize, pcrowsinserted: *mut isize) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub find: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irowstart: isize, icolumn: isize, val: ::core::mem::ManuallyDrop<super::Com::VARIANT>, findflags: OSPFIND, comptype: OSPCOMP, pirowfound: *mut isize) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    find: usize,
    pub addOLEDBSimpleProviderListener: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pospilistener: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub removeOLEDBSimpleProviderListener: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pospilistener: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub isAsync: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbasynch: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    isAsync: usize,
    pub getEstimatedRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pirows: *mut isize) -> ::windows::core::HRESULT,
    pub stopTransfer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
#[repr(transparent)]
pub struct OLEDBSimpleProviderListener(::windows::core::IUnknown);
impl OLEDBSimpleProviderListener {
    pub unsafe fn aboutToChangeCell(&self, irow: isize, icolumn: isize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).aboutToChangeCell)(::windows::core::Vtable::as_raw(self), irow, icolumn).ok()
    }
    pub unsafe fn cellChanged(&self, irow: isize, icolumn: isize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).cellChanged)(::windows::core::Vtable::as_raw(self), irow, icolumn).ok()
    }
    pub unsafe fn aboutToDeleteRows(&self, irow: isize, crows: isize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).aboutToDeleteRows)(::windows::core::Vtable::as_raw(self), irow, crows).ok()
    }
    pub unsafe fn deletedRows(&self, irow: isize, crows: isize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).deletedRows)(::windows::core::Vtable::as_raw(self), irow, crows).ok()
    }
    pub unsafe fn aboutToInsertRows(&self, irow: isize, crows: isize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).aboutToInsertRows)(::windows::core::Vtable::as_raw(self), irow, crows).ok()
    }
    pub unsafe fn insertedRows(&self, irow: isize, crows: isize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).insertedRows)(::windows::core::Vtable::as_raw(self), irow, crows).ok()
    }
    pub unsafe fn rowsAvailable(&self, irow: isize, crows: isize) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).rowsAvailable)(::windows::core::Vtable::as_raw(self), irow, crows).ok()
    }
    pub unsafe fn transferComplete(&self, xfer: OSPXFER) -> ::windows::core::Result<()> {
        (::windows::core::Vtable::vtable(self).transferComplete)(::windows::core::Vtable::as_raw(self), xfer).ok()
    }
}
::windows::core::interface_hierarchy!(OLEDBSimpleProviderListener, ::windows::core::IUnknown);
impl ::core::clone::Clone for OLEDBSimpleProviderListener {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for OLEDBSimpleProviderListener {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for OLEDBSimpleProviderListener {}
impl ::core::fmt::Debug for OLEDBSimpleProviderListener {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("OLEDBSimpleProviderListener").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Vtable for OLEDBSimpleProviderListener {
    type Vtable = OLEDBSimpleProviderListener_Vtbl;
}
unsafe impl ::windows::core::Interface for OLEDBSimpleProviderListener {
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe0e270c1_c0be_11d0_8fe4_00a0c90a6341);
}
#[repr(C)]
#[doc(hidden)]
pub struct OLEDBSimpleProviderListener_Vtbl {
    pub base__: ::windows::core::IUnknown_Vtbl,
    pub aboutToChangeCell: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, icolumn: isize) -> ::windows::core::HRESULT,
    pub cellChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, icolumn: isize) -> ::windows::core::HRESULT,
    pub aboutToDeleteRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, crows: isize) -> ::windows::core::HRESULT,
    pub deletedRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, crows: isize) -> ::windows::core::HRESULT,
    pub aboutToInsertRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, crows: isize) -> ::windows::core::HRESULT,
    pub insertedRows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, crows: isize) -> ::windows::core::HRESULT,
    pub rowsAvailable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, irow: isize, crows: isize) -> ::windows::core::HRESULT,
    pub transferComplete: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, xfer: OSPXFER) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP6xFILEFMT: u32 = 9u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPABORT: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPBATCH: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFILECP: u32 = 12u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFILECP_ACP: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFILECP_OEMCP: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFILECP_RAW: i32 = -1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFILEFMT: u32 = 15u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPFIRST: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPHINTS: u32 = 11u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPHINTSA: u32 = 10u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPHINTSW: u32 = 11u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPKEEPIDENTITY: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPKEEPNULLS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPLAST: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPMAXERRS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPODBC: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPTEXTFILE: u32 = 14u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCPUNICODEFILE: u32 = 13u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_COLLATION: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_COLLATION_ID: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_DATA_LEN: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_INDICATOR_LEN: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_SERVER_COL: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_TERMINATOR: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BCP_FMT_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BMK_DURABILITY_INTRANSACTION: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BMK_DURABILITY_REORGANIZATION: i32 = 3i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BMK_DURABILITY_ROWSET: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BMK_DURABILITY_XTRANSACTION: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BUCKET_EXPONENTIAL: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const BUCKET_LINEAR: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORIZE_BUCKETS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORIZE_CLUSTER: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORIZE_RANGE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORIZE_UNIQUE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORY_COLLATOR: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORY_GATHERER: i32 = 3i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORY_INDEXER: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CATEGORY_SEARCH: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CDBBMKDISPIDS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CDBCOLDISPIDS: u32 = 28u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CDBSELFDISPIDS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CERT_E_NOT_FOUND_OR_NO_PERMISSSION: i32 = -2147211263i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_CORRUPT_FWIDX: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473491i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_DIACRITIC_SETTINGS_DIFFER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473490i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_INCONSISTENT_TRANSACTION: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473486i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_INVALID_CATALOG_LIST_VERSION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147215313i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_MULTIPLE_PROTECTED_USERS_UNSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473483i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_NO_AUXMETADATA: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147215318i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_NO_CATALOG_MANAGER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473487i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_NO_PROTECTED_USER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473484i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_PROTECTED_CATALOG_NON_INTERACTIVE_USER: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473481i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_PROTECTED_CATALOG_NOT_AVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473485i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_E_PROTECTED_CATALOG_SID_MISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(-1073473482i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_S_CATALOG_RESET: ::windows::core::HRESULT = ::windows::core::HRESULT(268336i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_S_CLIENT_REQUESTED_ABORT: ::windows::core::HRESULT = ::windows::core::HRESULT(268331i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_S_NEW_AUXMETADATA: ::windows::core::HRESULT = ::windows::core::HRESULT(268329i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CI_S_RETRY_DOCUMENT: ::windows::core::HRESULT = ::windows::core::HRESULT(268332i32);
pub const CLSID_DataShapeProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3449a1c8_c56c_11d0_ad72_00c04fc29863);
pub const CLSID_MSDASQL: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc8b522cb_5cf3_11ce_ade5_00aa0044773d);
pub const CLSID_MSDASQL_ENUMERATOR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc8b522cd_5cf3_11ce_ade5_00aa0044773d);
pub const CLSID_MSPersist: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c07e0d0_4418_11d2_9212_00c04fbbbfb3);
pub const CLSID_SQLOLEDB: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c7ff16c_38e3_11d0_97ab_00c04fc2ad98);
pub const CLSID_SQLOLEDB_ENUMERATOR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdfa22b8e_e68d_11d0_97e4_00c04fc2ad98);
pub const CLSID_SQLOLEDB_ERROR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc0932c62_38e5_11d0_97ab_00c04fc2ad98);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_ALREADY_INIT: i32 = -2147216123i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_NOT_INIT: i32 = -2147216124i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_NUM_PARAMS: i32 = -2147216122i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_PARAM_SIZE: i32 = -2147216125i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_PAREN: i32 = -2147216126i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CMDLINE_E_UNEXPECTED: i32 = -2147216127i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_CONNECTIONTIMEOUT: i32 = -2147219963i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_DATASOURCENOTAVAILABLE: i32 = -2147219964i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_INSUFFICIENTBUFFER: i32 = -2147219957i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_INVALIDDATASOURCE: i32 = -2147219959i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_NOQUERYCONNECTIONS: i32 = -2147219965i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_REGISTRY: i32 = -2147219960i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_SERVERNOTFOUND: i32 = -2147219962i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_TIMEOUT: i32 = -2147219958i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_TOOMANYDATASERVERS: i32 = -2147219967i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_E_TOOMANYDATASOURCES: i32 = -2147219966i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CM_S_NODATASERVERS: i32 = 263687i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_BADRESULT: i32 = -2147220218i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_BADSEQUENCE: i32 = -2147220223i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_BUFFERTOOSMALL: i32 = -2147220220i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_DUPLICATEDBID: i32 = -2147220216i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_INCOMPATIBLECOLUMNS: i32 = -2147220221i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_MAXCONNEXCEEDED: i32 = -2147220213i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_NODEFAULTCATALOG: i32 = -2147220214i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_NOMOREDATA: i32 = -2147220222i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_NOSORTCOLUMN: i32 = -2147220217i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const COLL_E_TOOMANYMERGECOLUMNS: i32 = -2147220215i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_CONTENT_CLASS_READ: i32 = -2147208188i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_CONTENT_SOURCE_COLUMN_TYPE: i32 = -2147208185i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_NULL_CONTENT_CLASS_BSTR: i32 = -2147208186i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_NULL_URI: i32 = -2147208183i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_OUT_OF_RANGE: i32 = -2147208184i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_PROPERTY_MAPPING_BAD_VECTOR_SIZE: i32 = -2147208189i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_PROPERTY_MAPPING_READ: i32 = -2147208191i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_UNEXPECTED_EXCEPTION: i32 = -2147208187i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CONTENT_SOURCE_E_UNEXPECTED_NULL_POINTER: i32 = -2147208190i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CQUERYDISPIDS: u32 = 11u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CQUERYMETADISPIDS: u32 = 10u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CQUERYPROPERTY: u32 = 64u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_ASSERTIONS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CATALOGS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CHARACTER_SETS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CHECK_CONSTRAINTS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CHECK_CONSTRAINTS_BY_TABLE: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_COLLATIONS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_COLUMNS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_COLUMN_DOMAIN_USAGE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_COLUMN_PRIVILEGES: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CONSTRAINT_COLUMN_USAGE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_CONSTRAINT_TABLE_USAGE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_FOREIGN_KEYS: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_INDEXES: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_KEY_COLUMN_USAGE: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_LINKEDSERVERS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_OBJECTS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_OBJECT_ACTIONS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_PRIMARY_KEYS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_PROCEDURES: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_PROCEDURE_COLUMNS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_PROCEDURE_PARAMETERS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_PROVIDER_TYPES: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_REFERENTIAL_CONSTRAINTS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_SCHEMATA: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_SQL_LANGUAGES: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_STATISTICS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLES: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLES_INFO: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLE_CONSTRAINTS: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLE_PRIVILEGES: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TABLE_STATISTICS: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TRANSLATIONS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_TRUSTEE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_USAGE_PRIVILEGES: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_VIEWS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_VIEW_COLUMN_USAGE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_DBSCHEMA_VIEW_TABLE_USAGE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_ACTIONS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_COMMANDS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_CUBES: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_DIMENSIONS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_FUNCTIONS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_HIERARCHIES: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_LEVELS: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_MEASURES: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_MEMBERS: u32 = 12u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_PROPERTIES: u32 = 9u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CRESTRICTIONS_MDSCHEMA_SETS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const CSTORAGEPROPERTY: u32 = 23u32;
pub const CSearchLanguageSupport: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6a68cc80_4337_4dbc_bd27_fbfb1053820b);
pub const CSearchManager: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7d096c5f_ac08_4f1f_beb7_5c22c517ce39);
pub const CSearchRoot: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x30766bd2_ea1c_4f28_bf27_0b44e2f68db7);
pub const CSearchScopeRule: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe63de750_3bd7_4be5_9c84_6b4281988c44);
pub const CompoundCondition: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x116f8d13_101e_4fa5_84d4_ff8279381935);
pub const ConditionFactory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe03e85b0_7be3_4000_ba98_6c13de9fa486);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPUTEMODE_COMPUTED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPUTEMODE_DYNAMIC: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBCOMPUTEMODE_NOTCOMPUTED: u32 = 3u32;
pub const DBGUID_MSSQLXML: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5d531cb2_e6ed_11d2_b252_00c04f681b71);
pub const DBGUID_XPATH: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xec2a4293_e898_11d2_b1b7_00c04f680c56);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBMAXCHAR: u32 = 8001u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMTYPE_INPUT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMTYPE_INPUTOUTPUT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMTYPE_OUTPUT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPARAMTYPE_RETURNVALUE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPT_COMPLETE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPT_COMPLETEREQUIRED: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPT_NOPROMPT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROMPT_PROMPT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPFLAGS_PERSIST: u32 = 8192u32;
pub const DBPROPSET_MSDAORA8_ROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7f06a375_dd6a_43db_b4e0_1fc121e5e62b);
pub const DBPROPSET_MSDAORA_ROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe8cc4cbd_fdff_11d0_b865_00a0c9081c1d);
pub const DBPROPSET_MSDSDBINIT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x55cb91a8_5c7a_11d1_adad_00c04fc29863);
pub const DBPROPSET_MSDSSESSION: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedf17536_afbf_11d1_8847_0000f879f98c);
pub const DBPROPSET_PERSIST: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4d7839a0_5b8e_11d1_a6b3_00a0c9138c66);
pub const DBPROPSET_PROVIDERCONNATTR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e4_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERDATASOURCEINFO: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e0_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERDBINIT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e2_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e1_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_PROVIDERSTMTATTR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x497c60e3_7123_11cf_b171_00aa0057599e);
pub const DBPROPSET_SQLSERVERCOLUMN: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3b63fb5e_3fbb_11d3_9f29_00c04f8ee9dc);
pub const DBPROPSET_SQLSERVERDATASOURCE: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x28efaee4_2d2c_11d1_9807_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERDATASOURCEINFO: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdf10cb94_35f6_11d2_9c54_00c04f7971d3);
pub const DBPROPSET_SQLSERVERDBINIT: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca10_ef21_11d0_97e7_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERROWSET: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cf4ca11_ef21_11d0_97e7_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERSESSION: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x28efaee5_2d2c_11d1_9807_00c04fc2ad98);
pub const DBPROPSET_SQLSERVERSTREAM: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9f79c073_8a6d_4bca_a8a8_c9b79a9b962d);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_AO_RANDOM: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_AO_SEQUENTIAL: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_AO_SEQUENTIALSTORAGEOBJECTS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_BACKGROUNDPOPULATION: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_INITIALIZE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_POPULATEONDEMAND: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_PREPOPULATE: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_RANDOMPOPULATION: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ASYNCH_SEQUENTIALPOPULATION: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BD_INTRANSACTION: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BD_REORGANIZATION: i32 = 3i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BD_ROWSET: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BD_XTRANSACTION: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BI_CROSSROWSET: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BMK_KEY: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BMK_NUMERIC: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BO_NOINDEXUPDATE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BO_NOLOG: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_BO_REFINTEGRITY: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CB_DELETE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CB_NON_NULL: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CB_NULL: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CB_PRESERVE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CD_NOTNULL: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CL_END: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CL_START: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CM_TRANSACTIONS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_BEGINSWITH: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_CASEINSENSITIVE: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_CASESENSITIVE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_CONTAINS: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_EQUALITY: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CO_STRING: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CS_COMMUNICATIONFAILURE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CS_INITIALIZED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CS_UNINITIALIZED: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CU_DML_STATEMENTS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CU_INDEX_DEFINITION: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CU_PRIVILEGE_DEFINITION: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_CU_TABLE_DEFINITION: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DF_INITIALLY_DEFERRED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DF_INITIALLY_IMMEDIATE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DF_NOT_DEFERRABLE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DST_DOCSOURCE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DST_MDP: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DST_TDP: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_DST_TDPANDMDP: i32 = 3i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_FU_CATALOG: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_FU_COLUMN: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_FU_NOT_SUPPORTED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_FU_TABLE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GB_COLLATE: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GB_CONTAINS_SELECT: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GB_EQUALS_SELECT: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GB_NOT_SUPPORTED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GB_NO_RELATION: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GU_NOTSUPPORTED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_GU_SUFFIX: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_HT_DIFFERENT_CATALOGS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_HT_DIFFERENT_PROVIDERS: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IC_LOWER: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IC_MIXED: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IC_SENSITIVE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IC_UPPER: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IN_ALLOWNULL: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IN_DISALLOWNULL: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IN_IGNOREANYNULL: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IN_IGNORENULL: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IT_BTREE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IT_CONTENT: i32 = 3i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IT_HASH: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_IT_OTHER: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_LM_INTENT: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_LM_NONE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_LM_READ: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_LM_RITE: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_LM_SINGLEROW: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_MR_CONCURRENT: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_MR_NOTSUPPORTED: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_MR_SUPPORTED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NC_END: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NC_HIGH: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NC_LOW: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NC_START: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NP_ABOUTTODO: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NP_DIDEVENT: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NP_FAILEDTODO: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NP_OKTODO: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NP_SYNCHAFTER: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NT_MULTIPLEROWS: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_NT_SINGLEROW: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OA_ATEXECUTE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OA_ATROWRELEASE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OA_NOTSUPPORTED: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_BLOB: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_DIRECTBIND: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_IPERSIST: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_ROWOBJECT: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_SCOPED: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OO_SINGLETON: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OP_EQUAL: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OP_RELATIVE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OP_STRING: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ORS_HISTOGRAM: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ORS_INDEX: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ORS_INTEGRATEDINDEX: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ORS_STOREDPROC: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_ORS_TABLE: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_AGR_AFTERSESSION: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_CLIENTCURSOR: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_DISABLEALL: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_ENABLEALL: i32 = -1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_RESOURCEPOOLING: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_OS_TXNENLISTMENT: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PERSIST_ADTG: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PERSIST_XML: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_GUID: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_GUID_NAME: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_GUID_PROPID: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_NAME: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_PGUID_NAME: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_PGUID_PROPID: i32 = 64i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_PT_PROPID: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_RD_RESETALL: i32 = -1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_RT_APTMTTHREAD: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_RT_FREETHREAD: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_RT_SINGLETHREAD: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ANSI89_IEF: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ANSI92_ENTRY: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ANSI92_FULL: i32 = 128i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ANSI92_INTERMEDIATE: i32 = 64i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ESCAPECLAUSES: i32 = 256i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_FIPS_TRANSITIONAL: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_NONE: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ODBC_CORE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ODBC_EXTENDED: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_ODBC_MINIMUM: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQL_SUBMINIMUM: i32 = 512i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_COMPARISON: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_CORRELATEDSUBQUERIES: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_EXISTS: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_IN: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_QUANTIFIED: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SQ_TABLE: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SS_ILOCKBYTES: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SS_ISEQUENTIALSTREAM: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SS_ISTORAGE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SS_ISTREAM: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_CONVERT: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_DELETEONRELEASE: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_DIRECT: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_FAILIFTHERE: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_PRIORITY: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_STGM_TRANSACTED: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SU_DML_STATEMENTS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SU_INDEX_DEFINITION: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SU_PRIVILEGE_DEFINITION: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_SU_TABLE_DEFINITION: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_ALL: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_DDL_COMMIT: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_DDL_IGNORE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_DDL_LOCK: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_DML: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TC_NONE: i32 = 0i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_BROWSE: i32 = 256i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_CHAOS: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_CURSORSTABILITY: i32 = 4096i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_ISOLATED: i32 = 1048576i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_READCOMMITTED: i32 = 4096i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_READUNCOMMITTED: i32 = 256i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_REPEATABLEREAD: i32 = 65536i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TI_SERIALIZABLE: i32 = 1048576i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_ABORT: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_ABORT_DC: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_ABORT_NO: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_BOTH: i32 = 128i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_COMMIT: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_COMMIT_DC: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_COMMIT_NO: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_DONTCARE: i32 = 64i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_NONE: i32 = 256i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TR_OPTIMISTIC: i32 = 512i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TS_CARDINALITY: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_TS_HISTOGRAM: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_UP_CHANGE: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_UP_DELETE: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROPVAL_UP_INSERT: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_HCHAPTER: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_INTERLEAVEDROWS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MAINTAINPROPS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MSDAORA8_DETERMINEKEYCOLUMNS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_MSDAORA_DETERMINEKEYCOLUMNS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PersistFormat: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_PersistSchema: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBPROP_Unicode: u32 = 6u32;
pub const DBSCHEMA_LINKEDSERVERS: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9093caf4_2eac_11d1_9809_00c04fc2ad98);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DBTYPE_SQLVARIANT: u32 = 144u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_ALL_EXCEPT_LIKE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_COLLECTION: i32 = 16i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_DELAYFETCHCOLUMNS: i32 = 1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_DELAYFETCHSTREAM: i32 = 2i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_ISSTRUCTUREDDOCUMENT: i32 = 128i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_OPENIFEXISTS: i32 = 32i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_OUTPUT: i32 = 8i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_OVERWRITE: i32 = 64i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_BINDFLAGS_RECURSIVE: i32 = 4i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_COLLATION_ASC: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_COLLATION_DESC: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_COUNTUNAVAILABLE: i32 = -1i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ABORTLIMITREACHED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217871i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ALREADYINITIALIZED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217838i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ALTERRESTRICTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217763i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ASYNCNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217771i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADACCESSORFLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217850i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADACCESSORHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217920i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADACCESSORTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217845i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADBINDINFO: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217912i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADBOOKMARK: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217906i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCHAPTER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217914i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCOLUMNID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217903i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCOMMANDFLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217780i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCOMMANDID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217802i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCOMPAREOP: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217881i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCONSTRAINTFORM: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217800i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCONSTRAINTID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217781i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCONSTRAINTTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217801i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCONVERTFLAG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217828i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADCOPY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217863i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADDEFERRABILITY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217799i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADDYNAMICERRORID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217830i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADHRESULT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217832i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADID: i32 = -2147217860i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADINDEXID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217806i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADINITSTRING: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217805i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADLOCKMODE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217905i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADLOOKUPID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217831i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADMATCHTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217792i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADORDINAL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217835i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADPARAMETERNAME: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217827i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADPRECISION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217862i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADPROPERTYVALUE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217852i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADRATIO: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217902i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADRECORDNUM: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217854i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADREGIONHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217878i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADROWHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217916i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSCALE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217861i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSOURCEHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217840i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSTARTPOSITION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217890i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSTATUSVALUE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217880i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSTORAGEFLAG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217882i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADSTORAGEFLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217849i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADTABLEID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217860i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADTYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217859i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADTYPENAME: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217872i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADUPDATEDELETERULE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217782i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BADVALUES: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217901i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BOGUS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217665i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BOOKMARKSKIPPED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217853i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_BYREFACCESSORNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217848i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANCELED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217842i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANNOTCONNECT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217770i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANNOTFREE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217894i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANNOTRESTART: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217896i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTCANCEL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217899i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTCONVERTVALUE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217913i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTFETCHBACKWARDS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217884i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTFILTER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217825i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTORDER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217824i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTSCROLLBACKWARDS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217879i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CANTTRANSLATE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217869i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CHAPTERNOTRELEASED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217841i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_COLUMNUNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217760i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_COMMANDNOTPERSISTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217817i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_CONCURRENCYVIOLATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217864i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_COSTLIMIT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217907i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DATAOVERFLOW: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217833i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DELETEDROW: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217885i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DIALECTNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217898i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DROPRESTRICTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217776i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATECOLUMNID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217858i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATECONSTRAINTID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217767i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATEDATASOURCE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217897i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATEID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217816i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATEINDEXID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217868i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_DUPLICATETABLEID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217857i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ERRORSINCOMMAND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217900i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ERRORSOCCURRED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217887i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_GOALREJECTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217892i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_INDEXINUSE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217866i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_INTEGRITYVIOLATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217873i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_INVALID: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217851i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_INVALIDTRANSITION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217876i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_LIMITREJECTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217909i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_MAXPENDCHANGESEXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217836i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_MISMATCHEDPROVIDER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217803i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_MULTIPLESTATEMENTS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217874i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_MULTIPLESTORAGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217826i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NEWLYINSERTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217893i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOAGGREGATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217886i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOCOLUMN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217819i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOCOMMAND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217908i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOCONSTRAINT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217761i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOINDEX: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217867i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOLOCALE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217855i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NONCONTIGUOUSRANGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217877i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOPROVIDERSREGISTERED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217804i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOQUERY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217889i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOSOURCEOBJECT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217775i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOSTATISTIC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217764i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217865i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTAREFERENCECOLUMN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217910i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTASUBREGION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217875i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTCOLLECTION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217773i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTFOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217895i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTPREPARED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217846i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTREENTRANT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217888i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217837i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_NULLACCESSORNOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217847i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_OBJECTCREATIONLIMITREACHED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217815i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_OBJECTMISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217779i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_OBJECTOPEN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217915i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_OUTOFSPACE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217766i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_PARAMNOTOPTIONAL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217904i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_PARAMUNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217839i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_PENDINGCHANGES: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217834i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_PENDINGINSERT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217829i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_READONLY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217772i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_READONLYACCESSOR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217918i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_RESOURCEEXISTS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217768i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_RESOURCELOCKED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217774i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_RESOURCENOTSUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217762i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_RESOURCEOUTOFSCOPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217778i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ROWLIMITEXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217919i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ROWSETINCOMMAND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217870i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_ROWSNOTRELEASED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217883i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_SCHEMAVIOLATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217917i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_TABLEINUSE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217856i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_TIMEOUT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217769i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_UNSUPPORTEDCONVERSION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217891i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_E_WRITEONLYACCESSOR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217844i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_IMP_LEVEL_ANONYMOUS: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_IMP_LEVEL_DELEGATE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_IMP_LEVEL_IDENTIFY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_IMP_LEVEL_IMPERSONATE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_IN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_INVALID_HACCESSOR: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_INVALID_HCHAPTER: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_LIKE_ONLY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_LOCAL_EXCLUSIVE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_LOCAL_SHARED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_READ: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_READWRITE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_SHARE_DENY_NONE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_SHARE_DENY_READ: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_SHARE_DENY_WRITE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_SHARE_EXCLUSIVE: u32 = 12u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_MODE_WRITE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_NULL_HACCESSOR: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_NULL_HCHAPTER: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_NULL_HROW: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_OUT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_CALL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_CONNECT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_PKT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_PKT_INTEGRITY: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PROT_LEVEL_PKT_PRIVACY: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PT_FUNCTION: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PT_PROCEDURE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_PT_UNKNOWN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_REMOTE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_SEARCHABLE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_SEC_E_AUTH_FAILED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217843i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_SEC_E_PERMISSIONDENIED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217911i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_SEC_E_SAFEMODE_DENIED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217765i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_ASYNCHRONOUS: ::windows::core::HRESULT = ::windows::core::HRESULT(265936i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_BADROWHANDLE: ::windows::core::HRESULT = ::windows::core::HRESULT(265939i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_BOOKMARKSKIPPED: ::windows::core::HRESULT = ::windows::core::HRESULT(265923i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_BUFFERFULL: ::windows::core::HRESULT = ::windows::core::HRESULT(265928i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_CANTRELEASE: ::windows::core::HRESULT = ::windows::core::HRESULT(265930i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_COLUMNSCHANGED: ::windows::core::HRESULT = ::windows::core::HRESULT(265937i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_COLUMNTYPEMISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(265921i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_COMMANDREEXECUTED: ::windows::core::HRESULT = ::windows::core::HRESULT(265927i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_DELETEDROW: ::windows::core::HRESULT = ::windows::core::HRESULT(265940i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_DIALECTIGNORED: ::windows::core::HRESULT = ::windows::core::HRESULT(265933i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_ENDOFROWSET: ::windows::core::HRESULT = ::windows::core::HRESULT(265926i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_ERRORSOCCURRED: ::windows::core::HRESULT = ::windows::core::HRESULT(265946i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_ERRORSRETURNED: ::windows::core::HRESULT = ::windows::core::HRESULT(265938i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_GOALCHANGED: ::windows::core::HRESULT = ::windows::core::HRESULT(265931i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_LOCKUPGRADED: ::windows::core::HRESULT = ::windows::core::HRESULT(265944i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_MULTIPLECHANGES: ::windows::core::HRESULT = ::windows::core::HRESULT(265948i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_NONEXTROWSET: ::windows::core::HRESULT = ::windows::core::HRESULT(265925i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_NORESULT: ::windows::core::HRESULT = ::windows::core::HRESULT(265929i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_NOROWSPECIFICCOLUMNS: ::windows::core::HRESULT = ::windows::core::HRESULT(265949i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_NOTSINGLETON: ::windows::core::HRESULT = ::windows::core::HRESULT(265943i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_PARAMUNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(265947i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_PROPERTIESCHANGED: ::windows::core::HRESULT = ::windows::core::HRESULT(265945i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_ROWLIMITEXCEEDED: ::windows::core::HRESULT = ::windows::core::HRESULT(265920i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_STOPLIMITREACHED: ::windows::core::HRESULT = ::windows::core::HRESULT(265942i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_TOOMANYCHANGES: ::windows::core::HRESULT = ::windows::core::HRESULT(265941i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_TYPEINFOOVERRIDDEN: ::windows::core::HRESULT = ::windows::core::HRESULT(265922i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_UNWANTEDOPERATION: ::windows::core::HRESULT = ::windows::core::HRESULT(265932i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_UNWANTEDPHASE: ::windows::core::HRESULT = ::windows::core::HRESULT(265934i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_S_UNWANTEDREASON: ::windows::core::HRESULT = ::windows::core::HRESULT(265935i32);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DB_UNSEARCHABLE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_ALL: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_HITCOUNT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_LASTSEENTIME: u32 = 10u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_PROPDISPID: u32 = 6u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_PROPGUID: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_PROPMODIFIABLE: u32 = 9u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_PROPNAME: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_STORELEVEL: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_VROOTAUTOMATIC: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_VROOTMANUAL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_METADATA_VROOTUSED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_RANK: u32 = 3u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_RANKVECTOR: u32 = 2u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_REVNAME: u32 = 8u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_UNFILTERED: u32 = 7u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_VIRTUALPATH: u32 = 9u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DISPID_QUERY_WORKID: u32 = 5u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_ALREADYDISABLED: i32 = -2147220447i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_ALREADYENABLED: i32 = -2147220454i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_BADREQUEST: i32 = -2147220475i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_BADRESULT: i32 = -2147220445i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_BADSEQUENCE: i32 = -2147220473i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_BUFFERTOOSMALL: i32 = -2147220449i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_CANNOTREMOVECONCURRENT: i32 = -2147220443i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_CANNOTWRITEREGISTRY: i32 = -2147220444i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_CONFIGBAD: i32 = -2147220470i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_CONFIGNOTRIGHTTYPE: i32 = -2147220456i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_DATANOTPRESENT: i32 = -2147220464i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_DATASOURCENOTAVAILABLE: i32 = -2147220478i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_DATASOURCENOTDISABLED: i32 = -2147220459i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_DUPLICATEID: i32 = -2147220462i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_INDEXDIRECTORY: i32 = -2147220452i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_INVALIDCATALOGNAME: i32 = -2147220457i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_INVALIDDATASOURCE: i32 = -2147220479i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_INVALIDTAGDB: i32 = -2147220458i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_MESSAGETOOLONG: i32 = -2147220472i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_MISSINGCATALOG: i32 = -2147220440i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_NOMOREDATA: i32 = -2147220480i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_PARAMOUTOFRANGE: i32 = -2147220448i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_PROPVERSIONMISMATCH: i32 = -2147220441i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_PROTOCOLVERSION: i32 = -2147220455i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_QUERYCANCELED: i32 = -2147220477i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_QUERYHUNG: i32 = -2147220446i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_REGISTRY: i32 = -2147220460i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_SEARCHCATNAMECOLLISION: i32 = -2147220442i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_SERVERCAPACITY: i32 = -2147220474i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_SERVERERROR: i32 = -2147220471i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_SETSTATUSINPROGRESS: i32 = -2147220463i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_TOOMANYDATASOURCES: i32 = -2147220461i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_UNKNOWNPARAM: i32 = -2147220450i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_UNKNOWNREQUEST: i32 = -2147220476i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const DS_E_VALUETOOLARGE: i32 = -2147220451i32;
pub const DataLinks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2206cdb2_19c1_11d1_89e0_00c04fd7a829);
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_FTE: u32 = 13824u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_FTE_CB: u32 = 51968u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_FTE_FD: u32 = 64768u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_CMDLINE: u32 = 5376u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_COLLATOR: u32 = 1280u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_CONNMGR: u32 = 1536u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_CONTENT_SOURCE: u32 = 13312u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_DATASOURCE: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_DAV: u32 = 8960u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_EXSTOREPH: u32 = 9984u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_FLTRDMN: u32 = 9216u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_GATHERER: u32 = 3328u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_INDEXER: u32 = 4352u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_MSS: u32 = 8448u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_NETWORKING: u32 = 768u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_NLADMIN: u32 = 6400u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_NOTESPH: u32 = 9728u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_OLEDB_BINDER: u32 = 9472u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_PEOPLE_IMPORT: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_PROTHNDLR: u32 = 4608u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_QUERY: u32 = 1792u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_REMOTE_EXSTOREPH: u32 = 13568u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_SCHEMA: u32 = 3072u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_SCRIPTPI: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_SECURITY: u32 = 5120u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_SETUP: u32 = 4864u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_SRCH_SCHEMA_CACHE: u32 = 13056u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const ERROR_SOURCE_XML: u32 = 8704u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_AUDIENCECOMPUTATION_CANNOTSTART: i32 = -1073738223i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_AUTOCAT_CANT_CREATE_FILE_SHARE: i32 = -1073738726i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_AUTOCAT_PERFMON: i32 = -1073738753i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_CONFIG_ERROR: i32 = -1073738821i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_CONFIG_SYNTAX: i32 = -2147482604i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_CRAWL_SCHEDULED: i32 = 1073744884i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_DETAILED_FILTERPOOL_ADD_FAILED: i32 = -1073738719i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_DSS_NOT_ENABLED: i32 = -2147476572i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_ENUMERATE_SESSIONS_FAILED: i32 = -1073738720i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_EXCEPTION: i32 = -1073740815i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FAILED_CREATE_GATHERER_LOG: i32 = -2147480587i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FAILED_INITIALIZE_CRAWL: i32 = -1073738765i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FILTERPOOL_ADD_FAILED: i32 = -1073738722i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FILTERPOOL_DELETE_FAILED: i32 = -1073738721i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FILTER_HOST_FORCE_TERMINATE: i32 = -2147473624i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FILTER_HOST_NOT_INITIALIZED: i32 = -1073738724i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_FILTER_HOST_NOT_TERMINATED: i32 = -1073738723i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHERER_DATASOURCE: i32 = -1073738727i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHERER_PERFMON: i32 = -1073738817i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHERSVC_PERFMON: i32 = -1073738818i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_ADVISE_FAILED: i32 = -1073738798i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_APP_INIT_FAILED: i32 = -1073738766i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_AUTODESCENCODE_INVALID: i32 = -2147480592i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_AUTODESCLEN_ADJUSTED: i32 = -2147480603i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_BACKUPAPP_COMPLETE: i32 = 3077i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_BACKUPAPP_ERROR: i32 = -1073738748i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CANT_CREATE_DOCID: i32 = -1073738793i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CANT_DELETE_DOCID: i32 = -1073738792i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CHECKPOINT_CORRUPT: i32 = -1073738732i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CHECKPOINT_FAILED: i32 = -1073738736i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CHECKPOINT_FILE_MISSING: i32 = -1073738731i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRAWL_IN_PROGRESS: i32 = -2147480609i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRAWL_NOT_STARTED: i32 = -2147480625i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRAWL_SEED_ERROR: i32 = -2147480624i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRAWL_SEED_FAILED: i32 = -2147480612i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRAWL_SEED_FAILED_INIT: i32 = -2147480611i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_CRITICAL_ERROR: i32 = -1073738799i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_DAEMON_TERMINATED: i32 = -2147480570i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_DELETING_HISTORY_ITEMS: i32 = -1073738774i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_DIRTY_STARTUP: i32 = -2147480576i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_DISK_FULL: i32 = -2147480594i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_END_ADAPTIVE: i32 = 1073744891i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_END_CRAWL: i32 = 1073744842i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_END_INCREMENTAL: i32 = 1073744871i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_EXCEPTION: i32 = -1073738810i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_FLUSH_FAILED: i32 = -1073738737i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_FROM_NOT_SET: i32 = -1073738776i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_HISTORY_CORRUPTION_DETECTED: i32 = -2147480575i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_INTERNAL: i32 = -1073738804i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_INVALID_NETWORK_ACCESS_ACCOUNT: i32 = -1073738739i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_LOCK_FAILED: i32 = -1073738784i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_NO_CRAWL_SEEDS: i32 = -2147480602i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_NO_SCHEMA: i32 = -2147480593i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_OBJ_INIT_FAILED: i32 = -1073738796i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_PLUGINMGR_INIT_FAILED: i32 = -1073738767i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_PLUGIN_INIT_FAILED: i32 = -1073738795i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_PROTOCOLHANDLER_INIT_FAILED: i32 = -1073738740i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_PROTOCOLHANDLER_LOAD_FAILED: i32 = -1073738741i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_READ_CHECKPOINT_FAILED: i32 = -1073738733i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RECOVERY_FAILURE: i32 = -1073738222i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_REG_MISSING: i32 = -2147480610i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESET_START: i32 = 1073744865i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESTOREAPP_COMPLETE: i32 = 3075i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESTOREAPP_ERROR: i32 = -1073738750i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESTORE_CHECKPOINT_FAILED: i32 = -1073738734i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESTORE_COMPLETE: i32 = 3069i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESTORE_ERROR: i32 = -1073738754i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_RESUME: i32 = 1073744868i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_SAVE_FAILED: i32 = -1073738735i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_SERVICE_INIT: i32 = -1073738794i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_START_CRAWL: i32 = 1073744843i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_START_CRAWL_IF_RESET: i32 = -2147480595i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_START_PAUSE: i32 = -2147480606i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_STOP_START: i32 = 1073744876i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_SYSTEM_LCID_CHANGED: i32 = -2147480562i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_THROTTLE: i32 = 1073744867i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_GATHER_TRANSACTION_FAIL: i32 = -1073738797i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_HASHMAP_INSERT: i32 = -1073738816i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_HASHMAP_UPDATE: i32 = -1073738811i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_ADD_DSS_DISCONNECT: i32 = -2147476585i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_ADD_DSS_FAILED: i32 = -2147476627i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_ADD_DSS_SUCCEEDED: i32 = 7019i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_BUILD_ENDED: i32 = 1073748873i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_BUILD_FAILED: i32 = -1073734797i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_BUILD_START: i32 = 1073748872i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_CI_LOAD_ERROR: i32 = -1073734785i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_DSS_ALREADY_ADDED: i32 = 1073748870i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_DSS_CONTACT_FAILED: i32 = -1073734800i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_DSS_UNABLE_TO_REMOVE: i32 = -1073734755i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_FAIL_TO_CREATE_PER_USER_CATALOG: i32 = -1073731797i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_FAIL_TO_SET_MAX_JETINSTANCE: i32 = -1073731798i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_FAIL_TO_UNLOAD_PER_USER_CATALOG: i32 = -1073731796i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_INIT_ERROR: i32 = -1073734814i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_INVALID_DIRECTORY: i32 = -1073734813i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_LOAD_FAIL: i32 = -1073734781i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_MISSING_APP_DIRECTORY: i32 = -1073734758i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_NEW_PROJECT: i32 = -1073734754i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_NO_SEARCH_SERVERS: i32 = -2147476630i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_OUT_OF_DATABASE_INSTANCE: i32 = -1073731799i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PAUSED_FOR_DISKFULL: i32 = -1073734811i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PERFMON: i32 = -1073734760i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROPSTORE_INIT_FAILED: i32 = -1073734787i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_ABORTED: i32 = 1073748899i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_COMMITTED: i32 = 1073748898i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_COMMIT_FAILED: i32 = -1073734747i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_ERROR: i32 = -1073734812i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_STARTED: i32 = 1073748841i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_STATE_CORRUPT: i32 = -1073734780i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_STOPPED: i32 = -2147476633i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_PROP_SUCCEEDED: i32 = 7016i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_REG_ERROR: i32 = -1073734756i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_REG_MISSING: i32 = -1073734796i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_REMOVED_PROJECT: i32 = -1073734753i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_REMOVE_DSS_FAILED: i32 = -1073734801i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_REMOVE_DSS_SUCCEEDED: i32 = 7020i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_RESET_FOR_CORRUPTION: i32 = -1073734784i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_SCHEMA_COPY_ERROR: i32 = -1073734823i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_SHUTDOWN: i32 = 1073748866i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_STARTED: i32 = 1073748824i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_INDEXER_VERIFY_PROP_ACCOUNT: i32 = -1073734768i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LEARN_COMPILE_FAILED: i32 = -2147480583i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LEARN_CREATE_DB_FAILED: i32 = -2147480584i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LEARN_PROPAGATION_COPY_FAILED: i32 = -2147480585i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LEARN_PROPAGATION_FAILED: i32 = -2147480582i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LOCAL_GROUPS_CACHE_FLUSHED: i32 = 1073744920i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_LOCAL_GROUP_NOT_EXPANDED: i32 = 1073744919i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_NOTIFICATION_FAILURE: i32 = -1073738745i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_NOTIFICATION_FAILURE_SCOPE_EXCEEDED_LOGGING: i32 = -2147480568i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_NOTIFICATION_RESTORED: i32 = 1073744905i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_NOTIFICATION_RESTORED_SCOPE_EXCEEDED_LOGGING: i32 = -2147480566i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_NOTIFICATION_THREAD_EXIT_FAILED: i32 = -1073738725i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_OUTOFMEMORY: i32 = -1073740817i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_PERF_COUNTERS_ALREADY_EXISTS: i32 = -2147473626i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_PERF_COUNTERS_NOT_LOADED: i32 = -2147473628i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_PERF_COUNTERS_REGISTRY_TROUBLE: i32 = -2147473627i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_PROTOCOL_HOST_FORCE_TERMINATE: i32 = -2147473625i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_REG_VERSION: i32 = -1073738790i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_CREATE_PATH_RULES_FAILED: i32 = -2147482634i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_CSM_SAVE_FAILED: i32 = -1073740805i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_DATAFILES_MOVE_FAILED: i32 = -1073740808i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_DATAFILES_MOVE_ROLLBACK_ERRORS: i32 = -2147482630i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_DATAFILES_MOVE_SUCCEEDED: i32 = 1073742841i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_DROPPED_EVENTS: i32 = -2147482633i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_SETUP_CLEANUP_FAILED: i32 = -1073740813i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_SETUP_CLEANUP_STARTED: i32 = -2147482640i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_SETUP_CLEANUP_SUCCEEDED: i32 = 1073742834i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_SETUP_FAILED: i32 = -1073740818i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_SETUP_SUCCEEDED: i32 = 1073742829i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_STARTED: i32 = 1073742827i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_STARTING_SETUP: i32 = 1073742828i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SSSEARCH_STOPPED: i32 = 1073742837i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_STS_INIT_SECURITY_FAILED: i32 = -2147480554i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_SYSTEM_EXCEPTION: i32 = -2147482595i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_TRANSACTION_READ: i32 = -1073738809i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_TRANSLOG_APPEND: i32 = -1073738814i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_TRANSLOG_CREATE: i32 = -1073738791i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_TRANSLOG_CREATE_TRX: i32 = -1073738815i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_TRANSLOG_UPDATE: i32 = -1073738813i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_UNPRIVILEGED_SERVICE_ACCOUNT: i32 = -2147482596i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_USING_DIFFERENT_WORD_BREAKER: i32 = -2147480580i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_WARNING_CANNOT_UPGRADE_NOISE_FILE: i32 = -2147473634i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_WARNING_CANNOT_UPGRADE_NOISE_FILES: i32 = -2147473635i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_WBREAKER_NOT_LOADED: i32 = -2147480586i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EVENT_WIN32_ERROR: i32 = -2147473633i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_ACCESS_DENIED: i32 = -2147216990i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_BADCONFIG_OR_ACCESSDENIED: i32 = -2147216988i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_INVALID_ACCOUNT_INFO: i32 = -2147216984i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_INVALID_EXCHANGE_SERVER: i32 = -2147216989i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_INVALID_SERVER_CONFIG: i32 = -2147216991i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_NOT_ADMIN_OR_WRONG_SITE: i32 = -2147216986i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_NO_CONFIG: i32 = -2147216992i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_NO_MAPI: i32 = -2147216985i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXCI_E_WRONG_SERVER_OR_ACCT: i32 = -2147216987i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EXSTOREPH_E_UNEXPECTED: i32 = -2147211519i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_CMDFATAL: u32 = 20u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_CONTROL: u32 = 25u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_DBCORRUPT: u32 = 23u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_DBFATAL: u32 = 21u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_DEADLOCK: u32 = 13u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_HARDWARE: u32 = 24u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_INFO: u32 = 10u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_INTOK: u32 = 18u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_LIMIT: u32 = 19u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_MAXISEVERITY: u32 = 10u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_MISSING: u32 = 11u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_PERMIT: u32 = 14u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_RESOURCE: u32 = 17u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_SYNTAX: u32 = 15u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_TABCORRUPT: u32 = 22u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_TYPE: u32 = 12u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const EX_USER: u32 = 16u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FAIL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FLTRDMN_E_CANNOT_DECRYPT_PASSWORD: i32 = -2147212282i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FLTRDMN_E_ENCRYPTED_DOCUMENT: i32 = -2147212283i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FLTRDMN_E_FILTER_INIT_FAILED: i32 = -2147212284i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FLTRDMN_E_QI_FILTER_FAILED: i32 = -2147212286i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FLTRDMN_E_UNEXPECTED: i32 = -2147212287i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_ADMIN_BLOB_CORRUPT: i32 = -2147207676i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_AFFINITY_MASK: i32 = -2147207651i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_ALREADY_INITIALIZED: i32 = -2147207604i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_ANOTHER_STATUS_CHANGE_IS_ALREADY_ACTIVE: i32 = -2147207635i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_BATCH_ABORTED: i32 = -2147207636i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CATALOG_ALREADY_EXISTS: i32 = -2147207656i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CATALOG_DOES_NOT_EXIST: i32 = -2147207639i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CB_CBID_OUT_OF_BOUND: i32 = -2147169535i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CB_NOT_ENOUGH_AVAIL_PHY_MEM: i32 = -2147169534i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CB_NOT_ENOUGH_OCC_BUFFER: i32 = -2147169533i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_CB_OUT_OF_MEMORY: i32 = -2147169536i32;
#[doc = "*Required features: `\"Win32_System_Search\"`*"]
pub const FTE_E_COM_SIGNATURE_VALIDATION: i32 = -2147207652i32;
#[doc = "*R