#! /bin/sh
# Do not edit this file!
# this file is generated by 'generate_test.pl'.

#
# idnconv2 command test.
# Test '-skip' option.
# The argument of '-skip' ends with ','.
#
#             api: command
#  local_encoding: U-escape
#         command: ../../tools/idnconv/idnconv2 -c /dev/null -skip prohcheck,
#           input: === a\u{a7}b.jp ===
#          output: invalid argument to option '-skip'.
#          output: try 'idnconv2 -help' for more information.
#        exitcode: 1

################## setup ##################

unset LC_ALL
unset LC_CTYPE
unset LC_MESSAGES
unset LANG
unset IDN_LOCAL_CODESET
unset IDN_LOG_LEVEL

SRCDIR=`dirname $0`
SYSCONFDIR=${SYSCONFDIR-"/etc"}
IGNORE=false
export IDN_LOCAL_CODESET; IDN_LOCAL_CODESET=U-escape

rm -f idn2.conf
touch idn2.conf
rm -f localmap1
rm -f localmap2
rm -f localmap3
rm -f localmap4
rm -f localset
rm -f expect.txt
rm -f output.txt

################## test ##################

echo 'invalid argument to option '\''-skip'\''.' >> expect.txt
echo 'try '\''idnconv2 -help'\'' for more information.' >> expect.txt
echo 'exitcode=1' >> expect.txt
rm -f input.txt
touch input.txt
echo '=== a\u{a7}b.jp ===' >> input.txt
cat input.txt | ../../tools/idnconv/idnconv2 -c /dev/null -skip prohcheck, > output.txt 2>&1
echo 'exitcode='$? >> output.txt
rm -f input.txt

################## teardown ##################

cmp expect.txt output.txt > /dev/null 2>&1
RESULT=$?
[ X$IGNORE = Xtrue ] && RESULT=77
if [ X$QUIET != Xtrue ]; then
    if [ $RESULT -eq 0 ]; then
        echo "PASS: $0"
    elif [ $RESULT -eq 77 ]; then
        echo "SKIP: $0"
    else
        echo "FAIL: $0"
    fi
fi
[ $RESULT -eq 0 -o $RESULT -eq 77 ] || exit $RESULT
rm -f idn2.conf
rm -f localmap1
rm -f localmap2
rm -f localmap3
rm -f localmap4
rm -f localset
rm -f expect.txt
rm -f output.txt
exit $RESULT
