// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/asset/v1/assets.proto

package asset

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v11 "google.golang.org/genproto/googleapis/cloud/orgpolicy/v1"
	v12 "google.golang.org/genproto/googleapis/cloud/osconfig/v1"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	v13 "google.golang.org/genproto/googleapis/identity/accesscontextmanager/v1"
	code "google.golang.org/genproto/googleapis/rpc/code"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of prior asset.
type TemporalAsset_PriorAssetState int32

const (
	// prior_asset is not applicable for the current asset.
	TemporalAsset_PRIOR_ASSET_STATE_UNSPECIFIED TemporalAsset_PriorAssetState = 0
	// prior_asset is populated correctly.
	TemporalAsset_PRESENT TemporalAsset_PriorAssetState = 1
	// Failed to set prior_asset.
	TemporalAsset_INVALID TemporalAsset_PriorAssetState = 2
	// Current asset is the first known state.
	TemporalAsset_DOES_NOT_EXIST TemporalAsset_PriorAssetState = 3
	// prior_asset is a deletion.
	TemporalAsset_DELETED TemporalAsset_PriorAssetState = 4
)

// Enum value maps for TemporalAsset_PriorAssetState.
var (
	TemporalAsset_PriorAssetState_name = map[int32]string{
		0: "PRIOR_ASSET_STATE_UNSPECIFIED",
		1: "PRESENT",
		2: "INVALID",
		3: "DOES_NOT_EXIST",
		4: "DELETED",
	}
	TemporalAsset_PriorAssetState_value = map[string]int32{
		"PRIOR_ASSET_STATE_UNSPECIFIED": 0,
		"PRESENT":                       1,
		"INVALID":                       2,
		"DOES_NOT_EXIST":                3,
		"DELETED":                       4,
	}
)

func (x TemporalAsset_PriorAssetState) Enum() *TemporalAsset_PriorAssetState {
	p := new(TemporalAsset_PriorAssetState)
	*p = x
	return p
}

func (x TemporalAsset_PriorAssetState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TemporalAsset_PriorAssetState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_assets_proto_enumTypes[0].Descriptor()
}

func (TemporalAsset_PriorAssetState) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_assets_proto_enumTypes[0]
}

func (x TemporalAsset_PriorAssetState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TemporalAsset_PriorAssetState.Descriptor instead.
func (TemporalAsset_PriorAssetState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{0, 0}
}

// Value of this expression.
type ConditionEvaluation_EvaluationValue int32

const (
	// Reserved for future use.
	ConditionEvaluation_EVALUATION_VALUE_UNSPECIFIED ConditionEvaluation_EvaluationValue = 0
	// The evaluation result is `true`.
	ConditionEvaluation_TRUE ConditionEvaluation_EvaluationValue = 1
	// The evaluation result is `false`.
	ConditionEvaluation_FALSE ConditionEvaluation_EvaluationValue = 2
	// The evaluation result is `conditional` when the condition expression
	// contains variables that are either missing input values or have not been
	// supported by Analyzer yet.
	ConditionEvaluation_CONDITIONAL ConditionEvaluation_EvaluationValue = 3
)

// Enum value maps for ConditionEvaluation_EvaluationValue.
var (
	ConditionEvaluation_EvaluationValue_name = map[int32]string{
		0: "EVALUATION_VALUE_UNSPECIFIED",
		1: "TRUE",
		2: "FALSE",
		3: "CONDITIONAL",
	}
	ConditionEvaluation_EvaluationValue_value = map[string]int32{
		"EVALUATION_VALUE_UNSPECIFIED": 0,
		"TRUE":                         1,
		"FALSE":                        2,
		"CONDITIONAL":                  3,
	}
)

func (x ConditionEvaluation_EvaluationValue) Enum() *ConditionEvaluation_EvaluationValue {
	p := new(ConditionEvaluation_EvaluationValue)
	*p = x
	return p
}

func (x ConditionEvaluation_EvaluationValue) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConditionEvaluation_EvaluationValue) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_assets_proto_enumTypes[1].Descriptor()
}

func (ConditionEvaluation_EvaluationValue) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_assets_proto_enumTypes[1]
}

func (x ConditionEvaluation_EvaluationValue) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConditionEvaluation_EvaluationValue.Descriptor instead.
func (ConditionEvaluation_EvaluationValue) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{14, 0}
}

// An asset in Google Cloud and its temporal metadata, including the time window
// when it was observed and its status during that window.
type TemporalAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time window when the asset data and state was observed.
	Window *TimeWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	// Whether the asset has been deleted or not.
	Deleted bool `protobuf:"varint,2,opt,name=deleted,proto3" json:"deleted,omitempty"`
	// An asset in Google Cloud.
	Asset *Asset `protobuf:"bytes,3,opt,name=asset,proto3" json:"asset,omitempty"`
	// State of prior_asset.
	PriorAssetState TemporalAsset_PriorAssetState `protobuf:"varint,4,opt,name=prior_asset_state,json=priorAssetState,proto3,enum=google.cloud.asset.v1.TemporalAsset_PriorAssetState" json:"prior_asset_state,omitempty"`
	// Prior copy of the asset. Populated if prior_asset_state is PRESENT.
	// Currently this is only set for responses in Real-Time Feed.
	PriorAsset *Asset `protobuf:"bytes,5,opt,name=prior_asset,json=priorAsset,proto3" json:"prior_asset,omitempty"`
}

func (x *TemporalAsset) Reset() {
	*x = TemporalAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TemporalAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TemporalAsset) ProtoMessage() {}

func (x *TemporalAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TemporalAsset.ProtoReflect.Descriptor instead.
func (*TemporalAsset) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{0}
}

func (x *TemporalAsset) GetWindow() *TimeWindow {
	if x != nil {
		return x.Window
	}
	return nil
}

func (x *TemporalAsset) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

func (x *TemporalAsset) GetAsset() *Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *TemporalAsset) GetPriorAssetState() TemporalAsset_PriorAssetState {
	if x != nil {
		return x.PriorAssetState
	}
	return TemporalAsset_PRIOR_ASSET_STATE_UNSPECIFIED
}

func (x *TemporalAsset) GetPriorAsset() *Asset {
	if x != nil {
		return x.PriorAsset
	}
	return nil
}

// A time window specified by its `start_time` and `end_time`.
type TimeWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time of the time window (exclusive).
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the time window (inclusive). If not specified, the current
	// timestamp is used instead.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TimeWindow) Reset() {
	*x = TimeWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeWindow) ProtoMessage() {}

func (x *TimeWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeWindow.ProtoReflect.Descriptor instead.
func (*TimeWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{1}
}

func (x *TimeWindow) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimeWindow) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// An asset in Google Cloud. An asset can be any resource in the Google Cloud
// [resource
// hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
// a resource outside the Google Cloud resource hierarchy (such as Google
// Kubernetes Engine clusters and objects), or a policy (e.g. Cloud IAM policy),
// or a relationship (e.g. an INSTANCE_TO_INSTANCEGROUP relationship).
// See [Supported asset
// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
// for more information.
type Asset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The last update timestamp of an asset. update_time is updated when
	// create/update/delete operation is performed.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The full name of the asset. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
	//
	// See [Resource
	// names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more information.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the asset. Example: `compute.googleapis.com/Disk`
	//
	// See [Supported asset
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// for more information.
	AssetType string `protobuf:"bytes,2,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// A representation of the resource.
	Resource *Resource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	// A representation of the Cloud IAM policy set on a Google Cloud resource.
	// There can be a maximum of one Cloud IAM policy set on any given resource.
	// In addition, Cloud IAM policies inherit their granted access scope from any
	// policies set on parent resources in the resource hierarchy. Therefore, the
	// effectively policy is the union of both the policy set on this resource
	// and each policy set on all of the resource's ancestry resource levels in
	// the hierarchy. See
	// [this topic](https://cloud.google.com/iam/docs/policies#inheritance) for
	// more information.
	IamPolicy *v1.Policy `protobuf:"bytes,4,opt,name=iam_policy,json=iamPolicy,proto3" json:"iam_policy,omitempty"`
	// A representation of an [organization
	// policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
	// There can be more than one organization policy with different constraints
	// set on a given resource.
	OrgPolicy []*v11.Policy `protobuf:"bytes,6,rep,name=org_policy,json=orgPolicy,proto3" json:"org_policy,omitempty"`
	// A representation of an [access
	// policy](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
	//
	// Types that are assignable to AccessContextPolicy:
	//	*Asset_AccessPolicy
	//	*Asset_AccessLevel
	//	*Asset_ServicePerimeter
	AccessContextPolicy isAsset_AccessContextPolicy `protobuf_oneof:"access_context_policy"`
	// A representation of runtime OS Inventory information. See [this
	// topic](https://cloud.google.com/compute/docs/instances/os-inventory-management)
	// for more information.
	OsInventory *v12.Inventory `protobuf:"bytes,12,opt,name=os_inventory,json=osInventory,proto3" json:"os_inventory,omitempty"`
	// DEPRECATED. This field only presents for the purpose of
	// backward-compatibility. The server will never generate responses with this
	// field.
	// The related assets of the asset of one relationship type. One asset
	// only represents one type of relationship.
	//
	// Deprecated: Do not use.
	RelatedAssets *RelatedAssets `protobuf:"bytes,13,opt,name=related_assets,json=relatedAssets,proto3" json:"related_assets,omitempty"`
	// One related asset of the current asset.
	RelatedAsset *RelatedAsset `protobuf:"bytes,15,opt,name=related_asset,json=relatedAsset,proto3" json:"related_asset,omitempty"`
	// The ancestry path of an asset in Google Cloud [resource
	// hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
	// represented as a list of relative resource names. An ancestry path starts
	// with the closest ancestor in the hierarchy and ends at root. If the asset
	// is a project, folder, or organization, the ancestry path starts from the
	// asset itself.
	//
	// Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
	Ancestors []string `protobuf:"bytes,10,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
}

func (x *Asset) Reset() {
	*x = Asset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset) ProtoMessage() {}

func (x *Asset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset.ProtoReflect.Descriptor instead.
func (*Asset) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{2}
}

func (x *Asset) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Asset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Asset) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *Asset) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *Asset) GetIamPolicy() *v1.Policy {
	if x != nil {
		return x.IamPolicy
	}
	return nil
}

func (x *Asset) GetOrgPolicy() []*v11.Policy {
	if x != nil {
		return x.OrgPolicy
	}
	return nil
}

func (m *Asset) GetAccessContextPolicy() isAsset_AccessContextPolicy {
	if m != nil {
		return m.AccessContextPolicy
	}
	return nil
}

func (x *Asset) GetAccessPolicy() *v13.AccessPolicy {
	if x, ok := x.GetAccessContextPolicy().(*Asset_AccessPolicy); ok {
		return x.AccessPolicy
	}
	return nil
}

func (x *Asset) GetAccessLevel() *v13.AccessLevel {
	if x, ok := x.GetAccessContextPolicy().(*Asset_AccessLevel); ok {
		return x.AccessLevel
	}
	return nil
}

func (x *Asset) GetServicePerimeter() *v13.ServicePerimeter {
	if x, ok := x.GetAccessContextPolicy().(*Asset_ServicePerimeter); ok {
		return x.ServicePerimeter
	}
	return nil
}

func (x *Asset) GetOsInventory() *v12.Inventory {
	if x != nil {
		return x.OsInventory
	}
	return nil
}

// Deprecated: Do not use.
func (x *Asset) GetRelatedAssets() *RelatedAssets {
	if x != nil {
		return x.RelatedAssets
	}
	return nil
}

func (x *Asset) GetRelatedAsset() *RelatedAsset {
	if x != nil {
		return x.RelatedAsset
	}
	return nil
}

func (x *Asset) GetAncestors() []string {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

type isAsset_AccessContextPolicy interface {
	isAsset_AccessContextPolicy()
}

type Asset_AccessPolicy struct {
	// Please also refer to the [access policy user
	// guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
	AccessPolicy *v13.AccessPolicy `protobuf:"bytes,7,opt,name=access_policy,json=accessPolicy,proto3,oneof"`
}

type Asset_AccessLevel struct {
	// Please also refer to the [access level user
	// guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
	AccessLevel *v13.AccessLevel `protobuf:"bytes,8,opt,name=access_level,json=accessLevel,proto3,oneof"`
}

type Asset_ServicePerimeter struct {
	// Please also refer to the [service perimeter user
	// guide](https://cloud.google.com/vpc-service-controls/docs/overview).
	ServicePerimeter *v13.ServicePerimeter `protobuf:"bytes,9,opt,name=service_perimeter,json=servicePerimeter,proto3,oneof"`
}

func (*Asset_AccessPolicy) isAsset_AccessContextPolicy() {}

func (*Asset_AccessLevel) isAsset_AccessContextPolicy() {}

func (*Asset_ServicePerimeter) isAsset_AccessContextPolicy() {}

// A representation of a Google Cloud resource.
type Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The API version. Example: `v1`
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The URL of the discovery document containing the resource's JSON schema.
	// Example:
	// `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest`
	//
	// This value is unspecified for resources that do not have an API based on a
	// discovery document, such as Cloud Bigtable.
	DiscoveryDocumentUri string `protobuf:"bytes,2,opt,name=discovery_document_uri,json=discoveryDocumentUri,proto3" json:"discovery_document_uri,omitempty"`
	// The JSON schema name listed in the discovery document. Example:
	// `Project`
	//
	// This value is unspecified for resources that do not have an API based on a
	// discovery document, such as Cloud Bigtable.
	DiscoveryName string `protobuf:"bytes,3,opt,name=discovery_name,json=discoveryName,proto3" json:"discovery_name,omitempty"`
	// The REST URL for accessing the resource. An HTTP `GET` request using this
	// URL returns the resource itself. Example:
	// `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
	//
	// This value is unspecified for resources without a REST API.
	ResourceUrl string `protobuf:"bytes,4,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	// The full name of the immediate parent of this resource. See
	// [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more information.
	//
	// For Google Cloud assets, this value is the parent resource defined in the
	// [Cloud IAM policy
	// hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
	// Example:
	// `//cloudresourcemanager.googleapis.com/projects/my_project_123`
	//
	// For third-party assets, this field may be set differently.
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	// The content of the resource, in which some sensitive fields are removed
	// and may not be present.
	Data *structpb.Struct `protobuf:"bytes,6,opt,name=data,proto3" json:"data,omitempty"`
	// The location of the resource in Google Cloud, such as its zone and region.
	// For more information, see https://cloud.google.com/about/locations/.
	Location string `protobuf:"bytes,8,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *Resource) Reset() {
	*x = Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{3}
}

func (x *Resource) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Resource) GetDiscoveryDocumentUri() string {
	if x != nil {
		return x.DiscoveryDocumentUri
	}
	return ""
}

func (x *Resource) GetDiscoveryName() string {
	if x != nil {
		return x.DiscoveryName
	}
	return ""
}

func (x *Resource) GetResourceUrl() string {
	if x != nil {
		return x.ResourceUrl
	}
	return ""
}

func (x *Resource) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *Resource) GetData() *structpb.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Resource) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// DEPRECATED. This message only presents for the purpose of
// backward-compatibility. The server will never populate this message in
// responses.
// The detailed related assets with the `relationship_type`.
//
// Deprecated: Do not use.
type RelatedAssets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The detailed relationship attributes.
	RelationshipAttributes *RelationshipAttributes `protobuf:"bytes,1,opt,name=relationship_attributes,json=relationshipAttributes,proto3" json:"relationship_attributes,omitempty"`
	// The peer resources of the relationship.
	Assets []*RelatedAsset `protobuf:"bytes,2,rep,name=assets,proto3" json:"assets,omitempty"`
}

func (x *RelatedAssets) Reset() {
	*x = RelatedAssets{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelatedAssets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelatedAssets) ProtoMessage() {}

func (x *RelatedAssets) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelatedAssets.ProtoReflect.Descriptor instead.
func (*RelatedAssets) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{4}
}

func (x *RelatedAssets) GetRelationshipAttributes() *RelationshipAttributes {
	if x != nil {
		return x.RelationshipAttributes
	}
	return nil
}

func (x *RelatedAssets) GetAssets() []*RelatedAsset {
	if x != nil {
		return x.Assets
	}
	return nil
}

// DEPRECATED. This message only presents for the purpose of
// backward-compatibility. The server will never populate this message in
// responses.
// The relationship attributes which include  `type`, `source_resource_type`,
// `target_resource_type` and `action`.
//
// Deprecated: Do not use.
type RelationshipAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the relationship type. Example:
	// `INSTANCE_TO_INSTANCEGROUP`
	Type string `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	// The source asset type. Example: `compute.googleapis.com/Instance`
	SourceResourceType string `protobuf:"bytes,1,opt,name=source_resource_type,json=sourceResourceType,proto3" json:"source_resource_type,omitempty"`
	// The target asset type. Example: `compute.googleapis.com/Disk`
	TargetResourceType string `protobuf:"bytes,2,opt,name=target_resource_type,json=targetResourceType,proto3" json:"target_resource_type,omitempty"`
	// The detail of the relationship, e.g. `contains`, `attaches`
	Action string `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *RelationshipAttributes) Reset() {
	*x = RelationshipAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelationshipAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelationshipAttributes) ProtoMessage() {}

func (x *RelationshipAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelationshipAttributes.ProtoReflect.Descriptor instead.
func (*RelationshipAttributes) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{5}
}

func (x *RelationshipAttributes) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *RelationshipAttributes) GetSourceResourceType() string {
	if x != nil {
		return x.SourceResourceType
	}
	return ""
}

func (x *RelationshipAttributes) GetTargetResourceType() string {
	if x != nil {
		return x.TargetResourceType
	}
	return ""
}

func (x *RelationshipAttributes) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

// An asset identifier in Google Cloud which contains its name, type and
// ancestors. An asset can be any resource in the Google Cloud [resource
// hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
// a resource outside the Google Cloud resource hierarchy (such as Google
// Kubernetes Engine clusters and objects), or a policy (e.g. Cloud IAM policy).
// See [Supported asset
// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
// for more information.
type RelatedAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full name of the asset. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
	//
	// See [Resource
	// names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more information.
	Asset string `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
	// The type of the asset. Example: `compute.googleapis.com/Disk`
	//
	// See [Supported asset
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// for more information.
	AssetType string `protobuf:"bytes,2,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// The ancestors of an asset in Google Cloud [resource
	// hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
	// represented as a list of relative resource names. An ancestry path starts
	// with the closest ancestor in the hierarchy and ends at root.
	//
	// Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
	Ancestors []string `protobuf:"bytes,3,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
	// The unique identifier of the relationship type. Example:
	// `INSTANCE_TO_INSTANCEGROUP`
	RelationshipType string `protobuf:"bytes,4,opt,name=relationship_type,json=relationshipType,proto3" json:"relationship_type,omitempty"`
}

func (x *RelatedAsset) Reset() {
	*x = RelatedAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelatedAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelatedAsset) ProtoMessage() {}

func (x *RelatedAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelatedAsset.ProtoReflect.Descriptor instead.
func (*RelatedAsset) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{6}
}

func (x *RelatedAsset) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

func (x *RelatedAsset) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *RelatedAsset) GetAncestors() []string {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

func (x *RelatedAsset) GetRelationshipType() string {
	if x != nil {
		return x.RelationshipType
	}
	return ""
}

// A result of Resource Search, containing information of a cloud resource.
type ResourceSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of this resource. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Cloud Asset Inventory Resource Name
	// Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for more information.
	//
	// To search against the `name`:
	//
	// * use a field query. Example: `name:instance1`
	// * use a free text query. Example: `instance1`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of this resource. Example: `compute.googleapis.com/Disk`.
	//
	// To search against the `asset_type`:
	//
	// * specify the `asset_type` field in your search request.
	AssetType string `protobuf:"bytes,2,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// The project that this resource belongs to, in the form of
	// projects/{PROJECT_NUMBER}. This field is available when the resource
	// belongs to a project.
	//
	// To search against `project`:
	//
	// * use a field query. Example: `project:12345`
	// * use a free text query. Example: `12345`
	// * specify the `scope` field as this project in your search request.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
	// The folder(s) that this resource belongs to, in the form of
	// folders/{FOLDER_NUMBER}. This field is available when the resource
	// belongs to one or more folders.
	//
	// To search against `folders`:
	//
	// * use a field query. Example: `folders:(123 OR 456)`
	// * use a free text query. Example: `123`
	// * specify the `scope` field as this folder in your search request.
	Folders []string `protobuf:"bytes,17,rep,name=folders,proto3" json:"folders,omitempty"`
	// The organization that this resource belongs to, in the form of
	// organizations/{ORGANIZATION_NUMBER}. This field is available when the
	// resource belongs to an organization.
	//
	// To search against `organization`:
	//
	// * use a field query. Example: `organization:123`
	// * use a free text query. Example: `123`
	// * specify the `scope` field as this organization in your search request.
	Organization string `protobuf:"bytes,18,opt,name=organization,proto3" json:"organization,omitempty"`
	// The display name of this resource. This field is available only when the
	// resource's Protobuf contains it.
	//
	// To search against the `display_name`:
	//
	// * use a field query. Example: `displayName:"My Instance"`
	// * use a free text query. Example: `"My Instance"`
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// One or more paragraphs of text description of this resource. Maximum length
	// could be up to 1M bytes. This field is available only when the resource's
	// Protobuf contains it.
	//
	// To search against the `description`:
	//
	// * use a field query. Example: `description:"important instance"`
	// * use a free text query. Example: `"important instance"`
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Location can be `global`, regional like `us-east1`, or zonal like
	// `us-west1-b`. This field is available only when the resource's Protobuf
	// contains it.
	//
	// To search against the `location`:
	//
	// * use a field query. Example: `location:us-west*`
	// * use a free text query. Example: `us-west*`
	Location string `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
	// Labels associated with this resource. See [Labelling and grouping GCP
	// resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
	// for more information. This field is available only when the resource's
	// Protobuf contains it.
	//
	// To search against the `labels`:
	//
	// * use a field query:
	//     - query on any label's key or value. Example: `labels:prod`
	//     - query by a given label. Example: `labels.env:prod`
	//     - query by a given label's existence. Example: `labels.env:*`
	// * use a free text query. Example: `prod`
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Network tags associated with this resource. Like labels, network tags are a
	// type of annotations used to group GCP resources. See [Labelling GCP
	// resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
	// for more information. This field is available only when the resource's
	// Protobuf contains it.
	//
	// To search against the `network_tags`:
	//
	// * use a field query. Example: `networkTags:internal`
	// * use a free text query. Example: `internal`
	NetworkTags []string `protobuf:"bytes,8,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// The Cloud KMS
	// [CryptoKey](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
	// name or
	// [CryptoKeyVersion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
	// name. This field is available only when the resource's Protobuf contains
	// it.
	//
	// To search against the `kms_key`:
	//
	// * use a field query. Example: `kmsKey:key`
	// * use a free text query. Example: `key`
	KmsKey string `protobuf:"bytes,10,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
	// The create timestamp of this resource, at which the resource was created.
	// The granularity is in seconds. Timestamp.nanos will always be 0. This field
	// is available only when the resource's Protobuf contains it.
	//
	// To search against `create_time`:
	//
	// * use a field query.
	//     - value in seconds since unix epoch. Example: `createTime > 1609459200`
	//     - value in date string. Example: `createTime > 2021-01-01`
	//     - value in date-time string (must be quoted). Example: `createTime >
	//     "2021-01-01T00:00:00"`
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last update timestamp of this resource, at which the resource was last
	// modified or deleted. The granularity is in seconds. Timestamp.nanos will
	// always be 0. This field is available only when the resource's Protobuf
	// contains it.
	//
	// To search against `update_time`:
	//
	// * use a field query.
	//     - value in seconds since unix epoch. Example: `updateTime < 1609459200`
	//     - value in date string. Example: `updateTime < 2021-01-01`
	//     - value in date-time string (must be quoted). Example: `updateTime <
	//     "2021-01-01T00:00:00"`
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The state of this resource. Different resources types have different state
	// definitions that are mapped from various fields of different resource
	// types. This field is available only when the resource's Protobuf contains
	// it.
	//
	// Example:
	// If the resource is an instance provided by Compute Engine,
	// its state will include PROVISIONING, STAGING, RUNNING, STOPPING,
	// SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. See `status` definition
	// in [API
	// Reference](https://cloud.google.com/compute/docs/reference/rest/v1/instances).
	// If the resource is a project provided by Cloud Resource Manager, its state
	// will include LIFECYCLE_STATE_UNSPECIFIED, ACTIVE, DELETE_REQUESTED and
	// DELETE_IN_PROGRESS. See `lifecycleState` definition in [API
	// Reference](https://cloud.google.com/resource-manager/reference/rest/v1/projects).
	//
	// To search against the `state`:
	//
	// * use a field query. Example: `state:RUNNING`
	// * use a free text query. Example: `RUNNING`
	State string `protobuf:"bytes,13,opt,name=state,proto3" json:"state,omitempty"`
	// The additional searchable attributes of this resource. The attributes may
	// vary from one resource type to another. Examples: `projectId` for Project,
	// `dnsName` for DNS ManagedZone. This field contains a subset of the resource
	// metadata fields that are returned by the List or Get APIs provided by the
	// corresponding GCP service (e.g., Compute Engine). see [API references and
	// supported searchable
	// attributes](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types)
	// to see which fields are included.
	//
	// You can search values of these fields through free text search. However,
	// you should not consume the field programically as the field names and
	// values may change as the GCP service updates to a new incompatible API
	// version.
	//
	// To search against the `additional_attributes`:
	//
	// * use a free text query to match the attributes values. Example: to search
	//   `additional_attributes = { dnsName: "foobar" }`, you can issue a query
	//   `foobar`.
	AdditionalAttributes *structpb.Struct `protobuf:"bytes,9,opt,name=additional_attributes,json=additionalAttributes,proto3" json:"additional_attributes,omitempty"`
	// The full resource name of this resource's parent, if it has one.
	// To search against the `parent_full_resource_name`:
	//
	// * use a field query. Example:
	// `parentFullResourceName:"project-name"`
	// * use a free text query. Example:
	// `project-name`
	ParentFullResourceName string `protobuf:"bytes,19,opt,name=parent_full_resource_name,json=parentFullResourceName,proto3" json:"parent_full_resource_name,omitempty"`
	// Versioned resource representations of this resource. This is repeated
	// because there could be multiple versions of resource representations during
	// version migration.
	//
	// This `versioned_resources` field is not searchable. Some attributes of the
	// resource representations are exposed in `additional_attributes` field, so
	// as to allow users to search on them.
	VersionedResources []*VersionedResource `protobuf:"bytes,16,rep,name=versioned_resources,json=versionedResources,proto3" json:"versioned_resources,omitempty"`
	// Attached resources of this resource. For example, an OSConfig
	// Inventory is an attached resource of a Compute Instance. This field is
	// repeated because a resource could have multiple attached resources.
	//
	// This `attached_resources` field is not searchable. Some attributes
	// of the attached resources are exposed in `additional_attributes` field, so
	// as to allow users to search on them.
	AttachedResources []*AttachedResource `protobuf:"bytes,20,rep,name=attached_resources,json=attachedResources,proto3" json:"attached_resources,omitempty"`
	// A map of related resources of this resource, keyed by the
	// relationship type. A relationship type is in the format of
	// {SourceType}_{ACTION}_{DestType}. Example: `DISK_TO_INSTANCE`,
	// `DISK_TO_NETWORK`, `INSTANCE_TO_INSTANCEGROUP`.
	// See [supported relationship
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#supported_relationship_types).
	Relationships map[string]*RelatedResources `protobuf:"bytes,21,rep,name=relationships,proto3" json:"relationships,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// TagKey namespaced names, in the format of {ORG_ID}/{TAG_KEY_SHORT_NAME}.
	// To search against the `tagKeys`:
	//
	// * use a field query. Example:
	//     - `tagKeys:"123456789/env*"`
	//     - `tagKeys="123456789/env"`
	//     - `tagKeys:"env"`
	//
	// * use a free text query. Example:
	//     - `env`
	TagKeys []string `protobuf:"bytes,23,rep,name=tag_keys,json=tagKeys,proto3" json:"tag_keys,omitempty"`
	// TagValue namespaced names, in the format of
	// {ORG_ID}/{TAG_KEY_SHORT_NAME}/{TAG_VALUE_SHORT_NAME}.
	// To search against the `tagValues`:
	//
	// * use a field query. Example:
	//     - `tagValues:"env"`
	//     - `tagValues:"env/prod"`
	//     - `tagValues:"123456789/env/prod*"`
	//     - `tagValues="123456789/env/prod"`
	//
	// * use a free text query. Example:
	//     - `prod`
	TagValues []string `protobuf:"bytes,25,rep,name=tag_values,json=tagValues,proto3" json:"tag_values,omitempty"`
	// TagValue IDs, in the format of tagValues/{TAG_VALUE_ID}.
	// To search against the `tagValueIds`:
	//
	// * use a field query. Example:
	//     - `tagValueIds:"456"`
	//     - `tagValueIds="tagValues/456"`
	//
	// * use a free text query. Example:
	//     - `456`
	TagValueIds []string `protobuf:"bytes,26,rep,name=tag_value_ids,json=tagValueIds,proto3" json:"tag_value_ids,omitempty"`
	// The type of this resource's immediate parent, if there is one.
	//
	// To search against the `parent_asset_type`:
	//
	// * use a field query. Example:
	// `parentAssetType:"cloudresourcemanager.googleapis.com/Project"`
	// * use a free text query. Example:
	// `cloudresourcemanager.googleapis.com/Project`
	ParentAssetType string `protobuf:"bytes,103,opt,name=parent_asset_type,json=parentAssetType,proto3" json:"parent_asset_type,omitempty"`
}

func (x *ResourceSearchResult) Reset() {
	*x = ResourceSearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceSearchResult) ProtoMessage() {}

func (x *ResourceSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceSearchResult.ProtoReflect.Descriptor instead.
func (*ResourceSearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{7}
}

func (x *ResourceSearchResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResourceSearchResult) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *ResourceSearchResult) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ResourceSearchResult) GetFolders() []string {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *ResourceSearchResult) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *ResourceSearchResult) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ResourceSearchResult) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ResourceSearchResult) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ResourceSearchResult) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ResourceSearchResult) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *ResourceSearchResult) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

func (x *ResourceSearchResult) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ResourceSearchResult) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ResourceSearchResult) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *ResourceSearchResult) GetAdditionalAttributes() *structpb.Struct {
	if x != nil {
		return x.AdditionalAttributes
	}
	return nil
}

func (x *ResourceSearchResult) GetParentFullResourceName() string {
	if x != nil {
		return x.ParentFullResourceName
	}
	return ""
}

func (x *ResourceSearchResult) GetVersionedResources() []*VersionedResource {
	if x != nil {
		return x.VersionedResources
	}
	return nil
}

func (x *ResourceSearchResult) GetAttachedResources() []*AttachedResource {
	if x != nil {
		return x.AttachedResources
	}
	return nil
}

func (x *ResourceSearchResult) GetRelationships() map[string]*RelatedResources {
	if x != nil {
		return x.Relationships
	}
	return nil
}

func (x *ResourceSearchResult) GetTagKeys() []string {
	if x != nil {
		return x.TagKeys
	}
	return nil
}

func (x *ResourceSearchResult) GetTagValues() []string {
	if x != nil {
		return x.TagValues
	}
	return nil
}

func (x *ResourceSearchResult) GetTagValueIds() []string {
	if x != nil {
		return x.TagValueIds
	}
	return nil
}

func (x *ResourceSearchResult) GetParentAssetType() string {
	if x != nil {
		return x.ParentAssetType
	}
	return ""
}

// Resource representation as defined by the corresponding service providing the
// resource for a given API version.
type VersionedResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// API version of the resource.
	//
	// Example:
	// If the resource is an instance provided by Compute Engine v1 API as defined
	// in `https://cloud.google.com/compute/docs/reference/rest/v1/instances`,
	// version will be "v1".
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// JSON representation of the resource as defined by the corresponding
	// service providing this resource.
	//
	// Example:
	// If the resource is an instance provided by Compute Engine, this field will
	// contain the JSON representation of the instance as defined by Compute
	// Engine:
	// `https://cloud.google.com/compute/docs/reference/rest/v1/instances`.
	//
	// You can find the resource definition for each supported resource type in
	// this table:
	// `https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types`
	Resource *structpb.Struct `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *VersionedResource) Reset() {
	*x = VersionedResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionedResource) ProtoMessage() {}

func (x *VersionedResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionedResource.ProtoReflect.Descriptor instead.
func (*VersionedResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{8}
}

func (x *VersionedResource) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *VersionedResource) GetResource() *structpb.Struct {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Attached resource representation, which is defined by the corresponding
// service provider. It represents an attached resource's payload.
type AttachedResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of this attached resource.
	//
	// Example: `osconfig.googleapis.com/Inventory`
	//
	// You can find the supported attached asset types of each resource in this
	// table:
	// `https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types`
	AssetType string `protobuf:"bytes,1,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// Versioned resource representations of this attached resource. This is
	// repeated because there could be multiple versions of the attached resource
	// representations during version migration.
	VersionedResources []*VersionedResource `protobuf:"bytes,3,rep,name=versioned_resources,json=versionedResources,proto3" json:"versioned_resources,omitempty"`
}

func (x *AttachedResource) Reset() {
	*x = AttachedResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttachedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedResource) ProtoMessage() {}

func (x *AttachedResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedResource.ProtoReflect.Descriptor instead.
func (*AttachedResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{9}
}

func (x *AttachedResource) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *AttachedResource) GetVersionedResources() []*VersionedResource {
	if x != nil {
		return x.VersionedResources
	}
	return nil
}

// The related resources of the primary resource.
type RelatedResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The detailed related resources of the primary resource.
	RelatedResources []*RelatedResource `protobuf:"bytes,1,rep,name=related_resources,json=relatedResources,proto3" json:"related_resources,omitempty"`
}

func (x *RelatedResources) Reset() {
	*x = RelatedResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelatedResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelatedResources) ProtoMessage() {}

func (x *RelatedResources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelatedResources.ProtoReflect.Descriptor instead.
func (*RelatedResources) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{10}
}

func (x *RelatedResources) GetRelatedResources() []*RelatedResource {
	if x != nil {
		return x.RelatedResources
	}
	return nil
}

// The detailed related resource.
type RelatedResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the asset. Example: `compute.googleapis.com/Instance`
	AssetType string `protobuf:"bytes,1,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// The full resource name of the related resource. Example:
	// `//compute.googleapis.com/projects/my_proj_123/zones/instance/instance123`
	FullResourceName string `protobuf:"bytes,2,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
}

func (x *RelatedResource) Reset() {
	*x = RelatedResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelatedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelatedResource) ProtoMessage() {}

func (x *RelatedResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelatedResource.ProtoReflect.Descriptor instead.
func (*RelatedResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{11}
}

func (x *RelatedResource) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *RelatedResource) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

// A result of IAM Policy search, containing information of an IAM policy.
type IamPolicySearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of the resource associated with this IAM policy.
	// Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Cloud Asset Inventory Resource Name
	// Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for more information.
	//
	// To search against the `resource`:
	//
	// * use a field query. Example: `resource:organizations/123`
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The type of the resource associated with this IAM policy. Example:
	// `compute.googleapis.com/Disk`.
	//
	// To search against the `asset_type`:
	//
	// * specify the `asset_types` field in your search request.
	AssetType string `protobuf:"bytes,5,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// The project that the associated GCP resource belongs to, in the form of
	// projects/{PROJECT_NUMBER}. If an IAM policy is set on a resource (like VM
	// instance, Cloud Storage bucket), the project field will indicate the
	// project that contains the resource. If an IAM policy is set on a folder or
	// orgnization, this field will be empty.
	//
	// To search against the `project`:
	//
	// * specify the `scope` field as this project in your search request.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// The folder(s) that the IAM policy belongs to, in the form of
	// folders/{FOLDER_NUMBER}. This field is available when the IAM policy
	// belongs to one or more folders.
	//
	// To search against `folders`:
	//
	// * use a field query. Example: `folders:(123 OR 456)`
	// * use a free text query. Example: `123`
	// * specify the `scope` field as this folder in your search request.
	Folders []string `protobuf:"bytes,6,rep,name=folders,proto3" json:"folders,omitempty"`
	// The organization that the IAM policy belongs to, in the form
	// of organizations/{ORGANIZATION_NUMBER}. This field is available when the
	// IAM policy belongs to an organization.
	//
	// To search against `organization`:
	//
	// * use a field query. Example: `organization:123`
	// * use a free text query. Example: `123`
	// * specify the `scope` field as this organization in your search request.
	Organization string `protobuf:"bytes,7,opt,name=organization,proto3" json:"organization,omitempty"`
	// The IAM policy directly set on the given resource. Note that the original
	// IAM policy can contain multiple bindings. This only contains the bindings
	// that match the given query. For queries that don't contain a constrain on
	// policies (e.g., an empty query), this contains all the bindings.
	//
	// To search against the `policy` bindings:
	//
	// * use a field query:
	//     - query by the policy contained members. Example:
	//       `policy:amy@gmail.com`
	//     - query by the policy contained roles. Example:
	//       `policy:roles/compute.admin`
	//     - query by the policy contained roles' included permissions. Example:
	//       `policy.role.permissions:compute.instances.create`
	Policy *v1.Policy `protobuf:"bytes,3,opt,name=policy,proto3" json:"policy,omitempty"`
	// Explanation about the IAM policy search result. It contains additional
	// information to explain why the search result matches the query.
	Explanation *IamPolicySearchResult_Explanation `protobuf:"bytes,4,opt,name=explanation,proto3" json:"explanation,omitempty"`
}

func (x *IamPolicySearchResult) Reset() {
	*x = IamPolicySearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicySearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicySearchResult) ProtoMessage() {}

func (x *IamPolicySearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicySearchResult.ProtoReflect.Descriptor instead.
func (*IamPolicySearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{12}
}

func (x *IamPolicySearchResult) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *IamPolicySearchResult) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *IamPolicySearchResult) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *IamPolicySearchResult) GetFolders() []string {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *IamPolicySearchResult) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *IamPolicySearchResult) GetPolicy() *v1.Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *IamPolicySearchResult) GetExplanation() *IamPolicySearchResult_Explanation {
	if x != nil {
		return x.Explanation
	}
	return nil
}

// Represents the detailed state of an entity under analysis, such as a
// resource, an identity or an access.
type IamPolicyAnalysisState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google standard error code that best describes the state.
	// For example:
	// - OK means the analysis on this entity has been successfully finished;
	// - PERMISSION_DENIED means an access denied error is encountered;
	// - DEADLINE_EXCEEDED means the analysis on this entity hasn't been started
	// in time;
	Code code.Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.rpc.Code" json:"code,omitempty"`
	// The human-readable description of the cause of failure.
	Cause string `protobuf:"bytes,2,opt,name=cause,proto3" json:"cause,omitempty"`
}

func (x *IamPolicyAnalysisState) Reset() {
	*x = IamPolicyAnalysisState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisState) ProtoMessage() {}

func (x *IamPolicyAnalysisState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisState.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisState) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{13}
}

func (x *IamPolicyAnalysisState) GetCode() code.Code {
	if x != nil {
		return x.Code
	}
	return code.Code_OK
}

func (x *IamPolicyAnalysisState) GetCause() string {
	if x != nil {
		return x.Cause
	}
	return ""
}

// The Condition evaluation.
type ConditionEvaluation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The evaluation result.
	EvaluationValue ConditionEvaluation_EvaluationValue `protobuf:"varint,1,opt,name=evaluation_value,json=evaluationValue,proto3,enum=google.cloud.asset.v1.ConditionEvaluation_EvaluationValue" json:"evaluation_value,omitempty"`
}

func (x *ConditionEvaluation) Reset() {
	*x = ConditionEvaluation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionEvaluation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionEvaluation) ProtoMessage() {}

func (x *ConditionEvaluation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionEvaluation.ProtoReflect.Descriptor instead.
func (*ConditionEvaluation) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{14}
}

func (x *ConditionEvaluation) GetEvaluationValue() ConditionEvaluation_EvaluationValue {
	if x != nil {
		return x.EvaluationValue
	}
	return ConditionEvaluation_EVALUATION_VALUE_UNSPECIFIED
}

// IAM Policy analysis result, consisting of one IAM policy binding and derived
// access control lists.
type IamPolicyAnalysisResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [full resource
	// name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// of the resource to which the
	// [iam_binding][google.cloud.asset.v1.IamPolicyAnalysisResult.iam_binding]
	// policy attaches.
	AttachedResourceFullName string `protobuf:"bytes,1,opt,name=attached_resource_full_name,json=attachedResourceFullName,proto3" json:"attached_resource_full_name,omitempty"`
	// The Cloud IAM policy binding under analysis.
	IamBinding *v1.Binding `protobuf:"bytes,2,opt,name=iam_binding,json=iamBinding,proto3" json:"iam_binding,omitempty"`
	// The access control lists derived from the
	// [iam_binding][google.cloud.asset.v1.IamPolicyAnalysisResult.iam_binding]
	// that match or potentially match resource and access selectors specified in
	// the request.
	AccessControlLists []*IamPolicyAnalysisResult_AccessControlList `protobuf:"bytes,3,rep,name=access_control_lists,json=accessControlLists,proto3" json:"access_control_lists,omitempty"`
	// The identity list derived from members of the
	// [iam_binding][google.cloud.asset.v1.IamPolicyAnalysisResult.iam_binding]
	// that match or potentially match identity selector specified in the request.
	IdentityList *IamPolicyAnalysisResult_IdentityList `protobuf:"bytes,4,opt,name=identity_list,json=identityList,proto3" json:"identity_list,omitempty"`
	// Represents whether all analyses on the
	// [iam_binding][google.cloud.asset.v1.IamPolicyAnalysisResult.iam_binding]
	// have successfully finished.
	FullyExplored bool `protobuf:"varint,5,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
}

func (x *IamPolicyAnalysisResult) Reset() {
	*x = IamPolicyAnalysisResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult) ProtoMessage() {}

func (x *IamPolicyAnalysisResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{15}
}

func (x *IamPolicyAnalysisResult) GetAttachedResourceFullName() string {
	if x != nil {
		return x.AttachedResourceFullName
	}
	return ""
}

func (x *IamPolicyAnalysisResult) GetIamBinding() *v1.Binding {
	if x != nil {
		return x.IamBinding
	}
	return nil
}

func (x *IamPolicyAnalysisResult) GetAccessControlLists() []*IamPolicyAnalysisResult_AccessControlList {
	if x != nil {
		return x.AccessControlLists
	}
	return nil
}

func (x *IamPolicyAnalysisResult) GetIdentityList() *IamPolicyAnalysisResult_IdentityList {
	if x != nil {
		return x.IdentityList
	}
	return nil
}

func (x *IamPolicyAnalysisResult) GetFullyExplored() bool {
	if x != nil {
		return x.FullyExplored
	}
	return false
}

// Explanation about the IAM policy search result.
type IamPolicySearchResult_Explanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The map from roles to their included permissions that match the
	// permission query (i.e., a query containing `policy.role.permissions:`).
	// Example: if query `policy.role.permissions:compute.disk.get`
	// matches a policy binding that contains owner role, the
	// matched_permissions will be `{"roles/owner": ["compute.disk.get"]}`. The
	// roles can also be found in the returned `policy` bindings. Note that the
	// map is populated only for requests with permission queries.
	MatchedPermissions map[string]*IamPolicySearchResult_Explanation_Permissions `protobuf:"bytes,1,rep,name=matched_permissions,json=matchedPermissions,proto3" json:"matched_permissions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *IamPolicySearchResult_Explanation) Reset() {
	*x = IamPolicySearchResult_Explanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicySearchResult_Explanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicySearchResult_Explanation) ProtoMessage() {}

func (x *IamPolicySearchResult_Explanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicySearchResult_Explanation.ProtoReflect.Descriptor instead.
func (*IamPolicySearchResult_Explanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{12, 0}
}

func (x *IamPolicySearchResult_Explanation) GetMatchedPermissions() map[string]*IamPolicySearchResult_Explanation_Permissions {
	if x != nil {
		return x.MatchedPermissions
	}
	return nil
}

// IAM permissions
type IamPolicySearchResult_Explanation_Permissions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of permissions. A sample permission string: `compute.disk.get`.
	Permissions []string `protobuf:"bytes,1,rep,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *IamPolicySearchResult_Explanation_Permissions) Reset() {
	*x = IamPolicySearchResult_Explanation_Permissions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicySearchResult_Explanation_Permissions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicySearchResult_Explanation_Permissions) ProtoMessage() {}

func (x *IamPolicySearchResult_Explanation_Permissions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicySearchResult_Explanation_Permissions.ProtoReflect.Descriptor instead.
func (*IamPolicySearchResult_Explanation_Permissions) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{12, 0, 0}
}

func (x *IamPolicySearchResult_Explanation_Permissions) GetPermissions() []string {
	if x != nil {
		return x.Permissions
	}
	return nil
}

// A Google Cloud resource under analysis.
type IamPolicyAnalysisResult_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [full resource
	// name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// The analysis state of this resource.
	AnalysisState *IamPolicyAnalysisState `protobuf:"bytes,2,opt,name=analysis_state,json=analysisState,proto3" json:"analysis_state,omitempty"`
}

func (x *IamPolicyAnalysisResult_Resource) Reset() {
	*x = IamPolicyAnalysisResult_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Resource) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Resource.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{15, 0}
}

func (x *IamPolicyAnalysisResult_Resource) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Resource) GetAnalysisState() *IamPolicyAnalysisState {
	if x != nil {
		return x.AnalysisState
	}
	return nil
}

// An IAM role or permission under analysis.
type IamPolicyAnalysisResult_Access struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OneofAccess:
	//	*IamPolicyAnalysisResult_Access_Role
	//	*IamPolicyAnalysisResult_Access_Permission
	OneofAccess isIamPolicyAnalysisResult_Access_OneofAccess `protobuf_oneof:"oneof_access"`
	// The analysis state of this access.
	AnalysisState *IamPolicyAnalysisState `protobuf:"bytes,3,opt,name=analysis_state,json=analysisState,proto3" json:"analysis_state,omitempty"`
}

func (x *IamPolicyAnalysisResult_Access) Reset() {
	*x = IamPolicyAnalysisResult_Access{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Access) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Access) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Access.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Access) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{15, 1}
}

func (m *IamPolicyAnalysisResult_Access) GetOneofAccess() isIamPolicyAnalysisResult_Access_OneofAccess {
	if m != nil {
		return m.OneofAccess
	}
	return nil
}

func (x *IamPolicyAnalysisResult_Access) GetRole() string {
	if x, ok := x.GetOneofAccess().(*IamPolicyAnalysisResult_Access_Role); ok {
		return x.Role
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Access) GetPermission() string {
	if x, ok := x.GetOneofAccess().(*IamPolicyAnalysisResult_Access_Permission); ok {
		return x.Permission
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Access) GetAnalysisState() *IamPolicyAnalysisState {
	if x != nil {
		return x.AnalysisState
	}
	return nil
}

type isIamPolicyAnalysisResult_Access_OneofAccess interface {
	isIamPolicyAnalysisResult_Access_OneofAccess()
}

type IamPolicyAnalysisResult_Access_Role struct {
	// The role.
	Role string `protobuf:"bytes,1,opt,name=role,proto3,oneof"`
}

type IamPolicyAnalysisResult_Access_Permission struct {
	// The permission.
	Permission string `protobuf:"bytes,2,opt,name=permission,proto3,oneof"`
}

func (*IamPolicyAnalysisResult_Access_Role) isIamPolicyAnalysisResult_Access_OneofAccess() {}

func (*IamPolicyAnalysisResult_Access_Permission) isIamPolicyAnalysisResult_Access_OneofAccess() {}

// An identity under analysis.
type IamPolicyAnalysisResult_Identity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identity name in any form of members appear in
	// [IAM policy
	// binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
	// as:
	// - user:foo@google.com
	// - group:group1@google.com
	// - serviceAccount:s1@prj1.iam.gserviceaccount.com
	// - projectOwner:some_project_id
	// - domain:google.com
	// - allUsers
	// - etc.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The analysis state of this identity.
	AnalysisState *IamPolicyAnalysisState `protobuf:"bytes,2,opt,name=analysis_state,json=analysisState,proto3" json:"analysis_state,omitempty"`
}

func (x *IamPolicyAnalysisResult_Identity) Reset() {
	*x = IamPolicyAnalysisResult_Identity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Identity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Identity) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Identity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Identity.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Identity) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{15, 2}
}

func (x *IamPolicyAnalysisResult_Identity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Identity) GetAnalysisState() *IamPolicyAnalysisState {
	if x != nil {
		return x.AnalysisState
	}
	return nil
}

// A directional edge.
type IamPolicyAnalysisResult_Edge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source node of the edge. For example, it could be a full resource
	// name for a resource node or an email of an identity.
	SourceNode string `protobuf:"bytes,1,opt,name=source_node,json=sourceNode,proto3" json:"source_node,omitempty"`
	// The target node of the edge. For example, it could be a full resource
	// name for a resource node or an email of an identity.
	TargetNode string `protobuf:"bytes,2,opt,name=target_node,json=targetNode,proto3" json:"target_node,omitempty"`
}

func (x *IamPolicyAnalysisResult_Edge) Reset() {
	*x = IamPolicyAnalysisResult_Edge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Edge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Edge) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Edge) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Edge.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Edge) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{15, 3}
}

func (x *IamPolicyAnalysisResult_Edge) GetSourceNode() string {
	if x != nil {
		return x.SourceNode
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Edge) GetTargetNode() string {
	if x != nil {
		return x.TargetNode
	}
	return ""
}

// An access control list, derived from the above IAM policy binding, which
// contains a set of resources and accesses. May include one
// item from each set to compose an access control entry.
//
// NOTICE that there could be multiple access control lists for one IAM policy
// binding. The access control lists are created based on resource and access
// combinations.
//
// For example, assume we have the following cases in one IAM policy binding:
// - Permission P1 and P2 apply to resource R1 and R2;
// - Permission P3 applies to resource R2 and R3;
//
// This will result in the following access control lists:
// - AccessControlList 1: [R1, R2], [P1, P2]
// - AccessControlList 2: [R2, R3], [P3]
type IamPolicyAnalysisResult_AccessControlList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resources that match one of the following conditions:
	// - The resource_selector, if it is specified in request;
	// - Otherwise, resources reachable from the policy attached resource.
	Resources []*IamPolicyAnalysisResult_Resource `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// The accesses that match one of the following conditions:
	// - The access_selector, if it is specified in request;
	// - Otherwise, access specifiers reachable from the policy binding's role.
	Accesses []*IamPolicyAnalysisResult_Access `protobuf:"bytes,2,rep,name=accesses,proto3" json:"accesses,omitempty"`
	// Resource edges of the graph starting from the policy attached
	// resource to any descendant resources. The
	// [Edge.source_node][google.cloud.asset.v1.IamPolicyAnalysisResult.Edge.source_node]
	// contains the full resource name of a parent resource and
	// [Edge.target_node][google.cloud.asset.v1.IamPolicyAnalysisResult.Edge.target_node]
	// contains the full resource name of a child resource. This field is
	// present only if the output_resource_edges option is enabled in request.
	ResourceEdges []*IamPolicyAnalysisResult_Edge `protobuf:"bytes,3,rep,name=resource_edges,json=resourceEdges,proto3" json:"resource_edges,omitempty"`
	// Condition evaluation for this AccessControlList, if there is a condition
	// defined in the above IAM policy binding.
	ConditionEvaluation *ConditionEvaluation `protobuf:"bytes,4,opt,name=condition_evaluation,json=conditionEvaluation,proto3" json:"condition_evaluation,omitempty"`
}

func (x *IamPolicyAnalysisResult_AccessControlList) Reset() {
	*x = IamPolicyAnalysisResult_AccessControlList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_AccessControlList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_AccessControlList) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_AccessControlList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_AccessControlList.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_AccessControlList) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{15, 4}
}

func (x *IamPolicyAnalysisResult_AccessControlList) GetResources() []*IamPolicyAnalysisResult_Resource {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *IamPolicyAnalysisResult_AccessControlList) GetAccesses() []*IamPolicyAnalysisResult_Access {
	if x != nil {
		return x.Accesses
	}
	return nil
}

func (x *IamPolicyAnalysisResult_AccessControlList) GetResourceEdges() []*IamPolicyAnalysisResult_Edge {
	if x != nil {
		return x.ResourceEdges
	}
	return nil
}

func (x *IamPolicyAnalysisResult_AccessControlList) GetConditionEvaluation() *ConditionEvaluation {
	if x != nil {
		return x.ConditionEvaluation
	}
	return nil
}

// The identities and group edges.
type IamPolicyAnalysisResult_IdentityList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only the identities that match one of the following conditions will be
	// presented:
	// - The identity_selector, if it is specified in request;
	// - Otherwise, identities reachable from the policy binding's members.
	Identities []*IamPolicyAnalysisResult_Identity `protobuf:"bytes,1,rep,name=identities,proto3" json:"identities,omitempty"`
	// Group identity edges of the graph starting from the binding's
	// group members to any node of the
	// [identities][google.cloud.asset.v1.IamPolicyAnalysisResult.IdentityList.identities].
	// The
	// [Edge.source_node][google.cloud.asset.v1.IamPolicyAnalysisResult.Edge.source_node]
	// contains a group, such as `group:parent@google.com`. The
	// [Edge.target_node][google.cloud.asset.v1.IamPolicyAnalysisResult.Edge.target_node]
	// contains a member of the group, such as `group:child@google.com` or
	// `user:foo@google.com`. This field is present only if the
	// output_group_edges option is enabled in request.
	GroupEdges []*IamPolicyAnalysisResult_Edge `protobuf:"bytes,2,rep,name=group_edges,json=groupEdges,proto3" json:"group_edges,omitempty"`
}

func (x *IamPolicyAnalysisResult_IdentityList) Reset() {
	*x = IamPolicyAnalysisResult_IdentityList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_IdentityList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_IdentityList) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_IdentityList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_IdentityList.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_IdentityList) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{15, 5}
}

func (x *IamPolicyAnalysisResult_IdentityList) GetIdentities() []*IamPolicyAnalysisResult_Identity {
	if x != nil {
		return x.Identities
	}
	return nil
}

func (x *IamPolicyAnalysisResult_IdentityList) GetGroupEdges() []*IamPolicyAnalysisResult_Edge {
	if x != nil {
		return x.GroupEdges
	}
	return nil
}

var File_google_cloud_asset_v1_assets_proto protoreflect.FileDescriptor

var file_google_cloud_asset_v1_assets_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2f,
	0x76, 0x31, 0x2f, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f,
	0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaa, 0x03, 0x0a, 0x0d, 0x54, 0x65, 0x6d,
	0x70, 0x6f, 0x72, 0x61, 0x6c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x77, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x06, 0x77,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12,
	0x32, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x12, 0x60, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x5f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x5f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x22, 0x6f, 0x0a, 0x0f, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x52, 0x49, 0x4f, 0x52,
	0x5f, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52,
	0x45, 0x53, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c,
	0x49, 0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x4f, 0x45, 0x53, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x44, 0x10, 0x04, 0x22, 0x7e, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x92, 0x07, 0x0a, 0x05, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x3b, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x34, 0x0a, 0x0a,
	0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x09, 0x69, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x40, 0x0a, 0x0a, 0x6f, 0x72, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x09, 0x6f, 0x72, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x5c, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x59, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48, 0x00,
	0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x68, 0x0a,
	0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x46, 0x0a, 0x0c, 0x6f, 0x73, 0x5f, 0x69, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x0b, 0x6f, 0x73, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12,
	0x4f, 0x0a, 0x0e, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x12, 0x48, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x0c, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x3a, 0x27, 0xea, 0x41, 0x24, 0x0a, 0x1f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x01,
	0x2a, 0x42, 0x17, 0x0a, 0x15, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x85, 0x02, 0x0a, 0x08, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x14, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72,
	0x6c, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xb8, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x12, 0x66, 0x0a, 0x17, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x68, 0x69, 0x70, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x52, 0x16, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68,
	0x69, 0x70, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x06,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x52, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xac, 0x01,
	0x0a, 0x16, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x30, 0x0a, 0x14,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30,
	0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xb4, 0x01, 0x0a,
	0x0c, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x3a, 0x0a,
	0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41,
	0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x54,
	0x79, 0x70, 0x65, 0x22, 0xf1, 0x09, 0x0a, 0x14, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x07,
	0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6b,
	0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4c, 0x0a, 0x15, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x14, 0x61,
	0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x46, 0x75,
	0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x59,
	0x0a, 0x13, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x12, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x12, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x11,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x64, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69,
	0x70, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68,
	0x69, 0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x61, 0x67, 0x5f, 0x6b,
	0x65, 0x79, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x74, 0x61, 0x67, 0x4b, 0x65,
	0x79, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x19, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x22, 0x0a, 0x0d, 0x74, 0x61, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x1a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x61, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x49, 0x64, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x67, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x69, 0x0a, 0x12,
	0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61,
	0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x62, 0x0a, 0x11, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x8c, 0x01, 0x0a, 0x10,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x59, 0x0a, 0x13, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x12, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65,
	0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0x67, 0x0a, 0x10, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x53,
	0x0a, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x10, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x22, 0x5e, 0x0a, 0x0f, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x88, 0x05, 0x0a, 0x15, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1a, 0x0a,
	0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x22, 0x0a, 0x0c,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2d, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x5a, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xd0, 0x02, 0x0a, 0x0b,
	0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x81, 0x01, 0x0a, 0x13,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x12, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0x2f, 0x0a, 0x0b, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x20,
	0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x8b, 0x01, 0x0a, 0x17, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x5a,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x6c,
	0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x54,
	0x0a, 0x16, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63,
	0x61, 0x75, 0x73, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x65, 0x0a, 0x10,
	0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0x59, 0x0a, 0x0f, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x56, 0x41, 0x4c, 0x55, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x52, 0x55, 0x45,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x41, 0x4c, 0x53, 0x45, 0x10, 0x02, 0x12, 0x0f, 0x0a,
	0x0b, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x03, 0x22, 0xc3,
	0x0b, 0x0a, 0x17, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3d, 0x0a, 0x1b, 0x61, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x18, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x69, 0x61, 0x6d,
	0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x69, 0x61, 0x6d, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x72, 0x0a, 0x14, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x12, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x4c, 0x69, 0x73, 0x74, 0x73, 0x12, 0x60, 0x0a, 0x0d, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x0c, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6c, 0x6c,
	0x79, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x1a,
	0x8e, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x12,
	0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x1a, 0xa6, 0x01, 0x0a, 0x06, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x14, 0x0a, 0x04, 0x72,
	0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x72, 0x6f, 0x6c,
	0x65, 0x12, 0x20, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x6f, 0x6e, 0x65,
	0x6f, 0x66, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x1a, 0x74, 0x0a, 0x08, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a,
	0x48, 0x0a, 0x04, 0x45, 0x64, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x1a, 0xf8, 0x02, 0x0a, 0x11, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x55, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x0e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x64, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x45, 0x64, 0x67, 0x65, 0x73, 0x12, 0x5d, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x13, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xbd, 0x01, 0x0a, 0x0c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x54,
	0x0a, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65, 0x64, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x52, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x45,
	0x64, 0x67, 0x65, 0x73, 0x42, 0x98, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x42, 0x0a, 0x41, 0x73, 0x73, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x73, 0x73, 0x65, 0x74, 0xf8, 0x01, 0x01, 0xaa,
	0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x5c, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_asset_v1_assets_proto_rawDescOnce sync.Once
	file_google_cloud_asset_v1_assets_proto_rawDescData = file_google_cloud_asset_v1_assets_proto_rawDesc
)

func file_google_cloud_asset_v1_assets_proto_rawDescGZIP() []byte {
	file_google_cloud_asset_v1_assets_proto_rawDescOnce.Do(func() {
		file_google_cloud_asset_v1_assets_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_asset_v1_assets_proto_rawDescData)
	})
	return file_google_cloud_asset_v1_assets_proto_rawDescData
}

var file_google_cloud_asset_v1_assets_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_asset_v1_assets_proto_msgTypes = make([]protoimpl.MessageInfo, 27)
var file_google_cloud_asset_v1_assets_proto_goTypes = []interface{}{
	(TemporalAsset_PriorAssetState)(0),        // 0: google.cloud.asset.v1.TemporalAsset.PriorAssetState
	(ConditionEvaluation_EvaluationValue)(0),  // 1: google.cloud.asset.v1.ConditionEvaluation.EvaluationValue
	(*TemporalAsset)(nil),                     // 2: google.cloud.asset.v1.TemporalAsset
	(*TimeWindow)(nil),                        // 3: google.cloud.asset.v1.TimeWindow
	(*Asset)(nil),                             // 4: google.cloud.asset.v1.Asset
	(*Resource)(nil),                          // 5: google.cloud.asset.v1.Resource
	(*RelatedAssets)(nil),                     // 6: google.cloud.asset.v1.RelatedAssets
	(*RelationshipAttributes)(nil),            // 7: google.cloud.asset.v1.RelationshipAttributes
	(*RelatedAsset)(nil),                      // 8: google.cloud.asset.v1.RelatedAsset
	(*ResourceSearchResult)(nil),              // 9: google.cloud.asset.v1.ResourceSearchResult
	(*VersionedResource)(nil),                 // 10: google.cloud.asset.v1.VersionedResource
	(*AttachedResource)(nil),                  // 11: google.cloud.asset.v1.AttachedResource
	(*RelatedResources)(nil),                  // 12: google.cloud.asset.v1.RelatedResources
	(*RelatedResource)(nil),                   // 13: google.cloud.asset.v1.RelatedResource
	(*IamPolicySearchResult)(nil),             // 14: google.cloud.asset.v1.IamPolicySearchResult
	(*IamPolicyAnalysisState)(nil),            // 15: google.cloud.asset.v1.IamPolicyAnalysisState
	(*ConditionEvaluation)(nil),               // 16: google.cloud.asset.v1.ConditionEvaluation
	(*IamPolicyAnalysisResult)(nil),           // 17: google.cloud.asset.v1.IamPolicyAnalysisResult
	nil,                                       // 18: google.cloud.asset.v1.ResourceSearchResult.LabelsEntry
	nil,                                       // 19: google.cloud.asset.v1.ResourceSearchResult.RelationshipsEntry
	(*IamPolicySearchResult_Explanation)(nil), // 20: google.cloud.asset.v1.IamPolicySearchResult.Explanation
	(*IamPolicySearchResult_Explanation_Permissions)(nil), // 21: google.cloud.asset.v1.IamPolicySearchResult.Explanation.Permissions
	nil,                                               // 22: google.cloud.asset.v1.IamPolicySearchResult.Explanation.MatchedPermissionsEntry
	(*IamPolicyAnalysisResult_Resource)(nil),          // 23: google.cloud.asset.v1.IamPolicyAnalysisResult.Resource
	(*IamPolicyAnalysisResult_Access)(nil),            // 24: google.cloud.asset.v1.IamPolicyAnalysisResult.Access
	(*IamPolicyAnalysisResult_Identity)(nil),          // 25: google.cloud.asset.v1.IamPolicyAnalysisResult.Identity
	(*IamPolicyAnalysisResult_Edge)(nil),              // 26: google.cloud.asset.v1.IamPolicyAnalysisResult.Edge
	(*IamPolicyAnalysisResult_AccessControlList)(nil), // 27: google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList
	(*IamPolicyAnalysisResult_IdentityList)(nil),      // 28: google.cloud.asset.v1.IamPolicyAnalysisResult.IdentityList
	(*timestamppb.Timestamp)(nil),                     // 29: google.protobuf.Timestamp
	(*v1.Policy)(nil),                                 // 30: google.iam.v1.Policy
	(*v11.Policy)(nil),                                // 31: google.cloud.orgpolicy.v1.Policy
	(*v13.AccessPolicy)(nil),                          // 32: google.identity.accesscontextmanager.v1.AccessPolicy
	(*v13.AccessLevel)(nil),                           // 33: google.identity.accesscontextmanager.v1.AccessLevel
	(*v13.ServicePerimeter)(nil),                      // 34: google.identity.accesscontextmanager.v1.ServicePerimeter
	(*v12.Inventory)(nil),                             // 35: google.cloud.osconfig.v1.Inventory
	(*structpb.Struct)(nil),                           // 36: google.protobuf.Struct
	(code.Code)(0),                                    // 37: google.rpc.Code
	(*v1.Binding)(nil),                                // 38: google.iam.v1.Binding
}
var file_google_cloud_asset_v1_assets_proto_depIdxs = []int32{
	3,  // 0: google.cloud.asset.v1.TemporalAsset.window:type_name -> google.cloud.asset.v1.TimeWindow
	4,  // 1: google.cloud.asset.v1.TemporalAsset.asset:type_name -> google.cloud.asset.v1.Asset
	0,  // 2: google.cloud.asset.v1.TemporalAsset.prior_asset_state:type_name -> google.cloud.asset.v1.TemporalAsset.PriorAssetState
	4,  // 3: google.cloud.asset.v1.TemporalAsset.prior_asset:type_name -> google.cloud.asset.v1.Asset
	29, // 4: google.cloud.asset.v1.TimeWindow.start_time:type_name -> google.protobuf.Timestamp
	29, // 5: google.cloud.asset.v1.TimeWindow.end_time:type_name -> google.protobuf.Timestamp
	29, // 6: google.cloud.asset.v1.Asset.update_time:type_name -> google.protobuf.Timestamp
	5,  // 7: google.cloud.asset.v1.Asset.resource:type_name -> google.cloud.asset.v1.Resource
	30, // 8: google.cloud.asset.v1.Asset.iam_policy:type_name -> google.iam.v1.Policy
	31, // 9: google.cloud.asset.v1.Asset.org_policy:type_name -> google.cloud.orgpolicy.v1.Policy
	32, // 10: google.cloud.asset.v1.Asset.access_policy:type_name -> google.identity.accesscontextmanager.v1.AccessPolicy
	33, // 11: google.cloud.asset.v1.Asset.access_level:type_name -> google.identity.accesscontextmanager.v1.AccessLevel
	34, // 12: google.cloud.asset.v1.Asset.service_perimeter:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeter
	35, // 13: google.cloud.asset.v1.Asset.os_inventory:type_name -> google.cloud.osconfig.v1.Inventory
	6,  // 14: google.cloud.asset.v1.Asset.related_assets:type_name -> google.cloud.asset.v1.RelatedAssets
	8,  // 15: google.cloud.asset.v1.Asset.related_asset:type_name -> google.cloud.asset.v1.RelatedAsset
	36, // 16: google.cloud.asset.v1.Resource.data:type_name -> google.protobuf.Struct
	7,  // 17: google.cloud.asset.v1.RelatedAssets.relationship_attributes:type_name -> google.cloud.asset.v1.RelationshipAttributes
	8,  // 18: google.cloud.asset.v1.RelatedAssets.assets:type_name -> google.cloud.asset.v1.RelatedAsset
	18, // 19: google.cloud.asset.v1.ResourceSearchResult.labels:type_name -> google.cloud.asset.v1.ResourceSearchResult.LabelsEntry
	29, // 20: google.cloud.asset.v1.ResourceSearchResult.create_time:type_name -> google.protobuf.Timestamp
	29, // 21: google.cloud.asset.v1.ResourceSearchResult.update_time:type_name -> google.protobuf.Timestamp
	36, // 22: google.cloud.asset.v1.ResourceSearchResult.additional_attributes:type_name -> google.protobuf.Struct
	10, // 23: google.cloud.asset.v1.ResourceSearchResult.versioned_resources:type_name -> google.cloud.asset.v1.VersionedResource
	11, // 24: google.cloud.asset.v1.ResourceSearchResult.attached_resources:type_name -> google.cloud.asset.v1.AttachedResource
	19, // 25: google.cloud.asset.v1.ResourceSearchResult.relationships:type_name -> google.cloud.asset.v1.ResourceSearchResult.RelationshipsEntry
	36, // 26: google.cloud.asset.v1.VersionedResource.resource:type_name -> google.protobuf.Struct
	10, // 27: google.cloud.asset.v1.AttachedResource.versioned_resources:type_name -> google.cloud.asset.v1.VersionedResource
	13, // 28: google.cloud.asset.v1.RelatedResources.related_resources:type_name -> google.cloud.asset.v1.RelatedResource
	30, // 29: google.cloud.asset.v1.IamPolicySearchResult.policy:type_name -> google.iam.v1.Policy
	20, // 30: google.cloud.asset.v1.IamPolicySearchResult.explanation:type_name -> google.cloud.asset.v1.IamPolicySearchResult.Explanation
	37, // 31: google.cloud.asset.v1.IamPolicyAnalysisState.code:type_name -> google.rpc.Code
	1,  // 32: google.cloud.asset.v1.ConditionEvaluation.evaluation_value:type_name -> google.cloud.asset.v1.ConditionEvaluation.EvaluationValue
	38, // 33: google.cloud.asset.v1.IamPolicyAnalysisResult.iam_binding:type_name -> google.iam.v1.Binding
	27, // 34: google.cloud.asset.v1.IamPolicyAnalysisResult.access_control_lists:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList
	28, // 35: google.cloud.asset.v1.IamPolicyAnalysisResult.identity_list:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.IdentityList
	12, // 36: google.cloud.asset.v1.ResourceSearchResult.RelationshipsEntry.value:type_name -> google.cloud.asset.v1.RelatedResources
	22, // 37: google.cloud.asset.v1.IamPolicySearchResult.Explanation.matched_permissions:type_name -> google.cloud.asset.v1.IamPolicySearchResult.Explanation.MatchedPermissionsEntry
	21, // 38: google.cloud.asset.v1.IamPolicySearchResult.Explanation.MatchedPermissionsEntry.value:type_name -> google.cloud.asset.v1.IamPolicySearchResult.Explanation.Permissions
	15, // 39: google.cloud.asset.v1.IamPolicyAnalysisResult.Resource.analysis_state:type_name -> google.cloud.asset.v1.IamPolicyAnalysisState
	15, // 40: google.cloud.asset.v1.IamPolicyAnalysisResult.Access.analysis_state:type_name -> google.cloud.asset.v1.IamPolicyAnalysisState
	15, // 41: google.cloud.asset.v1.IamPolicyAnalysisResult.Identity.analysis_state:type_name -> google.cloud.asset.v1.IamPolicyAnalysisState
	23, // 42: google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList.resources:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.Resource
	24, // 43: google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList.accesses:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.Access
	26, // 44: google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList.resource_edges:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.Edge
	16, // 45: google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList.condition_evaluation:type_name -> google.cloud.asset.v1.ConditionEvaluation
	25, // 46: google.cloud.asset.v1.IamPolicyAnalysisResult.IdentityList.identities:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.Identity
	26, // 47: google.cloud.asset.v1.IamPolicyAnalysisResult.IdentityList.group_edges:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.Edge
	48, // [48:48] is the sub-list for method output_type
	48, // [48:48] is the sub-list for method input_type
	48, // [48:48] is the sub-list for extension type_name
	48, // [48:48] is the sub-list for extension extendee
	0,  // [0:48] is the sub-list for field type_name
}

func init() { file_google_cloud_asset_v1_assets_proto_init() }
func file_google_cloud_asset_v1_assets_proto_init() {
	if File_google_cloud_asset_v1_assets_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_asset_v1_assets_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TemporalAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelatedAssets); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelationshipAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelatedAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceSearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionedResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttachedResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelatedResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelatedResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicySearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionEvaluation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicySearchResult_Explanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicySearchResult_Explanation_Permissions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Access); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Identity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Edge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_AccessControlList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_IdentityList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_asset_v1_assets_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Asset_AccessPolicy)(nil),
		(*Asset_AccessLevel)(nil),
		(*Asset_ServicePerimeter)(nil),
	}
	file_google_cloud_asset_v1_assets_proto_msgTypes[22].OneofWrappers = []interface{}{
		(*IamPolicyAnalysisResult_Access_Role)(nil),
		(*IamPolicyAnalysisResult_Access_Permission)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_asset_v1_assets_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   27,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_asset_v1_assets_proto_goTypes,
		DependencyIndexes: file_google_cloud_asset_v1_assets_proto_depIdxs,
		EnumInfos:         file_google_cloud_asset_v1_assets_proto_enumTypes,
		MessageInfos:      file_google_cloud_asset_v1_assets_proto_msgTypes,
	}.Build()
	File_google_cloud_asset_v1_assets_proto = out.File
	file_google_cloud_asset_v1_assets_proto_rawDesc = nil
	file_google_cloud_asset_v1_assets_proto_goTypes = nil
	file_google_cloud_asset_v1_assets_proto_depIdxs = nil
}
