// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/analytics/data/v1alpha/analytics_data_api.proto

package data

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Controls the dimensions present in the funnel visualization sub report
// response.
type RunFunnelReportRequest_FunnelVisualizationType int32

const (
	// Unspecified type.
	RunFunnelReportRequest_FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED RunFunnelReportRequest_FunnelVisualizationType = 0
	// A standard (stepped) funnel. The funnel visualization sub report in the
	// response will not contain date.
	RunFunnelReportRequest_STANDARD_FUNNEL RunFunnelReportRequest_FunnelVisualizationType = 1
	// A trended (line chart) funnel. The funnel visualization sub report in the
	// response will contain the date dimension.
	RunFunnelReportRequest_TRENDED_FUNNEL RunFunnelReportRequest_FunnelVisualizationType = 2
)

// Enum value maps for RunFunnelReportRequest_FunnelVisualizationType.
var (
	RunFunnelReportRequest_FunnelVisualizationType_name = map[int32]string{
		0: "FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED",
		1: "STANDARD_FUNNEL",
		2: "TRENDED_FUNNEL",
	}
	RunFunnelReportRequest_FunnelVisualizationType_value = map[string]int32{
		"FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED": 0,
		"STANDARD_FUNNEL":                       1,
		"TRENDED_FUNNEL":                        2,
	}
)

func (x RunFunnelReportRequest_FunnelVisualizationType) Enum() *RunFunnelReportRequest_FunnelVisualizationType {
	p := new(RunFunnelReportRequest_FunnelVisualizationType)
	*p = x
	return p
}

func (x RunFunnelReportRequest_FunnelVisualizationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RunFunnelReportRequest_FunnelVisualizationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_enumTypes[0].Descriptor()
}

func (RunFunnelReportRequest_FunnelVisualizationType) Type() protoreflect.EnumType {
	return &file_google_analytics_data_v1alpha_analytics_data_api_proto_enumTypes[0]
}

func (x RunFunnelReportRequest_FunnelVisualizationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RunFunnelReportRequest_FunnelVisualizationType.Descriptor instead.
func (RunFunnelReportRequest_FunnelVisualizationType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{0, 0}
}

// The request for a funnel report.
type RunFunnelReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Google Analytics GA4 property identifier whose events are tracked.
	// Specified in the URL path and not the body. To learn more, see [where to
	// find your Property
	// ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
	// Within a batch request, this property should either be unspecified or
	// consistent with the batch-level property.
	//
	// Example: properties/1234
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Date ranges of data to read. If multiple date ranges are requested, each
	// response row will contain a zero based date range index. If two date
	// ranges overlap, the event data for the overlapping days is included in the
	// response rows for both date ranges.
	DateRanges []*DateRange `protobuf:"bytes,2,rep,name=date_ranges,json=dateRanges,proto3" json:"date_ranges,omitempty"`
	// The configuration of this request's funnel. This funnel configuration is
	// required.
	Funnel *Funnel `protobuf:"bytes,3,opt,name=funnel,proto3" json:"funnel,omitempty"`
	// If specified, this breakdown adds a dimension to the funnel table sub
	// report response. This breakdown dimension expands each funnel step to the
	// unique values of the breakdown dimension. For example, a breakdown by the
	// `deviceCategory` dimension will create rows for `mobile`, `tablet`,
	// `desktop`, and the total.
	FunnelBreakdown *FunnelBreakdown `protobuf:"bytes,4,opt,name=funnel_breakdown,json=funnelBreakdown,proto3" json:"funnel_breakdown,omitempty"`
	// If specified, next action adds a dimension to the funnel visualization sub
	// report response. This next action dimension expands each funnel step to the
	// unique values of the next action. For example a breakdown by the
	// `eventName` dimension will create rows for several events (i.e.
	// `session_start` & `click`) and the total.
	FunnelNextAction *FunnelNextAction `protobuf:"bytes,5,opt,name=funnel_next_action,json=funnelNextAction,proto3" json:"funnel_next_action,omitempty"`
	// The funnel visualization type controls the dimensions present in the funnel
	// visualization sub report response. If not specified, `STANDARD_FUNNEL` is
	// used.
	FunnelVisualizationType RunFunnelReportRequest_FunnelVisualizationType `protobuf:"varint,6,opt,name=funnel_visualization_type,json=funnelVisualizationType,proto3,enum=google.analytics.data.v1alpha.RunFunnelReportRequest_FunnelVisualizationType" json:"funnel_visualization_type,omitempty"`
	// The configurations of segments. Segments are subsets of a property's data.
	// In a funnel report with segments, the funnel is evaluated in each segment.
	//
	// Each segment specified in this request
	// produces a separate row in the response; in the response, each segment
	// identified by its name.
	//
	// The segments parameter is optional. Requests are limited to 4 segments.
	Segments []*Segment `protobuf:"bytes,7,rep,name=segments,proto3" json:"segments,omitempty"`
	// The number of rows to return. If unspecified, 10,000 rows are returned. The
	// API returns a maximum of 100,000 rows per request, no matter how many you
	// ask for. `limit` must be positive.
	//
	// The API can also return fewer rows than the requested `limit`, if there
	// aren't as many dimension values as the `limit`.
	Limit int64 `protobuf:"varint,9,opt,name=limit,proto3" json:"limit,omitempty"`
	// Dimension filters allow you to ask for only specific dimension values in
	// the report. To learn more, see [Creating a Report: Dimension
	// Filters](https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
	// for examples. Metrics cannot be used in this filter.
	DimensionFilter *FilterExpression `protobuf:"bytes,10,opt,name=dimension_filter,json=dimensionFilter,proto3" json:"dimension_filter,omitempty"`
	// Toggles whether to return the current state of this Analytics Property's
	// quota. Quota is returned in [PropertyQuota](#PropertyQuota).
	ReturnPropertyQuota bool `protobuf:"varint,12,opt,name=return_property_quota,json=returnPropertyQuota,proto3" json:"return_property_quota,omitempty"`
}

func (x *RunFunnelReportRequest) Reset() {
	*x = RunFunnelReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunFunnelReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunFunnelReportRequest) ProtoMessage() {}

func (x *RunFunnelReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunFunnelReportRequest.ProtoReflect.Descriptor instead.
func (*RunFunnelReportRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{0}
}

func (x *RunFunnelReportRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *RunFunnelReportRequest) GetDateRanges() []*DateRange {
	if x != nil {
		return x.DateRanges
	}
	return nil
}

func (x *RunFunnelReportRequest) GetFunnel() *Funnel {
	if x != nil {
		return x.Funnel
	}
	return nil
}

func (x *RunFunnelReportRequest) GetFunnelBreakdown() *FunnelBreakdown {
	if x != nil {
		return x.FunnelBreakdown
	}
	return nil
}

func (x *RunFunnelReportRequest) GetFunnelNextAction() *FunnelNextAction {
	if x != nil {
		return x.FunnelNextAction
	}
	return nil
}

func (x *RunFunnelReportRequest) GetFunnelVisualizationType() RunFunnelReportRequest_FunnelVisualizationType {
	if x != nil {
		return x.FunnelVisualizationType
	}
	return RunFunnelReportRequest_FUNNEL_VISUALIZATION_TYPE_UNSPECIFIED
}

func (x *RunFunnelReportRequest) GetSegments() []*Segment {
	if x != nil {
		return x.Segments
	}
	return nil
}

func (x *RunFunnelReportRequest) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *RunFunnelReportRequest) GetDimensionFilter() *FilterExpression {
	if x != nil {
		return x.DimensionFilter
	}
	return nil
}

func (x *RunFunnelReportRequest) GetReturnPropertyQuota() bool {
	if x != nil {
		return x.ReturnPropertyQuota
	}
	return false
}

// The funnel report response contains two sub reports. The two sub reports are
// different combinations of dimensions and metrics.
type RunFunnelReportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The funnel table is a report with the funnel step, segment, breakdown
	// dimension, active users, completion rate, abandonments, and abandonments
	// rate.
	//
	// The segment dimension is only present in this response if a segment was
	// requested. The breakdown dimension is only present in this response if it
	// was requested.
	FunnelTable *FunnelSubReport `protobuf:"bytes,1,opt,name=funnel_table,json=funnelTable,proto3" json:"funnel_table,omitempty"`
	// The funnel visualization is a report with the funnel step, segment, date,
	// next action dimension, and active users.
	//
	// The segment dimension is only present in this response if a segment was
	// requested. The date dimension is only present in this response if it was
	// requested via the `TRENDED_FUNNEL` funnel type. The next action dimension
	// is only present in the response if it was requested.
	FunnelVisualization *FunnelSubReport `protobuf:"bytes,2,opt,name=funnel_visualization,json=funnelVisualization,proto3" json:"funnel_visualization,omitempty"`
	// This Analytics Property's quota state including this request.
	PropertyQuota *PropertyQuota `protobuf:"bytes,3,opt,name=property_quota,json=propertyQuota,proto3" json:"property_quota,omitempty"`
	// Identifies what kind of resource this message is. This `kind` is always the
	// fixed string "analyticsData#runFunnelReport". Useful to distinguish between
	// response types in JSON.
	Kind string `protobuf:"bytes,4,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *RunFunnelReportResponse) Reset() {
	*x = RunFunnelReportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunFunnelReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunFunnelReportResponse) ProtoMessage() {}

func (x *RunFunnelReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunFunnelReportResponse.ProtoReflect.Descriptor instead.
func (*RunFunnelReportResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{1}
}

func (x *RunFunnelReportResponse) GetFunnelTable() *FunnelSubReport {
	if x != nil {
		return x.FunnelTable
	}
	return nil
}

func (x *RunFunnelReportResponse) GetFunnelVisualization() *FunnelSubReport {
	if x != nil {
		return x.FunnelVisualization
	}
	return nil
}

func (x *RunFunnelReportResponse) GetPropertyQuota() *PropertyQuota {
	if x != nil {
		return x.PropertyQuota
	}
	return nil
}

func (x *RunFunnelReportResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

var File_google_analytics_data_v1alpha_analytics_data_api_proto protoreflect.FileDescriptor

var file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x61,
	0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdd, 0x06, 0x0a, 0x16, 0x52, 0x75, 0x6e,
	0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12,
	0x49, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0a,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x06, 0x66, 0x75,
	0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x52, 0x06, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x59, 0x0a, 0x10, 0x66, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x64,
	0x6f, 0x77, 0x6e, 0x52, 0x0f, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x72, 0x65, 0x61, 0x6b,
	0x64, 0x6f, 0x77, 0x6e, 0x12, 0x5d, 0x0a, 0x12, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x4e, 0x65, 0x78, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x10, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x4e, 0x65, 0x78, 0x74, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x89, 0x01, 0x0a, 0x19, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x46, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46,
	0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x17, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x56, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x42, 0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x5a, 0x0a, 0x10, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x22, 0x6d, 0x0a, 0x17, 0x46, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x29, 0x0a, 0x25, 0x46, 0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x56,
	0x49, 0x53, 0x55, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x46, 0x55, 0x4e, 0x4e,
	0x45, 0x4c, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x54, 0x52, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x5f,
	0x46, 0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x10, 0x02, 0x22, 0xb8, 0x02, 0x0a, 0x17, 0x52, 0x75, 0x6e,
	0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0c, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x53, 0x75, 0x62, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x0b, 0x66, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x61, 0x0a, 0x14, 0x66, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x75, 0x62, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x13, 0x66, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x56, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0e, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x52, 0x0d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12,
	0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x32, 0xd4, 0x02, 0x0a, 0x12, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x12, 0xbd, 0x01, 0x0a, 0x0f, 0x52,
	0x75, 0x6e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52,
	0x75, 0x6e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x46, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x35, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x46, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x1a, 0x7e, 0xca, 0x41, 0x1c, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5c, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x7f, 0x0a, 0x21, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42,
	0x15, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x41, 0x70,
	0x69, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescOnce sync.Once
	file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescData = file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDesc
)

func file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP() []byte {
	file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescOnce.Do(func() {
		file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescData)
	})
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescData
}

var file_google_analytics_data_v1alpha_analytics_data_api_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_analytics_data_v1alpha_analytics_data_api_proto_goTypes = []interface{}{
	(RunFunnelReportRequest_FunnelVisualizationType)(0), // 0: google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType
	(*RunFunnelReportRequest)(nil),                      // 1: google.analytics.data.v1alpha.RunFunnelReportRequest
	(*RunFunnelReportResponse)(nil),                     // 2: google.analytics.data.v1alpha.RunFunnelReportResponse
	(*DateRange)(nil),                                   // 3: google.analytics.data.v1alpha.DateRange
	(*Funnel)(nil),                                      // 4: google.analytics.data.v1alpha.Funnel
	(*FunnelBreakdown)(nil),                             // 5: google.analytics.data.v1alpha.FunnelBreakdown
	(*FunnelNextAction)(nil),                            // 6: google.analytics.data.v1alpha.FunnelNextAction
	(*Segment)(nil),                                     // 7: google.analytics.data.v1alpha.Segment
	(*FilterExpression)(nil),                            // 8: google.analytics.data.v1alpha.FilterExpression
	(*FunnelSubReport)(nil),                             // 9: google.analytics.data.v1alpha.FunnelSubReport
	(*PropertyQuota)(nil),                               // 10: google.analytics.data.v1alpha.PropertyQuota
}
var file_google_analytics_data_v1alpha_analytics_data_api_proto_depIdxs = []int32{
	3,  // 0: google.analytics.data.v1alpha.RunFunnelReportRequest.date_ranges:type_name -> google.analytics.data.v1alpha.DateRange
	4,  // 1: google.analytics.data.v1alpha.RunFunnelReportRequest.funnel:type_name -> google.analytics.data.v1alpha.Funnel
	5,  // 2: google.analytics.data.v1alpha.RunFunnelReportRequest.funnel_breakdown:type_name -> google.analytics.data.v1alpha.FunnelBreakdown
	6,  // 3: google.analytics.data.v1alpha.RunFunnelReportRequest.funnel_next_action:type_name -> google.analytics.data.v1alpha.FunnelNextAction
	0,  // 4: google.analytics.data.v1alpha.RunFunnelReportRequest.funnel_visualization_type:type_name -> google.analytics.data.v1alpha.RunFunnelReportRequest.FunnelVisualizationType
	7,  // 5: google.analytics.data.v1alpha.RunFunnelReportRequest.segments:type_name -> google.analytics.data.v1alpha.Segment
	8,  // 6: google.analytics.data.v1alpha.RunFunnelReportRequest.dimension_filter:type_name -> google.analytics.data.v1alpha.FilterExpression
	9,  // 7: google.analytics.data.v1alpha.RunFunnelReportResponse.funnel_table:type_name -> google.analytics.data.v1alpha.FunnelSubReport
	9,  // 8: google.analytics.data.v1alpha.RunFunnelReportResponse.funnel_visualization:type_name -> google.analytics.data.v1alpha.FunnelSubReport
	10, // 9: google.analytics.data.v1alpha.RunFunnelReportResponse.property_quota:type_name -> google.analytics.data.v1alpha.PropertyQuota
	1,  // 10: google.analytics.data.v1alpha.AlphaAnalyticsData.RunFunnelReport:input_type -> google.analytics.data.v1alpha.RunFunnelReportRequest
	2,  // 11: google.analytics.data.v1alpha.AlphaAnalyticsData.RunFunnelReport:output_type -> google.analytics.data.v1alpha.RunFunnelReportResponse
	11, // [11:12] is the sub-list for method output_type
	10, // [10:11] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_analytics_data_v1alpha_analytics_data_api_proto_init() }
func file_google_analytics_data_v1alpha_analytics_data_api_proto_init() {
	if File_google_analytics_data_v1alpha_analytics_data_api_proto != nil {
		return
	}
	file_google_analytics_data_v1alpha_data_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunFunnelReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunFunnelReportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_analytics_data_v1alpha_analytics_data_api_proto_goTypes,
		DependencyIndexes: file_google_analytics_data_v1alpha_analytics_data_api_proto_depIdxs,
		EnumInfos:         file_google_analytics_data_v1alpha_analytics_data_api_proto_enumTypes,
		MessageInfos:      file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes,
	}.Build()
	File_google_analytics_data_v1alpha_analytics_data_api_proto = out.File
	file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDesc = nil
	file_google_analytics_data_v1alpha_analytics_data_api_proto_goTypes = nil
	file_google_analytics_data_v1alpha_analytics_data_api_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AlphaAnalyticsDataClient is the client API for AlphaAnalyticsData service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AlphaAnalyticsDataClient interface {
	// Returns a customized funnel report of your Google Analytics event data. The
	// data returned from the API is as a table with columns for the requested
	// dimensions and metrics.
	//
	// Funnel exploration lets you visualize the steps your users take to complete
	// a task and quickly see how well they are succeeding or failing at each
	// step. For example, how do prospects become shoppers and then become buyers?
	// How do one time buyers become repeat buyers? With this information, you can
	// improve inefficient or abandoned customer journeys. To learn more, see [GA4
	// Funnel Explorations](https://support.google.com/analytics/answer/9327974).
	RunFunnelReport(ctx context.Context, in *RunFunnelReportRequest, opts ...grpc.CallOption) (*RunFunnelReportResponse, error)
}

type alphaAnalyticsDataClient struct {
	cc grpc.ClientConnInterface
}

func NewAlphaAnalyticsDataClient(cc grpc.ClientConnInterface) AlphaAnalyticsDataClient {
	return &alphaAnalyticsDataClient{cc}
}

func (c *alphaAnalyticsDataClient) RunFunnelReport(ctx context.Context, in *RunFunnelReportRequest, opts ...grpc.CallOption) (*RunFunnelReportResponse, error) {
	out := new(RunFunnelReportResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1alpha.AlphaAnalyticsData/RunFunnelReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AlphaAnalyticsDataServer is the server API for AlphaAnalyticsData service.
type AlphaAnalyticsDataServer interface {
	// Returns a customized funnel report of your Google Analytics event data. The
	// data returned from the API is as a table with columns for the requested
	// dimensions and metrics.
	//
	// Funnel exploration lets you visualize the steps your users take to complete
	// a task and quickly see how well they are succeeding or failing at each
	// step. For example, how do prospects become shoppers and then become buyers?
	// How do one time buyers become repeat buyers? With this information, you can
	// improve inefficient or abandoned customer journeys. To learn more, see [GA4
	// Funnel Explorations](https://support.google.com/analytics/answer/9327974).
	RunFunnelReport(context.Context, *RunFunnelReportRequest) (*RunFunnelReportResponse, error)
}

// UnimplementedAlphaAnalyticsDataServer can be embedded to have forward compatible implementations.
type UnimplementedAlphaAnalyticsDataServer struct {
}

func (*UnimplementedAlphaAnalyticsDataServer) RunFunnelReport(context.Context, *RunFunnelReportRequest) (*RunFunnelReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunFunnelReport not implemented")
}

func RegisterAlphaAnalyticsDataServer(s *grpc.Server, srv AlphaAnalyticsDataServer) {
	s.RegisterService(&_AlphaAnalyticsData_serviceDesc, srv)
}

func _AlphaAnalyticsData_RunFunnelReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunFunnelReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlphaAnalyticsDataServer).RunFunnelReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1alpha.AlphaAnalyticsData/RunFunnelReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlphaAnalyticsDataServer).RunFunnelReport(ctx, req.(*RunFunnelReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AlphaAnalyticsData_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.analytics.data.v1alpha.AlphaAnalyticsData",
	HandlerType: (*AlphaAnalyticsDataServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RunFunnelReport",
			Handler:    _AlphaAnalyticsData_RunFunnelReport_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/analytics/data/v1alpha/analytics_data_api.proto",
}
