// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v4/resources/ad_group_criterion.proto

package resources

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/ads/googleads/v4/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v4/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// An ad group criterion.
type AdGroupCriterion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the ad group criterion.
	// Ad group criterion resource names have the form:
	//
	// `customers/{customer_id}/adGroupCriteria/{ad_group_id}~{criterion_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the criterion.
	//
	// This field is ignored for mutates.
	CriterionId *wrapperspb.Int64Value `protobuf:"bytes,26,opt,name=criterion_id,json=criterionId,proto3" json:"criterion_id,omitempty"`
	// The status of the criterion.
	Status enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=google.ads.googleads.v4.enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus" json:"status,omitempty"`
	// Output only. Information regarding the quality of the criterion.
	QualityInfo *AdGroupCriterion_QualityInfo `protobuf:"bytes,4,opt,name=quality_info,json=qualityInfo,proto3" json:"quality_info,omitempty"`
	// Immutable. The ad group to which the criterion belongs.
	AdGroup *wrapperspb.StringValue `protobuf:"bytes,5,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// Output only. The type of the criterion.
	Type enums.CriterionTypeEnum_CriterionType `protobuf:"varint,25,opt,name=type,proto3,enum=google.ads.googleads.v4.enums.CriterionTypeEnum_CriterionType" json:"type,omitempty"`
	// Immutable. Whether to target (`false`) or exclude (`true`) the criterion.
	//
	// This field is immutable. To switch a criterion from positive to negative,
	// remove then re-add it.
	Negative *wrapperspb.BoolValue `protobuf:"bytes,31,opt,name=negative,proto3" json:"negative,omitempty"`
	// Output only. Serving status of the criterion.
	SystemServingStatus enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus `protobuf:"varint,52,opt,name=system_serving_status,json=systemServingStatus,proto3,enum=google.ads.googleads.v4.enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus" json:"system_serving_status,omitempty"`
	// Output only. Approval status of the criterion.
	ApprovalStatus enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus `protobuf:"varint,53,opt,name=approval_status,json=approvalStatus,proto3,enum=google.ads.googleads.v4.enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus" json:"approval_status,omitempty"`
	// Output only. List of disapproval reasons of the criterion.
	//
	// The different reasons for disapproving a criterion can be found here:
	// https://support.google.com/adspolicy/answer/6008942
	//
	// This field is read-only.
	DisapprovalReasons []*wrapperspb.StringValue `protobuf:"bytes,55,rep,name=disapproval_reasons,json=disapprovalReasons,proto3" json:"disapproval_reasons,omitempty"`
	// The modifier for the bid when the criterion matches. The modifier must be
	// in the range: 0.1 - 10.0. Most targetable criteria types support modifiers.
	BidModifier *wrapperspb.DoubleValue `protobuf:"bytes,44,opt,name=bid_modifier,json=bidModifier,proto3" json:"bid_modifier,omitempty"`
	// The CPC (cost-per-click) bid.
	CpcBidMicros *wrapperspb.Int64Value `protobuf:"bytes,16,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	// The CPM (cost-per-thousand viewable impressions) bid.
	CpmBidMicros *wrapperspb.Int64Value `protobuf:"bytes,17,opt,name=cpm_bid_micros,json=cpmBidMicros,proto3" json:"cpm_bid_micros,omitempty"`
	// The CPV (cost-per-view) bid.
	CpvBidMicros *wrapperspb.Int64Value `protobuf:"bytes,24,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3" json:"cpv_bid_micros,omitempty"`
	// The CPC bid amount, expressed as a fraction of the advertised price
	// for some good or service. The valid range for the fraction is [0,1) and the
	// value stored here is 1,000,000 * [fraction].
	PercentCpcBidMicros *wrapperspb.Int64Value `protobuf:"bytes,33,opt,name=percent_cpc_bid_micros,json=percentCpcBidMicros,proto3" json:"percent_cpc_bid_micros,omitempty"`
	// Output only. The effective CPC (cost-per-click) bid.
	EffectiveCpcBidMicros *wrapperspb.Int64Value `protobuf:"bytes,18,opt,name=effective_cpc_bid_micros,json=effectiveCpcBidMicros,proto3" json:"effective_cpc_bid_micros,omitempty"`
	// Output only. The effective CPM (cost-per-thousand viewable impressions) bid.
	EffectiveCpmBidMicros *wrapperspb.Int64Value `protobuf:"bytes,19,opt,name=effective_cpm_bid_micros,json=effectiveCpmBidMicros,proto3" json:"effective_cpm_bid_micros,omitempty"`
	// Output only. The effective CPV (cost-per-view) bid.
	EffectiveCpvBidMicros *wrapperspb.Int64Value `protobuf:"bytes,20,opt,name=effective_cpv_bid_micros,json=effectiveCpvBidMicros,proto3" json:"effective_cpv_bid_micros,omitempty"`
	// Output only. The effective Percent CPC bid amount.
	EffectivePercentCpcBidMicros *wrapperspb.Int64Value `protobuf:"bytes,34,opt,name=effective_percent_cpc_bid_micros,json=effectivePercentCpcBidMicros,proto3" json:"effective_percent_cpc_bid_micros,omitempty"`
	// Output only. Source of the effective CPC bid.
	EffectiveCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,21,opt,name=effective_cpc_bid_source,json=effectiveCpcBidSource,proto3,enum=google.ads.googleads.v4.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpc_bid_source,omitempty"`
	// Output only. Source of the effective CPM bid.
	EffectiveCpmBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,22,opt,name=effective_cpm_bid_source,json=effectiveCpmBidSource,proto3,enum=google.ads.googleads.v4.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpm_bid_source,omitempty"`
	// Output only. Source of the effective CPV bid.
	EffectiveCpvBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,23,opt,name=effective_cpv_bid_source,json=effectiveCpvBidSource,proto3,enum=google.ads.googleads.v4.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpv_bid_source,omitempty"`
	// Output only. Source of the effective Percent CPC bid.
	EffectivePercentCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,35,opt,name=effective_percent_cpc_bid_source,json=effectivePercentCpcBidSource,proto3,enum=google.ads.googleads.v4.enums.BiddingSourceEnum_BiddingSource" json:"effective_percent_cpc_bid_source,omitempty"`
	// Output only. Estimates for criterion bids at various positions.
	PositionEstimates *AdGroupCriterion_PositionEstimates `protobuf:"bytes,10,opt,name=position_estimates,json=positionEstimates,proto3" json:"position_estimates,omitempty"`
	// The list of possible final URLs after all cross-domain redirects for the
	// ad.
	FinalUrls []*wrapperspb.StringValue `protobuf:"bytes,11,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// The list of possible final mobile URLs after all cross-domain redirects.
	FinalMobileUrls []*wrapperspb.StringValue `protobuf:"bytes,51,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for appending params to final URL.
	FinalUrlSuffix *wrapperspb.StringValue `protobuf:"bytes,50,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrapperspb.StringValue `protobuf:"bytes,13,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,14,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// The ad group criterion.
	//
	// Exactly one must be set.
	//
	// Types that are assignable to Criterion:
	//	*AdGroupCriterion_Keyword
	//	*AdGroupCriterion_Placement
	//	*AdGroupCriterion_MobileAppCategory
	//	*AdGroupCriterion_MobileApplication
	//	*AdGroupCriterion_ListingGroup
	//	*AdGroupCriterion_AgeRange
	//	*AdGroupCriterion_Gender
	//	*AdGroupCriterion_IncomeRange
	//	*AdGroupCriterion_ParentalStatus
	//	*AdGroupCriterion_UserList
	//	*AdGroupCriterion_YoutubeVideo
	//	*AdGroupCriterion_YoutubeChannel
	//	*AdGroupCriterion_Topic
	//	*AdGroupCriterion_UserInterest
	//	*AdGroupCriterion_Webpage
	//	*AdGroupCriterion_AppPaymentModel
	//	*AdGroupCriterion_CustomAffinity
	//	*AdGroupCriterion_CustomIntent
	Criterion isAdGroupCriterion_Criterion `protobuf_oneof:"criterion"`
}

func (x *AdGroupCriterion) Reset() {
	*x = AdGroupCriterion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdGroupCriterion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdGroupCriterion) ProtoMessage() {}

func (x *AdGroupCriterion) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdGroupCriterion.ProtoReflect.Descriptor instead.
func (*AdGroupCriterion) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDescGZIP(), []int{0}
}

func (x *AdGroupCriterion) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *AdGroupCriterion) GetCriterionId() *wrapperspb.Int64Value {
	if x != nil {
		return x.CriterionId
	}
	return nil
}

func (x *AdGroupCriterion) GetStatus() enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus {
	if x != nil {
		return x.Status
	}
	return enums.AdGroupCriterionStatusEnum_UNSPECIFIED
}

func (x *AdGroupCriterion) GetQualityInfo() *AdGroupCriterion_QualityInfo {
	if x != nil {
		return x.QualityInfo
	}
	return nil
}

func (x *AdGroupCriterion) GetAdGroup() *wrapperspb.StringValue {
	if x != nil {
		return x.AdGroup
	}
	return nil
}

func (x *AdGroupCriterion) GetType() enums.CriterionTypeEnum_CriterionType {
	if x != nil {
		return x.Type
	}
	return enums.CriterionTypeEnum_UNSPECIFIED
}

func (x *AdGroupCriterion) GetNegative() *wrapperspb.BoolValue {
	if x != nil {
		return x.Negative
	}
	return nil
}

func (x *AdGroupCriterion) GetSystemServingStatus() enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus {
	if x != nil {
		return x.SystemServingStatus
	}
	return enums.CriterionSystemServingStatusEnum_UNSPECIFIED
}

func (x *AdGroupCriterion) GetApprovalStatus() enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus {
	if x != nil {
		return x.ApprovalStatus
	}
	return enums.AdGroupCriterionApprovalStatusEnum_UNSPECIFIED
}

func (x *AdGroupCriterion) GetDisapprovalReasons() []*wrapperspb.StringValue {
	if x != nil {
		return x.DisapprovalReasons
	}
	return nil
}

func (x *AdGroupCriterion) GetBidModifier() *wrapperspb.DoubleValue {
	if x != nil {
		return x.BidModifier
	}
	return nil
}

func (x *AdGroupCriterion) GetCpcBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.CpcBidMicros
	}
	return nil
}

func (x *AdGroupCriterion) GetCpmBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.CpmBidMicros
	}
	return nil
}

func (x *AdGroupCriterion) GetCpvBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.CpvBidMicros
	}
	return nil
}

func (x *AdGroupCriterion) GetPercentCpcBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.PercentCpcBidMicros
	}
	return nil
}

func (x *AdGroupCriterion) GetEffectiveCpcBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.EffectiveCpcBidMicros
	}
	return nil
}

func (x *AdGroupCriterion) GetEffectiveCpmBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.EffectiveCpmBidMicros
	}
	return nil
}

func (x *AdGroupCriterion) GetEffectiveCpvBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.EffectiveCpvBidMicros
	}
	return nil
}

func (x *AdGroupCriterion) GetEffectivePercentCpcBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.EffectivePercentCpcBidMicros
	}
	return nil
}

func (x *AdGroupCriterion) GetEffectiveCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if x != nil {
		return x.EffectiveCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (x *AdGroupCriterion) GetEffectiveCpmBidSource() enums.BiddingSourceEnum_BiddingSource {
	if x != nil {
		return x.EffectiveCpmBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (x *AdGroupCriterion) GetEffectiveCpvBidSource() enums.BiddingSourceEnum_BiddingSource {
	if x != nil {
		return x.EffectiveCpvBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (x *AdGroupCriterion) GetEffectivePercentCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if x != nil {
		return x.EffectivePercentCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (x *AdGroupCriterion) GetPositionEstimates() *AdGroupCriterion_PositionEstimates {
	if x != nil {
		return x.PositionEstimates
	}
	return nil
}

func (x *AdGroupCriterion) GetFinalUrls() []*wrapperspb.StringValue {
	if x != nil {
		return x.FinalUrls
	}
	return nil
}

func (x *AdGroupCriterion) GetFinalMobileUrls() []*wrapperspb.StringValue {
	if x != nil {
		return x.FinalMobileUrls
	}
	return nil
}

func (x *AdGroupCriterion) GetFinalUrlSuffix() *wrapperspb.StringValue {
	if x != nil {
		return x.FinalUrlSuffix
	}
	return nil
}

func (x *AdGroupCriterion) GetTrackingUrlTemplate() *wrapperspb.StringValue {
	if x != nil {
		return x.TrackingUrlTemplate
	}
	return nil
}

func (x *AdGroupCriterion) GetUrlCustomParameters() []*common.CustomParameter {
	if x != nil {
		return x.UrlCustomParameters
	}
	return nil
}

func (m *AdGroupCriterion) GetCriterion() isAdGroupCriterion_Criterion {
	if m != nil {
		return m.Criterion
	}
	return nil
}

func (x *AdGroupCriterion) GetKeyword() *common.KeywordInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_Keyword); ok {
		return x.Keyword
	}
	return nil
}

func (x *AdGroupCriterion) GetPlacement() *common.PlacementInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_Placement); ok {
		return x.Placement
	}
	return nil
}

func (x *AdGroupCriterion) GetMobileAppCategory() *common.MobileAppCategoryInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_MobileAppCategory); ok {
		return x.MobileAppCategory
	}
	return nil
}

func (x *AdGroupCriterion) GetMobileApplication() *common.MobileApplicationInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_MobileApplication); ok {
		return x.MobileApplication
	}
	return nil
}

func (x *AdGroupCriterion) GetListingGroup() *common.ListingGroupInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_ListingGroup); ok {
		return x.ListingGroup
	}
	return nil
}

func (x *AdGroupCriterion) GetAgeRange() *common.AgeRangeInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_AgeRange); ok {
		return x.AgeRange
	}
	return nil
}

func (x *AdGroupCriterion) GetGender() *common.GenderInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_Gender); ok {
		return x.Gender
	}
	return nil
}

func (x *AdGroupCriterion) GetIncomeRange() *common.IncomeRangeInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_IncomeRange); ok {
		return x.IncomeRange
	}
	return nil
}

func (x *AdGroupCriterion) GetParentalStatus() *common.ParentalStatusInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_ParentalStatus); ok {
		return x.ParentalStatus
	}
	return nil
}

func (x *AdGroupCriterion) GetUserList() *common.UserListInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_UserList); ok {
		return x.UserList
	}
	return nil
}

func (x *AdGroupCriterion) GetYoutubeVideo() *common.YouTubeVideoInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_YoutubeVideo); ok {
		return x.YoutubeVideo
	}
	return nil
}

func (x *AdGroupCriterion) GetYoutubeChannel() *common.YouTubeChannelInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_YoutubeChannel); ok {
		return x.YoutubeChannel
	}
	return nil
}

func (x *AdGroupCriterion) GetTopic() *common.TopicInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_Topic); ok {
		return x.Topic
	}
	return nil
}

func (x *AdGroupCriterion) GetUserInterest() *common.UserInterestInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_UserInterest); ok {
		return x.UserInterest
	}
	return nil
}

func (x *AdGroupCriterion) GetWebpage() *common.WebpageInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_Webpage); ok {
		return x.Webpage
	}
	return nil
}

func (x *AdGroupCriterion) GetAppPaymentModel() *common.AppPaymentModelInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_AppPaymentModel); ok {
		return x.AppPaymentModel
	}
	return nil
}

func (x *AdGroupCriterion) GetCustomAffinity() *common.CustomAffinityInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_CustomAffinity); ok {
		return x.CustomAffinity
	}
	return nil
}

func (x *AdGroupCriterion) GetCustomIntent() *common.CustomIntentInfo {
	if x, ok := x.GetCriterion().(*AdGroupCriterion_CustomIntent); ok {
		return x.CustomIntent
	}
	return nil
}

type isAdGroupCriterion_Criterion interface {
	isAdGroupCriterion_Criterion()
}

type AdGroupCriterion_Keyword struct {
	// Immutable. Keyword.
	Keyword *common.KeywordInfo `protobuf:"bytes,27,opt,name=keyword,proto3,oneof"`
}

type AdGroupCriterion_Placement struct {
	// Immutable. Placement.
	Placement *common.PlacementInfo `protobuf:"bytes,28,opt,name=placement,proto3,oneof"`
}

type AdGroupCriterion_MobileAppCategory struct {
	// Immutable. Mobile app category.
	MobileAppCategory *common.MobileAppCategoryInfo `protobuf:"bytes,29,opt,name=mobile_app_category,json=mobileAppCategory,proto3,oneof"`
}

type AdGroupCriterion_MobileApplication struct {
	// Immutable. Mobile application.
	MobileApplication *common.MobileApplicationInfo `protobuf:"bytes,30,opt,name=mobile_application,json=mobileApplication,proto3,oneof"`
}

type AdGroupCriterion_ListingGroup struct {
	// Immutable. Listing group.
	ListingGroup *common.ListingGroupInfo `protobuf:"bytes,32,opt,name=listing_group,json=listingGroup,proto3,oneof"`
}

type AdGroupCriterion_AgeRange struct {
	// Immutable. Age range.
	AgeRange *common.AgeRangeInfo `protobuf:"bytes,36,opt,name=age_range,json=ageRange,proto3,oneof"`
}

type AdGroupCriterion_Gender struct {
	// Immutable. Gender.
	Gender *common.GenderInfo `protobuf:"bytes,37,opt,name=gender,proto3,oneof"`
}

type AdGroupCriterion_IncomeRange struct {
	// Immutable. Income range.
	IncomeRange *common.IncomeRangeInfo `protobuf:"bytes,38,opt,name=income_range,json=incomeRange,proto3,oneof"`
}

type AdGroupCriterion_ParentalStatus struct {
	// Immutable. Parental status.
	ParentalStatus *common.ParentalStatusInfo `protobuf:"bytes,39,opt,name=parental_status,json=parentalStatus,proto3,oneof"`
}

type AdGroupCriterion_UserList struct {
	// Immutable. User List.
	UserList *common.UserListInfo `protobuf:"bytes,42,opt,name=user_list,json=userList,proto3,oneof"`
}

type AdGroupCriterion_YoutubeVideo struct {
	// Immutable. YouTube Video.
	YoutubeVideo *common.YouTubeVideoInfo `protobuf:"bytes,40,opt,name=youtube_video,json=youtubeVideo,proto3,oneof"`
}

type AdGroupCriterion_YoutubeChannel struct {
	// Immutable. YouTube Channel.
	YoutubeChannel *common.YouTubeChannelInfo `protobuf:"bytes,41,opt,name=youtube_channel,json=youtubeChannel,proto3,oneof"`
}

type AdGroupCriterion_Topic struct {
	// Immutable. Topic.
	Topic *common.TopicInfo `protobuf:"bytes,43,opt,name=topic,proto3,oneof"`
}

type AdGroupCriterion_UserInterest struct {
	// Immutable. User Interest.
	UserInterest *common.UserInterestInfo `protobuf:"bytes,45,opt,name=user_interest,json=userInterest,proto3,oneof"`
}

type AdGroupCriterion_Webpage struct {
	// Immutable. Webpage
	Webpage *common.WebpageInfo `protobuf:"bytes,46,opt,name=webpage,proto3,oneof"`
}

type AdGroupCriterion_AppPaymentModel struct {
	// Immutable. App Payment Model.
	AppPaymentModel *common.AppPaymentModelInfo `protobuf:"bytes,47,opt,name=app_payment_model,json=appPaymentModel,proto3,oneof"`
}

type AdGroupCriterion_CustomAffinity struct {
	// Immutable. Custom Affinity.
	CustomAffinity *common.CustomAffinityInfo `protobuf:"bytes,48,opt,name=custom_affinity,json=customAffinity,proto3,oneof"`
}

type AdGroupCriterion_CustomIntent struct {
	// Immutable. Custom Intent.
	CustomIntent *common.CustomIntentInfo `protobuf:"bytes,49,opt,name=custom_intent,json=customIntent,proto3,oneof"`
}

func (*AdGroupCriterion_Keyword) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Placement) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_MobileAppCategory) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_MobileApplication) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ListingGroup) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AgeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Gender) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_IncomeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ParentalStatus) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserList) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeVideo) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeChannel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Topic) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserInterest) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Webpage) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AppPaymentModel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_CustomAffinity) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_CustomIntent) isAdGroupCriterion_Criterion() {}

// A container for ad group criterion quality information.
type AdGroupCriterion_QualityInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The quality score.
	//
	// This field may not be populated if Google does not have enough
	// information to determine a value.
	QualityScore *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=quality_score,json=qualityScore,proto3" json:"quality_score,omitempty"`
	// Output only. The performance of the ad compared to other advertisers.
	CreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,2,opt,name=creative_quality_score,json=creativeQualityScore,proto3,enum=google.ads.googleads.v4.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"creative_quality_score,omitempty"`
	// Output only. The quality score of the landing page.
	PostClickQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,3,opt,name=post_click_quality_score,json=postClickQualityScore,proto3,enum=google.ads.googleads.v4.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"post_click_quality_score,omitempty"`
	// Output only. The click-through rate compared to that of other advertisers.
	SearchPredictedCtr enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,4,opt,name=search_predicted_ctr,json=searchPredictedCtr,proto3,enum=google.ads.googleads.v4.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"search_predicted_ctr,omitempty"`
}

func (x *AdGroupCriterion_QualityInfo) Reset() {
	*x = AdGroupCriterion_QualityInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdGroupCriterion_QualityInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdGroupCriterion_QualityInfo) ProtoMessage() {}

func (x *AdGroupCriterion_QualityInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdGroupCriterion_QualityInfo.ProtoReflect.Descriptor instead.
func (*AdGroupCriterion_QualityInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AdGroupCriterion_QualityInfo) GetQualityScore() *wrapperspb.Int32Value {
	if x != nil {
		return x.QualityScore
	}
	return nil
}

func (x *AdGroupCriterion_QualityInfo) GetCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if x != nil {
		return x.CreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (x *AdGroupCriterion_QualityInfo) GetPostClickQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if x != nil {
		return x.PostClickQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (x *AdGroupCriterion_QualityInfo) GetSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if x != nil {
		return x.SearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

// Estimates for criterion bids at various positions.
type AdGroupCriterion_PositionEstimates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The estimate of the CPC bid required for ad to be shown on first
	// page of search results.
	FirstPageCpcMicros *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=first_page_cpc_micros,json=firstPageCpcMicros,proto3" json:"first_page_cpc_micros,omitempty"`
	// Output only. The estimate of the CPC bid required for ad to be displayed in first
	// position, at the top of the first page of search results.
	FirstPositionCpcMicros *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=first_position_cpc_micros,json=firstPositionCpcMicros,proto3" json:"first_position_cpc_micros,omitempty"`
	// Output only. The estimate of the CPC bid required for ad to be displayed at the top
	// of the first page of search results.
	TopOfPageCpcMicros *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=top_of_page_cpc_micros,json=topOfPageCpcMicros,proto3" json:"top_of_page_cpc_micros,omitempty"`
	// Output only. Estimate of how many clicks per week you might get by changing your
	// keyword bid to the value in first_position_cpc_micros.
	EstimatedAddClicksAtFirstPositionCpc *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=estimated_add_clicks_at_first_position_cpc,json=estimatedAddClicksAtFirstPositionCpc,proto3" json:"estimated_add_clicks_at_first_position_cpc,omitempty"`
	// Output only. Estimate of how your cost per week might change when changing your
	// keyword bid to the value in first_position_cpc_micros.
	EstimatedAddCostAtFirstPositionCpc *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=estimated_add_cost_at_first_position_cpc,json=estimatedAddCostAtFirstPositionCpc,proto3" json:"estimated_add_cost_at_first_position_cpc,omitempty"`
}

func (x *AdGroupCriterion_PositionEstimates) Reset() {
	*x = AdGroupCriterion_PositionEstimates{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdGroupCriterion_PositionEstimates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdGroupCriterion_PositionEstimates) ProtoMessage() {}

func (x *AdGroupCriterion_PositionEstimates) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdGroupCriterion_PositionEstimates.ProtoReflect.Descriptor instead.
func (*AdGroupCriterion_PositionEstimates) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AdGroupCriterion_PositionEstimates) GetFirstPageCpcMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.FirstPageCpcMicros
	}
	return nil
}

func (x *AdGroupCriterion_PositionEstimates) GetFirstPositionCpcMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.FirstPositionCpcMicros
	}
	return nil
}

func (x *AdGroupCriterion_PositionEstimates) GetTopOfPageCpcMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.TopOfPageCpcMicros
	}
	return nil
}

func (x *AdGroupCriterion_PositionEstimates) GetEstimatedAddClicksAtFirstPositionCpc() *wrapperspb.Int64Value {
	if x != nil {
		return x.EstimatedAddClicksAtFirstPositionCpc
	}
	return nil
}

func (x *AdGroupCriterion_PositionEstimates) GetEstimatedAddCostAtFirstPositionCpc() *wrapperspb.Int64Value {
	if x != nil {
		return x.EstimatedAddCostAtFirstPositionCpc
	}
	return nil
}

var File_google_ads_googleads_v4_resources_ad_group_criterion_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a,
	0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
	0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x62, 0x69, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f,
	0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb2, 0x2b,
	0x0a, 0x10, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x05, 0xfa, 0x41,
	0x2b, 0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0c, 0x63, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x68, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x67, 0x0a, 0x0c, 0x71, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x6f, 0x6e, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x61, 0x0a, 0x08, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x28, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x07, 0x61, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x57, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x19, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x3b,
	0x0a, 0x08, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x08, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x12, 0x95, 0x01, 0x0a, 0x15,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x6f, 0x6e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x35, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x60, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x41, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f,
	0x6e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x52, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x37, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x64, 0x69, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61,
	0x6c, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a, 0x0c, 0x62, 0x69, 0x64, 0x5f,
	0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x62, 0x69,
	0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x0e, 0x63, 0x70, 0x63,
	0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c,
	0x63, 0x70, 0x63, 0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x41, 0x0a, 0x0e,
	0x63, 0x70, 0x6d, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0c, 0x63, 0x70, 0x6d, 0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12,
	0x41, 0x0a, 0x0e, 0x63, 0x70, 0x76, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x63, 0x70, 0x76, 0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72,
	0x6f, 0x73, 0x12, 0x50, 0x0a, 0x16, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x70,
	0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x21, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x13, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x4d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x12, 0x59, 0x0a, 0x18, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x63, 0x70, 0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12,
	0x59, 0x0a, 0x18, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x70, 0x6d,
	0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x15, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x70,
	0x6d, 0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x59, 0x0a, 0x18, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x70, 0x76, 0x5f, 0x62, 0x69, 0x64, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x70, 0x76, 0x42, 0x69, 0x64, 0x4d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x68, 0x0a, 0x20, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x70, 0x63, 0x5f, 0x62,
	0x69, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1c, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x50, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12,
	0x7c, 0x0a, 0x18, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x70, 0x63,
	0x5f, 0x62, 0x69, 0x64, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x43, 0x70, 0x63, 0x42, 0x69, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x7c, 0x0a,
	0x18, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x70, 0x6d, 0x5f, 0x62,
	0x69, 0x64, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x75,
	0x6d, 0x2e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43,
	0x70, 0x6d, 0x42, 0x69, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x7c, 0x0a, 0x18, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x70, 0x76, 0x5f, 0x62, 0x69, 0x64,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x42, 0x69,
	0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x15, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x70, 0x76,
	0x42, 0x69, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x8b, 0x01, 0x0a, 0x20, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x70, 0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x23,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1c, 0x65, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x70, 0x63, 0x42, 0x69,
	0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x79, 0x0a, 0x12, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x11, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74,
	0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x73,
	0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x73, 0x12,
	0x48, 0x0a, 0x11, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f,
	0x75, 0x72, 0x6c, 0x73, 0x18, 0x33, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x4d,
	0x6f, 0x62, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x46, 0x0a, 0x10, 0x66, 0x69, 0x6e,
	0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x32, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0e, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x53, 0x75, 0x66, 0x66, 0x69,
	0x78, 0x12, 0x50, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72,
	0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x6c, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x12, 0x63, 0x0a, 0x15, 0x75, 0x72, 0x6c, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0e, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x13, 0x75, 0x72, 0x6c, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4c, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x77,
	0x6f, 0x72, 0x64, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x07, 0x6b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x52, 0x0a, 0x09, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52,
	0x09, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6c, 0x0a, 0x13, 0x6d, 0x6f,
	0x62, 0x69, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x41,
	0x70, 0x70, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x11, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x41, 0x70, 0x70,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x6b, 0x0a, 0x12, 0x6d, 0x6f, 0x62, 0x69,
	0x6c, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x48, 0x00, 0x52, 0x11, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x0d, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x50, 0x0a, 0x09, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x41, 0x67, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x08, 0x61, 0x67, 0x65,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x49, 0x0a, 0x06, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x18,
	0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x06, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72,
	0x12, 0x59, 0x0a, 0x0c, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x63, 0x6f, 0x6d, 0x65, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0b,
	0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x62, 0x0a, 0x0f, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x27,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52,
	0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x50, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x2a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73,
	0x74, 0x12, 0x5c, 0x0a, 0x0d, 0x79, 0x6f, 0x75, 0x74, 0x75, 0x62, 0x65, 0x5f, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x59, 0x6f, 0x75, 0x54, 0x75, 0x62,
	0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48,
	0x00, 0x52, 0x0c, 0x79, 0x6f, 0x75, 0x74, 0x75, 0x62, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x12,
	0x62, 0x0a, 0x0f, 0x79, 0x6f, 0x75, 0x74, 0x75, 0x62, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x59, 0x6f, 0x75, 0x54, 0x75, 0x62,
	0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x48, 0x00, 0x52, 0x0e, 0x79, 0x6f, 0x75, 0x74, 0x75, 0x62, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x12, 0x46, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x2b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0,
	0x41, 0x05, 0x48, 0x00, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x5c, 0x0a, 0x0d, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x18, 0x2d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x07, 0x77, 0x65, 0x62,
	0x70, 0x61, 0x67, 0x65, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x57, 0x65, 0x62, 0x70,
	0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x07,
	0x77, 0x65, 0x62, 0x70, 0x61, 0x67, 0x65, 0x12, 0x66, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x5f, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x2f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x41, 0x70, 0x70, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0f,
	0x61, 0x70, 0x70, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x62, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x79, 0x18, 0x30, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x66, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x79, 0x12, 0x5c, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x31, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x1a, 0xe4, 0x03, 0x0a, 0x0b, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x45, 0x0a, 0x0d, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x71, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x83, 0x01, 0x0a, 0x16, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x86,
	0x01, 0x0a, 0x18, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x15, 0x70, 0x6f, 0x73, 0x74, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x7f, 0x0a, 0x14, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x74, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x65, 0x64, 0x43, 0x74, 0x72, 0x1a, 0x8f, 0x04, 0x0a, 0x11, 0x50, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x73, 0x12, 0x53,
	0x0a, 0x15, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x63,
	0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x12, 0x66, 0x69, 0x72, 0x73, 0x74, 0x50, 0x61, 0x67, 0x65, 0x43, 0x70, 0x63, 0x4d, 0x69, 0x63,
	0x72, 0x6f, 0x73, 0x12, 0x5b, 0x0a, 0x19, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x70, 0x63, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x66, 0x69, 0x72, 0x73, 0x74, 0x50,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x70, 0x63, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x12, 0x54, 0x0a, 0x16, 0x74, 0x6f, 0x70, 0x5f, 0x6f, 0x66, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x70, 0x63, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x12, 0x74, 0x6f, 0x70, 0x4f, 0x66, 0x50, 0x61, 0x67, 0x65, 0x43, 0x70, 0x63,
	0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x7a, 0x0a, 0x2a, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x5f, 0x61,
	0x74, 0x5f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x70, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x24, 0x65, 0x73,
	0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x64, 0x64, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73,
	0x41, 0x74, 0x46, 0x69, 0x72, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x70, 0x63, 0x12, 0x76, 0x0a, 0x28, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x61, 0x64, 0x64, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x61, 0x74, 0x5f, 0x66, 0x69, 0x72, 0x73,
	0x74, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x70, 0x63, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x22, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x73, 0x74, 0x41, 0x74, 0x46, 0x69, 0x72, 0x73, 0x74, 0x50,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x70, 0x63, 0x3a, 0x69, 0xea, 0x41, 0x66, 0x0a,
	0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x7d,
	0x2f, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61,
	0x2f, 0x7b, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x0b, 0x0a, 0x09, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x6f, 0x6e, 0x42, 0x82, 0x02, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x34, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x15, 0x41, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x3b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56,
	0x34, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xca, 0x02, 0x21, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x5c, 0x56, 0x34, 0x5c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xea,
	0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x34, 0x3a, 0x3a, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDescData = file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDesc
)

func file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDescData)
	})
	return file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDescData
}

var file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_ads_googleads_v4_resources_ad_group_criterion_proto_goTypes = []interface{}{
	(*AdGroupCriterion)(nil),                                                     // 0: google.ads.googleads.v4.resources.AdGroupCriterion
	(*AdGroupCriterion_QualityInfo)(nil),                                         // 1: google.ads.googleads.v4.resources.AdGroupCriterion.QualityInfo
	(*AdGroupCriterion_PositionEstimates)(nil),                                   // 2: google.ads.googleads.v4.resources.AdGroupCriterion.PositionEstimates
	(*wrapperspb.Int64Value)(nil),                                                // 3: google.protobuf.Int64Value
	(enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus)(0),                 // 4: google.ads.googleads.v4.enums.AdGroupCriterionStatusEnum.AdGroupCriterionStatus
	(*wrapperspb.StringValue)(nil),                                               // 5: google.protobuf.StringValue
	(enums.CriterionTypeEnum_CriterionType)(0),                                   // 6: google.ads.googleads.v4.enums.CriterionTypeEnum.CriterionType
	(*wrapperspb.BoolValue)(nil),                                                 // 7: google.protobuf.BoolValue
	(enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus)(0),     // 8: google.ads.googleads.v4.enums.CriterionSystemServingStatusEnum.CriterionSystemServingStatus
	(enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus)(0), // 9: google.ads.googleads.v4.enums.AdGroupCriterionApprovalStatusEnum.AdGroupCriterionApprovalStatus
	(*wrapperspb.DoubleValue)(nil),                                               // 10: google.protobuf.DoubleValue
	(enums.BiddingSourceEnum_BiddingSource)(0),                                   // 11: google.ads.googleads.v4.enums.BiddingSourceEnum.BiddingSource
	(*common.CustomParameter)(nil),                                               // 12: google.ads.googleads.v4.common.CustomParameter
	(*common.KeywordInfo)(nil),                                                   // 13: google.ads.googleads.v4.common.KeywordInfo
	(*common.PlacementInfo)(nil),                                                 // 14: google.ads.googleads.v4.common.PlacementInfo
	(*common.MobileAppCategoryInfo)(nil),                                         // 15: google.ads.googleads.v4.common.MobileAppCategoryInfo
	(*common.MobileApplicationInfo)(nil),                                         // 16: google.ads.googleads.v4.common.MobileApplicationInfo
	(*common.ListingGroupInfo)(nil),                                              // 17: google.ads.googleads.v4.common.ListingGroupInfo
	(*common.AgeRangeInfo)(nil),                                                  // 18: google.ads.googleads.v4.common.AgeRangeInfo
	(*common.GenderInfo)(nil),                                                    // 19: google.ads.googleads.v4.common.GenderInfo
	(*common.IncomeRangeInfo)(nil),                                               // 20: google.ads.googleads.v4.common.IncomeRangeInfo
	(*common.ParentalStatusInfo)(nil),                                            // 21: google.ads.googleads.v4.common.ParentalStatusInfo
	(*common.UserListInfo)(nil),                                                  // 22: google.ads.googleads.v4.common.UserListInfo
	(*common.YouTubeVideoInfo)(nil),                                              // 23: google.ads.googleads.v4.common.YouTubeVideoInfo
	(*common.YouTubeChannelInfo)(nil),                                            // 24: google.ads.googleads.v4.common.YouTubeChannelInfo
	(*common.TopicInfo)(nil),                                                     // 25: google.ads.googleads.v4.common.TopicInfo
	(*common.UserInterestInfo)(nil),                                              // 26: google.ads.googleads.v4.common.UserInterestInfo
	(*common.WebpageInfo)(nil),                                                   // 27: google.ads.googleads.v4.common.WebpageInfo
	(*common.AppPaymentModelInfo)(nil),                                           // 28: google.ads.googleads.v4.common.AppPaymentModelInfo
	(*common.CustomAffinityInfo)(nil),                                            // 29: google.ads.googleads.v4.common.CustomAffinityInfo
	(*common.CustomIntentInfo)(nil),                                              // 30: google.ads.googleads.v4.common.CustomIntentInfo
	(*wrapperspb.Int32Value)(nil),                                                // 31: google.protobuf.Int32Value
	(enums.QualityScoreBucketEnum_QualityScoreBucket)(0),                         // 32: google.ads.googleads.v4.enums.QualityScoreBucketEnum.QualityScoreBucket
}
var file_google_ads_googleads_v4_resources_ad_group_criterion_proto_depIdxs = []int32{
	3,  // 0: google.ads.googleads.v4.resources.AdGroupCriterion.criterion_id:type_name -> google.protobuf.Int64Value
	4,  // 1: google.ads.googleads.v4.resources.AdGroupCriterion.status:type_name -> google.ads.googleads.v4.enums.AdGroupCriterionStatusEnum.AdGroupCriterionStatus
	1,  // 2: google.ads.googleads.v4.resources.AdGroupCriterion.quality_info:type_name -> google.ads.googleads.v4.resources.AdGroupCriterion.QualityInfo
	5,  // 3: google.ads.googleads.v4.resources.AdGroupCriterion.ad_group:type_name -> google.protobuf.StringValue
	6,  // 4: google.ads.googleads.v4.resources.AdGroupCriterion.type:type_name -> google.ads.googleads.v4.enums.CriterionTypeEnum.CriterionType
	7,  // 5: google.ads.googleads.v4.resources.AdGroupCriterion.negative:type_name -> google.protobuf.BoolValue
	8,  // 6: google.ads.googleads.v4.resources.AdGroupCriterion.system_serving_status:type_name -> google.ads.googleads.v4.enums.CriterionSystemServingStatusEnum.CriterionSystemServingStatus
	9,  // 7: google.ads.googleads.v4.resources.AdGroupCriterion.approval_status:type_name -> google.ads.googleads.v4.enums.AdGroupCriterionApprovalStatusEnum.AdGroupCriterionApprovalStatus
	5,  // 8: google.ads.googleads.v4.resources.AdGroupCriterion.disapproval_reasons:type_name -> google.protobuf.StringValue
	10, // 9: google.ads.googleads.v4.resources.AdGroupCriterion.bid_modifier:type_name -> google.protobuf.DoubleValue
	3,  // 10: google.ads.googleads.v4.resources.AdGroupCriterion.cpc_bid_micros:type_name -> google.protobuf.Int64Value
	3,  // 11: google.ads.googleads.v4.resources.AdGroupCriterion.cpm_bid_micros:type_name -> google.protobuf.Int64Value
	3,  // 12: google.ads.googleads.v4.resources.AdGroupCriterion.cpv_bid_micros:type_name -> google.protobuf.Int64Value
	3,  // 13: google.ads.googleads.v4.resources.AdGroupCriterion.percent_cpc_bid_micros:type_name -> google.protobuf.Int64Value
	3,  // 14: google.ads.googleads.v4.resources.AdGroupCriterion.effective_cpc_bid_micros:type_name -> google.protobuf.Int64Value
	3,  // 15: google.ads.googleads.v4.resources.AdGroupCriterion.effective_cpm_bid_micros:type_name -> google.protobuf.Int64Value
	3,  // 16: google.ads.googleads.v4.resources.AdGroupCriterion.effective_cpv_bid_micros:type_name -> google.protobuf.Int64Value
	3,  // 17: google.ads.googleads.v4.resources.AdGroupCriterion.effective_percent_cpc_bid_micros:type_name -> google.protobuf.Int64Value
	11, // 18: google.ads.googleads.v4.resources.AdGroupCriterion.effective_cpc_bid_source:type_name -> google.ads.googleads.v4.enums.BiddingSourceEnum.BiddingSource
	11, // 19: google.ads.googleads.v4.resources.AdGroupCriterion.effective_cpm_bid_source:type_name -> google.ads.googleads.v4.enums.BiddingSourceEnum.BiddingSource
	11, // 20: google.ads.googleads.v4.resources.AdGroupCriterion.effective_cpv_bid_source:type_name -> google.ads.googleads.v4.enums.BiddingSourceEnum.BiddingSource
	11, // 21: google.ads.googleads.v4.resources.AdGroupCriterion.effective_percent_cpc_bid_source:type_name -> google.ads.googleads.v4.enums.BiddingSourceEnum.BiddingSource
	2,  // 22: google.ads.googleads.v4.resources.AdGroupCriterion.position_estimates:type_name -> google.ads.googleads.v4.resources.AdGroupCriterion.PositionEstimates
	5,  // 23: google.ads.googleads.v4.resources.AdGroupCriterion.final_urls:type_name -> google.protobuf.StringValue
	5,  // 24: google.ads.googleads.v4.resources.AdGroupCriterion.final_mobile_urls:type_name -> google.protobuf.StringValue
	5,  // 25: google.ads.googleads.v4.resources.AdGroupCriterion.final_url_suffix:type_name -> google.protobuf.StringValue
	5,  // 26: google.ads.googleads.v4.resources.AdGroupCriterion.tracking_url_template:type_name -> google.protobuf.StringValue
	12, // 27: google.ads.googleads.v4.resources.AdGroupCriterion.url_custom_parameters:type_name -> google.ads.googleads.v4.common.CustomParameter
	13, // 28: google.ads.googleads.v4.resources.AdGroupCriterion.keyword:type_name -> google.ads.googleads.v4.common.KeywordInfo
	14, // 29: google.ads.googleads.v4.resources.AdGroupCriterion.placement:type_name -> google.ads.googleads.v4.common.PlacementInfo
	15, // 30: google.ads.googleads.v4.resources.AdGroupCriterion.mobile_app_category:type_name -> google.ads.googleads.v4.common.MobileAppCategoryInfo
	16, // 31: google.ads.googleads.v4.resources.AdGroupCriterion.mobile_application:type_name -> google.ads.googleads.v4.common.MobileApplicationInfo
	17, // 32: google.ads.googleads.v4.resources.AdGroupCriterion.listing_group:type_name -> google.ads.googleads.v4.common.ListingGroupInfo
	18, // 33: google.ads.googleads.v4.resources.AdGroupCriterion.age_range:type_name -> google.ads.googleads.v4.common.AgeRangeInfo
	19, // 34: google.ads.googleads.v4.resources.AdGroupCriterion.gender:type_name -> google.ads.googleads.v4.common.GenderInfo
	20, // 35: google.ads.googleads.v4.resources.AdGroupCriterion.income_range:type_name -> google.ads.googleads.v4.common.IncomeRangeInfo
	21, // 36: google.ads.googleads.v4.resources.AdGroupCriterion.parental_status:type_name -> google.ads.googleads.v4.common.ParentalStatusInfo
	22, // 37: google.ads.googleads.v4.resources.AdGroupCriterion.user_list:type_name -> google.ads.googleads.v4.common.UserListInfo
	23, // 38: google.ads.googleads.v4.resources.AdGroupCriterion.youtube_video:type_name -> google.ads.googleads.v4.common.YouTubeVideoInfo
	24, // 39: google.ads.googleads.v4.resources.AdGroupCriterion.youtube_channel:type_name -> google.ads.googleads.v4.common.YouTubeChannelInfo
	25, // 40: google.ads.googleads.v4.resources.AdGroupCriterion.topic:type_name -> google.ads.googleads.v4.common.TopicInfo
	26, // 41: google.ads.googleads.v4.resources.AdGroupCriterion.user_interest:type_name -> google.ads.googleads.v4.common.UserInterestInfo
	27, // 42: google.ads.googleads.v4.resources.AdGroupCriterion.webpage:type_name -> google.ads.googleads.v4.common.WebpageInfo
	28, // 43: google.ads.googleads.v4.resources.AdGroupCriterion.app_payment_model:type_name -> google.ads.googleads.v4.common.AppPaymentModelInfo
	29, // 44: google.ads.googleads.v4.resources.AdGroupCriterion.custom_affinity:type_name -> google.ads.googleads.v4.common.CustomAffinityInfo
	30, // 45: google.ads.googleads.v4.resources.AdGroupCriterion.custom_intent:type_name -> google.ads.googleads.v4.common.CustomIntentInfo
	31, // 46: google.ads.googleads.v4.resources.AdGroupCriterion.QualityInfo.quality_score:type_name -> google.protobuf.Int32Value
	32, // 47: google.ads.googleads.v4.resources.AdGroupCriterion.QualityInfo.creative_quality_score:type_name -> google.ads.googleads.v4.enums.QualityScoreBucketEnum.QualityScoreBucket
	32, // 48: google.ads.googleads.v4.resources.AdGroupCriterion.QualityInfo.post_click_quality_score:type_name -> google.ads.googleads.v4.enums.QualityScoreBucketEnum.QualityScoreBucket
	32, // 49: google.ads.googleads.v4.resources.AdGroupCriterion.QualityInfo.search_predicted_ctr:type_name -> google.ads.googleads.v4.enums.QualityScoreBucketEnum.QualityScoreBucket
	3,  // 50: google.ads.googleads.v4.resources.AdGroupCriterion.PositionEstimates.first_page_cpc_micros:type_name -> google.protobuf.Int64Value
	3,  // 51: google.ads.googleads.v4.resources.AdGroupCriterion.PositionEstimates.first_position_cpc_micros:type_name -> google.protobuf.Int64Value
	3,  // 52: google.ads.googleads.v4.resources.AdGroupCriterion.PositionEstimates.top_of_page_cpc_micros:type_name -> google.protobuf.Int64Value
	3,  // 53: google.ads.googleads.v4.resources.AdGroupCriterion.PositionEstimates.estimated_add_clicks_at_first_position_cpc:type_name -> google.protobuf.Int64Value
	3,  // 54: google.ads.googleads.v4.resources.AdGroupCriterion.PositionEstimates.estimated_add_cost_at_first_position_cpc:type_name -> google.protobuf.Int64Value
	55, // [55:55] is the sub-list for method output_type
	55, // [55:55] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v4_resources_ad_group_criterion_proto_init() }
func file_google_ads_googleads_v4_resources_ad_group_criterion_proto_init() {
	if File_google_ads_googleads_v4_resources_ad_group_criterion_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdGroupCriterion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdGroupCriterion_QualityInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdGroupCriterion_PositionEstimates); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*AdGroupCriterion_Keyword)(nil),
		(*AdGroupCriterion_Placement)(nil),
		(*AdGroupCriterion_MobileAppCategory)(nil),
		(*AdGroupCriterion_MobileApplication)(nil),
		(*AdGroupCriterion_ListingGroup)(nil),
		(*AdGroupCriterion_AgeRange)(nil),
		(*AdGroupCriterion_Gender)(nil),
		(*AdGroupCriterion_IncomeRange)(nil),
		(*AdGroupCriterion_ParentalStatus)(nil),
		(*AdGroupCriterion_UserList)(nil),
		(*AdGroupCriterion_YoutubeVideo)(nil),
		(*AdGroupCriterion_YoutubeChannel)(nil),
		(*AdGroupCriterion_Topic)(nil),
		(*AdGroupCriterion_UserInterest)(nil),
		(*AdGroupCriterion_Webpage)(nil),
		(*AdGroupCriterion_AppPaymentModel)(nil),
		(*AdGroupCriterion_CustomAffinity)(nil),
		(*AdGroupCriterion_CustomIntent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v4_resources_ad_group_criterion_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v4_resources_ad_group_criterion_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v4_resources_ad_group_criterion_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v4_resources_ad_group_criterion_proto = out.File
	file_google_ads_googleads_v4_resources_ad_group_criterion_proto_rawDesc = nil
	file_google_ads_googleads_v4_resources_ad_group_criterion_proto_goTypes = nil
	file_google_ads_googleads_v4_resources_ad_group_criterion_proto_depIdxs = nil
}
