//go:generate mapgen -name "dirs" -zero "false" -go-type "bool" -pkg "" -a "nil" -b "nil" -c "nil" -bb "nil" -destination "packr"
// Code generated by github.com/gobuffalo/mapgen. DO NOT EDIT.

package packr

import (
	"sort"
	"strings"
	"sync"
)

// dirsMap wraps sync.Map and uses the following types:
// key:   string
// value: bool
type dirsMap struct {
	data sync.Map
}

// Delete the key from the map
func (m *dirsMap) Delete(key string) {
	m.data.Delete(m.normalizeKey(key))
}

// Load the key from the map.
// Returns bool or bool.
// A false return indicates either the key was not found
// or the value is not of type bool
func (m *dirsMap) Load(key string) (bool, bool) {
	i, ok := m.data.Load(m.normalizeKey(key))
	if !ok {
		return false, false
	}
	s, ok := i.(bool)
	return s, ok
}

// LoadOrStore will return an existing key or
// store the value if not already in the map
func (m *dirsMap) LoadOrStore(key string, value bool) (bool, bool) {
	i, _ := m.data.LoadOrStore(m.normalizeKey(key), value)
	s, ok := i.(bool)
	return s, ok
}

// Range over the bool values in the map
func (m *dirsMap) Range(f func(key string, value bool) bool) {
	m.data.Range(func(k, v interface{}) bool {
		key, ok := k.(string)
		if !ok {
			return false
		}
		value, ok := v.(bool)
		if !ok {
			return false
		}
		return f(key, value)
	})
}

// Store a bool in the map
func (m *dirsMap) Store(key string, value bool) {
	d := m.normalizeKey(key)
	m.data.Store(d, value)
	m.data.Store(strings.TrimPrefix(d, "/"), value)
}

// Keys returns a list of keys in the map
func (m *dirsMap) Keys() []string {
	var keys []string
	m.Range(func(key string, value bool) bool {
		keys = append(keys, key)
		return true
	})
	sort.Strings(keys)
	return keys
}

func (m *dirsMap) normalizeKey(key string) string {
	key = strings.Replace(key, "\\", "/", -1)

	return key
}
