/*
Copyright © 2023 atanarjuat@riseup.net
*/
package cmd

import (
	"github.com/rs/zerolog/log"
	"github.com/spf13/cobra"
)

// listCmd represents the list command
var listCmd = &cobra.Command{
	Use:   "list",
	Short: "A brief description of your command",
	Long: `A longer description that spans multiple lines and likely contains examples
and usage of using your command. For example:

Cobra is a CLI library for Go that empowers applications.
This application is a tool to generate the needed files
to quickly create a Cobra application.`,
	Run: func(cmd *cobra.Command, args []string) {
		cmdArgs := []string{"sessions-list"}
		if err := runOpenVPNCmd(cmdArgs); err != nil {
			log.Fatal().Err(err).Msg("")
		}
		cmdArgs = []string{"configs-list"}
		if err := runOpenVPNCmd(cmdArgs); err != nil {
			log.Fatal().Err(err).Msg("")
		}
	},
}

func init() {
	tunnelCmd.AddCommand(listCmd)

	// Here you will define your flags and configuration settings.

	// Cobra supports Persistent Flags which will work for this command
	// and all subcommands, e.g.:
	// listCmd.PersistentFlags().String("foo", "", "A help for foo")

	// Cobra supports local flags which will only run when this command
	// is called directly, e.g.:
	// listCmd.Flags().BoolP("toggle", "t", false, "Help message for toggle")
}

/*
func listTunnels() error {
	cmd := exec.Command("openvpn3", "sessions-list")
	out, err := cmd.CombinedOutput()
	if err != nil {
		return fmt.Errorf("cannot list sessions: %w", err)
	}
	fmt.Println(string(out))
	return nil
}
*/
