// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_get_object_acl_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::get_object_acl::GetObjectAclOutput, crate::operation::get_object_acl::GetObjectAclError> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::get_object_acl::GetObjectAclError::unhandled)?;
    generic_builder = crate::s3_request_id::apply_extended_request_id(generic_builder, _response_headers);
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::get_object_acl::GetObjectAclError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchKey" => crate::operation::get_object_acl::GetObjectAclError::NoSuchKey({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::NoSuchKeyBuilder::default();
                output = crate::protocol_serde::shape_no_such_key::de_no_such_key_xml_err(_response_body, output)
                    .map_err(crate::operation::get_object_acl::GetObjectAclError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::get_object_acl::GetObjectAclError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_get_object_acl_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::get_object_acl::GetObjectAclOutput, crate::operation::get_object_acl::GetObjectAclError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::get_object_acl::builders::GetObjectAclOutputBuilder::default();
        output = crate::protocol_serde::shape_get_object_acl::de_get_object_acl(_response_body, output)
            .map_err(crate::operation::get_object_acl::GetObjectAclError::unhandled)?;
        output = output.set_request_charged(
            crate::protocol_serde::shape_get_object_acl_output::de_request_charged_header(_response_headers).map_err(|_| {
                crate::operation::get_object_acl::GetObjectAclError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged")
            })?,
        );
        output._set_extended_request_id(crate::s3_request_id::RequestIdExt::extended_request_id(_response_headers).map(str::to_string));
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_get_object_acl_headers(
    input: &crate::operation::get_object_acl::GetObjectAclInput,
    mut builder: ::http::request::Builder,
) -> std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
    if let ::std::option::Option::Some(inner_1) = &input.request_payer {
        let formatted_2 = inner_1.as_str();
        let header_value = formatted_2;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "request_payer",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-request-payer", header_value);
    }
    if let ::std::option::Option::Some(inner_3) = &input.expected_bucket_owner {
        let formatted_4 = inner_3.as_str();
        let header_value = formatted_4;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "expected_bucket_owner",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-expected-bucket-owner", header_value);
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn de_get_object_acl(
    inp: &[u8],
    mut builder: crate::operation::get_object_acl::builders::GetObjectAclOutputBuilder,
) -> std::result::Result<crate::operation::get_object_acl::builders::GetObjectAclOutputBuilder, ::aws_smithy_xml::decode::XmlDecodeError> {
    let mut doc = ::aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    #[allow(unused_variables)]
    let start_el = decoder.start_el();
    if !start_el.matches("AccessControlPolicy") {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
            "encountered invalid XML root: expected AccessControlPolicy but got {:?}. This is likely a bug in the SDK.",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Owner") /* Owner com.amazonaws.s3.synthetic#GetObjectAclOutput$Owner */ =>  {
                let var_5 =
                    Some(
                        crate::protocol_serde::shape_owner::de_owner(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_owner(var_5);
            }
            ,
            s if s.matches("AccessControlList") /* Grants com.amazonaws.s3.synthetic#GetObjectAclOutput$Grants */ =>  {
                let var_6 =
                    Some(
                        crate::protocol_serde::shape_grants::de_grants(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_grants(var_6);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}
