//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfdocument?language=objc)
#[repr(C)]
pub struct CGPDFDocument {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGPDFDocument {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGPDFDocument"> for CGPDFDocument {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfaccesspermissions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGPDFAccessPermissions(pub u32);
bitflags::bitflags! {
    impl CGPDFAccessPermissions: u32 {
        #[doc(alias = "kCGPDFAllowsLowQualityPrinting")]
        const AllowsLowQualityPrinting = 1<<0;
        #[doc(alias = "kCGPDFAllowsHighQualityPrinting")]
        const AllowsHighQualityPrinting = 1<<1;
        #[doc(alias = "kCGPDFAllowsDocumentChanges")]
        const AllowsDocumentChanges = 1<<2;
        #[doc(alias = "kCGPDFAllowsDocumentAssembly")]
        const AllowsDocumentAssembly = 1<<3;
        #[doc(alias = "kCGPDFAllowsContentCopying")]
        const AllowsContentCopying = 1<<4;
        #[doc(alias = "kCGPDFAllowsContentAccessibility")]
        const AllowsContentAccessibility = 1<<5;
        #[doc(alias = "kCGPDFAllowsCommenting")]
        const AllowsCommenting = 1<<6;
        #[doc(alias = "kCGPDFAllowsFormFieldEntry")]
        const AllowsFormFieldEntry = 1<<7;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGPDFAccessPermissions {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPDFAccessPermissions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgpdfoutlinetitle?language=objc)
    pub static kCGPDFOutlineTitle: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgpdfoutlinechildren?language=objc)
    pub static kCGPDFOutlineChildren: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgpdfoutlinedestination?language=objc)
    pub static kCGPDFOutlineDestination: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgpdfoutlinedestinationrect?language=objc)
    pub static kCGPDFOutlineDestinationRect: &'static CFString;
}

impl CGPDFDocument {
    #[doc(alias = "CGPDFDocumentCreateWithProvider")]
    #[cfg(feature = "CGDataProvider")]
    #[inline]
    pub unsafe fn with_provider(
        provider: Option<&CGDataProvider>,
    ) -> Option<CFRetained<CGPDFDocument>> {
        extern "C-unwind" {
            fn CGPDFDocumentCreateWithProvider(
                provider: Option<&CGDataProvider>,
            ) -> Option<NonNull<CGPDFDocument>>;
        }
        let ret = unsafe { CGPDFDocumentCreateWithProvider(provider) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPDFDocumentCreateWithURL")]
    #[inline]
    pub unsafe fn with_url(url: Option<&CFURL>) -> Option<CFRetained<CGPDFDocument>> {
        extern "C-unwind" {
            fn CGPDFDocumentCreateWithURL(url: Option<&CFURL>) -> Option<NonNull<CGPDFDocument>>;
        }
        let ret = unsafe { CGPDFDocumentCreateWithURL(url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPDFDocumentGetVersion")]
    #[inline]
    pub unsafe fn version(
        document: Option<&CGPDFDocument>,
        major_version: NonNull<c_int>,
        minor_version: NonNull<c_int>,
    ) {
        extern "C-unwind" {
            fn CGPDFDocumentGetVersion(
                document: Option<&CGPDFDocument>,
                major_version: NonNull<c_int>,
                minor_version: NonNull<c_int>,
            );
        }
        unsafe { CGPDFDocumentGetVersion(document, major_version, minor_version) }
    }

    #[doc(alias = "CGPDFDocumentIsEncrypted")]
    #[inline]
    pub unsafe fn is_encrypted(document: Option<&CGPDFDocument>) -> bool {
        extern "C-unwind" {
            fn CGPDFDocumentIsEncrypted(document: Option<&CGPDFDocument>) -> bool;
        }
        unsafe { CGPDFDocumentIsEncrypted(document) }
    }

    #[doc(alias = "CGPDFDocumentUnlockWithPassword")]
    #[inline]
    pub unsafe fn unlock_with_password(
        document: Option<&CGPDFDocument>,
        password: NonNull<c_char>,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFDocumentUnlockWithPassword(
                document: Option<&CGPDFDocument>,
                password: NonNull<c_char>,
            ) -> bool;
        }
        unsafe { CGPDFDocumentUnlockWithPassword(document, password) }
    }

    #[doc(alias = "CGPDFDocumentIsUnlocked")]
    #[inline]
    pub unsafe fn is_unlocked(document: Option<&CGPDFDocument>) -> bool {
        extern "C-unwind" {
            fn CGPDFDocumentIsUnlocked(document: Option<&CGPDFDocument>) -> bool;
        }
        unsafe { CGPDFDocumentIsUnlocked(document) }
    }

    #[doc(alias = "CGPDFDocumentAllowsPrinting")]
    #[inline]
    pub unsafe fn allows_printing(document: Option<&CGPDFDocument>) -> bool {
        extern "C-unwind" {
            fn CGPDFDocumentAllowsPrinting(document: Option<&CGPDFDocument>) -> bool;
        }
        unsafe { CGPDFDocumentAllowsPrinting(document) }
    }

    #[doc(alias = "CGPDFDocumentAllowsCopying")]
    #[inline]
    pub unsafe fn allows_copying(document: Option<&CGPDFDocument>) -> bool {
        extern "C-unwind" {
            fn CGPDFDocumentAllowsCopying(document: Option<&CGPDFDocument>) -> bool;
        }
        unsafe { CGPDFDocumentAllowsCopying(document) }
    }

    #[doc(alias = "CGPDFDocumentGetNumberOfPages")]
    #[inline]
    pub unsafe fn number_of_pages(document: Option<&CGPDFDocument>) -> usize {
        extern "C-unwind" {
            fn CGPDFDocumentGetNumberOfPages(document: Option<&CGPDFDocument>) -> usize;
        }
        unsafe { CGPDFDocumentGetNumberOfPages(document) }
    }

    #[doc(alias = "CGPDFDocumentGetPage")]
    #[cfg(feature = "CGPDFPage")]
    #[inline]
    pub unsafe fn page(
        document: Option<&CGPDFDocument>,
        page_number: usize,
    ) -> Option<CFRetained<CGPDFPage>> {
        extern "C-unwind" {
            fn CGPDFDocumentGetPage(
                document: Option<&CGPDFDocument>,
                page_number: usize,
            ) -> Option<NonNull<CGPDFPage>>;
        }
        let ret = unsafe { CGPDFDocumentGetPage(document, page_number) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CGPDFDocumentGetCatalog")]
    #[cfg(feature = "CGPDFDictionary")]
    #[inline]
    pub unsafe fn catalog(document: Option<&CGPDFDocument>) -> CGPDFDictionaryRef {
        extern "C-unwind" {
            fn CGPDFDocumentGetCatalog(document: Option<&CGPDFDocument>) -> CGPDFDictionaryRef;
        }
        unsafe { CGPDFDocumentGetCatalog(document) }
    }

    #[doc(alias = "CGPDFDocumentGetInfo")]
    #[cfg(feature = "CGPDFDictionary")]
    #[inline]
    pub unsafe fn info(document: Option<&CGPDFDocument>) -> CGPDFDictionaryRef {
        extern "C-unwind" {
            fn CGPDFDocumentGetInfo(document: Option<&CGPDFDocument>) -> CGPDFDictionaryRef;
        }
        unsafe { CGPDFDocumentGetInfo(document) }
    }

    #[doc(alias = "CGPDFDocumentGetID")]
    #[cfg(feature = "CGPDFArray")]
    #[inline]
    pub unsafe fn id(document: Option<&CGPDFDocument>) -> CGPDFArrayRef {
        extern "C-unwind" {
            fn CGPDFDocumentGetID(document: Option<&CGPDFDocument>) -> CGPDFArrayRef;
        }
        unsafe { CGPDFDocumentGetID(document) }
    }
}

unsafe impl ConcreteType for CGPDFDocument {
    #[doc(alias = "CGPDFDocumentGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGPDFDocumentGetTypeID() -> CFTypeID;
        }
        unsafe { CGPDFDocumentGetTypeID() }
    }
}

impl CGPDFDocument {
    #[doc(alias = "CGPDFDocumentGetOutline")]
    #[inline]
    pub unsafe fn outline(self: &CGPDFDocument) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CGPDFDocumentGetOutline(document: &CGPDFDocument) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CGPDFDocumentGetOutline(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CGPDFDocumentGetAccessPermissions")]
    #[inline]
    pub unsafe fn access_permissions(self: &CGPDFDocument) -> CGPDFAccessPermissions {
        extern "C-unwind" {
            fn CGPDFDocumentGetAccessPermissions(
                document: &CGPDFDocument,
            ) -> CGPDFAccessPermissions;
        }
        unsafe { CGPDFDocumentGetAccessPermissions(self) }
    }

    #[doc(alias = "CGPDFDocumentGetMediaBox")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn media_box(document: Option<&CGPDFDocument>, page: c_int) -> CGRect {
        extern "C-unwind" {
            fn CGPDFDocumentGetMediaBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
        }
        unsafe { CGPDFDocumentGetMediaBox(document, page) }
    }

    #[doc(alias = "CGPDFDocumentGetCropBox")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn crop_box(document: Option<&CGPDFDocument>, page: c_int) -> CGRect {
        extern "C-unwind" {
            fn CGPDFDocumentGetCropBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
        }
        unsafe { CGPDFDocumentGetCropBox(document, page) }
    }

    #[doc(alias = "CGPDFDocumentGetBleedBox")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn bleed_box(document: Option<&CGPDFDocument>, page: c_int) -> CGRect {
        extern "C-unwind" {
            fn CGPDFDocumentGetBleedBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
        }
        unsafe { CGPDFDocumentGetBleedBox(document, page) }
    }

    #[doc(alias = "CGPDFDocumentGetTrimBox")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn trim_box(document: Option<&CGPDFDocument>, page: c_int) -> CGRect {
        extern "C-unwind" {
            fn CGPDFDocumentGetTrimBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
        }
        unsafe { CGPDFDocumentGetTrimBox(document, page) }
    }

    #[doc(alias = "CGPDFDocumentGetArtBox")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn art_box(document: Option<&CGPDFDocument>, page: c_int) -> CGRect {
        extern "C-unwind" {
            fn CGPDFDocumentGetArtBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
        }
        unsafe { CGPDFDocumentGetArtBox(document, page) }
    }

    #[doc(alias = "CGPDFDocumentGetRotationAngle")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn rotation_angle(document: Option<&CGPDFDocument>, page: c_int) -> c_int {
        extern "C-unwind" {
            fn CGPDFDocumentGetRotationAngle(
                document: Option<&CGPDFDocument>,
                page: c_int,
            ) -> c_int;
        }
        unsafe { CGPDFDocumentGetRotationAngle(document, page) }
    }
}

#[cfg(feature = "CGDataProvider")]
#[deprecated = "renamed to `CGPDFDocument::with_provider`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPDFDocumentCreateWithProvider(
    provider: Option<&CGDataProvider>,
) -> Option<CFRetained<CGPDFDocument>> {
    extern "C-unwind" {
        fn CGPDFDocumentCreateWithProvider(
            provider: Option<&CGDataProvider>,
        ) -> Option<NonNull<CGPDFDocument>>;
    }
    let ret = unsafe { CGPDFDocumentCreateWithProvider(provider) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPDFDocument::with_url`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPDFDocumentCreateWithURL(
    url: Option<&CFURL>,
) -> Option<CFRetained<CGPDFDocument>> {
    extern "C-unwind" {
        fn CGPDFDocumentCreateWithURL(url: Option<&CFURL>) -> Option<NonNull<CGPDFDocument>>;
    }
    let ret = unsafe { CGPDFDocumentCreateWithURL(url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::version`"]
    pub fn CGPDFDocumentGetVersion(
        document: Option<&CGPDFDocument>,
        major_version: NonNull<c_int>,
        minor_version: NonNull<c_int>,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::is_encrypted`"]
    pub fn CGPDFDocumentIsEncrypted(document: Option<&CGPDFDocument>) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::unlock_with_password`"]
    pub fn CGPDFDocumentUnlockWithPassword(
        document: Option<&CGPDFDocument>,
        password: NonNull<c_char>,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::is_unlocked`"]
    pub fn CGPDFDocumentIsUnlocked(document: Option<&CGPDFDocument>) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::allows_printing`"]
    pub fn CGPDFDocumentAllowsPrinting(document: Option<&CGPDFDocument>) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::allows_copying`"]
    pub fn CGPDFDocumentAllowsCopying(document: Option<&CGPDFDocument>) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::number_of_pages`"]
    pub fn CGPDFDocumentGetNumberOfPages(document: Option<&CGPDFDocument>) -> usize;
}

#[cfg(feature = "CGPDFPage")]
#[deprecated = "renamed to `CGPDFDocument::page`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPDFDocumentGetPage(
    document: Option<&CGPDFDocument>,
    page_number: usize,
) -> Option<CFRetained<CGPDFPage>> {
    extern "C-unwind" {
        fn CGPDFDocumentGetPage(
            document: Option<&CGPDFDocument>,
            page_number: usize,
        ) -> Option<NonNull<CGPDFPage>>;
    }
    let ret = unsafe { CGPDFDocumentGetPage(document, page_number) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFDictionary")]
    #[deprecated = "renamed to `CGPDFDocument::catalog`"]
    pub fn CGPDFDocumentGetCatalog(document: Option<&CGPDFDocument>) -> CGPDFDictionaryRef;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFDictionary")]
    #[deprecated = "renamed to `CGPDFDocument::info`"]
    pub fn CGPDFDocumentGetInfo(document: Option<&CGPDFDocument>) -> CGPDFDictionaryRef;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFArray")]
    #[deprecated = "renamed to `CGPDFDocument::id`"]
    pub fn CGPDFDocumentGetID(document: Option<&CGPDFDocument>) -> CGPDFArrayRef;
}

#[deprecated = "renamed to `CGPDFDocument::outline`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPDFDocumentGetOutline(
    document: &CGPDFDocument,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CGPDFDocumentGetOutline(document: &CGPDFDocument) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CGPDFDocumentGetOutline(document) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::access_permissions`"]
    pub fn CGPDFDocumentGetAccessPermissions(document: &CGPDFDocument) -> CGPDFAccessPermissions;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::media_box`"]
    pub fn CGPDFDocumentGetMediaBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::crop_box`"]
    pub fn CGPDFDocumentGetCropBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::bleed_box`"]
    pub fn CGPDFDocumentGetBleedBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::trim_box`"]
    pub fn CGPDFDocumentGetTrimBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::art_box`"]
    pub fn CGPDFDocumentGetArtBox(document: Option<&CGPDFDocument>, page: c_int) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDocument::rotation_angle`"]
    pub fn CGPDFDocumentGetRotationAngle(document: Option<&CGPDFDocument>, page: c_int) -> c_int;
}
