RabbitMQ `3.11.24` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).
This release series [goes out of community support on Dec 31, 2023](https://rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).


### Core Server

#### Bug Fixes

 * Stream replication connections configured to use exclusively TLSv1.3 failed.

   GitHub issue:[#9678](https://github.com/rabbitmq/rabbitmq-server/pull/9678)

 * On startup, stream replicas will handle one more potential case of segment file corruption
   after an unclean shutdown.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#9678](https://github.com/rabbitmq/rabbitmq-server/pull/9678)

 * `default_policies.*.queue_pattern` definition in `rabbitmq.conf` was incorrectly parsed.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#9546](https://github.com/rabbitmq/rabbitmq-server/pull/9546)

#### Enhancements

 * Optimized stream index scans. Longer scans could result in some replicas stopping
   with a timeout.

   GitHub issue:[#9678](https://github.com/rabbitmq/rabbitmq-server/pull/9678)

 * Classic queue storage version is now a supported key for [operator policies](https://rabbitmq.com/parameters.html#operator-policies).

   Contributed by @SignalWhisperer (AWS).

   GitHub issue: [#9549](https://github.com/rabbitmq/rabbitmq-server/pull/9549)

 * Nodes now log boot time at info level instead of debug. This piece of information
   can be useful during root cause analysis.

   Contributed by @johanrhodin (CloudAMQP).

   GitHub issue: [#9466](https://github.com/rabbitmq/rabbitmq-server/pull/9466)


### Management Plugin

#### Enhancements

 * HTTP API request body size is now limited to 10 MiB by default.
   Two endpoints, one that accepts messages for publishing (note: publishing over the HTTP API is greatly discouraged)
   and another for [definition import](https://rabbitmq.com/definitions.html#import),
   will now reject larger transfers with a `400 Bad Request` response.

   GitHub issue: [#9708](https://github.com/rabbitmq/rabbitmq-server/pull/9708)

 * `DELETE /api/queues/{vhost}/{name}` now can delete exclusive queues.

   GitHub issue: [#8758](https://github.com/rabbitmq/rabbitmq-server/issues/8758)


## Dependency Upgrades

 * `osiris` has been upgraded to [`1.6.9`](https://github.com/rabbitmq/osiris/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.24.tar.xz`
instead of the source tarball produced by GitHub.
