//========================================================================
//
// gfile-xpdf.h
//
// Miscellaneous file and directory name manipulation.
//
// Copyright 1996-2003 Glyph & Cog, LLC
// Copyright 2025 Adam Sampson <ats@offog.org>
//
//========================================================================

#ifndef GFILE_XPDF_H
#define GFILE_XPDF_H

#include <string>
#include <time.h>

//------------------------------------------------------------------------

// Get home directory path.
extern std::string xpdfGetHomeDir();

// Get the directory part of a file name.  If there is no
// directory component in <fileName>, returns an empty string.
extern std::string xpdfDirName(const std::string& fileName);

// Is this an absolute path or file name?
extern bool xpdfIsAbsolutePath(const std::string& path);

// Does this path end in ".pdf" (case-insensitively)?
extern bool endsWithDotPDF(const std::string& path);

// Get the modification time for <fileName>.  Returns 0 if there is an
// error.
extern time_t xpdfGetModTime(const std::string& fileName);

// Make this path absolute by prepending current directory (if path is
// relative).
extern std::string xpdfMakePathAbsolute(std::string path);

#endif
