#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;

use lib 'lib';
use Data::Dumper;
use Database::Filter;
use OPTIMADE::Filter::Parser;

binmode( STDOUT, 'utf8' );

my @test_cases = (
    "(revision_id < 4) OR (NOT (id > 10))",
);

eval {
    local $\ = "\n";
    for my $case (@test_cases) {
        my $parser = new OPTIMADE::Filter::Parser;
        print $case;
        my $tree = $parser->parse_string( $case );
        my $filter = Database::Filter->new_from_tree( $tree );
        my $filter_string = $filter->filter->to_SQL( { delim => '`' } );
        print $filter_string;
        print '';
    }
};
if( $@ ) {
    print STDERR $@;
}
