# Announce: Rakudo Perl 6 compiler, Development Release #91 (“Zürich”)

On behalf of the Rakudo development team, I’m happy to announce the September
2015 release of Rakudo Perl 6 #91 “Zürich”. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1] and the Java Virtual Machine. The
tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, with each
release named after a Perl Mongers group. This month’s release is named after
Zürich Perl Mongers, hosts of the recent Swiss Perl Workshop.

Some of the changes in this release are outlined below:

* Great List Refactor - See http://design.perl6.org/S07.html
* All Deprecations removed in preparation for Christmas release
* Added support for calling into C++ libraries and calling methods on C++ classes
* New slurpy parameter, +args or +@args, to allow for one-argument style binding
* New with/orwith/without conditionals allow you to check for .defined but topicalize to the actual value returned
* New `supply`, `whenever` and `react` blocks for easy reactive programming
* All Unicode digits can now be part of literal numbers
* `val()` and allomorphic types implemented
* Most European quoting styles are now supported
* New $[...] and ${...} constructs allow prefix itemization
* The .gist and .perl methods can now deal with self-referential structures

These are only some of the changes in this release. For a more
detailed list, see "docs/ChangeLog".

Apologies, there are a few failures in the JVM test suite this month, as
we’ve been focusing on our primary backend, MoarVM. Please bear with us.

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
the design docs, the Perl 6 test suite, MoarVM and the specification.

The following people contributed to this release:

Jonathan Worthington, Stefan Seifert, Elizabeth Mattijsen, Tobias Leich, Moritz Lenz, Pawel Murias, Larry Wall, Faye Niemeyer, Rob Hoelz, skids, Jimmy Zhuo, Timo Paulssen, Will "Coke" Coleda, Solomon Foster, Paul Cochrane, Pepe Schwarz, David Warring, Jonathan Scott Duff, Christian Bartolomäus, Nick Logan, niner, laben, Brent Laabs, Carl Masak, Kamil Kułaga, Francois Perrad, Bart Wiegmans, Ben Tyler, Geoffrey Broadwell, Leon Timmermans, Will Coleda, Justin DeVuyst, Steve Mynott, alexghacker, vendethiel, Tim Smith, Jonathan Stowe, David Warring, Carl Mäsak, sergot, Stéphane Payrard, Daniel Dehennin, Mike Francis, Sue Spence, Zoffix Znet

If you would like to contribute, see <http://rakudo.org/how-to-help>,
ask on the <perl6-compiler@perl.org> mailing list, or ask on IRC #perl6
on freenode.

The next release of Rakudo (#92), is scheduled for 22 October 2015.
A list of the other planned release dates and code names for future
releases is available in the "docs/release_guide.pod" file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.  Rakudo Star
is meant for early adopters who wish to explore what’s possible with
Rakudo Perl 6 and provide feedback on what works, what doesn’t, and
what else they would like to see included in the distribution.
