% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperbolic.R
\name{step_hyperbolic}
\alias{step_hyperbolic}
\title{Hyperbolic Transformations}
\usage{
step_hyperbolic(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  func = c("sinh", "cosh", "tanh"),
  inverse = TRUE,
  columns = NULL,
  skip = FALSE,
  id = rand_id("hyperbolic")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{func}{A character value for the function. Valid values
are "sinh", "cosh", or "tanh".}

\item{inverse}{A logical: should the inverse function be used?}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_hyperbolic} creates a \emph{specification} of a
recipe step that will transform data using a hyperbolic
function.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns
\code{terms} (the columns that will be affected), \code{inverse}, and \code{func} is
returned.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
set.seed(313)
examples <- matrix(rnorm(40), ncol = 2)
examples <- as.data.frame(examples)

rec <- recipe(~ V1 + V2, data = examples)

cos_trans <- rec \%>\%
  step_hyperbolic(
    all_numeric_predictors(),
    func = "cosh", inverse = FALSE
  )

cos_obj <- prep(cos_trans, training = examples)

transformed_te <- bake(cos_obj, examples)
plot(examples$V1, transformed_te$V1)

tidy(cos_trans, number = 1)
tidy(cos_obj, number = 1)
}
\seealso{
Other individual transformation steps: 
\code{\link{step_BoxCox}()},
\code{\link{step_YeoJohnson}()},
\code{\link{step_bs}()},
\code{\link{step_harmonic}()},
\code{\link{step_inverse}()},
\code{\link{step_invlogit}()},
\code{\link{step_logit}()},
\code{\link{step_log}()},
\code{\link{step_mutate}()},
\code{\link{step_ns}()},
\code{\link{step_percentile}()},
\code{\link{step_poly}()},
\code{\link{step_relu}()},
\code{\link{step_sqrt}()}
}
\concept{individual transformation steps}
