% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/props.R
\name{get.properties}
\alias{get.properties}
\title{Get all properties associated with a molecule.}
\usage{
get.properties(molecule)
}
\arguments{
\item{molecule}{The molecule to query. Should be a `jobjRef` representing an `IAtomContainer`}
}
\value{
A named `list` with the property values. Element names are the keys 
for each property. If no properties have been defined, an empty list.
}
\description{
In this context a property is a value associated with a key and stored
with the molecule. This method returns a list of all the properties of 
a molecule. The names of the list are set to the property names.
}
\examples{
mol <- parse.smiles("CC1CC(C=O)CCC1")[[1]]
set.property(mol, 'prop1', 23.45)
set.property(mol, 'prop2', 'inactive')
get.properties(mol)
}
\seealso{
\code{\link{set.property}}, \code{\link{get.property}}, \code{\link{remove.property}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
