# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class BrandVettingList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, brand_sid):
        """
        Initialize the BrandVettingList

        :param Version version: Version that contains the resource
        :param brand_sid: A2P BrandRegistration Sid

        :returns: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingList
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingList
        """
        super(BrandVettingList, self).__init__(version)

        # Path Solution
        self._solution = {'brand_sid': brand_sid, }
        self._uri = '/a2p/BrandRegistrations/{brand_sid}/Vettings'.format(**self._solution)

    def create(self, vetting_provider, vetting_id=values.unset):
        """
        Create the BrandVettingInstance

        :param BrandVettingInstance.VettingProvider vetting_provider: Third-party provider of the vettings to create
        :param unicode vetting_id: The unique ID of the vetting

        :returns: The created BrandVettingInstance
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingInstance
        """
        data = values.of({'VettingProvider': vetting_provider, 'VettingId': vetting_id, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return BrandVettingInstance(self._version, payload, brand_sid=self._solution['brand_sid'], )

    def stream(self, vetting_provider=values.unset, limit=None, page_size=None):
        """
        Streams BrandVettingInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param BrandVettingInstance.VettingProvider vetting_provider: Third-party provider of the vettings to create
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(vetting_provider=vetting_provider, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, vetting_provider=values.unset, limit=None, page_size=None):
        """
        Lists BrandVettingInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param BrandVettingInstance.VettingProvider vetting_provider: Third-party provider of the vettings to create
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingInstance]
        """
        return list(self.stream(vetting_provider=vetting_provider, limit=limit, page_size=page_size, ))

    def page(self, vetting_provider=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of BrandVettingInstance records from the API.
        Request is executed immediately

        :param BrandVettingInstance.VettingProvider vetting_provider: Third-party provider of the vettings to create
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of BrandVettingInstance
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingPage
        """
        data = values.of({
            'VettingProvider': vetting_provider,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return BrandVettingPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of BrandVettingInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of BrandVettingInstance
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return BrandVettingPage(self._version, response, self._solution)

    def get(self, brand_vetting_sid):
        """
        Constructs a BrandVettingContext

        :param brand_vetting_sid: SID for third-party vetting record

        :returns: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingContext
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingContext
        """
        return BrandVettingContext(
            self._version,
            brand_sid=self._solution['brand_sid'],
            brand_vetting_sid=brand_vetting_sid,
        )

    def __call__(self, brand_vetting_sid):
        """
        Constructs a BrandVettingContext

        :param brand_vetting_sid: SID for third-party vetting record

        :returns: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingContext
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingContext
        """
        return BrandVettingContext(
            self._version,
            brand_sid=self._solution['brand_sid'],
            brand_vetting_sid=brand_vetting_sid,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.BrandVettingList>'


class BrandVettingPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the BrandVettingPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param brand_sid: A2P BrandRegistration Sid

        :returns: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingPage
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingPage
        """
        super(BrandVettingPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of BrandVettingInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingInstance
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingInstance
        """
        return BrandVettingInstance(self._version, payload, brand_sid=self._solution['brand_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.BrandVettingPage>'


class BrandVettingContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, brand_sid, brand_vetting_sid):
        """
        Initialize the BrandVettingContext

        :param Version version: Version that contains the resource
        :param brand_sid: A2P BrandRegistration Sid
        :param brand_vetting_sid: SID for third-party vetting record

        :returns: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingContext
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingContext
        """
        super(BrandVettingContext, self).__init__(version)

        # Path Solution
        self._solution = {'brand_sid': brand_sid, 'brand_vetting_sid': brand_vetting_sid, }
        self._uri = '/a2p/BrandRegistrations/{brand_sid}/Vettings/{brand_vetting_sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the BrandVettingInstance

        :returns: The fetched BrandVettingInstance
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return BrandVettingInstance(
            self._version,
            payload,
            brand_sid=self._solution['brand_sid'],
            brand_vetting_sid=self._solution['brand_vetting_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Messaging.V1.BrandVettingContext {}>'.format(context)


class BrandVettingInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class VettingProvider(object):
        CAMPAIGN_VERIFY = "campaign-verify"

    def __init__(self, version, payload, brand_sid, brand_vetting_sid=None):
        """
        Initialize the BrandVettingInstance

        :returns: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingInstance
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingInstance
        """
        super(BrandVettingInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'brand_sid': payload.get('brand_sid'),
            'brand_vetting_sid': payload.get('brand_vetting_sid'),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'vetting_id': payload.get('vetting_id'),
            'vetting_class': payload.get('vetting_class'),
            'vetting_status': payload.get('vetting_status'),
            'vetting_provider': payload.get('vetting_provider'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {
            'brand_sid': brand_sid,
            'brand_vetting_sid': brand_vetting_sid or self._properties['brand_vetting_sid'],
        }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: BrandVettingContext for this BrandVettingInstance
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingContext
        """
        if self._context is None:
            self._context = BrandVettingContext(
                self._version,
                brand_sid=self._solution['brand_sid'],
                brand_vetting_sid=self._solution['brand_vetting_sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the vetting
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def brand_sid(self):
        """
        :returns: A2P BrandRegistration Sid
        :rtype: unicode
        """
        return self._properties['brand_sid']

    @property
    def brand_vetting_sid(self):
        """
        :returns: SID for third-party vetting record
        :rtype: unicode
        """
        return self._properties['brand_vetting_sid']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def vetting_id(self):
        """
        :returns: The unique ID of the vetting
        :rtype: unicode
        """
        return self._properties['vetting_id']

    @property
    def vetting_class(self):
        """
        :returns: The type of vetting
        :rtype: unicode
        """
        return self._properties['vetting_class']

    @property
    def vetting_status(self):
        """
        :returns: Status of vetting attempt
        :rtype: unicode
        """
        return self._properties['vetting_status']

    @property
    def vetting_provider(self):
        """
        :returns: Third-party provider that has conducted the vetting
        :rtype: BrandVettingInstance.VettingProvider
        """
        return self._properties['vetting_provider']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Brand Vetting
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the BrandVettingInstance

        :returns: The fetched BrandVettingInstance
        :rtype: twilio.rest.messaging.v1.brand_registration.brand_vetting.BrandVettingInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Messaging.V1.BrandVettingInstance {}>'.format(context)
