# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservicefleet import ContainerServiceFleetMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceFleetMgmtAutoUpgradeProfilesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceFleetMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_auto_upgrade_profiles_list_by_fleet(self, resource_group):
        response = self.client.auto_upgrade_profiles.list_by_fleet(
            resource_group_name=resource_group.name,
            fleet_name="str",
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_auto_upgrade_profiles_get(self, resource_group):
        response = self.client.auto_upgrade_profiles.get(
            resource_group_name=resource_group.name,
            fleet_name="str",
            auto_upgrade_profile_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_auto_upgrade_profiles_begin_create_or_update(self, resource_group):
        response = self.client.auto_upgrade_profiles.begin_create_or_update(
            resource_group_name=resource_group.name,
            fleet_name="str",
            auto_upgrade_profile_name="str",
            resource={
                "autoUpgradeProfileStatus": {
                    "lastTriggerError": {
                        "additionalInfo": [{"info": {}, "type": "str"}],
                        "code": "str",
                        "details": [...],
                        "message": "str",
                        "target": "str",
                    },
                    "lastTriggerStatus": "str",
                    "lastTriggerUpgradeVersions": ["str"],
                    "lastTriggeredAt": "2020-02-20 00:00:00",
                },
                "channel": "str",
                "disabled": bool,
                "eTag": "str",
                "id": "str",
                "name": "str",
                "nodeImageSelection": {"type": "str"},
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "updateStrategyId": "str",
            },
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_auto_upgrade_profiles_begin_delete(self, resource_group):
        response = self.client.auto_upgrade_profiles.begin_delete(
            resource_group_name=resource_group.name,
            fleet_name="str",
            auto_upgrade_profile_name="str",
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
