// This tests that cpSync resolves relative symlinks to their absolute path by default.
import { mustNotMutateObjectDeep, isWindows } from '../common/index.mjs';
import { nextdir } from '../common/fs.js';
import assert from 'node:assert';
import { cpSync, mkdirSync, writeFileSync, symlinkSync, readlinkSync } from 'node:fs';
import { join } from 'node:path';

import tmpdir from '../common/tmpdir.js';
tmpdir.refresh();

const src = nextdir();
mkdirSync(src, mustNotMutateObjectDeep({ recursive: true }));
writeFileSync(join(src, 'foo.js'), 'foo', 'utf8');
symlinkSync('foo.js', join(src, 'bar.js'));

const dest = nextdir();
mkdirSync(dest, mustNotMutateObjectDeep({ recursive: true }));

cpSync(src, dest, mustNotMutateObjectDeep({ recursive: true }));
const link = readlinkSync(join(dest, 'bar.js'));

if (isWindows) {
  // On Windows, readlinkSync() may return a path with uppercase drive letter,
  // but paths are case-insensitive.
  assert.strictEqual(link.toLowerCase(), join(src, 'foo.js').toLowerCase());
} else {
  assert.strictEqual(link, join(src, 'foo.js'));
}
