/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "PlotModInteractive.h"

#include "MvApplication.h"
#include "PlotModConst.h"
#include "uPlotBase.h"

#include <QMessageBox>

PlotModInteractive::PlotModInteractive()
{
    isInteractive_   = true;
    isWindow_        = true;
    plotDestination_ = MVSCREEN;
    printerName_     = "";
    plotApplication_ = 0;
}

void PlotModInteractive::UserMessage(const string& message)
{
    QString str = message.c_str();

    QMessageBox msgBox;
    msgBox.setText(str);
    msgBox.setStandardButtons(QMessageBox::Ok);
    msgBox.exec();
}

void PlotModInteractive::progressMessage(const string& message)
{
    if (plotApplication_)
        plotApplication_->progressMessage(message);
}


// Print a message to the log window or the output; if 'priority', then
// it will be visible without '-slog'
void PlotModInteractive::printMessage(const string& msg, bool priority)
{
    char c_msg[1024];
    strncpy(c_msg, msg.c_str(), 1023);

    if (priority) {
        svc* service = MvApplication::instance().getService();

        // copy the message into a C string and send it to the service

        if (service != NULL) {
            set_svc_msg(service->id, c_msg);
        }
    }

    marslog(LOG_INFO | LOG_PERR, c_msg);
}


void PlotModInteractive::SystemError(const string& message, const string& title)
{
    // Call the MetviewError method to get output to the user
    string fullMessage = title + ": " + message;
    MetviewError(fullMessage, "ERROR");

#if 0
      string titleText ( "PlotMod System Error" );
      if ( title.length() )
	titleText = titleText + ": " + title;
      InfoDialogManager::Instance().post( titleText.c_str(), message.c_str());
  
  MvRequest reqst("USER_MESSAGE");
  reqst("INFO") = message.c_str(); 
  send_message(PlotModApp::Instance().getService(),(request*)reqst);
#endif
}


#if 0
void
PlotMod::InternalError ( const string & message, const string & title )
{
     string titleText ( "PlotMod Internal Error" );
      if ( title.length() )
	titleText = titleText + ": " + title;
      InfoDialogManager::Instance().post( titleText.c_str(), message.c_str());

  MvRequest reqst("USER_MESSAGE");
  reqst("INFO") = message.c_str(); 

  send_message(PlotModApp::Instance().getService(),(request*)reqst);
}

#endif
