{
  'target_defaults': {
    'defines': [
      'ABSL_ALLOCATOR_NOTHROW=1'
    ],
    'direct_dependent_settings': {
      'include_dirs': [
        'abseil-cpp'
      ]
    },
    'include_dirs': [
      'abseil-cpp',
    ],
    'conditions': [
      [ 'OS != "win"', {
        'cflags': [
          '-std=c++11',
          '-Wall',
          '-Wextra',
          '-Wno-unused-parameter',
          '-Wno-implicit-fallthrough',
          '-Wno-sign-compare'
        ]
      }],
      ['OS in "mac ios"', {
        'xcode_settings': {
          'WARNING_CFLAGS': [
            '-Wbool-conversion',
            '-Wconstant-conversion',
            '-Wenum-conversion',
            '-Wint-conversion',
            '-Wliteral-conversion',
            '-Wnon-literal-null-conversion',
            '-Wnull-conversion',
            '-Wobjc-literal-conversion',
            '-Wno-sign-conversion',
            '-Wno-sign-compare',
            '-Wstring-conversion'
          ],
          'OTHER_CPLUSPLUSFLAGS': [
            '-std=c++11',
          ],
        }
      }],
      ['OS == "win"', {
        'cflags': [
          '/wd4005', # macro-redefinition
          '/wd4018', # sign-compare
          '/wd4068', # unknown pragma
          '/wd4702'  # unreachable code
        ],
        'defines': [
          'NOMINMAX', # Don't define min and max macros (windows.h)
          # Don't bloat namespace with incompatible winsock versions.
          'WIN32_LEAN_AND_MEAN',
          # Don't warn about usage of insecure C functions.
          '_CRT_SECURE_NO_WARNINGS',
          '_SCL_SECURE_NO_WARNINGS',
          # Introduced in VS 2017 15.8, allow overaligned types in aligned_storage.
          '_ENABLE_EXTENDED_ALIGNED_STORAGE'
        ]
      }]
    ],
  },
  'targets': [
    {
      'target_name': 'abseil',
      'type': 'static_library',
      'sources': [
        'abseil-cpp/absl/strings/charconv.h',
        'abseil-cpp/absl/strings/numbers.h',
        'abseil-cpp/absl/strings/match.cc',
        'abseil-cpp/absl/strings/str_format.h',
        'abseil-cpp/absl/strings/str_split.h',
        'abseil-cpp/absl/strings/internal/stl_type_traits.h',
        'abseil-cpp/absl/strings/internal/charconv_bigint.cc',
        'abseil-cpp/absl/strings/internal/char_map.h',
        'abseil-cpp/absl/strings/internal/pow10_helper.h',
        'abseil-cpp/absl/strings/internal/charconv_parse.cc',
        'abseil-cpp/absl/strings/internal/memutil.h',
        'abseil-cpp/absl/strings/internal/str_format/float_conversion.h',
        'abseil-cpp/absl/strings/internal/str_format/arg.cc',
        'abseil-cpp/absl/strings/internal/str_format/float_conversion.cc',
        'abseil-cpp/absl/strings/internal/str_format/output.cc',
        'abseil-cpp/absl/strings/internal/str_format/parser.h',
        'abseil-cpp/absl/strings/internal/str_format/arg.h',
        'abseil-cpp/absl/strings/internal/str_format/bind.cc',
        'abseil-cpp/absl/strings/internal/str_format/parser.cc',
        'abseil-cpp/absl/strings/internal/str_format/extension.cc',
        'abseil-cpp/absl/strings/internal/str_format/output.h',
        'abseil-cpp/absl/strings/internal/str_format/checker.h',
        'abseil-cpp/absl/strings/internal/str_format/extension.h',
        'abseil-cpp/absl/strings/internal/str_format/bind.h',
        'abseil-cpp/absl/strings/internal/str_join_internal.h',
        'abseil-cpp/absl/strings/internal/charconv_bigint.h',
        'abseil-cpp/absl/strings/internal/memutil.cc',
        'abseil-cpp/absl/strings/internal/ostringstream.cc',
        'abseil-cpp/absl/strings/internal/pow10_helper.cc',
        'abseil-cpp/absl/strings/internal/utf8.cc',
        'abseil-cpp/absl/strings/internal/resize_uninitialized.h',
        'abseil-cpp/absl/strings/internal/ostringstream.h',
        'abseil-cpp/absl/strings/internal/charconv_parse.h',
        'abseil-cpp/absl/strings/internal/utf8.h',
        'abseil-cpp/absl/strings/internal/str_split_internal.h',
        'abseil-cpp/absl/strings/str_replace.h',
        'abseil-cpp/absl/strings/string_view.cc',
        'abseil-cpp/absl/strings/str_join.h',
        'abseil-cpp/absl/strings/str_cat.cc',
        'abseil-cpp/absl/strings/ascii.h',
        'abseil-cpp/absl/strings/escaping.h',
        'abseil-cpp/absl/strings/match.h',
        'abseil-cpp/absl/strings/ascii.cc',
        'abseil-cpp/absl/strings/numbers.cc',
        'abseil-cpp/absl/strings/charconv.cc',
        'abseil-cpp/absl/strings/strip.h',
        'abseil-cpp/absl/strings/str_split.cc',
        'abseil-cpp/absl/strings/substitute.cc',
        'abseil-cpp/absl/strings/substitute.h',
        'abseil-cpp/absl/strings/escaping.cc',
        'abseil-cpp/absl/strings/string_view.h',
        'abseil-cpp/absl/strings/str_replace.cc',
        'abseil-cpp/absl/strings/str_cat.h',
        'abseil-cpp/absl/types/bad_variant_access.h',
        'abseil-cpp/absl/types/bad_any_cast.h',
        'abseil-cpp/absl/types/bad_any_cast.cc',
        'abseil-cpp/absl/types/internal/variant.h',
        'abseil-cpp/absl/types/optional.h',
        'abseil-cpp/absl/types/bad_optional_access.h',
        'abseil-cpp/absl/types/bad_optional_access.cc',
        'abseil-cpp/absl/types/span.h',
        'abseil-cpp/absl/types/bad_variant_access.cc',
        'abseil-cpp/absl/types/any.h',
        'abseil-cpp/absl/types/optional.cc',
        'abseil-cpp/absl/types/variant.h',
        'abseil-cpp/absl/memory/memory.h',
        'abseil-cpp/absl/synchronization/blocking_counter.h',
        'abseil-cpp/absl/synchronization/blocking_counter.cc',
        'abseil-cpp/absl/synchronization/notification.h',
        'abseil-cpp/absl/synchronization/mutex.cc',
        'abseil-cpp/absl/synchronization/barrier.h',
        'abseil-cpp/absl/synchronization/internal/per_thread_sem.cc',
        'abseil-cpp/absl/synchronization/internal/per_thread_sem.h',
        'abseil-cpp/absl/synchronization/internal/graphcycles.h',
        'abseil-cpp/absl/synchronization/internal/waiter.h',
        'abseil-cpp/absl/synchronization/internal/thread_pool.h',
        'abseil-cpp/absl/synchronization/internal/create_thread_identity.cc',
        'abseil-cpp/absl/synchronization/internal/waiter.cc',
        'abseil-cpp/absl/synchronization/internal/create_thread_identity.h',
        'abseil-cpp/absl/synchronization/internal/kernel_timeout.h',
        'abseil-cpp/absl/synchronization/internal/graphcycles.cc',
        'abseil-cpp/absl/synchronization/barrier.cc',
        'abseil-cpp/absl/synchronization/notification.cc',
        'abseil-cpp/absl/synchronization/mutex.h',
        'abseil-cpp/absl/hash/internal/hash.cc',
        'abseil-cpp/absl/hash/internal/spy_hash_state.h',
        'abseil-cpp/absl/hash/internal/city.h',
        'abseil-cpp/absl/hash/internal/city.cc',
        'abseil-cpp/absl/hash/internal/hash.h',
        'abseil-cpp/absl/hash/hash.h',
        'abseil-cpp/absl/debugging/symbolize.cc',
        'abseil-cpp/absl/debugging/failure_signal_handler.h',
        'abseil-cpp/absl/debugging/failure_signal_handler.cc',
        'abseil-cpp/absl/debugging/stacktrace.h',
        'abseil-cpp/absl/debugging/symbolize.h',
        'abseil-cpp/absl/debugging/leak_check_disable.cc',
        'abseil-cpp/absl/debugging/leak_check.h',
        'abseil-cpp/absl/debugging/internal/stacktrace_config.h',
        'abseil-cpp/absl/debugging/internal/examine_stack.h',
        'abseil-cpp/absl/debugging/internal/examine_stack.cc',
        'abseil-cpp/absl/debugging/internal/vdso_support.cc',
        'abseil-cpp/absl/debugging/internal/stack_consumption.cc',
        'abseil-cpp/absl/debugging/internal/demangle.h',
        'abseil-cpp/absl/debugging/internal/symbolize.h',
        'abseil-cpp/absl/debugging/internal/address_is_readable.h',
        'abseil-cpp/absl/debugging/internal/stack_consumption.h',
        'abseil-cpp/absl/debugging/internal/address_is_readable.cc',
        'abseil-cpp/absl/debugging/internal/elf_mem_image.h',
        'abseil-cpp/absl/debugging/internal/elf_mem_image.cc',
        'abseil-cpp/absl/debugging/internal/demangle.cc',
        'abseil-cpp/absl/debugging/internal/vdso_support.h',
        'abseil-cpp/absl/debugging/leak_check.cc',
        'abseil-cpp/absl/debugging/stacktrace.cc',
        'abseil-cpp/absl/meta/type_traits.h',
        'abseil-cpp/absl/algorithm/algorithm.h',
        'abseil-cpp/absl/algorithm/container.h',
        'abseil-cpp/absl/time/time.h',
        'abseil-cpp/absl/time/internal/cctz/include/cctz/civil_time.h',
        'abseil-cpp/absl/time/internal/cctz/include/cctz/time_zone.h',
        'abseil-cpp/absl/time/internal/cctz/include/cctz/zone_info_source.h',
        'abseil-cpp/absl/time/internal/cctz/include/cctz/civil_time_detail.h',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_format.cc',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_fixed.h',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_if.h',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_impl.cc',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_lookup.cc',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_info.cc',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_if.cc',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_fixed.cc',
        'abseil-cpp/absl/time/internal/cctz/src/zone_info_source.cc',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_libc.cc',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_posix.h',
        'abseil-cpp/absl/time/internal/cctz/src/tzfile.h',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_libc.h',
        'abseil-cpp/absl/time/internal/cctz/src/civil_time_detail.cc',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_info.h',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_impl.h',
        'abseil-cpp/absl/time/internal/cctz/src/time_zone_posix.cc',
        'abseil-cpp/absl/time/civil_time.h',
        'abseil-cpp/absl/time/clock.cc',
        'abseil-cpp/absl/time/duration.cc',
        'abseil-cpp/absl/time/civil_time.cc',
        'abseil-cpp/absl/time/format.cc',
        'abseil-cpp/absl/time/time.cc',
        'abseil-cpp/absl/time/clock.h',
        'abseil-cpp/absl/container/node_hash_map.h',
        'abseil-cpp/absl/container/flat_hash_map.h',
        'abseil-cpp/absl/container/fixed_array.h',
        'abseil-cpp/absl/container/internal/compressed_tuple.h',
        'abseil-cpp/absl/container/internal/container_memory.h',
        'abseil-cpp/absl/container/internal/node_hash_policy.h',
        'abseil-cpp/absl/container/internal/raw_hash_set.h',
        'abseil-cpp/absl/container/internal/hash_function_defaults.h',
        'abseil-cpp/absl/container/internal/hashtablez_sampler.h',
        'abseil-cpp/absl/container/internal/hashtablez_force_sampling.cc',
        'abseil-cpp/absl/container/internal/raw_hash_set.cc',
        'abseil-cpp/absl/container/internal/hashtable_debug.h',
        'abseil-cpp/absl/container/internal/raw_hash_map.h',
        'abseil-cpp/absl/container/internal/have_sse.h',
        'abseil-cpp/absl/container/internal/layout.h',
        'abseil-cpp/absl/container/internal/hashtable_debug_hooks.h',
        'abseil-cpp/absl/container/internal/hashtablez_sampler_force_weak_definition.cc',
        'abseil-cpp/absl/container/internal/hash_policy_traits.h',
        'abseil-cpp/absl/container/internal/common.h',
        'abseil-cpp/absl/container/internal/tracked.h',
        'abseil-cpp/absl/container/internal/hashtablez_sampler.cc',
        'abseil-cpp/absl/container/internal/counting_allocator.h',
        'abseil-cpp/absl/container/inlined_vector.h',
        'abseil-cpp/absl/container/flat_hash_set.h',
        'abseil-cpp/absl/container/node_hash_set.h',
        'abseil-cpp/absl/numeric/int128.cc',
        'abseil-cpp/absl/numeric/int128.h',
        'abseil-cpp/absl/base/policy_checks.h',
        'abseil-cpp/absl/base/port.h',
        'abseil-cpp/absl/base/config.h',
        'abseil-cpp/absl/base/casts.h',
        'abseil-cpp/absl/base/internal/spinlock.h',
        'abseil-cpp/absl/base/internal/spinlock_wait.cc',
        'abseil-cpp/absl/base/internal/cycleclock.cc',
        'abseil-cpp/absl/base/internal/scheduling_mode.h',
        'abseil-cpp/absl/base/internal/per_thread_tls.h',
        'abseil-cpp/absl/base/internal/spinlock.cc',
        'abseil-cpp/absl/base/internal/unscaledcycleclock.cc',
        'abseil-cpp/absl/base/internal/endian.h',
        'abseil-cpp/absl/base/internal/sysinfo.h',
        'abseil-cpp/absl/base/internal/tsan_mutex_interface.h',
        'abseil-cpp/absl/base/internal/thread_identity.h',
        'abseil-cpp/absl/base/internal/unaligned_access.h',
        'abseil-cpp/absl/base/internal/sysinfo.cc',
        'abseil-cpp/absl/base/internal/raw_logging.cc',
        'abseil-cpp/absl/base/internal/direct_mmap.h',
        'abseil-cpp/absl/base/internal/unscaledcycleclock.h',
        'abseil-cpp/absl/base/internal/throw_delegate.cc',
        'abseil-cpp/absl/base/internal/invoke.h',
        'abseil-cpp/absl/base/internal/pretty_function.h',
        'abseil-cpp/absl/base/internal/inline_variable.h',
        'abseil-cpp/absl/base/internal/cycleclock.h',
        'abseil-cpp/absl/base/internal/low_level_alloc.h',
        'abseil-cpp/absl/base/internal/atomic_hook.h',
        'abseil-cpp/absl/base/internal/identity.h',
        'abseil-cpp/absl/base/internal/low_level_scheduling.h',
        'abseil-cpp/absl/base/internal/raw_logging.h',
        'abseil-cpp/absl/base/internal/thread_identity.cc',
        'abseil-cpp/absl/base/internal/throw_delegate.h',
        'abseil-cpp/absl/base/internal/low_level_alloc.cc',
        'abseil-cpp/absl/base/internal/hide_ptr.h',
        'abseil-cpp/absl/base/internal/spinlock_wait.h',
        'abseil-cpp/absl/base/internal/bits.h',
        'abseil-cpp/absl/base/attributes.h',
        'abseil-cpp/absl/base/const_init.h',
        'abseil-cpp/absl/base/macros.h',
        'abseil-cpp/absl/base/thread_annotations.h',
        'abseil-cpp/absl/base/dynamic_annotations.cc',
        'abseil-cpp/absl/base/optimization.h',
        'abseil-cpp/absl/base/log_severity.h',
        'abseil-cpp/absl/base/call_once.h',
        'abseil-cpp/absl/base/dynamic_annotations.h',
        'abseil-cpp/absl/utility/utility.h'
      ]
    }
  ] # targets
}
