/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <config_wasm_strip.h>

#include <osl/diagnose.h>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/uno/XComponentContext.hpp>
#include <comphelper/base64.hxx>
#include <comphelper/processfactory.hxx>
#include <comphelper/servicehelper.hxx>
#include <utility>
#include <xmloff/namespacemap.hxx>
#include <xmloff/xmlnamespace.hxx>
#include <xmloff/xmltoken.hxx>
#include "MutableAttrList.hxx"
#include "DeepTContext.hxx"
#include "StyleOOoTContext.hxx"
#include "FrameOOoTContext.hxx"
#include "EventOOoTContext.hxx"
#include "ControlOOoTContext.hxx"
#include "FormPropOOoTContext.hxx"
#include "ChartOOoTContext.hxx"
#include "ChartPlotAreaOOoTContext.hxx"
#include "ElemTransformerAction.hxx"
#include "AttrTransformerAction.hxx"
#include "PropertyActionsOOo.hxx"
#include "TransformerActions.hxx"
#include "OOo2Oasis.hxx"
#include <cppuhelper/supportsservice.hxx>
#include <cppuhelper/typeprovider.hxx>
#include <comphelper/diagnose_ex.hxx>

using namespace ::xmloff::token;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::beans;

namespace {

enum XMLUserDefinedTransformerAction
{
    XML_ETACTION_DOCUMENT=XML_ETACTION_USER_DEFINED,
    XML_ETACTION_BODY,
    XML_ETACTION_STYLE,
    XML_ETACTION_STYLE_RENAME,
    XML_ETACTION_FRAME,
    XML_ETACTION_EVENT,
    XML_ETACTION_TAB_STOP,
    XML_ETACTION_FORM_CONTROL,
    XML_ETACTION_FORM_PROPERTY,
    XML_ETACTION_CHART,
    XML_ETACTION_TRACKED_CHANGES,
    XML_ETACTION_CHART_PLOT_AREA,
    XML_ETACTION_DOCUMENT_RENAME,
    XML_ETACTION_TABLE
};

}

#define ENTRY3( n, l, a, p1, p2, p3 ) \
    { n, l, a, p1, p2, p3 }
#define ENTRY3QQN( n, l, a, n1, l1, n2, l2, p3 ) \
    ENTRY3( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ), \
            XMLTransformerActionInit::QNameParam( n2, l2 ), p3 )

#define ENTRY2( n, l, a, p1, p2 ) \
    ENTRY3( n, l, a, p1, p2, 0 )
#define ENTRY2QN( n, l, a, n1, l1, p2 ) \
    ENTRY2( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ), p2 )

#define ENTRY1( n, l, a, p1 ) \
    ENTRY3( n, l, a, p1, 0, 0 )
#define ENTRY1Q( n, l, a, n1, l1 ) \
    ENTRY1( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ) )

#define ENTRY0( n, l, a ) \
    ENTRY3( n, l, a, 0, 0, 0 )

// BM: a macro to put two tokens into one sal_Int32 for the action
// XML_ATACTION_RENAME_ATTRIBUTE
static constexpr sal_Int32 RENAME_ENTRY( XMLTokenEnum f, XMLTokenEnum s )
{
    return static_cast< sal_Int32 >(f) | (static_cast< sal_Int32 >(s) << 16);
}

XMLTransformerActionInit const aActionTable[] =
{
    // remove office:class from <office:document> and <office:document-content>
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_DOCUMENT, XML_ETACTION_DOCUMENT ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_DOCUMENT_CONTENT, XML_ETACTION_DOCUMENT ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_DOCUMENT_STYLES, XML_ETACTION_DOCUMENT ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_DOCUMENT_SETTINGS, XML_ETACTION_DOCUMENT ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_AUTO_TEXT_EVENTS, XML_ETACTION_DOCUMENT_RENAME, XML_NAMESPACE_OOO, XML_AUTO_TEXT_EVENTS),

    // remove <meta:keywords>
    ENTRY0( XML_NAMESPACE_META, XML_KEYWORDS, XML_ETACTION_COPY_CONTENT ),

    // rename <office:script> to <office:scripts>
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_SCRIPT, XML_ETACTION_RENAME_ELEM, XML_NAMESPACE_OFFICE, XML_SCRIPTS ),

    // rename <office:script-data> to <office:script> and process attributes
    ENTRY2QN( XML_NAMESPACE_OFFICE, XML_SCRIPT_DATA, XML_ETACTION_RENAME_ELEM_PROC_ATTRS, XML_NAMESPACE_OFFICE, XML_SCRIPT, OOO_SCRIPT_ACTIONS ),

    // rename <script:libraries> to <ooo:libraries>
    ENTRY1Q( XML_NAMESPACE_SCRIPT, XML_LIBRARIES, XML_ETACTION_RENAME_ELEM, XML_NAMESPACE_OOO, XML_LIBRARIES ),

    // rename <script:library-linked> to <ooo:library-linked> and process attributes
    ENTRY2QN( XML_NAMESPACE_SCRIPT, XML_LIBRARY_LINKED, XML_ETACTION_RENAME_ELEM_PROC_ATTRS, XML_NAMESPACE_OOO, XML_LIBRARY_LINKED, OOO_SCRIPT_ACTIONS ),

    // rename <script:library-embedded> to <ooo:library-embedded> and process attributes
    ENTRY2QN( XML_NAMESPACE_SCRIPT, XML_LIBRARY_EMBEDDED, XML_ETACTION_RENAME_ELEM_PROC_ATTRS, XML_NAMESPACE_OOO, XML_LIBRARY_EMBEDDED, OOO_SCRIPT_ACTIONS ),

    // rename <script:module> to <ooo:module> and process attributes
    ENTRY2QN( XML_NAMESPACE_SCRIPT, XML_MODULE, XML_ETACTION_RENAME_ELEM_PROC_ATTRS, XML_NAMESPACE_OOO, XML_MODULE, OOO_SCRIPT_ACTIONS ),

    // rename <script:source-code> to <ooo:source-code>
    ENTRY1Q( XML_NAMESPACE_SCRIPT, XML_SOURCE_CODE, XML_ETACTION_RENAME_ELEM, XML_NAMESPACE_OOO, XML_SOURCE_CODE ),

    // rename <office:font-decls> to <office:font-face-decl>,
    // rename <style:font-decl> to <style:font-face>, process attrs
    ENTRY1Q(  XML_NAMESPACE_OFFICE, XML_FONT_DECLS, XML_ETACTION_RENAME_ELEM,            XML_NAMESPACE_OFFICE, XML_FONT_FACE_DECLS ),
    ENTRY2QN( XML_NAMESPACE_STYLE,  XML_FONT_DECL,  XML_ETACTION_RENAME_ELEM_PROC_ATTRS, XML_NAMESPACE_STYLE,  XML_FONT_FACE, OOO_FONT_DECL_ACTIONS ),

    // add genre element
    ENTRY0( XML_NAMESPACE_OFFICE, XML_BODY, XML_ETACTION_BODY ),

    // rename <style:page-master> to <style:page-layout>
    ENTRY2QN( XML_NAMESPACE_STYLE, XML_PAGE_MASTER, XML_ETACTION_STYLE_RENAME, XML_NAMESPACE_STYLE, XML_PAGE_LAYOUT, XML_FAMILY_TYPE_PAGE_LAYOUT  ),
    ENTRY1(   XML_NAMESPACE_STYLE, XML_MASTER_PAGE, XML_ETACTION_PROC_ATTRS,   OOO_MASTER_PAGE_ACTIONS ),

    // split <style:properties> into <style:*-properties> and do other
    // styles processing
    ENTRY1(   XML_NAMESPACE_STYLE,  XML_STYLE,                   XML_ETACTION_STYLE,        XML_FAMILY_TYPE_END ),
    ENTRY1(   XML_NAMESPACE_STYLE,  XML_DEFAULT_STYLE,           XML_ETACTION_STYLE,        XML_FAMILY_TYPE_END ),
    ENTRY1(   XML_NAMESPACE_NUMBER, XML_NUMBER_STYLE,            XML_ETACTION_STYLE,        XML_FAMILY_TYPE_DATA ),
    ENTRY1(   XML_NAMESPACE_NUMBER, XML_CURRENCY_STYLE,          XML_ETACTION_STYLE,        XML_FAMILY_TYPE_DATA ),
    ENTRY1(   XML_NAMESPACE_NUMBER, XML_PERCENTAGE_STYLE,        XML_ETACTION_STYLE,        XML_FAMILY_TYPE_DATA ),
    ENTRY1(   XML_NAMESPACE_NUMBER, XML_DATE_STYLE,              XML_ETACTION_STYLE,        XML_FAMILY_TYPE_DATA ),
    ENTRY1(   XML_NAMESPACE_NUMBER, XML_TIME_STYLE,              XML_ETACTION_STYLE,        XML_FAMILY_TYPE_DATA ),
    ENTRY1(   XML_NAMESPACE_NUMBER, XML_BOOLEAN_STYLE,           XML_ETACTION_STYLE,        XML_FAMILY_TYPE_DATA ),
    ENTRY1(   XML_NAMESPACE_NUMBER, XML_TEXT_STYLE,              XML_ETACTION_STYLE,        XML_FAMILY_TYPE_DATA ),
    ENTRY1(   XML_NAMESPACE_TEXT,   XML_LIST_STYLE,              XML_ETACTION_STYLE,        XML_FAMILY_TYPE_LIST ),
//  ENTRY0(   XML_NAMESPACE_TEXT,   XML_OUTLINE_STYLE,           STYLE ),
    ENTRY1(   XML_NAMESPACE_STYLE,  XML_HEADER_STYLE,            XML_ETACTION_STYLE,        XML_FAMILY_TYPE_HEADER_FOOTER ),
    ENTRY1(   XML_NAMESPACE_STYLE,  XML_FOOTER_STYLE,            XML_ETACTION_STYLE,        XML_FAMILY_TYPE_HEADER_FOOTER ),
    ENTRY1(   XML_NAMESPACE_TEXT,   XML_LIST_LEVEL_STYLE_NUMBER, XML_ETACTION_STYLE,        XML_FAMILY_TYPE_LIST ),
    ENTRY1(   XML_NAMESPACE_TEXT,   XML_LIST_LEVEL_STYLE_BULLET, XML_ETACTION_STYLE,        XML_FAMILY_TYPE_LIST ),
    ENTRY1(   XML_NAMESPACE_TEXT,   XML_LIST_LEVEL_STYLE_IMAGE,  XML_ETACTION_STYLE,        XML_FAMILY_TYPE_LIST ),
    ENTRY1(   XML_NAMESPACE_TEXT,   XML_OUTLINE_LEVEL_STYLE,     XML_ETACTION_STYLE,        XML_FAMILY_TYPE_LIST ),
    ENTRY1(   XML_NAMESPACE_DRAW,   XML_GRADIENT,                XML_ETACTION_STYLE,        XML_FAMILY_TYPE_GRADIENT ),
    ENTRY1(   XML_NAMESPACE_DRAW,   XML_FILL_IMAGE,              XML_ETACTION_STYLE,        XML_FAMILY_TYPE_FILL_IMAGE ),
    ENTRY2QN( XML_NAMESPACE_DRAW,   XML_TRANSPARENCY,            XML_ETACTION_STYLE_RENAME, XML_NAMESPACE_DRAW, XML_OPACITY, XML_FAMILY_TYPE_GRADIENT ),
    ENTRY1(   XML_NAMESPACE_DRAW,   XML_MARKER,                  XML_ETACTION_STYLE,        XML_FAMILY_TYPE_MARKER ),
    ENTRY1(   XML_NAMESPACE_DRAW,   XML_HATCH,                   XML_ETACTION_STYLE,        XML_FAMILY_TYPE_HATCH ),
    ENTRY1(   XML_NAMESPACE_DRAW,   XML_STROKE_DASH,             XML_ETACTION_STYLE,        XML_FAMILY_TYPE_STROKE_DASH ),

    // rename <text:h>'s text:level to text:outline-level
    // process <text:h/p>: process style-name attributes,
    ENTRY1( XML_NAMESPACE_TEXT, XML_H, XML_ETACTION_PROC_ATTRS, OOO_PARA_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_P, XML_ETACTION_PROC_ATTRS, OOO_PARA_ACTIONS ),

    // rename <text:ordered-list> and <text:unordered-list> to <text:list>
    ENTRY2QN( XML_NAMESPACE_TEXT, XML_UNORDERED_LIST, XML_ETACTION_RENAME_ELEM_PROC_ATTRS, XML_NAMESPACE_TEXT, XML_LIST, OOO_STYLE_REF_ACTIONS ),
    ENTRY2QN( XML_NAMESPACE_TEXT, XML_ORDERED_LIST,   XML_ETACTION_RENAME_ELEM_PROC_ATTRS, XML_NAMESPACE_TEXT, XML_LIST, OOO_STYLE_REF_ACTIONS ),

    // rename <text:footnote*> to <text:note*>
    ENTRY3QQN( XML_NAMESPACE_TEXT, XML_FOOTNOTE,                XML_ETACTION_RENAME_ELEM_ADD_ATTR, XML_NAMESPACE_TEXT, XML_NOTE, XML_NAMESPACE_TEXT, XML_NOTE_CLASS, XML_FOOTNOTE ),
    ENTRY1Q(   XML_NAMESPACE_TEXT, XML_FOOTNOTE_BODY,           XML_ETACTION_RENAME_ELEM, XML_NAMESPACE_TEXT, XML_NOTE_BODY ),
    ENTRY1Q(   XML_NAMESPACE_TEXT, XML_FOOTNOTE_CITATION,       XML_ETACTION_RENAME_ELEM, XML_NAMESPACE_TEXT, XML_NOTE_CITATION ),
    ENTRY3QQN( XML_NAMESPACE_TEXT, XML_FOOTNOTES_CONFIGURATION, XML_ETACTION_RENAME_ELEM_ADD_PROC_ATTR, XML_NAMESPACE_TEXT, XML_NOTES_CONFIGURATION, XML_NAMESPACE_TEXT, XML_NOTE_CLASS, XML_FOOTNOTE | (OOO_STYLE_REF_ACTIONS << 16) ),

    // rename <text:endnote*> to <text:endnote*>
    ENTRY3QQN( XML_NAMESPACE_TEXT, XML_ENDNOTE,                XML_ETACTION_RENAME_ELEM_ADD_ATTR,      XML_NAMESPACE_TEXT, XML_NOTE, XML_NAMESPACE_TEXT, XML_NOTE_CLASS, XML_ENDNOTE ),
    ENTRY1Q(   XML_NAMESPACE_TEXT, XML_ENDNOTE_BODY,           XML_ETACTION_RENAME_ELEM,               XML_NAMESPACE_TEXT, XML_NOTE_BODY ),
    ENTRY1Q(   XML_NAMESPACE_TEXT, XML_ENDNOTE_CITATION,       XML_ETACTION_RENAME_ELEM,               XML_NAMESPACE_TEXT, XML_NOTE_CITATION ),
    ENTRY3QQN( XML_NAMESPACE_TEXT, XML_ENDNOTES_CONFIGURATION, XML_ETACTION_RENAME_ELEM_ADD_PROC_ATTR, XML_NAMESPACE_TEXT, XML_NOTES_CONFIGURATION, XML_NAMESPACE_TEXT, XML_NOTE_CLASS, XML_ENDNOTE | (OOO_STYLE_REF_ACTIONS << 16) ),

    // rename <text:footnote> and <text:endnote> to <text:note>
    ENTRY3QQN( XML_NAMESPACE_TEXT, XML_ENDNOTE_REF,  XML_ETACTION_RENAME_ELEM_ADD_ATTR, XML_NAMESPACE_TEXT, XML_NOTE_REF, XML_NAMESPACE_TEXT, XML_NOTE_CLASS, XML_ENDNOTE ),
    ENTRY3QQN( XML_NAMESPACE_TEXT, XML_FOOTNOTE_REF, XML_ETACTION_RENAME_ELEM_ADD_ATTR, XML_NAMESPACE_TEXT, XML_NOTE_REF, XML_NAMESPACE_TEXT, XML_NOTE_CLASS, XML_FOOTNOTE ),

    // rename <text:tab-stop> to <text:tab>
    ENTRY1Q( XML_NAMESPACE_TEXT, XML_TAB_STOP, XML_ETACTION_RENAME_ELEM, XML_NAMESPACE_TEXT, XML_TAB ),

    // replace <table:sub-table> with <table:table table:is-sub-table>
    ENTRY3QQN( XML_NAMESPACE_TABLE, XML_SUB_TABLE, XML_ETACTION_RENAME_ELEM_ADD_ATTR, XML_NAMESPACE_TABLE, XML_TABLE, XML_NAMESPACE_TABLE, XML_IS_SUB_TABLE, XML_TRUE ),

    // process *:style-name attributes
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_SECTION,                           XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_SPAN,                              XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_A,                                 XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_RUBY,                              XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_RUBY_TEXT,                         XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_DATE,                              XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_TIME,                              XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_VARIABLE_GET,                      XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_USER_FIELD_GET,                    XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_USER_FIELD_INPUT,                  XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_CREATION_DATE,                     XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_CREATION_TIME,                     XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_PRINT_TIME,                        XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_PRINT_DATE,                        XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_EDITING_DURATION,                  XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_MODIFICATION_TIME,                 XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_MODIFICATION_DATE,                 XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_DATABASE_DISPLAY,                  XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_TABLE_FORMULA,                     XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_INDEX_TITLE,                       XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_TABLE_OF_CONTENT,                  XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_TABLE_OF_CONTENT_ENTRY_TEMPLATE,   XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_ILLUSTRATION_INDEX,                XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_ILLUSTRATION_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_TABLE_INDEX,                       XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_TABLE_INDEX_ENTRY_TEMPLATE,        XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_OBJECT_INDEX,                      XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_OBJECT_INDEX_ENTRY_TEMPLATE,       XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_USER_INDEX,                        XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_USER_INDEX_ENTRY_TEMPLATE,         XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_ALPHABETICAL_INDEX,                XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_ALPHABETICAL_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_BIBLIOGRAPHY,                      XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_BIBLIOGRAPHY_ENTRY_TEMPLATE,       XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_INDEX_SOURCE_STYLE,                XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_INDEX_TITLE_TEMPLATE,              XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_INDEX_ENTRY_CHAPTER,               XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY2QN( XML_NAMESPACE_TEXT,         XML_INDEX_ENTRY_CHAPTER_NUMBER,        XML_ETACTION_RENAME_ELEM_PROC_ATTRS, XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_CHAPTER, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_INDEX_ENTRY_TEXT,                  XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_INDEX_ENTRY_PAGE_NUMBER,           XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_INDEX_ENTRY_SPAN,                  XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_INDEX_ENTRY_BIBLIOGRAPHY,          XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_INDEX_ENTRY_LINK_START,            XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_INDEX_ENTRY_LINK_END,              XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_STYLE,        XML_HANDOUT_MASTER,                    XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_DRAW,         XML_PAGE,                              XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_STYLE,        XML_MAP,                               XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_PRESENTATION, XML_NOTES,                             XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_STYLE,        XML_PRESENTATION_PAGE_LAYOUT,          XML_ETACTION_PROC_ATTRS, OOO_MASTER_PAGE_ACTIONS ),
    /* Consider also attribute table:style-name for <table:table>,
       <table:table-row> and <table:table-column>. (#i40011#, #i40015#)
    */
    ENTRY0( XML_NAMESPACE_TABLE, XML_TABLE,        XML_ETACTION_TABLE ),
    ENTRY1( XML_NAMESPACE_TABLE, XML_TABLE_ROW,    XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TABLE, XML_TABLE_COLUMN, XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ),

    // split frame elements
    ENTRY0( XML_NAMESPACE_DRAW, XML_TEXT_BOX,       XML_ETACTION_FRAME ),
    ENTRY0( XML_NAMESPACE_DRAW, XML_IMAGE,          XML_ETACTION_FRAME ),
    ENTRY0( XML_NAMESPACE_DRAW, XML_OBJECT,         XML_ETACTION_FRAME ),
    ENTRY0( XML_NAMESPACE_DRAW, XML_OBJECT_OLE,     XML_ETACTION_FRAME ),
    ENTRY0( XML_NAMESPACE_DRAW, XML_APPLET,         XML_ETACTION_FRAME ),
    ENTRY0( XML_NAMESPACE_DRAW, XML_PLUGIN,         XML_ETACTION_FRAME ),
    ENTRY0( XML_NAMESPACE_DRAW, XML_FLOATING_FRAME, XML_ETACTION_FRAME ),
    ENTRY0( XML_NAMESPACE_SVG,  XML_DESC,           XML_ETACTION_COPY_TEXT ),

    // process events
    ENTRY1Q( XML_NAMESPACE_OFFICE,       XML_EVENTS, XML_ETACTION_RENAME_ELEM,XML_NAMESPACE_OFFICE, XML_EVENT_LISTENERS ),
    ENTRY0(  XML_NAMESPACE_SCRIPT,       XML_EVENT,  XML_ETACTION_EVENT ),
    ENTRY0(  XML_NAMESPACE_PRESENTATION, XML_EVENT,  XML_ETACTION_EVENT ),

    // process length attributes
    ENTRY1( XML_NAMESPACE_DRAW,         XML_RECT,              XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_LINE,              XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_POLYLINE,          XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_POLYGON,           XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_PATH,              XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_CIRCLE,            XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_ELLIPSE,           XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_CONNECTOR,         XML_ETACTION_PROC_ATTRS, OOO_CONNECTOR_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_CAPTION,           XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_CONTROL,           XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_PAGE_THUMBNAIL,    XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_MEASURE,           XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_G,                 XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
//  ENTRY1( XML_NAMESPACE_DRAW,         XML_TEXT_BOX,          XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_PLACEHOLDER,       XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_CONTOUR_POLYGON,   XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_CONTOUR_PATH,      XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_AREA_RECTANGLE,    XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_AREA_CIRCLE,       XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_AREA_POLYGON,      XML_ETACTION_PROC_ATTRS, OOO_DRAW_AREA_POLYGON_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,         XML_GLUE_POINT,        XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DR3D,         XML_SCENE,             XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DR3D,         XML_CUBE,              XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DR3D,         XML_SPHERE,            XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DR3D,         XML_EXTRUDE,           XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DR3D,         XML_ROTATE,            XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_TITLE,             XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_SUBTITLE,          XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_FOOTER,            XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_LEGEND,            XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_WALL,              XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_FLOOR,             XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_AXIS,              XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_GRID,              XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_SERIES,            XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_DATA_POINT,        XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_MEAN_VALUE,        XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_ERROR_INDICATOR,   XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_REGRESSION_CURVE,  XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_STOCK_GAIN_MARKER, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_STOCK_LOSS_MARKER, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART,        XML_STOCK_RANGE_LINE,  XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),

    ENTRY0( XML_NAMESPACE_CHART, XML_CHART,     XML_ETACTION_CHART ),
    ENTRY0( XML_NAMESPACE_CHART, XML_PLOT_AREA, XML_ETACTION_CHART_PLOT_AREA ),

    ENTRY1Q( XML_NAMESPACE_TEXT,  XML_TRACKED_CHANGES, XML_ETACTION_TRACKED_CHANGES, XML_NAMESPACE_TEXT,  XML_PROTECTION_KEY ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_TRACKED_CHANGES, XML_ETACTION_TRACKED_CHANGES, XML_NAMESPACE_TABLE, XML_PROTECTION_KEY ),

    ENTRY1( XML_NAMESPACE_TEXT,  XML_INDEX_ENTRY_TAB_STOP,        XML_ETACTION_PROC_ATTRS, OOO_INDEX_ENTRY_TAB_STOP_ACTIONS ),
    ENTRY0( XML_NAMESPACE_STYLE, XML_TAB_STOP,                    XML_ETACTION_TAB_STOP ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_BACKGROUND_IMAGE,            XML_ETACTION_PROC_ATTRS, OOO_BACKGROUND_IMAGE_ACTIONS  ),
    ENTRY1( XML_NAMESPACE_TEXT,  XML_LINENUMBERING_CONFIGURATION, XML_ETACTION_PROC_ATTRS, OOO_LINENUMBERING_ACTIONS ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_FOOTNOTE_SEP,                XML_ETACTION_PROC_ATTRS, OOO_FOOTNOTE_SEP_ACTIONS ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_DROP_CAP,                    XML_ETACTION_PROC_ATTRS, OOO_DROP_CAP_ACTIONS ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_COLUMNS,                     XML_ETACTION_PROC_ATTRS, OOO_COLUMNS_ACTIONS ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_COLUMN,                      XML_ETACTION_PROC_ATTRS, OOO_COLUMNS_ACTIONS ),

    // rename office:value-* to *:value-*
    ENTRY1( XML_NAMESPACE_TEXT,  XML_VARIABLE_DECL,           XML_ETACTION_PROC_ATTRS, OOO_TEXT_VALUE_TYPE_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT,  XML_VARIABLE_SET,            XML_ETACTION_PROC_ATTRS, OOO_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT,  XML_VARIABLE_INPUT,          XML_ETACTION_PROC_ATTRS, OOO_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT,  XML_USER_FIELD_DECL,         XML_ETACTION_PROC_ATTRS, OOO_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT,  XML_EXPRESSION,              XML_ETACTION_PROC_ATTRS, OOO_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
//  ENTRY1( XML_NAMESPACE_TEXT,  XML_USER_DEFINED,            XML_ETACTION_PROC_ATTRS, OOO_TEXT_VALUE_TYPE_ACTIONS), /* text:user-defined has no attrs so far */
    ENTRY1( XML_NAMESPACE_TABLE, XML_TABLE_CELL,              XML_ETACTION_PROC_ATTRS, OOO_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TABLE, XML_COVERED_TABLE_CELL,      XML_ETACTION_PROC_ATTRS, OOO_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TABLE, XML_CHANGE_TRACK_TABLE_CELL, XML_ETACTION_PROC_ATTRS, OOO_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
//  ENTRY1( XML_NAMESPACE_FORM,  XML_PROPERTY,                XML_ETACTION_PROC_ATTRS, OOO_VALUE_TYPE_ACTIONS), /* TODO: generated entry */
//  ENTRY1( XML_NAMESPACE_FORM,  XML_LIST_PROPERTY,           XML_ETACTION_PROC_ATTRS, OOO_VALUE_TYPE_ACTIONS), /* generated entry */

    ENTRY1( XML_NAMESPACE_OFFICE, XML_ANNOTATION,  XML_ETACTION_MOVE_ATTRS_TO_ELEMS, OOO_ANNOTATION_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_OFFICE, XML_CHANGE_INFO, XML_ETACTION_MOVE_ATTRS_TO_ELEMS, OOO_CHANGE_INFO_ACTIONS ), /* generated entry */

    ENTRY1( XML_NAMESPACE_TEXT, XML_DDE_CONNECTION_DECL, XML_ETACTION_PROC_ATTRS, OOO_DDE_CONNECTION_DECL_ACTIONS  ),

    ENTRY0( XML_NAMESPACE_FORM, XML_CONTROL,  XML_ETACTION_FORM_CONTROL ),
    ENTRY1( XML_NAMESPACE_FORM, XML_COLUMN,   XML_ETACTION_PROC_ATTRS, OOO_FORM_COLUMN_ACTIONS ),
    ENTRY0( XML_NAMESPACE_FORM, XML_PROPERTY, XML_ETACTION_FORM_PROPERTY ),

    // process xlink:href
    ENTRY1(   XML_NAMESPACE_META,         XML_TEMPLATE,                          XML_ETACTION_PROC_ATTRS,             OOO_XLINK_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_META,         XML_AUTO_RELOAD,                       XML_ETACTION_PROC_ATTRS,             OOO_XLINK_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_SECTION_SOURCE,                    XML_ETACTION_PROC_ATTRS,             OOO_XLINK_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_SCRIPT,                            XML_ETACTION_PROC_ATTRS,             OOO_XLINK_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TEXT,         XML_ALPHABETICAL_INDEX_AUTO_MARK_FILE, XML_ETACTION_PROC_ATTRS,             OOO_XLINK_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TABLE,        XML_TABLE_SOURCE,                      XML_ETACTION_PROC_ATTRS,             OOO_XLINK_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_TABLE,        XML_CELL_RANGE_SOURCE,                 XML_ETACTION_PROC_ATTRS,             OOO_XLINK_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_DRAW,         XML_A,                                 XML_ETACTION_PROC_ATTRS,             OOO_XLINK_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_PRESENTATION, XML_SOUND,                             XML_ETACTION_PROC_ATTRS,             OOO_XLINK_ACTIONS ), /* generated entry */
    ENTRY1(   XML_NAMESPACE_FORM,         XML_FORM,                              XML_ETACTION_PROC_ATTRS,             OOO_FORM_CONTROL_ACTIONS ),
    ENTRY2QN( XML_NAMESPACE_STYLE,        XML_SYMBOL_IMAGE,                      XML_ETACTION_RENAME_ELEM_PROC_ATTRS, XML_NAMESPACE_CHART, XML_SYMBOL_IMAGE, OOO_BACKGROUND_IMAGE_ACTIONS ),

    ENTRY2QN( XML_NAMESPACE_CONFIG, XML_CONFIG_ITEM_SET, XML_ETACTION_PROC_ATTRS_COND, XML_NAMESPACE_OFFICE, XML_SETTINGS, OOO_CONFIG_ITEM_SET_ACTIONS ),

    // add namespace prefix
    //  text:formula
    ENTRY1( XML_NAMESPACE_TEXT, XML_SEQUENCE, XML_ETACTION_PROC_ATTRS, OOO_FORMULA_ACTIONS ), /* generated entry */
    //  text:condition
    ENTRY1( XML_NAMESPACE_TEXT, XML_DATABASE_NEXT, XML_ETACTION_PROC_ATTRS, OOO_FORMULA_ACTIONS ), /* generated entry */
    //  text:condition
    ENTRY2QN( XML_NAMESPACE_TEXT, XML_DATABASE_SELECT, XML_ETACTION_RENAME_ELEM_PROC_ATTRS, XML_NAMESPACE_TEXT, XML_DATABASE_ROW_SELECT, OOO_FORMULA_ACTIONS ),
    //  text:condition
    ENTRY1( XML_NAMESPACE_TEXT, XML_CONDITIONAL_TEXT, XML_ETACTION_PROC_ATTRS, OOO_FORMULA_ACTIONS ), /* generated entry */
    //  text:condition
    ENTRY1( XML_NAMESPACE_TEXT, XML_HIDDEN_TEXT, XML_ETACTION_PROC_ATTRS, OOO_FORMULA_ACTIONS ), /* generated entry */
    //  text:condition
    ENTRY1( XML_NAMESPACE_TEXT, XML_HIDDEN_PARAGRAPH, XML_ETACTION_PROC_ATTRS, OOO_FORMULA_ACTIONS ), /* generated entry */
    //  table:condition
    ENTRY1( XML_NAMESPACE_TABLE, XML_CONTENT_VALIDATION, XML_ETACTION_PROC_ATTRS, OOO_FORMULA_ACTIONS ), /* generated entry */

    // rename <table:dependences> to <table:dependencies>
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_DEPENDENCES, XML_ETACTION_RENAME_ELEM, XML_NAMESPACE_TABLE, XML_DEPENDENCIES ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_DEPENDENCE,  XML_ETACTION_RENAME_ELEM, XML_NAMESPACE_TABLE, XML_DEPENDENCY ),

    // process table::error-macro
    ENTRY1( XML_NAMESPACE_TABLE, XML_ERROR_MACRO, XML_ETACTION_PROC_ATTRS, OOO_ERROR_MACRO_ACTIONS ),

    // process table::conversion-mode
    ENTRY1( XML_NAMESPACE_TABLE, XML_CONVERSION_MODE, XML_ETACTION_PROC_ATTRS, OOO_DDE_CONV_MODE_ACTIONS ),

    // fix <text:alphabatical-index-mark text:main-etry>
    ENTRY1( XML_NAMESPACE_TEXT, XML_ALPHABETICAL_INDEX_MARK,       XML_ETACTION_PROC_ATTRS, OOO_ALPHABETICAL_INDEX_MARK_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_ALPHABETICAL_INDEX_MARK_START, XML_ETACTION_PROC_ATTRS, OOO_ALPHABETICAL_INDEX_MARK_ACTIONS ),

    // process table::data-pilot-member
    ENTRY1( XML_NAMESPACE_TABLE, XML_DATA_PILOT_MEMBER, XML_ETACTION_PROC_ATTRS, OOO_DATAPILOT_MEMBER_ACTIONS ),

    // process table::data-pilot-level
    ENTRY1( XML_NAMESPACE_TABLE, XML_DATA_PILOT_LEVEL, XML_ETACTION_PROC_ATTRS, OOO_DATAPILOT_LEVEL_ACTIONS ),

    // process table::source-service
    ENTRY1( XML_NAMESPACE_TABLE, XML_SOURCE_SERVICE, XML_ETACTION_PROC_ATTRS, OOO_SOURCE_SERVICE_ACTIONS ),

    // fix id strings in old animation elements
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_DIM,        XML_ETACTION_PROC_ATTRS, OOO_ANIMATION_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_PLAY,       XML_ETACTION_PROC_ATTRS, OOO_ANIMATION_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_SHOW_TEXT,  XML_ETACTION_PROC_ATTRS, OOO_ANIMATION_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_SHOW_SHAPE, XML_ETACTION_PROC_ATTRS, OOO_ANIMATION_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_HIDE_TEXT,  XML_ETACTION_PROC_ATTRS, OOO_ANIMATION_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_HIDE_SHAPE, XML_ETACTION_PROC_ATTRS, OOO_ANIMATION_ACTIONS ),

    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ETACTION_EOT )
};

// XML_ETACTION_STYLE
XMLTransformerActionInit const aStyleActionTable[] =
{
    ENTRY0( XML_NAMESPACE_STYLE,  XML_FAMILY,            XML_ATACTION_STYLE_FAMILY ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_NAME,              XML_ATACTION_ENCODE_STYLE_NAME ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_PARENT_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_NEXT_STYLE_NAME,   XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_LIST_STYLE_NAME,   XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_MASTER_PAGE_NAME,  XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_DATA_STYLE_NAME,   XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_NAME,              XML_ATACTION_ENCODE_STYLE_NAME ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_DISTANCE,          XML_ATACTION_INCH2IN ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_DOTS1_LENGTH,      XML_ATACTION_INCH2IN ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_DOTS2_LENGTH,      XML_ATACTION_INCH2IN ),
    ENTRY0( XML_NAMESPACE_SVG,    XML_WIDTH,             XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
    ENTRY0( XML_NAMESPACE_SVG,    XML_HEIGHT,            XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_START,             XML_ATACTION_NEG_PERCENT ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_END,               XML_ATACTION_NEG_PERCENT ),
    ENTRY1( XML_NAMESPACE_XLINK,  XML_HREF,              XML_ATACTION_URI_OOO, sal_uInt32(true) ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,     XML_ATACTION_EOT )
};

// OOO_FRAME_ELEM_ACTIONS
XMLTransformerActionInit const aFrameElemActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_EVENTS,          XML_ETACTION_RENAME_ELEM, XML_NAMESPACE_OFFICE, XML_EVENT_LISTENERS ),
    ENTRY0(  XML_NAMESPACE_DRAW,   XML_GLUE_POINT,      XML_ETACTION_COPY ),
    ENTRY0(  XML_NAMESPACE_DRAW,   XML_IMAGE_MAP,       XML_ETACTION_COPY ),
    ENTRY0(  XML_NAMESPACE_SVG,    XML_DESC,            XML_ETACTION_COPY_TEXT ),
    ENTRY0(  XML_NAMESPACE_DRAW,   XML_CONTOUR_POLYGON, XML_ETACTION_COPY ),
    ENTRY0(  XML_NAMESPACE_DRAW,   XML_CONTOUR_PATH,    XML_ETACTION_COPY ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,   XML_ETACTION_EOT )
};

// OOO_FRAME_ATTR_ACTIONS
XMLTransformerActionInit const aFrameAttrActionTable[] =
{
    ENTRY0( XML_NAMESPACE_DRAW,         XML_ZINDEX,             XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_DRAW,         XML_ID,                 XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_DRAW,         XML_LAYER,              XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_DRAW,         XML_STYLE_NAME,         XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_STYLE_NAME,         XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_DRAW,         XML_TRANSFORM,          XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_DRAW,         XML_NAME,               XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_TABLE,        XML_END_CELL_ADDRESS,   XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_TABLE,        XML_END_X,              XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_TABLE,        XML_END_Y,              XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_TABLE,        XML_TABLE_BACKGROUND,   XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_TEXT,         XML_ANCHOR_TYPE,        XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_TEXT,         XML_ANCHOR_PAGE_NUMBER, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_DRAW,         XML_TEXT_STYLE_NAME,    XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_SVG,          XML_X,                  XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_SVG,          XML_Y,                  XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_SVG,          XML_WIDTH,              XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_SVG,          XML_HEIGHT,             XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_STYLE,        XML_REL_WIDTH,          XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_STYLE,        XML_REL_HEIGHT,         XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_CLASS,              XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_PLACEHOLDER,        XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_USER_TRANSFORMED,   XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
    ENTRY0( XML_NAMESPACE_OFFICE,       XML_TOKEN_INVALID,      XML_ATACTION_EOT )
};

// OOO_EVENT_ELEM_ACTIONS
XMLTransformerActionInit const aEventActionTable[] =
{
    ENTRY0( XML_NAMESPACE_XLINK,  XML_HREF,          XML_ATACTION_HREF ),
    ENTRY1( XML_NAMESPACE_SCRIPT, XML_LANGUAGE,      XML_ATACTION_ADD_NAMESPACE_PREFIX, XML_NAMESPACE_OOO ),
    ENTRY0( XML_NAMESPACE_SCRIPT, XML_EVENT_NAME,    XML_ATACTION_EVENT_NAME ),
    ENTRY0( XML_NAMESPACE_SCRIPT, XML_MACRO_NAME,    XML_ATACTION_MACRO_NAME ),
    ENTRY0( XML_NAMESPACE_SCRIPT, XML_LOCATION,      XML_ATACTION_MACRO_LOCATION ),
    ENTRY0( XML_NAMESPACE_SCRIPT, XML_LIBRARY,       XML_ATACTION_MACRO_LOCATION ), // bug in draw
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OOO_MASTER_PAGE_ACTIONS
XMLTransformerActionInit const aMasterPageActionTable[] =
{
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_NAME,             XML_ATACTION_ENCODE_STYLE_NAME ),
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_NEXT_STYLE_NAME,  XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY1Q( XML_NAMESPACE_STYLE,  XML_PAGE_MASTER_NAME, XML_ATACTION_RENAME_ENCODE_STYLE_NAME_REF, XML_NAMESPACE_STYLE, XML_PAGE_LAYOUT_NAME ),
    ENTRY0(  XML_NAMESPACE_DRAW,   XML_STYLE_NAME,       XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,    XML_ATACTION_EOT )
};

XMLTransformerActionInit const aFontDeclActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_FO,     XML_FONT_FAMILY,     XML_ATACTION_RENAME, XML_NAMESPACE_SVG,   XML_FONT_FAMILY ),
    ENTRY1Q( XML_NAMESPACE_STYLE,  XML_FONT_STYLE_NAME, XML_ATACTION_RENAME, XML_NAMESPACE_STYLE, XML_FONT_ADORNMENTS ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,   XML_ATACTION_EOT )
};

// action table for OOO_PARA_ACTIONS
XMLTransformerActionInit const aParaActionTable[] =
{
    ENTRY0(  XML_NAMESPACE_TEXT,   XML_STYLE_NAME,      XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0(  XML_NAMESPACE_TEXT,   XML_COND_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
//  ENTRY0(  XML_NAMESPACE_TEXT,   XML_CLASS_NAMES,     XML_ATACTION_REMOVE ),
    ENTRY1Q( XML_NAMESPACE_TEXT,   XML_LEVEL,           XML_ATACTION_RENAME, XML_NAMESPACE_TEXT, XML_OUTLINE_LEVEL ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,   XML_ATACTION_EOT )
};

// action table for OOO_STYLE_REF_ACTIONS
XMLTransformerActionInit const aStyleRefActionTable[] =
{
    ENTRY0( XML_NAMESPACE_TEXT,         XML_STYLE_NAME,                    XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_TEXT,         XML_VISITED_STYLE_NAME,            XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_TEXT,         XML_MAIN_ENTRY_STYLE_NAME,         XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_TEXT,         XML_CITATION_STYLE_NAME,           XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_TEXT,         XML_CITATION_BODY_STYLE_NAME,      XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_TEXT,         XML_DEFAULT_STYLE_NAME,            XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_TEXT,         XML_MASTER_PAGE_NAME,              XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_STYLE,        XML_DATA_STYLE_NAME,               XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_STYLE,        XML_APPLY_STYLE_NAME,              XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_STYLE,        XML_PAGE_LAYOUT_NAME,              XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_TABLE,        XML_STYLE_NAME,                    XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_TABLE,        XML_DEFAULT_CELL_STYLE_NAME,       XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_DRAW,         XML_STYLE_NAME,                    XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_DRAW,         XML_MASTER_PAGE_NAME,              XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_PRESENTATION_PAGE_LAYOUT_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY1( XML_NAMESPACE_XLINK,        XML_HREF,                          XML_ATACTION_URI_OOO,              sal_uInt32(false) ),
    ENTRY1( XML_NAMESPACE_TEXT,         XML_CONDITION,                     XML_ATACTION_ADD_NAMESPACE_PREFIX, XML_NAMESPACE_OOOW ),
    ENTRY1( XML_NAMESPACE_TEXT,         XML_FORMULA,                       XML_ATACTION_ADD_NAMESPACE_PREFIX, XML_NAMESPACE_OOOW ),
    ENTRY0( XML_NAMESPACE_OFFICE,       XML_TOKEN_INVALID,                 XML_ATACTION_EOT )
};

// OOO_SHAPE_ACTIONS
// !!ATTENTION!! If you change something here, please also change
// aConnectorActionTable if appropriate
XMLTransformerActionInit const aShapeActionTable[] =
{
    ENTRY0(  XML_NAMESPACE_SVG,          XML_X,               XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_Y,               XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_X1,              XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_Y1,              XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_X2,              XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_Y2,              XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_CX,              XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_CY,              XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_R,               XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_RX,              XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_RY,              XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_WIDTH,           XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_HEIGHT,          XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MIN_WIDTH,       XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MIN_HEIGHT,      XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MAX_WIDTH,       XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MAX_HEIGHT,      XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_CORNER_RADIUS,   XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_LINE_SKEW,       XML_ATACTION_INCHS2INS ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_CAPTION_POINT_X, XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_CAPTION_POINT_Y, XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_STYLE_NAME,      XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_TEXT_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_END_X,           XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_END_Y,           XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_PRESENTATION, XML_STYLE_NAME,      XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0(  XML_NAMESPACE_DR3D,         XML_DISTANCE,        XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_DR3D,         XML_FOCAL_LENGTH,    XML_ATACTION_INCH2IN ),
    ENTRY1Q( XML_NAMESPACE_FORM,         XML_ID,              XML_ATACTION_RENAME,  XML_NAMESPACE_DRAW, XML_CONTROL ),
    ENTRY1(  XML_NAMESPACE_XLINK,        XML_HREF,            XML_ATACTION_URI_OOO, sal_uInt32(true) ),

    // BM: needed by chart:legend.  The legend needs also the draw actions.  As
    // there is no merge mechanism, all actions have to be in the same table
    ENTRY2( XML_NAMESPACE_CHART,  XML_LEGEND_POSITION, XML_ATACTION_RENAME_ATTRIBUTE, RENAME_ENTRY( XML_LEFT, XML_START ), RENAME_ENTRY( XML_RIGHT, XML_END )),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_ID,              XML_ATACTION_SHAPEID ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_START_SHAPE,     XML_ATACTION_SHAPEID ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_END_SHAPE,       XML_ATACTION_SHAPEID ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,   XML_ATACTION_EOT )
};

XMLTransformerActionInit const aConnectorActionTable[] =
{
    ENTRY0(  XML_NAMESPACE_SVG,          XML_X1,              XML_ATACTION_TWIPS2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_Y1,              XML_ATACTION_TWIPS2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_X2,              XML_ATACTION_TWIPS2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_Y2,              XML_ATACTION_TWIPS2IN ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_WIDTH,           XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_HEIGHT,          XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MIN_WIDTH,       XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MIN_HEIGHT,      XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MAX_WIDTH,       XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MAX_HEIGHT,      XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_STYLE_NAME,      XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_TEXT_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_END_X,           XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_END_Y,           XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_PRESENTATION, XML_STYLE_NAME,      XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY1Q( XML_NAMESPACE_FORM,         XML_ID,              XML_ATACTION_RENAME,  XML_NAMESPACE_DRAW, XML_CONTROL ),
    ENTRY1(  XML_NAMESPACE_XLINK,        XML_HREF,            XML_ATACTION_URI_OOO, sal_uInt32(true) ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_ID,              XML_ATACTION_SHAPEID ),
    ENTRY0(  XML_NAMESPACE_OFFICE,       XML_TOKEN_INVALID,   XML_ATACTION_EOT )
};

// OOO_INDEX_ENTRY_TAB_STOP_ACTIONS
XMLTransformerActionInit const aIndexEntryTabStopActionTable[] =
{
    ENTRY0( XML_NAMESPACE_STYLE,  XML_POSITION,      XML_ATACTION_INCH2IN ),
    ENTRY0( XML_NAMESPACE_TEXT,   XML_STYLE_NAME,    XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_TAB_STOP_ACTIONS
XMLTransformerActionInit const aTabStopActionTable[] =
{
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_POSITION,      XML_ATACTION_INCH2IN ),
    ENTRY1Q( XML_NAMESPACE_STYLE,  XML_LEADER_CHAR,   XML_ATACTION_RENAME, XML_NAMESPACE_STYLE, XML_LEADER_TEXT ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_LINENUMBERING_ACTIONS
XMLTransformerActionInit const aLineNumberingActionTable[] =
{
    ENTRY0(  XML_NAMESPACE_TEXT,   XML_OFFSET,                   XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_TEXT,   XML_STYLE_NAME,               XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY1Q( XML_NAMESPACE_TEXT,   XML_COUNT_IN_FLOATING_FRAMES, XML_ATACTION_RENAME, XML_NAMESPACE_TEXT, XML_COUNT_IN_TEXT_BOXES ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,            XML_ATACTION_EOT )
};

XMLTransformerActionInit const aFootnoteSepActionTable[] =
{
    ENTRY0( XML_NAMESPACE_STYLE,  XML_WIDTH,               XML_ATACTION_INCH2IN ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_DISTANCE_BEFORE_SEP, XML_ATACTION_INCH2IN ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_DISTANCE_AFTER_SEP,  XML_ATACTION_INCH2IN ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,       XML_ATACTION_EOT )
};

// OOO_DROP_CAP_ACTIONS
XMLTransformerActionInit const aDropCapActionTable[] =
{
    ENTRY0( XML_NAMESPACE_STYLE,  XML_DISTANCE,      XML_ATACTION_INCH2IN ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_STYLE_NAME,    XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

XMLTransformerActionInit const aColumnsActionTable[] =
{
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_COLUMN_GAP,    XML_ATACTION_INCH2IN ),
//  ENTRY0(  XML_NAMESPACE_STYLE,  XML_SPACE_BEFORE,  XML_ATACTION_INCH2IN ),
//  ENTRY0(  XML_NAMESPACE_STYLE,  XML_SPACE_AFTER,   XML_ATACTION_INCH2IN ),
    ENTRY1Q( XML_NAMESPACE_FO,     XML_MARGIN_LEFT,   XML_ATACTION_RENAME_INCH2IN, XML_NAMESPACE_FO, XML_START_INDENT ),
    ENTRY1Q( XML_NAMESPACE_FO,     XML_MARGIN_RIGHT,  XML_ATACTION_RENAME_INCH2IN, XML_NAMESPACE_FO, XML_END_INDENT ),
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_WIDTH,         XML_ATACTION_INCH2IN ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_TEXT_VALUE_TYPE_ACTIONS
XMLTransformerActionInit const aTextValueTypeActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TEXT,  XML_VALUE_TYPE,      XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_VALUE_TYPE ),
    ENTRY1Q( XML_NAMESPACE_TEXT,  XML_VALUE,           XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_VALUE ),
    ENTRY1Q( XML_NAMESPACE_TEXT,  XML_CURRENCY,        XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_CURRENCY ),
    ENTRY1Q( XML_NAMESPACE_TEXT,  XML_DATE_VALUE,      XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_DATE_VALUE ),
    ENTRY1Q( XML_NAMESPACE_TEXT,  XML_TIME_VALUE,      XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_TIME_VALUE ),
    ENTRY1Q( XML_NAMESPACE_TEXT,  XML_BOOLEAN_VALUE,   XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_BOOLEAN_VALUE ),
    ENTRY1Q( XML_NAMESPACE_TEXT,  XML_STRING_VALUE,    XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_STRING_VALUE ),
    ENTRY0(  XML_NAMESPACE_STYLE, XML_DATA_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY1(  XML_NAMESPACE_TEXT,  XML_FORMULA,         XML_ATACTION_ADD_NAMESPACE_PREFIX, XML_NAMESPACE_OOOW ),
    ENTRY0(  XML_NAMESPACE_TEXT,  XML_TOKEN_INVALID,   XML_ATACTION_EOT )
};

// OOO_TABLE_VALUE_TYPE_ACTIONS
XMLTransformerActionInit const aTableValueTypeActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_VALUE_TYPE,      XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_VALUE_TYPE ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_VALUE,           XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_VALUE ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_CURRENCY,        XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_CURRENCY ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_DATE_VALUE,      XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_DATE_VALUE ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_TIME_VALUE,      XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_TIME_VALUE ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_BOOLEAN_VALUE,   XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_BOOLEAN_VALUE ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_STRING_VALUE,    XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_STRING_VALUE ),
    ENTRY0(  XML_NAMESPACE_TABLE, XML_STYLE_NAME,      XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY1(  XML_NAMESPACE_TABLE, XML_FORMULA,         XML_ATACTION_ADD_APP_NAMESPACE_PREFIX, XML_NAMESPACE_OOOW ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_VALIDATION_NAME, XML_ATACTION_RENAME, XML_NAMESPACE_TABLE, XML_CONTENT_VALIDATION_NAME ),
    ENTRY0(  XML_NAMESPACE_TABLE, XML_TOKEN_INVALID,   XML_ATACTION_EOT )
};

// action table for OOO_ANNOTATION_ACTIONS
XMLTransformerActionInit const aAnnotationActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_AUTHOR,             XML_ATACTION_MOVE_TO_ELEM, XML_NAMESPACE_DC,   XML_CREATOR ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_CREATE_DATE,        XML_ATACTION_MOVE_TO_ELEM, XML_NAMESPACE_DC,   XML_DATE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_CREATE_DATE_STRING, XML_ATACTION_MOVE_TO_ELEM, XML_NAMESPACE_META, XML_DATE_STRING ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,      XML_ATACTION_EOT )
};

// action table for OOO_CHANGE_INFO_ACTIONS
XMLTransformerActionInit const aChangeInfoActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_CHG_AUTHOR,    XML_ATACTION_MOVE_TO_ELEM, XML_NAMESPACE_DC, XML_CREATOR ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_CHG_DATE_TIME, XML_ATACTION_MOVE_TO_ELEM, XML_NAMESPACE_DC, XML_DATE ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_BACKGROUND_IMAGE_ACTIONS
XMLTransformerActionInit const aBackgroundImageActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_DRAW,   XML_TRANSPARENCY,  XML_ATACTION_RENAME_NEG_PERCENT, XML_NAMESPACE_DRAW, XML_OPACITY ),
    ENTRY1(  XML_NAMESPACE_XLINK,  XML_HREF,          XML_ATACTION_URI_OOO,            sal_uInt32(true) ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

/* OOO_BACKGROUND_IMAGE_ACTIONS for OpenOffice.org text documents
   OpenOffice.org text documents, written by OpenOffice.org, contain
   wrong value for the transparency of the background graphic (#i50322#)
*/
XMLTransformerActionInit const aWriterBackgroundImageActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_DRAW,   XML_TRANSPARENCY,  XML_ATACTION_WRITER_BACK_GRAPHIC_TRANSPARENCY, XML_NAMESPACE_DRAW, XML_OPACITY ),
    ENTRY1(  XML_NAMESPACE_XLINK,  XML_HREF,          XML_ATACTION_URI_OOO,                          sal_uInt32(true) ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_DDE_CONNECTION_DECL
XMLTransformerActionInit const aDDEConnectionDeclActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TEXT,   XML_NAME,          XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_NAME ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_FORM_CONTROL_ACTIONS
XMLTransformerActionInit const aFormControlActionTable[] =
{
    ENTRY2QN( XML_NAMESPACE_FORM,   XML_SERVICE_NAME,  XML_ATACTION_RENAME_ADD_NAMESPACE_PREFIX, XML_NAMESPACE_FORM, XML_CONTROL_IMPLEMENTATION, XML_NAMESPACE_OOO ),
    ENTRY1(   XML_NAMESPACE_XLINK,  XML_HREF,          XML_ATACTION_URI_OOO, sal_uInt32(false) ),
    ENTRY0(   XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_FORM_COLUMN_ACTIONS
XMLTransformerActionInit const aFormColumnActionTable[] =
{
    ENTRY1Q(  XML_NAMESPACE_FORM,   XML_COLUMN_STYLE_NAME, XML_ATACTION_RENAME_ENCODE_STYLE_NAME_REF, XML_NAMESPACE_FORM, XML_TEXT_STYLE_NAME ),
    ENTRY2QN( XML_NAMESPACE_FORM,   XML_SERVICE_NAME,      XML_ATACTION_RENAME_ADD_NAMESPACE_PREFIX,  XML_NAMESPACE_FORM, XML_CONTROL_IMPLEMENTATION, XML_NAMESPACE_OOO ),
    ENTRY0(   XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,     XML_ATACTION_EOT )
};

// OOO_FORM_PROP_ACTIONS
XMLTransformerActionInit const aFormPropActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_FORM,   XML_PROPERTY_TYPE,    XML_ATACTION_RENAME, XML_NAMESPACE_OFFICE, XML_VALUE_TYPE ),
    ENTRY0(  XML_NAMESPACE_FORM,   XML_PROPERTY_IS_LIST, XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,    XML_ATACTION_EOT )
};

// OOO_XLINK_ACTIONS
XMLTransformerActionInit const aXLinkActionTable[] =
{
    ENTRY1( XML_NAMESPACE_XLINK,  XML_HREF,          XML_ATACTION_URI_OOO, sal_uInt32(false) ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_CONFIG_ITEM_SET_ACTIONS
XMLTransformerActionInit const aConfigItemSetActionTable[] =
{
    ENTRY1( XML_NAMESPACE_CONFIG, XML_NAME,          XML_ATACTION_ADD_NAMESPACE_PREFIX, XML_NAMESPACE_OOO ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FORMULA_ACTIONS
XMLTransformerActionInit const aFormulaActionTable[] =
{
    ENTRY1( XML_NAMESPACE_TEXT,   XML_CONDITION,     XML_ATACTION_ADD_NAMESPACE_PREFIX,     XML_NAMESPACE_OOOW ),
    ENTRY1( XML_NAMESPACE_TEXT,   XML_FORMULA,       XML_ATACTION_ADD_NAMESPACE_PREFIX,     XML_NAMESPACE_OOOW ),
    ENTRY1( XML_NAMESPACE_TABLE,  XML_CONDITION,     XML_ATACTION_ADD_APP_NAMESPACE_PREFIX, XML_NAMESPACE_OOOW ),
    ENTRY1( XML_NAMESPACE_TABLE,  XML_FORMULA,       XML_ATACTION_ADD_APP_NAMESPACE_PREFIX, XML_NAMESPACE_OOOW ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_ERROR_MACRO_ACTIONS
XMLTransformerActionInit const aErrorMacroActionTable[] =
{
    ENTRY0( XML_NAMESPACE_TABLE,  XML_NAME,          XML_ATACTION_REMOVE ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_DDE_CONV_MODE_ACTIONS
XMLTransformerActionInit const aDDEConvModeActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TABLE,  XML_LET_TEXT,      XML_ATACTION_RENAME, XML_NAMESPACE_TABLE, XML_KEEP_TEXT ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_DATAPILOT_MEMBER_ACTIONS
XMLTransformerActionInit const aDataPilotMemberActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TABLE,  XML_DISPLAY_DETAILS, XML_ATACTION_RENAME, XML_NAMESPACE_TABLE, XML_SHOW_DETAILS ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,   XML_ATACTION_EOT )
};

// OOO_DATAPILOT_LEVEL_ACTIONS
XMLTransformerActionInit const aDataPilotLevelActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TABLE,  XML_DISPLAY_EMPTY, XML_ATACTION_RENAME, XML_NAMESPACE_TABLE, XML_SHOW_EMPTY ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_SOURCE_SERVICE_ACTIONS
XMLTransformerActionInit const aSourceServiceActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TABLE,  XML_USERNAME,      XML_ATACTION_RENAME, XML_NAMESPACE_TABLE, XML_USER_NAME ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_ANIMATION_ACTIONS
XMLTransformerActionInit const aAnimationsActionTable[] =
{
    ENTRY0( XML_NAMESPACE_DRAW,         XML_SHAPE_ID,      XML_ATACTION_SHAPEID ),
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_PATH_ID,       XML_ATACTION_SHAPEID ),
    ENTRY0( XML_NAMESPACE_OFFICE,       XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_DRAW_AREA_POLYGON_ACTIONS (to be added to OOO_SHAPE_ACTIONS)
XMLTransformerActionInit const aDrawAreaPolygonActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_SVG,    XML_POINTS,        XML_ATACTION_RENAME, XML_NAMESPACE_DRAW, XML_POINTS ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_CHART_ACTIONS
XMLTransformerActionInit const aChartActionTable[] =
{
    ENTRY1( XML_NAMESPACE_CHART,  XML_CLASS,         XML_ATACTION_ADD_NAMESPACE_PREFIX, XML_NAMESPACE_CHART ),
    ENTRY0( XML_NAMESPACE_CHART,  XML_ADD_IN_NAME,   XML_ATACTION_REMOVE ),
    ENTRY0( XML_NAMESPACE_SVG,    XML_WIDTH,         XML_ATACTION_INCH2IN ),
    ENTRY0( XML_NAMESPACE_SVG,    XML_HEIGHT,        XML_ATACTION_INCH2IN ),
    ENTRY0( XML_NAMESPACE_CHART,  XML_STYLE_NAME,    XML_ATACTION_ENCODE_STYLE_NAME_REF ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_ALPHABETICAL_INDEX_MARK_ACTIONS
XMLTransformerActionInit const aAlphabeticalIndexMarkActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TEXT,   XML_MAIN_ETRY,     XML_ATACTION_RENAME, XML_NAMESPACE_TEXT, XML_MAIN_ENTRY ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_SCRIPT_ACTIONS
XMLTransformerActionInit const aScriptActionTable[] =
{
    ENTRY1(  XML_NAMESPACE_SCRIPT, XML_LANGUAGE,      XML_ATACTION_ADD_NAMESPACE_PREFIX, XML_NAMESPACE_OOO ),
    ENTRY1Q( XML_NAMESPACE_SCRIPT, XML_NAME,          XML_ATACTION_RENAME,               XML_NAMESPACE_OOO, XML_NAME ),
    ENTRY1Q( XML_NAMESPACE_SCRIPT, XML_READONLY,      XML_ATACTION_RENAME,               XML_NAMESPACE_OOO, XML_READONLY ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

XMLTokenEnum const aTokenMap[] =
{
    XML_NONE, XML_SINGLE, XML_DOUBLE, XML_BOLD, XML_BOLD_DOTTED,
    XML_BOLD_DASH, XML_BOLD_LONG_DASH, XML_BOLD_DOT_DASH,
    XML_BOLD_DOT_DOT_DASH, XML_BOLD_WAVE, XML_DOUBLE_WAVE,
    XML_SINGLE_LINE, XML_DOUBLE_LINE, XML_THICK_LINE, XML_SLASH, XML_uX,
    XML_TOKEN_END
};

namespace {

class XMLDocumentTransformerContext_Impl : public XMLTransformerContext
{
    OUString const m_aElemQName;
    OUString m_aOldClass;

public:
    XMLDocumentTransformerContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName );
    XMLDocumentTransformerContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName,
                              sal_uInt16 nPrefix,
                              ::xmloff::token::XMLTokenEnum eToken  );

    virtual void StartElement( const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;
    virtual void EndElement() override;
};

}

XMLDocumentTransformerContext_Impl::XMLDocumentTransformerContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName ) :
    XMLTransformerContext( rImp, rQName ),
    m_aElemQName( rQName )
{
}
XMLDocumentTransformerContext_Impl::XMLDocumentTransformerContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName ,
        sal_uInt16 nPrefix,
        ::xmloff::token::XMLTokenEnum eToken) :
    XMLTransformerContext( rImp, rQName ),
    m_aElemQName( rImp.GetNamespaceMap().GetQNameByKey( nPrefix,
                            ::xmloff::token::GetXMLToken( eToken ) ) )
{
}

void XMLDocumentTransformerContext_Impl::StartElement(
        const Reference< XAttributeList >& rAttrList )
{
    Reference< XAttributeList > xAttrList( rAttrList );

    m_aOldClass = GetTransformer().GetClass();

    rtl::Reference<XMLMutableAttributeList> pMutableAttrList;
    bool bOOo = false, bOOoW = false, bOOoC = false,
        bDOM=false, bDC = false, bSVG = false;
    sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
    for( sal_Int16 i=0; i < nAttrCount; i++ )
    {
        const OUString& rAttrName = xAttrList->getNameByIndex( i );
        OUString aLocalName;
        sal_uInt16 nPrefix =
            GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
                                                                 &aLocalName );
        if( XML_NAMESPACE_OFFICE == nPrefix &&
            IsXMLToken( aLocalName, XML_CLASS ) )
        {
            const OUString& rValue = xAttrList->getValueByIndex( i );
            GetTransformer().SetClass( rValue );

            pMutableAttrList = new XMLMutableAttributeList( xAttrList );
            xAttrList = pMutableAttrList;
            OUString sMime = "application/vnd.oasis.opendocument." + rValue;
            pMutableAttrList->SetValueByIndex( i, sMime );
            OUString aNewAttrQName( GetTransformer().GetNamespaceMap().GetQNameByKey( XML_NAMESPACE_OFFICE, ::xmloff::token::GetXMLToken( XML_MIMETYPE ) ) );
            pMutableAttrList->RenameAttributeByIndex(i, aNewAttrQName );
            break;
        }
        else if( XML_NAMESPACE_XMLNS == nPrefix )
        {
            const OUString& rAttrValue = xAttrList->getValueByIndex( i );
            if( IsXMLToken( rAttrValue, XML_N_OOO ) )
                bOOo = true;
            else if( IsXMLToken( rAttrValue, XML_N_OOOW ) )
                bOOoW = true;
            else if( IsXMLToken( rAttrValue, XML_N_OOOC ) )
                bOOoC = true;
            else if( IsXMLToken( rAttrValue, XML_N_DOM ) )
                bDOM = true;
            else if( IsXMLToken( rAttrValue, XML_N_DC ) )
                bDC = true;
            else if( IsXMLToken( rAttrValue, XML_N_SVG ) )
                bSVG = true;
        }
    }
    if( !(bOOo && bOOoW && bOOoC && bDOM && bDC && bSVG) )
    {
        if( !pMutableAttrList  )
        {
            pMutableAttrList = new XMLMutableAttributeList( xAttrList );
            xAttrList = pMutableAttrList;
        }
        if( !bOOo )
            pMutableAttrList->AddAttribute(
                    GetTransformer().GetNamespaceMap().GetAttrNameByKey(
                        XML_NAMESPACE_OOO ),
                    GetTransformer().GetNamespaceMap().GetNameByKey(
                        XML_NAMESPACE_OOO ) );
        if( !bOOoW )
            pMutableAttrList->AddAttribute(
                    GetTransformer().GetNamespaceMap().GetAttrNameByKey(
                        XML_NAMESPACE_OOOW ),
                    GetTransformer().GetNamespaceMap().GetNameByKey(
                        XML_NAMESPACE_OOOW ) );
        if( !bOOoC )
            pMutableAttrList->AddAttribute(
                    GetTransformer().GetNamespaceMap().GetAttrNameByKey(
                        XML_NAMESPACE_OOOC ),
                    GetTransformer().GetNamespaceMap().GetNameByKey(
                        XML_NAMESPACE_OOOC ) );
        if( !bDOM )
            pMutableAttrList->AddAttribute(
                    GetTransformer().GetNamespaceMap().GetAttrNameByKey(
                        XML_NAMESPACE_DOM ),
                    GetTransformer().GetNamespaceMap().GetNameByKey(
                        XML_NAMESPACE_DOM ) );
        if( !bDC )
            pMutableAttrList->AddAttribute(
                    GetTransformer().GetNamespaceMap().GetAttrNameByKey(
                        XML_NAMESPACE_DC ),
                    GetTransformer().GetNamespaceMap().GetNameByKey(
                        XML_NAMESPACE_DC ) );
        if( !bSVG )
            pMutableAttrList->AddAttribute(
                    GetTransformer().GetNamespaceMap().GetAttrNameByKey(
                        XML_NAMESPACE_SVG ),
                    GetTransformer().GetNamespaceMap().GetNameByKey(
                        XML_NAMESPACE_SVG ) );
    }

    GetTransformer().GetDocHandler()->startElement( m_aElemQName, xAttrList );
}

void XMLDocumentTransformerContext_Impl::EndElement()
{
    GetTransformer().GetDocHandler()->endElement( m_aElemQName );

    GetTransformer().SetClass( m_aOldClass );
}

namespace {

class XMLBodyTransformerContext_Impl : public XMLTransformerContext
{
    OUString m_aClassQName;

public:
    XMLBodyTransformerContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName );

    virtual void StartElement( const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;
    virtual void EndElement() override;
};

}

XMLBodyTransformerContext_Impl::XMLBodyTransformerContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName ) :
    XMLTransformerContext( rImp, rQName )
{
}

void XMLBodyTransformerContext_Impl::StartElement(
        const Reference< XAttributeList >& rAttrList )
{
    XMLTransformerContext::StartElement( rAttrList );

    rtl::Reference<XMLMutableAttributeList> pMutableAttrList =
        new XMLMutableAttributeList( rAttrList );
    Reference< XAttributeList > xAttrList = pMutableAttrList;
    OUString aClass( GetTransformer().GetClass() );
    if( aClass.isEmpty() )
    {
        aClass = GetXMLToken( XML_TEXT );
    }
    else if( IsXMLToken( aClass, XML_TEXT_GLOBAL ) )
    {
        OUString aGlobalQName(
                GetTransformer().GetNamespaceMap().GetQNameByKey(
                            XML_NAMESPACE_TEXT, GetXMLToken(XML_GLOBAL ) ) );
        pMutableAttrList->AddAttribute( aGlobalQName, GetXMLToken(XML_TRUE) );

        aClass = GetXMLToken( XML_TEXT );
    }

    m_aClassQName = GetTransformer().GetNamespaceMap().GetQNameByKey(
                        XML_NAMESPACE_OFFICE, aClass );
    GetTransformer().GetDocHandler()->startElement( m_aClassQName,
                                                    xAttrList );
}

void XMLBodyTransformerContext_Impl::EndElement()
{
    GetTransformer().GetDocHandler()->endElement( m_aClassQName );
    XMLTransformerContext::EndElement();
}

namespace {

class XMLTabStopOOoTContext_Impl : public XMLPersElemContentTContext
{
public:
    XMLTabStopOOoTContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName );

    virtual void StartElement( const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;
};

}

XMLTabStopOOoTContext_Impl::XMLTabStopOOoTContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName ) :
    XMLPersElemContentTContext( rImp, rQName )
{
}

void XMLTabStopOOoTContext_Impl::StartElement(
        const Reference< XAttributeList >& rAttrList )
{
    XMLTransformerActions *pActions =
        GetTransformer().GetUserDefinedActions( OOO_TAB_STOP_ACTIONS  );
    OSL_ENSURE( pActions, "go no actions" );

    Reference< XAttributeList > xAttrList( rAttrList );
    rtl::Reference<XMLMutableAttributeList> pMutableAttrList;
    sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
    for( sal_Int16 i=0; i < nAttrCount; i++ )
    {
        const OUString& rAttrName = xAttrList->getNameByIndex( i );
        OUString aLocalName;
        sal_uInt16 nPrefix =
            GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
                                                                 &aLocalName );
        XMLTransformerActions::key_type aKey( nPrefix, aLocalName );
        XMLTransformerActions::const_iterator aIter =
            pActions->find( aKey );
        if( aIter != pActions->end() )
        {
            if( !pMutableAttrList )
            {
                pMutableAttrList =
                    new XMLMutableAttributeList( xAttrList );
                xAttrList = pMutableAttrList;
            }
            const OUString& rAttrValue = xAttrList->getValueByIndex( i );
            switch( (*aIter).second.m_nActionType )
            {
            case XML_ATACTION_RENAME:
                {
                    OUString aNewAttrQName(
                        GetTransformer().GetNamespaceMap().GetQNameByKey(
                            (*aIter).second.GetQNamePrefixFromParam1(),
                            ::xmloff::token::GetXMLToken(
                            (*aIter).second.GetQNameTokenFromParam1()) ) );
                    pMutableAttrList->RenameAttributeByIndex( i,
                                                              aNewAttrQName );
                }
                if( IsXMLToken( aLocalName, XML_LEADER_CHAR ) &&
                     !rAttrValue.isEmpty() &&
                    rAttrValue[0] != ' ' )
                {
                    OUString aNewAttrQName(
                        GetTransformer().GetNamespaceMap().GetQNameByKey(
                            XML_NAMESPACE_STYLE,
                            ::xmloff::token::GetXMLToken(XML_LEADER_STYLE) ) );
                    pMutableAttrList->AddAttribute( aNewAttrQName,
                                                 GetXMLToken( XML_SOLID ) );
                }
                break;
            case XML_ATACTION_INCH2IN:
                {
                    OUString aAttrValue( rAttrValue );
                    if( XMLTransformerBase::ReplaceSingleInchWithIn(
                                aAttrValue ) )
                        pMutableAttrList->SetValueByIndex( i, aAttrValue );
                }
                break;
            default:
                OSL_ENSURE( false, "unknown action" );
                break;
            }
        }
    }

    XMLPersElemContentTContext::StartElement( xAttrList );
}

namespace {

class XMLTrackedChangesOOoTContext_Impl : public XMLTransformerContext
{
    sal_uInt16 const m_nPrefix;
    XMLTokenEnum const m_eToken;

public:
    XMLTrackedChangesOOoTContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName,
                               sal_uInt16 nPrefix,
                            XMLTokenEnum eToken );

    virtual void StartElement( const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;
};

}

XMLTrackedChangesOOoTContext_Impl::XMLTrackedChangesOOoTContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName,
        sal_uInt16 nPrefix,
        XMLTokenEnum eToken ) :
    XMLTransformerContext( rImp, rQName ),
    m_nPrefix( nPrefix ),
    m_eToken( eToken )
{
}

void XMLTrackedChangesOOoTContext_Impl::StartElement(
        const Reference< XAttributeList >& rAttrList )
{
    sal_Int16 nAttrCount = rAttrList.is() ? rAttrList->getLength() : 0;
    for( sal_Int16 i=0; i < nAttrCount; i++ )
    {
        const OUString& rAttrName = rAttrList->getNameByIndex( i );
        OUString aLocalName;
        sal_uInt16 nPrefix =
            GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
                                                                 &aLocalName );
        if( m_nPrefix == nPrefix && IsXMLToken( aLocalName, m_eToken ) )
        {
            const Reference< XPropertySet > rPropSet =
                GetTransformer().GetPropertySet();
            OSL_ENSURE( rPropSet.is(), "no info property set" );
            if( rPropSet.is() )
            {
                OUString aPropName("RedlineProtectionKey");
                Reference< XPropertySetInfo > xPropSetInfo(
                            rPropSet->getPropertySetInfo() );
                if( xPropSetInfo.is() &&
                    xPropSetInfo->hasPropertyByName( aPropName ) )
                {
                    Sequence < sal_Int8 > aKey;
                    ::comphelper::Base64::decode( aKey,
                                        rAttrList->getValueByIndex( i ) );
                    rPropSet->setPropertyValue( aPropName, Any( aKey ) );
                }
                else
                {
                    OSL_ENSURE( false, "RedineProtectionKey is missing" );
                }
            }
            break;
        }
    }
    XMLTransformerContext::StartElement( rAttrList );
}

namespace {

class XMLTableOOoTransformerContext_Impl : public XMLTransformerContext
{
    OUString const m_aElemQName;

public:
    XMLTableOOoTransformerContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName );

    virtual void StartElement( const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;
    virtual void EndElement() override;
};

}

XMLTableOOoTransformerContext_Impl::XMLTableOOoTransformerContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName ) :
    XMLTransformerContext( rImp, rQName ),
    m_aElemQName( rQName )
{
}

void XMLTableOOoTransformerContext_Impl::StartElement(
        const Reference< XAttributeList >& rAttrList )
{
    // Perform OOO_STYLE_REF_ACTIONS for all applications (#i50521#)
    Reference< XAttributeList > xAttrList( rAttrList );
    XMLMutableAttributeList* pMutableAttrList =
        GetTransformer().ProcessAttrList( xAttrList, OOO_STYLE_REF_ACTIONS, false );
    if( rAttrList->getLength() && IsXMLToken( GetTransformer().GetClass(), XML_SPREADSHEET  ) )
    {
        bool bPrintRanges(false);

        sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
        for( sal_Int16 i=0; i < nAttrCount; i++ )
        {
            const OUString& rAttrName = xAttrList->getNameByIndex( i );
            OUString aLocalName;
            sal_uInt16 nPrefix =
                GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
                                                                    &aLocalName );
            if( XML_NAMESPACE_TABLE == nPrefix &&
                IsXMLToken( aLocalName, XML_PRINT_RANGES ) )
            {
                bPrintRanges = true;
            }
        }
        if (!bPrintRanges && pMutableAttrList)
        {
            xAttrList = pMutableAttrList;
            pMutableAttrList->AddAttribute(GetTransformer().GetNamespaceMap().GetQNameByKey(
                                XML_NAMESPACE_TABLE,
                                GetXMLToken( XML_PRINT ) ), GetXMLToken ( XML_FALSE ));
        }
    }

    GetTransformer().GetDocHandler()->startElement( m_aElemQName, xAttrList );
}

void XMLTableOOoTransformerContext_Impl::EndElement()
{
    GetTransformer().GetDocHandler()->endElement( m_aElemQName );
}

XMLTransformerContext *OOo2OasisTransformer::CreateUserDefinedContext(
                              const TransformerAction_Impl& rAction,
                              const OUString& rQName,
                                 bool bPersistent   )
{
    switch( rAction.m_nActionType )
    {
    case XML_ETACTION_DOCUMENT:
        return new XMLDocumentTransformerContext_Impl( *this, rQName );
    case XML_ETACTION_DOCUMENT_RENAME:
        return new XMLDocumentTransformerContext_Impl( *this, rQName,
                            rAction.GetQNamePrefixFromParam1(),
                            rAction.GetQNameTokenFromParam1() );
    case XML_ETACTION_BODY:
        return new XMLBodyTransformerContext_Impl( *this, rQName );
    case XML_ETACTION_STYLE:
        return new XMLStyleOOoTContext( *this, rQName,
                               static_cast< XMLFamilyType >( rAction.m_nParam1 ),
                               bPersistent  );
    case XML_ETACTION_STYLE_RENAME:
        return new XMLStyleOOoTContext( *this, rQName,
                    static_cast< XMLFamilyType >( rAction.m_nParam2 ),
                    rAction.GetQNamePrefixFromParam1(),
                    rAction.GetQNameTokenFromParam1(),
                    bPersistent );
    case XML_ETACTION_FRAME:
        return new XMLFrameOOoTransformerContext( *this, rQName );
    case XML_ETACTION_EVENT:
        return new XMLEventOOoTransformerContext( *this, rQName, bPersistent );
    case XML_ETACTION_TAB_STOP:
        return new XMLTabStopOOoTContext_Impl( *this, rQName );
    case XML_ETACTION_FORM_CONTROL:
        return new XMLControlOOoTransformerContext( *this, rQName );
    case XML_ETACTION_FORM_PROPERTY:
        return new XMLFormPropOOoTransformerContext( *this, rQName );
#if !ENABLE_WASM_STRIP_CHART
    case XML_ETACTION_CHART:
        return new XMLChartOOoTransformerContext( *this, rQName );
    case XML_ETACTION_CHART_PLOT_AREA:
        return new XMLChartPlotAreaOOoTContext( *this, rQName );
#endif
    case XML_ETACTION_TRACKED_CHANGES:
        return new XMLTrackedChangesOOoTContext_Impl( *this, rQName,
                               rAction.GetQNamePrefixFromParam1(),
                            rAction.GetQNameTokenFromParam1() );
    case XML_ETACTION_TABLE:
        return new XMLTableOOoTransformerContext_Impl( *this, rQName );
    default:
        OSL_ENSURE( false, "no user defined context found!" );
    }

    // default is copying
    return new XMLTransformerContext( *this, rQName );
}

XMLTransformerActions *OOo2OasisTransformer::GetUserDefinedActions(
        sal_uInt16 n )
{
    XMLTransformerActions *pActions = nullptr;
    if( n < MAX_OOO_ACTIONS )
    {
        if( !m_aActions[n] )
        {
            if( n<MAX_OOO_PROP_ACTIONS )
            {
                m_aActions[n].reset(
                    XMLStyleOOoTContext::CreateTransformerActions( n ) );
            }
            else switch( n )
            {
                case OOO_STYLE_ACTIONS:
                    m_aActions[OOO_STYLE_ACTIONS].reset(
                        new XMLTransformerActions( aStyleActionTable ) );
                    break;
                case OOO_FONT_DECL_ACTIONS:
                    m_aActions[OOO_FONT_DECL_ACTIONS].reset(
                        new XMLTransformerActions( aFontDeclActionTable ) );
                    break;
                case OOO_SHAPE_ACTIONS:
                    m_aActions[OOO_SHAPE_ACTIONS].reset(
                        new XMLTransformerActions( aShapeActionTable ) );
                    break;
                case OOO_CONNECTOR_ACTIONS:
                    m_aActions[OOO_CONNECTOR_ACTIONS].reset(
                        new XMLTransformerActions( aConnectorActionTable ) );
                    break;
                case OOO_TAB_STOP_ACTIONS:
                    m_aActions[OOO_TAB_STOP_ACTIONS].reset(
                        new XMLTransformerActions( aTabStopActionTable ) );
                    break;
                case OOO_INDEX_ENTRY_TAB_STOP_ACTIONS:
                    m_aActions[OOO_INDEX_ENTRY_TAB_STOP_ACTIONS].reset(
                        new XMLTransformerActions( aIndexEntryTabStopActionTable ) );
                    break;
                case OOO_LINENUMBERING_ACTIONS:
                    m_aActions[OOO_LINENUMBERING_ACTIONS].reset(
                        new XMLTransformerActions( aLineNumberingActionTable ) );
                    break;
                case OOO_FOOTNOTE_SEP_ACTIONS:
                    m_aActions[OOO_FOOTNOTE_SEP_ACTIONS].reset(
                        new XMLTransformerActions( aFootnoteSepActionTable ) );
                    break;
                case OOO_DROP_CAP_ACTIONS:
                    m_aActions[OOO_DROP_CAP_ACTIONS].reset(
                        new XMLTransformerActions( aDropCapActionTable ) );
                    break;
                case OOO_COLUMNS_ACTIONS:
                    m_aActions[OOO_COLUMNS_ACTIONS].reset(
                        new XMLTransformerActions( aColumnsActionTable ) );
                    break;
                case OOO_TEXT_VALUE_TYPE_ACTIONS:
                    m_aActions[OOO_TEXT_VALUE_TYPE_ACTIONS].reset(
                        new XMLTransformerActions( aTextValueTypeActionTable ) );
                    break;
                case OOO_TABLE_VALUE_TYPE_ACTIONS:
                    m_aActions[OOO_TABLE_VALUE_TYPE_ACTIONS].reset(
                        new XMLTransformerActions( aTableValueTypeActionTable ) );
                    break;
                case OOO_PARA_ACTIONS:
                    m_aActions[OOO_PARA_ACTIONS].reset(
                        new XMLTransformerActions( aParaActionTable ) );
                    break;
                case OOO_STYLE_REF_ACTIONS:
                    m_aActions[OOO_STYLE_REF_ACTIONS].reset(
                        new XMLTransformerActions( aStyleRefActionTable ) );
                    break;
                case OOO_MASTER_PAGE_ACTIONS:
                    m_aActions[OOO_MASTER_PAGE_ACTIONS].reset(
                        new XMLTransformerActions( aMasterPageActionTable ) );
                    break;
                case OOO_ANNOTATION_ACTIONS:
                    m_aActions[OOO_ANNOTATION_ACTIONS].reset(
                        new XMLTransformerActions( aAnnotationActionTable ) );
                    break;
                case OOO_CHANGE_INFO_ACTIONS:
                    m_aActions[OOO_CHANGE_INFO_ACTIONS].reset(
                        new XMLTransformerActions( aChangeInfoActionTable ) );
                    break;
                case OOO_FRAME_ELEM_ACTIONS:
                    m_aActions[OOO_FRAME_ELEM_ACTIONS].reset(
                        new XMLTransformerActions( aFrameElemActionTable ) );
                    break;
                case OOO_FRAME_ATTR_ACTIONS:
                    m_aActions[OOO_FRAME_ATTR_ACTIONS].reset(
                        new XMLTransformerActions( aFrameAttrActionTable ) );
                    break;
                case OOO_BACKGROUND_IMAGE_ACTIONS:
                    // Use special actions for Writer documents. (#i50322#)
                    m_aActions[OOO_BACKGROUND_IMAGE_ACTIONS].reset(
                        isWriter()
                        ? new XMLTransformerActions( aWriterBackgroundImageActionTable )
                        : new XMLTransformerActions( aBackgroundImageActionTable ) );
                    break;
                case OOO_DDE_CONNECTION_DECL_ACTIONS:
                    m_aActions[OOO_DDE_CONNECTION_DECL_ACTIONS].reset(
                        new XMLTransformerActions( aDDEConnectionDeclActionTable ) );
                    break;
                case OOO_EVENT_ACTIONS:
                    m_aActions[OOO_EVENT_ACTIONS].reset(
                        new XMLTransformerActions( aEventActionTable ) );
                    break;
                case OOO_FORM_CONTROL_ACTIONS:
                    m_aActions[OOO_FORM_CONTROL_ACTIONS].reset(
                        new XMLTransformerActions( aFormControlActionTable ) );
                    break;
                case OOO_FORM_COLUMN_ACTIONS:
                    m_aActions[OOO_FORM_COLUMN_ACTIONS].reset(
                        new XMLTransformerActions( aFormColumnActionTable ) );
                    break;
                case OOO_FORM_PROP_ACTIONS:
                    m_aActions[OOO_FORM_PROP_ACTIONS].reset(
                        new XMLTransformerActions( aFormPropActionTable ) );
                    break;
                case OOO_XLINK_ACTIONS:
                    m_aActions[OOO_XLINK_ACTIONS].reset(
                        new XMLTransformerActions( aXLinkActionTable ) );
                    break;
                case OOO_CONFIG_ITEM_SET_ACTIONS:
                    m_aActions[OOO_CONFIG_ITEM_SET_ACTIONS].reset(
                        new XMLTransformerActions( aConfigItemSetActionTable ) );
                    break;
                case OOO_FORMULA_ACTIONS:
                    m_aActions[OOO_FORMULA_ACTIONS].reset(
                        new XMLTransformerActions( aFormulaActionTable ) );
                    break;
                case OOO_CHART_ACTIONS:
                    m_aActions[OOO_CHART_ACTIONS].reset(
                        new XMLTransformerActions( aChartActionTable ) );
                    break;
                case OOO_ERROR_MACRO_ACTIONS:
                    m_aActions[OOO_ERROR_MACRO_ACTIONS].reset(
                        new XMLTransformerActions( aErrorMacroActionTable ) );
                    break;
                case OOO_DDE_CONV_MODE_ACTIONS:
                    m_aActions[OOO_DDE_CONV_MODE_ACTIONS].reset(
                        new XMLTransformerActions( aDDEConvModeActionTable ) );
                    break;
                case OOO_ALPHABETICAL_INDEX_MARK_ACTIONS:
                    m_aActions[OOO_ALPHABETICAL_INDEX_MARK_ACTIONS].reset(
                        new XMLTransformerActions( aAlphabeticalIndexMarkActionTable ) );
                    break;
                case OOO_DATAPILOT_MEMBER_ACTIONS:
                    m_aActions[OOO_DATAPILOT_MEMBER_ACTIONS].reset(
                        new XMLTransformerActions( aDataPilotMemberActionTable ) );
                    break;
                case OOO_DATAPILOT_LEVEL_ACTIONS:
                    m_aActions[OOO_DATAPILOT_LEVEL_ACTIONS].reset(
                        new XMLTransformerActions( aDataPilotLevelActionTable ) );
                    break;
                case OOO_SOURCE_SERVICE_ACTIONS:
                    m_aActions[OOO_SOURCE_SERVICE_ACTIONS].reset(
                        new XMLTransformerActions( aSourceServiceActionTable ) );
                    break;
                case OOO_DRAW_AREA_POLYGON_ACTIONS:
                    m_aActions[OOO_DRAW_AREA_POLYGON_ACTIONS].reset(
                        new XMLTransformerActions( aShapeActionTable ) );
                    m_aActions[OOO_DRAW_AREA_POLYGON_ACTIONS]
                        ->Add( aDrawAreaPolygonActionTable );
                    break;
                case OOO_SCRIPT_ACTIONS:
                    m_aActions[OOO_SCRIPT_ACTIONS].reset(
                        new XMLTransformerActions( aScriptActionTable ) );
                    break;
                case OOO_ANIMATION_ACTIONS:
                    m_aActions[OOO_ANIMATION_ACTIONS].reset(
                        new XMLTransformerActions( aAnimationsActionTable ) );
                    break;
            }
        }
        pActions = m_aActions[n].get();
    }

    return pActions;
}

OUString OOo2OasisTransformer::GetEventName( const OUString& rName, bool )
{
    if( !m_pEventMap )
        m_pEventMap = XMLEventOOoTransformerContext::CreateEventMap();

    OUString aNewName;
    sal_uInt16 nPrefix = XMLEventOOoTransformerContext::GetEventName( rName,
                                                    aNewName, *m_pEventMap );
    if( XML_NAMESPACE_UNKNOWN != nPrefix )
        aNewName = GetNamespaceMap().GetQNameByKey( nPrefix, aNewName );
    else
        aNewName = rName;

    return aNewName;
}

OOo2OasisTransformer::OOo2OasisTransformer( OUString aImplName,
                                            OUString aSubServiceName )
        noexcept :
    XMLTransformerBase( aActionTable, aTokenMap ),
    m_aImplName(std::move(aImplName)),
    m_aSubServiceName(std::move(aSubServiceName)),
    m_pEventMap( nullptr )
{
    GetNamespaceMap().Add( GetXMLToken(XML_NP_OFFICE), GetXMLToken(XML_N_OFFICE_OOO), XML_NAMESPACE_OFFICE );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_OFFICE), GetXMLToken(XML_N_OFFICE), XML_NAMESPACE_OFFICE );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_META), GetXMLToken(XML_N_META_OOO), XML_NAMESPACE_META );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_META), GetXMLToken(XML_N_META), XML_NAMESPACE_META );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_STYLE), GetXMLToken(XML_N_STYLE_OOO), XML_NAMESPACE_STYLE );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_STYLE), GetXMLToken(XML_N_STYLE), XML_NAMESPACE_STYLE );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_NUMBER), GetXMLToken(XML_N_NUMBER_OOO), XML_NAMESPACE_NUMBER );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_NUMBER), GetXMLToken(XML_N_NUMBER), XML_NAMESPACE_NUMBER );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_CONFIG), GetXMLToken(XML_N_CONFIG_OOO), XML_NAMESPACE_CONFIG );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_CONFIG), GetXMLToken(XML_N_CONFIG), XML_NAMESPACE_CONFIG );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_TEXT), GetXMLToken(XML_N_TEXT_OOO), XML_NAMESPACE_TEXT );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_TEXT), GetXMLToken(XML_N_TEXT), XML_NAMESPACE_TEXT );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_TABLE), GetXMLToken(XML_N_TABLE_OOO), XML_NAMESPACE_TABLE );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_TABLE), GetXMLToken(XML_N_TABLE), XML_NAMESPACE_TABLE );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_DRAW), GetXMLToken(XML_N_DRAW_OOO), XML_NAMESPACE_DRAW );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_DRAW), GetXMLToken(XML_N_DRAW), XML_NAMESPACE_DRAW );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_DR3D), GetXMLToken(XML_N_DR3D_OOO), XML_NAMESPACE_DR3D );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_DR3D), GetXMLToken(XML_N_DR3D), XML_NAMESPACE_DR3D );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_PRESENTATION), GetXMLToken(XML_N_PRESENTATION_OOO), XML_NAMESPACE_PRESENTATION );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_PRESENTATION), GetXMLToken(XML_N_PRESENTATION), XML_NAMESPACE_PRESENTATION );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_CHART), GetXMLToken(XML_N_CHART_OOO), XML_NAMESPACE_CHART );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_CHART), GetXMLToken(XML_N_CHART), XML_NAMESPACE_CHART );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_FORM), GetXMLToken(XML_N_FORM_OOO), XML_NAMESPACE_FORM );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_FORM), GetXMLToken(XML_N_FORM), XML_NAMESPACE_FORM );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_SCRIPT), GetXMLToken(XML_N_SCRIPT_OOO), XML_NAMESPACE_SCRIPT );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_SCRIPT), GetXMLToken(XML_N_SCRIPT), XML_NAMESPACE_SCRIPT );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_FO), GetXMLToken(XML_N_FO), XML_NAMESPACE_FO );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_FO), GetXMLToken(XML_N_FO_COMPAT), XML_NAMESPACE_FO );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_SVG), GetXMLToken(XML_N_SVG),  XML_NAMESPACE_SVG );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_SVG), GetXMLToken(XML_N_SVG_COMPAT), XML_NAMESPACE_SVG );

    for(auto & rp : m_aActions)
        rp.reset();
}

OOo2OasisTransformer::~OOo2OasisTransformer() noexcept
{
    for(auto & rp : m_aActions)
        rp.reset();
    XMLEventOOoTransformerContext::FlushEventMap( m_pEventMap );
}

Any OOo2OasisTransformer::queryInterface( const Type& rType )
{
    Any aRet;
    if ( rType == cppu::UnoType<XImporter>::get())
    {
        Reference<XImporter> xThis( this );
        aRet <<= xThis;
    }
    else if ( rType == cppu::UnoType<XFilter>::get())
    {
        Reference<XFilter> xThis( this );
        aRet <<= xThis;
    }
    else
    {
        aRet = XMLTransformerBase::queryInterface(rType);
    }

    return aRet;
}

// XImporter
void SAL_CALL OOo2OasisTransformer::setTargetDocument(
        const Reference< XComponent >& xDoc )
{
    if( !GetDocHandler().is() )
    {
        // if initialize hasn't been called, then we have to call it now
        // to get the sub component initialized.
        Sequence<Any> aArgs( 0 );
        Initialize( aArgs );
    }

    mxModel.set( xDoc, UNO_QUERY );

    Reference< XImporter > xImp( GetDocHandler(), UNO_QUERY );
    OSL_ENSURE( xImp.is(), "doc handler is not an importer" );
    if( xImp.is() )
        xImp->setTargetDocument( xDoc );
}

// XFilter
sal_Bool SAL_CALL OOo2OasisTransformer::filter(
        const Sequence< PropertyValue >& aDescriptor )
{
    Reference< XFilter> xFilter( GetDocHandler(), UNO_QUERY );
    OSL_ENSURE( xFilter.is(), "doc handler is not a filter" );
    if( xFilter.is() )
        return xFilter->filter( aDescriptor );

    return false;
}

void SAL_CALL OOo2OasisTransformer::cancel(  )
{
    Reference< XFilter> xFilter( GetDocHandler(), UNO_QUERY );
    OSL_ENSURE( xFilter.is(), "doc handler is not a filter" );
    if( xFilter.is() )
        xFilter->cancel();
}

// XInitialize
void SAL_CALL OOo2OasisTransformer::initialize(
                const Sequence< Any >& rArguments )
{
    Initialize( rArguments );
}

void SAL_CALL OOo2OasisTransformer::startDocument()
{
    if( !GetDocHandler().is() )
    {
        // if initialize hasn't been called, then we have to call it now
        // to get the sub component initialized.
        Sequence<Any> aArgs( 0 );
        Initialize( aArgs );
    }

    XMLTransformerBase::startDocument();
}

void OOo2OasisTransformer::Initialize(
                const Sequence< Any >& rArguments )
{
    OSL_ENSURE( !GetDocHandler().is(), "duplication initialization" );

    Reference< XInterface > xFilter;
    if( !m_aSubServiceName.isEmpty() )
    {
        Reference< XComponentContext > xContext = comphelper::getProcessComponentContext();
        // get filter component
        xFilter =
            xContext->getServiceManager()->createInstanceWithArgumentsAndContext(m_aSubServiceName, rArguments, xContext);
        SAL_WARN_IF(!xFilter, "xmloff", "could not instantiate " << m_aSubServiceName);
    }
    else
        SAL_WARN("xmloff", "no subservice name");

    if (xFilter.is())
    {
        Sequence<Any> aArgs( 1 + rArguments.getLength() );
        auto pArgs = aArgs.getArray();
        pArgs[0] <<= xFilter;
        std::copy(rArguments.begin(), rArguments.end(), std::next(pArgs));
        XMLTransformerBase::initialize( aArgs );

        OSL_ENSURE( GetDocHandler() == xFilter,
                    "duplicate doc handler" );
    }
    else
    {
        XMLTransformerBase::initialize( rArguments );
    }
}

// XServiceInfo
OUString SAL_CALL OOo2OasisTransformer::getImplementationName()
{
    return m_aImplName;
}

sal_Bool SAL_CALL OOo2OasisTransformer::supportsService( const OUString& ServiceName )
{
    return cppu::supportsService(this, ServiceName);
}

Sequence< OUString > SAL_CALL OOo2OasisTransformer::getSupportedServiceNames(  )
{
    return { };
}

// XTypeProvider
Sequence< css::uno::Type > SAL_CALL OOo2OasisTransformer::getTypes()
{
    return cppu::OTypeCollection(
            cppu::UnoType<XImporter>::get(),
            cppu::UnoType<XFilter>::get(),
            XMLTransformerBase::getTypes()
        ).getTypes();
}

// Service registration

extern "C" SAL_DLLPUBLIC_EXPORT css::uno::XInterface*
xmloff_OOo2OasisTransformer_get_implementation(
    css::uno::XComponentContext* , css::uno::Sequence<css::uno::Any> const&)
{
    return cppu::acquire(new OOo2OasisTransformer("com.sun.star.comp.OOo2OasisTransformer", OUString()));
}

#define OOO_IMPORTER( xml_className_get_impl, implName, subServiceName )             \
extern "C" SAL_DLLPUBLIC_EXPORT css::uno::XInterface* \
xml_className_get_impl( \
    css::uno::XComponentContext* , css::uno::Sequence<css::uno::Any> const&) \
{ \
    return cppu::acquire(new OOo2OasisTransformer( \
              implName, \
              subServiceName )); \
}

OOO_IMPORTER( xmloff_XMLWriterImportOOO_get_implementation,
              "com.sun.star.comp.Writer.XMLImporter",
              "com.sun.star.comp.Writer.XMLOasisImporter" )
OOO_IMPORTER( xmloff_XMLWriterStylesImportOOO_get_implementation,
              "com.sun.star.comp.Writer.XMLStylesImporter",
              "com.sun.star.comp.Writer.XMLOasisStylesImporter" )
OOO_IMPORTER( xmloff_XMLWriterContentImportOOO_get_implementation,
              "com.sun.star.comp.Writer.XMLContentImporter",
              "com.sun.star.comp.Writer.XMLOasisContentImporter" )
OOO_IMPORTER( xmloff_XMLWriterMetaImportOOO_get_implementation,
              "com.sun.star.comp.Writer.XMLMetaImporter",
              "com.sun.star.comp.Writer.XMLOasisMetaImporter" )
OOO_IMPORTER( xmloff_XMLWriterSettingsImportOOO_get_implementation,
              "com.sun.star.comp.Writer.XMLSettingsImporter",
              "com.sun.star.comp.Writer.XMLOasisSettingsImporter" )

OOO_IMPORTER( xmloff_XMLImpressImportOOO_get_implementation,
              "com.sun.star.comp.Impress.XMLImporter",
              "com.sun.star.comp.Impress.XMLOasisImporter" )
OOO_IMPORTER( xmloff_XMLImpressStylesImportOOO_get_implementation,
              "com.sun.star.comp.Impress.XMLStylesImporter",
              "com.sun.star.comp.Impress.XMLOasisStylesImporter" )
OOO_IMPORTER( xmloff_XMLImpressContentImportOOO_get_implementation,
              "com.sun.star.comp.Impress.XMLContentImporter",
              "com.sun.star.comp.Impress.XMLOasisContentImporter" )
OOO_IMPORTER( xmloff_XMLImpressMetaImportOOO_get_implementation,
              "com.sun.star.comp.Impress.XMLMetaImporter",
              "com.sun.star.comp.Impress.XMLOasisMetaImporter" )
OOO_IMPORTER( xmloff_XMLImpressSettingsImportOOO_get_implementation,
              "com.sun.star.comp.Impress.XMLSettingsImporter",
              "com.sun.star.comp.Impress.XMLOasisSettingsImporter" )

OOO_IMPORTER( xmloff_XMLDrawImportOOO_get_implementation,
              "com.sun.star.comp.Draw.XMLImporter",
              "com.sun.star.comp.Draw.XMLOasisImporter" )
OOO_IMPORTER( xmloff_XMLDrawStylesImportOOO_get_implementation,
              "com.sun.star.comp.Draw.XMLStylesImporter",
              "com.sun.star.comp.Draw.XMLOasisStylesImporter" )
OOO_IMPORTER( xmloff_XMLDrawContentImportOOO_get_implementation,
              "com.sun.star.comp.Draw.XMLContentImporter",
              "com.sun.star.comp.Draw.XMLOasisContentImporter" )
OOO_IMPORTER( xmloff_XMLDrawMetaImportOOO_get_implementation,
              "com.sun.star.comp.Draw.XMLMetaImporter",
              "com.sun.star.comp.Draw.XMLOasisMetaImporter" )
OOO_IMPORTER( xmloff_XMLDrawSettingsImportOOO_get_implementation,
              "com.sun.star.comp.Draw.XMLSettingsImporter",
              "com.sun.star.comp.Draw.XMLOasisSettingsImporter" )

OOO_IMPORTER( xmloff_XMLCalcImportOOO_get_implementation,
              "com.sun.star.comp.Calc.XMLImporter",
              "com.sun.star.comp.Calc.XMLOasisImporter" )
OOO_IMPORTER( xmloff_XMLCalcStylesImportOOO_get_implementation,
              "com.sun.star.comp.Calc.XMLStylesImporter",
              "com.sun.star.comp.Calc.XMLOasisStylesImporter" )
OOO_IMPORTER( xmloff_XMLCalcContentImportOOO_get_implementation,
              "com.sun.star.comp.Calc.XMLContentImporter",
              "com.sun.star.comp.Calc.XMLOasisContentImporter" )
OOO_IMPORTER( xmloff_XMLCalcMetaImportOOO_get_implementation,
              "com.sun.star.comp.Calc.XMLMetaImporter",
              "com.sun.star.comp.Calc.XMLOasisMetaImporter" )
OOO_IMPORTER( xmloff_XMLCalcSettingsImportOOO_get_implementation,
              "com.sun.star.comp.Calc.XMLSettingsImporter",
              "com.sun.star.comp.Calc.XMLOasisSettingsImporter" )

OOO_IMPORTER( xmloff_XMLChartImportOOO_get_implementation,
              "com.sun.star.comp.Chart.XMLImporter",
              "com.sun.star.comp.Chart.XMLOasisImporter" )
OOO_IMPORTER( xmloff_XMLChartStylesImportOOO_get_implementation,
              "com.sun.star.comp.Chart.XMLStylesImporter",
              "com.sun.star.comp.Chart.XMLOasisStylesImporter" )
OOO_IMPORTER( xmloff_XMLChartContentImportOOO_get_implementation,
              "com.sun.star.comp.Chart.XMLContentImporter",
              "com.sun.star.comp.Chart.XMLOasisContentImporter" )

OOO_IMPORTER( xmloff_XMLMathMetaImportOOO_get_implementation,
              "com.sun.star.comp.Math.XMLMetaImporter",
              "com.sun.star.comp.Math.XMLOasisMetaImporter" )
OOO_IMPORTER( xmloff_XMLMathSettingsImportOOO_get_implementation,
              "com.sun.star.comp.Math.XMLSettingsImporter",
              "com.sun.star.comp.Math.XMLOasisSettingsImporter" )

OOO_IMPORTER( xmloff_XMLMetaImportOOO_get_implementation,
              "com.sun.star.document.XMLMetaImporter",
              "com.sun.star.document.XMLOasisMetaImporter" )

OOO_IMPORTER( xmloff_XMLAutoTextEventImportOOO_get_implementation,
              "com.sun.star.comp.Writer.XMLAutotextEventsImporter",
              "com.sun.star.comp.Writer.XMLOasisAutotextEventsImporter" )

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
