/*
 * java-gnome, a UI library for writing GTK and GNOME programs from Java!
 *
 * Copyright © 2007-2010 Operational Dynamics Consulting, Pty Ltd and Others
 *
 * The code in this file, and the program it is a part of, is made available
 * to you by its authors as open source software: you can redistribute it
 * and/or modify it under the terms of the GNU General Public License version
 * 2 ("GPL") as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GPL for more details.
 *
 * You should have received a copy of the GPL along with this program. If not,
 * see http://www.gnu.org/licenses/. The authors of this program may be
 * contacted through http://java-gnome.sourceforge.net/.
 */
package com.operationaldynamics.codegen;

import com.operationaldynamics.driver.DefsFile;

/**
 * Output the code corresponding to a GObject method definition. See
 * {@link MethodBlock} for an example of a (define-method ...) stanza.
 * 
 * <p>
 * Code generated by this class will be used as:
 * 
 * <pre>
 * public setLabel(String label) {
 *     GtkButton.setLabel(this, label);
 * }
 * </pre>
 * 
 * in the public API wrapper classes to be written by the bindings hackers.
 * 
 * @author Andrew Cowie
 */
public class MethodGenerator extends FunctionGenerator
{
    /**
     * @param gObjectType
     * @param blockName
     * @param gReturnType
     * @param gFunctionName
     * @param gParameters
     */
    public MethodGenerator(final DefsFile data, final String blockName, final String gReturnType,
            final String gFunctionName, final String[][] gParameters, char callerOwnsReturn) {
        super(data, blockName, gReturnType, gFunctionName, gParameters, callerOwnsReturn);
    }
}
