---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Server-side code injection (PHP)

## Description

The target application was found vulnerable to code injection. A malicious actor could inject arbitrary
PHP code to be executed on the server. This could lead to a full system compromise by accessing
stored secrets, injecting code to take over accounts, or executing OS commands.

## Remediation

Never pass user input directly into functions which evaluate string data as code, such as `eval`.
There is almost no benefit of passing string values to `eval`, as such the best recommendation is
to replace the current logic with more safe implementations of dynamically evaluating logic with
user input. One alternative is to use an `array()`, storing expected user inputs in an array
key, and use that key as a look up to execute functions:

```php
$func_to_run = function()
{
    print('hello world');
};

$function_map = array();
$function_map["fn"] = $func_to_run; // store additional input to function mappings here

$input = "fn";

// lookup "fn" as the key
if (array_key_exists($input, $function_map)) {
    // run the $func_to_run that was stored in the "fn" array hash value.
    $func = $function_map[$input];
    $func();
} else {
    print('invalid input');
}
```

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 94.1 | false | 94 | Active | high |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/94.html)
- [OWASP](https://owasp.org/www-community/attacks/Code_Injection)
