// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a snapshot of the current Region, including whether Amazon Security
// Lake is enabled for those accounts and which sources Security Lake is collecting
// data from.
func (c *Client) GetDataLakeSources(ctx context.Context, params *GetDataLakeSourcesInput, optFns ...func(*Options)) (*GetDataLakeSourcesOutput, error) {
	if params == nil {
		params = &GetDataLakeSourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDataLakeSources", params, optFns, c.addOperationGetDataLakeSourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDataLakeSourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDataLakeSourcesInput struct {

	// The Amazon Web Services account ID for which a static snapshot of the current
	// Amazon Web Services Region, including enabled accounts and log sources, is
	// retrieved.
	Accounts []string

	// The maximum limit of accounts for which the static snapshot of the current
	// Region, including enabled accounts and log sources, is retrieved.
	MaxResults *int32

	// Lists if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token to
	// retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination token
	// will return an HTTP 400 InvalidToken error.
	NextToken *string

	noSmithyDocumentSerde
}

type GetDataLakeSourcesOutput struct {

	// The Amazon Resource Name (ARN) created by you to provide to the subscriber. For
	// more information about ARNs and how to use them in policies, see the [Amazon Security Lake User Guide].
	//
	// [Amazon Security Lake User Guide]: https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html
	DataLakeArn *string

	// The list of enabled accounts and enabled sources.
	DataLakeSources []types.DataLakeSource

	// Lists if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token to
	// retrieve the next page. Keep all other arguments unchanged.
	//
	// Each pagination token expires after 24 hours. Using an expired pagination token
	// will return an HTTP 400 InvalidToken error.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDataLakeSourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDataLakeSources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDataLakeSources{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDataLakeSources"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDataLakeSources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetDataLakeSourcesAPIClient is a client that implements the GetDataLakeSources
// operation.
type GetDataLakeSourcesAPIClient interface {
	GetDataLakeSources(context.Context, *GetDataLakeSourcesInput, ...func(*Options)) (*GetDataLakeSourcesOutput, error)
}

var _ GetDataLakeSourcesAPIClient = (*Client)(nil)

// GetDataLakeSourcesPaginatorOptions is the paginator options for
// GetDataLakeSources
type GetDataLakeSourcesPaginatorOptions struct {
	// The maximum limit of accounts for which the static snapshot of the current
	// Region, including enabled accounts and log sources, is retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetDataLakeSourcesPaginator is a paginator for GetDataLakeSources
type GetDataLakeSourcesPaginator struct {
	options   GetDataLakeSourcesPaginatorOptions
	client    GetDataLakeSourcesAPIClient
	params    *GetDataLakeSourcesInput
	nextToken *string
	firstPage bool
}

// NewGetDataLakeSourcesPaginator returns a new GetDataLakeSourcesPaginator
func NewGetDataLakeSourcesPaginator(client GetDataLakeSourcesAPIClient, params *GetDataLakeSourcesInput, optFns ...func(*GetDataLakeSourcesPaginatorOptions)) *GetDataLakeSourcesPaginator {
	if params == nil {
		params = &GetDataLakeSourcesInput{}
	}

	options := GetDataLakeSourcesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetDataLakeSourcesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetDataLakeSourcesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetDataLakeSources page.
func (p *GetDataLakeSourcesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetDataLakeSourcesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetDataLakeSources(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetDataLakeSources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDataLakeSources",
	}
}
