// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the job executions for a job.
//
// Requires permission to access the [ListJobExecutionsForJob] action.
//
// [ListJobExecutionsForJob]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions
func (c *Client) ListJobExecutionsForJob(ctx context.Context, params *ListJobExecutionsForJobInput, optFns ...func(*Options)) (*ListJobExecutionsForJobOutput, error) {
	if params == nil {
		params = &ListJobExecutionsForJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListJobExecutionsForJob", params, optFns, c.addOperationListJobExecutionsForJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListJobExecutionsForJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListJobExecutionsForJobInput struct {

	// The unique identifier you assigned to this job when it was created.
	//
	// This member is required.
	JobId *string

	// The maximum number of results to be returned per request.
	MaxResults *int32

	// The token to retrieve the next set of results.
	NextToken *string

	// The status of the job.
	Status types.JobExecutionStatus

	noSmithyDocumentSerde
}

type ListJobExecutionsForJobOutput struct {

	// A list of job execution summaries.
	ExecutionSummaries []types.JobExecutionSummaryForJob

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListJobExecutionsForJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListJobExecutionsForJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListJobExecutionsForJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListJobExecutionsForJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListJobExecutionsForJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListJobExecutionsForJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListJobExecutionsForJobAPIClient is a client that implements the
// ListJobExecutionsForJob operation.
type ListJobExecutionsForJobAPIClient interface {
	ListJobExecutionsForJob(context.Context, *ListJobExecutionsForJobInput, ...func(*Options)) (*ListJobExecutionsForJobOutput, error)
}

var _ ListJobExecutionsForJobAPIClient = (*Client)(nil)

// ListJobExecutionsForJobPaginatorOptions is the paginator options for
// ListJobExecutionsForJob
type ListJobExecutionsForJobPaginatorOptions struct {
	// The maximum number of results to be returned per request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListJobExecutionsForJobPaginator is a paginator for ListJobExecutionsForJob
type ListJobExecutionsForJobPaginator struct {
	options   ListJobExecutionsForJobPaginatorOptions
	client    ListJobExecutionsForJobAPIClient
	params    *ListJobExecutionsForJobInput
	nextToken *string
	firstPage bool
}

// NewListJobExecutionsForJobPaginator returns a new
// ListJobExecutionsForJobPaginator
func NewListJobExecutionsForJobPaginator(client ListJobExecutionsForJobAPIClient, params *ListJobExecutionsForJobInput, optFns ...func(*ListJobExecutionsForJobPaginatorOptions)) *ListJobExecutionsForJobPaginator {
	if params == nil {
		params = &ListJobExecutionsForJobInput{}
	}

	options := ListJobExecutionsForJobPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListJobExecutionsForJobPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListJobExecutionsForJobPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListJobExecutionsForJob page.
func (p *ListJobExecutionsForJobPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListJobExecutionsForJobOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListJobExecutionsForJob(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListJobExecutionsForJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListJobExecutionsForJob",
	}
}
