// Code generated by smithy-go-codegen DO NOT EDIT.

package codedeploy

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the deployment configurations with the user or Amazon Web Services
// account.
func (c *Client) ListDeploymentConfigs(ctx context.Context, params *ListDeploymentConfigsInput, optFns ...func(*Options)) (*ListDeploymentConfigsOutput, error) {
	if params == nil {
		params = &ListDeploymentConfigsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDeploymentConfigs", params, optFns, c.addOperationListDeploymentConfigsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDeploymentConfigsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a ListDeploymentConfigs operation.
type ListDeploymentConfigsInput struct {

	// An identifier returned from the previous ListDeploymentConfigs call. It can be
	// used to return the next set of deployment configurations in the list.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListDeploymentConfigs operation.
type ListDeploymentConfigsOutput struct {

	// A list of deployment configurations, including built-in configurations such as
	// CodeDeployDefault.OneAtATime .
	DeploymentConfigsList []string

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list deployment configurations call to return the
	// next set of deployment configurations in the list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDeploymentConfigsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListDeploymentConfigs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListDeploymentConfigs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDeploymentConfigs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDeploymentConfigs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDeploymentConfigsAPIClient is a client that implements the
// ListDeploymentConfigs operation.
type ListDeploymentConfigsAPIClient interface {
	ListDeploymentConfigs(context.Context, *ListDeploymentConfigsInput, ...func(*Options)) (*ListDeploymentConfigsOutput, error)
}

var _ ListDeploymentConfigsAPIClient = (*Client)(nil)

// ListDeploymentConfigsPaginatorOptions is the paginator options for
// ListDeploymentConfigs
type ListDeploymentConfigsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDeploymentConfigsPaginator is a paginator for ListDeploymentConfigs
type ListDeploymentConfigsPaginator struct {
	options   ListDeploymentConfigsPaginatorOptions
	client    ListDeploymentConfigsAPIClient
	params    *ListDeploymentConfigsInput
	nextToken *string
	firstPage bool
}

// NewListDeploymentConfigsPaginator returns a new ListDeploymentConfigsPaginator
func NewListDeploymentConfigsPaginator(client ListDeploymentConfigsAPIClient, params *ListDeploymentConfigsInput, optFns ...func(*ListDeploymentConfigsPaginatorOptions)) *ListDeploymentConfigsPaginator {
	if params == nil {
		params = &ListDeploymentConfigsInput{}
	}

	options := ListDeploymentConfigsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDeploymentConfigsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDeploymentConfigsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDeploymentConfigs page.
func (p *ListDeploymentConfigsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDeploymentConfigsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	result, err := p.client.ListDeploymentConfigs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListDeploymentConfigs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDeploymentConfigs",
	}
}
