// Code generated by smithy-go-codegen DO NOT EDIT.

package chatbot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/chatbot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates Slack Channel Configuration
func (c *Client) CreateSlackChannelConfiguration(ctx context.Context, params *CreateSlackChannelConfigurationInput, optFns ...func(*Options)) (*CreateSlackChannelConfigurationOutput, error) {
	if params == nil {
		params = &CreateSlackChannelConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateSlackChannelConfiguration", params, optFns, c.addOperationCreateSlackChannelConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateSlackChannelConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateSlackChannelConfigurationInput struct {

	// The name of the configuration.
	//
	// This member is required.
	ConfigurationName *string

	// The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a
	// user-defined role that AWS Chatbot will assume. This is not the service-linked
	// role. For more information, see IAM Policies for AWS Chatbot.
	//
	// This member is required.
	IamRoleArn *string

	// The ID of the Slack channel. To get the ID, open Slack, right click on the
	// channel name in the left pane, then choose Copy Link. The channel ID is the
	// 9-character string at the end of the URL. For example, ABCBBLZZZ.
	//
	// This member is required.
	SlackChannelId *string

	// The ID of the Slack workspace authorized with AWS Chatbot.
	//
	// This member is required.
	SlackTeamId *string

	// The list of IAM policy ARNs that are applied as channel guardrails. The AWS
	// managed 'AdministratorAccess' policy is applied by default if this is not set.
	GuardrailPolicyArns []string

	// Logging levels include ERROR, INFO, or NONE.
	LoggingLevel *string

	// The name of the Slack Channel.
	SlackChannelName *string

	// The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
	SnsTopicArns []string

	// A list of tags to apply to the configuration.
	Tags []types.Tag

	// Enables use of a user role requirement in your chat configuration.
	UserAuthorizationRequired *bool

	noSmithyDocumentSerde
}

type CreateSlackChannelConfigurationOutput struct {

	// The configuration for a Slack channel configured with AWS Chatbot.
	ChannelConfiguration *types.SlackChannelConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateSlackChannelConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateSlackChannelConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateSlackChannelConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateSlackChannelConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateSlackChannelConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateSlackChannelConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateSlackChannelConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateSlackChannelConfiguration",
	}
}
