//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmachinelearningservices

import "time"

// AKS - A Machine Learning compute based on AKS.
type AKS struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// AKS properties
	Properties *AKSProperties `json:"properties,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type AKS.
func (a *AKS) GetCompute() *Compute {
	return &Compute{
		ComputeType:        a.ComputeType,
		ComputeLocation:    a.ComputeLocation,
		ProvisioningState:  a.ProvisioningState,
		Description:        a.Description,
		CreatedOn:          a.CreatedOn,
		ModifiedOn:         a.ModifiedOn,
		ResourceID:         a.ResourceID,
		ProvisioningErrors: a.ProvisioningErrors,
		IsAttachedCompute:  a.IsAttachedCompute,
		DisableLocalAuth:   a.DisableLocalAuth,
	}
}

// AKSProperties - AKS properties
type AKSProperties struct {
	// Number of agents
	AgentCount *int32 `json:"agentCount,omitempty"`

	// Agent virtual machine size
	AgentVMSize *string `json:"agentVmSize,omitempty"`

	// AKS networking configuration for vnet
	AksNetworkingConfiguration *AksNetworkingConfiguration `json:"aksNetworkingConfiguration,omitempty"`

	// Cluster full qualified domain name
	ClusterFqdn *string `json:"clusterFqdn,omitempty"`

	// Intended usage of the cluster
	ClusterPurpose *ClusterPurpose `json:"clusterPurpose,omitempty"`

	// Load Balancer Subnet
	LoadBalancerSubnet *string `json:"loadBalancerSubnet,omitempty"`

	// Load Balancer Type
	LoadBalancerType *LoadBalancerType `json:"loadBalancerType,omitempty"`

	// SSL configuration
	SSLConfiguration *SSLConfiguration `json:"sslConfiguration,omitempty"`

	// READ-ONLY; System services
	SystemServices []*SystemService `json:"systemServices,omitempty" azure:"ro"`
}

// AksComputeSecrets - Secrets related to a Machine Learning compute based on AKS.
type AksComputeSecrets struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	AdminKubeConfig *string `json:"adminKubeConfig,omitempty"`

	// Image registry pull secret.
	ImagePullSecretName *string `json:"imagePullSecretName,omitempty"`

	// Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	UserKubeConfig *string `json:"userKubeConfig,omitempty"`
}

// GetComputeSecrets implements the ComputeSecretsClassification interface for type AksComputeSecrets.
func (a *AksComputeSecrets) GetComputeSecrets() *ComputeSecrets {
	return &ComputeSecrets{
		ComputeType: a.ComputeType,
	}
}

// AksComputeSecretsProperties - Properties of AksComputeSecrets
type AksComputeSecretsProperties struct {
	// Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	AdminKubeConfig *string `json:"adminKubeConfig,omitempty"`

	// Image registry pull secret.
	ImagePullSecretName *string `json:"imagePullSecretName,omitempty"`

	// Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	UserKubeConfig *string `json:"userKubeConfig,omitempty"`
}

// AksNetworkingConfiguration - Advance configuration for AKS networking
type AksNetworkingConfiguration struct {
	// An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified
	// in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`

	// A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes
	// service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`

	// A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`

	// Virtual network subnet resource ID the compute nodes belong to
	SubnetID *string `json:"subnetId,omitempty"`
}

// AmlCompute - Properties(top level) of AmlCompute
type AmlCompute struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Properties of AmlCompute
	Properties *AmlComputeProperties `json:"properties,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type AmlCompute.
func (a *AmlCompute) GetCompute() *Compute {
	return &Compute{
		ComputeType:        a.ComputeType,
		ComputeLocation:    a.ComputeLocation,
		ProvisioningState:  a.ProvisioningState,
		Description:        a.Description,
		CreatedOn:          a.CreatedOn,
		ModifiedOn:         a.ModifiedOn,
		ResourceID:         a.ResourceID,
		ProvisioningErrors: a.ProvisioningErrors,
		IsAttachedCompute:  a.IsAttachedCompute,
		DisableLocalAuth:   a.DisableLocalAuth,
	}
}

// AmlComputeNodeInformation - Compute node information related to a AmlCompute.
type AmlComputeNodeInformation struct {
	// READ-ONLY; ID of the compute node.
	NodeID *string `json:"nodeId,omitempty" azure:"ro"`

	// READ-ONLY; State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
	NodeState *NodeState `json:"nodeState,omitempty" azure:"ro"`

	// READ-ONLY; SSH port number of the node.
	Port *int32 `json:"port,omitempty" azure:"ro"`

	// READ-ONLY; Private IP address of the compute node.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; Public IP address of the compute node.
	PublicIPAddress *string `json:"publicIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; ID of the Experiment running on the node, if any else null.
	RunID *string `json:"runId,omitempty" azure:"ro"`
}

// AmlComputeNodesInformation - Result of AmlCompute Nodes
type AmlComputeNodesInformation struct {
	// READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The collection of returned AmlCompute nodes details.
	Nodes []*AmlComputeNodeInformation `json:"nodes,omitempty" azure:"ro"`
}

// AmlComputeProperties - AML Compute properties
type AmlComputeProperties struct {
	// Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that
	// the compute nodes will have public IPs provisioned. false - Indicates that the
	// compute nodes will have a private endpoint and no public IPs.
	EnableNodePublicIP *bool `json:"enableNodePublicIp,omitempty"`

	// Network is isolated or not
	IsolatedNetwork *bool `json:"isolatedNetwork,omitempty"`

	// Compute OS Type
	OSType *OsType `json:"osType,omitempty"`

	// State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes
	// of the cluster. Enabled - Indicates that the public ssh port is open on all
	// nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is
	// defined, else is open all public nodes. It can be default only during cluster
	// creation time, after creation it will be either enabled or disabled.
	RemoteLoginPortPublicAccess *RemoteLoginPortPublicAccess `json:"remoteLoginPortPublicAccess,omitempty"`

	// Scale settings for AML Compute
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`

	// Virtual network subnet resource ID the compute nodes belong to.
	Subnet *ResourceID `json:"subnet,omitempty"`

	// Credentials for an administrator user account that will be created on each compute node.
	UserAccountCredentials *UserAccountCredentials `json:"userAccountCredentials,omitempty"`

	// Virtual Machine priority
	VMPriority *VMPriority `json:"vmPriority,omitempty"`

	// Virtual Machine Size
	VMSize *string `json:"vmSize,omitempty"`

	// Virtual Machine image for AML Compute - windows only
	VirtualMachineImage *VirtualMachineImage `json:"virtualMachineImage,omitempty"`

	// READ-ONLY; Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There
	// are no changes to the number of compute nodes in the compute in progress. A compute
	// enters this state when it is created and when no operations are being performed on the compute to change the number of
	// compute nodes. resizing - Indicates that the compute is resizing; that is,
	// compute nodes are being added to or removed from the compute.
	AllocationState *AllocationState `json:"allocationState,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute entered its current allocation state.
	AllocationStateTransitionTime *time.Time `json:"allocationStateTransitionTime,omitempty" azure:"ro"`

	// READ-ONLY; The number of compute nodes currently assigned to the compute.
	CurrentNodeCount *int32 `json:"currentNodeCount,omitempty" azure:"ro"`

	// READ-ONLY; Collection of errors encountered by various compute nodes during node setup.
	Errors []*ErrorResponse `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Counts of various node states on the compute.
	NodeStateCounts *NodeStateCounts `json:"nodeStateCounts,omitempty" azure:"ro"`

	// READ-ONLY; The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes
	// the target node count for the ongoing resize operation. If the allocationState is steady,
	// this property denotes the target node count for the previous resize operation.
	TargetNodeCount *int32 `json:"targetNodeCount,omitempty" azure:"ro"`
}

// AmlUserFeature - Features enabled for a workspace
type AmlUserFeature struct {
	// Describes the feature for user experience
	Description *string `json:"description,omitempty"`

	// Specifies the feature name
	DisplayName *string `json:"displayName,omitempty"`

	// Specifies the feature ID
	ID *string `json:"id,omitempty"`
}

// AssignedUser - A user that can be assigned to a compute instance.
type AssignedUser struct {
	// REQUIRED; User’s AAD Object Id.
	ObjectID *string `json:"objectId,omitempty"`

	// REQUIRED; User’s AAD Tenant Id.
	TenantID *string `json:"tenantId,omitempty"`
}

// AutoPauseProperties - Auto pause properties
type AutoPauseProperties struct {
	DelayInMinutes *int32 `json:"delayInMinutes,omitempty"`
	Enabled        *bool  `json:"enabled,omitempty"`
}

// AutoScaleProperties - Auto scale properties
type AutoScaleProperties struct {
	Enabled      *bool  `json:"enabled,omitempty"`
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`
}

// ClusterUpdateParameters - AmlCompute update parameters.
type ClusterUpdateParameters struct {
	// The properties of the amlCompute.
	Properties *ClusterUpdateProperties `json:"properties,omitempty"`
}

// ClusterUpdateProperties - The properties of a amlCompute that need to be updated.
type ClusterUpdateProperties struct {
	// Properties of ClusterUpdate
	Properties *ScaleSettingsInformation `json:"properties,omitempty"`
}

type Components1D3SwueSchemasComputeresourceAllof1 struct {
	// Compute properties
	Properties ComputeClassification `json:"properties,omitempty"`
}

// ComputeClassification provides polymorphic access to related types.
// Call the interface's GetCompute() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AKS, *AmlCompute, *Compute, *ComputeInstance, *DataFactory, *DataLakeAnalytics, *Databricks, *HDInsight, *Kubernetes,
// - *SynapseSpark, *VirtualMachine
type ComputeClassification interface {
	// GetCompute returns the Compute content of the underlying type.
	GetCompute() *Compute
}

// Compute - Machine Learning compute object.
type Compute struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type Compute.
func (c *Compute) GetCompute() *Compute { return c }

// ComputeClientBeginCreateOrUpdateOptions contains the optional parameters for the ComputeClient.BeginCreateOrUpdate method.
type ComputeClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ComputeClientBeginDeleteOptions contains the optional parameters for the ComputeClient.BeginDelete method.
type ComputeClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ComputeClientBeginRestartOptions contains the optional parameters for the ComputeClient.BeginRestart method.
type ComputeClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ComputeClientBeginStartOptions contains the optional parameters for the ComputeClient.BeginStart method.
type ComputeClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ComputeClientBeginStopOptions contains the optional parameters for the ComputeClient.BeginStop method.
type ComputeClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ComputeClientBeginUpdateOptions contains the optional parameters for the ComputeClient.BeginUpdate method.
type ComputeClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ComputeClientGetOptions contains the optional parameters for the ComputeClient.Get method.
type ComputeClientGetOptions struct {
	// placeholder for future optional parameters
}

// ComputeClientListKeysOptions contains the optional parameters for the ComputeClient.ListKeys method.
type ComputeClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// ComputeClientListNodesOptions contains the optional parameters for the ComputeClient.ListNodes method.
type ComputeClientListNodesOptions struct {
	// placeholder for future optional parameters
}

// ComputeClientListOptions contains the optional parameters for the ComputeClient.List method.
type ComputeClientListOptions struct {
	// Continuation token for pagination.
	Skip *string
}

// ComputeInstance - Properties(top level) of ComputeInstance
type ComputeInstance struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Properties of ComputeInstance
	Properties *ComputeInstanceProperties `json:"properties,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type ComputeInstance.
func (c *ComputeInstance) GetCompute() *Compute {
	return &Compute{
		ComputeType:        c.ComputeType,
		ComputeLocation:    c.ComputeLocation,
		ProvisioningState:  c.ProvisioningState,
		Description:        c.Description,
		CreatedOn:          c.CreatedOn,
		ModifiedOn:         c.ModifiedOn,
		ResourceID:         c.ResourceID,
		ProvisioningErrors: c.ProvisioningErrors,
		IsAttachedCompute:  c.IsAttachedCompute,
		DisableLocalAuth:   c.DisableLocalAuth,
	}
}

// ComputeInstanceApplication - Defines an Aml Instance application and its connectivity endpoint URI.
type ComputeInstanceApplication struct {
	// Name of the ComputeInstance application.
	DisplayName *string `json:"displayName,omitempty"`

	// Application' endpoint URI.
	EndpointURI *string `json:"endpointUri,omitempty"`
}

// ComputeInstanceConnectivityEndpoints - Defines all connectivity endpoints and properties for an ComputeInstance.
type ComputeInstanceConnectivityEndpoints struct {
	// READ-ONLY; Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
	PrivateIPAddress *string `json:"privateIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; Public IP Address of this ComputeInstance.
	PublicIPAddress *string `json:"publicIpAddress,omitempty" azure:"ro"`
}

// ComputeInstanceCreatedBy - Describes information on user who created this ComputeInstance.
type ComputeInstanceCreatedBy struct {
	// READ-ONLY; Uniquely identifies the user within his/her organization.
	UserID *string `json:"userId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the user.
	UserName *string `json:"userName,omitempty" azure:"ro"`

	// READ-ONLY; Uniquely identifies user' Azure Active Directory organization.
	UserOrgID *string `json:"userOrgId,omitempty" azure:"ro"`
}

// ComputeInstanceLastOperation - The last operation on ComputeInstance.
type ComputeInstanceLastOperation struct {
	// Name of the last operation.
	OperationName *OperationName `json:"operationName,omitempty"`

	// Operation status.
	OperationStatus *OperationStatus `json:"operationStatus,omitempty"`

	// Time of the last operation.
	OperationTime *time.Time `json:"operationTime,omitempty"`
}

// ComputeInstanceProperties - Compute Instance properties
type ComputeInstanceProperties struct {
	// Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator
	// can access applications on this compute instance. When Shared, any workspace
	// user can access applications on this instance depending on his/her assigned role.
	ApplicationSharingPolicy *ApplicationSharingPolicy `json:"applicationSharingPolicy,omitempty"`

	// The Compute Instance Authorization type. Available values are personal (default).
	ComputeInstanceAuthorizationType *ComputeInstanceAuthorizationType `json:"computeInstanceAuthorizationType,omitempty"`

	// Settings for a personal compute instance.
	PersonalComputeInstanceSettings *PersonalComputeInstanceSettings `json:"personalComputeInstanceSettings,omitempty"`

	// Specifies policy and settings for SSH access.
	SSHSettings *ComputeInstanceSSHSettings `json:"sshSettings,omitempty"`

	// Details of customized scripts to execute for setting up the cluster.
	SetupScripts *SetupScripts `json:"setupScripts,omitempty"`

	// Virtual network subnet resource ID the compute nodes belong to.
	Subnet *ResourceID `json:"subnet,omitempty"`

	// Virtual Machine Size
	VMSize *string `json:"vmSize,omitempty"`

	// READ-ONLY; Describes available applications and their endpoints on this ComputeInstance.
	Applications []*ComputeInstanceApplication `json:"applications,omitempty" azure:"ro"`

	// READ-ONLY; Describes all connectivity endpoints available for this ComputeInstance.
	ConnectivityEndpoints *ComputeInstanceConnectivityEndpoints `json:"connectivityEndpoints,omitempty" azure:"ro"`

	// READ-ONLY; Describes information on user who created this ComputeInstance.
	CreatedBy *ComputeInstanceCreatedBy `json:"createdBy,omitempty" azure:"ro"`

	// READ-ONLY; Collection of errors encountered on this ComputeInstance.
	Errors []*ErrorResponse `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; The last operation on ComputeInstance.
	LastOperation *ComputeInstanceLastOperation `json:"lastOperation,omitempty" azure:"ro"`

	// READ-ONLY; The current state of this ComputeInstance.
	State *ComputeInstanceState `json:"state,omitempty" azure:"ro"`
}

// ComputeInstanceSSHSettings - Specifies policy and settings for SSH access.
type ComputeInstanceSSHSettings struct {
	// Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
	AdminPublicKey *string `json:"adminPublicKey,omitempty"`

	// State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance.
	// Enabled - Indicates that the public ssh port is open and accessible
	// according to the VNet/subnet policy if applicable.
	SSHPublicAccess *SSHPublicAccess `json:"sshPublicAccess,omitempty"`

	// READ-ONLY; Describes the admin user name.
	AdminUserName *string `json:"adminUserName,omitempty" azure:"ro"`

	// READ-ONLY; Describes the port for connecting through SSH.
	SSHPort *int32 `json:"sshPort,omitempty" azure:"ro"`
}

// ComputeResource - Machine Learning compute object wrapped into ARM resource envelope.
type ComputeResource struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// Compute properties
	Properties ComputeClassification `json:"properties,omitempty"`

	// The sku of the workspace.
	SKU *SKU `json:"sku,omitempty"`

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ComputeSecretsClassification provides polymorphic access to related types.
// Call the interface's GetComputeSecrets() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AksComputeSecrets, *ComputeSecrets, *DatabricksComputeSecrets, *VirtualMachineSecrets
type ComputeSecretsClassification interface {
	// GetComputeSecrets returns the ComputeSecrets content of the underlying type.
	GetComputeSecrets() *ComputeSecrets
}

// ComputeSecrets - Secrets related to a Machine Learning compute. Might differ for every type of compute.
type ComputeSecrets struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`
}

// GetComputeSecrets implements the ComputeSecretsClassification interface for type ComputeSecrets.
func (c *ComputeSecrets) GetComputeSecrets() *ComputeSecrets { return c }

// ContainerResourceRequirements - The resource requirements for the container (cpu and memory).
type ContainerResourceRequirements struct {
	// The minimum amount of CPU cores to be used by the container. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	CPU *float64 `json:"cpu,omitempty"`

	// The maximum amount of CPU cores allowed to be used by the container. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	CPULimit *float64 `json:"cpuLimit,omitempty"`

	// The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
	Fpga *int32 `json:"fpga,omitempty"`

	// The number of GPU cores in the container.
	Gpu *int32 `json:"gpu,omitempty"`

	// The minimum amount of memory (in GB) to be used by the container. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`

	// The maximum amount of memory (in GB) allowed to be used by the container. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	MemoryInGBLimit *float64 `json:"memoryInGBLimit,omitempty"`
}

type CosmosDbSettings struct {
	// The throughput of the collections in cosmosdb database
	CollectionsThroughput *int32 `json:"collectionsThroughput,omitempty"`
}

// DataFactory - A DataFactory compute.
type DataFactory struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type DataFactory.
func (d *DataFactory) GetCompute() *Compute {
	return &Compute{
		ComputeType:        d.ComputeType,
		ComputeLocation:    d.ComputeLocation,
		ProvisioningState:  d.ProvisioningState,
		Description:        d.Description,
		CreatedOn:          d.CreatedOn,
		ModifiedOn:         d.ModifiedOn,
		ResourceID:         d.ResourceID,
		ProvisioningErrors: d.ProvisioningErrors,
		IsAttachedCompute:  d.IsAttachedCompute,
		DisableLocalAuth:   d.DisableLocalAuth,
	}
}

// DataLakeAnalytics - A DataLakeAnalytics compute.
type DataLakeAnalytics struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool                        `json:"disableLocalAuth,omitempty"`
	Properties       *DataLakeAnalyticsProperties `json:"properties,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type DataLakeAnalytics.
func (d *DataLakeAnalytics) GetCompute() *Compute {
	return &Compute{
		ComputeType:        d.ComputeType,
		ComputeLocation:    d.ComputeLocation,
		ProvisioningState:  d.ProvisioningState,
		Description:        d.Description,
		CreatedOn:          d.CreatedOn,
		ModifiedOn:         d.ModifiedOn,
		ResourceID:         d.ResourceID,
		ProvisioningErrors: d.ProvisioningErrors,
		IsAttachedCompute:  d.IsAttachedCompute,
		DisableLocalAuth:   d.DisableLocalAuth,
	}
}

type DataLakeAnalyticsProperties struct {
	// DataLake Store Account Name
	DataLakeStoreAccountName *string `json:"dataLakeStoreAccountName,omitempty"`
}

// Databricks - A DataFactory compute.
type Databricks struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Properties of Databricks
	Properties *DatabricksProperties `json:"properties,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type Databricks.
func (d *Databricks) GetCompute() *Compute {
	return &Compute{
		ComputeType:        d.ComputeType,
		ComputeLocation:    d.ComputeLocation,
		ProvisioningState:  d.ProvisioningState,
		Description:        d.Description,
		CreatedOn:          d.CreatedOn,
		ModifiedOn:         d.ModifiedOn,
		ResourceID:         d.ResourceID,
		ProvisioningErrors: d.ProvisioningErrors,
		IsAttachedCompute:  d.IsAttachedCompute,
		DisableLocalAuth:   d.DisableLocalAuth,
	}
}

// DatabricksComputeSecrets - Secrets related to a Machine Learning compute based on Databricks.
type DatabricksComputeSecrets struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// access token for databricks account.
	DatabricksAccessToken *string `json:"databricksAccessToken,omitempty"`
}

// GetComputeSecrets implements the ComputeSecretsClassification interface for type DatabricksComputeSecrets.
func (d *DatabricksComputeSecrets) GetComputeSecrets() *ComputeSecrets {
	return &ComputeSecrets{
		ComputeType: d.ComputeType,
	}
}

// DatabricksComputeSecretsProperties - Properties of Databricks Compute Secrets
type DatabricksComputeSecretsProperties struct {
	// access token for databricks account.
	DatabricksAccessToken *string `json:"databricksAccessToken,omitempty"`
}

// DatabricksProperties - Properties of Databricks
type DatabricksProperties struct {
	// Databricks access token
	DatabricksAccessToken *string `json:"databricksAccessToken,omitempty"`

	// Workspace Url
	WorkspaceURL *string `json:"workspaceUrl,omitempty"`
}

type DiagnoseRequestProperties struct {
	// Setting for diagnosing dependent application insights
	ApplicationInsights map[string]interface{} `json:"applicationInsights,omitempty"`

	// Setting for diagnosing dependent container registry
	ContainerRegistry map[string]interface{} `json:"containerRegistry,omitempty"`

	// Setting for diagnosing dns resolution
	DNSResolution map[string]interface{} `json:"dnsResolution,omitempty"`

	// Setting for diagnosing dependent key vault
	KeyVault map[string]interface{} `json:"keyVault,omitempty"`

	// Setting for diagnosing network security group
	Nsg map[string]interface{} `json:"nsg,omitempty"`

	// Setting for diagnosing unclassified category of problems
	Others map[string]interface{} `json:"others,omitempty"`

	// Setting for diagnosing resource lock
	ResourceLock map[string]interface{} `json:"resourceLock,omitempty"`

	// Setting for diagnosing dependent storage account
	StorageAccount map[string]interface{} `json:"storageAccount,omitempty"`

	// Setting for diagnosing user defined routing
	Udr map[string]interface{} `json:"udr,omitempty"`
}

type DiagnoseResponseResult struct {
	Value *DiagnoseResponseResultValue `json:"value,omitempty"`
}

type DiagnoseResponseResultValue struct {
	ApplicationInsightsResults []*DiagnoseResult `json:"applicationInsightsResults,omitempty"`
	ContainerRegistryResults   []*DiagnoseResult `json:"containerRegistryResults,omitempty"`
	DNSResolutionResults       []*DiagnoseResult `json:"dnsResolutionResults,omitempty"`
	KeyVaultResults            []*DiagnoseResult `json:"keyVaultResults,omitempty"`
	NetworkSecurityRuleResults []*DiagnoseResult `json:"networkSecurityRuleResults,omitempty"`
	OtherResults               []*DiagnoseResult `json:"otherResults,omitempty"`
	ResourceLockResults        []*DiagnoseResult `json:"resourceLockResults,omitempty"`
	StorageAccountResults      []*DiagnoseResult `json:"storageAccountResults,omitempty"`
	UserDefinedRouteResults    []*DiagnoseResult `json:"userDefinedRouteResults,omitempty"`
}

// DiagnoseResult - Result of Diagnose
type DiagnoseResult struct {
	// READ-ONLY; Code for workspace setup error
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Level of workspace setup error
	Level *DiagnoseResultLevel `json:"level,omitempty" azure:"ro"`

	// READ-ONLY; Message of workspace setup error
	Message *string `json:"message,omitempty" azure:"ro"`
}

// DiagnoseWorkspaceParameters - Parameters to diagnose a workspace
type DiagnoseWorkspaceParameters struct {
	// Value of Parameters
	Value *DiagnoseRequestProperties `json:"value,omitempty"`
}

type EncryptionProperty struct {
	// REQUIRED; Customer Key vault properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// REQUIRED; Indicates whether or not the encryption is enabled for the workspace.
	Status *EncryptionStatus `json:"status,omitempty"`

	// The identity that will be used to access the key vault for encryption at rest.
	Identity *IdentityForCmk `json:"identity,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// EstimatedVMPrice - The estimated price info for using a VM of a particular OS type, tier, etc.
type EstimatedVMPrice struct {
	// REQUIRED; Operating system type used by the VM.
	OSType *VMPriceOSType `json:"osType,omitempty"`

	// REQUIRED; The price charged for using the VM.
	RetailPrice *float64 `json:"retailPrice,omitempty"`

	// REQUIRED; The type of the VM.
	VMTier *VMTier `json:"vmTier,omitempty"`
}

// EstimatedVMPrices - The estimated price info for using a VM.
type EstimatedVMPrices struct {
	// REQUIRED; Three lettered code specifying the currency of the VM price. Example: USD
	BillingCurrency *BillingCurrency `json:"billingCurrency,omitempty"`

	// REQUIRED; The unit of time measurement for the specified VM price. Example: OneHour
	UnitOfMeasure *UnitOfMeasure `json:"unitOfMeasure,omitempty"`

	// REQUIRED; The list of estimated prices for using a VM of a particular OS type, tier, etc.
	Values []*EstimatedVMPrice `json:"values,omitempty"`
}

type ExternalFQDNResponse struct {
	Value []*FQDNEndpoints `json:"value,omitempty"`
}

type FQDNEndpoint struct {
	DomainName      *string               `json:"domainName,omitempty"`
	EndpointDetails []*FQDNEndpointDetail `json:"endpointDetails,omitempty"`
}

type FQDNEndpointDetail struct {
	Port *int32 `json:"port,omitempty"`
}

type FQDNEndpoints struct {
	Properties *FQDNEndpointsProperties `json:"properties,omitempty"`
}

type FQDNEndpointsProperties struct {
	Category  *string         `json:"category,omitempty"`
	Endpoints []*FQDNEndpoint `json:"endpoints,omitempty"`
}

// HDInsight - A HDInsight compute.
type HDInsight struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// HDInsight compute properties
	Properties *HDInsightProperties `json:"properties,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type HDInsight.
func (h *HDInsight) GetCompute() *Compute {
	return &Compute{
		ComputeType:        h.ComputeType,
		ComputeLocation:    h.ComputeLocation,
		ProvisioningState:  h.ProvisioningState,
		Description:        h.Description,
		CreatedOn:          h.CreatedOn,
		ModifiedOn:         h.ModifiedOn,
		ResourceID:         h.ResourceID,
		ProvisioningErrors: h.ProvisioningErrors,
		IsAttachedCompute:  h.IsAttachedCompute,
		DisableLocalAuth:   h.DisableLocalAuth,
	}
}

// HDInsightProperties - HDInsight compute properties
type HDInsightProperties struct {
	// Public IP address of the master node of the cluster.
	Address *string `json:"address,omitempty"`

	// Admin credentials for master node of the cluster
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`

	// Port open for ssh connections on the master node of the cluster.
	SSHPort *int32 `json:"sshPort,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The user assigned identities associated with the resource.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// IdentityForCmk - Identity that will be used to access key vault for encryption at rest
type IdentityForCmk struct {
	// The ArmId of the user assigned identity that will be used to access the customer managed key vault
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// InstanceTypeSchema - Instance type schema.
type InstanceTypeSchema struct {
	// Node Selector
	NodeSelector map[string]*string `json:"nodeSelector,omitempty"`

	// Resource requests/limits for this instance type
	Resources *InstanceTypeSchemaResources `json:"resources,omitempty"`
}

// InstanceTypeSchemaResources - Resource requests/limits for this instance type
type InstanceTypeSchemaResources struct {
	// Resource limits for this instance type
	Limits map[string]*string `json:"limits,omitempty"`

	// Resource requests for this instance type
	Requests map[string]*string `json:"requests,omitempty"`
}

type KeyVaultProperties struct {
	// REQUIRED; Key vault uri to access the encryption key.
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`

	// REQUIRED; The ArmId of the keyVault where the customer owned encryption key is present.
	KeyVaultArmID *string `json:"keyVaultArmId,omitempty"`

	// For future use - The client id of the identity which will be used to access key vault.
	IdentityClientID *string `json:"identityClientId,omitempty"`
}

// Kubernetes - A Machine Learning compute based on Kubernetes Compute.
type Kubernetes struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Properties of Kubernetes
	Properties *KubernetesProperties `json:"properties,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type Kubernetes.
func (k *Kubernetes) GetCompute() *Compute {
	return &Compute{
		ComputeType:        k.ComputeType,
		ComputeLocation:    k.ComputeLocation,
		ProvisioningState:  k.ProvisioningState,
		Description:        k.Description,
		CreatedOn:          k.CreatedOn,
		ModifiedOn:         k.ModifiedOn,
		ResourceID:         k.ResourceID,
		ProvisioningErrors: k.ProvisioningErrors,
		IsAttachedCompute:  k.IsAttachedCompute,
		DisableLocalAuth:   k.DisableLocalAuth,
	}
}

// KubernetesProperties - Kubernetes properties
type KubernetesProperties struct {
	// Default instance type
	DefaultInstanceType *string `json:"defaultInstanceType,omitempty"`

	// Extension instance release train.
	ExtensionInstanceReleaseTrain *string `json:"extensionInstanceReleaseTrain,omitempty"`

	// Extension principal-id.
	ExtensionPrincipalID *string `json:"extensionPrincipalId,omitempty"`

	// Instance Type Schema
	InstanceTypes map[string]*InstanceTypeSchema `json:"instanceTypes,omitempty"`

	// Compute namespace
	Namespace *string `json:"namespace,omitempty"`

	// Relay connection string.
	RelayConnectionString *string `json:"relayConnectionString,omitempty"`

	// ServiceBus connection string.
	ServiceBusConnectionString *string `json:"serviceBusConnectionString,omitempty"`

	// VC name.
	VcName *string `json:"vcName,omitempty"`
}

// KubernetesSchema - Kubernetes Compute Schema
type KubernetesSchema struct {
	// Properties of Kubernetes
	Properties *KubernetesProperties `json:"properties,omitempty"`
}

// ListAmlUserFeatureResult - The List Aml user feature operation response.
type ListAmlUserFeatureResult struct {
	// READ-ONLY; The URI to fetch the next page of AML user features information. Call ListNext() with this to fetch the next
	// page of AML user features information.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of AML user facing features.
	Value []*AmlUserFeature `json:"value,omitempty" azure:"ro"`
}

type ListNotebookKeysResult struct {
	// READ-ONLY
	PrimaryAccessKey *string `json:"primaryAccessKey,omitempty" azure:"ro"`

	// READ-ONLY
	SecondaryAccessKey *string `json:"secondaryAccessKey,omitempty" azure:"ro"`
}

type ListStorageAccountKeysResult struct {
	// READ-ONLY
	UserStorageKey *string `json:"userStorageKey,omitempty" azure:"ro"`
}

// ListUsagesResult - The List Usages operation response.
type ListUsagesResult struct {
	// READ-ONLY; The URI to fetch the next page of AML resource usage information. Call ListNext() with this to fetch the next
	// page of AML resource usage information.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of AML resource usages.
	Value []*Usage `json:"value,omitempty" azure:"ro"`
}

type ListWorkspaceKeysResult struct {
	// READ-ONLY
	AppInsightsInstrumentationKey *string `json:"appInsightsInstrumentationKey,omitempty" azure:"ro"`

	// READ-ONLY
	ContainerRegistryCredentials *RegistryListCredentialsResult `json:"containerRegistryCredentials,omitempty" azure:"ro"`

	// READ-ONLY
	NotebookAccessKeys *ListNotebookKeysResult `json:"notebookAccessKeys,omitempty" azure:"ro"`

	// READ-ONLY
	UserStorageKey *string `json:"userStorageKey,omitempty" azure:"ro"`

	// READ-ONLY
	UserStorageResourceID *string `json:"userStorageResourceId,omitempty" azure:"ro"`
}

// ListWorkspaceQuotas - The List WorkspaceQuotasByVMFamily operation response.
type ListWorkspaceQuotas struct {
	// READ-ONLY; The URI to fetch the next page of workspace quota information by VM Family. Call ListNext() with this to fetch
	// the next page of Workspace Quota information.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of Workspace Quotas by VM Family
	Value []*ResourceQuota `json:"value,omitempty" azure:"ro"`
}

// NodeStateCounts - Counts of various compute node states on the amlCompute.
type NodeStateCounts struct {
	// READ-ONLY; Number of compute nodes in idle state.
	IdleNodeCount *int32 `json:"idleNodeCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of compute nodes which are leaving the amlCompute.
	LeavingNodeCount *int32 `json:"leavingNodeCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of compute nodes which are in preempted state.
	PreemptedNodeCount *int32 `json:"preemptedNodeCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of compute nodes which are being prepared.
	PreparingNodeCount *int32 `json:"preparingNodeCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of compute nodes which are running jobs.
	RunningNodeCount *int32 `json:"runningNodeCount,omitempty" azure:"ro"`

	// READ-ONLY; Number of compute nodes which are in unusable state.
	UnusableNodeCount *int32 `json:"unusableNodeCount,omitempty" azure:"ro"`
}

type NotebookAccessTokenResult struct {
	// READ-ONLY
	AccessToken *string `json:"accessToken,omitempty" azure:"ro"`

	// READ-ONLY
	ExpiresIn *int32 `json:"expiresIn,omitempty" azure:"ro"`

	// READ-ONLY
	HostName *string `json:"hostName,omitempty" azure:"ro"`

	// READ-ONLY
	NotebookResourceID *string `json:"notebookResourceId,omitempty" azure:"ro"`

	// READ-ONLY
	PublicDNS *string `json:"publicDns,omitempty" azure:"ro"`

	// READ-ONLY
	RefreshToken *string `json:"refreshToken,omitempty" azure:"ro"`

	// READ-ONLY
	Scope *string `json:"scope,omitempty" azure:"ro"`

	// READ-ONLY
	TokenType *string `json:"tokenType,omitempty" azure:"ro"`
}

type NotebookPreparationError struct {
	ErrorMessage *string `json:"errorMessage,omitempty"`
	StatusCode   *int32  `json:"statusCode,omitempty"`
}

type NotebookResourceInfo struct {
	Fqdn *string `json:"fqdn,omitempty"`

	// The error that occurs when preparing notebook.
	NotebookPreparationError *NotebookPreparationError `json:"notebookPreparationError,omitempty"`

	// the data plane resourceId that used to initialize notebook component
	ResourceID *string `json:"resourceId,omitempty"`
}

// Operation - Azure Machine Learning workspace REST API operation
type Operation struct {
	// Display name of operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - Display name of operation
type OperationDisplay struct {
	// The description for the operation.
	Description *string `json:"description,omitempty"`

	// The operation that users can perform.
	Operation *string `json:"operation,omitempty"`

	// The resource provider name: Microsoft.MachineLearningExperimentation
	Provider *string `json:"provider,omitempty"`

	// The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - An array of operations supported by the resource provider.
type OperationListResult struct {
	// List of AML workspace operations supported by the AML workspace resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PaginatedComputeResourcesList - Paginated list of Machine Learning compute objects wrapped in ARM resource envelope.
type PaginatedComputeResourcesList struct {
	// A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of Machine Learning compute objects wrapped in ARM resource envelope.
	Value []*ComputeResource `json:"value,omitempty"`
}

// PaginatedWorkspaceConnectionsList - Paginated list of Workspace connection objects.
type PaginatedWorkspaceConnectionsList struct {
	// A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of Workspace connection objects.
	Value []*WorkspaceConnection `json:"value,omitempty"`
}

type Password struct {
	// READ-ONLY
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY
	Value *string `json:"value,omitempty" azure:"ro"`
}

// PersonalComputeInstanceSettings - Settings for a personal compute instance.
type PersonalComputeInstanceSettings struct {
	// A user explicitly assigned to a personal compute instance.
	AssignedUser *AssignedUser `json:"assignedUser,omitempty"`
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The ARM identifier for Subnet resource that private endpoint links to
	SubnetArmID *string `json:"subnetArmId,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// The sku of the workspace.
	SKU *SKU `json:"sku,omitempty"`

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified workspace
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.CreateOrUpdate
// method.
type PrivateEndpointConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Delete
// method.
type PrivateEndpointConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// The sku of the workspace.
	SKU *SKU `json:"sku,omitempty"`

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// QuotaBaseProperties - The properties for Quota update or retrieval.
type QuotaBaseProperties struct {
	// Specifies the resource ID.
	ID *string `json:"id,omitempty"`

	// The maximum permitted quota of the resource.
	Limit *int64 `json:"limit,omitempty"`

	// Specifies the resource type.
	Type *string `json:"type,omitempty"`

	// An enum describing the unit of quota measurement.
	Unit *QuotaUnit `json:"unit,omitempty"`
}

// QuotaUpdateParameters - Quota update parameters.
type QuotaUpdateParameters struct {
	// Region of workspace quota to be updated.
	Location *string `json:"location,omitempty"`

	// The list for update quota.
	Value []*QuotaBaseProperties `json:"value,omitempty"`
}

// QuotasClientListOptions contains the optional parameters for the QuotasClient.List method.
type QuotasClientListOptions struct {
	// placeholder for future optional parameters
}

// QuotasClientUpdateOptions contains the optional parameters for the QuotasClient.Update method.
type QuotasClientUpdateOptions struct {
	// placeholder for future optional parameters
}

type RegistryListCredentialsResult struct {
	Passwords []*Password `json:"passwords,omitempty"`

	// READ-ONLY
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY
	Username *string `json:"username,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceID - Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
type ResourceID struct {
	// REQUIRED; The ID of the resource
	ID *string `json:"id,omitempty"`
}

// ResourceName - The Resource Name.
type ResourceName struct {
	// READ-ONLY; The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// ResourceQuota - The quota assigned to a resource.
type ResourceQuota struct {
	// READ-ONLY; Region of the AML workspace in the id.
	AmlWorkspaceLocation *string `json:"amlWorkspaceLocation,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The maximum permitted quota of the resource.
	Limit *int64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *ResourceName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; An enum describing the unit of quota measurement.
	Unit *QuotaUnit `json:"unit,omitempty" azure:"ro"`
}

type ResourceSKULocationInfo struct {
	// READ-ONLY; Location of the SKU
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Details of capabilities available to a SKU in specific zones.
	ZoneDetails []*ResourceSKUZoneDetails `json:"zoneDetails,omitempty" azure:"ro"`

	// READ-ONLY; List of availability zones where the SKU is supported.
	Zones []*string `json:"zones,omitempty" azure:"ro"`
}

// ResourceSKUZoneDetails - Describes The zonal capabilities of a SKU.
type ResourceSKUZoneDetails struct {
	// READ-ONLY; A list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities []*SKUCapability `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; The set of zones that the SKU is available in with the specified capabilities.
	Name []*string `json:"name,omitempty" azure:"ro"`
}

// Restriction - The restriction because of which SKU cannot be used.
type Restriction struct {
	// The reason for the restriction.
	ReasonCode *ReasonCode `json:"reasonCode,omitempty"`

	// READ-ONLY; The type of restrictions. As of now only possible value for this is location.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where
	// the SKU is restricted.
	Values []*string `json:"values,omitempty" azure:"ro"`
}

// SKU - Sku of the resource
type SKU struct {
	// Name of the sku
	Name *string `json:"name,omitempty"`

	// Tier of the sku like Basic or Enterprise
	Tier *string `json:"tier,omitempty"`
}

// SKUCapability - Features/user capabilities associated with the sku
type SKUCapability struct {
	// Capability/Feature ID
	Name *string `json:"name,omitempty"`

	// Details about the feature/capability
	Value *string `json:"value,omitempty"`
}

// SKUListResult - List of skus with features
type SKUListResult struct {
	// The URI to fetch the next page of Workspace Skus. Call ListNext() with this URI to fetch the next page of Workspace Skus
	NextLink *string         `json:"nextLink,omitempty"`
	Value    []*WorkspaceSKU `json:"value,omitempty"`
}

// SSLConfiguration - The ssl configuration for scoring
type SSLConfiguration struct {
	// Cert data
	Cert *string `json:"cert,omitempty"`

	// CNAME of the cert
	Cname *string `json:"cname,omitempty"`

	// Key data
	Key *string `json:"key,omitempty"`

	// Leaf domain label of public endpoint
	LeafDomainLabel *string `json:"leafDomainLabel,omitempty"`

	// Indicates whether to overwrite existing domain label.
	OverwriteExistingDomain *bool `json:"overwriteExistingDomain,omitempty"`

	// Enable or disable ssl for scoring
	Status *SSLConfigurationStatus `json:"status,omitempty"`
}

// ScaleSettings - scale settings for AML Compute
type ScaleSettings struct {
	// REQUIRED; Max number of nodes to use
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`

	// Min number of nodes to use
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`

	// Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
	NodeIdleTimeBeforeScaleDown *string `json:"nodeIdleTimeBeforeScaleDown,omitempty"`
}

// ScaleSettingsInformation - Desired scale settings for the amlCompute.
type ScaleSettingsInformation struct {
	// scale settings for AML Compute
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
}

// ScriptReference - Script reference
type ScriptReference struct {
	// Optional command line arguments passed to the script to run.
	ScriptArguments *string `json:"scriptArguments,omitempty"`

	// The location of scripts in the mounted volume.
	ScriptData *string `json:"scriptData,omitempty"`

	// The storage source of the script: inline, workspace.
	ScriptSource *string `json:"scriptSource,omitempty"`

	// Optional time period passed to timeout command.
	Timeout *string `json:"timeout,omitempty"`
}

// ScriptsToExecute - Customized setup scripts
type ScriptsToExecute struct {
	// Script that's run only once during provision of the compute.
	CreationScript *ScriptReference `json:"creationScript,omitempty"`

	// Script that's run every time the machine starts.
	StartupScript *ScriptReference `json:"startupScript,omitempty"`
}

type ServiceManagedResourcesSettings struct {
	// The settings for the service managed cosmosdb account.
	CosmosDb *CosmosDbSettings `json:"cosmosDb,omitempty"`
}

// ServicePrincipalCredentials - Service principal credentials.
type ServicePrincipalCredentials struct {
	// REQUIRED; Client Id
	ClientID *string `json:"clientId,omitempty"`

	// REQUIRED; Client secret
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// SetupScripts - Details of customized scripts to execute for setting up the cluster.
type SetupScripts struct {
	// Customized setup scripts
	Scripts *ScriptsToExecute `json:"scripts,omitempty"`
}

type SharedPrivateLinkResource struct {
	// Unique name of the private link.
	Name *string `json:"name,omitempty"`

	// Resource properties.
	Properties *SharedPrivateLinkResourceProperty `json:"properties,omitempty"`
}

// SharedPrivateLinkResourceProperty - Properties of a shared private link resource.
type SharedPrivateLinkResourceProperty struct {
	// The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`

	// The resource id that private link links to.
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`

	// Request message.
	RequestMessage *string `json:"requestMessage,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// SynapseSpark - A SynapseSpark compute.
type SynapseSpark struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool                   `json:"disableLocalAuth,omitempty"`
	Properties       *SynapseSparkProperties `json:"properties,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type SynapseSpark.
func (s *SynapseSpark) GetCompute() *Compute {
	return &Compute{
		ComputeType:        s.ComputeType,
		ComputeLocation:    s.ComputeLocation,
		ProvisioningState:  s.ProvisioningState,
		Description:        s.Description,
		CreatedOn:          s.CreatedOn,
		ModifiedOn:         s.ModifiedOn,
		ResourceID:         s.ResourceID,
		ProvisioningErrors: s.ProvisioningErrors,
		IsAttachedCompute:  s.IsAttachedCompute,
		DisableLocalAuth:   s.DisableLocalAuth,
	}
}

type SynapseSparkProperties struct {
	// Auto pause properties.
	AutoPauseProperties *AutoPauseProperties `json:"autoPauseProperties,omitempty"`

	// Auto scale properties.
	AutoScaleProperties *AutoScaleProperties `json:"autoScaleProperties,omitempty"`

	// The number of compute nodes currently assigned to the compute.
	NodeCount *int32 `json:"nodeCount,omitempty"`

	// Node size.
	NodeSize *string `json:"nodeSize,omitempty"`

	// Node size family.
	NodeSizeFamily *string `json:"nodeSizeFamily,omitempty"`

	// Pool name.
	PoolName *string `json:"poolName,omitempty"`

	// Name of the resource group in which workspace is located.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// Spark version.
	SparkVersion *string `json:"sparkVersion,omitempty"`

	// Azure subscription identifier.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// Name of Azure Machine Learning workspace.
	WorkspaceName *string `json:"workspaceName,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// SystemService - A system service running on a compute.
type SystemService struct {
	// READ-ONLY; Public IP address
	PublicIPAddress *string `json:"publicIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; The type of this system service.
	SystemServiceType *string `json:"systemServiceType,omitempty" azure:"ro"`

	// READ-ONLY; The version for this type.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// UpdateWorkspaceQuotas - The properties for update Quota response.
type UpdateWorkspaceQuotas struct {
	// The maximum permitted quota of the resource.
	Limit *int64 `json:"limit,omitempty"`

	// Status of update workspace quota.
	Status *Status `json:"status,omitempty"`

	// READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; An enum describing the unit of quota measurement.
	Unit *QuotaUnit `json:"unit,omitempty" azure:"ro"`
}

// UpdateWorkspaceQuotasResult - The result of update workspace quota.
type UpdateWorkspaceQuotasResult struct {
	// READ-ONLY; The URI to fetch the next page of workspace quota update result. Call ListNext() with this to fetch the next
	// page of Workspace Quota update result.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of workspace quota update result.
	Value []*UpdateWorkspaceQuotas `json:"value,omitempty" azure:"ro"`
}

// Usage - Describes AML Resource Usage.
type Usage struct {
	// READ-ONLY; Region of the AML workspace in the id.
	AmlWorkspaceLocation *string `json:"amlWorkspaceLocation,omitempty" azure:"ro"`

	// READ-ONLY; The current usage of the resource.
	CurrentValue *int64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The maximum permitted usage of the resource.
	Limit *int64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The name of the type of usage.
	Name *UsageName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; An enum describing the unit of usage measurement.
	Unit *UsageUnit `json:"unit,omitempty" azure:"ro"`
}

// UsageName - The Usage Names.
type UsageName struct {
	// READ-ONLY; The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// UsagesClientListOptions contains the optional parameters for the UsagesClient.List method.
type UsagesClientListOptions struct {
	// placeholder for future optional parameters
}

// UserAccountCredentials - Settings for user account that gets created on each on the nodes of a compute.
type UserAccountCredentials struct {
	// REQUIRED; Name of the administrator user account which can be used to SSH to nodes.
	AdminUserName *string `json:"adminUserName,omitempty"`

	// Password of the administrator user account.
	AdminUserPassword *string `json:"adminUserPassword,omitempty"`

	// SSH public key of the administrator user account.
	AdminUserSSHPublicKey *string `json:"adminUserSshPublicKey,omitempty"`
}

// UserAssignedIdentity - User Assigned Identity
type UserAssignedIdentity struct {
	// READ-ONLY; The clientId(aka appId) of the user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID of the user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the user assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// VirtualMachine - A Machine Learning compute based on Azure Virtual Machines.
type VirtualMachine struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`

	// The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool                     `json:"disableLocalAuth,omitempty"`
	Properties       *VirtualMachineProperties `json:"properties,omitempty"`

	// ARM resource id of the underlying compute
	ResourceID *string `json:"resourceId,omitempty"`

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool `json:"isAttachedCompute,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse `json:"provisioningErrors,omitempty" azure:"ro"`

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// GetCompute implements the ComputeClassification interface for type VirtualMachine.
func (v *VirtualMachine) GetCompute() *Compute {
	return &Compute{
		ComputeType:        v.ComputeType,
		ComputeLocation:    v.ComputeLocation,
		ProvisioningState:  v.ProvisioningState,
		Description:        v.Description,
		CreatedOn:          v.CreatedOn,
		ModifiedOn:         v.ModifiedOn,
		ResourceID:         v.ResourceID,
		ProvisioningErrors: v.ProvisioningErrors,
		IsAttachedCompute:  v.IsAttachedCompute,
		DisableLocalAuth:   v.DisableLocalAuth,
	}
}

// VirtualMachineImage - Virtual Machine image for Windows AML Compute
type VirtualMachineImage struct {
	// REQUIRED; Virtual Machine image path
	ID *string `json:"id,omitempty"`
}

type VirtualMachineProperties struct {
	// Public IP address of the virtual machine.
	Address *string `json:"address,omitempty"`

	// Admin credentials for virtual machine
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`

	// Indicates whether this compute will be used for running notebooks.
	IsNotebookInstanceCompute *bool `json:"isNotebookInstanceCompute,omitempty"`

	// Port open for ssh connections.
	SSHPort *int32 `json:"sshPort,omitempty"`

	// Virtual Machine size
	VirtualMachineSize *string `json:"virtualMachineSize,omitempty"`
}

// VirtualMachineSSHCredentials - Admin credentials for virtual machine
type VirtualMachineSSHCredentials struct {
	// Password of admin account
	Password *string `json:"password,omitempty"`

	// Private key data
	PrivateKeyData *string `json:"privateKeyData,omitempty"`

	// Public key data
	PublicKeyData *string `json:"publicKeyData,omitempty"`

	// Username of admin account
	Username *string `json:"username,omitempty"`
}

// VirtualMachineSecrets - Secrets related to a Machine Learning compute based on AKS.
type VirtualMachineSecrets struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType `json:"computeType,omitempty"`

	// Admin credentials for virtual machine.
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
}

// GetComputeSecrets implements the ComputeSecretsClassification interface for type VirtualMachineSecrets.
func (v *VirtualMachineSecrets) GetComputeSecrets() *ComputeSecrets {
	return &ComputeSecrets{
		ComputeType: v.ComputeType,
	}
}

// VirtualMachineSize - Describes the properties of a VM size.
type VirtualMachineSize struct {
	// The estimated price information for using a VM.
	EstimatedVMPrices *EstimatedVMPrices `json:"estimatedVMPrices,omitempty"`

	// Specifies the compute types supported by the virtual machine size.
	SupportedComputeTypes []*string `json:"supportedComputeTypes,omitempty"`

	// READ-ONLY; The family name of the virtual machine size.
	Family *string `json:"family,omitempty" azure:"ro"`

	// READ-ONLY; The number of gPUs supported by the virtual machine size.
	Gpus *int32 `json:"gpus,omitempty" azure:"ro"`

	// READ-ONLY; Specifies if the virtual machine size supports low priority VMs.
	LowPriorityCapable *bool `json:"lowPriorityCapable,omitempty" azure:"ro"`

	// READ-ONLY; The resource volume size, in MB, allowed by the virtual machine size.
	MaxResourceVolumeMB *int32 `json:"maxResourceVolumeMB,omitempty" azure:"ro"`

	// READ-ONLY; The amount of memory, in GB, supported by the virtual machine size.
	MemoryGB *float64 `json:"memoryGB,omitempty" azure:"ro"`

	// READ-ONLY; The name of the virtual machine size.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The OS VHD disk size, in MB, allowed by the virtual machine size.
	OSVhdSizeMB *int32 `json:"osVhdSizeMB,omitempty" azure:"ro"`

	// READ-ONLY; Specifies if the virtual machine size supports premium IO.
	PremiumIO *bool `json:"premiumIO,omitempty" azure:"ro"`

	// READ-ONLY; The number of vCPUs supported by the virtual machine size.
	VCPUs *int32 `json:"vCPUs,omitempty" azure:"ro"`
}

// VirtualMachineSizeListResult - The List Virtual Machine size operation response.
type VirtualMachineSizeListResult struct {
	// The list of virtual machine sizes supported by AmlCompute.
	Value []*VirtualMachineSize `json:"value,omitempty"`
}

// VirtualMachineSizesClientListOptions contains the optional parameters for the VirtualMachineSizesClient.List method.
type VirtualMachineSizesClientListOptions struct {
	// placeholder for future optional parameters
}

// Workspace - An object that represents a machine learning workspace.
type Workspace struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Specifies the location of the resource.
	Location *string `json:"location,omitempty"`

	// The properties of the machine learning workspace.
	Properties *WorkspaceProperties `json:"properties,omitempty"`

	// The sku of the workspace.
	SKU *SKU `json:"sku,omitempty"`

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System data
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkspaceConnection - Workspace connection.
type WorkspaceConnection struct {
	// Properties of workspace connection.
	Properties *WorkspaceConnectionProps `json:"properties,omitempty"`

	// READ-ONLY; ResourceId of the workspace connection.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Friendly name of the workspace connection.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of workspace connection.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkspaceConnectionProps - Workspace Connection specific properties.
type WorkspaceConnectionProps struct {
	// Authorization type of the workspace connection.
	AuthType *string `json:"authType,omitempty"`

	// Category of the workspace connection.
	Category *string `json:"category,omitempty"`

	// Target of the workspace connection.
	Target *string `json:"target,omitempty"`

	// Value details of the workspace connection.
	Value *string `json:"value,omitempty"`

	// format for the workspace connection value
	ValueFormat *ValueFormat `json:"valueFormat,omitempty"`
}

// WorkspaceConnectionsClientCreateOptions contains the optional parameters for the WorkspaceConnectionsClient.Create method.
type WorkspaceConnectionsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceConnectionsClientDeleteOptions contains the optional parameters for the WorkspaceConnectionsClient.Delete method.
type WorkspaceConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceConnectionsClientGetOptions contains the optional parameters for the WorkspaceConnectionsClient.Get method.
type WorkspaceConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceConnectionsClientListOptions contains the optional parameters for the WorkspaceConnectionsClient.List method.
type WorkspaceConnectionsClientListOptions struct {
	// Category of the workspace connection.
	Category *string
	// Target of the workspace connection.
	Target *string
}

// WorkspaceFeaturesClientListOptions contains the optional parameters for the WorkspaceFeaturesClient.List method.
type WorkspaceFeaturesClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceListResult - The result of a request to list machine learning workspaces.
type WorkspaceListResult struct {
	// The URI that can be used to request the next list of machine learning workspaces.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of machine learning workspaces. Since this list may be incomplete, the nextLink field should be used to request
	// the next list of machine learning workspaces.
	Value []*Workspace `json:"value,omitempty"`
}

// WorkspaceProperties - The properties of a machine learning workspace.
type WorkspaceProperties struct {
	// The flag to indicate whether to allow public access when behind VNet.
	AllowPublicAccessWhenBehindVnet *bool `json:"allowPublicAccessWhenBehindVnet,omitempty"`

	// ARM id of the application insights associated with this workspace. This cannot be changed once the workspace has been created
	ApplicationInsights *string `json:"applicationInsights,omitempty"`

	// ARM id of the container registry associated with this workspace. This cannot be changed once the workspace has been created
	ContainerRegistry *string `json:"containerRegistry,omitempty"`

	// The description of this workspace.
	Description *string `json:"description,omitempty"`

	// Url for the discovery service to identify regional endpoints for machine learning experimentation services
	DiscoveryURL *string `json:"discoveryUrl,omitempty"`

	// The encryption settings of Azure ML workspace.
	Encryption *EncryptionProperty `json:"encryption,omitempty"`

	// The friendly name for this workspace. This name in mutable
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service
	HbiWorkspace *bool `json:"hbiWorkspace,omitempty"`

	// The compute name for image build
	ImageBuildCompute *string `json:"imageBuildCompute,omitempty"`

	// ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
	KeyVault *string `json:"keyVault,omitempty"`

	// The user assigned identity resource id that represents the workspace identity.
	PrimaryUserAssignedIdentity *string `json:"primaryUserAssignedIdentity,omitempty"`

	// Whether requests from Public Network are allowed.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// The service managed resource settings.
	ServiceManagedResourcesSettings *ServiceManagedResourcesSettings `json:"serviceManagedResourcesSettings,omitempty"`

	// The list of shared private link resources in this workspace.
	SharedPrivateLinkResources []*SharedPrivateLinkResource `json:"sharedPrivateLinkResources,omitempty"`

	// ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
	StorageAccount *string `json:"storageAccount,omitempty"`

	// READ-ONLY; The URI associated with this workspace that machine learning flow must point at to set up tracking.
	MlFlowTrackingURI *string `json:"mlFlowTrackingUri,omitempty" azure:"ro"`

	// READ-ONLY; The notebook info of Azure ML workspace.
	NotebookInfo *NotebookResourceInfo `json:"notebookInfo,omitempty" azure:"ro"`

	// READ-ONLY; The list of private endpoint connections in the workspace.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Count of private connections in the workspace
	PrivateLinkCount *int32 `json:"privateLinkCount,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment state of workspace resource. The provisioningState is to indicate states for resource
	// provisioning.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The name of the managed resource group created by workspace RP in customer subscription if the workspace is
	// CMK workspace
	ServiceProvisionedResourceGroup *string `json:"serviceProvisionedResourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; If the storage associated with the workspace has hierarchical namespace(HNS) enabled.
	StorageHnsEnabled *bool `json:"storageHnsEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id associated with this workspace.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`

	// READ-ONLY; The immutable id associated with this workspace.
	WorkspaceID *string `json:"workspaceId,omitempty" azure:"ro"`
}

// WorkspacePropertiesUpdateParameters - The parameters for updating the properties of a machine learning workspace.
type WorkspacePropertiesUpdateParameters struct {
	// The description of this workspace.
	Description *string `json:"description,omitempty"`

	// The friendly name for this workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`

	// The compute name for image build
	ImageBuildCompute *string `json:"imageBuildCompute,omitempty"`

	// The user assigned identity resource id that represents the workspace identity.
	PrimaryUserAssignedIdentity *string `json:"primaryUserAssignedIdentity,omitempty"`

	// Whether requests from Public Network are allowed.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// The service managed resource settings.
	ServiceManagedResourcesSettings *ServiceManagedResourcesSettings `json:"serviceManagedResourcesSettings,omitempty"`
}

// WorkspaceSKU - Describes Workspace Sku details and features
type WorkspaceSKU struct {
	// The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*Restriction `json:"restrictions,omitempty"`

	// READ-ONLY; List of features/user capabilities associated with the sku
	Capabilities []*SKUCapability `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; A list of locations and availability zones in those locations where the SKU is available.
	LocationInfo []*ResourceSKULocationInfo `json:"locationInfo,omitempty" azure:"ro"`

	// READ-ONLY; The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g.
	// West US, East US, Southeast Asia, etc.).
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; Sku Tier like Basic or Enterprise
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// WorkspaceSKUsClientListOptions contains the optional parameters for the WorkspaceSKUsClient.List method.
type WorkspaceSKUsClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceUpdateParameters - The parameters for updating a machine learning workspace.
type WorkspaceUpdateParameters struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The properties that the machine learning workspace will be updated with.
	Properties *WorkspacePropertiesUpdateParameters `json:"properties,omitempty"`

	// The sku of the workspace.
	SKU *SKU `json:"sku,omitempty"`

	// The resource tags for the machine learning workspace.
	Tags map[string]*string `json:"tags,omitempty"`
}

// WorkspacesClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspacesClient.BeginCreateOrUpdate
// method.
type WorkspacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientBeginDeleteOptions contains the optional parameters for the WorkspacesClient.BeginDelete method.
type WorkspacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientBeginDiagnoseOptions contains the optional parameters for the WorkspacesClient.BeginDiagnose method.
type WorkspacesClientBeginDiagnoseOptions struct {
	// The parameter of diagnosing workspace health
	Parameters *DiagnoseWorkspaceParameters
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientBeginPrepareNotebookOptions contains the optional parameters for the WorkspacesClient.BeginPrepareNotebook
// method.
type WorkspacesClientBeginPrepareNotebookOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientBeginResyncKeysOptions contains the optional parameters for the WorkspacesClient.BeginResyncKeys method.
type WorkspacesClientBeginResyncKeysOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientGetOptions contains the optional parameters for the WorkspacesClient.Get method.
type WorkspacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListByResourceGroupOptions contains the optional parameters for the WorkspacesClient.ListByResourceGroup
// method.
type WorkspacesClientListByResourceGroupOptions struct {
	// Continuation token for pagination.
	Skip *string
}

// WorkspacesClientListBySubscriptionOptions contains the optional parameters for the WorkspacesClient.ListBySubscription
// method.
type WorkspacesClientListBySubscriptionOptions struct {
	// Continuation token for pagination.
	Skip *string
}

// WorkspacesClientListKeysOptions contains the optional parameters for the WorkspacesClient.ListKeys method.
type WorkspacesClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListNotebookAccessTokenOptions contains the optional parameters for the WorkspacesClient.ListNotebookAccessToken
// method.
type WorkspacesClientListNotebookAccessTokenOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListNotebookKeysOptions contains the optional parameters for the WorkspacesClient.ListNotebookKeys method.
type WorkspacesClientListNotebookKeysOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the WorkspacesClient.ListOutboundNetworkDependenciesEndpoints
// method.
type WorkspacesClientListOutboundNetworkDependenciesEndpointsOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListStorageAccountKeysOptions contains the optional parameters for the WorkspacesClient.ListStorageAccountKeys
// method.
type WorkspacesClientListStorageAccountKeysOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientUpdateOptions contains the optional parameters for the WorkspacesClient.Update method.
type WorkspacesClientUpdateOptions struct {
	// placeholder for future optional parameters
}
