//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcosmos

import "time"

type APIProperties struct {
	// Describes the ServerVersion of an a MongoDB account.
	ServerVersion *ServerVersion `json:"serverVersion,omitempty"`
}

// ARMProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required
// location and tags
type ARMProxyResource struct {
	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ARMResourceProperties - The core properties of ARM resources.
type ARMResourceProperties struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountKeyMetadata - The metadata related to an access key for a given database account.
type AccountKeyMetadata struct {
	// READ-ONLY; Generation time in UTC of the key in ISO-8601 format. If the value is missing from the object, it means that
	// the last key regeneration was triggered before 2022-06-18.
	GenerationTime *time.Time `json:"generationTime,omitempty" azure:"ro"`
}

// AnalyticalStorageConfiguration - Analytical storage specific properties.
type AnalyticalStorageConfiguration struct {
	// Describes the types of schema for analytical storage.
	SchemaType *AnalyticalStorageSchemaType `json:"schemaType,omitempty"`
}

// AuthenticationMethodLdapProperties - Ldap authentication method properties. This feature is in preview.
type AuthenticationMethodLdapProperties struct {
	// Distinguished name of the object to start the recursive search of users from.
	SearchBaseDistinguishedName *string `json:"searchBaseDistinguishedName,omitempty"`

	// Template to use for searching. Defaults to (cn=%s) where %s will be replaced by the username used to login.
	SearchFilterTemplate *string        `json:"searchFilterTemplate,omitempty"`
	ServerCertificates   []*Certificate `json:"serverCertificates,omitempty"`

	// Hostname of the LDAP server.
	ServerHostname *string `json:"serverHostname,omitempty"`

	// Port of the LDAP server.
	ServerPort *int32 `json:"serverPort,omitempty"`

	// Distinguished name of the look up user account, who can look up user details on authentication.
	ServiceUserDistinguishedName *string `json:"serviceUserDistinguishedName,omitempty"`

	// Password of the look up user.
	ServiceUserPassword *string `json:"serviceUserPassword,omitempty"`
}

// AutoUpgradePolicyResource - Cosmos DB resource auto-upgrade policy
type AutoUpgradePolicyResource struct {
	// Represents throughput policy which service must adhere to for auto-upgrade
	ThroughputPolicy *ThroughputPolicyResource `json:"throughputPolicy,omitempty"`
}

type AutoscaleSettings struct {
	// Represents maximum throughput, the resource can scale up to.
	MaxThroughput *int32 `json:"maxThroughput,omitempty"`
}

// AutoscaleSettingsResource - Cosmos DB provisioned throughput settings object
type AutoscaleSettingsResource struct {
	// REQUIRED; Represents maximum throughput container can scale up to.
	MaxThroughput *int32 `json:"maxThroughput,omitempty"`

	// Cosmos DB resource auto-upgrade policy
	AutoUpgradePolicy *AutoUpgradePolicyResource `json:"autoUpgradePolicy,omitempty"`

	// READ-ONLY; Represents target maximum throughput container can scale up to once offer is no longer in pending state.
	TargetMaxThroughput *int32 `json:"targetMaxThroughput,omitempty" azure:"ro"`
}

// AzureBlobDataTransferDataSourceSink - An Azure Blob Storage data source/sink
type AzureBlobDataTransferDataSourceSink struct {
	// REQUIRED
	Component *DataTransferComponent `json:"component,omitempty"`

	// REQUIRED
	ContainerName *string `json:"containerName,omitempty"`
	EndpointURL   *string `json:"endpointUrl,omitempty"`
}

// GetDataTransferDataSourceSink implements the DataTransferDataSourceSinkClassification interface for type AzureBlobDataTransferDataSourceSink.
func (a *AzureBlobDataTransferDataSourceSink) GetDataTransferDataSourceSink() *DataTransferDataSourceSink {
	return &DataTransferDataSourceSink{
		Component: a.Component,
	}
}

// BackupInformation - Backup information of a resource.
type BackupInformation struct {
	// READ-ONLY; Information about the status of continuous backups.
	ContinuousBackupInformation *ContinuousBackupInformation `json:"continuousBackupInformation,omitempty" azure:"ro"`
}

// BackupPolicyClassification provides polymorphic access to related types.
// Call the interface's GetBackupPolicy() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *BackupPolicy, *ContinuousModeBackupPolicy, *PeriodicModeBackupPolicy
type BackupPolicyClassification interface {
	// GetBackupPolicy returns the BackupPolicy content of the underlying type.
	GetBackupPolicy() *BackupPolicy
}

// BackupPolicy - The object representing the policy for taking backups on an account.
type BackupPolicy struct {
	// REQUIRED; Describes the mode of backups.
	Type *BackupPolicyType `json:"type,omitempty"`

	// The object representing the state of the migration between the backup policies.
	MigrationState *BackupPolicyMigrationState `json:"migrationState,omitempty"`
}

// GetBackupPolicy implements the BackupPolicyClassification interface for type BackupPolicy.
func (b *BackupPolicy) GetBackupPolicy() *BackupPolicy { return b }

// BackupPolicyMigrationState - The object representing the state of the migration between the backup policies.
type BackupPolicyMigrationState struct {
	// Time at which the backup policy migration started (ISO-8601 format).
	StartTime *time.Time `json:"startTime,omitempty"`

	// Describes the status of migration between backup policy types.
	Status *BackupPolicyMigrationStatus `json:"status,omitempty"`

	// Describes the target backup policy type of the backup policy migration.
	TargetType *BackupPolicyType `json:"targetType,omitempty"`
}

// BackupResource - A restorable backup of a Cassandra cluster.
type BackupResource struct {
	Properties *BackupResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type BackupResourceProperties struct {
	// The time this backup was taken, formatted like 2021-01-21T17:35:21
	Timestamp *time.Time `json:"timestamp,omitempty"`
}

// Capability - Cosmos DB capability object
type Capability struct {
	// Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and
	// "EnableGremlin".
	Name *string `json:"name,omitempty"`
}

// Capacity - The object that represents all properties related to capacity enforcement on an account.
type Capacity struct {
	// The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max throughput
	// that can be provisioned on that account to be 2000. A totalThroughputLimit of
	// -1 indicates no limits on provisioning of throughput.
	TotalThroughputLimit *int32 `json:"totalThroughputLimit,omitempty"`
}

// CassandraClusterPublicStatus - Properties of a managed Cassandra cluster public status.
type CassandraClusterPublicStatus struct {
	// List relevant information about any connection errors to the Datacenters.
	ConnectionErrors []*ConnectionError `json:"connectionErrors,omitempty"`

	// List of the status of each datacenter in this cluster.
	DataCenters  []*CassandraClusterPublicStatusDataCentersItem `json:"dataCenters,omitempty"`
	ETag         *string                                        `json:"eTag,omitempty"`
	ReaperStatus *ManagedCassandraReaperStatus                  `json:"reaperStatus,omitempty"`
}

type CassandraClusterPublicStatusDataCentersItem struct {
	// The name of this Datacenter.
	Name  *string                                                                                              `json:"name,omitempty"`
	Nodes []*ComponentsM9L909SchemasCassandraclusterpublicstatusPropertiesDatacentersItemsPropertiesNodesItems `json:"nodes,omitempty"`

	// A list of all seed nodes in the cluster, managed and unmanaged.
	SeedNodes []*string `json:"seedNodes,omitempty"`
}

// CassandraClustersClientBeginCreateUpdateOptions contains the optional parameters for the CassandraClustersClient.BeginCreateUpdate
// method.
type CassandraClustersClientBeginCreateUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraClustersClientBeginDeallocateOptions contains the optional parameters for the CassandraClustersClient.BeginDeallocate
// method.
type CassandraClustersClientBeginDeallocateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraClustersClientBeginDeleteOptions contains the optional parameters for the CassandraClustersClient.BeginDelete
// method.
type CassandraClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraClustersClientBeginInvokeCommandOptions contains the optional parameters for the CassandraClustersClient.BeginInvokeCommand
// method.
type CassandraClustersClientBeginInvokeCommandOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraClustersClientBeginStartOptions contains the optional parameters for the CassandraClustersClient.BeginStart method.
type CassandraClustersClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraClustersClientBeginUpdateOptions contains the optional parameters for the CassandraClustersClient.BeginUpdate
// method.
type CassandraClustersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraClustersClientGetBackupOptions contains the optional parameters for the CassandraClustersClient.GetBackup method.
type CassandraClustersClientGetBackupOptions struct {
	// placeholder for future optional parameters
}

// CassandraClustersClientGetOptions contains the optional parameters for the CassandraClustersClient.Get method.
type CassandraClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// CassandraClustersClientListBackupsOptions contains the optional parameters for the CassandraClustersClient.ListBackups
// method.
type CassandraClustersClientListBackupsOptions struct {
	// placeholder for future optional parameters
}

// CassandraClustersClientListByResourceGroupOptions contains the optional parameters for the CassandraClustersClient.ListByResourceGroup
// method.
type CassandraClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// CassandraClustersClientListBySubscriptionOptions contains the optional parameters for the CassandraClustersClient.ListBySubscription
// method.
type CassandraClustersClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// CassandraClustersClientStatusOptions contains the optional parameters for the CassandraClustersClient.Status method.
type CassandraClustersClientStatusOptions struct {
	// placeholder for future optional parameters
}

// CassandraDataCentersClientBeginCreateUpdateOptions contains the optional parameters for the CassandraDataCentersClient.BeginCreateUpdate
// method.
type CassandraDataCentersClientBeginCreateUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraDataCentersClientBeginDeleteOptions contains the optional parameters for the CassandraDataCentersClient.BeginDelete
// method.
type CassandraDataCentersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraDataCentersClientBeginUpdateOptions contains the optional parameters for the CassandraDataCentersClient.BeginUpdate
// method.
type CassandraDataCentersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraDataCentersClientGetOptions contains the optional parameters for the CassandraDataCentersClient.Get method.
type CassandraDataCentersClientGetOptions struct {
	// placeholder for future optional parameters
}

// CassandraDataCentersClientListOptions contains the optional parameters for the CassandraDataCentersClient.List method.
type CassandraDataCentersClientListOptions struct {
	// placeholder for future optional parameters
}

// CassandraDataTransferDataSourceSink - A CosmosDB Cassandra API data source/sink
type CassandraDataTransferDataSourceSink struct {
	// REQUIRED
	Component *DataTransferComponent `json:"component,omitempty"`

	// REQUIRED
	KeyspaceName *string `json:"keyspaceName,omitempty"`

	// REQUIRED
	TableName *string `json:"tableName,omitempty"`
}

// GetDataTransferDataSourceSink implements the DataTransferDataSourceSinkClassification interface for type CassandraDataTransferDataSourceSink.
func (c *CassandraDataTransferDataSourceSink) GetDataTransferDataSourceSink() *DataTransferDataSourceSink {
	return &DataTransferDataSourceSink{
		Component: c.Component,
	}
}

// CassandraKeyspaceCreateUpdateParameters - Parameters to create and update Cosmos DB Cassandra keyspace.
type CassandraKeyspaceCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Cassandra keyspace.
	Properties *CassandraKeyspaceCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CassandraKeyspaceCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra keyspace.
type CassandraKeyspaceCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Cassandra keyspace
	Resource *CassandraKeyspaceResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// CassandraKeyspaceGetProperties - The properties of an Azure Cosmos DB Cassandra keyspace
type CassandraKeyspaceGetProperties struct {
	Options  *CassandraKeyspaceGetPropertiesOptions  `json:"options,omitempty"`
	Resource *CassandraKeyspaceGetPropertiesResource `json:"resource,omitempty"`
}

type CassandraKeyspaceGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type CassandraKeyspaceGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra keyspace
	ID *string `json:"id,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// CassandraKeyspaceGetResults - An Azure Cosmos DB Cassandra keyspace.
type CassandraKeyspaceGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB Cassandra keyspace
	Properties *CassandraKeyspaceGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CassandraKeyspaceListResult - The List operation response, that contains the Cassandra keyspaces and their properties.
type CassandraKeyspaceListResult struct {
	// READ-ONLY; List of Cassandra keyspaces and their properties.
	Value []*CassandraKeyspaceGetResults `json:"value,omitempty" azure:"ro"`
}

// CassandraKeyspaceResource - Cosmos DB Cassandra keyspace resource object
type CassandraKeyspaceResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra keyspace
	ID *string `json:"id,omitempty"`
}

// CassandraPartitionKey - Cosmos DB Cassandra table partition key
type CassandraPartitionKey struct {
	// Name of the Cosmos DB Cassandra table partition key
	Name *string `json:"name,omitempty"`
}

// CassandraResourcesClientBeginCreateUpdateCassandraKeyspaceOptions contains the optional parameters for the CassandraResourcesClient.BeginCreateUpdateCassandraKeyspace
// method.
type CassandraResourcesClientBeginCreateUpdateCassandraKeyspaceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginCreateUpdateCassandraTableOptions contains the optional parameters for the CassandraResourcesClient.BeginCreateUpdateCassandraTable
// method.
type CassandraResourcesClientBeginCreateUpdateCassandraTableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginCreateUpdateCassandraViewOptions contains the optional parameters for the CassandraResourcesClient.BeginCreateUpdateCassandraView
// method.
type CassandraResourcesClientBeginCreateUpdateCassandraViewOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginDeleteCassandraKeyspaceOptions contains the optional parameters for the CassandraResourcesClient.BeginDeleteCassandraKeyspace
// method.
type CassandraResourcesClientBeginDeleteCassandraKeyspaceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginDeleteCassandraTableOptions contains the optional parameters for the CassandraResourcesClient.BeginDeleteCassandraTable
// method.
type CassandraResourcesClientBeginDeleteCassandraTableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginDeleteCassandraViewOptions contains the optional parameters for the CassandraResourcesClient.BeginDeleteCassandraView
// method.
type CassandraResourcesClientBeginDeleteCassandraViewOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginMigrateCassandraKeyspaceToAutoscaleOptions contains the optional parameters for the CassandraResourcesClient.BeginMigrateCassandraKeyspaceToAutoscale
// method.
type CassandraResourcesClientBeginMigrateCassandraKeyspaceToAutoscaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginMigrateCassandraKeyspaceToManualThroughputOptions contains the optional parameters for the
// CassandraResourcesClient.BeginMigrateCassandraKeyspaceToManualThroughput method.
type CassandraResourcesClientBeginMigrateCassandraKeyspaceToManualThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginMigrateCassandraTableToAutoscaleOptions contains the optional parameters for the CassandraResourcesClient.BeginMigrateCassandraTableToAutoscale
// method.
type CassandraResourcesClientBeginMigrateCassandraTableToAutoscaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginMigrateCassandraTableToManualThroughputOptions contains the optional parameters for the CassandraResourcesClient.BeginMigrateCassandraTableToManualThroughput
// method.
type CassandraResourcesClientBeginMigrateCassandraTableToManualThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginMigrateCassandraViewToAutoscaleOptions contains the optional parameters for the CassandraResourcesClient.BeginMigrateCassandraViewToAutoscale
// method.
type CassandraResourcesClientBeginMigrateCassandraViewToAutoscaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginMigrateCassandraViewToManualThroughputOptions contains the optional parameters for the CassandraResourcesClient.BeginMigrateCassandraViewToManualThroughput
// method.
type CassandraResourcesClientBeginMigrateCassandraViewToManualThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginUpdateCassandraKeyspaceThroughputOptions contains the optional parameters for the CassandraResourcesClient.BeginUpdateCassandraKeyspaceThroughput
// method.
type CassandraResourcesClientBeginUpdateCassandraKeyspaceThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginUpdateCassandraTableThroughputOptions contains the optional parameters for the CassandraResourcesClient.BeginUpdateCassandraTableThroughput
// method.
type CassandraResourcesClientBeginUpdateCassandraTableThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientBeginUpdateCassandraViewThroughputOptions contains the optional parameters for the CassandraResourcesClient.BeginUpdateCassandraViewThroughput
// method.
type CassandraResourcesClientBeginUpdateCassandraViewThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CassandraResourcesClientGetCassandraKeyspaceOptions contains the optional parameters for the CassandraResourcesClient.GetCassandraKeyspace
// method.
type CassandraResourcesClientGetCassandraKeyspaceOptions struct {
	// placeholder for future optional parameters
}

// CassandraResourcesClientGetCassandraKeyspaceThroughputOptions contains the optional parameters for the CassandraResourcesClient.GetCassandraKeyspaceThroughput
// method.
type CassandraResourcesClientGetCassandraKeyspaceThroughputOptions struct {
	// placeholder for future optional parameters
}

// CassandraResourcesClientGetCassandraTableOptions contains the optional parameters for the CassandraResourcesClient.GetCassandraTable
// method.
type CassandraResourcesClientGetCassandraTableOptions struct {
	// placeholder for future optional parameters
}

// CassandraResourcesClientGetCassandraTableThroughputOptions contains the optional parameters for the CassandraResourcesClient.GetCassandraTableThroughput
// method.
type CassandraResourcesClientGetCassandraTableThroughputOptions struct {
	// placeholder for future optional parameters
}

// CassandraResourcesClientGetCassandraViewOptions contains the optional parameters for the CassandraResourcesClient.GetCassandraView
// method.
type CassandraResourcesClientGetCassandraViewOptions struct {
	// placeholder for future optional parameters
}

// CassandraResourcesClientGetCassandraViewThroughputOptions contains the optional parameters for the CassandraResourcesClient.GetCassandraViewThroughput
// method.
type CassandraResourcesClientGetCassandraViewThroughputOptions struct {
	// placeholder for future optional parameters
}

// CassandraResourcesClientListCassandraKeyspacesOptions contains the optional parameters for the CassandraResourcesClient.ListCassandraKeyspaces
// method.
type CassandraResourcesClientListCassandraKeyspacesOptions struct {
	// placeholder for future optional parameters
}

// CassandraResourcesClientListCassandraTablesOptions contains the optional parameters for the CassandraResourcesClient.ListCassandraTables
// method.
type CassandraResourcesClientListCassandraTablesOptions struct {
	// placeholder for future optional parameters
}

// CassandraResourcesClientListCassandraViewsOptions contains the optional parameters for the CassandraResourcesClient.ListCassandraViews
// method.
type CassandraResourcesClientListCassandraViewsOptions struct {
	// placeholder for future optional parameters
}

// CassandraSchema - Cosmos DB Cassandra table schema
type CassandraSchema struct {
	// List of cluster key.
	ClusterKeys []*ClusterKey `json:"clusterKeys,omitempty"`

	// List of Cassandra table columns.
	Columns []*Column `json:"columns,omitempty"`

	// List of partition key.
	PartitionKeys []*CassandraPartitionKey `json:"partitionKeys,omitempty"`
}

// CassandraTableCreateUpdateParameters - Parameters to create and update Cosmos DB Cassandra table.
type CassandraTableCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Cassandra table.
	Properties *CassandraTableCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CassandraTableCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra table.
type CassandraTableCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Cassandra table
	Resource *CassandraTableResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// CassandraTableGetProperties - The properties of an Azure Cosmos DB Cassandra table
type CassandraTableGetProperties struct {
	Options  *CassandraTableGetPropertiesOptions  `json:"options,omitempty"`
	Resource *CassandraTableGetPropertiesResource `json:"resource,omitempty"`
}

type CassandraTableGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type CassandraTableGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra table
	ID *string `json:"id,omitempty"`

	// Analytical TTL.
	AnalyticalStorageTTL *int32 `json:"analyticalStorageTtl,omitempty"`

	// Time to live of the Cosmos DB Cassandra table
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`

	// Schema of the Cosmos DB Cassandra table
	Schema *CassandraSchema `json:"schema,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// CassandraTableGetResults - An Azure Cosmos DB Cassandra table.
type CassandraTableGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB Cassandra table
	Properties *CassandraTableGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CassandraTableListResult - The List operation response, that contains the Cassandra tables and their properties.
type CassandraTableListResult struct {
	// READ-ONLY; List of Cassandra tables and their properties.
	Value []*CassandraTableGetResults `json:"value,omitempty" azure:"ro"`
}

// CassandraTableResource - Cosmos DB Cassandra table resource object
type CassandraTableResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra table
	ID *string `json:"id,omitempty"`

	// Analytical TTL.
	AnalyticalStorageTTL *int32 `json:"analyticalStorageTtl,omitempty"`

	// Time to live of the Cosmos DB Cassandra table
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`

	// Schema of the Cosmos DB Cassandra table
	Schema *CassandraSchema `json:"schema,omitempty"`
}

// CassandraViewCreateUpdateParameters - Parameters to create and update Cosmos DB Cassandra view.
type CassandraViewCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Cassandra view.
	Properties *CassandraViewCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CassandraViewCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra view.
type CassandraViewCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Cassandra view
	Resource *CassandraViewResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// CassandraViewGetProperties - The properties of an Azure Cosmos DB Cassandra view
type CassandraViewGetProperties struct {
	Options  *CassandraViewGetPropertiesOptions  `json:"options,omitempty"`
	Resource *CassandraViewGetPropertiesResource `json:"resource,omitempty"`
}

type CassandraViewGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type CassandraViewGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra view
	ID *string `json:"id,omitempty"`

	// REQUIRED; View Definition of the Cosmos DB Cassandra view
	ViewDefinition *string `json:"viewDefinition,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// CassandraViewGetResults - An Azure Cosmos DB Cassandra view.
type CassandraViewGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB Cassandra view
	Properties *CassandraViewGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CassandraViewListResult - The List operation response, that contains the Cassandra views and their properties.
type CassandraViewListResult struct {
	// READ-ONLY; List of Cassandra views and their properties.
	Value []*CassandraViewGetResults `json:"value,omitempty" azure:"ro"`
}

// CassandraViewResource - Cosmos DB Cassandra view resource object
type CassandraViewResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra view
	ID *string `json:"id,omitempty"`

	// REQUIRED; View Definition of the Cosmos DB Cassandra view
	ViewDefinition *string `json:"viewDefinition,omitempty"`
}

type Certificate struct {
	// PEM formatted public key.
	Pem *string `json:"pem,omitempty"`
}

// ClientEncryptionIncludedPath - .
type ClientEncryptionIncludedPath struct {
	// REQUIRED; The identifier of the Client Encryption Key to be used to encrypt the path.
	ClientEncryptionKeyID *string `json:"clientEncryptionKeyId,omitempty"`

	// REQUIRED; The encryption algorithm which will be used. Eg - AEADAES256CBCHMAC_SHA256.
	EncryptionAlgorithm *string `json:"encryptionAlgorithm,omitempty"`

	// REQUIRED; The type of encryption to be performed. Eg - Deterministic, Randomized.
	EncryptionType *string `json:"encryptionType,omitempty"`

	// REQUIRED; Path that needs to be encrypted.
	Path *string `json:"path,omitempty"`
}

// ClientEncryptionKeyCreateUpdateParameters - Parameters to create and update ClientEncryptionKey.
type ClientEncryptionKeyCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update ClientEncryptionKey.
	Properties *ClientEncryptionKeyCreateUpdateProperties `json:"properties,omitempty"`
}

// ClientEncryptionKeyCreateUpdateProperties - Properties to create and update ClientEncryptionKey.
type ClientEncryptionKeyCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a ClientEncryptionKey
	Resource *ClientEncryptionKeyResource `json:"resource,omitempty"`
}

// ClientEncryptionKeyGetProperties - The properties of a ClientEncryptionKey resource
type ClientEncryptionKeyGetProperties struct {
	Resource *ClientEncryptionKeyGetPropertiesResource `json:"resource,omitempty"`
}

type ClientEncryptionKeyGetPropertiesResource struct {
	// Encryption algorithm that will be used along with this client encryption key to encrypt/decrypt data.
	EncryptionAlgorithm *string `json:"encryptionAlgorithm,omitempty"`

	// Name of the ClientEncryptionKey
	ID *string `json:"id,omitempty"`

	// Metadata for the wrapping provider that can be used to unwrap the wrapped client encryption key.
	KeyWrapMetadata *KeyWrapMetadata `json:"keyWrapMetadata,omitempty"`

	// Wrapped (encrypted) form of the key represented as a byte array.
	WrappedDataEncryptionKey []byte `json:"wrappedDataEncryptionKey,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// ClientEncryptionKeyGetResults - Client Encryption Key.
type ClientEncryptionKeyGetResults struct {
	// The properties of a ClientEncryptionKey
	Properties *ClientEncryptionKeyGetProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClientEncryptionKeyResource - Cosmos DB client encryption key resource object.
type ClientEncryptionKeyResource struct {
	// Encryption algorithm that will be used along with this client encryption key to encrypt/decrypt data.
	EncryptionAlgorithm *string `json:"encryptionAlgorithm,omitempty"`

	// Name of the ClientEncryptionKey
	ID *string `json:"id,omitempty"`

	// Metadata for the wrapping provider that can be used to unwrap the wrapped client encryption key.
	KeyWrapMetadata *KeyWrapMetadata `json:"keyWrapMetadata,omitempty"`

	// Wrapped (encrypted) form of the key represented as a byte array.
	WrappedDataEncryptionKey []byte `json:"wrappedDataEncryptionKey,omitempty"`
}

// ClientEncryptionKeysListResult - The List operation response, that contains the client encryption keys and their properties.
type ClientEncryptionKeysListResult struct {
	// READ-ONLY; List of client encryption keys and their properties.
	Value []*ClientEncryptionKeyGetResults `json:"value,omitempty" azure:"ro"`
}

// ClientEncryptionPolicy - Cosmos DB client encryption policy.
type ClientEncryptionPolicy struct {
	// REQUIRED; Paths of the item that need encryption along with path-specific settings.
	IncludedPaths []*ClientEncryptionIncludedPath `json:"includedPaths,omitempty"`

	// Version of the client encryption policy definition. Please note, user passed value is ignored. Default policy version is
	// 1.
	PolicyFormatVersion *int32 `json:"policyFormatVersion,omitempty"`
}

// ClusterKey - Cosmos DB Cassandra table cluster key
type ClusterKey struct {
	// Name of the Cosmos DB Cassandra table cluster key
	Name *string `json:"name,omitempty"`

	// Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
	OrderBy *string `json:"orderBy,omitempty"`
}

// ClusterResource - Representation of a managed Cassandra cluster.
type ClusterResource struct {
	// Identity for the resource.
	Identity *ManagedCassandraManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Properties of a managed Cassandra cluster.
	Properties *ClusterResourceProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterResourceProperties - Properties of a managed Cassandra cluster.
type ClusterResourceProperties struct {
	// Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not
	// be used except in emergencies. 'Cassandra' is the default password based
	// authentication. The default is 'Cassandra'. 'Ldap' is in preview.
	AuthenticationMethod *AuthenticationMethod `json:"authenticationMethod,omitempty"`

	// Whether Cassandra audit logging is enabled
	CassandraAuditLoggingEnabled *bool `json:"cassandraAuditLoggingEnabled,omitempty"`

	// Which version of Cassandra should this cluster converge to running (e.g., 3.11). When updated, the cluster may take some
	// time to migrate to the new version.
	CassandraVersion *string `json:"cassandraVersion,omitempty"`

	// List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether
	// clientCertificates is set or not, but if clientCertificates is set, the managed
	// Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more
	// of the public certificates in this property.
	ClientCertificates []*Certificate `json:"clientCertificates,omitempty"`

	// If you need to set the clusterName property in cassandra.yaml to something besides the resource name of the cluster, set
	// the value to use on this property.
	ClusterNameOverride *string `json:"clusterNameOverride,omitempty"`

	// Whether the cluster and associated data centers has been deallocated.
	Deallocated *bool `json:"deallocated,omitempty"`

	// Resource id of a subnet that this cluster's management service should have its network interface attached to. The subnet
	// must be routable to all subnets that will be delegated to data centers. The
	// resource id must be of the form '/subscriptions//resourceGroups//providers/Microsoft.Network/virtualNetworks//subnets/'
	DelegatedManagementSubnetID *string `json:"delegatedManagementSubnetId,omitempty"`

	// List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged
	// data centers must be verifiable using one of the certificates provided in
	// this property.
	ExternalGossipCertificates []*Certificate `json:"externalGossipCertificates,omitempty"`

	// List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed
	// nodes.
	ExternalSeedNodes []*SeedNode `json:"externalSeedNodes,omitempty"`

	// Number of hours to wait between taking a backup of the cluster.
	HoursBetweenBackups *int32 `json:"hoursBetweenBackups,omitempty"`

	// Initial password for clients connecting as admin to the cluster. Should be changed after cluster creation. Returns null
	// on GET. This field only applies when the authenticationMethod field is
	// 'Cassandra'.
	InitialCassandraAdminPassword *string `json:"initialCassandraAdminPassword,omitempty"`

	// Hostname or IP address where the Prometheus endpoint containing data about the managed Cassandra nodes can be reached.
	PrometheusEndpoint *SeedNode `json:"prometheusEndpoint,omitempty"`

	// The status of the resource at the time the operation was called.
	ProvisioningState *ManagedCassandraProvisioningState `json:"provisioningState,omitempty"`

	// Should automatic repairs run on this cluster? If omitted, this is true, and should stay true unless you are running a hybrid
	// cluster where you are already doing your own repairs.
	RepairEnabled *bool `json:"repairEnabled,omitempty"`

	// To create an empty cluster, omit this field or set it to null. To restore a backup into a new cluster, set this field to
	// the resource id of the backup.
	RestoreFromBackupID *string `json:"restoreFromBackupId,omitempty"`

	// READ-ONLY; List of TLS certificates that unmanaged nodes must trust for gossip with managed nodes. All managed nodes will
	// present TLS client certificates that are verifiable using one of the certificates
	// provided in this property.
	GossipCertificates []*Certificate `json:"gossipCertificates,omitempty" azure:"ro"`

	// READ-ONLY; List of IP addresses of seed nodes in the managed data centers. These should be added to the seed node lists
	// of all unmanaged nodes.
	SeedNodes []*SeedNode `json:"seedNodes,omitempty" azure:"ro"`
}

// CollectionClientListMetricDefinitionsOptions contains the optional parameters for the CollectionClient.ListMetricDefinitions
// method.
type CollectionClientListMetricDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// CollectionClientListMetricsOptions contains the optional parameters for the CollectionClient.ListMetrics method.
type CollectionClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// CollectionClientListUsagesOptions contains the optional parameters for the CollectionClient.ListUsages method.
type CollectionClientListUsagesOptions struct {
	// An OData filter expression that describes a subset of usages to return. The supported parameter is name.value (name of
	// the metric, can have an or of multiple names).
	Filter *string
}

// CollectionPartitionClientListMetricsOptions contains the optional parameters for the CollectionPartitionClient.ListMetrics
// method.
type CollectionPartitionClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// CollectionPartitionClientListUsagesOptions contains the optional parameters for the CollectionPartitionClient.ListUsages
// method.
type CollectionPartitionClientListUsagesOptions struct {
	// An OData filter expression that describes a subset of usages to return. The supported parameter is name.value (name of
	// the metric, can have an or of multiple names).
	Filter *string
}

// CollectionPartitionRegionClientListMetricsOptions contains the optional parameters for the CollectionPartitionRegionClient.ListMetrics
// method.
type CollectionPartitionRegionClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// CollectionRegionClientListMetricsOptions contains the optional parameters for the CollectionRegionClient.ListMetrics method.
type CollectionRegionClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// Column - Cosmos DB Cassandra table column
type Column struct {
	// Name of the Cosmos DB Cassandra table column
	Name *string `json:"name,omitempty"`

	// Type of the Cosmos DB Cassandra table column
	Type *string `json:"type,omitempty"`
}

// CommandOutput - Response of /command api
type CommandOutput struct {
	// Output of the command.
	CommandOutput *string `json:"commandOutput,omitempty"`
}

// CommandPostBody - Specification of which command to run where
type CommandPostBody struct {
	// REQUIRED; The command which should be run
	Command *string `json:"command,omitempty"`

	// REQUIRED; IP address of the cassandra host to run the command on
	Host *string `json:"host,omitempty"`

	// The arguments for the command to be run
	Arguments map[string]*string `json:"arguments,omitempty"`

	// If true, stops cassandra before executing the command and then start it again
	CassandraStopStart *bool `json:"cassandra-stop-start,omitempty"`

	// If true, allows the command to write to the cassandra directory, otherwise read-only.
	Readwrite *bool `json:"readwrite,omitempty"`
}

type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

type ComponentsM9L909SchemasCassandraclusterpublicstatusPropertiesDatacentersItemsPropertiesNodesItems struct {
	// The node's IP address.
	Address *string `json:"address,omitempty"`

	// A float representing the current system-wide CPU utilization as a percentage.
	CPUUsage *float64 `json:"cpuUsage,omitempty"`

	// The amount of disk free, in kB, of the directory /var/lib/cassandra.
	DiskFreeKB *int64 `json:"diskFreeKB,omitempty"`

	// The amount of disk used, in kB, of the directory /var/lib/cassandra.
	DiskUsedKB *int64 `json:"diskUsedKB,omitempty"`

	// The network ID of the node.
	HostID *string `json:"hostID,omitempty"`

	// The amount of file system data in the data directory (e.g., 47.66 kB), excluding all content in the snapshots subdirectories.
	// Because all SSTable data files are included, any data that is not cleaned
	// up (such as TTL-expired cells or tombstones) is counted.
	Load *string `json:"load,omitempty"`

	// Memory used by kernel buffers (Buffers in /proc/meminfo) and page cache and slabs (Cached and SReclaimable in /proc/meminfo),
	// in kB.
	MemoryBuffersAndCachedKB *int64 `json:"memoryBuffersAndCachedKB,omitempty"`

	// Unused memory (MemFree and SwapFree in /proc/meminfo), in kB.
	MemoryFreeKB *int64 `json:"memoryFreeKB,omitempty"`

	// Total installed memory (MemTotal and SwapTotal in /proc/meminfo), in kB.
	MemoryTotalKB *int64 `json:"memoryTotalKB,omitempty"`

	// Used memory (calculated as total - free - buffers - cache), in kB.
	MemoryUsedKB *int64 `json:"memoryUsedKB,omitempty"`

	// The rack this node is part of.
	Rack *string `json:"rack,omitempty"`
	Size *int32  `json:"size,omitempty"`

	// The state of the node in Cassandra ring.
	State  *NodeState `json:"state,omitempty"`
	Status *string    `json:"status,omitempty"`

	// The timestamp at which that snapshot of these usage statistics were taken.
	Timestamp *string `json:"timestamp,omitempty"`

	// List of tokens this node covers.
	Tokens []*string `json:"tokens,omitempty"`
}

type CompositePath struct {
	// Sort order for composite paths.
	Order *CompositePathSortOrder `json:"order,omitempty"`

	// The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
}

// ConflictResolutionPolicy - The conflict resolution policy for the container.
type ConflictResolutionPolicy struct {
	// The conflict resolution path in the case of LastWriterWins mode.
	ConflictResolutionPath *string `json:"conflictResolutionPath,omitempty"`

	// The procedure to resolve conflicts in the case of custom mode.
	ConflictResolutionProcedure *string `json:"conflictResolutionProcedure,omitempty"`

	// Indicates the conflict resolution mode.
	Mode *ConflictResolutionMode `json:"mode,omitempty"`
}

type ConnectionError struct {
	// The kind of connection error that occurred.
	ConnectionState *ConnectionState `json:"connectionState,omitempty"`

	// Detailed error message about the failed connection.
	Exception *string `json:"exception,omitempty"`

	// The IP of host that originated the failed connection.
	IPFrom *string `json:"iPFrom,omitempty"`

	// The IP that the connection attempted to reach.
	IPTo *string `json:"iPTo,omitempty"`

	// The TCP port the connection was attempted on.
	Port *int32 `json:"port,omitempty"`
}

// ConsistencyPolicy - The consistency policy for the Cosmos DB database account.
type ConsistencyPolicy struct {
	// REQUIRED; The default consistency level and configuration settings of the Cosmos DB account.
	DefaultConsistencyLevel *DefaultConsistencyLevel `json:"defaultConsistencyLevel,omitempty"`

	// When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds)
	// tolerated. Accepted range for this value is 5 - 86400. Required when
	// defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxIntervalInSeconds *int32 `json:"maxIntervalInSeconds,omitempty"`

	// When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted
	// range for this value is 1 – 2,147,483,647. Required when
	// defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxStalenessPrefix *int64 `json:"maxStalenessPrefix,omitempty"`
}

// ContainerPartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
type ContainerPartitionKey struct {
	// Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are
	// supported for container create
	Kind *PartitionKind `json:"kind,omitempty"`

	// List of paths using which data within the container can be partitioned
	Paths []*string `json:"paths,omitempty"`

	// Indicates the version of the partition key definition
	Version *int32 `json:"version,omitempty"`

	// READ-ONLY; Indicates if the container is using a system generated partition key
	SystemKey *bool `json:"systemKey,omitempty" azure:"ro"`
}

// ContinuousBackupInformation - Information about the status of continuous backups.
type ContinuousBackupInformation struct {
	// The latest restorable timestamp for a resource.
	LatestRestorableTimestamp *string `json:"latestRestorableTimestamp,omitempty"`
}

// ContinuousBackupRestoreLocation - Properties of the regional restorable account.
type ContinuousBackupRestoreLocation struct {
	// The name of the continuous backup restore location.
	Location *string `json:"location,omitempty"`
}

// ContinuousModeBackupPolicy - The object representing continuous mode backup policy.
type ContinuousModeBackupPolicy struct {
	// REQUIRED; Describes the mode of backups.
	Type *BackupPolicyType `json:"type,omitempty"`

	// Configuration values for continuous mode backup
	ContinuousModeProperties *ContinuousModeProperties `json:"continuousModeProperties,omitempty"`

	// The object representing the state of the migration between the backup policies.
	MigrationState *BackupPolicyMigrationState `json:"migrationState,omitempty"`
}

// GetBackupPolicy implements the BackupPolicyClassification interface for type ContinuousModeBackupPolicy.
func (c *ContinuousModeBackupPolicy) GetBackupPolicy() *BackupPolicy {
	return &BackupPolicy{
		Type:           c.Type,
		MigrationState: c.MigrationState,
	}
}

// ContinuousModeProperties - Configuration values for periodic mode backup
type ContinuousModeProperties struct {
	// Enum to indicate type of Continuos backup mode
	Tier *ContinuousTier `json:"tier,omitempty"`
}

// CorsPolicy - The CORS policy for the Cosmos DB database account.
type CorsPolicy struct {
	// REQUIRED; The origin domains that are permitted to make a request against the service via CORS.
	AllowedOrigins *string `json:"allowedOrigins,omitempty"`

	// The request headers that the origin domain may specify on the CORS request.
	AllowedHeaders *string `json:"allowedHeaders,omitempty"`

	// The methods (HTTP request verbs) that the origin domain may use for a CORS request.
	AllowedMethods *string `json:"allowedMethods,omitempty"`

	// The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
	ExposedHeaders *string `json:"exposedHeaders,omitempty"`

	// The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds *int64 `json:"maxAgeInSeconds,omitempty"`
}

// CreateJobRequest - Parameters to create Data Transfer Job
type CreateJobRequest struct {
	// REQUIRED; Data Transfer Create Job Properties
	Properties *DataTransferJobProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are "If-Match", "If-None-Match",
// "Session-Token" and "Throughput"
type CreateUpdateOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Request Units per second. For example, "throughput": 10000.
	Throughput *int32 `json:"throughput,omitempty"`
}

// DataCenterResource - A managed Cassandra data center.
type DataCenterResource struct {
	// Properties of a managed Cassandra data center.
	Properties *DataCenterResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataCenterResourceProperties - Properties of a managed Cassandra data center.
type DataCenterResourceProperties struct {
	// Ldap authentication method properties. This feature is in preview.
	AuthenticationMethodLdapProperties *AuthenticationMethodLdapProperties `json:"authenticationMethodLdapProperties,omitempty"`

	// If the data center has Availability Zone feature, apply it to the Virtual Machine ScaleSet that host the cassandra data
	// center virtual machines.
	AvailabilityZone *bool `json:"availabilityZone,omitempty"`

	// Indicates the Key Uri of the customer key to use for encryption of the backup storage account.
	BackupStorageCustomerKeyURI *string `json:"backupStorageCustomerKeyUri,omitempty"`

	// A fragment of a cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this data center.
	// The fragment should be Base64 encoded, and only a subset of keys are allowed.
	Base64EncodedCassandraYamlFragment *string `json:"base64EncodedCassandraYamlFragment,omitempty"`

	// The region this data center should be created in.
	DataCenterLocation *string `json:"dataCenterLocation,omitempty"`

	// Resource id of a subnet the nodes in this data center should have their network interfaces connected to. The subnet must
	// be in the same region specified in 'dataCenterLocation' and must be able to
	// route to the subnet specified in the cluster's 'delegatedManagementSubnetId' property. This resource id will be of the
	// form '/subscriptions//resourceGroups/
	// /providers/Microsoft.Network/virtualNetworks//subnets/'.
	DelegatedSubnetID *string `json:"delegatedSubnetId,omitempty"`

	// Number of disk used for data centers. Default value is 4.
	DiskCapacity *int32 `json:"diskCapacity,omitempty"`

	// Disk SKU used for data centers. Default value is P30.
	DiskSKU *string `json:"diskSku,omitempty"`

	// Key uri to use for encryption of managed disks. Ensure the system assigned identity of the cluster has been assigned appropriate
	// permissions(key get/wrap/unwrap permissions) on the key.
	ManagedDiskCustomerKeyURI *string `json:"managedDiskCustomerKeyUri,omitempty"`

	// The number of nodes the data center should have. This is the desired number. After it is set, it may take some time for
	// the data center to be scaled to match. To monitor the number of nodes and their
	// status, use the fetchNodeStatus method on the cluster.
	NodeCount *int32 `json:"nodeCount,omitempty"`

	// The status of the resource at the time the operation was called.
	ProvisioningState *ManagedCassandraProvisioningState `json:"provisioningState,omitempty"`

	// Virtual Machine SKU used for data centers. Default value is StandardDS14v2
	SKU *string `json:"sku,omitempty"`

	// READ-ONLY; IP addresses for seed nodes in this data center. This is for reference. Generally you will want to use the seedNodes
	// property on the cluster, which aggregates the seed nodes from all data centers in
	// the cluster.
	SeedNodes []*SeedNode `json:"seedNodes,omitempty" azure:"ro"`
}

// DataTransferDataSourceSinkClassification provides polymorphic access to related types.
// Call the interface's GetDataTransferDataSourceSink() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureBlobDataTransferDataSourceSink, *CassandraDataTransferDataSourceSink, *DataTransferDataSourceSink, *SQLDataTransferDataSourceSink
type DataTransferDataSourceSinkClassification interface {
	// GetDataTransferDataSourceSink returns the DataTransferDataSourceSink content of the underlying type.
	GetDataTransferDataSourceSink() *DataTransferDataSourceSink
}

// DataTransferDataSourceSink - Base class for all DataTransfer source/sink
type DataTransferDataSourceSink struct {
	// REQUIRED
	Component *DataTransferComponent `json:"component,omitempty"`
}

// GetDataTransferDataSourceSink implements the DataTransferDataSourceSinkClassification interface for type DataTransferDataSourceSink.
func (d *DataTransferDataSourceSink) GetDataTransferDataSourceSink() *DataTransferDataSourceSink {
	return d
}

// DataTransferJobFeedResults - The List operation response, that contains the Data Transfer jobs and their properties.
type DataTransferJobFeedResults struct {
	// READ-ONLY; URL to get the next set of Data Transfer job list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Data Transfer jobs and their properties.
	Value []*DataTransferJobGetResults `json:"value,omitempty" azure:"ro"`
}

// DataTransferJobGetResults - A Cosmos DB Data Transfer Job
type DataTransferJobGetResults struct {
	// The properties of a DataTransfer Job
	Properties *DataTransferJobProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataTransferJobProperties - The properties of a DataTransfer Job
type DataTransferJobProperties struct {
	// REQUIRED; Destination DataStore details
	Destination DataTransferDataSourceSinkClassification `json:"destination,omitempty"`

	// REQUIRED; Source DataStore details
	Source DataTransferDataSourceSinkClassification `json:"source,omitempty"`

	// Worker count
	WorkerCount *int32 `json:"workerCount,omitempty"`

	// READ-ONLY; Error response for Faulted job
	Error *ErrorResponse `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Job Name
	JobName *string `json:"jobName,omitempty" azure:"ro"`

	// READ-ONLY; Last Updated Time (ISO-8601 format).
	LastUpdatedUTCTime *time.Time `json:"lastUpdatedUtcTime,omitempty" azure:"ro"`

	// READ-ONLY; Processed Count.
	ProcessedCount *int64 `json:"processedCount,omitempty" azure:"ro"`

	// READ-ONLY; Job Status
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Total Count.
	TotalCount *int64 `json:"totalCount,omitempty" azure:"ro"`
}

// DataTransferJobsClientCancelOptions contains the optional parameters for the DataTransferJobsClient.Cancel method.
type DataTransferJobsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// DataTransferJobsClientCreateOptions contains the optional parameters for the DataTransferJobsClient.Create method.
type DataTransferJobsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// DataTransferJobsClientGetOptions contains the optional parameters for the DataTransferJobsClient.Get method.
type DataTransferJobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataTransferJobsClientListByDatabaseAccountOptions contains the optional parameters for the DataTransferJobsClient.ListByDatabaseAccount
// method.
type DataTransferJobsClientListByDatabaseAccountOptions struct {
	// placeholder for future optional parameters
}

// DataTransferJobsClientPauseOptions contains the optional parameters for the DataTransferJobsClient.Pause method.
type DataTransferJobsClientPauseOptions struct {
	// placeholder for future optional parameters
}

// DataTransferJobsClientResumeOptions contains the optional parameters for the DataTransferJobsClient.Resume method.
type DataTransferJobsClientResumeOptions struct {
	// placeholder for future optional parameters
}

// DataTransferRegionalServiceResource - Resource for a regional service location.
type DataTransferRegionalServiceResource struct {
	// READ-ONLY; The location name.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The regional service name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus `json:"status,omitempty" azure:"ro"`
}

// DataTransferServiceResource - Describes the service response property.
type DataTransferServiceResource struct {
	// Properties for DataTransferServiceResource.
	Properties *DataTransferServiceResourceProperties `json:"properties,omitempty"`
}

// DataTransferServiceResourceProperties - Properties for DataTransferServiceResource.
type DataTransferServiceResourceProperties struct {
	// REQUIRED; ServiceType for the service.
	ServiceType *ServiceType `json:"serviceType,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Instance count for the service.
	InstanceCount *int32 `json:"instanceCount,omitempty"`

	// Instance type for the service.
	InstanceSize *ServiceSize `json:"instanceSize,omitempty"`

	// READ-ONLY; Time of the last state change (ISO-8601 format).
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; An array that contains all of the locations for the service.
	Locations []*DataTransferRegionalServiceResource `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus `json:"status,omitempty" azure:"ro"`
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type DataTransferServiceResourceProperties.
func (d *DataTransferServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return &ServiceResourceProperties{
		CreationTime:         d.CreationTime,
		InstanceSize:         d.InstanceSize,
		InstanceCount:        d.InstanceCount,
		ServiceType:          d.ServiceType,
		Status:               d.Status,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DatabaseAccountConnectionString - Connection string for the Cosmos DB account
type DatabaseAccountConnectionString struct {
	// READ-ONLY; Value of the connection string
	ConnectionString *string `json:"connectionString,omitempty" azure:"ro"`

	// READ-ONLY; Description of the connection string
	Description *string `json:"description,omitempty" azure:"ro"`
}

// DatabaseAccountCreateUpdateParameters - Parameters to create and update Cosmos DB database accounts.
type DatabaseAccountCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB database accounts.
	Properties *DatabaseAccountCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Indicates the type of database account. This can only be set at database account creation.
	Kind *DatabaseAccountKind `json:"kind,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseAccountCreateUpdateProperties - Properties to create and update Azure Cosmos DB database accounts.
type DatabaseAccountCreateUpdateProperties struct {
	// CONSTANT; The offer type for the database
	// Field has constant value "Standard", any specified value is ignored.
	DatabaseAccountOfferType *string `json:"databaseAccountOfferType,omitempty"`

	// REQUIRED; An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations []*Location `json:"locations,omitempty"`

	// API specific properties. Currently, supported only for MongoDB API.
	APIProperties *APIProperties `json:"apiProperties,omitempty"`

	// Analytical storage specific properties.
	AnalyticalStorageConfiguration *AnalyticalStorageConfiguration `json:"analyticalStorageConfiguration,omitempty"`

	// The object representing the policy for taking backups on an account.
	BackupPolicy BackupPolicyClassification `json:"backupPolicy,omitempty"`

	// List of Cosmos DB capabilities for the account
	Capabilities []*Capability `json:"capabilities,omitempty"`

	// The object that represents all properties related to capacity enforcement on an account.
	Capacity *Capacity `json:"capacity,omitempty"`

	// The cassandra connector offer type for the Cosmos DB database C* account.
	ConnectorOffer *ConnectorOffer `json:"connectorOffer,omitempty"`

	// The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`

	// The CORS policy for the Cosmos DB database account.
	Cors []*CorsPolicy `json:"cors,omitempty"`

	// Enum to indicate the mode of account creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// The default identity for accessing key vault used in features like customer managed keys. The default identity needs to
	// be explicitly set by the users. It can be "FirstPartyIdentity",
	// "SystemAssignedIdentity" and more.
	DefaultIdentity *string `json:"defaultIdentity,omitempty"`

	// The Object representing the different Diagnostic log settings for the Cosmos DB Account.
	DiagnosticLogSettings *DiagnosticLogSettings `json:"diagnosticLogSettings,omitempty"`

	// Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`

	// Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool `json:"enableAnalyticalStorage,omitempty"`

	// Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic
	// failover will result in a new write region for the account and is chosen
	// based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`

	// Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`

	// Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool `json:"enableFreeTier,omitempty"`

	// Flag to indicate whether to enable MaterializedViews on the Cosmos DB account
	EnableMaterializedViews *bool `json:"enableMaterializedViews,omitempty"`

	// Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`

	// Flag to indicate enabling/disabling of Partition Merge feature on the account
	EnablePartitionMerge *bool `json:"enablePartitionMerge,omitempty"`

	// List of IpRules.
	IPRules []*IPAddressOrRange `json:"ipRules,omitempty"`

	// Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`

	// The URI of the key vault
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`

	// Indicates what services are allowed to bypass firewall checks.
	NetworkACLBypass *NetworkACLBypass `json:"networkAclBypass,omitempty"`

	// An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
	NetworkACLBypassResourceIDs []*string `json:"networkAclBypassResourceIds,omitempty"`

	// Whether requests from Public Network are allowed
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Parameters to indicate the information about the restore.
	RestoreParameters *RestoreParameters `json:"restoreParameters,omitempty"`

	// List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules []*VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`

	// READ-ONLY; This property is ignored during the update/create operation, as the metadata is read-only. The object represents
	// the metadata for the Account Keys of the Cosmos DB account.
	KeysMetadata *DatabaseAccountKeysMetadata `json:"keysMetadata,omitempty" azure:"ro"`
}

// DatabaseAccountGetProperties - Properties for the database account.
type DatabaseAccountGetProperties struct {
	// API specific properties.
	APIProperties *APIProperties `json:"apiProperties,omitempty"`

	// Analytical storage specific properties.
	AnalyticalStorageConfiguration *AnalyticalStorageConfiguration `json:"analyticalStorageConfiguration,omitempty"`

	// The object representing the policy for taking backups on an account.
	BackupPolicy BackupPolicyClassification `json:"backupPolicy,omitempty"`

	// List of Cosmos DB capabilities for the account
	Capabilities []*Capability `json:"capabilities,omitempty"`

	// The object that represents all properties related to capacity enforcement on an account.
	Capacity *Capacity `json:"capacity,omitempty"`

	// The cassandra connector offer type for the Cosmos DB database C* account.
	ConnectorOffer *ConnectorOffer `json:"connectorOffer,omitempty"`

	// The consistency policy for the Cosmos DB database account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`

	// The CORS policy for the Cosmos DB database account.
	Cors []*CorsPolicy `json:"cors,omitempty"`

	// Enum to indicate the mode of account creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// The default identity for accessing key vault used in features like customer managed keys. The default identity needs to
	// be explicitly set by the users. It can be "FirstPartyIdentity",
	// "SystemAssignedIdentity" and more.
	DefaultIdentity *string `json:"defaultIdentity,omitempty"`

	// The Object representing the different Diagnostic log settings for the Cosmos DB Account.
	DiagnosticLogSettings *DiagnosticLogSettings `json:"diagnosticLogSettings,omitempty"`

	// Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`

	// Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool `json:"enableAnalyticalStorage,omitempty"`

	// Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic
	// failover will result in a new write region for the account and is chosen
	// based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`

	// Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`

	// Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool `json:"enableFreeTier,omitempty"`

	// Flag to indicate whether to enable MaterializedViews on the Cosmos DB account
	EnableMaterializedViews *bool `json:"enableMaterializedViews,omitempty"`

	// Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`

	// Flag to indicate enabling/disabling of Partition Merge feature on the account
	EnablePartitionMerge *bool `json:"enablePartitionMerge,omitempty"`

	// List of IpRules.
	IPRules []*IPAddressOrRange `json:"ipRules,omitempty"`

	// Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`

	// The URI of the key vault
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`

	// Indicates what services are allowed to bypass firewall checks.
	NetworkACLBypass *NetworkACLBypass `json:"networkAclBypass,omitempty"`

	// An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
	NetworkACLBypassResourceIDs []*string `json:"networkAclBypassResourceIds,omitempty"`

	// Whether requests from Public Network are allowed
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Parameters to indicate the information about the restore.
	RestoreParameters *RestoreParameters `json:"restoreParameters,omitempty"`

	// List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules []*VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`

	// READ-ONLY; The offer type for the Cosmos DB database account. Default value: Standard.
	DatabaseAccountOfferType *string `json:"databaseAccountOfferType,omitempty" azure:"ro"`

	// READ-ONLY; The connection endpoint for the Cosmos DB database account.
	DocumentEndpoint *string `json:"documentEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; An array that contains the regions ordered by their failover priorities.
	FailoverPolicies []*FailoverPolicy `json:"failoverPolicies,omitempty" azure:"ro"`

	// READ-ONLY; A unique identifier assigned to the database account
	InstanceID *string `json:"instanceId,omitempty" azure:"ro"`

	// READ-ONLY; The object that represents the metadata for the Account Keys of the Cosmos DB account.
	KeysMetadata *DatabaseAccountKeysMetadata `json:"keysMetadata,omitempty" azure:"ro"`

	// READ-ONLY; An array that contains all of the locations enabled for the Cosmos DB account.
	Locations []*Location `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; List of Private Endpoint Connections configured for the Cosmos DB account.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The status of the Cosmos DB account at the time the operation was called. The status can be one of following.
	// 'Creating' – the Cosmos DB account is being created. When an account is in Creating state,
	// only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the
	// Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being
	// updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed'
	// – the Cosmos DB account deletion failed.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; An array that contains of the read locations enabled for the Cosmos DB account.
	ReadLocations []*Location `json:"readLocations,omitempty" azure:"ro"`

	// READ-ONLY; An array that contains the write location for the Cosmos DB account.
	WriteLocations []*Location `json:"writeLocations,omitempty" azure:"ro"`
}

// DatabaseAccountGetResults - An Azure Cosmos DB database account.
type DatabaseAccountGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Indicates the type of database account. This can only be set at database account creation.
	Kind *DatabaseAccountKind `json:"kind,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Properties for the database account.
	Properties *DatabaseAccountGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseAccountKeysMetadata - The metadata related to each access key for the given Cosmos DB database account.
type DatabaseAccountKeysMetadata struct {
	// READ-ONLY; The metadata related to the Primary Read-Write Key for the given Cosmos DB database account.
	PrimaryMasterKey *AccountKeyMetadata `json:"primaryMasterKey,omitempty" azure:"ro"`

	// READ-ONLY; The metadata related to the Primary Read-Only Key for the given Cosmos DB database account.
	PrimaryReadonlyMasterKey *AccountKeyMetadata `json:"primaryReadonlyMasterKey,omitempty" azure:"ro"`

	// READ-ONLY; The metadata related to the Secondary Read-Write Key for the given Cosmos DB database account.
	SecondaryMasterKey *AccountKeyMetadata `json:"secondaryMasterKey,omitempty" azure:"ro"`

	// READ-ONLY; The metadata related to the Secondary Read-Only Key for the given Cosmos DB database account.
	SecondaryReadonlyMasterKey *AccountKeyMetadata `json:"secondaryReadonlyMasterKey,omitempty" azure:"ro"`
}

// DatabaseAccountListConnectionStringsResult - The connection strings for the given database account.
type DatabaseAccountListConnectionStringsResult struct {
	// An array that contains the connection strings for the Cosmos DB account.
	ConnectionStrings []*DatabaseAccountConnectionString `json:"connectionStrings,omitempty"`
}

// DatabaseAccountListKeysResult - The access keys for the given database account.
type DatabaseAccountListKeysResult struct {
	// READ-ONLY; Base 64 encoded value of the primary read-write key.
	PrimaryMasterKey *string `json:"primaryMasterKey,omitempty" azure:"ro"`

	// READ-ONLY; Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string `json:"primaryReadonlyMasterKey,omitempty" azure:"ro"`

	// READ-ONLY; Base 64 encoded value of the secondary read-write key.
	SecondaryMasterKey *string `json:"secondaryMasterKey,omitempty" azure:"ro"`

	// READ-ONLY; Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string `json:"secondaryReadonlyMasterKey,omitempty" azure:"ro"`
}

// DatabaseAccountListReadOnlyKeysResult - The read-only access keys for the given database account.
type DatabaseAccountListReadOnlyKeysResult struct {
	// READ-ONLY; Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string `json:"primaryReadonlyMasterKey,omitempty" azure:"ro"`

	// READ-ONLY; Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string `json:"secondaryReadonlyMasterKey,omitempty" azure:"ro"`
}

// DatabaseAccountRegenerateKeyParameters - Parameters to regenerate the keys within the database account.
type DatabaseAccountRegenerateKeyParameters struct {
	// REQUIRED; The access key to regenerate.
	KeyKind *KeyKind `json:"keyKind,omitempty"`
}

// DatabaseAccountRegionClientListMetricsOptions contains the optional parameters for the DatabaseAccountRegionClient.ListMetrics
// method.
type DatabaseAccountRegionClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountUpdateParameters - Parameters for patching Azure Cosmos DB database account properties.
type DatabaseAccountUpdateParameters struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Properties to update Azure Cosmos DB database accounts.
	Properties *DatabaseAccountUpdateProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`
}

// DatabaseAccountUpdateProperties - Properties to update Azure Cosmos DB database accounts.
type DatabaseAccountUpdateProperties struct {
	// API specific properties. Currently, supported only for MongoDB API.
	APIProperties *APIProperties `json:"apiProperties,omitempty"`

	// Analytical storage specific properties.
	AnalyticalStorageConfiguration *AnalyticalStorageConfiguration `json:"analyticalStorageConfiguration,omitempty"`

	// The object representing the policy for taking backups on an account.
	BackupPolicy BackupPolicyClassification `json:"backupPolicy,omitempty"`

	// List of Cosmos DB capabilities for the account
	Capabilities []*Capability `json:"capabilities,omitempty"`

	// The object that represents all properties related to capacity enforcement on an account.
	Capacity *Capacity `json:"capacity,omitempty"`

	// The cassandra connector offer type for the Cosmos DB database C* account.
	ConnectorOffer *ConnectorOffer `json:"connectorOffer,omitempty"`

	// The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`

	// The CORS policy for the Cosmos DB database account.
	Cors []*CorsPolicy `json:"cors,omitempty"`

	// The default identity for accessing key vault used in features like customer managed keys. The default identity needs to
	// be explicitly set by the users. It can be "FirstPartyIdentity",
	// "SystemAssignedIdentity" and more.
	DefaultIdentity *string `json:"defaultIdentity,omitempty"`

	// The Object representing the different Diagnostic log settings for the Cosmos DB Account.
	DiagnosticLogSettings *DiagnosticLogSettings `json:"diagnosticLogSettings,omitempty"`

	// Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`

	// Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool `json:"enableAnalyticalStorage,omitempty"`

	// Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic
	// failover will result in a new write region for the account and is chosen
	// based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`

	// Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`

	// Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool `json:"enableFreeTier,omitempty"`

	// Flag to indicate whether to enable MaterializedViews on the Cosmos DB account
	EnableMaterializedViews *bool `json:"enableMaterializedViews,omitempty"`

	// Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`

	// Flag to indicate enabling/disabling of Partition Merge feature on the account
	EnablePartitionMerge *bool `json:"enablePartitionMerge,omitempty"`

	// List of IpRules.
	IPRules []*IPAddressOrRange `json:"ipRules,omitempty"`

	// Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`

	// The URI of the key vault
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`

	// An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations []*Location `json:"locations,omitempty"`

	// Indicates what services are allowed to bypass firewall checks.
	NetworkACLBypass *NetworkACLBypass `json:"networkAclBypass,omitempty"`

	// An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
	NetworkACLBypassResourceIDs []*string `json:"networkAclBypassResourceIds,omitempty"`

	// Whether requests from Public Network are allowed
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules []*VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`

	// READ-ONLY; This property is ignored during the update operation, as the metadata is read-only. The object represents the
	// metadata for the Account Keys of the Cosmos DB account.
	KeysMetadata *DatabaseAccountKeysMetadata `json:"keysMetadata,omitempty" azure:"ro"`
}

// DatabaseAccountsClientBeginCreateOrUpdateOptions contains the optional parameters for the DatabaseAccountsClient.BeginCreateOrUpdate
// method.
type DatabaseAccountsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabaseAccountsClientBeginDeleteOptions contains the optional parameters for the DatabaseAccountsClient.BeginDelete method.
type DatabaseAccountsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabaseAccountsClientBeginFailoverPriorityChangeOptions contains the optional parameters for the DatabaseAccountsClient.BeginFailoverPriorityChange
// method.
type DatabaseAccountsClientBeginFailoverPriorityChangeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabaseAccountsClientBeginOfflineRegionOptions contains the optional parameters for the DatabaseAccountsClient.BeginOfflineRegion
// method.
type DatabaseAccountsClientBeginOfflineRegionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabaseAccountsClientBeginOnlineRegionOptions contains the optional parameters for the DatabaseAccountsClient.BeginOnlineRegion
// method.
type DatabaseAccountsClientBeginOnlineRegionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabaseAccountsClientBeginRegenerateKeyOptions contains the optional parameters for the DatabaseAccountsClient.BeginRegenerateKey
// method.
type DatabaseAccountsClientBeginRegenerateKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabaseAccountsClientBeginUpdateOptions contains the optional parameters for the DatabaseAccountsClient.BeginUpdate method.
type DatabaseAccountsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabaseAccountsClientCheckNameExistsOptions contains the optional parameters for the DatabaseAccountsClient.CheckNameExists
// method.
type DatabaseAccountsClientCheckNameExistsOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountsClientGetOptions contains the optional parameters for the DatabaseAccountsClient.Get method.
type DatabaseAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountsClientGetReadOnlyKeysOptions contains the optional parameters for the DatabaseAccountsClient.GetReadOnlyKeys
// method.
type DatabaseAccountsClientGetReadOnlyKeysOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountsClientListByResourceGroupOptions contains the optional parameters for the DatabaseAccountsClient.ListByResourceGroup
// method.
type DatabaseAccountsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountsClientListConnectionStringsOptions contains the optional parameters for the DatabaseAccountsClient.ListConnectionStrings
// method.
type DatabaseAccountsClientListConnectionStringsOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountsClientListKeysOptions contains the optional parameters for the DatabaseAccountsClient.ListKeys method.
type DatabaseAccountsClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountsClientListMetricDefinitionsOptions contains the optional parameters for the DatabaseAccountsClient.ListMetricDefinitions
// method.
type DatabaseAccountsClientListMetricDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountsClientListMetricsOptions contains the optional parameters for the DatabaseAccountsClient.ListMetrics method.
type DatabaseAccountsClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountsClientListOptions contains the optional parameters for the DatabaseAccountsClient.List method.
type DatabaseAccountsClientListOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountsClientListReadOnlyKeysOptions contains the optional parameters for the DatabaseAccountsClient.ListReadOnlyKeys
// method.
type DatabaseAccountsClientListReadOnlyKeysOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAccountsClientListUsagesOptions contains the optional parameters for the DatabaseAccountsClient.ListUsages method.
type DatabaseAccountsClientListUsagesOptions struct {
	// An OData filter expression that describes a subset of usages to return. The supported parameter is name.value (name of
	// the metric, can have an or of multiple names).
	Filter *string
}

// DatabaseAccountsListResult - The List operation response, that contains the database accounts and their properties.
type DatabaseAccountsListResult struct {
	// READ-ONLY; List of database account and their properties.
	Value []*DatabaseAccountGetResults `json:"value,omitempty" azure:"ro"`
}

// DatabaseClientListMetricDefinitionsOptions contains the optional parameters for the DatabaseClient.ListMetricDefinitions
// method.
type DatabaseClientListMetricDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// DatabaseClientListMetricsOptions contains the optional parameters for the DatabaseClient.ListMetrics method.
type DatabaseClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// DatabaseClientListUsagesOptions contains the optional parameters for the DatabaseClient.ListUsages method.
type DatabaseClientListUsagesOptions struct {
	// An OData filter expression that describes a subset of usages to return. The supported parameter is name.value (name of
	// the metric, can have an or of multiple names).
	Filter *string
}

// DatabaseRestoreResource - Specific Databases to restore.
type DatabaseRestoreResource struct {
	// The names of the collections available for restore.
	CollectionNames []*string `json:"collectionNames,omitempty"`

	// The name of the database available for restore.
	DatabaseName *string `json:"databaseName,omitempty"`
}

// DiagnosticLogSettings - Indicates what diagnostic log settings are to be enabled.
type DiagnosticLogSettings struct {
	// Describe the level of detail with which queries are to be logged.
	EnableFullTextQuery *EnableFullTextQuery `json:"enableFullTextQuery,omitempty"`
}

// ErrorResponse - Error Response.
type ErrorResponse struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

type ExcludedPath struct {
	// The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
}

// ExtendedResourceProperties - The system generated resource properties associated with SQL databases, SQL containers, Gremlin
// databases and Gremlin graphs.
type ExtendedResourceProperties struct {
	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// FailoverPolicies - The list of new failover policies for the failover priority change.
type FailoverPolicies struct {
	// REQUIRED; List of failover policies.
	FailoverPolicies []*FailoverPolicy `json:"failoverPolicies,omitempty"`
}

// FailoverPolicy - The failover policy for a given region of a database account.
type FailoverPolicy struct {
	// The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover
	// priority = (total number of regions - 1). Failover priority values must be
	// unique for each of the regions in which the database account exists.
	FailoverPriority *int32 `json:"failoverPriority,omitempty"`

	// The name of the region in which the database account exists.
	LocationName *string `json:"locationName,omitempty"`

	// READ-ONLY; The unique identifier of the region in which the database account replicates to. Example: <accountName>-<locationName>.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// GraphAPIComputeRegionalServiceResource - Resource for a regional service location.
type GraphAPIComputeRegionalServiceResource struct {
	// READ-ONLY; The regional endpoint for GraphAPICompute.
	GraphAPIComputeEndpoint *string `json:"graphApiComputeEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The location name.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The regional service name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus `json:"status,omitempty" azure:"ro"`
}

// GraphAPIComputeServiceResource - Describes the service response property for GraphAPICompute.
type GraphAPIComputeServiceResource struct {
	// Properties for GraphAPIComputeServiceResource.
	Properties *GraphAPIComputeServiceResourceProperties `json:"properties,omitempty"`
}

// GraphAPIComputeServiceResourceProperties - Properties for GraphAPIComputeServiceResource.
type GraphAPIComputeServiceResourceProperties struct {
	// REQUIRED; ServiceType for the service.
	ServiceType *ServiceType `json:"serviceType,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// GraphAPICompute endpoint for the service.
	GraphAPIComputeEndpoint *string `json:"graphApiComputeEndpoint,omitempty"`

	// Instance count for the service.
	InstanceCount *int32 `json:"instanceCount,omitempty"`

	// Instance type for the service.
	InstanceSize *ServiceSize `json:"instanceSize,omitempty"`

	// READ-ONLY; Time of the last state change (ISO-8601 format).
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; An array that contains all of the locations for the service.
	Locations []*GraphAPIComputeRegionalServiceResource `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus `json:"status,omitempty" azure:"ro"`
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type GraphAPIComputeServiceResourceProperties.
func (g *GraphAPIComputeServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return &ServiceResourceProperties{
		CreationTime:         g.CreationTime,
		InstanceSize:         g.InstanceSize,
		InstanceCount:        g.InstanceCount,
		ServiceType:          g.ServiceType,
		Status:               g.Status,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GraphResource - Cosmos DB Graph resource object
type GraphResource struct {
	// REQUIRED; Name of the Cosmos DB Graph
	ID *string `json:"id,omitempty"`
}

// GraphResourceCreateUpdateParameters - Parameters to create and update Cosmos DB Graph resource.
type GraphResourceCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Graph resource.
	Properties *GraphResourceCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GraphResourceCreateUpdateProperties - Properties to create and update Azure Cosmos DB Graph resource.
type GraphResourceCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Graph resource
	Resource *GraphResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// GraphResourceGetProperties - The properties of an Azure Cosmos DB SQL database
type GraphResourceGetProperties struct {
	Options  *GraphResourceGetPropertiesOptions  `json:"options,omitempty"`
	Resource *GraphResourceGetPropertiesResource `json:"resource,omitempty"`
}

type GraphResourceGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type GraphResourceGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Graph
	ID *string `json:"id,omitempty"`
}

// GraphResourceGetResults - An Azure Cosmos DB Graph resource.
type GraphResourceGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB Graph resource.
	Properties *GraphResourceGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GraphResourcesClientBeginCreateUpdateGraphOptions contains the optional parameters for the GraphResourcesClient.BeginCreateUpdateGraph
// method.
type GraphResourcesClientBeginCreateUpdateGraphOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GraphResourcesClientBeginDeleteGraphResourceOptions contains the optional parameters for the GraphResourcesClient.BeginDeleteGraphResource
// method.
type GraphResourcesClientBeginDeleteGraphResourceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GraphResourcesClientGetGraphOptions contains the optional parameters for the GraphResourcesClient.GetGraph method.
type GraphResourcesClientGetGraphOptions struct {
	// placeholder for future optional parameters
}

// GraphResourcesClientListGraphsOptions contains the optional parameters for the GraphResourcesClient.ListGraphs method.
type GraphResourcesClientListGraphsOptions struct {
	// placeholder for future optional parameters
}

// GraphResourcesListResult - The List operation response, that contains the Graph resource and their properties.
type GraphResourcesListResult struct {
	// READ-ONLY; List of Graph resource and their properties.
	Value []*GraphResourceGetResults `json:"value,omitempty" azure:"ro"`
}

// GremlinDatabaseCreateUpdateParameters - Parameters to create and update Cosmos DB Gremlin database.
type GremlinDatabaseCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Gremlin database.
	Properties *GremlinDatabaseCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GremlinDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB Gremlin database.
type GremlinDatabaseCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Gremlin database
	Resource *GremlinDatabaseResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// GremlinDatabaseGetProperties - The properties of an Azure Cosmos DB SQL database
type GremlinDatabaseGetProperties struct {
	Options  *GremlinDatabaseGetPropertiesOptions  `json:"options,omitempty"`
	Resource *GremlinDatabaseGetPropertiesResource `json:"resource,omitempty"`
}

type GremlinDatabaseGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type GremlinDatabaseGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Gremlin database
	ID *string `json:"id,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// GremlinDatabaseGetResults - An Azure Cosmos DB Gremlin database.
type GremlinDatabaseGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB SQL database
	Properties *GremlinDatabaseGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GremlinDatabaseListResult - The List operation response, that contains the Gremlin databases and their properties.
type GremlinDatabaseListResult struct {
	// READ-ONLY; List of Gremlin databases and their properties.
	Value []*GremlinDatabaseGetResults `json:"value,omitempty" azure:"ro"`
}

// GremlinDatabaseResource - Cosmos DB Gremlin database resource object
type GremlinDatabaseResource struct {
	// REQUIRED; Name of the Cosmos DB Gremlin database
	ID *string `json:"id,omitempty"`
}

// GremlinDatabaseRestoreResource - Specific Gremlin Databases to restore.
type GremlinDatabaseRestoreResource struct {
	// The name of the gremlin database available for restore.
	DatabaseName *string `json:"databaseName,omitempty"`

	// The names of the graphs available for restore.
	GraphNames []*string `json:"graphNames,omitempty"`
}

// GremlinGraphCreateUpdateParameters - Parameters to create and update Cosmos DB Gremlin graph.
type GremlinGraphCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Gremlin graph.
	Properties *GremlinGraphCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GremlinGraphCreateUpdateProperties - Properties to create and update Azure Cosmos DB Gremlin graph.
type GremlinGraphCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Gremlin graph
	Resource *GremlinGraphResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// GremlinGraphGetProperties - The properties of an Azure Cosmos DB Gremlin graph
type GremlinGraphGetProperties struct {
	Options  *GremlinGraphGetPropertiesOptions  `json:"options,omitempty"`
	Resource *GremlinGraphGetPropertiesResource `json:"resource,omitempty"`
}

type GremlinGraphGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type GremlinGraphGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Gremlin graph
	ID *string `json:"id,omitempty"`

	// Analytical TTL.
	AnalyticalStorageTTL *int64 `json:"analyticalStorageTtl,omitempty"`

	// The conflict resolution policy for the graph.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`

	// Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`

	// The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`

	// The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`

	// The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos
	// DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// GremlinGraphGetResults - An Azure Cosmos DB Gremlin graph.
type GremlinGraphGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB Gremlin graph
	Properties *GremlinGraphGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GremlinGraphListResult - The List operation response, that contains the graphs and their properties.
type GremlinGraphListResult struct {
	// READ-ONLY; List of graphs and their properties.
	Value []*GremlinGraphGetResults `json:"value,omitempty" azure:"ro"`
}

// GremlinGraphResource - Cosmos DB Gremlin graph resource object
type GremlinGraphResource struct {
	// REQUIRED; Name of the Cosmos DB Gremlin graph
	ID *string `json:"id,omitempty"`

	// Analytical TTL.
	AnalyticalStorageTTL *int64 `json:"analyticalStorageTtl,omitempty"`

	// The conflict resolution policy for the graph.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`

	// Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`

	// The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`

	// The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`

	// The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos
	// DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
}

// GremlinResourcesClientBeginCreateUpdateGremlinDatabaseOptions contains the optional parameters for the GremlinResourcesClient.BeginCreateUpdateGremlinDatabase
// method.
type GremlinResourcesClientBeginCreateUpdateGremlinDatabaseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientBeginCreateUpdateGremlinGraphOptions contains the optional parameters for the GremlinResourcesClient.BeginCreateUpdateGremlinGraph
// method.
type GremlinResourcesClientBeginCreateUpdateGremlinGraphOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientBeginDeleteGremlinDatabaseOptions contains the optional parameters for the GremlinResourcesClient.BeginDeleteGremlinDatabase
// method.
type GremlinResourcesClientBeginDeleteGremlinDatabaseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientBeginDeleteGremlinGraphOptions contains the optional parameters for the GremlinResourcesClient.BeginDeleteGremlinGraph
// method.
type GremlinResourcesClientBeginDeleteGremlinGraphOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientBeginMigrateGremlinDatabaseToAutoscaleOptions contains the optional parameters for the GremlinResourcesClient.BeginMigrateGremlinDatabaseToAutoscale
// method.
type GremlinResourcesClientBeginMigrateGremlinDatabaseToAutoscaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientBeginMigrateGremlinDatabaseToManualThroughputOptions contains the optional parameters for the GremlinResourcesClient.BeginMigrateGremlinDatabaseToManualThroughput
// method.
type GremlinResourcesClientBeginMigrateGremlinDatabaseToManualThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientBeginMigrateGremlinGraphToAutoscaleOptions contains the optional parameters for the GremlinResourcesClient.BeginMigrateGremlinGraphToAutoscale
// method.
type GremlinResourcesClientBeginMigrateGremlinGraphToAutoscaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientBeginMigrateGremlinGraphToManualThroughputOptions contains the optional parameters for the GremlinResourcesClient.BeginMigrateGremlinGraphToManualThroughput
// method.
type GremlinResourcesClientBeginMigrateGremlinGraphToManualThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientBeginRetrieveContinuousBackupInformationOptions contains the optional parameters for the GremlinResourcesClient.BeginRetrieveContinuousBackupInformation
// method.
type GremlinResourcesClientBeginRetrieveContinuousBackupInformationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientBeginUpdateGremlinDatabaseThroughputOptions contains the optional parameters for the GremlinResourcesClient.BeginUpdateGremlinDatabaseThroughput
// method.
type GremlinResourcesClientBeginUpdateGremlinDatabaseThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientBeginUpdateGremlinGraphThroughputOptions contains the optional parameters for the GremlinResourcesClient.BeginUpdateGremlinGraphThroughput
// method.
type GremlinResourcesClientBeginUpdateGremlinGraphThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GremlinResourcesClientGetGremlinDatabaseOptions contains the optional parameters for the GremlinResourcesClient.GetGremlinDatabase
// method.
type GremlinResourcesClientGetGremlinDatabaseOptions struct {
	// placeholder for future optional parameters
}

// GremlinResourcesClientGetGremlinDatabaseThroughputOptions contains the optional parameters for the GremlinResourcesClient.GetGremlinDatabaseThroughput
// method.
type GremlinResourcesClientGetGremlinDatabaseThroughputOptions struct {
	// placeholder for future optional parameters
}

// GremlinResourcesClientGetGremlinGraphOptions contains the optional parameters for the GremlinResourcesClient.GetGremlinGraph
// method.
type GremlinResourcesClientGetGremlinGraphOptions struct {
	// placeholder for future optional parameters
}

// GremlinResourcesClientGetGremlinGraphThroughputOptions contains the optional parameters for the GremlinResourcesClient.GetGremlinGraphThroughput
// method.
type GremlinResourcesClientGetGremlinGraphThroughputOptions struct {
	// placeholder for future optional parameters
}

// GremlinResourcesClientListGremlinDatabasesOptions contains the optional parameters for the GremlinResourcesClient.ListGremlinDatabases
// method.
type GremlinResourcesClientListGremlinDatabasesOptions struct {
	// placeholder for future optional parameters
}

// GremlinResourcesClientListGremlinGraphsOptions contains the optional parameters for the GremlinResourcesClient.ListGremlinGraphs
// method.
type GremlinResourcesClientListGremlinGraphsOptions struct {
	// placeholder for future optional parameters
}

// IPAddressOrRange - IpAddressOrRange object
type IPAddressOrRange struct {
	// A single IPv4 address or a single IPv4 address range in CIDR format. Provided IPs must be well-formatted and cannot be
	// contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10,
	// 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs: “23.40.210.245”
	// or “23.40.210.0/8”.
	IPAddressOrRange *string `json:"ipAddressOrRange,omitempty"`
}

// IncludedPath - The paths that are included in indexing
type IncludedPath struct {
	// List of indexes for this path
	Indexes []*Indexes `json:"indexes,omitempty"`

	// The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
}

// Indexes - The indexes for the path.
type Indexes struct {
	// The datatype for which the indexing behavior is applied to.
	DataType *DataType `json:"dataType,omitempty"`

	// Indicates the type of index.
	Kind *IndexKind `json:"kind,omitempty"`

	// The precision of the index. -1 is maximum precision.
	Precision *int32 `json:"precision,omitempty"`
}

// IndexingPolicy - Cosmos DB indexing policy
type IndexingPolicy struct {
	// Indicates if the indexing policy is automatic
	Automatic *bool `json:"automatic,omitempty"`

	// List of composite path list
	CompositeIndexes [][]*CompositePath `json:"compositeIndexes,omitempty"`

	// List of paths to exclude from indexing
	ExcludedPaths []*ExcludedPath `json:"excludedPaths,omitempty"`

	// List of paths to include in the indexing
	IncludedPaths []*IncludedPath `json:"includedPaths,omitempty"`

	// Indicates the indexing mode.
	IndexingMode *IndexingMode `json:"indexingMode,omitempty"`

	// List of spatial specifics
	SpatialIndexes []*SpatialSpec `json:"spatialIndexes,omitempty"`
}

// KeyWrapMetadata - Represents key wrap metadata that a key wrapping provider can use to wrap/unwrap a client encryption
// key.
type KeyWrapMetadata struct {
	// Algorithm used in wrapping and unwrapping of the data encryption key.
	Algorithm *string `json:"algorithm,omitempty"`

	// The name of associated KeyEncryptionKey (aka CustomerManagedKey).
	Name *string `json:"name,omitempty"`

	// ProviderName of KeyStoreProvider.
	Type *string `json:"type,omitempty"`

	// Reference / link to the KeyEncryptionKey.
	Value *string `json:"value,omitempty"`
}

// ListBackups - List of restorable backups for a Cassandra cluster.
type ListBackups struct {
	// READ-ONLY; Container for array of backups.
	Value []*BackupResource `json:"value,omitempty" azure:"ro"`
}

// ListClusters - List of managed Cassandra clusters.
type ListClusters struct {
	// Container for the array of clusters.
	Value []*ClusterResource `json:"value,omitempty"`
}

// ListDataCenters - List of managed Cassandra data centers and their properties.
type ListDataCenters struct {
	// READ-ONLY; Container for array of data centers.
	Value []*DataCenterResource `json:"value,omitempty" azure:"ro"`
}

// Location - A region in which the Azure Cosmos DB database account is deployed.
type Location struct {
	// The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover
	// priority = (total number of regions - 1). Failover priority values must be
	// unique for each of the regions in which the database account exists.
	FailoverPriority *int32 `json:"failoverPriority,omitempty"`

	// Flag to indicate whether or not this region is an AvailabilityZone region
	IsZoneRedundant *bool `json:"isZoneRedundant,omitempty"`

	// The name of the region.
	LocationName *string `json:"locationName,omitempty"`

	// READ-ONLY; The connection endpoint for the specific region. Example: https://<accountName>-<locationName>.documents.azure.com:443/
	DocumentEndpoint *string `json:"documentEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The unique identifier of the region within the database account. Example: <accountName>-<locationName>.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The status of the Cosmos DB account at the time the operation was called. The status can be one of following.
	// 'Creating' – the Cosmos DB account is being created. When an account is in Creating state,
	// only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the
	// Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being
	// updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed'
	// – the Cosmos DB account deletion failed.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// LocationGetResult - Cosmos DB location get result
type LocationGetResult struct {
	// Cosmos DB location metadata
	Properties *LocationProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LocationListResult - The List operation response, that contains Cosmos DB locations and their properties.
type LocationListResult struct {
	// READ-ONLY; List of Cosmos DB locations and their properties.
	Value []*LocationGetResult `json:"value,omitempty" azure:"ro"`
}

// LocationProperties - Cosmos DB location metadata
type LocationProperties struct {
	// READ-ONLY; The properties of available backup storage redundancies.
	BackupStorageRedundancies []*BackupStorageRedundancy `json:"backupStorageRedundancies,omitempty" azure:"ro"`

	// READ-ONLY; Flag indicating whether the location is residency sensitive.
	IsResidencyRestricted *bool `json:"isResidencyRestricted,omitempty" azure:"ro"`

	// READ-ONLY; The current status of location in Azure.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Flag indicating whether the location supports availability zones or not.
	SupportsAvailabilityZone *bool `json:"supportsAvailabilityZone,omitempty" azure:"ro"`
}

// LocationsClientGetOptions contains the optional parameters for the LocationsClient.Get method.
type LocationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LocationsClientListOptions contains the optional parameters for the LocationsClient.List method.
type LocationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ManagedCassandraARMResourceProperties - The core properties of ARM resources.
type ManagedCassandraARMResourceProperties struct {
	// Identity for the resource.
	Identity *ManagedCassandraManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedCassandraManagedServiceIdentity - Identity for the resource.
type ManagedCassandraManagedServiceIdentity struct {
	// The type of the resource.
	Type *ManagedCassandraResourceIdentityType `json:"type,omitempty"`

	// READ-ONLY; The object id of the identity resource.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id of the resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

type ManagedCassandraReaperStatus struct {
	Healthy *bool `json:"healthy,omitempty"`

	// Dictionary of
	RepairRunIDs map[string]*string `json:"repairRunIds,omitempty"`

	// Dictionary of
	RepairSchedules map[string]*string `json:"repairSchedules,omitempty"`
}

// ManagedServiceIdentity - Identity for the resource.
type ManagedServiceIdentity struct {
	// The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created
	// identity and a set of user assigned identities. The type 'None' will remove any
	// identities from the service.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MaterializedViewsBuilderRegionalServiceResource - Resource for a regional service location.
type MaterializedViewsBuilderRegionalServiceResource struct {
	// READ-ONLY; The location name.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The regional service name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus `json:"status,omitempty" azure:"ro"`
}

// MaterializedViewsBuilderServiceResource - Describes the service response property for MaterializedViewsBuilder.
type MaterializedViewsBuilderServiceResource struct {
	// Properties for MaterializedViewsBuilderServiceResource.
	Properties *MaterializedViewsBuilderServiceResourceProperties `json:"properties,omitempty"`
}

// MaterializedViewsBuilderServiceResourceProperties - Properties for MaterializedViewsBuilderServiceResource.
type MaterializedViewsBuilderServiceResourceProperties struct {
	// REQUIRED; ServiceType for the service.
	ServiceType *ServiceType `json:"serviceType,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Instance count for the service.
	InstanceCount *int32 `json:"instanceCount,omitempty"`

	// Instance type for the service.
	InstanceSize *ServiceSize `json:"instanceSize,omitempty"`

	// READ-ONLY; Time of the last state change (ISO-8601 format).
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; An array that contains all of the locations for the service.
	Locations []*MaterializedViewsBuilderRegionalServiceResource `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus `json:"status,omitempty" azure:"ro"`
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type MaterializedViewsBuilderServiceResourceProperties.
func (m *MaterializedViewsBuilderServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return &ServiceResourceProperties{
		CreationTime:         m.CreationTime,
		InstanceSize:         m.InstanceSize,
		InstanceCount:        m.InstanceCount,
		ServiceType:          m.ServiceType,
		Status:               m.Status,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MergeParameters - The properties of an Azure Cosmos DB merge operations
type MergeParameters struct {
	// Specifies whether the operation is a real merge operation or a simulation.
	IsDryRun *bool `json:"isDryRun,omitempty"`
}

// Metric data
type Metric struct {
	// READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues []*MetricValue `json:"metricValues,omitempty" azure:"ro"`

	// READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the metric.
	Unit *UnitType `json:"unit,omitempty" azure:"ro"`
}

// MetricAvailability - The availability of the metric.
type MetricAvailability struct {
	// READ-ONLY; The retention for the metric values.
	Retention *string `json:"retention,omitempty" azure:"ro"`

	// READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty" azure:"ro"`
}

// MetricDefinition - The definition of a metric.
type MetricDefinition struct {
	// READ-ONLY; The list of metric availabilities for the account.
	MetricAvailabilities []*MetricAvailability `json:"metricAvailabilities,omitempty" azure:"ro"`

	// READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The primary aggregation type of the metric.
	PrimaryAggregationType *PrimaryAggregationType `json:"primaryAggregationType,omitempty" azure:"ro"`

	// READ-ONLY; The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the metric.
	Unit *UnitType `json:"unit,omitempty" azure:"ro"`
}

// MetricDefinitionsListResult - The response to a list metric definitions request.
type MetricDefinitionsListResult struct {
	// READ-ONLY; The list of metric definitions for the account.
	Value []*MetricDefinition `json:"value,omitempty" azure:"ro"`
}

// MetricListResult - The response to a list metrics request.
type MetricListResult struct {
	// READ-ONLY; The list of metrics for the account.
	Value []*Metric `json:"value,omitempty" azure:"ro"`
}

// MetricName - A metric name.
type MetricName struct {
	// READ-ONLY; The friendly name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`

	// READ-ONLY; The name of the metric.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// MetricValue - Represents metrics values.
type MetricValue struct {
	// READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty" azure:"ro"`

	// READ-ONLY; The number of values for the metric.
	Count *int32 `json:"_count,omitempty" azure:"ro"`

	// READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty" azure:"ro"`
}

// MongoDBCollectionCreateUpdateParameters - Parameters to create and update Cosmos DB MongoDB collection.
type MongoDBCollectionCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB MongoDB collection.
	Properties *MongoDBCollectionCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MongoDBCollectionCreateUpdateProperties - Properties to create and update Azure Cosmos DB MongoDB collection.
type MongoDBCollectionCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a MongoDB collection
	Resource *MongoDBCollectionResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// MongoDBCollectionGetProperties - The properties of an Azure Cosmos DB MongoDB collection
type MongoDBCollectionGetProperties struct {
	Options  *MongoDBCollectionGetPropertiesOptions  `json:"options,omitempty"`
	Resource *MongoDBCollectionGetPropertiesResource `json:"resource,omitempty"`
}

type MongoDBCollectionGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type MongoDBCollectionGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB MongoDB collection
	ID *string `json:"id,omitempty"`

	// Analytical TTL.
	AnalyticalStorageTTL *int32 `json:"analyticalStorageTtl,omitempty"`

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// List of index keys
	Indexes []*MongoIndex `json:"indexes,omitempty"`

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters `json:"restoreParameters,omitempty"`

	// A key-value pair of shard keys to be applied for the request.
	ShardKey map[string]*string `json:"shardKey,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// MongoDBCollectionGetResults - An Azure Cosmos DB MongoDB collection.
type MongoDBCollectionGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB MongoDB collection
	Properties *MongoDBCollectionGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MongoDBCollectionListResult - The List operation response, that contains the MongoDB collections and their properties.
type MongoDBCollectionListResult struct {
	// READ-ONLY; List of MongoDB collections and their properties.
	Value []*MongoDBCollectionGetResults `json:"value,omitempty" azure:"ro"`
}

// MongoDBCollectionResource - Cosmos DB MongoDB collection resource object
type MongoDBCollectionResource struct {
	// REQUIRED; Name of the Cosmos DB MongoDB collection
	ID *string `json:"id,omitempty"`

	// Analytical TTL.
	AnalyticalStorageTTL *int32 `json:"analyticalStorageTtl,omitempty"`

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// List of index keys
	Indexes []*MongoIndex `json:"indexes,omitempty"`

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters `json:"restoreParameters,omitempty"`

	// A key-value pair of shard keys to be applied for the request.
	ShardKey map[string]*string `json:"shardKey,omitempty"`
}

// MongoDBDatabaseCreateUpdateParameters - Parameters to create and update Cosmos DB MongoDB database.
type MongoDBDatabaseCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB MongoDB database.
	Properties *MongoDBDatabaseCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MongoDBDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB MongoDB database.
type MongoDBDatabaseCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a MongoDB database
	Resource *MongoDBDatabaseResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// MongoDBDatabaseGetProperties - The properties of an Azure Cosmos DB MongoDB database
type MongoDBDatabaseGetProperties struct {
	Options  *MongoDBDatabaseGetPropertiesOptions  `json:"options,omitempty"`
	Resource *MongoDBDatabaseGetPropertiesResource `json:"resource,omitempty"`
}

type MongoDBDatabaseGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type MongoDBDatabaseGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB MongoDB database
	ID *string `json:"id,omitempty"`

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters `json:"restoreParameters,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// MongoDBDatabaseGetResults - An Azure Cosmos DB MongoDB database.
type MongoDBDatabaseGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB MongoDB database
	Properties *MongoDBDatabaseGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MongoDBDatabaseListResult - The List operation response, that contains the MongoDB databases and their properties.
type MongoDBDatabaseListResult struct {
	// READ-ONLY; List of MongoDB databases and their properties.
	Value []*MongoDBDatabaseGetResults `json:"value,omitempty" azure:"ro"`
}

// MongoDBDatabaseResource - Cosmos DB MongoDB database resource object
type MongoDBDatabaseResource struct {
	// REQUIRED; Name of the Cosmos DB MongoDB database
	ID *string `json:"id,omitempty"`

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters `json:"restoreParameters,omitempty"`
}

// MongoDBResourcesClientBeginCreateUpdateMongoDBCollectionOptions contains the optional parameters for the MongoDBResourcesClient.BeginCreateUpdateMongoDBCollection
// method.
type MongoDBResourcesClientBeginCreateUpdateMongoDBCollectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginCreateUpdateMongoDBDatabaseOptions contains the optional parameters for the MongoDBResourcesClient.BeginCreateUpdateMongoDBDatabase
// method.
type MongoDBResourcesClientBeginCreateUpdateMongoDBDatabaseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginCreateUpdateMongoRoleDefinitionOptions contains the optional parameters for the MongoDBResourcesClient.BeginCreateUpdateMongoRoleDefinition
// method.
type MongoDBResourcesClientBeginCreateUpdateMongoRoleDefinitionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginCreateUpdateMongoUserDefinitionOptions contains the optional parameters for the MongoDBResourcesClient.BeginCreateUpdateMongoUserDefinition
// method.
type MongoDBResourcesClientBeginCreateUpdateMongoUserDefinitionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginDeleteMongoDBCollectionOptions contains the optional parameters for the MongoDBResourcesClient.BeginDeleteMongoDBCollection
// method.
type MongoDBResourcesClientBeginDeleteMongoDBCollectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginDeleteMongoDBDatabaseOptions contains the optional parameters for the MongoDBResourcesClient.BeginDeleteMongoDBDatabase
// method.
type MongoDBResourcesClientBeginDeleteMongoDBDatabaseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginDeleteMongoRoleDefinitionOptions contains the optional parameters for the MongoDBResourcesClient.BeginDeleteMongoRoleDefinition
// method.
type MongoDBResourcesClientBeginDeleteMongoRoleDefinitionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginDeleteMongoUserDefinitionOptions contains the optional parameters for the MongoDBResourcesClient.BeginDeleteMongoUserDefinition
// method.
type MongoDBResourcesClientBeginDeleteMongoUserDefinitionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginListMongoDBCollectionPartitionMergeOptions contains the optional parameters for the MongoDBResourcesClient.BeginListMongoDBCollectionPartitionMerge
// method.
type MongoDBResourcesClientBeginListMongoDBCollectionPartitionMergeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginMigrateMongoDBCollectionToAutoscaleOptions contains the optional parameters for the MongoDBResourcesClient.BeginMigrateMongoDBCollectionToAutoscale
// method.
type MongoDBResourcesClientBeginMigrateMongoDBCollectionToAutoscaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginMigrateMongoDBCollectionToManualThroughputOptions contains the optional parameters for the MongoDBResourcesClient.BeginMigrateMongoDBCollectionToManualThroughput
// method.
type MongoDBResourcesClientBeginMigrateMongoDBCollectionToManualThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginMigrateMongoDBDatabaseToAutoscaleOptions contains the optional parameters for the MongoDBResourcesClient.BeginMigrateMongoDBDatabaseToAutoscale
// method.
type MongoDBResourcesClientBeginMigrateMongoDBDatabaseToAutoscaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginMigrateMongoDBDatabaseToManualThroughputOptions contains the optional parameters for the MongoDBResourcesClient.BeginMigrateMongoDBDatabaseToManualThroughput
// method.
type MongoDBResourcesClientBeginMigrateMongoDBDatabaseToManualThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginMongoDBContainerRedistributeThroughputOptions contains the optional parameters for the MongoDBResourcesClient.BeginMongoDBContainerRedistributeThroughput
// method.
type MongoDBResourcesClientBeginMongoDBContainerRedistributeThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginMongoDBContainerRetrieveThroughputDistributionOptions contains the optional parameters for the
// MongoDBResourcesClient.BeginMongoDBContainerRetrieveThroughputDistribution method.
type MongoDBResourcesClientBeginMongoDBContainerRetrieveThroughputDistributionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginMongoDBDatabaseRedistributeThroughputOptions contains the optional parameters for the MongoDBResourcesClient.BeginMongoDBDatabaseRedistributeThroughput
// method.
type MongoDBResourcesClientBeginMongoDBDatabaseRedistributeThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginMongoDBDatabaseRetrieveThroughputDistributionOptions contains the optional parameters for the
// MongoDBResourcesClient.BeginMongoDBDatabaseRetrieveThroughputDistribution method.
type MongoDBResourcesClientBeginMongoDBDatabaseRetrieveThroughputDistributionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginRetrieveContinuousBackupInformationOptions contains the optional parameters for the MongoDBResourcesClient.BeginRetrieveContinuousBackupInformation
// method.
type MongoDBResourcesClientBeginRetrieveContinuousBackupInformationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginUpdateMongoDBCollectionThroughputOptions contains the optional parameters for the MongoDBResourcesClient.BeginUpdateMongoDBCollectionThroughput
// method.
type MongoDBResourcesClientBeginUpdateMongoDBCollectionThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientBeginUpdateMongoDBDatabaseThroughputOptions contains the optional parameters for the MongoDBResourcesClient.BeginUpdateMongoDBDatabaseThroughput
// method.
type MongoDBResourcesClientBeginUpdateMongoDBDatabaseThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MongoDBResourcesClientGetMongoDBCollectionOptions contains the optional parameters for the MongoDBResourcesClient.GetMongoDBCollection
// method.
type MongoDBResourcesClientGetMongoDBCollectionOptions struct {
	// placeholder for future optional parameters
}

// MongoDBResourcesClientGetMongoDBCollectionThroughputOptions contains the optional parameters for the MongoDBResourcesClient.GetMongoDBCollectionThroughput
// method.
type MongoDBResourcesClientGetMongoDBCollectionThroughputOptions struct {
	// placeholder for future optional parameters
}

// MongoDBResourcesClientGetMongoDBDatabaseOptions contains the optional parameters for the MongoDBResourcesClient.GetMongoDBDatabase
// method.
type MongoDBResourcesClientGetMongoDBDatabaseOptions struct {
	// placeholder for future optional parameters
}

// MongoDBResourcesClientGetMongoDBDatabaseThroughputOptions contains the optional parameters for the MongoDBResourcesClient.GetMongoDBDatabaseThroughput
// method.
type MongoDBResourcesClientGetMongoDBDatabaseThroughputOptions struct {
	// placeholder for future optional parameters
}

// MongoDBResourcesClientGetMongoRoleDefinitionOptions contains the optional parameters for the MongoDBResourcesClient.GetMongoRoleDefinition
// method.
type MongoDBResourcesClientGetMongoRoleDefinitionOptions struct {
	// placeholder for future optional parameters
}

// MongoDBResourcesClientGetMongoUserDefinitionOptions contains the optional parameters for the MongoDBResourcesClient.GetMongoUserDefinition
// method.
type MongoDBResourcesClientGetMongoUserDefinitionOptions struct {
	// placeholder for future optional parameters
}

// MongoDBResourcesClientListMongoDBCollectionsOptions contains the optional parameters for the MongoDBResourcesClient.ListMongoDBCollections
// method.
type MongoDBResourcesClientListMongoDBCollectionsOptions struct {
	// placeholder for future optional parameters
}

// MongoDBResourcesClientListMongoDBDatabasesOptions contains the optional parameters for the MongoDBResourcesClient.ListMongoDBDatabases
// method.
type MongoDBResourcesClientListMongoDBDatabasesOptions struct {
	// placeholder for future optional parameters
}

// MongoDBResourcesClientListMongoRoleDefinitionsOptions contains the optional parameters for the MongoDBResourcesClient.ListMongoRoleDefinitions
// method.
type MongoDBResourcesClientListMongoRoleDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// MongoDBResourcesClientListMongoUserDefinitionsOptions contains the optional parameters for the MongoDBResourcesClient.ListMongoUserDefinitions
// method.
type MongoDBResourcesClientListMongoUserDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// MongoIndex - Cosmos DB MongoDB collection index key
type MongoIndex struct {
	// Cosmos DB MongoDB collection index keys
	Key *MongoIndexKeys `json:"key,omitempty"`

	// Cosmos DB MongoDB collection index key options
	Options *MongoIndexOptions `json:"options,omitempty"`
}

// MongoIndexKeys - Cosmos DB MongoDB collection resource object
type MongoIndexKeys struct {
	// List of keys for each MongoDB collection in the Azure Cosmos DB service
	Keys []*string `json:"keys,omitempty"`
}

// MongoIndexOptions - Cosmos DB MongoDB collection index options
type MongoIndexOptions struct {
	// Expire after seconds
	ExpireAfterSeconds *int32 `json:"expireAfterSeconds,omitempty"`

	// Is unique or not
	Unique *bool `json:"unique,omitempty"`
}

// MongoRoleDefinitionCreateUpdateParameters - Parameters to create and update an Azure Cosmos DB Mongo Role Definition.
type MongoRoleDefinitionCreateUpdateParameters struct {
	// Properties to create and update an Azure Cosmos DB Mongo Role Definition.
	Properties *MongoRoleDefinitionResource `json:"properties,omitempty"`
}

// MongoRoleDefinitionGetResults - An Azure Cosmos DB Mongo Role Definition.
type MongoRoleDefinitionGetResults struct {
	// Properties related to the Mongo Role Definition.
	Properties *MongoRoleDefinitionResource `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MongoRoleDefinitionListResult - The relevant Mongo Role Definitions.
type MongoRoleDefinitionListResult struct {
	// READ-ONLY; List of Mongo Role Definitions and their properties.
	Value []*MongoRoleDefinitionGetResults `json:"value,omitempty" azure:"ro"`
}

// MongoRoleDefinitionResource - Azure Cosmos DB Mongo Role Definition resource object.
type MongoRoleDefinitionResource struct {
	// The database name for which access is being granted for this Role Definition.
	DatabaseName *string `json:"databaseName,omitempty"`

	// A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire
	// database account or any underlying Database / Collection. Scopes higher than
	// Database are not enforceable as privilege.
	Privileges []*Privilege `json:"privileges,omitempty"`

	// A user-friendly name for the Role Definition. Must be unique for the database account.
	RoleName *string `json:"roleName,omitempty"`

	// The set of roles inherited by this Role Definition.
	Roles []*Role `json:"roles,omitempty"`

	// Indicates whether the Role Definition was built-in or user created.
	Type *MongoRoleDefinitionType `json:"type,omitempty"`
}

// MongoUserDefinitionCreateUpdateParameters - Parameters to create and update an Azure Cosmos DB Mongo User Definition.
type MongoUserDefinitionCreateUpdateParameters struct {
	// Properties to create and update an Azure Cosmos DB Mongo User Definition.
	Properties *MongoUserDefinitionResource `json:"properties,omitempty"`
}

// MongoUserDefinitionGetResults - An Azure Cosmos DB User Definition
type MongoUserDefinitionGetResults struct {
	// Properties related to the User Definition.
	Properties *MongoUserDefinitionResource `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MongoUserDefinitionListResult - The relevant User Definition.
type MongoUserDefinitionListResult struct {
	// READ-ONLY; List of User Definition and their properties
	Value []*MongoUserDefinitionGetResults `json:"value,omitempty" azure:"ro"`
}

// MongoUserDefinitionResource - Azure Cosmos DB Mongo User Definition resource object.
type MongoUserDefinitionResource struct {
	// A custom definition for the USer Definition.
	CustomData *string `json:"customData,omitempty"`

	// The database name for which access is being granted for this User Definition.
	DatabaseName *string `json:"databaseName,omitempty"`

	// The Mongo Auth mechanism. For now, we only support auth mechanism SCRAM-SHA-256.
	Mechanisms *string `json:"mechanisms,omitempty"`

	// The password for User Definition. Response does not contain user password.
	Password *string `json:"password,omitempty"`

	// The set of roles inherited by the User Definition.
	Roles []*Role `json:"roles,omitempty"`

	// The user name for User Definition.
	UserName *string `json:"userName,omitempty"`
}

// NotebookWorkspace - A notebook workspace resource
type NotebookWorkspace struct {
	// Resource properties.
	Properties *NotebookWorkspaceProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NotebookWorkspaceConnectionInfoResult - The connection info for the given notebook workspace
type NotebookWorkspaceConnectionInfoResult struct {
	// READ-ONLY; Specifies auth token used for connecting to Notebook server (uses token-based auth).
	AuthToken *string `json:"authToken,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the endpoint of Notebook server.
	NotebookServerEndpoint *string `json:"notebookServerEndpoint,omitempty" azure:"ro"`
}

// NotebookWorkspaceCreateUpdateParameters - Parameters to create a notebook workspace resource
type NotebookWorkspaceCreateUpdateParameters struct {
	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NotebookWorkspaceListResult - A list of notebook workspace resources
type NotebookWorkspaceListResult struct {
	// Array of notebook workspace resources
	Value []*NotebookWorkspace `json:"value,omitempty"`
}

// NotebookWorkspaceProperties - Properties of a notebook workspace resource.
type NotebookWorkspaceProperties struct {
	// READ-ONLY; Specifies the endpoint of Notebook server.
	NotebookServerEndpoint *string `json:"notebookServerEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Status of the notebook workspace. Possible values are: Creating, Online, Deleting, Failed, Updating.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// NotebookWorkspacesClientBeginCreateOrUpdateOptions contains the optional parameters for the NotebookWorkspacesClient.BeginCreateOrUpdate
// method.
type NotebookWorkspacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NotebookWorkspacesClientBeginDeleteOptions contains the optional parameters for the NotebookWorkspacesClient.BeginDelete
// method.
type NotebookWorkspacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NotebookWorkspacesClientBeginRegenerateAuthTokenOptions contains the optional parameters for the NotebookWorkspacesClient.BeginRegenerateAuthToken
// method.
type NotebookWorkspacesClientBeginRegenerateAuthTokenOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NotebookWorkspacesClientBeginStartOptions contains the optional parameters for the NotebookWorkspacesClient.BeginStart
// method.
type NotebookWorkspacesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NotebookWorkspacesClientGetOptions contains the optional parameters for the NotebookWorkspacesClient.Get method.
type NotebookWorkspacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// NotebookWorkspacesClientListByDatabaseAccountOptions contains the optional parameters for the NotebookWorkspacesClient.ListByDatabaseAccount
// method.
type NotebookWorkspacesClientListByDatabaseAccountOptions struct {
	// placeholder for future optional parameters
}

// NotebookWorkspacesClientListConnectionInfoOptions contains the optional parameters for the NotebookWorkspacesClient.ListConnectionInfo
// method.
type NotebookWorkspacesClientListConnectionInfoOptions struct {
	// placeholder for future optional parameters
}

// Operation - REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of operation
	Description *string `json:"Description,omitempty"`

	// Operation type: Read, write, delete, etc.
	Operation *string `json:"Operation,omitempty"`

	// Service provider: Microsoft.ResourceProvider
	Provider *string `json:"Provider,omitempty"`

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"Resource,omitempty"`
}

// OperationListResult - Result of the request to list Resource Provider operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of operations supported by the Resource Provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OptionsResource - Cosmos DB options resource object
type OptionsResource struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

// PartitionKeyRangeIDClientListMetricsOptions contains the optional parameters for the PartitionKeyRangeIDClient.ListMetrics
// method.
type PartitionKeyRangeIDClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// PartitionKeyRangeIDRegionClientListMetricsOptions contains the optional parameters for the PartitionKeyRangeIDRegionClient.ListMetrics
// method.
type PartitionKeyRangeIDRegionClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// PartitionMetric - The metric values for a single partition.
type PartitionMetric struct {
	// READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues []*MetricValue `json:"metricValues,omitempty" azure:"ro"`

	// READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The partition id (GUID identifier) of the metric values.
	PartitionID *string `json:"partitionId,omitempty" azure:"ro"`

	// READ-ONLY; The partition key range id (integer identifier) of the metric values.
	PartitionKeyRangeID *string `json:"partitionKeyRangeId,omitempty" azure:"ro"`

	// READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the metric.
	Unit *UnitType `json:"unit,omitempty" azure:"ro"`
}

// PartitionMetricListResult - The response to a list partition metrics request.
type PartitionMetricListResult struct {
	// READ-ONLY; The list of partition-level metrics for the account.
	Value []*PartitionMetric `json:"value,omitempty" azure:"ro"`
}

// PartitionUsage - The partition level usage data for a usage request.
type PartitionUsage struct {
	// READ-ONLY; Current value for this metric
	CurrentValue *int64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Maximum value for this metric
	Limit *int64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The partition id (GUID identifier) of the usages.
	PartitionID *string `json:"partitionId,omitempty" azure:"ro"`

	// READ-ONLY; The partition key range id (integer identifier) of the usages.
	PartitionKeyRangeID *string `json:"partitionKeyRangeId,omitempty" azure:"ro"`

	// READ-ONLY; The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the metric.
	Unit *UnitType `json:"unit,omitempty" azure:"ro"`
}

// PartitionUsagesResult - The response to a list partition level usage request.
type PartitionUsagesResult struct {
	// READ-ONLY; The list of partition-level usages for the database. A usage is a point in time metric
	Value []*PartitionUsage `json:"value,omitempty" azure:"ro"`
}

// PercentileClientListMetricsOptions contains the optional parameters for the PercentileClient.ListMetrics method.
type PercentileClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// PercentileMetric - Percentile Metric data
type PercentileMetric struct {
	// READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The percentile metric values for the specified time window and timestep.
	MetricValues []*PercentileMetricValue `json:"metricValues,omitempty" azure:"ro"`

	// READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the metric.
	Unit *UnitType `json:"unit,omitempty" azure:"ro"`
}

// PercentileMetricListResult - The response to a list percentile metrics request.
type PercentileMetricListResult struct {
	// READ-ONLY; The list of percentile metrics for the account.
	Value []*PercentileMetric `json:"value,omitempty" azure:"ro"`
}

// PercentileMetricValue - Represents percentile metrics values.
type PercentileMetricValue struct {
	// READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty" azure:"ro"`

	// READ-ONLY; The number of values for the metric.
	Count *int32 `json:"_count,omitempty" azure:"ro"`

	// READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; The 10th percentile value for the metric.
	P10 *float64 `json:"P10,omitempty" azure:"ro"`

	// READ-ONLY; The 25th percentile value for the metric.
	P25 *float64 `json:"P25,omitempty" azure:"ro"`

	// READ-ONLY; The 50th percentile value for the metric.
	P50 *float64 `json:"P50,omitempty" azure:"ro"`

	// READ-ONLY; The 75th percentile value for the metric.
	P75 *float64 `json:"P75,omitempty" azure:"ro"`

	// READ-ONLY; The 90th percentile value for the metric.
	P90 *float64 `json:"P90,omitempty" azure:"ro"`

	// READ-ONLY; The 95th percentile value for the metric.
	P95 *float64 `json:"P95,omitempty" azure:"ro"`

	// READ-ONLY; The 99th percentile value for the metric.
	P99 *float64 `json:"P99,omitempty" azure:"ro"`

	// READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty" azure:"ro"`
}

// PercentileSourceTargetClientListMetricsOptions contains the optional parameters for the PercentileSourceTargetClient.ListMetrics
// method.
type PercentileSourceTargetClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// PercentileTargetClientListMetricsOptions contains the optional parameters for the PercentileTargetClient.ListMetrics method.
type PercentileTargetClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// PeriodicModeBackupPolicy - The object representing periodic mode backup policy.
type PeriodicModeBackupPolicy struct {
	// REQUIRED; Describes the mode of backups.
	Type *BackupPolicyType `json:"type,omitempty"`

	// The object representing the state of the migration between the backup policies.
	MigrationState *BackupPolicyMigrationState `json:"migrationState,omitempty"`

	// Configuration values for periodic mode backup
	PeriodicModeProperties *PeriodicModeProperties `json:"periodicModeProperties,omitempty"`
}

// GetBackupPolicy implements the BackupPolicyClassification interface for type PeriodicModeBackupPolicy.
func (p *PeriodicModeBackupPolicy) GetBackupPolicy() *BackupPolicy {
	return &BackupPolicy{
		Type:           p.Type,
		MigrationState: p.MigrationState,
	}
}

// PeriodicModeProperties - Configuration values for periodic mode backup
type PeriodicModeProperties struct {
	// An integer representing the interval in minutes between two backups
	BackupIntervalInMinutes *int32 `json:"backupIntervalInMinutes,omitempty"`

	// An integer representing the time (in hours) that each backup is retained
	BackupRetentionIntervalInHours *int32 `json:"backupRetentionIntervalInHours,omitempty"`

	// Enum to indicate type of backup residency
	BackupStorageRedundancy *BackupStorageRedundancy `json:"backupStorageRedundancy,omitempty"`
}

// Permission - The set of data plane operations permitted through this Role Definition.
type Permission struct {
	// An array of data actions that are allowed.
	DataActions []*string `json:"dataActions,omitempty"`

	// An array of data actions that are denied.
	NotDataActions []*string `json:"notDataActions,omitempty"`
}

// PhysicalPartitionID - PhysicalPartitionId object
type PhysicalPartitionID struct {
	// REQUIRED; Id of a physical partition
	ID *string `json:"id,omitempty"`
}

// PhysicalPartitionStorageInfo - The storage of a physical partition
type PhysicalPartitionStorageInfo struct {
	// READ-ONLY; The unique identifier of the partition.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The storage in KB for the physical partition.
	StorageInKB *float64 `json:"storageInKB,omitempty" azure:"ro"`
}

// PhysicalPartitionStorageInfoCollection - List of physical partitions and their properties returned by a merge operation.
type PhysicalPartitionStorageInfoCollection struct {
	// READ-ONLY; List of physical partitions and their properties.
	PhysicalPartitionStorageInfoCollection []*PhysicalPartitionStorageInfo `json:"physicalPartitionStorageInfoCollection,omitempty" azure:"ro"`
}

// PhysicalPartitionThroughputInfoProperties - The properties of an Azure Cosmos DB PhysicalPartitionThroughputInfoProperties
// object
type PhysicalPartitionThroughputInfoProperties struct {
	// Array of physical partition throughput info objects
	PhysicalPartitionThroughputInfo []*PhysicalPartitionThroughputInfoResource `json:"physicalPartitionThroughputInfo,omitempty"`
}

// PhysicalPartitionThroughputInfoResource - PhysicalPartitionThroughputInfo object
type PhysicalPartitionThroughputInfoResource struct {
	// REQUIRED; Id of a physical partition
	ID *string `json:"id,omitempty"`

	// Throughput of a physical partition
	Throughput *float64 `json:"throughput,omitempty"`
}

// PhysicalPartitionThroughputInfoResult - An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object.
type PhysicalPartitionThroughputInfoResult struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB PhysicalPartitionThroughputInfoResult object
	Properties *PhysicalPartitionThroughputInfoResultProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PhysicalPartitionThroughputInfoResultProperties - The properties of an Azure Cosmos DB PhysicalPartitionThroughputInfoResult
// object
type PhysicalPartitionThroughputInfoResultProperties struct {
	// properties of physical partition throughput info
	Resource *PhysicalPartitionThroughputInfoResultPropertiesResource `json:"resource,omitempty"`
}

// PhysicalPartitionThroughputInfoResultPropertiesResource - properties of physical partition throughput info
type PhysicalPartitionThroughputInfoResultPropertiesResource struct {
	// Array of physical partition throughput info objects
	PhysicalPartitionThroughputInfo []*PhysicalPartitionThroughputInfoResource `json:"physicalPartitionThroughputInfo,omitempty"`
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// Group id of the private endpoint.
	GroupID *string `json:"groupId,omitempty"`

	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`

	// Connection State of the Private Endpoint Connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`

	// Provisioning state of the private endpoint.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByDatabaseAccountOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByDatabaseAccount
// method.
type PrivateEndpointConnectionsClientListByDatabaseAccountOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointProperty - Private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required zone names.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByDatabaseAccountOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByDatabaseAccount
// method.
type PrivateLinkResourcesClientListByDatabaseAccountOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionStateProperty - Connection State of the Private Endpoint Connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// The private link service connection description.
	Description *string `json:"description,omitempty"`

	// The private link service connection status.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; Any action that is required beyond basic workflow (approve/ reject/ disconnect)
	ActionsRequired *string `json:"actionsRequired,omitempty" azure:"ro"`
}

// Privilege - The set of data plane operations permitted through this Role Definition.
type Privilege struct {
	// An array of actions that are allowed.
	Actions []*string `json:"actions,omitempty"`

	// An Azure Cosmos DB Mongo DB Resource.
	Resource *PrivilegeResource `json:"resource,omitempty"`
}

// PrivilegeResource - An Azure Cosmos DB Mongo DB Resource.
type PrivilegeResource struct {
	// The collection name the role is applied.
	Collection *string `json:"collection,omitempty"`

	// The database name the role is applied.
	Db *string `json:"db,omitempty"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RedistributeThroughputParameters - Cosmos DB redistribute throughput parameters object
type RedistributeThroughputParameters struct {
	// REQUIRED; Properties to redistribute throughput parameters object
	Properties *RedistributeThroughputProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RedistributeThroughputProperties - Properties to redistribute throughput for Azure Cosmos DB resource.
type RedistributeThroughputProperties struct {
	// REQUIRED; The standard JSON format of a resource throughput
	Resource *RedistributeThroughputPropertiesResource `json:"resource,omitempty"`
}

// RedistributeThroughputPropertiesResource - Resource to redistribute throughput for Azure Cosmos DB resource
type RedistributeThroughputPropertiesResource struct {
	// REQUIRED; Array of PhysicalPartitionThroughputInfoResource objects.
	SourcePhysicalPartitionThroughputInfo []*PhysicalPartitionThroughputInfoResource `json:"sourcePhysicalPartitionThroughputInfo,omitempty"`

	// REQUIRED; Array of PhysicalPartitionThroughputInfoResource objects.
	TargetPhysicalPartitionThroughputInfo []*PhysicalPartitionThroughputInfoResource `json:"targetPhysicalPartitionThroughputInfo,omitempty"`

	// REQUIRED; ThroughputPolicy to apply for throughput redistribution
	ThroughputPolicy *ThroughputPolicyType `json:"throughputPolicy,omitempty"`
}

// RegionForOnlineOffline - Cosmos DB region to online or offline.
type RegionForOnlineOffline struct {
	// REQUIRED; Cosmos DB region, with spaces between words and each word capitalized.
	Region *string `json:"region,omitempty"`
}

// RegionalServiceResource - Resource for a regional service location.
type RegionalServiceResource struct {
	// READ-ONLY; The location name.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The regional service name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus `json:"status,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceRestoreParameters - Parameters to indicate the information about the restore.
type ResourceRestoreParameters struct {
	// The id of the restorable database account from which the restore has to be initiated. For example:
	// /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
	RestoreSource *string `json:"restoreSource,omitempty"`

	// Time to which the account has to be restored (ISO-8601 format).
	RestoreTimestampInUTC *time.Time `json:"restoreTimestampInUtc,omitempty"`
}

// RestorableDatabaseAccountGetResult - A Azure Cosmos DB restorable database account.
type RestorableDatabaseAccountGetResult struct {
	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of a restorable database account.
	Properties *RestorableDatabaseAccountProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableDatabaseAccountProperties - The properties of a restorable database account.
type RestorableDatabaseAccountProperties struct {
	// The name of the global database account
	AccountName *string `json:"accountName,omitempty"`

	// The creation time of the restorable database account (ISO-8601 format).
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// The time at which the restorable database account has been deleted (ISO-8601 format).
	DeletionTime *time.Time `json:"deletionTime,omitempty"`

	// The least recent time at which the database account can be restored to (ISO-8601 format).
	OldestRestorableTime *time.Time `json:"oldestRestorableTime,omitempty"`

	// READ-ONLY; The API type of the restorable database account.
	APIType *APIType `json:"apiType,omitempty" azure:"ro"`

	// READ-ONLY; List of regions where the of the database account can be restored from.
	RestorableLocations []*RestorableLocationResource `json:"restorableLocations,omitempty" azure:"ro"`
}

// RestorableDatabaseAccountsClientGetByLocationOptions contains the optional parameters for the RestorableDatabaseAccountsClient.GetByLocation
// method.
type RestorableDatabaseAccountsClientGetByLocationOptions struct {
	// placeholder for future optional parameters
}

// RestorableDatabaseAccountsClientListByLocationOptions contains the optional parameters for the RestorableDatabaseAccountsClient.ListByLocation
// method.
type RestorableDatabaseAccountsClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// RestorableDatabaseAccountsClientListOptions contains the optional parameters for the RestorableDatabaseAccountsClient.List
// method.
type RestorableDatabaseAccountsClientListOptions struct {
	// placeholder for future optional parameters
}

// RestorableDatabaseAccountsListResult - The List operation response, that contains the restorable database accounts and
// their properties.
type RestorableDatabaseAccountsListResult struct {
	// READ-ONLY; List of restorable database accounts and their properties.
	Value []*RestorableDatabaseAccountGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableGremlinDatabaseGetResult - An Azure Cosmos DB Gremlin database event
type RestorableGremlinDatabaseGetResult struct {
	// The properties of a Gremlin database event.
	Properties *RestorableGremlinDatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableGremlinDatabaseProperties - The properties of an Azure Cosmos DB Gremlin database event
type RestorableGremlinDatabaseProperties struct {
	// The resource of an Azure Cosmos DB Gremlin database event
	Resource *RestorableGremlinDatabasePropertiesResource `json:"resource,omitempty"`
}

// RestorableGremlinDatabasePropertiesResource - The resource of an Azure Cosmos DB Gremlin database event
type RestorableGremlinDatabasePropertiesResource struct {
	// READ-ONLY; The time when this database event happened.
	EventTimestamp *string `json:"eventTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The operation type of this database event.
	OperationType *OperationType `json:"operationType,omitempty" azure:"ro"`

	// READ-ONLY; The name of this Gremlin database.
	OwnerID *string `json:"ownerId,omitempty" azure:"ro"`

	// READ-ONLY; The resource ID of this Gremlin database.
	OwnerResourceID *string `json:"ownerResourceId,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`
}

// RestorableGremlinDatabasesClientListOptions contains the optional parameters for the RestorableGremlinDatabasesClient.List
// method.
type RestorableGremlinDatabasesClientListOptions struct {
	// placeholder for future optional parameters
}

// RestorableGremlinDatabasesListResult - The List operation response, that contains the Gremlin database events and their
// properties.
type RestorableGremlinDatabasesListResult struct {
	// READ-ONLY; List of Gremlin database events and their properties.
	Value []*RestorableGremlinDatabaseGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableGremlinGraphGetResult - An Azure Cosmos DB Gremlin graph event
type RestorableGremlinGraphGetResult struct {
	// The properties of a Gremlin graph event.
	Properties *RestorableGremlinGraphProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableGremlinGraphProperties - The properties of an Azure Cosmos DB Gremlin graph event
type RestorableGremlinGraphProperties struct {
	// The resource of an Azure Cosmos DB Gremlin graph event
	Resource *RestorableGremlinGraphPropertiesResource `json:"resource,omitempty"`
}

// RestorableGremlinGraphPropertiesResource - The resource of an Azure Cosmos DB Gremlin graph event
type RestorableGremlinGraphPropertiesResource struct {
	// READ-ONLY; The time when this graph event happened.
	EventTimestamp *string `json:"eventTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The operation type of this graph event.
	OperationType *OperationType `json:"operationType,omitempty" azure:"ro"`

	// READ-ONLY; The name of this Gremlin graph.
	OwnerID *string `json:"ownerId,omitempty" azure:"ro"`

	// READ-ONLY; The resource ID of this Gremlin graph.
	OwnerResourceID *string `json:"ownerResourceId,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`
}

// RestorableGremlinGraphsClientListOptions contains the optional parameters for the RestorableGremlinGraphsClient.List method.
type RestorableGremlinGraphsClientListOptions struct {
	// Restorable Gremlin graphs event feed end time.
	EndTime *string
	// The resource ID of the Gremlin database.
	RestorableGremlinDatabaseRid *string
	// Restorable Gremlin graphs event feed start time.
	StartTime *string
}

// RestorableGremlinGraphsListResult - The List operation response, that contains the Gremlin graph events and their properties.
type RestorableGremlinGraphsListResult struct {
	// READ-ONLY; List of Gremlin graph events and their properties.
	Value []*RestorableGremlinGraphGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableGremlinResourcesClientListOptions contains the optional parameters for the RestorableGremlinResourcesClient.List
// method.
type RestorableGremlinResourcesClientListOptions struct {
	// The location where the restorable resources are located.
	RestoreLocation *string
	// The timestamp when the restorable resources existed.
	RestoreTimestampInUTC *string
}

// RestorableGremlinResourcesGetResult - Specific Databases to restore.
type RestorableGremlinResourcesGetResult struct {
	// The name of the gremlin database available for restore.
	DatabaseName *string `json:"databaseName,omitempty"`

	// The names of the graphs available for restore.
	GraphNames []*string `json:"graphNames,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableGremlinResourcesListResult - The List operation response, that contains the restorable Gremlin resources.
type RestorableGremlinResourcesListResult struct {
	// READ-ONLY; List of restorable Gremlin resources, including the gremlin database and graph names.
	Value []*RestorableGremlinResourcesGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableLocationResource - Properties of the regional restorable account.
type RestorableLocationResource struct {
	// READ-ONLY; The creation time of the regional restorable database account (ISO-8601 format).
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the regional restorable database account has been deleted (ISO-8601 format).
	DeletionTime *time.Time `json:"deletionTime,omitempty" azure:"ro"`

	// READ-ONLY; The location of the regional restorable account.
	LocationName *string `json:"locationName,omitempty" azure:"ro"`

	// READ-ONLY; The instance id of the regional restorable account.
	RegionalDatabaseAccountInstanceID *string `json:"regionalDatabaseAccountInstanceId,omitempty" azure:"ro"`
}

// RestorableMongodbCollectionGetResult - An Azure Cosmos DB MongoDB collection event
type RestorableMongodbCollectionGetResult struct {
	// The properties of a MongoDB collection event.
	Properties *RestorableMongodbCollectionProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableMongodbCollectionProperties - The properties of an Azure Cosmos DB MongoDB collection event
type RestorableMongodbCollectionProperties struct {
	// The resource of an Azure Cosmos DB MongoDB collection event
	Resource *RestorableMongodbCollectionPropertiesResource `json:"resource,omitempty"`
}

// RestorableMongodbCollectionPropertiesResource - The resource of an Azure Cosmos DB MongoDB collection event
type RestorableMongodbCollectionPropertiesResource struct {
	// READ-ONLY; The time when this collection event happened.
	EventTimestamp *string `json:"eventTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The operation type of this collection event.
	OperationType *OperationType `json:"operationType,omitempty" azure:"ro"`

	// READ-ONLY; The name of this MongoDB collection.
	OwnerID *string `json:"ownerId,omitempty" azure:"ro"`

	// READ-ONLY; The resource ID of this MongoDB collection.
	OwnerResourceID *string `json:"ownerResourceId,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`
}

// RestorableMongodbCollectionsClientListOptions contains the optional parameters for the RestorableMongodbCollectionsClient.List
// method.
type RestorableMongodbCollectionsClientListOptions struct {
	// Restorable MongoDB collections event feed end time.
	EndTime *string
	// The resource ID of the MongoDB database.
	RestorableMongodbDatabaseRid *string
	// Restorable MongoDB collections event feed start time.
	StartTime *string
}

// RestorableMongodbCollectionsListResult - The List operation response, that contains the MongoDB collection events and their
// properties.
type RestorableMongodbCollectionsListResult struct {
	// READ-ONLY; List of MongoDB collection events and their properties.
	Value []*RestorableMongodbCollectionGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableMongodbDatabaseGetResult - An Azure Cosmos DB MongoDB database event
type RestorableMongodbDatabaseGetResult struct {
	// The properties of a MongoDB database event.
	Properties *RestorableMongodbDatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableMongodbDatabaseProperties - The properties of an Azure Cosmos DB MongoDB database event
type RestorableMongodbDatabaseProperties struct {
	// The resource of an Azure Cosmos DB MongoDB database event
	Resource *RestorableMongodbDatabasePropertiesResource `json:"resource,omitempty"`
}

// RestorableMongodbDatabasePropertiesResource - The resource of an Azure Cosmos DB MongoDB database event
type RestorableMongodbDatabasePropertiesResource struct {
	// READ-ONLY; The time when this database event happened.
	EventTimestamp *string `json:"eventTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The operation type of this database event.
	OperationType *OperationType `json:"operationType,omitempty" azure:"ro"`

	// READ-ONLY; The name of this MongoDB database.
	OwnerID *string `json:"ownerId,omitempty" azure:"ro"`

	// READ-ONLY; The resource ID of this MongoDB database.
	OwnerResourceID *string `json:"ownerResourceId,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`
}

// RestorableMongodbDatabasesClientListOptions contains the optional parameters for the RestorableMongodbDatabasesClient.List
// method.
type RestorableMongodbDatabasesClientListOptions struct {
	// placeholder for future optional parameters
}

// RestorableMongodbDatabasesListResult - The List operation response, that contains the MongoDB database events and their
// properties.
type RestorableMongodbDatabasesListResult struct {
	// READ-ONLY; List of MongoDB database events and their properties.
	Value []*RestorableMongodbDatabaseGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableMongodbResourcesClientListOptions contains the optional parameters for the RestorableMongodbResourcesClient.List
// method.
type RestorableMongodbResourcesClientListOptions struct {
	// The location where the restorable resources are located.
	RestoreLocation *string
	// The timestamp when the restorable resources existed.
	RestoreTimestampInUTC *string
}

// RestorableMongodbResourcesGetResult - Specific Databases to restore.
type RestorableMongodbResourcesGetResult struct {
	// The names of the collections available for restore.
	CollectionNames []*string `json:"collectionNames,omitempty"`

	// The name of the database available for restore.
	DatabaseName *string `json:"databaseName,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableMongodbResourcesListResult - The List operation response, that contains the restorable MongoDB resources.
type RestorableMongodbResourcesListResult struct {
	// READ-ONLY; List of restorable MongoDB resources, including the database and collection names.
	Value []*RestorableMongodbResourcesGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableSQLContainerGetResult - An Azure Cosmos DB SQL container event
type RestorableSQLContainerGetResult struct {
	// The properties of a SQL container event.
	Properties *RestorableSQLContainerProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableSQLContainerProperties - The properties of an Azure Cosmos DB SQL container event
type RestorableSQLContainerProperties struct {
	// The resource of an Azure Cosmos DB SQL container event
	Resource *RestorableSQLContainerPropertiesResource `json:"resource,omitempty"`
}

// RestorableSQLContainerPropertiesResource - The resource of an Azure Cosmos DB SQL container event
type RestorableSQLContainerPropertiesResource struct {
	// Cosmos DB SQL container resource object
	Container *RestorableSQLContainerPropertiesResourceContainer `json:"container,omitempty"`

	// READ-ONLY; The when this container event happened.
	EventTimestamp *string `json:"eventTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The operation type of this container event.
	OperationType *OperationType `json:"operationType,omitempty" azure:"ro"`

	// READ-ONLY; The name of this SQL container.
	OwnerID *string `json:"ownerId,omitempty" azure:"ro"`

	// READ-ONLY; The resource ID of this SQL container.
	OwnerResourceID *string `json:"ownerResourceId,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`
}

// RestorableSQLContainerPropertiesResourceContainer - Cosmos DB SQL container resource object
type RestorableSQLContainerPropertiesResourceContainer struct {
	// REQUIRED; Name of the Cosmos DB SQL container
	ID *string `json:"id,omitempty"`

	// Analytical TTL.
	AnalyticalStorageTTL *int64 `json:"analyticalStorageTtl,omitempty"`

	// The client encryption policy for the container.
	ClientEncryptionPolicy *ClientEncryptionPolicy `json:"clientEncryptionPolicy,omitempty"`

	// The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`

	// The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`

	// The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters `json:"restoreParameters,omitempty"`

	// The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos
	// DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that specifies the addressable path of the container resource.
	Self *string `json:"_self,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// RestorableSQLContainersClientListOptions contains the optional parameters for the RestorableSQLContainersClient.List method.
type RestorableSQLContainersClientListOptions struct {
	// Restorable Sql containers event feed end time.
	EndTime *string
	// The resource ID of the SQL database.
	RestorableSQLDatabaseRid *string
	// Restorable Sql containers event feed start time.
	StartTime *string
}

// RestorableSQLContainersListResult - The List operation response, that contains the SQL container events and their properties.
type RestorableSQLContainersListResult struct {
	// READ-ONLY; List of SQL container events and their properties.
	Value []*RestorableSQLContainerGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableSQLDatabaseGetResult - An Azure Cosmos DB SQL database event
type RestorableSQLDatabaseGetResult struct {
	// The properties of a SQL database event.
	Properties *RestorableSQLDatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableSQLDatabaseProperties - The properties of an Azure Cosmos DB SQL database event
type RestorableSQLDatabaseProperties struct {
	// The resource of an Azure Cosmos DB SQL database event
	Resource *RestorableSQLDatabasePropertiesResource `json:"resource,omitempty"`
}

// RestorableSQLDatabasePropertiesResource - The resource of an Azure Cosmos DB SQL database event
type RestorableSQLDatabasePropertiesResource struct {
	// Cosmos DB SQL database resource object
	Database *RestorableSQLDatabasePropertiesResourceDatabase `json:"database,omitempty"`

	// READ-ONLY; The time when this database event happened.
	EventTimestamp *string `json:"eventTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The operation type of this database event.
	OperationType *OperationType `json:"operationType,omitempty" azure:"ro"`

	// READ-ONLY; The name of the SQL database.
	OwnerID *string `json:"ownerId,omitempty" azure:"ro"`

	// READ-ONLY; The resource ID of the SQL database.
	OwnerResourceID *string `json:"ownerResourceId,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`
}

// RestorableSQLDatabasePropertiesResourceDatabase - Cosmos DB SQL database resource object
type RestorableSQLDatabasePropertiesResourceDatabase struct {
	// REQUIRED; Name of the Cosmos DB SQL database
	ID *string `json:"id,omitempty"`

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters `json:"restoreParameters,omitempty"`

	// READ-ONLY; A system generated property that specified the addressable path of the collections resource.
	Colls *string `json:"_colls,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that specifies the addressable path of the database resource.
	Self *string `json:"_self,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that specifies the addressable path of the users resource.
	Users *string `json:"_users,omitempty" azure:"ro"`
}

// RestorableSQLDatabasesClientListOptions contains the optional parameters for the RestorableSQLDatabasesClient.List method.
type RestorableSQLDatabasesClientListOptions struct {
	// placeholder for future optional parameters
}

// RestorableSQLDatabasesListResult - The List operation response, that contains the SQL database events and their properties.
type RestorableSQLDatabasesListResult struct {
	// READ-ONLY; List of SQL database events and their properties.
	Value []*RestorableSQLDatabaseGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableSQLResourcesClientListOptions contains the optional parameters for the RestorableSQLResourcesClient.List method.
type RestorableSQLResourcesClientListOptions struct {
	// The location where the restorable resources are located.
	RestoreLocation *string
	// The timestamp when the restorable resources existed.
	RestoreTimestampInUTC *string
}

// RestorableSQLResourcesGetResult - Specific Databases to restore.
type RestorableSQLResourcesGetResult struct {
	// The names of the collections available for restore.
	CollectionNames []*string `json:"collectionNames,omitempty"`

	// The name of the database available for restore.
	DatabaseName *string `json:"databaseName,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableSQLResourcesListResult - The List operation response, that contains the restorable SQL resources.
type RestorableSQLResourcesListResult struct {
	// READ-ONLY; List of restorable SQL resources, including the database and collection names.
	Value []*RestorableSQLResourcesGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableTableGetResult - An Azure Cosmos DB Table event
type RestorableTableGetResult struct {
	// The properties of a Table event.
	Properties *RestorableTableProperties `json:"properties,omitempty"`

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableTableProperties - The properties of an Azure Cosmos DB Table event
type RestorableTableProperties struct {
	// The resource of an Azure Cosmos DB Table event
	Resource *RestorableTablePropertiesResource `json:"resource,omitempty"`
}

// RestorableTablePropertiesResource - The resource of an Azure Cosmos DB Table event
type RestorableTablePropertiesResource struct {
	// READ-ONLY; The time when this table event happened.
	EventTimestamp *string `json:"eventTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The operation type of this table event.
	OperationType *OperationType `json:"operationType,omitempty" azure:"ro"`

	// READ-ONLY; The name of this Table.
	OwnerID *string `json:"ownerId,omitempty" azure:"ro"`

	// READ-ONLY; The resource ID of this Table.
	OwnerResourceID *string `json:"ownerResourceId,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`
}

// RestorableTableResourcesClientListOptions contains the optional parameters for the RestorableTableResourcesClient.List
// method.
type RestorableTableResourcesClientListOptions struct {
	// The location where the restorable resources are located.
	RestoreLocation *string
	// The timestamp when the restorable resources existed.
	RestoreTimestampInUTC *string
}

// RestorableTableResourcesGetResult - Specific Databases to restore.
type RestorableTableResourcesGetResult struct {
	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the Table.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableTableResourcesListResult - List of restorable table names.
type RestorableTableResourcesListResult struct {
	// READ-ONLY; List of restorable table names.
	Value []*RestorableTableResourcesGetResult `json:"value,omitempty" azure:"ro"`
}

// RestorableTablesClientListOptions contains the optional parameters for the RestorableTablesClient.List method.
type RestorableTablesClientListOptions struct {
	// Restorable Tables event feed end time.
	EndTime *string
	// Restorable Tables event feed start time.
	StartTime *string
}

// RestorableTablesListResult - The List operation response, that contains the Table events and their properties.
type RestorableTablesListResult struct {
	// READ-ONLY; List of Table events and their properties.
	Value []*RestorableTableGetResult `json:"value,omitempty" azure:"ro"`
}

// RestoreParameters - Parameters to indicate the information about the restore.
type RestoreParameters struct {
	// List of specific databases available for restore.
	DatabasesToRestore []*DatabaseRestoreResource `json:"databasesToRestore,omitempty"`

	// List of specific gremlin databases available for restore.
	GremlinDatabasesToRestore []*GremlinDatabaseRestoreResource `json:"gremlinDatabasesToRestore,omitempty"`

	// Describes the mode of the restore.
	RestoreMode *RestoreMode `json:"restoreMode,omitempty"`

	// The id of the restorable database account from which the restore has to be initiated. For example:
	// /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
	RestoreSource *string `json:"restoreSource,omitempty"`

	// Time to which the account has to be restored (ISO-8601 format).
	RestoreTimestampInUTC *time.Time `json:"restoreTimestampInUtc,omitempty"`

	// List of specific tables available for restore.
	TablesToRestore []*string `json:"tablesToRestore,omitempty"`
}

// RestoreParametersBase - Parameters to indicate the information about the restore.
type RestoreParametersBase struct {
	// The id of the restorable database account from which the restore has to be initiated. For example:
	// /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
	RestoreSource *string `json:"restoreSource,omitempty"`

	// Time to which the account has to be restored (ISO-8601 format).
	RestoreTimestampInUTC *time.Time `json:"restoreTimestampInUtc,omitempty"`
}

// RetrieveThroughputParameters - Cosmos DB retrieve throughput parameters object
type RetrieveThroughputParameters struct {
	// REQUIRED; Properties to retrieve throughput parameters object
	Properties *RetrieveThroughputProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RetrieveThroughputProperties - Properties to retrieve throughput for Azure Cosmos DB resource.
type RetrieveThroughputProperties struct {
	// REQUIRED; The standard JSON format of a resource throughput
	Resource *RetrieveThroughputPropertiesResource `json:"resource,omitempty"`
}

// RetrieveThroughputPropertiesResource - Resource to retrieve throughput information for Cosmos DB resource
type RetrieveThroughputPropertiesResource struct {
	// REQUIRED; Array of PhysicalPartitionId objects.
	PhysicalPartitionIDs []*PhysicalPartitionID `json:"physicalPartitionIds,omitempty"`
}

// Role - The set of roles permitted through this Role Definition.
type Role struct {
	// The database name the role is applied.
	Db *string `json:"db,omitempty"`

	// The role name.
	Role *string `json:"role,omitempty"`
}

// SQLContainerCreateUpdateParameters - Parameters to create and update Cosmos DB container.
type SQLContainerCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB container.
	Properties *SQLContainerCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLContainerCreateUpdateProperties - Properties to create and update Azure Cosmos DB container.
type SQLContainerCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a container
	Resource *SQLContainerResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// SQLContainerGetProperties - The properties of an Azure Cosmos DB container
type SQLContainerGetProperties struct {
	Options  *SQLContainerGetPropertiesOptions  `json:"options,omitempty"`
	Resource *SQLContainerGetPropertiesResource `json:"resource,omitempty"`
}

type SQLContainerGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type SQLContainerGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB SQL container
	ID *string `json:"id,omitempty"`

	// Analytical TTL.
	AnalyticalStorageTTL *int64 `json:"analyticalStorageTtl,omitempty"`

	// The client encryption policy for the container.
	ClientEncryptionPolicy *ClientEncryptionPolicy `json:"clientEncryptionPolicy,omitempty"`

	// The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`

	// The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`

	// The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters `json:"restoreParameters,omitempty"`

	// The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos
	// DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// SQLContainerGetResults - An Azure Cosmos DB container.
type SQLContainerGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB container
	Properties *SQLContainerGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLContainerListResult - The List operation response, that contains the containers and their properties.
type SQLContainerListResult struct {
	// READ-ONLY; List of containers and their properties.
	Value []*SQLContainerGetResults `json:"value,omitempty" azure:"ro"`
}

// SQLContainerResource - Cosmos DB SQL container resource object
type SQLContainerResource struct {
	// REQUIRED; Name of the Cosmos DB SQL container
	ID *string `json:"id,omitempty"`

	// Analytical TTL.
	AnalyticalStorageTTL *int64 `json:"analyticalStorageTtl,omitempty"`

	// The client encryption policy for the container.
	ClientEncryptionPolicy *ClientEncryptionPolicy `json:"clientEncryptionPolicy,omitempty"`

	// The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`

	// The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`

	// The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters `json:"restoreParameters,omitempty"`

	// The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos
	// DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
}

// SQLDataTransferDataSourceSink - A CosmosDB Cassandra API data source/sink
type SQLDataTransferDataSourceSink struct {
	// REQUIRED
	Component *DataTransferComponent `json:"component,omitempty"`

	// REQUIRED
	ContainerName *string `json:"containerName,omitempty"`

	// REQUIRED
	DatabaseName *string `json:"databaseName,omitempty"`
}

// GetDataTransferDataSourceSink implements the DataTransferDataSourceSinkClassification interface for type SQLDataTransferDataSourceSink.
func (s *SQLDataTransferDataSourceSink) GetDataTransferDataSourceSink() *DataTransferDataSourceSink {
	return &DataTransferDataSourceSink{
		Component: s.Component,
	}
}

// SQLDatabaseCreateUpdateParameters - Parameters to create and update Cosmos DB SQL database.
type SQLDatabaseCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB SQL database.
	Properties *SQLDatabaseCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB SQL database.
type SQLDatabaseCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a SQL database
	Resource *SQLDatabaseResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// SQLDatabaseGetProperties - The properties of an Azure Cosmos DB SQL database
type SQLDatabaseGetProperties struct {
	Options  *SQLDatabaseGetPropertiesOptions  `json:"options,omitempty"`
	Resource *SQLDatabaseGetPropertiesResource `json:"resource,omitempty"`
}

type SQLDatabaseGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type SQLDatabaseGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB SQL database
	ID *string `json:"id,omitempty"`

	// A system generated property that specified the addressable path of the collections resource.
	Colls *string `json:"_colls,omitempty"`

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters `json:"restoreParameters,omitempty"`

	// A system generated property that specifies the addressable path of the users resource.
	Users *string `json:"_users,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// SQLDatabaseGetResults - An Azure Cosmos DB SQL database.
type SQLDatabaseGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB SQL database
	Properties *SQLDatabaseGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLDatabaseListResult - The List operation response, that contains the SQL databases and their properties.
type SQLDatabaseListResult struct {
	// READ-ONLY; List of SQL databases and their properties.
	Value []*SQLDatabaseGetResults `json:"value,omitempty" azure:"ro"`
}

// SQLDatabaseResource - Cosmos DB SQL database resource object
type SQLDatabaseResource struct {
	// REQUIRED; Name of the Cosmos DB SQL database
	ID *string `json:"id,omitempty"`

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters `json:"restoreParameters,omitempty"`
}

// SQLDedicatedGatewayRegionalServiceResource - Resource for a regional service location.
type SQLDedicatedGatewayRegionalServiceResource struct {
	// READ-ONLY; The location name.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The regional service name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The regional endpoint for SqlDedicatedGateway.
	SQLDedicatedGatewayEndpoint *string `json:"sqlDedicatedGatewayEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus `json:"status,omitempty" azure:"ro"`
}

// SQLDedicatedGatewayServiceResource - Describes the service response property for SqlDedicatedGateway.
type SQLDedicatedGatewayServiceResource struct {
	// Properties for SqlDedicatedGatewayServiceResource.
	Properties *SQLDedicatedGatewayServiceResourceProperties `json:"properties,omitempty"`
}

// SQLDedicatedGatewayServiceResourceProperties - Properties for SqlDedicatedGatewayServiceResource.
type SQLDedicatedGatewayServiceResourceProperties struct {
	// REQUIRED; ServiceType for the service.
	ServiceType *ServiceType `json:"serviceType,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Instance count for the service.
	InstanceCount *int32 `json:"instanceCount,omitempty"`

	// Instance type for the service.
	InstanceSize *ServiceSize `json:"instanceSize,omitempty"`

	// SqlDedicatedGateway endpoint for the service.
	SQLDedicatedGatewayEndpoint *string `json:"sqlDedicatedGatewayEndpoint,omitempty"`

	// READ-ONLY; Time of the last state change (ISO-8601 format).
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; An array that contains all of the locations for the service.
	Locations []*SQLDedicatedGatewayRegionalServiceResource `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus `json:"status,omitempty" azure:"ro"`
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type SQLDedicatedGatewayServiceResourceProperties.
func (s *SQLDedicatedGatewayServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return &ServiceResourceProperties{
		CreationTime:         s.CreationTime,
		InstanceSize:         s.InstanceSize,
		InstanceCount:        s.InstanceCount,
		ServiceType:          s.ServiceType,
		Status:               s.Status,
		AdditionalProperties: s.AdditionalProperties,
	}
}

// SQLResourcesClientBeginCreateUpdateClientEncryptionKeyOptions contains the optional parameters for the SQLResourcesClient.BeginCreateUpdateClientEncryptionKey
// method.
type SQLResourcesClientBeginCreateUpdateClientEncryptionKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginCreateUpdateSQLContainerOptions contains the optional parameters for the SQLResourcesClient.BeginCreateUpdateSQLContainer
// method.
type SQLResourcesClientBeginCreateUpdateSQLContainerOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginCreateUpdateSQLDatabaseOptions contains the optional parameters for the SQLResourcesClient.BeginCreateUpdateSQLDatabase
// method.
type SQLResourcesClientBeginCreateUpdateSQLDatabaseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginCreateUpdateSQLRoleAssignmentOptions contains the optional parameters for the SQLResourcesClient.BeginCreateUpdateSQLRoleAssignment
// method.
type SQLResourcesClientBeginCreateUpdateSQLRoleAssignmentOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginCreateUpdateSQLRoleDefinitionOptions contains the optional parameters for the SQLResourcesClient.BeginCreateUpdateSQLRoleDefinition
// method.
type SQLResourcesClientBeginCreateUpdateSQLRoleDefinitionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginCreateUpdateSQLStoredProcedureOptions contains the optional parameters for the SQLResourcesClient.BeginCreateUpdateSQLStoredProcedure
// method.
type SQLResourcesClientBeginCreateUpdateSQLStoredProcedureOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginCreateUpdateSQLTriggerOptions contains the optional parameters for the SQLResourcesClient.BeginCreateUpdateSQLTrigger
// method.
type SQLResourcesClientBeginCreateUpdateSQLTriggerOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginCreateUpdateSQLUserDefinedFunctionOptions contains the optional parameters for the SQLResourcesClient.BeginCreateUpdateSQLUserDefinedFunction
// method.
type SQLResourcesClientBeginCreateUpdateSQLUserDefinedFunctionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginDeleteSQLContainerOptions contains the optional parameters for the SQLResourcesClient.BeginDeleteSQLContainer
// method.
type SQLResourcesClientBeginDeleteSQLContainerOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginDeleteSQLDatabaseOptions contains the optional parameters for the SQLResourcesClient.BeginDeleteSQLDatabase
// method.
type SQLResourcesClientBeginDeleteSQLDatabaseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginDeleteSQLRoleAssignmentOptions contains the optional parameters for the SQLResourcesClient.BeginDeleteSQLRoleAssignment
// method.
type SQLResourcesClientBeginDeleteSQLRoleAssignmentOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginDeleteSQLRoleDefinitionOptions contains the optional parameters for the SQLResourcesClient.BeginDeleteSQLRoleDefinition
// method.
type SQLResourcesClientBeginDeleteSQLRoleDefinitionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginDeleteSQLStoredProcedureOptions contains the optional parameters for the SQLResourcesClient.BeginDeleteSQLStoredProcedure
// method.
type SQLResourcesClientBeginDeleteSQLStoredProcedureOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginDeleteSQLTriggerOptions contains the optional parameters for the SQLResourcesClient.BeginDeleteSQLTrigger
// method.
type SQLResourcesClientBeginDeleteSQLTriggerOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginDeleteSQLUserDefinedFunctionOptions contains the optional parameters for the SQLResourcesClient.BeginDeleteSQLUserDefinedFunction
// method.
type SQLResourcesClientBeginDeleteSQLUserDefinedFunctionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginListSQLContainerPartitionMergeOptions contains the optional parameters for the SQLResourcesClient.BeginListSQLContainerPartitionMerge
// method.
type SQLResourcesClientBeginListSQLContainerPartitionMergeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginMigrateSQLContainerToAutoscaleOptions contains the optional parameters for the SQLResourcesClient.BeginMigrateSQLContainerToAutoscale
// method.
type SQLResourcesClientBeginMigrateSQLContainerToAutoscaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginMigrateSQLContainerToManualThroughputOptions contains the optional parameters for the SQLResourcesClient.BeginMigrateSQLContainerToManualThroughput
// method.
type SQLResourcesClientBeginMigrateSQLContainerToManualThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginMigrateSQLDatabaseToAutoscaleOptions contains the optional parameters for the SQLResourcesClient.BeginMigrateSQLDatabaseToAutoscale
// method.
type SQLResourcesClientBeginMigrateSQLDatabaseToAutoscaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginMigrateSQLDatabaseToManualThroughputOptions contains the optional parameters for the SQLResourcesClient.BeginMigrateSQLDatabaseToManualThroughput
// method.
type SQLResourcesClientBeginMigrateSQLDatabaseToManualThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginRetrieveContinuousBackupInformationOptions contains the optional parameters for the SQLResourcesClient.BeginRetrieveContinuousBackupInformation
// method.
type SQLResourcesClientBeginRetrieveContinuousBackupInformationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginSQLContainerRedistributeThroughputOptions contains the optional parameters for the SQLResourcesClient.BeginSQLContainerRedistributeThroughput
// method.
type SQLResourcesClientBeginSQLContainerRedistributeThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginSQLContainerRetrieveThroughputDistributionOptions contains the optional parameters for the SQLResourcesClient.BeginSQLContainerRetrieveThroughputDistribution
// method.
type SQLResourcesClientBeginSQLContainerRetrieveThroughputDistributionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginSQLDatabaseRedistributeThroughputOptions contains the optional parameters for the SQLResourcesClient.BeginSQLDatabaseRedistributeThroughput
// method.
type SQLResourcesClientBeginSQLDatabaseRedistributeThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginSQLDatabaseRetrieveThroughputDistributionOptions contains the optional parameters for the SQLResourcesClient.BeginSQLDatabaseRetrieveThroughputDistribution
// method.
type SQLResourcesClientBeginSQLDatabaseRetrieveThroughputDistributionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginUpdateSQLContainerThroughputOptions contains the optional parameters for the SQLResourcesClient.BeginUpdateSQLContainerThroughput
// method.
type SQLResourcesClientBeginUpdateSQLContainerThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientBeginUpdateSQLDatabaseThroughputOptions contains the optional parameters for the SQLResourcesClient.BeginUpdateSQLDatabaseThroughput
// method.
type SQLResourcesClientBeginUpdateSQLDatabaseThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLResourcesClientGetClientEncryptionKeyOptions contains the optional parameters for the SQLResourcesClient.GetClientEncryptionKey
// method.
type SQLResourcesClientGetClientEncryptionKeyOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientGetSQLContainerOptions contains the optional parameters for the SQLResourcesClient.GetSQLContainer method.
type SQLResourcesClientGetSQLContainerOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientGetSQLContainerThroughputOptions contains the optional parameters for the SQLResourcesClient.GetSQLContainerThroughput
// method.
type SQLResourcesClientGetSQLContainerThroughputOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientGetSQLDatabaseOptions contains the optional parameters for the SQLResourcesClient.GetSQLDatabase method.
type SQLResourcesClientGetSQLDatabaseOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientGetSQLDatabaseThroughputOptions contains the optional parameters for the SQLResourcesClient.GetSQLDatabaseThroughput
// method.
type SQLResourcesClientGetSQLDatabaseThroughputOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientGetSQLRoleAssignmentOptions contains the optional parameters for the SQLResourcesClient.GetSQLRoleAssignment
// method.
type SQLResourcesClientGetSQLRoleAssignmentOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientGetSQLRoleDefinitionOptions contains the optional parameters for the SQLResourcesClient.GetSQLRoleDefinition
// method.
type SQLResourcesClientGetSQLRoleDefinitionOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientGetSQLStoredProcedureOptions contains the optional parameters for the SQLResourcesClient.GetSQLStoredProcedure
// method.
type SQLResourcesClientGetSQLStoredProcedureOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientGetSQLTriggerOptions contains the optional parameters for the SQLResourcesClient.GetSQLTrigger method.
type SQLResourcesClientGetSQLTriggerOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientGetSQLUserDefinedFunctionOptions contains the optional parameters for the SQLResourcesClient.GetSQLUserDefinedFunction
// method.
type SQLResourcesClientGetSQLUserDefinedFunctionOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientListClientEncryptionKeysOptions contains the optional parameters for the SQLResourcesClient.ListClientEncryptionKeys
// method.
type SQLResourcesClientListClientEncryptionKeysOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientListSQLContainersOptions contains the optional parameters for the SQLResourcesClient.ListSQLContainers
// method.
type SQLResourcesClientListSQLContainersOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientListSQLDatabasesOptions contains the optional parameters for the SQLResourcesClient.ListSQLDatabases
// method.
type SQLResourcesClientListSQLDatabasesOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientListSQLRoleAssignmentsOptions contains the optional parameters for the SQLResourcesClient.ListSQLRoleAssignments
// method.
type SQLResourcesClientListSQLRoleAssignmentsOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientListSQLRoleDefinitionsOptions contains the optional parameters for the SQLResourcesClient.ListSQLRoleDefinitions
// method.
type SQLResourcesClientListSQLRoleDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientListSQLStoredProceduresOptions contains the optional parameters for the SQLResourcesClient.ListSQLStoredProcedures
// method.
type SQLResourcesClientListSQLStoredProceduresOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientListSQLTriggersOptions contains the optional parameters for the SQLResourcesClient.ListSQLTriggers method.
type SQLResourcesClientListSQLTriggersOptions struct {
	// placeholder for future optional parameters
}

// SQLResourcesClientListSQLUserDefinedFunctionsOptions contains the optional parameters for the SQLResourcesClient.ListSQLUserDefinedFunctions
// method.
type SQLResourcesClientListSQLUserDefinedFunctionsOptions struct {
	// placeholder for future optional parameters
}

// SQLRoleAssignmentCreateUpdateParameters - Parameters to create and update an Azure Cosmos DB SQL Role Assignment.
type SQLRoleAssignmentCreateUpdateParameters struct {
	// Properties to create and update an Azure Cosmos DB SQL Role Assignment.
	Properties *SQLRoleAssignmentResource `json:"properties,omitempty"`
}

// SQLRoleAssignmentGetResults - An Azure Cosmos DB Role Assignment
type SQLRoleAssignmentGetResults struct {
	// Properties related to the Role Assignment.
	Properties *SQLRoleAssignmentResource `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLRoleAssignmentListResult - The relevant Role Assignments.
type SQLRoleAssignmentListResult struct {
	// READ-ONLY; List of Role Assignments and their properties
	Value []*SQLRoleAssignmentGetResults `json:"value,omitempty" azure:"ro"`
}

// SQLRoleAssignmentResource - Azure Cosmos DB SQL Role Assignment resource object.
type SQLRoleAssignmentResource struct {
	// The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role
	// Assignment. Tenant ID for the principal is inferred using the tenant
	// associated with the subscription.
	PrincipalID *string `json:"principalId,omitempty"`

	// The unique identifier for the associated Role Definition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`

	// The data plane resource path for which access is being granted through this Role Assignment.
	Scope *string `json:"scope,omitempty"`
}

// SQLRoleDefinitionCreateUpdateParameters - Parameters to create and update an Azure Cosmos DB SQL Role Definition.
type SQLRoleDefinitionCreateUpdateParameters struct {
	// Properties to create and update an Azure Cosmos DB SQL Role Definition.
	Properties *SQLRoleDefinitionResource `json:"properties,omitempty"`
}

// SQLRoleDefinitionGetResults - An Azure Cosmos DB SQL Role Definition.
type SQLRoleDefinitionGetResults struct {
	// Properties related to the Role Definition.
	Properties *SQLRoleDefinitionResource `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLRoleDefinitionListResult - The relevant Role Definitions.
type SQLRoleDefinitionListResult struct {
	// READ-ONLY; List of Role Definitions and their properties.
	Value []*SQLRoleDefinitionGetResults `json:"value,omitempty" azure:"ro"`
}

// SQLRoleDefinitionResource - Azure Cosmos DB SQL Role Definition resource object.
type SQLRoleDefinitionResource struct {
	// A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will
	// allow application of this Role Definition on the entire database account or any
	// underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable
	// as assignable Scopes. Note that resources referenced in assignable Scopes need
	// not exist.
	AssignableScopes []*string `json:"assignableScopes,omitempty"`

	// The set of operations allowed through this Role Definition.
	Permissions []*Permission `json:"permissions,omitempty"`

	// A user-friendly name for the Role Definition. Must be unique for the database account.
	RoleName *string `json:"roleName,omitempty"`

	// Indicates whether the Role Definition was built-in or user created.
	Type *RoleDefinitionType `json:"type,omitempty"`
}

// SQLStoredProcedureCreateUpdateParameters - Parameters to create and update Cosmos DB storedProcedure.
type SQLStoredProcedureCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB storedProcedure.
	Properties *SQLStoredProcedureCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLStoredProcedureCreateUpdateProperties - Properties to create and update Azure Cosmos DB storedProcedure.
type SQLStoredProcedureCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a storedProcedure
	Resource *SQLStoredProcedureResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// SQLStoredProcedureGetProperties - The properties of an Azure Cosmos DB StoredProcedure
type SQLStoredProcedureGetProperties struct {
	Resource *SQLStoredProcedureGetPropertiesResource `json:"resource,omitempty"`
}

type SQLStoredProcedureGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB SQL storedProcedure
	ID *string `json:"id,omitempty"`

	// Body of the Stored Procedure
	Body *string `json:"body,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// SQLStoredProcedureGetResults - An Azure Cosmos DB storedProcedure.
type SQLStoredProcedureGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB storedProcedure
	Properties *SQLStoredProcedureGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLStoredProcedureListResult - The List operation response, that contains the storedProcedures and their properties.
type SQLStoredProcedureListResult struct {
	// READ-ONLY; List of storedProcedures and their properties.
	Value []*SQLStoredProcedureGetResults `json:"value,omitempty" azure:"ro"`
}

// SQLStoredProcedureResource - Cosmos DB SQL storedProcedure resource object
type SQLStoredProcedureResource struct {
	// REQUIRED; Name of the Cosmos DB SQL storedProcedure
	ID *string `json:"id,omitempty"`

	// Body of the Stored Procedure
	Body *string `json:"body,omitempty"`
}

// SQLTriggerCreateUpdateParameters - Parameters to create and update Cosmos DB trigger.
type SQLTriggerCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB trigger.
	Properties *SQLTriggerCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLTriggerCreateUpdateProperties - Properties to create and update Azure Cosmos DB trigger.
type SQLTriggerCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a trigger
	Resource *SQLTriggerResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// SQLTriggerGetProperties - The properties of an Azure Cosmos DB trigger
type SQLTriggerGetProperties struct {
	Resource *SQLTriggerGetPropertiesResource `json:"resource,omitempty"`
}

type SQLTriggerGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB SQL trigger
	ID *string `json:"id,omitempty"`

	// Body of the Trigger
	Body *string `json:"body,omitempty"`

	// The operation the trigger is associated with
	TriggerOperation *TriggerOperation `json:"triggerOperation,omitempty"`

	// Type of the Trigger
	TriggerType *TriggerType `json:"triggerType,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// SQLTriggerGetResults - An Azure Cosmos DB trigger.
type SQLTriggerGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB trigger
	Properties *SQLTriggerGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLTriggerListResult - The List operation response, that contains the triggers and their properties.
type SQLTriggerListResult struct {
	// READ-ONLY; List of triggers and their properties.
	Value []*SQLTriggerGetResults `json:"value,omitempty" azure:"ro"`
}

// SQLTriggerResource - Cosmos DB SQL trigger resource object
type SQLTriggerResource struct {
	// REQUIRED; Name of the Cosmos DB SQL trigger
	ID *string `json:"id,omitempty"`

	// Body of the Trigger
	Body *string `json:"body,omitempty"`

	// The operation the trigger is associated with
	TriggerOperation *TriggerOperation `json:"triggerOperation,omitempty"`

	// Type of the Trigger
	TriggerType *TriggerType `json:"triggerType,omitempty"`
}

// SQLUserDefinedFunctionCreateUpdateParameters - Parameters to create and update Cosmos DB userDefinedFunction.
type SQLUserDefinedFunctionCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB userDefinedFunction.
	Properties *SQLUserDefinedFunctionCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLUserDefinedFunctionCreateUpdateProperties - Properties to create and update Azure Cosmos DB userDefinedFunction.
type SQLUserDefinedFunctionCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a userDefinedFunction
	Resource *SQLUserDefinedFunctionResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// SQLUserDefinedFunctionGetProperties - The properties of an Azure Cosmos DB userDefinedFunction
type SQLUserDefinedFunctionGetProperties struct {
	Resource *SQLUserDefinedFunctionGetPropertiesResource `json:"resource,omitempty"`
}

type SQLUserDefinedFunctionGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB SQL userDefinedFunction
	ID *string `json:"id,omitempty"`

	// Body of the User Defined Function
	Body *string `json:"body,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// SQLUserDefinedFunctionGetResults - An Azure Cosmos DB userDefinedFunction.
type SQLUserDefinedFunctionGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB userDefinedFunction
	Properties *SQLUserDefinedFunctionGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLUserDefinedFunctionListResult - The List operation response, that contains the userDefinedFunctions and their properties.
type SQLUserDefinedFunctionListResult struct {
	// READ-ONLY; List of userDefinedFunctions and their properties.
	Value []*SQLUserDefinedFunctionGetResults `json:"value,omitempty" azure:"ro"`
}

// SQLUserDefinedFunctionResource - Cosmos DB SQL userDefinedFunction resource object
type SQLUserDefinedFunctionResource struct {
	// REQUIRED; Name of the Cosmos DB SQL userDefinedFunction
	ID *string `json:"id,omitempty"`

	// Body of the User Defined Function
	Body *string `json:"body,omitempty"`
}

type SeedNode struct {
	// IP address of this seed node.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ServiceClientBeginCreateOptions contains the optional parameters for the ServiceClient.BeginCreate method.
type ServiceClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientBeginDeleteOptions contains the optional parameters for the ServiceClient.BeginDelete method.
type ServiceClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceClientGetOptions contains the optional parameters for the ServiceClient.Get method.
type ServiceClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientListOptions contains the optional parameters for the ServiceClient.List method.
type ServiceClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceResource - Properties for the database account.
type ServiceResource struct {
	// Services response resource.
	Properties ServiceResourcePropertiesClassification `json:"properties,omitempty"`

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceResourceCreateUpdateParameters - Parameters for Create or Update Request for ServiceResource
type ServiceResourceCreateUpdateParameters struct {
	// Properties in ServiceResourceCreateUpdateParameters.
	Properties *ServiceResourceCreateUpdateProperties `json:"properties,omitempty"`
}

// ServiceResourceCreateUpdateProperties - Properties in ServiceResourceCreateUpdateParameters.
type ServiceResourceCreateUpdateProperties struct {
	// Instance count for the service.
	InstanceCount *int32 `json:"instanceCount,omitempty"`

	// Instance type for the service.
	InstanceSize *ServiceSize `json:"instanceSize,omitempty"`

	// ServiceType for the service.
	ServiceType *ServiceType `json:"serviceType,omitempty"`
}

// ServiceResourceListResult - The List operation response, that contains the Service Resource and their properties.
type ServiceResourceListResult struct {
	// READ-ONLY; List of Service Resource and their properties.
	Value []*ServiceResource `json:"value,omitempty" azure:"ro"`
}

// ServiceResourcePropertiesClassification provides polymorphic access to related types.
// Call the interface's GetServiceResourceProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DataTransferServiceResourceProperties, *GraphAPIComputeServiceResourceProperties, *MaterializedViewsBuilderServiceResourceProperties,
// - *SQLDedicatedGatewayServiceResourceProperties, *ServiceResourceProperties
type ServiceResourcePropertiesClassification interface {
	// GetServiceResourceProperties returns the ServiceResourceProperties content of the underlying type.
	GetServiceResourceProperties() *ServiceResourceProperties
}

// ServiceResourceProperties - Services response resource.
type ServiceResourceProperties struct {
	// REQUIRED; ServiceType for the service.
	ServiceType *ServiceType `json:"serviceType,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Instance count for the service.
	InstanceCount *int32 `json:"instanceCount,omitempty"`

	// Instance type for the service.
	InstanceSize *ServiceSize `json:"instanceSize,omitempty"`

	// READ-ONLY; Time of the last state change (ISO-8601 format).
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus `json:"status,omitempty" azure:"ro"`
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type ServiceResourceProperties.
func (s *ServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return s
}

type SpatialSpec struct {
	// The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`

	// List of path's spatial type
	Types []*SpatialType `json:"types,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TableCreateUpdateParameters - Parameters to create and update Cosmos DB Table.
type TableCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Table.
	Properties *TableCreateUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TableCreateUpdateProperties - Properties to create and update Azure Cosmos DB Table.
type TableCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Table
	Resource *TableResource `json:"resource,omitempty"`

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions `json:"options,omitempty"`
}

// TableGetProperties - The properties of an Azure Cosmos Table
type TableGetProperties struct {
	Options  *TableGetPropertiesOptions  `json:"options,omitempty"`
	Resource *TableGetPropertiesResource `json:"resource,omitempty"`
}

type TableGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32 `json:"throughput,omitempty"`
}

type TableGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB table
	ID *string `json:"id,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// TableGetResults - An Azure Cosmos DB Table.
type TableGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB Table
	Properties *TableGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TableListResult - The List operation response, that contains the Table and their properties.
type TableListResult struct {
	// READ-ONLY; List of Table and their properties.
	Value []*TableGetResults `json:"value,omitempty" azure:"ro"`
}

// TableResource - Cosmos DB table resource object
type TableResource struct {
	// REQUIRED; Name of the Cosmos DB table
	ID *string `json:"id,omitempty"`
}

// TableResourcesClientBeginCreateUpdateTableOptions contains the optional parameters for the TableResourcesClient.BeginCreateUpdateTable
// method.
type TableResourcesClientBeginCreateUpdateTableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TableResourcesClientBeginDeleteTableOptions contains the optional parameters for the TableResourcesClient.BeginDeleteTable
// method.
type TableResourcesClientBeginDeleteTableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TableResourcesClientBeginMigrateTableToAutoscaleOptions contains the optional parameters for the TableResourcesClient.BeginMigrateTableToAutoscale
// method.
type TableResourcesClientBeginMigrateTableToAutoscaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TableResourcesClientBeginMigrateTableToManualThroughputOptions contains the optional parameters for the TableResourcesClient.BeginMigrateTableToManualThroughput
// method.
type TableResourcesClientBeginMigrateTableToManualThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TableResourcesClientBeginRetrieveContinuousBackupInformationOptions contains the optional parameters for the TableResourcesClient.BeginRetrieveContinuousBackupInformation
// method.
type TableResourcesClientBeginRetrieveContinuousBackupInformationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TableResourcesClientBeginUpdateTableThroughputOptions contains the optional parameters for the TableResourcesClient.BeginUpdateTableThroughput
// method.
type TableResourcesClientBeginUpdateTableThroughputOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TableResourcesClientGetTableOptions contains the optional parameters for the TableResourcesClient.GetTable method.
type TableResourcesClientGetTableOptions struct {
	// placeholder for future optional parameters
}

// TableResourcesClientGetTableThroughputOptions contains the optional parameters for the TableResourcesClient.GetTableThroughput
// method.
type TableResourcesClientGetTableThroughputOptions struct {
	// placeholder for future optional parameters
}

// TableResourcesClientListTablesOptions contains the optional parameters for the TableResourcesClient.ListTables method.
type TableResourcesClientListTablesOptions struct {
	// placeholder for future optional parameters
}

// ThroughputPolicyResource - Cosmos DB resource throughput policy
type ThroughputPolicyResource struct {
	// Represents the percentage by which throughput can increase every time throughput policy kicks in.
	IncrementPercent *int32 `json:"incrementPercent,omitempty"`

	// Determines whether the ThroughputPolicy is active or not
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// ThroughputSettingsGetProperties - The properties of an Azure Cosmos DB resource throughput
type ThroughputSettingsGetProperties struct {
	Resource *ThroughputSettingsGetPropertiesResource `json:"resource,omitempty"`
}

type ThroughputSettingsGetPropertiesResource struct {
	// Cosmos DB resource for autoscale settings. Either throughput is required or autoscaleSettings is required, but not both.
	AutoscaleSettings *AutoscaleSettingsResource `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput. Either throughput is required or autoscaleSettings is required, but not both.
	Throughput *int32 `json:"throughput,omitempty"`

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty" azure:"ro"`

	// READ-ONLY; The minimum throughput of the resource
	MinimumThroughput *string `json:"minimumThroughput,omitempty" azure:"ro"`

	// READ-ONLY; The throughput replace is pending
	OfferReplacePending *string `json:"offerReplacePending,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty" azure:"ro"`

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32 `json:"_ts,omitempty" azure:"ro"`
}

// ThroughputSettingsGetResults - An Azure Cosmos DB resource throughput.
type ThroughputSettingsGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// The properties of an Azure Cosmos DB resource throughput
	Properties *ThroughputSettingsGetProperties `json:"properties,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ThroughputSettingsResource - Cosmos DB resource throughput object. Either throughput is required or autoscaleSettings is
// required, but not both.
type ThroughputSettingsResource struct {
	// Cosmos DB resource for autoscale settings. Either throughput is required or autoscaleSettings is required, but not both.
	AutoscaleSettings *AutoscaleSettingsResource `json:"autoscaleSettings,omitempty"`

	// Value of the Cosmos DB resource throughput. Either throughput is required or autoscaleSettings is required, but not both.
	Throughput *int32 `json:"throughput,omitempty"`

	// READ-ONLY; The minimum throughput of the resource
	MinimumThroughput *string `json:"minimumThroughput,omitempty" azure:"ro"`

	// READ-ONLY; The throughput replace is pending
	OfferReplacePending *string `json:"offerReplacePending,omitempty" azure:"ro"`
}

// ThroughputSettingsUpdateParameters - Parameters to update Cosmos DB resource throughput.
type ThroughputSettingsUpdateParameters struct {
	// REQUIRED; Properties to update Azure Cosmos DB resource throughput.
	Properties *ThroughputSettingsUpdateProperties `json:"properties,omitempty"`

	// Identity for the resource.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The location of the resource group to which the resource belongs.
	Location *string `json:"location,omitempty"`

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ThroughputSettingsUpdateProperties - Properties to update Azure Cosmos DB resource throughput.
type ThroughputSettingsUpdateProperties struct {
	// REQUIRED; The standard JSON format of a resource throughput
	Resource *ThroughputSettingsResource `json:"resource,omitempty"`
}

// UniqueKey - The unique key on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB
// service.
type UniqueKey struct {
	// List of paths must be unique for each document in the Azure Cosmos DB service
	Paths []*string `json:"paths,omitempty"`
}

// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection
// in the Azure Cosmos DB service.
type UniqueKeyPolicy struct {
	// List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
	UniqueKeys []*UniqueKey `json:"uniqueKeys,omitempty"`
}

// Usage - The usage data for a usage request.
type Usage struct {
	// READ-ONLY; Current value for this metric
	CurrentValue *int64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Maximum value for this metric
	Limit *int64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the metric.
	Unit *UnitType `json:"unit,omitempty" azure:"ro"`
}

// UsagesResult - The response to a list usage request.
type UsagesResult struct {
	// READ-ONLY; The list of usages for the database. A usage is a point in time metric
	Value []*Usage `json:"value,omitempty" azure:"ro"`
}

// VirtualNetworkRule - Virtual Network ACL Rule object
type VirtualNetworkRule struct {
	// Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
	ID *string `json:"id,omitempty"`

	// Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVNetServiceEndpoint *bool `json:"ignoreMissingVNetServiceEndpoint,omitempty"`
}
