////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// zmoelnig@iem.at
//
// Implementation file
//
//    Copyright (c) 1997-1999 Mark Danks.
//    Copyright (c) Günther Geiger.
//    Copyright (c) 2001-2011 IOhannes m zmölnig. forum::für::umläute. IEM. zmoelnig@iem.at
//    For information on usage and redistribution, and for a DISCLAIMER OF ALL
//    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.
//
/////////////////////////////////////////////////////////

#include "render_trigger.h"

CPPEXTERN_NEW(render_trigger);

/////////////////////////////////////////////////////////
//
// render_trigger
//
/////////////////////////////////////////////////////////
// Constructor
//
/////////////////////////////////////////////////////////
render_trigger :: render_trigger()
{
  m_preOut = outlet_new(this->x_obj, 0);
  m_postOut = outlet_new(this->x_obj, 0);
}

/////////////////////////////////////////////////////////
// Destructor
//
/////////////////////////////////////////////////////////
render_trigger :: ~render_trigger()
{
  outlet_free(m_preOut);
  outlet_free(m_postOut);
}

/////////////////////////////////////////////////////////
// render
//
/////////////////////////////////////////////////////////
void render_trigger :: render(GemState *)
{
  outlet_bang(m_preOut);
}

/////////////////////////////////////////////////////////
// postrender
//
/////////////////////////////////////////////////////////
void render_trigger :: postrender(GemState *)
{
  outlet_bang(m_postOut);
}

/////////////////////////////////////////////////////////
// static member function
//
/////////////////////////////////////////////////////////
void render_trigger :: obj_setupCallback(t_class *)
{ }
