#ifndef WL_SHM_POOL_H_
#define WL_SHM_POOL_H_
#include <cstdint>
#include <wayland-client.h>
#include <wayland-util.h>
#include "fcitx-utils/misc.h"
namespace fcitx::wayland {

class WlBuffer;

class WlShmPool final {
public:
    static constexpr const char *interface = "wl_shm_pool";
    static constexpr const wl_interface *const wlInterface =
        &wl_shm_pool_interface;
    static constexpr const uint32_t version = 1;
    using wlType = wl_shm_pool;
    operator wl_shm_pool *() { return data_.get(); }
    WlShmPool(wlType *data);
    WlShmPool(WlShmPool &&other) noexcept = delete;
    WlShmPool &operator=(WlShmPool &&other) noexcept = delete;
    auto actualVersion() const { return version_; }
    void *userData() const { return userData_; }
    void setUserData(void *userData) { userData_ = userData; }
    WlBuffer *createBuffer(int32_t offset, int32_t width, int32_t height,
                           int32_t stride, uint32_t format);
    void resize(int32_t size);

private:
    static void destructor(wl_shm_pool *);

    uint32_t version_;
    void *userData_ = nullptr;
    UniqueCPtr<wl_shm_pool, &destructor> data_;
};
static inline wl_shm_pool *rawPointer(WlShmPool *p) {
    return p ? static_cast<wl_shm_pool *>(*p) : nullptr;
}

} // namespace fcitx::wayland

#endif // WL_SHM_POOL_H_
