# How to connect to JSON-RPC with curl

Before continuing make sure `deluge-web` or Web UI plugin is running.

## Create a curl configuration file

To save a lot of typing and to keep the curl command short we shall create
a `curl.cfg` files and put the following contents in it:

    request = "POST"
    compressed
    cookie = "cookie_deluge.txt"
    cookie-jar = "cookie_deluge.txt"
    header = "Content-Type: application/json"
    header = "Accept: application/json"
    url = "http://localhost:8112/json"
    write-out = "\n"

To pretty-print the JSON result see: <https://stackoverflow.com/q/352098/175584>

## Log in to Web UI

Log in to the Web UI and get session cookie:

    curl -d '{"method": "auth.login", "params": ["deluge"], "id": 1}' -K curl.cfg

Result is `true` to signify that login was successful:

    {
        "error": null,
        "id": 1,
        "result": true
    }

Check the contents of the cookie file to verify session ID created.

    cat cookie_deluge.txt
    # Netscape HTTP Cookie File
    # http://curl.haxx.se/docs/http-cookies.html
    # This file was generated by libcurl! Edit at your own risk.

    localhost	FALSE	/json	FALSE	1540061203	_session_id	<session_id>

## Check connected to deluged

Use the `web.connected` method to get a boolean response if the Web UI is
connected to a deluged host:

    curl -d '{"method": "web.connected", "params": [], "id": 1}' -K curl.cfg

Result is `false` because Web UI is not yet connected to the daemon:

    {
        "error": null,
        "id": 1,
        "result": false
    }

## Get list of deluged hosts

Use the `web.get_hosts` method:

    curl -d '{"method": "web.get_hosts", "params": [], "id": 1}' -K curl.cfg

The result contains the `<hostID>` for using in request `params` field.

    {
        "error": null,
        "id": 1,
        "result": [
            [
                "<hostID>",
                "127.0.0.1",
                58846,
                "localclient"
            ]
        ]
    }

## Get the deluged host status

    curl -d '{"method": "web.get_host_status", \
    "params": ["<hostID>"], "id": 1}' -K curl.cfg

The result shows the version and status; _online_, _offline_ or _connected_.

    {
        "error": null,
        "id": 1,
        "result": [
            "<hostID>",
            "Online",
            "2.0.0"
        ]
    }

## Connect to deluged host

To connect to deluged with `<hostID>`:

    curl -d '{"method": "web.connect", \
    "params": ["<hostID>"], "id": 1}' -K curl.cfg

The result contains the full list of available host methods:

    {
        "error": null,
        "id": 1,
        "result": [
            "core.add_torrent_url",
            ...
            "core.upload_plugin"
        ]
    }

## Disconnect from host

    curl -d '{"method": "web.disconnect", "params": [], "id": 1}' -K curl.cfg

A successful result:

    {
        "error": null,
        "id": 1,
        "result": "Connection was closed cleanly."
    }

## Add a torrent

    curl -d '{"method": "web.add_torrents", "params": \
    [[{"path":"/tmp/ubuntu-12.04.1-desktop-amd64.iso.torrent", \
    "options":null}]], "id": 1}' -K curl.cfg

## Add a magnet URI

    curl-d '{"method": "core.add_torrent_magnet", \
    "params": ["<magnet_uri>", {}], "id": 1}' -K curl.cfg

## Get list of files for a torrent

    curl -d '{"method": "web.get_torrent_files", \
    "params": ["<torrentid>"], "id": 1}' -K curl.cfg

## Set a core config option

    curl -d '{"method": "core.set_config", \
    "params":[{"max_upload_slots_global":"200"}], "id": 1}' -K curl.cfg

    {"error": null, "result": null, "id": 1}

## Useful curl configuration options

For full list of options see man page `man curl` or help `curl --help`:

    --cookie (-b) # Load cookie file with session id
    --cookie-jar (-c) # Save cookie file with session id
    --compressed # responses are gzipped
    --include (-i) # Include the HTTP header in output (optional)
    --header (-H) # HTTP header
    --request (-X) # custom request method
    --data (-d) # data to send in POST request '{"method": "", "params": [], "id": ""}'
    --insecure (-k) # use with self-signed certs https
