# TinyLog

Самый простой движок таблиц, который хранит данные на диске.
Каждый столбец хранится в отдельном сжатом файле.
При записи, данные дописываются в конец файлов.

Конкурентный доступ к данным никак не ограничивается:

-   если вы одновременно читаете из таблицы и в другом запросе пишете в неё, то чтение будет завершено с ошибкой;
-   если вы одновременно пишете в таблицу в нескольких запросах, то данные будут битыми.

Типичный способ использования этой таблицы - это write-once: сначала один раз только пишем данные, а потом сколько угодно читаем.
Запросы выполняются в один поток. То есть, этот движок предназначен для сравнительно маленьких таблиц (рекомендуется до 1 000 000 строк).
Этот движок таблиц имеет смысл использовать лишь в случае, если у вас есть много маленьких таблиц, так как он проще, чем движок Log (требуется открывать меньше файлов).
Случай, когда у вас много маленьких таблиц, является гарантированно плохим по производительности, но может уже использоваться при работе с другой СУБД, и вам может оказаться удобнее перейти на использование таблиц типа TinyLog.
**Индексы не поддерживаются.**

В Яндекс.Метрике таблицы типа TinyLog используются для промежуточных данных, обрабатываемых маленькими пачками.

[Оригинальная статья](https://clickhouse.yandex/docs/ru/operations/table_engines/tinylog/) <!--hide-->
