#ifndef ATL_stGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,240,320,480,560,720,880,960,1040,1600,1840,1920,2000,2080,2160,3200,4320,5360,5920,6160,6320,6400,6480,8640
 * N : 25,240,320,480,560,720,880,960,1040,1600,1840,1920,2000,2080,2160,3200,4320,5360,5920,6160,6320,6400,6480,8640
 * NB : 5,16,32,32,80,80,80,80,88,80,80,160,192,160,240,240,320,320,320,320,320,400,720,720
 */
#define ATL_stGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 132) (nb_) = 5; \
   else if ((n_) < 280) (nb_) = 16; \
   else if ((n_) < 520) (nb_) = 32; \
   else if ((n_) < 1000) (nb_) = 80; \
   else if ((n_) < 1320) (nb_) = 88; \
   else if ((n_) < 1880) (nb_) = 80; \
   else if ((n_) < 1960) (nb_) = 160; \
   else if ((n_) < 2040) (nb_) = 192; \
   else if ((n_) < 2120) (nb_) = 160; \
   else if ((n_) < 3760) (nb_) = 240; \
   else if ((n_) < 6360) (nb_) = 320; \
   else if ((n_) < 6440) (nb_) = 400; \
   else (nb_) = 720; \
}


#endif    /* end ifndef ATL_stGetNB_geqrf */
