/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.aspectj.internal.tools.ant.taskdefs.ConditionalTask;

public class AJPush
extends ConditionalTask {
    private File src;
    private String key;
    File releaseDir = null;
    File downloadDir = null;
    boolean waiting = false;

    public void setSrc(String v) {
        this.src = this.project.resolveFile(v);
    }

    public void setKey(String v) {
        this.key = v;
    }

    @Override
    public void execute() throws BuildException {
        this.releaseDir = this.project.resolveFile(this.project.getProperty("aj.release.dir"));
        this.downloadDir = this.project.resolveFile(this.project.getProperty("download.dir"));
        Mkdir mkdir = (Mkdir)this.project.createTask("mkdir");
        mkdir.setDir(this.releaseDir);
        mkdir.execute();
        mkdir = (Mkdir)this.project.createTask("mkdir");
        mkdir.setDir(this.downloadDir);
        mkdir.execute();
        this.log("Pushing from " + this.releaseDir + " to " + this.downloadDir);
        try {
            File releaseFile = new File(this.releaseDir, "release.txt");
            File downloadFile = new File(this.downloadDir, "release.txt");
            if (!releaseFile.canRead()) {
                releaseFile.createNewFile();
            }
            this.addReleaseInfo(this.src, releaseFile);
            this.project.copyFile(this.src, new File(this.downloadDir, this.src.getName()));
            this.project.copyFile(releaseFile, downloadFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void addReleaseInfo(File file, File propFile) throws IOException {
        Properties props = new Properties();
        if (propFile.canRead()) {
            props.load(new FileInputStream(propFile));
        }
        file.createNewFile();
        long bytes = file.length();
        DecimalFormat df = new DecimalFormat();
        df.setGroupingSize(3);
        String bytesString = df.format(bytes);
        props.put("release." + this.key + ".size.bytes", bytesString);
        props.put("release." + this.key + ".date", this.project.getProperty("build.date"));
        props.put("release." + this.key + ".filename", file.getName());
        props.put("release.date", this.project.getProperty("build.date"));
        props.put("release.version", this.project.getProperty("build.version.short"));
        props.put("release.versionName", this.project.getProperty("build.version.long"));
        String userName = System.getProperty("user.name");
        if (userName != null) {
            props.put("release." + this.key + ".username", userName);
        }
        props.store(new FileOutputStream(propFile), null);
    }
}

