// See bug #796. Fine if it compiles without errors

namespace icu_73 {
  namespace inner_ns {
    pointcut pct() = "icu_73::%";
  }
  class C1 {};
  class C2 {};
}

namespace icu = icu_73;
namespace icu2 = icu_73;
namespace icu = icu2;  // this redefinition is allowed

// namespace icu3 = icu::C1;  // is an error: "Alias target 'C1' is not a namespace"
// namespace icu = icu_73::inner_ns;  // is an error "conflicts with a previous declaration"

using namespace icu;
using namespace icu::inner_ns;

namespace {
  class C3 {};
}

namespace {
  class C4 {};
  pointcut pct2() = "icu_73::%";  // pointcut in unnamed namespace should be found!
}

// inline namespaces are also tricky for the phase 1 parser:
namespace mystd {
  inline namespace chrono {
    inline namespace chrono_literals {
      pointcut pct3() = "icu_73::%";  // pointcut in inline namespace should be found!
    }
  }
}

using namespace mystd::chrono_literals;  // is only found if 'inline' is not ignored!

// to reproduce bugs that we had in mysql-server
namespace pb { class SomeStuff; }
namespace google { namespace protobuf {} }

namespace xcl { namespace row_decoder {
  // all these declarations must lead to "Namespace alias 'pb' redeclared as different kind of entity"
  // class C {}; typedef C pb;
  // class pb {};
  // namespace pb {}

  // this leads to "Definition of namespace alias 'pb' conflicts with previous definition"
  // namespace pb = ::xcl;

  namespace pb = google::protobuf;
} }

namespace absl {
inline namespace lts_20230802 {
namespace time_internal {
namespace cctz {
}}}}

namespace cctz = absl::time_internal::cctz;
// up to here

aspect UseNsAlias {
  advice pct() : slice struct { int i; };
  advice pct2() : slice struct { int i2; };
  advice pct3() : slice struct { int i3; };
};

int main () {
  icu::C1 c1;
  c1.i = 42;
  icu::C2 c2;
  c2.i = 42;
  C3 c3;
}
