/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.vncviewer.PlatformPixelBuffer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class JavaPixelBuffer
extends PlatformPixelBuffer {
    public JavaPixelBuffer(int n, int n2) {
        super(JavaPixelBuffer.getPreferredPF(), n, n2, JavaPixelBuffer.getPreferredPF().getColorModel().createCompatibleWritableRaster(n, n2));
        ColorModel colorModel = this.format.getColorModel();
        this.image = new BufferedImage(colorModel, this.data, colorModel.isAlphaPremultiplied(), null);
        this.image.setAccelerationPriority(1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WritableRaster getBufferRW(Rect rect) {
        Image image = this.image;
        synchronized (image) {
            return ((BufferedImage)this.image).getSubimage(rect.tl.x, rect.tl.y, rect.width(), rect.height()).getRaster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster getBuffer(Rect rect) {
        Rectangle rectangle = new Rectangle(rect.tl.x, rect.tl.y, rect.width(), rect.height());
        Image image = this.image;
        synchronized (image) {
            return ((BufferedImage)this.image).getData(rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillRect(Rect rect, byte[] byArray) {
        ColorModel colorModel = this.format.getColorModel();
        int n = ByteBuffer.wrap(byArray).order(this.format.getByteOrder()).asIntBuffer().get(0);
        Color color = new Color(colorModel.getRGB(n));
        Image image = this.image;
        synchronized (image) {
            Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
            graphics2D.setColor(color);
            graphics2D.fillRect(rect.tl.x, rect.tl.y, rect.width(), rect.height());
            graphics2D.dispose();
        }
        this.commitBufferRW(rect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyRect(Rect rect, Point point) {
        Image image = this.image;
        synchronized (image) {
            Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
            graphics2D.copyArea(rect.tl.x - point.x, rect.tl.y - point.y, rect.width(), rect.height(), point.x, point.y);
            graphics2D.dispose();
        }
        this.commitBufferRW(rect);
    }

    private static PixelFormat getPreferredPF() {
        int n;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        ColorModel colorModel = graphicsConfiguration.getColorModel();
        int n2 = n = colorModel.getPixelSize() > 24 ? 24 : colorModel.getPixelSize();
        int n3 = n > 16 ? 32 : (n > 8 ? 16 : 8);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        boolean bl = byteOrder == ByteOrder.BIG_ENDIAN;
        boolean bl2 = true;
        int n4 = colorModel.getComponentSize()[0] + colorModel.getComponentSize()[1];
        int n5 = colorModel.getComponentSize()[0];
        int n6 = 0;
        int n7 = (int)Math.pow(2.0, colorModel.getComponentSize()[2]) - 1;
        int n8 = (int)Math.pow(2.0, colorModel.getComponentSize()[1]) - 1;
        int n9 = (int)Math.pow(2.0, colorModel.getComponentSize()[0]) - 1;
        return new PixelFormat(n3, n, bl, bl2, n7, n8, n9, n4, n5, n6);
    }
}

