'''OpenGL extension NV.fragment_shader_barycentric

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.fragment_shader_barycentric to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension advertises OpenGL support for the OpenGL Shading Language
	(GLSL) extension "NV_fragment_shader_barycentric", which provides fragment
	shader built-in variables holding barycentric weight vectors that identify
	the location of the fragment within its primitive.  Additionally, the GLSL
	extension allows fragment the ability to read raw attribute values for
	each of the vertices of the primitive that produced the fragment.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/fragment_shader_barycentric.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.fragment_shader_barycentric import *
from OpenGL.raw.GLES2.NV.fragment_shader_barycentric import _EXTENSION_NAME

def glInitFragmentShaderBarycentricNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION