/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.FPSCounter;
import org.jetbrains.skiko.FrameDispatcher;
import org.jetbrains.skiko.FrameLimiter;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.HardwareLayerKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MainUIDispatcher_awtKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.DirectSoftwareContextHandler;
import org.jetbrains.skiko.redrawer.AWTRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0014J\b\u0010!\u001a\u00020\u001dH\u0016J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0016J\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u0017H\u0016J\b\u0010*\u001a\u00020\u001dH\u0016J!\u0010\"\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0082 J\u0011\u0010&\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0017H\u0082 J\u0019\u0010(\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0017H\u0082 J\u0011\u0010-\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0017H\u0082 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lorg/jetbrains/skiko/redrawer/AbstractDirectSoftwareRedrawer;", "Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "contextHandler", "Lorg/jetbrains/skiko/context/DirectSoftwareContextHandler;", "renderInfo", "", "getRenderInfo", "()Ljava/lang/String;", "frameJob", "Lkotlinx/coroutines/CompletableJob;", "frameLimiter", "Lorg/jetbrains/skiko/FrameLimiter;", "frameDispatcher", "Lorg/jetbrains/skiko/FrameDispatcher;", "device", "", "getDevice", "()J", "setDevice", "(J)V", "needRender", "", "throttledToVsync", "", "draw", "renderImmediately", "resize", "width", "", "height", "acquireSurface", "Lorg/jetbrains/skia/Surface;", "finishFrame", "surface", "dispose", "devicePtr", "surfacePtr", "disposeDevice", "skiko"})
@SourceDebugExtension(value={"SMAP\nAbstractDirectSoftwareRedrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDirectSoftwareRedrawer.kt\norg/jetbrains/skiko/redrawer/AbstractDirectSoftwareRedrawer\n+ 2 AWTRedrawer.kt\norg/jetbrains/skiko/redrawer/AWTRedrawer\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SkiaLayer.awt.kt\norg/jetbrains/skiko/SkiaLayer\n+ 5 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,66:1\n58#2:67\n59#2,8:69\n67#2,6:96\n1#3:68\n611#4,10:77\n621#4,5:91\n168#5,4:87\n*S KotlinDebug\n*F\n+ 1 AbstractDirectSoftwareRedrawer.kt\norg/jetbrains/skiko/redrawer/AbstractDirectSoftwareRedrawer\n*L\n36#1:67\n36#1:69,8\n36#1:96,6\n36#1:68\n36#1:77,10\n36#1:91,5\n36#1:87,4\n*E\n"})
public abstract class AbstractDirectSoftwareRedrawer
extends AWTRedrawer {
    @NotNull
    private final SkiaLayer layer;
    @NotNull
    private final SkiaLayerProperties properties;
    @NotNull
    private final DirectSoftwareContextHandler contextHandler;
    @NotNull
    private final CompletableJob frameJob;
    @NotNull
    private final FrameLimiter frameLimiter;
    @NotNull
    private final FrameDispatcher frameDispatcher;
    private long device;

    public AbstractDirectSoftwareRedrawer(@NotNull SkiaLayer layer, @NotNull SkiaLayerAnalytics analytics, @NotNull SkiaLayerProperties properties) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(layer, analytics, GraphicsApi.SOFTWARE_FAST);
        this.layer = layer;
        this.properties = properties;
        this.contextHandler = new DirectSoftwareContextHandler(this.layer);
        this.frameJob = JobKt.Job$default(null, (int)1, null);
        this.frameLimiter = HardwareLayerKt.layerFrameLimiter$default(CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.frameJob)), this.layer.getBackedLayer$skiko(), null, 4, null);
        this.frameDispatcher = new FrameDispatcher((CoroutineContext)MainUIDispatcher_awtKt.getMainUIDispatcher(), (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AbstractDirectSoftwareRedrawer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (AbstractDirectSoftwareRedrawer.access$getProperties$p(this.this$0).isVsyncEnabled() && AbstractDirectSoftwareRedrawer.access$getProperties$p(this.this$0).isVsyncFramelimitFallbackEnabled()) {
                            this.label = 1;
                            v0 = AbstractDirectSoftwareRedrawer.access$getFrameLimiter$p(this.this$0).awaitNextFrame((Continuation<? super Unit>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        if (AbstractDirectSoftwareRedrawer.access$getLayer$p(this.this$0).isShowing()) {
                            Redrawer.DefaultImpls.update$default(this.this$0, 0L, 1, null);
                            this.this$0.draw();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @NotNull
    public String getRenderInfo() {
        return this.contextHandler.rendererInfo();
    }

    protected final long getDevice() {
        return this.device;
    }

    protected final void setDevice(long l) {
        this.device = l;
    }

    @Override
    public void needRender(boolean throttledToVsync) {
        this.frameDispatcher.scheduleFrame();
    }

    /*
     * WARNING - void declaration
     */
    protected void draw() {
        block16: {
            boolean isFirstFrame$iv;
            void this_$iv;
            block15: {
                AWTRedrawer aWTRedrawer = this;
                DirectSoftwareContextHandler directSoftwareContextHandler = this.contextHandler;
                boolean $i$f$inDrawScope = false;
                if (AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv) == null) {
                    boolean $i$a$-requireNotNull-AWTRedrawer$inDrawScope$1$iv22 = false;
                    String $i$a$-requireNotNull-AWTRedrawer$inDrawScope$1$iv22 = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                    throw new IllegalArgumentException($i$a$-requireNotNull-AWTRedrawer$inDrawScope$1$iv22.toString());
                }
                if (AWTRedrawer.access$isDisposed((AWTRedrawer)this_$iv)) break block16;
                isFirstFrame$iv = !AWTRedrawer.access$isFirstFrameRendered$p((AWTRedrawer)this_$iv);
                AWTRedrawer.access$setFirstFrameRendered$p((AWTRedrawer)this_$iv, true);
                if (isFirstFrame$iv) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer this_$iv$iv = AWTRedrawer.access$getLayer$p((AWTRedrawer)this_$iv);
                boolean $i$f$inDrawScope$skiko = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    boolean $i$a$-check-SkiaLayer$inDrawScope$1$iv$iv22 = false;
                    String $i$a$-check-SkiaLayer$inDrawScope$1$iv$iv22 = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException($i$a$-check-SkiaLayer$inDrawScope$1$iv$iv22.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(this_$iv$iv))) {
                    boolean $i$a$-check-SkiaLayer$inDrawScope$2$iv$iv22 = false;
                    String $i$a$-check-SkiaLayer$inDrawScope$2$iv$iv22 = "SkiaLayer is disposed";
                    throw new IllegalStateException($i$a$-check-SkiaLayer$inDrawScope$2$iv$iv22.toString());
                }
                try {
                    FPSCounter fPSCounter = SkiaLayer.access$getFpsCounter$p(this_$iv$iv);
                    if (fPSCounter != null) {
                        fPSCounter.tick();
                    }
                    boolean bl = false;
                    directSoftwareContextHandler.draw();
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException e$iv$iv) {
                    if (SkiaLayer.access$isDisposed$p(this_$iv$iv)) break block15;
                    Logger this_$iv$iv$iv = Logger.INSTANCE;
                    boolean $i$f$warn = false;
                    if (this_$iv$iv$iv.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable = e$iv$iv;
                        SkikoLoggerInterface skikoLoggerInterface = this_$iv$iv$iv.getLoggerImpl();
                        boolean bl = false;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(this_$iv$iv), false, 1, null);
                    Redrawer redrawer = this_$iv$iv.getRedrawer$skiko();
                    if (redrawer != null) {
                        redrawer.renderImmediately();
                    }
                }
            }
            if (isFirstFrame$iv && !AWTRedrawer.access$isDisposed((AWTRedrawer)this_$iv)) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p((AWTRedrawer)this_$iv);
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
        }
    }

    @Override
    public void renderImmediately() {
        Redrawer.DefaultImpls.update$default(this, 0L, 1, null);
        if (!this.isDisposed()) {
            this.draw();
        }
    }

    public void resize(int width, int height) {
        this.resize(this.device, width, height);
    }

    @NotNull
    public final Surface acquireSurface() {
        long surface = this.acquireSurface(this.device);
        if (surface == 0L) {
            throw new RenderException("Failed to create Surface", null, 2, null);
        }
        return new Surface(surface);
    }

    public void finishFrame(long surface) {
        this.finishFrame(this.device, surface);
    }

    @Override
    public void dispose() {
        Job.DefaultImpls.cancel$default((Job)((Job)this.frameJob), null, (int)1, null);
        this.frameDispatcher.cancel();
        this.contextHandler.dispose();
        this.disposeDevice(this.device);
        super.dispose();
    }

    private final native void resize(long var1, int var3, int var4);

    private final native long acquireSurface(long var1);

    private final native void finishFrame(long var1, long var3);

    private final native void disposeDevice(long var1);

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(AbstractDirectSoftwareRedrawer $this) {
        return $this.properties;
    }

    public static final /* synthetic */ FrameLimiter access$getFrameLimiter$p(AbstractDirectSoftwareRedrawer $this) {
        return $this.frameLimiter;
    }

    public static final /* synthetic */ SkiaLayer access$getLayer$p(AbstractDirectSoftwareRedrawer $this) {
        return $this.layer;
    }
}

